/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	wpa.c

	Abstract:

	Revision History:
	Who         When            What
	--------    ----------      ----------------------------------------------
	Jan Lee     03-07-22        Initial
*/
#include "rt_config.h"

#define SECURE_BIT      0x02
#define ERROR_BIT           0x04
#define REQUEST_BIT     0x08
#define MIC_BIT                 0x01

#define KEY_TYPE_BIT    0x08
#define PAIRWISEKEY     1
#define GROUPKEY            0

#define GEN_KEYINFO0(mic,secure,err,req) (((mic) ? 0x0001 : 0x0000)|((secure) ? 0x0002 : 0x0000)|((err) ? 0x0004 : 0x0000)|((req) ? 0x0008 : 0x0000) )

#define GEN_KEYINFO1(ver,type,idx,install,ack) ((ver)|(type<<3)|(idx<<4)|((install)?0x0040:0x0000)|((ack)?0x0080:0x0000))

static UCHAR   EAPOL[]={0x88, 0x8e};

//////////////////////////////////////////////////////////////////////////
//
BOOLEAN WPAMsgTypeSubst(
		IN UCHAR    EAPType,
		OUT ULONG *MsgType) 
{
	switch(EAPType)
	{
		case EAPPacket:
			*MsgType = MACHINE_TYPE_EAPPacket;
			DBGPRINT(RT_DEBUG_TTL, "  WPAMsgTypeSubst: MACHINE_TYPE_EAPPacket\n");
			break;
		case EAPOLStart:
			*MsgType = MACHINE_TYPE_EAPOLStart;
			DBGPRINT(RT_DEBUG_TTL, "  WPAMsgTypeSubst: MACHINE_TYPE_EAPOLStart\n");
			break;
		case EAPOLLogoff:
			*MsgType = MACHINE_TYPE_EAPOLLogoff;
			DBGPRINT(RT_DEBUG_TTL, "  WPAMsgTypeSubst: MACHINE_TYPE_EAPOLLogoff\n");
			break;
		case EAPOLKey:
			*MsgType = MACHINE_TYPE_EAPOLKey;
			DBGPRINT(RT_DEBUG_TTL, "  WPAMsgTypeSubst  : MACHINE_TYPE_EAPOLKey\n");
			break;
		case EAPOLASFAlert:
			*MsgType = MACHINE_TYPE_EAPOLASFAlert;
			DBGPRINT(RT_DEBUG_TTL, "  WPAMsgTypeSubst  : MACHINE_TYPE_EAPOLASFAlert\n");    
			break;
		default:
			DBGPRINT(RT_DEBUG_TTL, "  WPAMsgTypeSubst  :    return FALSE; \n");    
			return FALSE;
	}
	
	return TRUE;
}//end of WPAMsgTypeSubst()

/*  
	==========================================================================
	Description: 
		association state machine init, including state transition and timer init
	Parameters: 
		S - pointer to the association state machine
	==========================================================================
 */
VOID WpaStateMachineInit(
	IN  PRTMP_ADAPTER   pAd, 
	IN  STATE_MACHINE *S, 
	OUT STATE_MACHINE_FUNC Trans[]) 
{
//    NDIS_STATUS Status = NDIS_STATUS_SUCCESS;

	StateMachineInit(S, (STATE_MACHINE_FUNC*)Trans, MAX_WPA_PTK_STATE, MAX_WPA_MSG, (STATE_MACHINE_FUNC)Drop, WPA_PTK, WPA_MACHINE_BASE);

	StateMachineSetAction(S, WPA_PTK, MACHINE_TYPE_EAPPacket, (STATE_MACHINE_FUNC)WpaEAPPacketAction);
	StateMachineSetAction(S, WPA_PTK, MACHINE_TYPE_EAPOLStart, (STATE_MACHINE_FUNC)WpaEAPOLStartAction);
	StateMachineSetAction(S, WPA_PTK, MACHINE_TYPE_EAPOLLogoff, (STATE_MACHINE_FUNC)WpaEAPOLLogoffAction);
	StateMachineSetAction(S, WPA_PTK, MACHINE_TYPE_EAPOLKey, (STATE_MACHINE_FUNC)WpaEAPOLKeyAction);
	StateMachineSetAction(S, WPA_PTK, MACHINE_TYPE_EAPOLASFAlert, (STATE_MACHINE_FUNC)WpaEAPOLASFAlertAction);

}//end of WpaStateMachineInit()

/*
	==========================================================================
	Description:
		Port Access Control Inquiry function. Return entry's Privacy and Wpastate.
		Also check if AP needs to initilize 4-way handshake. 
	Return:
		pEntry 
	==========================================================================
*/
MAC_TABLE_ENTRY *PACInquiry(
	IN      PRTMP_ADAPTER       pAd, 
	IN      MACADDR                *pAddr, 
	OUT     NDIS_802_11_PRIVACY_FILTER   *Privacy,
	OUT     WPA_STATE      *WpaState)
{
	MAC_TABLE_ENTRY *pEntry = (MAC_TABLE_ENTRY*)NULL;
	
//	DBGPRINT(RT_DEBUG_TTL, "PACInquiry-->\n");

	*Privacy = Ndis802_11PrivFilterAcceptAll;
	*WpaState = AS_NOTUSE;
	
	if (MAC_ADDR_IS_GROUP(*pAddr)) // mcast & broadcast address
	{
//        *Privacy = Ndis802_11PrivFilterAcceptAll;
//        *WpaState = AS_NOTUSE;
	} 
	else // unicast address
	{
		pEntry = MacTableLookup(pAd, pAddr);
		if (pEntry) 
		{
			*Privacy = pEntry->PrivacyFilter;
			*WpaState = pEntry->WpaState;
			if((*WpaState == AS_INITPSK) || (*WpaState == AS_INITPMK))
			{
				WPAStart4WayHS(pAd, pEntry);
			}
		} 
	}
	return pEntry;
}//end of PACInquiry()

/*
	==========================================================================
	Description:
	   
	Return:
		 TRUE if this is EAP frame
		 FALSE otherwise
	==========================================================================
*/
BOOLEAN RTMPCheckWPAframe(
	IN PRTMP_ADAPTER pAdapter,
	IN PUCHAR pHeader,
	IN ULONG DataByteCount)
{
	UCHAR   SNAP_802_1H[6] = {0xaa, 0xaa, 0x03, 0x00, 0x00, 0x00};
	UCHAR   EAPOL[2] = {0x88, 0x8e};
	PUCHAR  pData;

	DBGPRINT(RT_DEBUG_TTL, "   RTMPCheckWPAframe  ======>> \n");
		
	if(DataByteCount < (LENGTH_802_11+LENGTH_802_1_H +LENGTH_EAPOL_H))
		return FALSE;

	pData = pHeader+LENGTH_802_11;
	DataByteCount -= LENGTH_802_11;
	if (RTMPEqualMemory(SNAP_802_1H, pData, 6)) 
	{
		pData += 6;
	}
	if (RTMPEqualMemory(EAPOL, pData, 2)) 
	{
		pData += 2;         
	}
	else    
		return FALSE;

	switch (*(pData+1))     
	{   
		case EAPPacket:
			DBGPRINT(RT_DEBUG_TRACE, "   Receive EAP-Packet frame, TYPE = 0 \n");
			break;
		case EAPOLStart:
			DBGPRINT(RT_DEBUG_TRACE, "   Receive EAPOL-Start frame, TYPE = 1   \n");
			break;
		case EAPOLLogoff:
			DBGPRINT(RT_DEBUG_TRACE, "   Receive EAPOLLogoff frame,  TYPE = 2  \n");
			break;
		case EAPOLKey:
			DBGPRINT(RT_DEBUG_TRACE, "  Receive EAPOL-Key frame,  TYPE = 3  , Length =%x\n", *(pData+2));
			break;
		case EAPOLASFAlert:
			DBGPRINT(RT_DEBUG_TRACE, "  Receive EAPOLASFAlert frame,  TYPE = 4 \n");
			break;
		default:
			return FALSE;
	
	}   
	return TRUE;
}//end of RTMPCheckWPAframe()

/*
	==========================================================================
	Description:
	   Check invalidity of multicast cipher selection in RSN IE.
	Return:
		 TRUE if match
		 FALSE otherwise
	==========================================================================
*/
BOOLEAN RTMPCheckMcast(
	IN PRTMP_ADAPTER pAdapter,
	PEID_STRUCT  eid_ptr)
{
	if (eid_ptr->Len >= 10)
	{   
		if (!RTMPEqualMemory(&eid_ptr->Octet[6], &pAdapter->PortCfg.RSN_IE[6], 4))
			return FALSE;
	}
	else
		return FALSE;

	return TRUE;
}//end of RTMPCheckMcast()

/*
	==========================================================================
	Description:
	   Check invalidity of unicast cipher selection in RSN IE.
	Return:
		 TRUE if match
		 FALSE otherwise
	==========================================================================
*/
BOOLEAN RTMPCheckUcast(
	IN PRTMP_ADAPTER pAdapter,
	PEID_STRUCT  eid_ptr)
{
	INT i,j;
	
	DBGPRINT(RT_DEBUG_TRACE, " RTMPCheckUcast  ==  >  ucast number = %d\n",eid_ptr->Octet[10]);
	if (eid_ptr->Len >= 16)
	{   
		for (i = 0; i < (INT)eid_ptr->Octet[10]; i++)
		{
			for (j = 0; j < (INT)pAdapter->PortCfg.RSN_IE[10]; j++)
			{
				DBGPRINT(RT_DEBUG_TTL, "  %x %x %x %x \n",
										eid_ptr->Octet[12 + i*4],
										eid_ptr->Octet[13 + i*4],
										eid_ptr->Octet[14 + i*4],
										eid_ptr->Octet[15 + i*4]);
				if (!RTMPEqualMemory(&eid_ptr->Octet[12 + i*4], 
										&pAdapter->PortCfg.RSN_IE[12 + j*4], 4))
					return FALSE;
				else
					break;
			}
		}    
	}
	else
		return FALSE;

	return TRUE;
	
}//end of RTMPCheckUcast()

/*
	==========================================================================
	Description:
	   Check invalidity of authentication method selection in RSN IE.
	Return:
		 TRUE if match
		 FALSE otherwise
	==========================================================================
*/
BOOLEAN RTMPCheckAUTH(
	IN PRTMP_ADAPTER pAdapter,
	PEID_STRUCT  eid_ptr)
{
	UCHAR i;
	UCHAR PSK[4]={0x00, 0x50, 0xf2, 0x02};
	
	DBGPRINT(RT_DEBUG_TTL, " RTMPCheckAUTH  ==  > RSN_IE Len = %d \n",eid_ptr->Len);
	if (eid_ptr->Len >= 22)
	{   
		for (i = eid_ptr->Len; i >= 22; i--)
		{
			if (RTMPEqualMemory(&eid_ptr->Octet[i-4], &pAdapter->PortCfg.RSN_IE[18], 4)) //`N
				return TRUE;
		}
	}
	else
		return FALSE;

	return FALSE;

}//end of RTMPCheckAUTH()

/*
	==========================================================================
	Description:
		this is state machine function. 
		When receiving EAP packets which is  for 802.1x authentication use. 
		Not use in PSK case
	Return:
	==========================================================================
*/
VOID WpaEAPPacketAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem) 
{   
	DBGPRINT(RT_DEBUG_TTL, "   WpaEAPPAckettion ===>>\n");


}//end of WpaEAPPacketAction()

//////////////////////////////////////////////////////////////////////////
//
VOID WpaEAPOLStartAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem) 
{   
		DBGPRINT(RT_DEBUG_TRACE, "   WpaEAPOLStartAction ====>>> \n");            

}//end of WpaEAPOLStartAction()


//////////////////////////////////////////////////////////////////////////
//
VOID WpaEAPOLLogoffAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem) 
{   
	DBGPRINT( RT_DEBUG_TTL, "WpaEAPLogoffAction ==>>> \n" );
	
}//end of WpaEAPOLLogoffAction()

/*
	==========================================================================
	Description:
		Function to handel countermeasures active attack.  Init 60-sec timer if necessary.
	Return:
	==========================================================================
*/
VOID HandleCounterMeasure(
		IN PRTMP_ADAPTER pAd, 
		IN MAC_TABLE_ENTRY  *pEntry) 
{
	INT         i;
//    UCHAR       *pData;
	
	DBGPRINT(RT_DEBUG_TTL, "HandleCounterMeasure-->\n");

	pAd->PortCfg.MICFailureCounter++;
	// record which entry causes this MIC error, if this entry sends disauth/disassoc, AP doesn't need to log the CM
	pEntry->CMTimerRunning = TRUE;
	if (pAd->PortCfg.CMTimerRunning == TRUE)
	{
		DBGPRINT(DEBUG_TEMP, "   Receive CM Attack Twice  Within 60 seconds  ====>>> \n");            
		// renew GTK
		GenRandom(pAd, pAd->PortCfg.GNonce);
		ApLogEvent(pAd, &pEntry->Addr, EVENT_COUNTER_M);
		del_timer_sync(&pAd->PortCfg.CounterMeasureTimer);
		for (i = 0; i < MAX_LEN_OF_MAC_TABLE; i++)
		{
			// happened twice within 60 sec,  AP SENDS disaccociate all associated STAs.  All STA's transition to State 2
			if (pAd->MacTab.Content[i].Valid == TRUE)
			{
				DisAssocAction(pAd, &pAd->MacTab.Content[i], SUBTYPE_DISASSOC, REASON_MIC_FAILURE);
			}
		}
		// Further,  ban all Class 3 DATA transportation for  a period 0f 60 sec
		// disallow new association , too
		pAd->PortCfg.BANClass3Data = TRUE;        

		// check how many entry left...  should be zero
		pAd->PortCfg.GKeyDoneStations = pAd->MacTab.Size;
		DBGPRINT(RT_DEBUG_TRACE, "  pAd->PortCfg.GKeyDoneStations= %d====>>> \n",pAd->PortCfg.GKeyDoneStations);
	}

	pAd->PortCfg.CounterMeasureTimer.expires = jiffies + 60*MLME_TASK_EXEC_INTV;
	add_timer(&pAd->PortCfg.CounterMeasureTimer);
	pAd->PortCfg.CMTimerRunning = TRUE;
	pAd->PortCfg.PrevaMICFailTime = pAd->PortCfg.aMICFailTime;
	pAd->PortCfg.aMICFailTime = jiffies;

}//end of HandleCounterMeasure()

/*
	==========================================================================
	Description:
		This is state machine function. 
		When receiving EAPOL packets which is  for 802.1x key management. 
		Use both in WPA, and WPAPSK case. 
		In this function, further dispatch to different functions according to the received packet.  3 categories are : 
		  1.  normal 4-way pairwisekey and 2-way groupkey handshake
		  2.  MIC error (Countermeasures attack)  report packet from STA.
		  3.  Request for pairwise/group key update from STA
	Return:
	==========================================================================
*/
VOID WpaEAPOLKeyAction(
	IN PRTMP_ADAPTER pAdapter, 
	IN MLME_QUEUE_ELEM *Elem) 
{
	INT                         i;
	UCHAR                    KEYINFO;
//    BOOLEAN                 Cancelled;
//    KEY_DESCRIPTER  *Key_des;
	MAC_TABLE_ENTRY *pEntry;
	PHEADER_802_11  pHeader;
	KEY_DESCRIPTER      *pKeyDesc;
  
	pHeader = (PHEADER_802_11)Elem->pMsg;
    DBGPRINT(RT_DEBUG_TTL/*INFO*/, "   WpaEAPOLKeyAction  =====>>> \n");
	pKeyDesc = (PKEY_DESCRIPTER)&Elem->pMsg[(LENGTH_802_11+LENGTH_802_1_H+LENGTH_EAPOL_H)];

	do
	{
		if (pAdapter->PortCfg.AuthMode < Ndis802_11AuthModeWPA)
			break;

		if ((Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H] != EAPOL_VER) || (pKeyDesc->Type != RSN_KEY_DESC))
		{
			DBGPRINT(RT_DEBUG_ERROR, "  Key descripter does not match with WPA rule \n");
			break;
		}

		if ((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled) && ((pKeyDesc->Keyinfo[1]&0x07) != DESC_TYPE_AES))
		{
			DBGPRINT(RT_DEBUG_ERROR, "  Key descripter version does not match current AP's wepstatus \n");
			break;
		}
		else if ((pAdapter->PortCfg.WepStatus != Ndis802_11Encryption3Enabled) && ((pKeyDesc->Keyinfo[1]&0x07)  != DESC_TYPE_OTHER))
		{
			DBGPRINT(RT_DEBUG_ERROR, "  Key descripter version not support \n");
			break;
		}

		pEntry = MacTableLookup(pAdapter, &pHeader->Controlhead.Addr2);
		KEYINFO = pKeyDesc->Keyinfo[0];
		if ((pEntry) && (pEntry->Sst == SST_ASSOC) && (pEntry->WpaState >= AS_INITPSK))
		{
			DBGPRINT( RT_DEBUG_TTL, "pEntry-> SST_ASSOC, AS_INITPSK \n");
			if ((KEYINFO&MIC_BIT) && (KEYINFO&ERROR_BIT) && (KEYINFO&REQUEST_BIT) ) 
			{
				// Category 2. 
				DBGPRINT(DEBUG_TEMP, " MIC, ERROR, REQUEST ALL 1'S  , ACTIVE COUNTERMEASURE \n");
				DBGPRINT(DEBUG_TEMP, " %x %x %x %x %x %x %x %x ",Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H],Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H+2],Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H+3],pKeyDesc->Type,pKeyDesc->Keyinfo[0],pKeyDesc->Keyinfo[1],pKeyDesc->KeyLength[0],pKeyDesc->KeyLength[1]);
				DBGPRINT(DEBUG_TEMP, "\n");
				HandleCounterMeasure(pAdapter, pEntry);
			}
			else if ((KEYINFO&SECURE_BIT) && !(KEYINFO&REQUEST_BIT) && !(KEYINFO&ERROR_BIT))
			{
				// SECURE=1, REQUEST=0 ,  ERROR= 0
				// Category 1
				PeerGroupMsg2Action(pAdapter, pEntry, &Elem->pMsg[LENGTH_802_11], (Elem->MsgLen-LENGTH_802_11));
			}
			else if (!(KEYINFO&ERROR_BIT) && !(KEYINFO&REQUEST_BIT) && !(KEYINFO&SECURE_BIT))
			{   
				// general 4-way handshake step // SECURE=0, REQUEST=0 ,  ERROR= 0
				// Category 1
				if (pEntry->WpaState == AS_PTKSTART)
					PeerPairMsg2Action(pAdapter, pEntry, Elem); //tt_lin(important)
				else if (pEntry->WpaState == AS_PTKINIT_NEGOTIATING)
					PeerPairMsg4Action(pAdapter, pEntry, Elem); //tt_lin(important)
			}
			else if (!(KEYINFO&ERROR_BIT) && (KEYINFO&REQUEST_BIT))
			{
				// Category 3
				// Need to check   KEY TYPE   for groupkey or pairwise key update  ,   refer to  8021i  P.114, 
				if ((Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H+2] & KEY_TYPE_BIT) == GROUPKEY)
				{
					DBGPRINT(RT_DEBUG_TRACE, "   REQUEST=1 ,  ERROR= 0 , UPDATE Group Key\n");
					GenRandom(pAdapter, pAdapter->PortCfg.GNonce);
					pAdapter->PortCfg.WpaGTKState = SETKEYS;
					pAdapter->PortCfg.GKeyDoneStations = pAdapter->MacTab.Size;
					for (i = 0; i < MAX_LEN_OF_MAC_TABLE; i++)
					{
						if ((pAdapter->MacTab.Content[i].Valid == TRUE) && (pAdapter->MacTab.Content[i].WpaState == AS_PTKINITDONE))
						{
							pAdapter->MacTab.Content[i].GTKState = REKRY_NEGOTIATING;
							WPAHardTransmit(pAdapter, &pAdapter->MacTab.Content[i]);
						}
					}
				}
				else
				{
					DBGPRINT(RT_DEBUG_TRACE, "   REQUEST=1,  ERROR= 0, UPDATE Pairwise Key\n");
					pEntry->PairwiseKey[0].KeyLen = 0;
					pEntry->Sst = SST_ASSOC;
					if (pAdapter->PortCfg.AuthMode == Ndis802_11AuthModeWPA)
						pEntry->WpaState = AS_INITPMK;  
					else if (pAdapter->PortCfg.AuthMode == Ndis802_11AuthModeWPAPSK)
						pEntry->WpaState = AS_INITPSK;  
					pEntry->GTKState = REKRY_NEGOTIATING;
					if (pEntry->RetryTimerRunning == FALSE )
					{               // retry up to 3 times at interval 1 second
						DBGPRINT(RT_DEBUG_TRACE, "  init_timer  :    add_timer  Timer   ====>>>   \n");
						pEntry->RetryTimerRunning = TRUE;
						WPAStart4WayHS(pAdapter, pEntry);
						init_timer(&pEntry->RetryTimer);
						pEntry->RetryTimer.expires = jiffies + WPA_RETRY_EXEC_INTV;
						pEntry->RetryTimer.data = (unsigned long)pAdapter;
						pEntry->RetryTimer.function = &WPARetryExec;
						add_timer(&pEntry->RetryTimer);			
						pEntry->ReTryCounter = PAIR_HS_RETRY_TIMER_CTR;
					}
				}
			}
			else
			{
				//
			}
		}
	}while(FALSE);
}

/*
	==========================================================================
	Description:
		This is a function to initilize 4way handshake
	Return:
		 
	==========================================================================
*/
VOID WPAStart4WayHS(
		IN PRTMP_ADAPTER pAdapter, 
		IN MAC_TABLE_ENTRY *pEntry) 
{
	UINT                        i;
	UCHAR           FrameGap;
//    UCHAR           EAPHEAD[12] = {0xaa, 0xaa, 0x03, 0x00, 0x00, 0x00,0x88,0x8e, EAPOL_VER, EAPOLKey, 0x00,0x5f};
	UCHAR           EAPHEAD[4] = {EAPOL_VER, EAPOLKey, 0x00,0x5f};
	ULONG           FrameLen = 0;
	UCHAR           *OutBuffer = NULL;
	UCHAR           INFO[2], KEYLEN[2], KEY_DESC=RSN_KEY_DESC;
	UCHAR           zeroarray[32];
	PUCHAR          pDest;  
//    HEADER_802_11   Header_802_11/*, *pHeader*/;
	UCHAR           Header802_3[14];
	PTXD_STRUC      pTxD;
	TXD_STRUC		TxD;//tt_lin_big
//    NDIS_STATUS             NStatus;

	DBGPRINT(DEBUG_TEMP, "   WPAStart4WayHS ==> CurEncryptIndex= %d \n", pAdapter->CurEncryptIndex);
	
//	FrameGap = IFS_BACKOFF;     // Default frame gap mode
	NdisZeroMemory(zeroarray, sizeof(zeroarray));

	do
	{       
		if ((pEntry->WpaState > AS_PTKSTART) || (pEntry->WpaState < AS_INITPMK))
		{
			DBGPRINT(RT_DEBUG_ERROR, " Not expect calling  WPAStart4WayHS here ");
			break;
		}
		WPAMake8023Hdr(pAdapter, pEntry->Addr.Octet, Header802_3);

		OutBuffer = kmalloc(MAX_LEN_OF_EAP_HS, GFP_KERNEL);
		if(OutBuffer == NULL)
		{
			return;
		}
		// Increment  replay counter by 1 
		i = LEN_KEY_DESC_REPLAY;
		do
		{
				i--;
				pAdapter->PortCfg.R_Counter[i]++;
				if (i == 0)
				{
					break;
				}
		}
		while (pAdapter->PortCfg.R_Counter[i] == 0);
		NdisMoveMemory(pEntry->R_Counter, pAdapter->PortCfg.R_Counter, sizeof(pEntry->R_Counter));            
		INFO[0] = GEN_KEYINFO0(0,0,0,0);
		INFO[1] = GEN_KEYINFO1(DESC_TYPE_OTHER,PAIRWISEKEY,0,0,1);                    
		KEYLEN[0] = 0;
		KEYLEN[1] = LEN_TKIP_KEY;
		if (pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled)
		{
			KEYLEN[1] = 16;
			INFO[1] = GEN_KEYINFO1(DESC_TYPE_AES,PAIRWISEKEY,0,0,1);                    
		}
		GenRandom(pAdapter, pEntry->ANonce);  
				
		MakeOutgoingFrame(OutBuffer,            &FrameLen,
							sizeof(Header802_3),           Header802_3,
							sizeof(EAPHEAD),               EAPHEAD,
							1,                    &KEY_DESC,
							2,                    INFO, //don't need change to big-endian
							2,                    KEYLEN, // don't need change to big-endian
							sizeof(pEntry->R_Counter), pEntry->R_Counter, 
							LEN_KEY_DESC_NONCE,          pEntry->ANonce, //(????)
							LEN_KEY_DESC_IV,            zeroarray,
							LEN_KEY_DESC_RSC,       zeroarray,
							LEN_KEY_DESC_ID,            zeroarray,
							LEN_KEY_DESC_MIC,                zeroarray,
							2,                                  zeroarray,
							END_OF_ARGS);

		RTMPToWirelessSta(pAdapter, OutBuffer, FrameLen);
		pEntry->WpaState = AS_PTKSTART;
		// Make sure to release Tx ring resource
		kfree(OutBuffer);
	}while(FALSE);
	
	DBGPRINT(RT_DEBUG_TRACE, "   WPAStart4WayHS ==> pEntry->WpaState= %d , FrameLen= %d\n",pEntry->WpaState,FrameLen);
}//end of WPAStart4WayHS()

/*
	==========================================================================
	Description:
		When receiving the second packet of 4-way pairwisekey handshake.
	Return:
	==========================================================================
*/
VOID PeerPairMsg2Action(
	IN PRTMP_ADAPTER pAdapter, 
	IN MAC_TABLE_ENTRY  *pEntry,
	IN MLME_QUEUE_ELEM *Elem) 
{   
	UINT                        i;
	UCHAR                   PTK[80],mac[LEN_KEY_DESC_MIC],SNonce[LEN_KEY_DESC_NONCE];
//    UCHAR                   FrameGap;
//    UCHAR                   EAPHEAD[8] = {0xaa, 0xaa, 0x03, 0x00, 0x00, 0x00,0x88,0x8e};
	UCHAR                   EAPOLHEAD[4] = {EAPOL_VER,  EAPOLKey,  0x00,  0x77};
	ULONG                   FrameLen = 0;
	UCHAR                   *OutBuffer = NULL;
	UCHAR                   INFO[2], KEYLEN[2], DATALEN[2], KEY_DESC = RSN_KEY_DESC, Data[MAX_LEN_OF_RSNIE];
	UCHAR                   zeroarray[32];
//    PUCHAR                 pDest,pSA/*,pLook*/;    
	USHORT                MICMsgLen,MICOffset;
	PTXD_STRUC           pTxD;
	TXD_STRUC				TxD; //tt_lin_big
//    HEADER_802_11       Header_802_11;//NOTICE: Little-Endian
	PHEADER_802_11      pHeader;
//    NDIS_STATUS           NStatus;
	PUCHAR                  pSA;
	KEY_DESCRIPTER      *pKeyDesc;

	UCHAR                   Header802_3[LENGTH_802_3];
	   
	pHeader = (PHEADER_802_11)Elem->pMsg;
	DBGPRINT(RT_DEBUG_TTL/*INFO*/, "   PeerPairMsg2Action   ====>>>   \n");
//    FrameGap = IFS_BACKOFF;     // Default frame gap mode
		
	NdisZeroMemory(zeroarray, sizeof(zeroarray));
	
	do
	{
		if (Elem->MsgLen < (LENGTH_802_11 + LENGTH_802_1_H +LENGTH_EAPOL_H +sizeof(KEY_DESCRIPTER) -MAX_LEN_OF_RSNIE -2))
			break;

		// check Entry in valid State
		if (pEntry->WpaState < AS_PTKSTART)
			break;
	
		OutBuffer = kmalloc(MAX_LEN_OF_EAP_HS, GFP_KERNEL);
		if(OutBuffer == NULL)
			break;
		
		// Save Data Length to pDesc for receiving packet,   then put in outgoing frame Data Len fields.
		pKeyDesc = (PKEY_DESCRIPTER)&Elem->pMsg[(LENGTH_802_11+LENGTH_802_1_H+LENGTH_EAPOL_H)];       

		// 802.1i, p.99 - 100 ,  on Receive MSG2 
		//  1. check Replay Counter coresponds to MSG1.,  otherwise discard
		if (!RTMPEqualMemory(pKeyDesc->RCounter, pEntry->R_Counter, LEN_KEY_DESC_REPLAY))
		{
			DBGPRINT(RT_DEBUG_ERROR, " Replay Counter  Different  in msg 2 of 4-way handshake!!!!!!!!!! \n");
			DBGPRINT(RT_DEBUG_TRACE, " Receive :  %d   %d  %d   %d  \n", pKeyDesc->RCounter[0],pKeyDesc->RCounter[1],pKeyDesc->RCounter[2],pKeyDesc->RCounter[3]);
			DBGPRINT(RT_DEBUG_TRACE, " Current :  %d   %d  %d   %d  \n", pEntry->R_Counter[4],pEntry->R_Counter[5],pEntry->R_Counter[6],pEntry->R_Counter[7]);
			break;
		}

		//  2. Derive PTK, 
		MICMsgLen=(Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H+3]) | (Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H+2]<<8); 
				
		EAPOLHEAD[3] = (UCHAR)MICMsgLen;
		MICMsgLen += LENGTH_EAPOL_H;
		NdisMoveMemory(SNonce, pKeyDesc->Nonce, LEN_KEY_DESC_NONCE);
//        pSA = (PUCHAR)&pHeader->Controlhead.Addr2;
		pSA = pEntry->Addr.Octet;
		CountPTK(pAdapter->PortCfg.PMK,  
				 pEntry->ANonce, 
				 pAdapter->CurrentAddress, 
				 SNonce, 
				 pSA,  
				 PTK,//output 
				 LEN_PTK); 
		
		NdisMoveMemory(pEntry->PTK, PTK, LEN_PTK);
		//  3. verify MSG2 MIC, If not valid, discard.
		MICOffset = LENGTH_EAPOL_H+sizeof(KEY_DESCRIPTER)-MAX_LEN_OF_RSNIE-2-LEN_KEY_DESC_MIC;
		NdisMoveMemory(OutBuffer, &Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H], MICMsgLen);  
		NdisZeroMemory((OutBuffer+MICOffset), LEN_KEY_DESC_MIC);
		if (pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled)
		{	
			DBGPRINT(RT_DEBUG_TTL,"hmac_md5-MICMsgLen=%d\n", MICMsgLen);
			hmac_md5(PTK, LEN_EAP_MICK, OutBuffer, MICMsgLen, mac);
		}
		else
		{
			UCHAR digest[80];
			DBGPRINT(RT_DEBUG_TTL,"HMAC_SHA1\n");
			HMAC_SHA1(OutBuffer,  MICMsgLen, PTK, LEN_EAP_MICK, digest);
			NdisMoveMemory(mac, digest, LEN_KEY_DESC_MIC);
		}

		if (!RTMPEqualMemory(&Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H+MICOffset], mac, LEN_KEY_DESC_MIC))
		{
			DBGPRINT(RT_DEBUG_ERROR, "     MIC  Different  in msg 2 of 4-way handshake!!!!!!!!!! \n");
			DBGPRINT(RT_DEBUG_ERROR, "  Receive :  %02x %02x  \n",
										Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H+MICOffset], 
										//Elem->pMsg[LENGTH_EAPOL_H+LENGTH_802_11+LENGTH_802_1_H+MICOffset+1]);
										Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H+MICOffset+1]);
			DBGPRINT(RT_DEBUG_ERROR, "  Current :  %02x %02x \n", mac[0], mac[1] );
			break;
		}
		else
		{
			DBGPRINT(RT_DEBUG_ERROR, "     MIC  VALID  in msg 2 of 4-way handshake!!!!!!!!!! \n");;
		}
		//  4. check RSN IE, if not match, send MLME-DEAUTHENTICATE.
		// Points  pDesc  to RSN_IE in Datafield.
		if (!RTMPEqualMemory(&pKeyDesc->Data[2], pEntry->RSN_IE, pEntry->RSNIE_Len))
		{       
			DBGPRINT(RT_DEBUG_ERROR, "  RSN_IE  Different  in msg 2 of 4-way handshake!!!!!!!!!! \n");
			pEntry->Flag |= DIS_REASON_RSNIE_DIFF;            
			DBGPRINT(RT_DEBUG_TRACE, "  Receive :  %x %x %x %x ",pKeyDesc->Data[2], pKeyDesc->Data[3],pKeyDesc->Data[4],pKeyDesc->Data[5] );
			DBGPRINT(RT_DEBUG_TRACE, "  Current :  %x %x %x %x ",pEntry->RSN_IE[0], pEntry->RSN_IE[1],pEntry->RSN_IE[2],pEntry->RSN_IE[3] );
			break;  
		}
		else
		{    
			DBGPRINT(RT_DEBUG_ERROR, "     RSN_IE   VALID  in msg 2 of 4-way handshake!!!!!!!!!! \n");;
		}
		//verified  ok , change state
		if (pEntry->RetryTimerRunning == TRUE)
		{
			DBGPRINT(RT_DEBUG_TRACE, "  Verified ok,  Cancel Retry Timer ! \n");
			del_timer_sync(&pEntry->RetryTimer);
			pEntry->RetryTimerRunning = FALSE;              
		}
		pEntry->WpaState = AS_PTKINIT_NEGOTIATING;

		// 5. CONSTRUCT msg3
		// Increment  replay counter by 1       
		i = LEN_KEY_DESC_REPLAY;
		do
		{           
			i--;
			pAdapter->PortCfg.R_Counter[i]++;
			pEntry->R_Counter[i]++;
			if (i == 0)
			{
				break;
			}
		}
		while(pAdapter->PortCfg.R_Counter[i] == 0);
		NdisMoveMemory(pEntry->R_Counter, pAdapter->PortCfg.R_Counter, sizeof(pEntry->R_Counter));

		// Fill in every field 
		INFO[0] = GEN_KEYINFO0(1,0,0,0);
		INFO[1] = GEN_KEYINFO1(DESC_TYPE_OTHER,PAIRWISEKEY,0,1,1);
		KEYLEN[0] = 0;
		KEYLEN[1] = LEN_TKIP_KEY;
		if (pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled)
		{
			DBGPRINT(DEBUG_TEMP," PortCfg.WepStatus == Ndis802_11Encryption3Enabled (AES)\n");
			KEYLEN[1] = LEN_AES_KEY;
			INFO[1] = GEN_KEYINFO1(DESC_TYPE_AES,PAIRWISEKEY,0,1,1);
		}        
			
		DATALEN[0] = 0;
		DATALEN[1] = (pEntry->RSNIE_Len+2);
		Data[0] = IE_WPA_RSN_IE;
		Data[1] = pEntry->RSNIE_Len;
		NdisMoveMemory(&Data[2], pEntry->RSN_IE, pEntry->RSNIE_Len);
        
		DebugPrint("pEntry->RSN_IE-2", Data, pEntry->RSNIE_Len+2 );
				
		// First make a frame  for Countint MIC,
		MakeOutgoingFrame(OutBuffer,            &FrameLen,
				sizeof(EAPOLHEAD),              EAPOLHEAD,
				1,                              &KEY_DESC,
				2,                              INFO, //
				2,                              KEYLEN, //
				sizeof(pEntry->R_Counter),      pEntry->R_Counter, 
				LEN_KEY_DESC_NONCE,             pEntry->ANonce,
				LEN_KEY_DESC_IV,                zeroarray,
				LEN_KEY_DESC_RSC,               zeroarray,
				LEN_KEY_DESC_ID,                zeroarray,
				LEN_KEY_DESC_MIC,				zeroarray,
				2,                              DATALEN,
				(UINT)DATALEN[1],               Data,
				END_OF_ARGS);

		NdisZeroMemory(mac, sizeof(mac));
		// count MIC
		if (pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled)
		{
			UCHAR digest[80];

			DBGPRINT(RT_DEBUG_TTL, "HMAC_SHA1\n");
			HMAC_SHA1(OutBuffer,  FrameLen, PTK, LEN_EAP_MICK, digest);
			NdisMoveMemory(mac, digest, LEN_KEY_DESC_MIC);
		}
		else
		{
			DBGPRINT(RT_DEBUG_TTL,"hmac_md5\n");
			hmac_md5(PTK,  LEN_EAP_MICK, OutBuffer, FrameLen, mac);
		}

		FrameLen = 0;
		// Make  Transmitting frame
		WPAMake8023Hdr(pAdapter, pEntry->Addr.Octet, Header802_3);//v1.2.0
		MakeOutgoingFrame(OutBuffer,            &FrameLen,
				LENGTH_802_3,                      Header802_3,
				sizeof(EAPOLHEAD),              EAPOLHEAD,
				1,                              &KEY_DESC,
				2,                              INFO,
				2,                              KEYLEN,
				sizeof(pEntry->R_Counter),      pEntry->R_Counter, 
				LEN_KEY_DESC_NONCE,             pEntry->ANonce,
				LEN_KEY_DESC_IV,                zeroarray,
				LEN_KEY_DESC_RSC,               zeroarray,
				LEN_KEY_DESC_ID,                zeroarray,
				LEN_KEY_DESC_MIC,                    mac,
				2,                              DATALEN,
				(UINT)DATALEN[1],               Data,
				END_OF_ARGS);
		DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "  RTMPToWirelessSta : ETHTYPE = %x %x FrameLen = %d! \n",Header802_3[12],Header802_3[13],FrameLen);
		RTMPToWirelessSta(pAdapter, OutBuffer, FrameLen);
		pEntry->WpaState = AS_PTKINIT_NEGOTIATING;
		pEntry->Flag &= (~DISASSOC_4_WAY_TMOUT);
	}while(FALSE);  

	kfree(OutBuffer);

DBGPRINT(RT_DEBUG_TTL/*INFO*/, "   PeerPairMsg2Action   <<<====   \n");
}//end of PeerPairMsg2Action()

/*
	==========================================================================
	Description:
		countermeasures active attack timer execution
	Return:
	==========================================================================
*/
VOID CMTimerExec(
	IN	unsigned long data) 
{
	UINT                i,j=0;
	RTMP_ADAPTER *pAdapter = (RTMP_ADAPTER *)data;
	
	DBGPRINT( RT_DEBUG_TTL, "CMTimerExec-->\n" );

	pAdapter->PortCfg.BANClass3Data = FALSE;
	for (i = 0; i < MAX_LEN_OF_MAC_TABLE; i++)
	{
		if ((pAdapter->MacTab.Content[i].Valid == TRUE) && (pAdapter->MacTab.Content[i].CMTimerRunning == TRUE))
		{
			pAdapter->MacTab.Content[i].CMTimerRunning =FALSE;
			j++;
		}
	}
	
	if (j > 1)
		DBGPRINT(RT_DEBUG_ERROR, "   Find more than one entry which generated MIC Fail ..  \n");

	pAdapter->PortCfg.CMTimerRunning = FALSE;

}//end of CMTimerExec()

//////////////////////////////////////////////////////////////////////////
//    

VOID WPARetryExec(
	IN	unsigned long data) 
{
	UINT                i;
	MACADDR         addr;
	RTMP_ADAPTER *pAdapter = (RTMP_ADAPTER *)data;
	MAC_TABLE_ENTRY *pEntry;
	
	DBGPRINT(RT_DEBUG_TTL, "WPARetryExec-->\n");

	//retry up to 3 times, then send disassoc /deauth 
	DBGPRINT(RT_DEBUG_TTL/*INFO*/, "   EAPOLRetry Send   Timer  Execuatation ====>>>   \n");
	
	for (i = 0; i < MAX_LEN_OF_MAC_TABLE; i++)
	{
		if ((pAdapter->MacTab.Content[i].Valid == TRUE) && (pAdapter->MacTab.Content[i].RetryTimerRunning == TRUE))
		{
			BOOLEAN			bTimer = TRUE;
			
			pEntry = &pAdapter->MacTab.Content[i];
			pEntry->ReTryCounter++;
			DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "    Send  Timer   ReTryCounter= %d  WpaState=%d \n", pEntry->ReTryCounter,pEntry->WpaState);
			NdisMoveMemory(&addr, &pAdapter->MacTab.Content[i].Addr, MAC_ADDR_LEN);

			switch (pAdapter->PortCfg.AuthMode)
			{
				case Ndis802_11AuthModeWPA:
					DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "     CANCEL RETRY TIMER  \n");
					bTimer = FALSE;
					pEntry->RetryTimerRunning=FALSE;                
					break;

				case Ndis802_11AuthModeWPAPSK:
					//  1.   Cancel  Timer  if necessary
					if (pEntry->ReTryCounter > (GRP_HS_RETRY_TIMER_CTR+1))
					{    
						bTimer = FALSE;
						pEntry->RetryTimerRunning = FALSE;  
						if (pEntry->GTKState == REKRY_NEGOTIATING)          
							pEntry->Flag |= DISASSOC_GRP_UDATE_TMOUT ;
						DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "  del_timer_sync    :  ====>>>pEntry->ReTryCounter %d   \n",pEntry->ReTryCounter);
					}
					else if (pEntry->ReTryCounter > GRP_HS_RETRY_TIMER_CTR)
					{
						;
					}
					else if (pEntry->ReTryCounter > (PAIR_HS_RETRY_TIMER_CTR+2))                
					{   // if(pAdapter->MacTab.Content[i].WpaState==AS_INITPSK   || pAdapter->MacTab.Content[i].WpaState==AS_INITPMK )  
						bTimer = FALSE;
						pEntry->RetryTimerRunning = FALSE;  
						DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "  CANCEL RETRY TIMER  ,pEntry->ReTryCounter = %d\n",pEntry->ReTryCounter);
						ApLogEvent(pAdapter, &pEntry->Addr, EVENT_INVALID_PSK);
						pEntry->Flag |= DISASSOC_4_WAY_TMOUT;
					}

					//  2.   Invoke retry Transmition 
					if (((pEntry->WpaState == AS_PTKSTART) || (pEntry->WpaState == AS_INITPSK) || (pEntry->WpaState == AS_INITPMK))	&& (pEntry->ReTryCounter < GRP_HS_RETRY_TIMER_CTR))
					{
						DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "   transmit  Start 4-way Handshake in Timer ====>>>   \n");
						WPAStart4WayHS(pAdapter, pEntry);
					}
					else if ((pEntry->ReTryCounter >= GRP_HS_RETRY_TIMER_CTR) && (pEntry->GTKState == REKRY_NEGOTIATING) )
					{
						DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "  ReInitilize 2-way group-key Handshake in TimerExecution  ====>>>   \n");
						WPAHardTransmit( pAdapter,  pEntry);
					}
					break;

				default:
					break;
			}
		
			if(bTimer)
			{
				pEntry->RetryTimer.expires = jiffies + WPA_RETRY_EXEC_INTV;
				if(pEntry->RetryTimer.function != NULL) add_timer(&pEntry->RetryTimer);
			}
		}
	}
}

/*
	==========================================================================
	Description:
		When receiving the last packet of 4-way pairwisekey handshake.
		Initilize 2-way groupkey handshake following.
	Return:
	==========================================================================
*/
VOID PeerPairMsg4Action(
	IN PRTMP_ADAPTER pAdapter, 
	IN MAC_TABLE_ENTRY *pEntry,
	IN MLME_QUEUE_ELEM *Elem) 
{
//    UINT                        i;
//    UINT                        Len;
	UCHAR				mac[LEN_KEY_DESC_MIC];
	UCHAR					FrameGap;
	ULONG				MICMsgLen;
//    PUCHAR                   pDest,pSA,pLook;    
//    PWPA_KEY               pWpaKey;
//    HEADER_802_11       Header_802_11;
	PHEADER_802_11     pHeader;
	KEY_DESCRIPTER     *pKeyDesc;
	EAPOL_PACKET        EAPOLPKT;
//    PTXD_STRUC           pTxD;

	FrameGap = IFS_BACKOFF;     // Default frame gap mode
	DBGPRINT(DEBUG_TEMP, "   WpaEAPOL Peer PAIR  Msg4 Action ====>>   \n");
	NdisZeroMemory((PUCHAR)&EAPOLPKT, sizeof(EAPOL_PACKET));

	do
	{
		if (Elem->MsgLen < (LENGTH_802_11 + LENGTH_802_1_H +LENGTH_EAPOL_H +sizeof(KEY_DESCRIPTER) -MAX_LEN_OF_RSNIE -2 ) )
			break;
		if (pEntry->WpaState < AS_PTKINIT_NEGOTIATING)
			break;

		pKeyDesc = (PKEY_DESCRIPTER)&Elem->pMsg[(LENGTH_802_11+LENGTH_802_1_H+LENGTH_EAPOL_H)];
		pHeader = (PHEADER_802_11)Elem->pMsg;

		// 1.check Replay Counter
		if (!RTMPEqualMemory(pKeyDesc->RCounter, pEntry->R_Counter, LEN_KEY_DESC_REPLAY))
		{
			DBGPRINT(RT_DEBUG_ERROR, "   Replay Counter  Different  in msg 4 of 4-way handshake!!!!!!!!!! \n");
			DBGPRINT(RT_DEBUG_TRACE, " Receive : %d   %d  %d   %d  \n", pKeyDesc->RCounter[0],pKeyDesc->RCounter[1],pKeyDesc->RCounter[2],pKeyDesc->RCounter[3]);
			DBGPRINT(RT_DEBUG_TRACE, " Current :  %d   %d  %d   %d  \n", pEntry->R_Counter[4],pEntry->R_Counter[5],pEntry->R_Counter[6],pEntry->R_Counter[7]);
		}

		// 2. check MIC, if not valid, discard silently
		MICMsgLen = (Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H+3]) | (Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H+2]<<8);   
		DBGPRINT(RT_DEBUG_TTL, "MICMsgLen = %d\n", MICMsgLen);
		MICMsgLen += LENGTH_EAPOL_H;

		NdisMoveMemory((PUCHAR)&EAPOLPKT, &Elem->pMsg[LENGTH_802_11+LENGTH_802_1_H], MICMsgLen);  
		NdisZeroMemory(EAPOLPKT.KeyDesc.MIC, sizeof(EAPOLPKT.KeyDesc.MIC));

		hmac_md5(pEntry->PTK, LEN_EAP_MICK, (PUCHAR)&EAPOLPKT, (MICMsgLen), mac);
		if (pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled)
		{
			hmac_md5(pEntry->PTK, LEN_EAP_MICK, (PUCHAR)&EAPOLPKT, (MICMsgLen), mac);
		}
		else
		{
			UCHAR digest[80];
			HMAC_SHA1((PUCHAR)&EAPOLPKT,  MICMsgLen, pEntry->PTK, LEN_EAP_MICK, digest);
			NdisMoveMemory(mac, digest, LEN_KEY_DESC_MIC);
		}
		if (!RTMPEqualMemory(pKeyDesc->MIC, mac, LEN_KEY_DESC_MIC))
		{
			DBGPRINT(RT_DEBUG_ERROR, "     MAC  Different  in msg 4 of 4-way handshake!!!!!!!!!! \n");
			break;
		}
		else
			DBGPRINT(DEBUG_TEMP, "     MAC  Valid   in msg 4 of 4-way handshake!!!!!!!!!! \n");;

		// 3. uses the MLME.SETKEYS.request to configure PTK into MAC
		NdisZeroMemory(&pEntry->PairwiseKey[0], sizeof(WPA_KEY));   
		NdisMoveMemory(pEntry->PairwiseKey[0].RxTsc, EAPOLPKT.KeyDesc.RSC, 6);

		pEntry->PairwiseKey[0].KeyLen = LEN_TKIP_EK;
		NdisMoveMemory(pEntry->PairwiseKey[0].Key, &pEntry->PTK[32], LEN_TKIP_EK);
		NdisMoveMemory(pEntry->PairwiseKey[0].RxMic, &pEntry->PTK[TKIP_AP_RXMICK_OFFSET], LEN_TKIP_RXMICK);
		NdisMoveMemory(pEntry->PairwiseKey[0].TxMic, &pEntry->PTK[TKIP_AP_TXMICK_OFFSET], LEN_TKIP_TXMICK);
		
		// 4. upgrade state
		pEntry->PrivacyFilter = Ndis802_11PrivFilterAcceptAll;
		pEntry->WpaState = AS_PTKINITDONE;
		pAdapter->PortCfg.PortSecured = WPA_802_1X_PORT_SECURED;
		pEntry->PortSecured = WPA_802_1X_PORT_SECURED;
		// 5. init Group 2-way handshake if necessary.
		WPAHardTransmit(pAdapter, pEntry);

		if (pEntry->RetryTimerRunning == FALSE)
		{
			DBGPRINT(RT_DEBUG_TRACE, "  init_timer  :    add_timer  Timer   ====>>>   \n");
			pEntry->RetryTimerRunning = TRUE;
			init_timer(&pEntry->RetryTimer);
			pEntry->RetryTimer.expires = jiffies + WPA_RETRY_EXEC_INTV;
			pEntry->RetryTimer.data = (unsigned long)pAdapter;
			pEntry->RetryTimer.function = &WPARetryExec;
			add_timer(&pEntry->RetryTimer);
			pEntry->ReTryCounter = GRP_HS_RETRY_TIMER_CTR;
		}

	}while(FALSE);
	DBGPRINT(RT_DEBUG_TRACE, "   WpaEAPOL Peer PAIR  Msg4 Action <<====   \n");

}

/*
	==========================================================================
	Description:
		When receiving the last packet of 2-way groupkey handshake.
	Return:
	==========================================================================
*/
VOID PeerGroupMsg2Action(
	IN PRTMP_ADAPTER pAdapter, 
	IN MAC_TABLE_ENTRY *pEntry,
	IN VOID *Msg,
	IN UINT MsgLen) 
{
	UINT        Len/*,i*/;
	UCHAR        pDecryp[MAX_LEN_OF_EAP_HS],mic[LEN_KEY_DESC_MIC];
	PUCHAR        pData;
	KEY_DESCRIPTER  *pKeyDesc;
	
	Len = MsgLen-LENGTH_802_1_H;
	pData = (PUCHAR)Msg;
	NdisZeroMemory(pDecryp, sizeof(pDecryp));
	NdisZeroMemory(mic, sizeof(mic));
	
	DBGPRINT(DEBUG_TEMP, "   PeerGroupMsg2Action   ====>>> %x %x %x %x %x %x   \n",pEntry->Addr.Octet[0],\
		pEntry->Addr.Octet[1], pEntry->Addr.Octet[2],pEntry->Addr.Octet[3],pEntry->Addr.Octet[4],pEntry->Addr.Octet[5]);
	do
	{
		if (MsgLen < (LENGTH_802_1_H+ LENGTH_EAPOL_H +sizeof(KEY_DESCRIPTER) -MAX_LEN_OF_RSNIE -2 ) )
			break;
			
		if (pEntry->WpaState != AS_PTKINITDONE)
			break;
		
		pKeyDesc = (PKEY_DESCRIPTER)(pData+LENGTH_802_1_H+LENGTH_EAPOL_H);

		// 1. verify the Reaply counter, if not valid,
		if (!RTMPEqualMemory(pKeyDesc->RCounter, pEntry->R_Counter, LEN_KEY_DESC_REPLAY))
		{
			DBGPRINT(RT_DEBUG_ERROR, "   Replay Counter  Different  in msg 2 of GROUP 2-way handshake!!!!!!!!!! \n");
			DBGPRINT(RT_DEBUG_TRACE, "   Receive : %d   %d  %d   %d  ",pKeyDesc->RCounter[0],pKeyDesc->RCounter[1],pKeyDesc->RCounter[2],pKeyDesc->RCounter[3]);
			DBGPRINT(RT_DEBUG_TRACE, "   Current : %d   %d  %d   %d  \n",pEntry->R_Counter[0],pEntry->R_Counter[1],pEntry->R_Counter[2],pEntry->R_Counter[3]);
			break;
		}
		else
		{
			DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "     Replay Counter  VALID  in msg 2 of GROUP 2-way handshake!!!!!!!!!! \n");;
		}
		// 2. verify MIC, 
		NdisMoveMemory(pDecryp, &pData[LENGTH_802_1_H], Len);  
		NdisZeroMemory(&pDecryp[81], LEN_KEY_DESC_MIC);
		if (pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled)
		{
			hmac_md5(pEntry->PTK,  LEN_EAP_MICK, pDecryp, Len, mic);
		}
		else
		{
			UCHAR digest[80];
			//encrypt_mpdu(PTK,  pnl,  pnh, 0, PAY_LEN, &LEN_HDR, (INT*)&MICMsgLen, 0, 0, OutBuffer, mac);
			HMAC_SHA1(pDecryp,  Len, pEntry->PTK, LEN_EAP_MICK, digest);
			NdisMoveMemory(mic, digest, LEN_KEY_DESC_MIC);
		}
		if (!RTMPEqualMemory(pKeyDesc->MIC, mic, LEN_KEY_DESC_MIC))
		{
			DBGPRINT(RT_DEBUG_ERROR, "     MIC  Different  in msg 2 of 2-way handshake!!!!!!!!!! \n");
			break;
		}
		else
			DBGPRINT(RT_DEBUG_ERROR, "     MIC VALID  in msg 2 of 2-way handshake!!!!!!!!!! \n");

		// 3.  upgrade state
		if (pEntry->RetryTimerRunning == TRUE)
		{
			DBGPRINT(RT_DEBUG_ERROR, "   Cancel Retry Timer ! \n");
			del_timer_sync(&pEntry->RetryTimer);
			pEntry->RetryTimerRunning = FALSE;              
		}
		pEntry->GTKState = REKEY_ESTABLISHED;
		pEntry->Flag &= (~DISASSOC_GRP_UDATE_TMOUT);    
	
		if (pAdapter->PortCfg.GKeyDoneStations > 0 )
			pAdapter->PortCfg.GKeyDoneStations--;
		
		if (pAdapter->PortCfg.GKeyDoneStations == 0)
		{
			pAdapter->PortCfg.WpaGTKState = SETKEYS_DONE;
			DBGPRINT(RT_DEBUG_ERROR, "AP SETKEYS_DONE  \n");
		// tt_lin_test
	//		ApStop(pAdapter);
			
			pAdapter->PortCfg.WPAREKEY.ReKeyInterval=10;
			ApStartUp(pAdapter);
		}

	}while(FALSE);  

}

/*
	==========================================================================
	Description: n
		Only for sending the first packet of 2-way groupkey handshake
	Return:
	==========================================================================
*/
NDIS_STATUS WPAHardTransmit(
	IN PRTMP_ADAPTER pAdapter,
	IN MAC_TABLE_ENTRY *pEntry)
{
	UINT                    i;
	UCHAR               GTK[TKIP_GTK_LENGTH],pRc4GTK[TKIP_GTK_LENGTH],mic[LEN_KEY_DESC_MIC];
//    UCHAR               EAPHEAD[8] = {0xaa, 0xaa, 0x03, 0x00, 0x00, 0x00,0x88,0x8e};
//    UCHAR               FrameGap;
	UCHAR               EAPHEADER[4] = {EAPOL_VER,EAPOLKey,0x00, LEN_MSG1_2WAY};
	UCHAR                ekey[(LEN_KEY_DESC_IV+LEN_EAP_EK)];
	ULONG                FrameLen = 0;
	UCHAR                *OutBuffer = NULL;
	
	UCHAR                INFO[2], KEYLEN[2], DATALEN[2], 
						 KEY_DESC=RSN_KEY_DESC, IV[LEN_KEY_DESC_IV];
	
	UCHAR                zeroarray[16];
	ULONG               Iv32,Iv16;
	PWPA_KEY          pWpaKey;
	PUCHAR              pDest;
	HEADER_802_11   Header_802_11; //NOTICE: Little-endian
	PTXD_STRUC      pTxD;
	TXD_STRUC		TxD; //tt_lin_big
//    NDIS_STATUS             NStatus;

	UCHAR               Header802_3[14];

	DBGPRINT(RT_DEBUG_TTL, "WPAHardTransmit-->\n");
	
	NdisZeroMemory(zeroarray, sizeof(zeroarray));
	NdisZeroMemory(ekey, sizeof(ekey));
	NdisZeroMemory(IV, sizeof(IV));
	NdisZeroMemory(pRc4GTK, sizeof(pRc4GTK));
	
	pWpaKey = &pEntry->PairwiseKey[0];
	do
	{   
		OutBuffer = kmalloc(MAX_LEN_OF_EAP_HS, GFP_KERNEL);
		if(OutBuffer == NULL)
			break;
		// Increment  replay counter by 1  
		i = LEN_KEY_DESC_REPLAY;
		do
		{
			i--;
			pAdapter->PortCfg.R_Counter[i]++;
			if (i == 0)
			{
				break;
			}
		}
		while (pAdapter->PortCfg.R_Counter[i] == 0);
		NdisMoveMemory(pEntry->R_Counter, pAdapter->PortCfg.R_Counter, sizeof(pEntry->R_Counter));
		INFO[0] = GEN_KEYINFO0(1,1,0,0);
		INFO[1] = GEN_KEYINFO1(DESC_TYPE_OTHER, GROUPKEY, pAdapter->PortCfg.WPAGKeyID,0,1); // install bit =0 for RCV only
		KEYLEN[0] = 0;
		KEYLEN[1] = TKIP_GTK_LENGTH;
		DATALEN[0] = 0;
		DATALEN[1] = TKIP_GTK_LENGTH;
		if (pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled)//AES
		{
			// AES data material length is less than that in TKIP by 8
			EAPHEADER[3] -= 8;
			KEYLEN[1] = LEN_AES_KEY;
			INFO[1] = GEN_KEYINFO1(DESC_TYPE_AES, GROUPKEY, pAdapter->PortCfg.WPAGKeyID, 0, 1);
			DATALEN[1] = LEN_AES_KEY + 8;
		}        
		NdisMoveMemory(IV, &pAdapter->PortCfg.GNonce[16], sizeof(IV));
		// Suggest IV be random number plus some number,
		IV[15] += 4;

		CountGTK(pAdapter->PortCfg.GMK, (UCHAR*)pAdapter->PortCfg.GNonce, pAdapter->CurrentAddress, GTK, TKIP_GTK_LENGTH);
		DBGPRINT(RT_DEBUG_ERROR, " pAdapter->PortCfg.WPAGKeyID %d GTK = \n",pAdapter->PortCfg.WPAGKeyID);
		DBGPRINT(RT_DEBUG_TTL/*INFO*/, " %x %x %x %x %x %x %x %x ",GTK[0],GTK[1],GTK[2],GTK[3],GTK[4],GTK[5],GTK[6],GTK[7]);
		DBGPRINT(RT_DEBUG_TTL/*INFO*/, "  %x %x %x %x %x %x %x %x \n",GTK[8],GTK[9],GTK[10],GTK[11],GTK[12],GTK[13],GTK[14],GTK[15]);
		DBGPRINT(RT_DEBUG_TTL/*INFO*/, "  %x %x %x %x %x %x %x %x",GTK[16],GTK[17],GTK[18],GTK[19],GTK[20],GTK[21],GTK[22],GTK[23]);
		DBGPRINT(RT_DEBUG_TTL/*INFO*/, "  %x %x %x %x %x %x  %x %x \n",GTK[24],GTK[25],GTK[26],GTK[27],GTK[28],GTK[29],GTK[30],GTK[31]);
		DBGPRINT(RT_DEBUG_TTL/*INFO*/, "\n");
			
		NdisMoveMemory(pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].Key, GTK, LEN_TKIP_EK);
		NdisMoveMemory(pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].TxMic, &GTK[16], LEN_TKIP_TXMICK);
		NdisMoveMemory(pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].RxMic, &GTK[24], LEN_TKIP_RXMICK);            

		WPAMake8023Hdr(pAdapter, pEntry->Addr.Octet, Header802_3);
		// Count EAPOL MIC , and encrypt DATA field before Send,   DATA fields includes the encrypted GTK
		if (pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled)
		{
			UCHAR digest[80];  // 80 to prevent overflow
			AES_GTK_KEY_WRAP(&pEntry->PTK[16], GTK, pRc4GTK);
			// First make a frame  for Countint MIC,
			MakeOutgoingFrame(OutBuffer,            &FrameLen,
							sizeof(EAPHEADER),                    EAPHEADER,
							1,                    &KEY_DESC,
							2,                    INFO,
							2,                    KEYLEN,
							sizeof(pEntry->R_Counter),                    pEntry->R_Counter, 
							LEN_KEY_DESC_NONCE,          pAdapter->PortCfg.GNonce,
							LEN_KEY_DESC_IV,            IV,
							6,           pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].TxTsc,
							2,                                  zeroarray,
							LEN_KEY_DESC_ID,        zeroarray,
							LEN_KEY_DESC_MIC,       zeroarray,
							2,                                  DATALEN,
							(KEYLEN[1] +8),         pRc4GTK,  //key wrap algorithm enhance length by 8
							END_OF_ARGS);
			HMAC_SHA1(OutBuffer,  FrameLen, pEntry->PTK, LEN_EAP_MICK, digest);
			NdisMoveMemory(mic, digest, LEN_KEY_DESC_MIC);
		
			// make  outgoing frame
			MakeOutgoingFrame(OutBuffer,                &FrameLen,
						LENGTH_802_3,                   &Header802_3,
						sizeof(EAPHEADER),              EAPHEADER,
						1,                              &KEY_DESC,
						2,                              INFO,
						2,                              KEYLEN,
						sizeof(pEntry->R_Counter),      pEntry->R_Counter, 
						LEN_KEY_DESC_NONCE,             pAdapter->PortCfg.GNonce,
						LEN_KEY_DESC_IV,                IV,
						6,                              pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].TxTsc,
						2,                              zeroarray,
						LEN_KEY_DESC_ID,                zeroarray,
						LEN_KEY_DESC_MIC,               mic,
						2,                              DATALEN,
						(KEYLEN[1] + 8),                pRc4GTK,
						END_OF_ARGS);
		}
		else
		{
			// PREPARE Encrypted  "Key DATA" field.  (Encrypt GTK with RC4, usinf PTK[16]->[31] as Key, IV-field as IV)
			// put TxTsc in Key RSC field
			pAdapter->PrivateInfo.FCSCRC32 = PPPINITFCS32;   //Init crc32.

			// ekey is the contanetion of IV-field, and PTK[16]->PTK[31]
			NdisMoveMemory(ekey, IV, LEN_KEY_DESC_IV);
			NdisMoveMemory(&ekey[LEN_KEY_DESC_IV], &pEntry->PTK[16], LEN_EAP_EK);
			ARCFOUR_INIT( &pAdapter->PrivateInfo.WEPCONTEXT, ekey, sizeof(ekey) );  //INIT SBOX, KEYLEN+3(IV)
			pAdapter->PrivateInfo.FCSCRC32 = RTMP_CALC_FCS32(pAdapter->PrivateInfo.FCSCRC32, GTK, TKIP_GTK_LENGTH);
			WPAARCFOUR_ENCRYPT(&pAdapter->PrivateInfo.WEPCONTEXT, pRc4GTK, GTK,  TKIP_GTK_LENGTH);
			// make a frame  for Countint MIC,
			MakeOutgoingFrame(OutBuffer,            &FrameLen,
							sizeof(EAPHEADER),                    EAPHEADER,
							1,                    &KEY_DESC,
							2,                    INFO,
							2,                    KEYLEN,
							sizeof(pEntry->R_Counter),  pEntry->R_Counter, 
							LEN_KEY_DESC_NONCE,          pAdapter->PortCfg.GNonce,
							LEN_KEY_DESC_IV,            IV,
							
							6,           pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].TxTsc,
							2,                      zeroarray,
							LEN_KEY_DESC_ID,        zeroarray,
							LEN_KEY_DESC_MIC,       zeroarray,
							2,                                  DATALEN,
							TKIP_GTK_LENGTH,         pRc4GTK,
							END_OF_ARGS);
			hmac_md5(pEntry->PTK, LEN_EAP_MICK, OutBuffer, FrameLen, mic);
			// make  outgoing frame
			MakeOutgoingFrame(OutBuffer,            &FrameLen,
						LENGTH_802_3,                   &Header802_3,
						sizeof(EAPHEADER),                    EAPHEADER,
						1,                    &KEY_DESC,
						2,                    INFO,
						2,                    KEYLEN,
						sizeof(pEntry->R_Counter),                    pEntry->R_Counter, 
						LEN_KEY_DESC_NONCE,          pAdapter->PortCfg.GNonce,
						LEN_KEY_DESC_IV,            IV,
						6, pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].TxTsc,
						2, zeroarray,
						LEN_KEY_DESC_ID,        zeroarray,
						LEN_KEY_DESC_MIC,       mic,
						2,                                  DATALEN,
						TKIP_GTK_LENGTH,         pRc4GTK,
						END_OF_ARGS);
		}
		
		DBGPRINT(DEBUG_TEMP,"Hard Transmit FrameLen = %d \n", FrameLen);
		RTMPToWirelessSta(pAdapter, OutBuffer, FrameLen);
	
	}while (FALSE);

	kfree(OutBuffer);

	DBGPRINT(RT_DEBUG_TTL, "WPAHardTransmit<<--\n");

	return (NDIS_STATUS_SUCCESS);
}

//////////////////////////////////////////////////////////////////////////
//
VOID WpaEAPOLASFAlertAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem) 
{   
	DBGPRINT(RT_DEBUG_TTL, "WpaEAPOLASFAlertAction-->\n");
	
}

//////////////////////////////////////////////////////////////////////////
//
VOID DisAssocAction(
	IN PRTMP_ADAPTER pAd, 
	IN MAC_TABLE_ENTRY *pEntry,
	IN USHORT SubType,
	IN USHORT Reason)
{
	CHAR                 *OutBuffer = NULL;
	ULONG                 FrameLen = 0;
	MACHDR              DisassocHdr;
	MACADDR            addr;
//    NDIS_STATUS      NStatus;

	//  send out a DISASSOC request frame
	OutBuffer = kmalloc(MAX_LEN_OF_MLME_BUFFER, GFP_KERNEL);
	if(OutBuffer == NULL)
		return;
	
	NdisMoveMemory(addr.Octet, pEntry->Addr.Octet, MAC_ADDR_LEN);
	DBGPRINT(RT_DEBUG_ERROR, "   ASSOC - Send DISASSOC  Reason = %d frame  TO %02x:%02x:%02x:%02x:%02x:%02x \n", 
			 Reason, pEntry->Addr.Octet[0], 
			 pEntry->Addr.Octet[1], pEntry->Addr.Octet[2], pEntry->Addr.Octet[3], pEntry->Addr.Octet[4], pEntry->Addr.Octet[5]);
	
	MgtMacHeaderInit(pAd, &DisassocHdr, SubType, 0, &addr, &pAd->PortCfg.Bssid);
	// DisassocHdr is little-endian
	Reason = RTMP_CPU_TO_LE16(Reason);//tt_lin_big

	MakeOutgoingFrame(OutBuffer, &FrameLen, 
						sizeof(MACHDR), (CHAR *)&DisassocHdr, 
						2, (char*)&Reason, 
						END_OF_ARGS);
	
	MiniportMMRequest(pAd, OutBuffer, FrameLen);
	
	if (pEntry)
	{  
		if (pEntry->RetryTimerRunning == TRUE)
		{
			DBGPRINT(RT_DEBUG_TTL/*TRACE*/, " del_timer_sync in DisAssocAction : !!!!!!!!");
			del_timer_sync(&pEntry->RetryTimer);
			pEntry->RetryTimerRunning = FALSE;              
		}     
		//ApLogEvent(pAd, &pEntry->Addr, EVENT_DISASSOCIATED);
		MacTableDeleteEntry(pAd,  &pEntry->Addr);
	}

}//end of DisAssocAction()

/*
	==========================================================================
	Description:
		Timer execution function for periodically updating group key.
	Return:
	==========================================================================
*/  //n
VOID GREKEYPeriodicExec( IN	unsigned long data) 
{
	UINT            i;
	ULONG           temp_counter = 0;
	RTMP_ADAPTER *pAdapter = (RTMP_ADAPTER *)data;
//    MAC_TABLE_ENTRY *pEntry;
	BOOLEAN			bTimer = TRUE;
		
	DBGPRINT(RT_DEBUG_TTL/*INFO*/, " GROUP REKEY PeriodicExec ==>>   \n");

	if(pAdapter->PortCfg.AuthMode < Ndis802_11AuthModeWPA)
	{
		bTimer = FALSE;
		pAdapter->PortCfg.REKEYTimerRunning = FALSE;
	}
	if ((pAdapter->PortCfg.WPAREKEY.ReKeyMethod == TIME_REKEY) && 	(pAdapter->PortCfg.REKEYCOUNTER < 0xffffffff))
		temp_counter = (++pAdapter->PortCfg.REKEYCOUNTER);
	// REKEYCOUNTER is incremented every TX_RING_SIZE packets transmitted, 
	// But the unit of Rekeyinterval is 1K packets
	else if (pAdapter->PortCfg.WPAREKEY.ReKeyMethod == PKT_REKEY )
		temp_counter = pAdapter->PortCfg.REKEYCOUNTER/TX_RING_SIZE;
	else
	{
		bTimer = FALSE;
		pAdapter->PortCfg.REKEYTimerRunning = FALSE;
	}
	
	if (temp_counter > (pAdapter->PortCfg.WPAREKEY.ReKeyInterval))
	{
		pAdapter->PortCfg.REKEYCOUNTER = 0;
		DBGPRINT(DEBUG_TEMP, "   Rekey Interval Excess,   GKeyDoneStations= %d  \n",pAdapter->MacTab.Size);
		pAdapter->PortCfg.WpaGTKState = SETKEYS;
		// take turn updating different groupkey index, 
		if ((pAdapter->PortCfg.GKeyDoneStations = pAdapter->MacTab.Size) > 0)
		{
			pAdapter->PortCfg.WPAGKeyID = (pAdapter->PortCfg.WPAGKeyID == 1) ? 2 : 1;         
			GenRandom(pAdapter, pAdapter->PortCfg.GNonce); //
			for (i = 0; i < MAX_LEN_OF_MAC_TABLE; i++)
			{
				if ((pAdapter->MacTab.Content[i].Valid == TRUE) && (pAdapter->MacTab.Content[i].WpaState == AS_PTKINITDONE))
				{
					pAdapter->MacTab.Content[i].GTKState = REKRY_NEGOTIATING;
					NdisZeroMemory(pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].TxTsc, 
									sizeof(pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].TxTsc));
					WPAHardTransmit(pAdapter, &pAdapter->MacTab.Content[i]);
					DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "   Rekey interval excess,  Update Group Key for  %02x:%02x:02%x:02:%02x:%02x:%02x , WPAGKeyID= %x \n",\
							pAdapter->MacTab.Content[i].Addr.Octet[0],pAdapter->MacTab.Content[i].Addr.Octet[1],\
							pAdapter->MacTab.Content[i].Addr.Octet[2],pAdapter->MacTab.Content[i].Addr.Octet[3],\
							pAdapter->MacTab.Content[i].Addr.Octet[4],pAdapter->MacTab.Content[i].Addr.Octet[5],\
							pAdapter->PortCfg.WPAGKeyID);
				}
			}
		}
	}
		
	if(bTimer)
	{
		pAdapter->PortCfg.REKEYTimer.expires = jiffies + GUPDATE_EXEC_INTV;
		add_timer(&pAdapter->PortCfg.REKEYTimer);
	}
}


/////////////////////////////////////////////////////////////////
// NOTICE: Output Big-endian
VOID WPAMake8023Hdr( 
	IN PRTMP_ADAPTER    pAd, 
	IN PCHAR pDAddr, 
	IN OUT PCHAR pHdr) 
{
	 // Addr1: DA, Addr2: BSSID, Addr3: SA
	NdisMoveMemory(pHdr, pDAddr, MAC_ADDR_LEN);
	NdisMoveMemory(&pHdr[MAC_ADDR_LEN], pAd->CurrentAddress, MAC_ADDR_LEN);
	NdisMoveMemory(&pHdr[2*MAC_ADDR_LEN], EAPOL, LENGTH_802_3_TYPE);
}

//////////////////////////////////////////////////////////////////////////
// HMAC-SHA1 is the EAPOL-Key encryption algorithm used to protect the
// distributed GTK 
VOID HMAC_SHA1(
	IN UCHAR *text,
	IN UINT text_len,
	IN UCHAR *key,
	IN UINT key_len,
	IN UCHAR *digest)
{
	SHA_CTX context;
	UCHAR k_ipad[65]; /* inner padding - key XORd with ipad */
	UCHAR k_opad[65]; /* outer padding - key XORd with opad */
	INT i;

//	DBGPRINT( RT_DEBUG_TTL, "HMAC_SHA1-->\n");
	// if key is longer than 64 bytes reset it to key=SHA1(key) 
	if (key_len > 64) 
	{
		SHA_CTX      tctx;
		SHAInit(&tctx);
		SHAUpdate(&tctx, key, key_len);
		SHAFinal(&tctx, key);
		key_len = 20;
	}
	NdisZeroMemory(k_ipad,  sizeof (k_ipad));
	NdisZeroMemory(k_opad, sizeof (k_opad));
	NdisMoveMemory(k_ipad, key, key_len);
	NdisMoveMemory(k_opad, key, key_len);

	// XOR key with ipad and opad values  
	for (i = 0; i < 64; i++) 
	{   
		k_ipad[i] ^= 0x36;
		k_opad[i] ^= 0x5c;
	}

	// perform inner SHA1 
	SHAInit(&context); /* init context for 1st pass */
	SHAUpdate(&context, k_ipad, 64); /* start with inner pad */
	SHAUpdate(&context, text, text_len); /* then text of datagram */
	SHAFinal(&context, digest); /* finish up 1st pass */

	//perform outer SHA1  
	SHAInit(&context); /* init context for 2nd pass */
	SHAUpdate(&context, k_opad, 64); /* start with outer pad */
	SHAUpdate(&context, digest, 20); /* then results of 1st hash */
	SHAFinal(&context, digest); /* finish up 2nd pass */

}//end of HMAC_SHA1()


/*
	==========================================================================
	Description: PRF=>(Pseudo Random Function)
		Length of output is in octets rather than bits.  Since length is always a multiple of 8, output array is organized
		so first N octets starting from 0 contains PRF output.
		INPUT : supported input are 16, 32, 48, 64
		OUTPUT : output array should be 80 octets to allow for sha1 overflow
	Return:
	==========================================================================
 * Pseudo-Random Function for generate cryptographic quality random numbers.
 * Length of output is in octets rather than bits since length is always a
 * multiple of 8.
 * Output array is organized so first N octets starting from 0 contains prf
 * output.
 * Supported inputs are 16, 32, 48, 64       ** q 802.11i Draft copy Ӫ  

*/
VOID PRF(
	IN UCHAR    *Key,
	IN INT      key_len,
	IN UCHAR    *Prefix,
	IN INT      Prefix_len,
	IN UCHAR    *Data,
	IN INT      Data_len,
	OUT UCHAR   *Output,
	IN   INT        Output_len)
{
	INT     i;
	UCHAR   input[1024];
	INT     currentindex=0;
	INT     total_len;
	
//	DBGPRINT(RT_DEBUG_TTL,"PRF-->\n");

	NdisMoveMemory( input, Prefix, Prefix_len );
	input[Prefix_len] = 0;/* single octet 0 */
	NdisMoveMemory( &input[Prefix_len+1], Data, Data_len);
	total_len = Prefix_len+1+Data_len;
	input[total_len] = 0; /* single octet count, start at 0 */
	total_len++;
	for (i = 0; i < (Output_len+19)/20; i++)
	{
		HMAC_SHA1(input, total_len, Key, key_len, &Output[currentindex]);
		currentindex += 20; /* next concatenation location */
		input[total_len-1]++;/* increment octet count */
	}
	
}

//////////////////////////////////////////////////////////////////////////
//
VOID CountPTK(
	IN      UCHAR   *PMK,
	IN      UCHAR   *ANonce,
	IN      UCHAR   *AA,
	IN      UCHAR   *SNonce,
	IN      UCHAR   *SA,
	OUT UCHAR   *output,
	IN      UINT    len)
{   
	UCHAR   concatenation[76];
	UINT    CurrPos=0;
	UCHAR   Prefix[22];
	UCHAR       temp[32];
//    INT         i;

	DBGPRINT(RT_DEBUG_TTL, "CountPTK-->\n" );

	NdisZeroMemory(temp, sizeof(temp));

	GetSmall(SA, AA, temp, 6);
	NdisMoveMemory(concatenation, temp, 6);
	CurrPos += 6;

	GetLarge(SA, AA, temp, 6);
	NdisMoveMemory(&concatenation[CurrPos], temp, 6);
	CurrPos += 6;

	GetSmall(ANonce, SNonce, temp, 32);
	NdisMoveMemory(&concatenation[CurrPos], temp, 32);
	CurrPos += 32;

	GetLarge(ANonce, SNonce, temp, 32);
	NdisMoveMemory(&concatenation[CurrPos], temp, 32);
	CurrPos += 32;
	
	Prefix[0] = 'P';
	Prefix[1] = 'a';
	Prefix[2] = 'i';
	Prefix[3] = 'r';
	Prefix[4] = 'w';
	Prefix[5] = 'i';
	Prefix[6] = 's';
	Prefix[7] = 'e';
	Prefix[8] = ' ';
	Prefix[9] = 'k';
	Prefix[10] = 'e';
	Prefix[11] = 'y';
	Prefix[12] = ' ';
	Prefix[13] = 'e';
	Prefix[14] = 'x';
	Prefix[15] = 'p';
	Prefix[16] = 'a';
	Prefix[17] = 'n';
	Prefix[18] = 's';
	Prefix[19] = 'i';
	Prefix[20] = 'o';
	Prefix[21] = 'n';
	PRF(PMK, PMK_LEN, Prefix,  22, concatenation, 76 , output, len);

}//end of CountPTK()

//////////////////////////////////////////////////////////////////////////
//
VOID CountGTK(
	IN      UCHAR   *GMK,
	IN      UCHAR   *GNonce,
	IN      UCHAR   *AA,
	OUT UCHAR   *output,
	IN      UINT    len)
{
	UCHAR   concatenation[76];
//    PUCHAR  pCurr;
	UINT    CurrPos=0;
	UCHAR   Prefix[19];
//    INT         i;
	UCHAR   temp[80];   
	
	DBGPRINT( RT_DEBUG_TTL, "CountGTK-->\n");

	NdisMoveMemory(&concatenation[CurrPos], AA, 6);
	CurrPos += 6;

	NdisMoveMemory(&concatenation[CurrPos], GNonce , 32);
	CurrPos += 32;

	Prefix[0] = 'G';
	Prefix[1] = 'r';
	Prefix[2] = 'o';
	Prefix[3] = 'u';
	Prefix[4] = 'p';
	Prefix[5] = ' ';
	Prefix[6] = 'k';
	Prefix[7] = 'e';
	Prefix[8] = 'y';
	Prefix[9] = ' ';
	Prefix[10] = 'e';
	Prefix[11] = 'x';
	Prefix[12] = 'p';
	Prefix[13] = 'a';
	Prefix[14] = 'n';
	Prefix[15] = 's';
	Prefix[16] = 'i';
	Prefix[17] = 'o';
	Prefix[18] = 'n';

	PRF(GMK, PMK_LEN, Prefix,  19, concatenation, 38 , temp, len);
	NdisMoveMemory(output, temp, len);

}//end of CountGTK()

//////////////////////////////////////////////////////////////////////////
//Copy small string to pOut 
VOID    GetSmall(
	IN  PVOID   pSrc1,
	IN  PVOID   pSrc2,
	OUT PUCHAR  pOut,
	IN  ULONG   Length)
{
	PUCHAR  pMem1;
	PUCHAR  pMem2;
	ULONG   Index = 0;
	pMem1 = (PUCHAR) pSrc1;
	pMem2 = (PUCHAR) pSrc2;

//	DBGPRINT(RT_DEBUG_TTL, "GetSmall-->\n");

	for (Index = 0; Index < Length; Index++)
	{
		if (pMem1[Index] != pMem2[Index])
		{
			if (pMem1[Index] > pMem2[Index])        
				NdisMoveMemory(pOut, pSrc2, Length);
			else
				NdisMoveMemory(pOut, pSrc1, Length);             

			break;
		}
	}

}//end of GetSmall()

//////////////////////////////////////////////////////////////////////////
//
VOID    GetLarge(
	IN  PVOID   pSrc1,
	IN  PVOID   pSrc2,
	OUT PUCHAR  pOut,
	IN  ULONG   Length)
{
	PUCHAR  pMem1;
	PUCHAR  pMem2;
	ULONG   Index = 0;
	pMem1 = (PUCHAR) pSrc1;
	pMem2 = (PUCHAR) pSrc2;

	for (Index = 0; Index < Length; Index++)
	{
		if (pMem1[Index] != pMem2[Index])
		{
			if (pMem1[Index] > pMem2[Index])        
				NdisMoveMemory(pOut, pSrc1, Length);
			else
				NdisMoveMemory(pOut, pSrc2, Length);             

			break;
		}
	}
}//end of GetLarge()

//////////////////////////////////////////////////////////////////////////
// 802.1i  Annex F.9
VOID GenRandom(
	IN PRTMP_ADAPTER pAd, 
	OUT UCHAR       *random)
{   
	INT i, curr/*,cc*/;
	USHORT sIndex,sTemp;
	UCHAR   local[80], prefix[12];
	UCHAR   result[80];
	UCHAR   strCurrentTime[8];// for CurrentTime exchange to bigendian.

//    PUCHAR  pLook;
	LARGE_INTEGER   CurrentTime;
//	char mykey[] = {0x1d,0x07,0x8c,0x7f,0x47,0x79,0x46,0x71,0xd0,0x39,
//		            0x04,0x64,0xff,0x40,0x16,0x4e,0x31,0x24,0x4d,0xa7,
//					0x50,0x84,0x7d,0xd7,0x27,0x38,0x55,0x42,0xd4,0xd9,
//					0x34,0x3c};

	NdisZeroMemory(result, 80);
	NdisZeroMemory(local, 80);
	NdisMoveMemory(local, pAd->CurrentAddress, ETH_LENGTH_OF_ADDRESS);
//
	prefix[0] = 'I';
	prefix[1] = 'n';
	prefix[2] = 'i';
	prefix[3] = 't';
	prefix[4] = ' ';
	prefix[5] = 'C';
	prefix[6] = 'o';
	prefix[7] = 'u';
	prefix[8] = 'n';
	prefix[9] = 't';
	prefix[10] = 'e';
	prefix[11] = 'r';
	
//	memcpy(pAd->PortCfg.Key_Counter, mykey, 32);
//	CurrentTime = *((LARGE_INTEGER*)mykey);

	for (i = 0; i < 32; i++)
	{   
		ULONG  uTemp;

		curr =  ETH_LENGTH_OF_ADDRESS;
//		CurrentTime = jiffies;
		*(LARGE_INTEGER*)strCurrentTime = jiffies;
		uTemp = *(PULONG)&strCurrentTime[4];	
		*(PULONG)&strCurrentTime[4] = RTMP_CPU_TO_LE32(*(PULONG)strCurrentTime);
		*(PULONG)strCurrentTime = RTMP_CPU_TO_LE32(uTemp);
		
		NdisMoveMemory(local,  pAd->CurrentAddress, ETH_LENGTH_OF_ADDRESS);
//
		curr += ETH_LENGTH_OF_ADDRESS;
		NdisMoveMemory(&local[curr],  &CurrentTime, sizeof(CurrentTime));//(P Intel PCP)
		curr += sizeof(CurrentTime);
		NdisMoveMemory(&local[curr],  result, 32);
		curr += 32;
		sTemp = RTMP_CPU_TO_LE16(i);//add by tt_lin
		NdisMoveMemory(&local[curr],  &sTemp,  2);   //??   
		curr += 2;
		PRF(pAd->PortCfg.Key_Counter, 32, prefix,12, local, curr, result, 32); 
	}
	
	// 32 bytes - adder,(Big-endian), Key_Counter += 1 
	// 0   1    2    ~  31
	// (MB)               (LB)
	for (i = 32; i > 0; i--)
	{   
		if (pAd->PortCfg.Key_Counter[i-1] == 0xff)
		{
			pAd->PortCfg.Key_Counter[i-1] = 0;
		}
		else
		{
			pAd->PortCfg.Key_Counter[i-1]++;
			break;
		}
	}
	NdisMoveMemory(random, result,  32);
	DebugPrint("GenRandom",random,32);
}//end of GenRandom()

/*
	==========================================================================
	Description:
		ENCRYPT AES GTK before sending in EAPOL frame.
		AES GTK length = 128 bit,  so fix blocks for aes-key-wrap as 2 in this function.
		This function references to RFC 3394 for aes key wrap algorithm.
	Return:
	==========================================================================
*/  //(XX)
VOID AES_GTK_KEY_WRAP( 
	IN UCHAR *key,
	IN UCHAR *plaintext,
	OUT UCHAR *ciphertext)
{
	UCHAR A[8], BIN[16], BOUT[16];
	UCHAR R1[8],R2[8];
	INT num_blocks = 2;
	INT i, j;
	aes_context aesctx;
	UCHAR xor;
	
	DBGPRINT(RT_DEBUG_AES, "AES_GTK_KEY_WRAP-->\n");

	// init
	for (i = 0; i < 8; i++)
		A[i] = 0xa6;

	NdisMoveMemory(R1, plaintext, 8);
	NdisMoveMemory(R2, &plaintext[8], 8);
	aes_set_key(&aesctx, key, 128);

	for (j = 0; j < 6; j++)
	{
		NdisMoveMemory( BIN, A, 8 );
		NdisMoveMemory( &BIN[8], R1, 8 );
		aes_encrypt( &aesctx, BIN, BOUT );
		xor = num_blocks * j +1;
		NdisMoveMemory( A, &BOUT[0], 8 );
		A[7] = BOUT[7] ^ xor;
		NdisMoveMemory( R1, &BOUT[8], 8 );
		xor = num_blocks * j + 2;

		NdisMoveMemory( BIN, A, 8 );
		NdisMoveMemory( &BIN[8], R2, 8 );
		aes_encrypt( &aesctx, BIN, BOUT );

		NdisMoveMemory( A, &BOUT[0], 8);
		A[7] = BOUT[7] ^ xor;
		NdisMoveMemory( R2, &BOUT[8], 8);            
	}

	// OUTPUT
	NdisMoveMemory(ciphertext, A, 8);
	NdisMoveMemory(&ciphertext[8], R1, 8);
	NdisMoveMemory(&ciphertext[16], R2, 8);

}//end of AES_GTK_KEY_WRAP()

/*
	========================================================================
	Routine Description:
	   Send all EAP frames to wireless station.
	   These frames don't come from normal SendPackets routine, but are EAPPacket, EAPOL, 
		
	Arguments:
		pRxD        Pointer to the Rx descriptor
		
	Return Value:
None
========================================================================
*/
VOID RTMPToWirelessSta(
	IN  PRTMP_ADAPTER   pAdapter,
	IN  PUCHAR          pFrame,
	IN  UINT            FrameLen)
{
	SST             Sst;
	USHORT          Aid;
	UCHAR           PsMode, Rate;
	MAC_TABLE_ENTRY *pEntry;
	BOOLEAN         result = FALSE;
	struct sk_buff *skb;

	DBGPRINT(RT_DEBUG_TTL/*INFO*/, "  0.  RTMPToWirelessSta ====>>   \n");

	// decide the return value. TRUE if no need to indicate to LLC, FALSE otherwise
	pEntry = SsPsInquiry(pAdapter, (MACADDR *)pFrame, &Sst, &Aid, &PsMode, &Rate);
	if ((pAdapter->PortCfg.IsolateInterStaTraffic == 0) && (pEntry && (Sst == SST_ASSOC)))
	{
		NDIS_STATUS     Status;
		UCHAR           *pVirtualAddress;
		
		DBGPRINT(RT_DEBUG_TTL/*INFO*/, "  1.  RTMPToWirelessSta ====>>  \n");

		do {
			// 1. build a NDIS packet and call RTMPSendPacket();
			//    be careful about how/when to release this internal allocated NDIS PACKET buffer
			if ((skb = dev_alloc_skb(FrameLen + 2)) != NULL)
			{
				skb->len = FrameLen;
				memcpy((skb->data), pFrame, FrameLen);
			}
			else
			{
				break;
			}

			// 2. send out the packet
			Status = RTMPSendPacket(pAdapter, skb);
			if (Status == NDIS_STATUS_SUCCESS)
			{
				DBGPRINT(RT_DEBUG_TTL/*INFO*/, "  2.  RTMPToWirelessSta ====>>  \n");

				// Dequeue one frame from TxSwQueue0..3 queue and process it
				// There are three place calling dequeue for TX ring.
				// 1. Here, right after queueing the frame.
				// 2. At the end of TxRingTxDone service routine.
				// 3. Upon NDIS call RTMPSendPackets
				if ((!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS)) && (!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_RESET_IN_PROGRESS)))
				{
					RTMPDeQueuePacket(pAdapter);
				}   
			}
			else // free this packet space
			{
				RTMPFreeSkbBuffer(skb);
			}

		} while (FALSE);
	}
}

/*
	========================================================================

	Routine Description:
		Sending EAP Req. frame to station in authenticating state.
		These frames come from Authenticator deamon.

	Arguments:
		pAdapter        Pointer to our adapter
		pPacket     Pointer to outgoing EAP frame body + 8023 Header
		Len             length of pPacket
		
	Return Value:
		None
	========================================================================
*/
VOID    WpaSend(
	IN  PRTMP_ADAPTER   pAdapter,
	IN  PUCHAR          pPacket,
	IN  ULONG           Len)
{
	UCHAR           FrameGap;
	PUCHAR          pDest;
	PUCHAR          pSrc;
	PTXD_STRUC      pTxD;
	ULONG           Iv16;
	ULONG           Iv32;
	PWPA_KEY        pWpaKey;
	PEAP_HDR        pEapHdr;
	UCHAR           RetryMode = SHORT_RETRY;
	MACADDR         Addr;
	MAC_TABLE_ENTRY *pEntry;
	HEADER_802_11   *pHEADER_802_11;
	
	DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "   WpaSend ====>> Len=%d  \n",Len);

	DebugPrint("WpaSend", pPacket, Len);

	//Step1. send EAP Success
	RTMPToWirelessSta(pAdapter, pPacket, Len);
	NdisMoveMemory(&(Addr.Octet), pPacket, 6);
	pEapHdr = (EAP_HDR*)(pPacket + LENGTH_802_3  + LENGTH_8021X_HDR);
	if ((pEntry = MacTableLookup(pAdapter, &Addr)) == NULL)
		return;    

	if (RTMPEqualMemory((pPacket+12), EAPOL, 2) )
	{
		switch (pEapHdr->code)
		{
			case EAP_CODE_SUCCESS:
				DBGPRINT(DEBUG_TEMP," Send EAP_CODE_SUCCESS \n");
				if (pEntry && (pEntry->Sst == SST_ASSOC))
				{
					pEntry->WpaState = AS_INITPMK;
					//Step2. EAPOL - Key 1
					WPAStart4WayHS(pAdapter, pEntry);
					if ((pEntry->RetryTimerRunning == FALSE) )
					{
						// retry up to 3 times at interval 1 second
						DBGPRINT(RT_DEBUG_TTL/*TRACE*/, "   add_timer  Timer   ====>>>   \n");
						pEntry->RetryTimerRunning = TRUE;
						init_timer(&pEntry->RetryTimer);
						pEntry->RetryTimer.expires = jiffies + WPA_RETRY_EXEC_INTV;
						pEntry->RetryTimer.data = (unsigned long)pAdapter;
						pEntry->RetryTimer.function = &WPARetryExec;
						add_timer(&pEntry->RetryTimer);
						pEntry->ReTryCounter = PAIR_HS_RETRY_TIMER_CTR;
					}                
				}
				break;

			case EAP_CODE_FAILURE:
				DBGPRINT(DEBUG_TEMP,"Send EAP_CODE_FAILURE\n");
				break;

			default:
				break;    
		}
	}
	else     
	{
		DBGPRINT(RT_DEBUG_TTL/*TRACE*/, " Send Deauth , Reason : REASON_NO_LONGER_VALID  \n");
		DisAssocAction(pAdapter, pEntry, SUBTYPE_DEAUTH, REASON_NO_LONGER_VALID);
	}
}

VOID	RTMPMakeRSNIE(
	IN  PRTMP_ADAPTER   pAdapter,
	IN  UINT            AuthMode,
	IN  UINT            WepStatus)
{
	RSNIE       *pRsnie;
	RSNIE_AUTH  *pRsnie_auth;
	UCHAR       oui01[4] = {0x00, 0x50, 0xf2, 0x01};
	UCHAR       oui02[4] = {0x00, 0x50, 0xf2, 0x02};
	UCHAR       oui04[4] = {0x00, 0x50, 0xf2, 0x04};


	DBGPRINT(RT_DEBUG_TTL,"RTMPMakeRSNIE-->\n");

	pRsnie = (RSNIE*)pAdapter->PortCfg.RSN_IE;    
	NdisMoveMemory(pRsnie->oui, oui01, 4);
	pRsnie->version = 1;
	pRsnie->version = RTMP_CPU_TO_LE16(pRsnie->version); //tt_lin_big
	switch (WepStatus)
	{
		case Ndis802_11Encryption2Enabled:
			NdisMoveMemory(pRsnie->mcast, oui02, 4);
			// currently support one unicast cipher. one auth  
			pRsnie->ucount = 1;
			pRsnie->ucount = RTMP_CPU_TO_LE16(pRsnie->ucount);
			NdisMoveMemory(pRsnie->ucast[0].oui, oui02, 4);
			break;

		case Ndis802_11Encryption3Enabled:
			NdisMoveMemory(pRsnie->mcast, oui04, 4);
			// currently support one unicast cipher.
			pRsnie->ucount = 1;
			pRsnie->ucount = RTMP_CPU_TO_LE16(pRsnie->ucount);//tt_lin_big
			NdisMoveMemory(pRsnie->ucast[0].oui, oui04, 4);
			break;
	}

	pRsnie_auth = (RSNIE_AUTH*)(pAdapter->PortCfg.RSN_IE + sizeof(RSNIE));

	switch (AuthMode)
	{
		case Ndis802_11AuthModeWPA:
			pRsnie_auth->acount = 1;
			pRsnie_auth->acount = RTMP_CPU_TO_LE16(pRsnie_auth->acount);//tt_lin_big
			NdisMoveMemory(pRsnie_auth->auth[0].oui, oui01, 4);
			DBGPRINT(RT_DEBUG_TTL/*INFO*/," auth = %x %x %x %x %x %x  \n",pAdapter->PortCfg.RSN_IE[16],pAdapter->PortCfg.RSN_IE[17],
				pAdapter->PortCfg.RSN_IE[18],pAdapter->PortCfg.RSN_IE[19],pAdapter->PortCfg.RSN_IE[20],pAdapter->PortCfg.RSN_IE[21]);
			break;

		case Ndis802_11AuthModeWPAPSK:
			pRsnie_auth->acount = 1;
			pRsnie_auth->acount = RTMP_CPU_TO_LE16(pRsnie_auth->acount);
			NdisMoveMemory(pRsnie_auth->auth[0].oui, oui02, 4);
			DBGPRINT(RT_DEBUG_TTL/*INFO*/," auth = %x %x %x %x %x %x  \n",pAdapter->PortCfg.RSN_IE[16],pAdapter->PortCfg.RSN_IE[17],
				pAdapter->PortCfg.RSN_IE[18],pAdapter->PortCfg.RSN_IE[19],pAdapter->PortCfg.RSN_IE[20],pAdapter->PortCfg.RSN_IE[21]);
			break;
	}
	
	pAdapter->PortCfg.RSNIE_Len = sizeof(RSNIE) + sizeof(RSNIE_AUTH);

	DBGPRINT(RT_DEBUG_ERROR," RTMPMakeRSNIE : RSNIE_Len = %d\n",pAdapter->PortCfg.RSNIE_Len);
}

