/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology	5th	Rd.
 * Science-based Industrial	Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved.	Ralink's source	code is	an unpublished work	and	the
 * use of a	copyright notice does not imply	otherwise. This	source code
 * contains	confidential trade secret material of Ralink Tech. Any attemp
 * or participation	in deciphering,	decoding, reverse engineering or in	any
 * way altering	the	source code	is stricitly prohibited, unless	the	prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	header.h

	Abstract:
	Miniport generic portion header	file

	Revision History:
	Who			When		  What
	--------	----------	  ----------------------------------------------
	Paul Lin	08-01-2002	  created

*/
#include	"rt_config.h"

//
// BBP register	initialization set
//
ULONG	BBPRegTable[] =	{
	0x00018302,	 //	R03
	0x00018419,	 //	R04
	0x00018E1C,	 //	R14
	0x00018F30,	 //	R15
	0x0001902c,	 //	R16
	0x00019148,	 //	R17
	0x00019218,	 //	R18
	0x000193ff,	 //	R19
	0x0001941E,	 //	R20
	0x00019508,	 //	R21
	0x00019608,	 //	R22
	0x00019708,	 //	R23
	0x00019870,	 //	R24
	0x00019940,	 //	R25
	0x00019A08,	 //	R26
	0x00019B23,	 //	R27
	0x00019E10,	 //	R30
	0x00019F2B,	 //	R31
	0x0001A0B9,	 //	R32
	0x0001A212,	 //	R34
	0x0001A350,	 //	R35
	0x0001A7c4,	 //	R39
	0x0001A802,	 //	R40
	0x0001A960,	 //	R41
	0x0001B510,	 //	R53
	0x0001B618,	 //	R54
	0x0001B808,	 //	R56
	0x0001B910,	 //	R57
	0x0001BA08,	 //	R58
	0x0001BD6d,	 //	R61
	0x0001BE10,	 //	R62
};

//
// MAC register	initialization sets
//
RTMP_REG_PAIR	MACRegTable[] =	{
	{PSCSR0,	0x00020002},			// 0xc8
	{PSCSR1,	0x00000002},			// 0xcc
	{PSCSR2,	0x00023f20},			// 0xd0
	{PSCSR3,	0x00000002},			// 0xd4
	{TIMECSR,	0x00003f20},
	{CSR9,		0x00000780},			// 0x24
	{CSR11,		0x07041483},		// 0x2C, lrc=7,	src=4, slot=20us, CWmax=2^10, CWmax=2^5	
	{CSR18,		0x00140000},		// SIFS=10us - PHY_TR_SWITCH_TIME, PIFS= SIFS +	SLOT
//	{CSR19,		0x016C0032},		// DIFS=SIFS + 2*SLOT, EIFS=364us
	{CNT3,		0x3f080000},			// Backoff_CCA_Th, RX_&_TX_CCA_Th

	{TXCSR1,	0x07614562},		// 0x64, ACK as	1Mb	time, 2003/10/22:Gary
	{TXCSR8,	0x8c8d8b8a},		// 0x98, CCK TX	BBP	register ID
  //{TXCSR9,	0x86870885},		// 0x94, OFDM TX BBP register ID
	
	{ARCSR1,	0x0000000f},		// 0x9c, Basic rate	set	bitmap
	{PLCP1MCSR,	0x00700400},		// 0x13c, ACK/CTS PLCP at 1	Mbps
	{PLCP2MCSR,	0x00380401},		// 0x140, ACK/CTS PLCP at 2	Mbps
	{PLCP5MCSR,	0x00150402},		// 0x144, ACK/CTS PLCP at 5.5 Mbps
	{PLCP11MCSR,0x000b8403},		// 0x148, ACK/CTS PLCP at 11 Mbps
	
	{ARTCSR0,	0x7038140a},		// 0x14c, ACK/CTS payload consumed time	for	1/2/5.5/11 mbps
	{ARTCSR1,	0x1d21252d},		// 0x150, alexsu : OFDM	ACK/CTS	payload	consumed time for 18/12/9/6	mbps
	{ARTCSR2,	0x1919191d},		// 0x154, alexsu : OFDM	ACK/CTS	payload	consumed time for 54/48/36/24 mbps
	
	{RXCSR0,	0xffffffff},		// 0x80	
	{RXCSR3,	0xb3aab3af},		// 0x90. RT2530	BBP	51:RSSI, R42:OFDM rate,	R47:CCK	SIGNAL
//	{PCICSR,	0x000003F8},		// 0x8c, alexsu	: PCI control register
	{PCICSR,	0x000003F8},		// 0x8c, alexsu : PCI control register, from Store&Foreward(0x398) to cut-through(0x380)
	{PWRCSR0,	0x3f3b3100},			// 0xC4
	{PSCSR2,	0x00023f20},			// 0xd4
	{PSCSR3,	0x00000002},			// 0xd4
	{PWRCSR1,	0x000001ff},			// 0xd8		
	{MACCSR0,	0x00213223},		// 0xE0, Enable	Tx dribble mode, 2003/10/22:Gary			
	{MACCSR1,	0x00235518},			// 0xE4, Disable Rx	Reset, tx dribble count, 2x30x16 = 960n,
	{MACCSR2,	0x00000040},			// 0x0134, 64*33ns = 2us
	{RALINKCSR,	0x9a009a11},			// 0xE8	
	{CSR7,		0xffffffff},			// 0x1C, Clear all pending interrupt source
	{LEDCSR,	0x0000FFFF},			 //	default	both LEDs off
	{BBPCSR1,	0x82188200},		// for 2560+2522
	{TXACKCSR0,	0x00000020},		// 0x110, TX ACK timeout in	usec
	{SECCSR3,	0x0000e78f},		// AES,	mask off more data bit for MIC calculation
};
		
#define	NUM_BBP_REG_PARMS	(sizeof(BBPRegTable) / sizeof(ULONG))
#define	NUM_MAC_REG_PARMS	(sizeof(MACRegTable) / sizeof(RTMP_REG_PAIR))

extern UCHAR	CipherSuiteWPAPSKTKIP[];
extern UCHAR	CipherSuiteWPAPSKTKIPLen;

static void* _va_data_start_addr;
static dma_addr_t _pa_data_start_addr;
	
/*
	========================================================================
	
	Routine	Description:
		Allocate all DMA releated resources

	Arguments:
		Adapter			Pointer	to our adapter

	Return Value:
		None

	Note:

	========================================================================
*/
NDIS_STATUS	RTMPAllocDMAMemory(
	IN	PRTMP_ADAPTER	pAd)
{
	INT				index;
	VOID			*ring;			// VA of ring descriptor
	VOID			*ring_data;		// VA of DMA data buffer
	dma_addr_t		ring_dma;		// PA of ring descriptor
	dma_addr_t		ring_data_dma;	// PA of DMA data buffer
	PTXD_STRUC		pTxD;			// Tx type ring	descriptor
	PRXD_STRUC		pRxD;			// Rx type ring	descriptor
	RXD_STRUC		RxD;   //tt_lin_big

	DBGPRINT(RT_DEBUG_INFO,	"--> RTMPAllocDMAMemory\n");

	// 1. Allocate Tx Ring DMA descriptor and buffer memory	
	// Allocate	Ring descriptors DMA block
	ring = pci_alloc_consistent(pAd->pPci_Dev, (TX_RING_SIZE * RING_DESCRIPTOR_SIZE), &ring_dma);
	if (!ring) {
		DBGPRINT(RT_DEBUG_ERROR, "Could	not	allocate DMA ring descriptor memory.\n");
		goto err_out_allocate_txring;
	}

	// Zero	init ring descriptors
	memset(ring, 0,	(TX_RING_SIZE *	RING_DESCRIPTOR_SIZE));
	
	// Allocate	Ring data DMA blocks
	ring_data =	pci_alloc_consistent(pAd->pPci_Dev,	(TX_RING_SIZE *	TX_BUFFER_SIZE), &ring_data_dma);
	
	// If failed, release ring descriptors DMA block & exit
	if (!ring_data)	{
		pci_free_consistent(pAd->pPci_Dev, (TX_RING_SIZE * RING_DESCRIPTOR_SIZE), ring,	ring_dma);
		DBGPRINT(RT_DEBUG_ERROR, "Could	not	allocate DMA ring buffer memory.\n");		
		goto err_out_allocate_txring;
	}

	// Start with Tx ring &	DMA	buffer
	for	(index = 0;	index <	TX_RING_SIZE; index++)
	{
		// Init	Tx Ring	Size, Va, Pa variables
		pAd->TxRing[index].size	= RING_DESCRIPTOR_SIZE;
		pAd->TxRing[index].va_addr = ring;//User data address
		pAd->TxRing[index].pa_addr = ring_dma; //BUS data address
		ring	 +=	RING_DESCRIPTOR_SIZE;
		ring_dma +=	RING_DESCRIPTOR_SIZE;
		
		// Init	Tx DMA buffer
		pAd->TxRing[index].data_size = TX_BUFFER_SIZE;
		pAd->TxRing[index].va_data_addr	= ring_data;//TX-desc
		pAd->TxRing[index].pa_data_addr	= ring_data_dma; //TX-data
		ring_data	  += TX_BUFFER_SIZE;
		ring_data_dma += TX_BUFFER_SIZE;
		
		// Write TxD buffer	address	& allocated	buffer length
		pTxD = (PTXD_STRUC)	pAd->TxRing[index].va_addr;
		pTxD->BufferAddressPa =	RTMP_CPU_TO_LE32(pAd->TxRing[index].pa_data_addr);//tt_lin_big

		DBGPRINT(RT_DEBUG_INFO,	"TxRing[%d]	va = 0x%x, pa =	0x%x, size = 0x%x\n",
			index, (UINT)pAd->TxRing[index].va_addr, (UINT)pAd->TxRing[index].pa_addr, pAd->TxRing[index].size);
		DBGPRINT(RT_DEBUG_INFO,	"TxRing[%d]	va_data	= 0x%x,	pa_data	= 0x%x,	size = 0x%x\n",
			index, (UINT)pAd->TxRing[index].va_data_addr, (UINT)pAd->TxRing[index].pa_data_addr, pAd->TxRing[index].data_size);
	}

	// 2. Allocate Prio	Ring DMA descriptor	and	buffer memory 
	// Allocate	Ring descriptors DMA block
	ring = pci_alloc_consistent(pAd->pPci_Dev, (PRIO_RING_SIZE * RING_DESCRIPTOR_SIZE),	&ring_dma);
	if (!ring) {
		DBGPRINT(RT_DEBUG_ERROR, "Could	not	allocate DMA ring descriptor memory.\n");
		goto err_out_allocate_prioring;
	}

	// Zero	init ring descriptors
	memset(ring, 0,	(PRIO_RING_SIZE	* RING_DESCRIPTOR_SIZE));
	
	// Allocate	Ring data DMA blocks
	ring_data =	pci_alloc_consistent(pAd->pPci_Dev,	(PRIO_RING_SIZE	* PRIO_BUFFER_SIZE), &ring_data_dma);
	
	// If failed, release ring descriptors DMA block & exit
	if (!ring_data)	{
		pci_free_consistent(pAd->pPci_Dev, (PRIO_RING_SIZE * RING_DESCRIPTOR_SIZE),	ring, ring_dma);
		DBGPRINT(RT_DEBUG_ERROR, "Could	not	allocate DMA ring buffer memory.\n");		
		goto err_out_allocate_prioring;
	}
	
	// Second with Prio	ring & DMA buffer
	for	(index = 0;	index <	PRIO_RING_SIZE;	index++)
	{
		// Init	Prio Ring Size,	Va,	Pa variables
		pAd->PrioRing[index].size =	RING_DESCRIPTOR_SIZE;
		pAd->PrioRing[index].va_addr = ring;
		pAd->PrioRing[index].pa_addr = ring_dma;
		ring	 +=	RING_DESCRIPTOR_SIZE;
		ring_dma +=	RING_DESCRIPTOR_SIZE;
		
		// Init	Prio DMA buffer
		pAd->PrioRing[index].data_size = PRIO_BUFFER_SIZE;
		pAd->PrioRing[index].va_data_addr =	ring_data;
		pAd->PrioRing[index].pa_data_addr =	ring_data_dma;
		ring_data	  += PRIO_BUFFER_SIZE;
		ring_data_dma += PRIO_BUFFER_SIZE;
		
		// Write TxD buffer	address	& allocated	buffer length for priority ring
		pTxD = (PTXD_STRUC)	pAd->PrioRing[index].va_addr;
		pTxD->BufferAddressPa =	RTMP_CPU_TO_LE32(pAd->PrioRing[index].pa_data_addr);//tt_lin_big
		
		DBGPRINT(RT_DEBUG_INFO,	"PrioRing[%d] va = 0x%x, pa	= 0x%x,	size = 0x%x\n",
			index, (UINT)pAd->PrioRing[index].va_addr, (UINT)pAd->PrioRing[index].pa_addr, pAd->PrioRing[index].size);
		DBGPRINT(RT_DEBUG_INFO,	"PrioRing[%d] va_data =	0x%x, pa_data =	0x%x, size = 0x%x\n",
			index, (UINT)pAd->PrioRing[index].va_data_addr,	(UINT)pAd->PrioRing[index].pa_data_addr, pAd->PrioRing[index].data_size);
	}

	// 3. Allocate Atim	Ring DMA descriptor	and	buffer memory 
	// Allocate	Ring descriptors DMA block
	ring = pci_alloc_consistent(pAd->pPci_Dev, (ATIM_RING_SIZE * RING_DESCRIPTOR_SIZE),	&ring_dma);
	if (!ring) {
		DBGPRINT(RT_DEBUG_ERROR, "Could	not	allocate DMA ring descriptor memory.\n");
		goto err_out_allocate_atimring;
	}

	// Zero	init ring descriptors
	memset(ring, 0,	(ATIM_RING_SIZE	* RING_DESCRIPTOR_SIZE));
	
	// Allocate	Ring data DMA blocks
	ring_data =	pci_alloc_consistent(pAd->pPci_Dev,	(ATIM_RING_SIZE	* ATIM_BUFFER_SIZE), &ring_data_dma);
	
	// If failed, release ring descriptors DMA block & exit
	if (!ring_data)	{
		pci_free_consistent(pAd->pPci_Dev, (ATIM_RING_SIZE * RING_DESCRIPTOR_SIZE),	ring, ring_dma);
		DBGPRINT(RT_DEBUG_ERROR, "Could	not	allocate DMA ring buffer memory.\n");		
		goto err_out_allocate_atimring;
	}
	
	// Atim	ring & DMA buffer
	for	(index = 0;	index <	ATIM_RING_SIZE;	index++)
	{
		// Init	Atim Ring Size,	Va,	Pa variables
		pAd->AtimRing[index].size =	RING_DESCRIPTOR_SIZE;
		pAd->AtimRing[index].va_addr = ring;
		pAd->AtimRing[index].pa_addr = ring_dma;
		ring	 +=	RING_DESCRIPTOR_SIZE;
		ring_dma +=	RING_DESCRIPTOR_SIZE;
		
		// Init	Atim DMA buffer
		pAd->AtimRing[index].data_size = ATIM_BUFFER_SIZE;
		pAd->AtimRing[index].va_data_addr =	ring_data;
		pAd->AtimRing[index].pa_data_addr =	ring_data_dma;
		ring_data	  += ATIM_BUFFER_SIZE;
		ring_data_dma += ATIM_BUFFER_SIZE;
		
		// Write TxD buffer	address	& allocated	buffer length
		pTxD = (PTXD_STRUC)	pAd->AtimRing[index].va_addr;
		pTxD->BufferAddressPa =	RTMP_CPU_TO_LE32(pAd->AtimRing[index].pa_data_addr);//ttl_lin_big

		DBGPRINT(RT_DEBUG_INFO,	"AtimRing[%d] va = 0x%x, pa	= 0x%x,	size = 0x%x\n",
			index, (UINT)pAd->AtimRing[index].va_addr, (UINT)pAd->AtimRing[index].pa_addr, pAd->AtimRing[index].size);
		DBGPRINT(RT_DEBUG_INFO,	"AtimRing[%d] va_data =	0x%x, pa_data =	0x%x, size = 0x%x\n",
			index, (UINT)pAd->AtimRing[index].va_data_addr,	(UINT)pAd->AtimRing[index].pa_data_addr, pAd->AtimRing[index].data_size);
	}

	// 4. Allocate Rx Ring DMA descriptor and buffer memory
	// Allocate	Ring descriptors DMA block
	ring = pci_alloc_consistent(pAd->pPci_Dev, (RX_RING_SIZE * RING_DESCRIPTOR_SIZE), &ring_dma);
	if (!ring) {
		DBGPRINT(RT_DEBUG_ERROR, "Could	not	allocate DMA ring descriptor memory.\n");
		goto err_out_allocate_rxring;
	}

	// Zero	init ring descriptors
	memset(ring, 0,	(RX_RING_SIZE *	RING_DESCRIPTOR_SIZE));
	
	// Allocate	Ring data DMA blocks
	ring_data =	pci_alloc_consistent(pAd->pPci_Dev,	(RX_RING_SIZE *	RX_BUFFER_SIZE + MAX_LEN_OF_MLME_QUEUE/*add	by tt_lin_perf*/), &ring_data_dma);
	
	// If failed, release ring descriptors DMA block & exit
	if (!ring_data)	{
		pci_free_consistent(pAd->pPci_Dev, (RX_RING_SIZE * RING_DESCRIPTOR_SIZE), ring,	ring_dma);
		DBGPRINT(RT_DEBUG_ERROR, "Could	not	allocate DMA ring buffer memory.\n");		
		goto err_out_allocate_rxring;
	}
	//Save the start address for release memory
	_va_data_start_addr	= ring_data;
	_pa_data_start_addr	= ring_data_dma;
	// Rx ring & DMA buffer
	for	(index = 0;	index <	RX_RING_SIZE; index++)
	{
		// Init	Rx Ring	Size, Va, Pa variables
		pAd->RxRing[index].size	= RING_DESCRIPTOR_SIZE;
		pAd->RxRing[index].va_addr = ring;
		pAd->RxRing[index].pa_addr = ring_dma;
		ring	 +=	RING_DESCRIPTOR_SIZE;
		ring_dma +=	RING_DESCRIPTOR_SIZE;
		
		// Init	Rx DMA buffer
		pAd->RxRing[index].data_size = RX_BUFFER_SIZE;
		pAd->RxRing[index].va_data_addr	= ring_data;
		pAd->RxRing[index].pa_data_addr	= ring_data_dma;
		ring_data	  += RX_BUFFER_SIZE;
		ring_data_dma += RX_BUFFER_SIZE;
		
		// Write RxD buffer	address	& allocated	buffer length
		pRxD = (PRXD_STRUC)	pAd->RxRing[index].va_addr;
		pRxD->BufferAddressPa =	RTMP_CPU_TO_LE32(pAd->RxRing[index].pa_data_addr);//tt_lin_big
		//n
		// Rx owner	bit	assign to NIC immediately
		*(PULONG)&RxD =	RTMP_LE32_TO_CPU( *(PULONG)pRxD	);
		RxD.Owner =	DESC_OWN_NIC; //w0
		*(PULONG)pRxD =	RTMP_CPU_TO_LE32( *(PULONG)&RxD	); //tt_lin_big

		DBGPRINT(RT_DEBUG_INFO,	"RxRing[%d]	va = 0x%x, pa =	0x%x, size = 0x%x\n",
			index, (UINT)pAd->RxRing[index].va_addr, (UINT)pAd->RxRing[index].pa_addr, pAd->RxRing[index].size);
		DBGPRINT(RT_DEBUG_INFO,	"RxRing[%d]	va_data	= 0x%x,	pa_data	= 0x%x,	size = 0x%x\n",
			index, (UINT)pAd->RxRing[index].va_data_addr, (UINT)pAd->RxRing[index].pa_data_addr, pAd->RxRing[index].data_size);
	}
	//Init MLME	Query (tt_lin)
	for(index =	0; index < MAX_LEN_OF_MLME_QUEUE; index++)
	{
		pAd->Mlme.Queue.Entry[index].pMsg =	ring_data;
		pAd->Mlme.Queue.Entry[index].pa_data_addr =	ring_data_dma;
		ring_data	  += RX_BUFFER_SIZE;
		ring_data_dma += RX_BUFFER_SIZE;
	}

	// 5. Allocate Beacon Ring DMA descriptor and buffer memory
	// Init	Beacon Ring	Size, Va, Pa variables
	ring = pci_alloc_consistent(pAd->pPci_Dev, RING_DESCRIPTOR_SIZE, &ring_dma);
	if (!ring) {
		DBGPRINT(RT_DEBUG_ERROR, "Could	not	allocate DMA ring descriptor memory.\n");
		goto err_out_allocate_beaconring;
	}

	// Zero	init ring descriptors
	memset(ring, 0,	(RING_DESCRIPTOR_SIZE));
	
	// Allocate	Ring data DMA blocks
	ring_data =	pci_alloc_consistent(pAd->pPci_Dev,	BEACON_BUFFER_SIZE,	&ring_data_dma);
	
	// If failed, release ring descriptors DMA block & exit
	if (!ring_data)	{
		pci_free_consistent(pAd->pPci_Dev, RING_DESCRIPTOR_SIZE, ring, ring_dma);
		DBGPRINT(RT_DEBUG_ERROR, "Could	not	allocate DMA ring buffer memory.\n");		
		goto err_out_allocate_beaconring;
	}
	
	pAd->BeaconRing.size = RING_DESCRIPTOR_SIZE;
	pAd->BeaconRing.va_addr	= ring;
	pAd->BeaconRing.pa_addr	= ring_dma;
		
	// Init	Beacon DMA buffer
	pAd->BeaconRing.data_size =	BEACON_BUFFER_SIZE;
	pAd->BeaconRing.va_data_addr = ring_data;
	pAd->BeaconRing.pa_data_addr = ring_data_dma;
		
	// Write RxD buffer	address	& allocated	buffer length
	pTxD = (PTXD_STRUC)	pAd->BeaconRing.va_addr;
	pTxD->BufferAddressPa =	RTMP_CPU_TO_LE32(pAd->BeaconRing.pa_data_addr);//tt_lin_big

	DBGPRINT(RT_DEBUG_INFO,	"BeaconRing	va = 0x%x, pa =	0x%x, size = 0x%x\n",
			(UINT)pAd->BeaconRing.va_addr, (UINT)pAd->BeaconRing.pa_addr, pAd->BeaconRing.size);
	DBGPRINT(RT_DEBUG_INFO,	"BeaconRing	va_data	= 0x%x,	pa_data	= 0x%x,	size = 0x%x\n",
			(UINT)pAd->BeaconRing.va_data_addr,	(UINT)pAd->BeaconRing.pa_data_addr,	pAd->BeaconRing.data_size);

	DBGPRINT(RT_DEBUG_INFO,	"<-- RTMPAllocDMAMemory\n");
	return 0;


err_out_allocate_beaconring:
	// Free	data DMA blocks	first, the start address is	the	same as	TxRing first DMA data block
	pci_free_consistent(pAd->pPci_Dev, (RX_RING_SIZE * RX_BUFFER_SIZE),	
		pAd->RxRing[0].va_data_addr, pAd->RxRing[0].pa_data_addr);
	// Free	ring descriptor	second,	the	start address is the same as TxRing	first elment
	pci_free_consistent(pAd->pPci_Dev, (RX_RING_SIZE * RING_DESCRIPTOR_SIZE),
		pAd->RxRing[0].va_addr,	pAd->RxRing[0].pa_addr);
err_out_allocate_rxring:
	// Free	data DMA blocks	first, the start address is	the	same as	TxRing first DMA data block
	pci_free_consistent(pAd->pPci_Dev, (ATIM_RING_SIZE * ATIM_BUFFER_SIZE),	
		pAd->AtimRing[0].va_data_addr, pAd->AtimRing[0].pa_data_addr);
	// Free	ring descriptor	second,	the	start address is the same as TxRing	first elment
	pci_free_consistent(pAd->pPci_Dev, (ATIM_RING_SIZE * RING_DESCRIPTOR_SIZE),
		pAd->AtimRing[0].va_addr, pAd->AtimRing[0].pa_addr);
err_out_allocate_atimring:
	// Free	data DMA blocks	first, the start address is	the	same as	TxRing first DMA data block
	pci_free_consistent(pAd->pPci_Dev, (PRIO_RING_SIZE * PRIO_BUFFER_SIZE),	
		pAd->PrioRing[0].va_data_addr, pAd->PrioRing[0].pa_data_addr);
	// Free	ring descriptor	second,	the	start address is the same as TxRing	first elment
	pci_free_consistent(pAd->pPci_Dev, (PRIO_RING_SIZE * RING_DESCRIPTOR_SIZE),
		pAd->PrioRing[0].va_addr, pAd->PrioRing[0].pa_addr);
err_out_allocate_prioring:
	// Free	data DMA blocks	first, the start address is	the	same as	TxRing first DMA data block
	pci_free_consistent(pAd->pPci_Dev, (TX_RING_SIZE * TX_BUFFER_SIZE),	
		pAd->TxRing[0].va_data_addr, pAd->TxRing[0].pa_data_addr);
	// Free	ring descriptor	second,	the	start address is the same as TxRing	first elment
	pci_free_consistent(pAd->pPci_Dev, (TX_RING_SIZE * RING_DESCRIPTOR_SIZE),
		pAd->TxRing[0].va_addr,	pAd->TxRing[0].pa_addr);
err_out_allocate_txring:
	DBGPRINT(RT_DEBUG_ERROR, "<-- RTMPAllocDMAMemory (memory not allocate successfully!)\n");
	return -ENOMEM;
}

/*
	========================================================================
	
	Routine	Description:
		Free all DMA memory.

	Arguments:
		Adapter			Pointer	to our adapter

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	RTMPFreeDMAMemory(
	IN	PRTMP_ADAPTER	pAd)
{

	DBGPRINT(RT_DEBUG_INFO,	"--> RTMPFreeDMAMemory\n");

	// Free	data DMA blocks	first, the start address is	the	same as	TxRing first DMA data block
	pci_free_consistent(pAd->pPci_Dev, (TX_RING_SIZE * TX_BUFFER_SIZE),	
		pAd->TxRing[0].va_data_addr, pAd->TxRing[0].pa_data_addr);
	// Free	ring descriptor	second,	the	start address is the same as TxRing	first elment
	pci_free_consistent(pAd->pPci_Dev, (TX_RING_SIZE * RING_DESCRIPTOR_SIZE),
		pAd->TxRing[0].va_addr,	pAd->TxRing[0].pa_addr);

	// Free	data DMA blocks	first, the start address is	the	same as	TxRing first DMA data block
	pci_free_consistent(pAd->pPci_Dev, (PRIO_RING_SIZE * PRIO_BUFFER_SIZE),	
		pAd->PrioRing[0].va_data_addr, pAd->PrioRing[0].pa_data_addr);
	// Free	ring descriptor	second,	the	start address is the same as TxRing	first elment
	pci_free_consistent(pAd->pPci_Dev, (PRIO_RING_SIZE * RING_DESCRIPTOR_SIZE),
		pAd->PrioRing[0].va_addr, pAd->PrioRing[0].pa_addr);

	// Free	data DMA blocks	first, the start address is	the	same as	TxRing first DMA data block
	pci_free_consistent(pAd->pPci_Dev, (ATIM_RING_SIZE * ATIM_BUFFER_SIZE),	
		pAd->AtimRing[0].va_data_addr, pAd->AtimRing[0].pa_data_addr);
	// Free	ring descriptor	second,	the	start address is the same as TxRing	first elment
	pci_free_consistent(pAd->pPci_Dev, (ATIM_RING_SIZE * RING_DESCRIPTOR_SIZE),
		pAd->AtimRing[0].va_addr, pAd->AtimRing[0].pa_addr);
	
	// Free	data DMA blocks	first, the start address is	the	same as	TxRing first DMA data block
	pci_free_consistent(pAd->pPci_Dev, (RX_RING_SIZE * RX_BUFFER_SIZE+MAX_LEN_OF_MLME_QUEUE), 
		_va_data_start_addr, _pa_data_start_addr);
	// Free	ring descriptor	second,	the	start address is the same as TxRing	first elment
	pci_free_consistent(pAd->pPci_Dev, (RX_RING_SIZE * RING_DESCRIPTOR_SIZE),
		pAd->RxRing[0].va_addr,	pAd->RxRing[0].pa_addr);

	// Free	data DMA blocks	first, the start address is	the	same as	TxRing first DMA data block
	pci_free_consistent(pAd->pPci_Dev, (BEACON_RING_SIZE * BEACON_BUFFER_SIZE),	
		pAd->BeaconRing.va_data_addr, pAd->BeaconRing.pa_data_addr);
	// Free	ring descriptor	second,	the	start address is the same as TxRing	first elment
	pci_free_consistent(pAd->pPci_Dev, (BEACON_RING_SIZE * RING_DESCRIPTOR_SIZE),
		pAd->BeaconRing.va_addr, pAd->BeaconRing.pa_addr);
	
}

/*
	========================================================================
	
	Routine	Description:
		Initialize transmit	data structures

	Arguments:
		Adapter						Pointer	to our adapter

	Return Value:
		None

	Note:
		Initialize all transmit	releated private buffer, include those define
		in RTMP_ADAPTER	structure and all private data structures.
		
	========================================================================
*/
VOID	NICInitTransmit(
	IN	PRTMP_ADAPTER	pAdapter)
{
	DBGPRINT(RT_DEBUG_TRACE, "--> NICInitTransmit\n");

	// Initialize all Transmit releated	queues
	InitializeQueueHeader(&pAdapter->TxSwQueue0);
	InitializeQueueHeader(&pAdapter->TxSwQueue1);
	InitializeQueueHeader(&pAdapter->TxSwQueue2);
	InitializeQueueHeader(&pAdapter->TxSwQueue3);
	
	// Init	Ring index pointer
	pAdapter->CurRxIndex		  =	0;
	pAdapter->CurDecryptIndex	   = 0;
	pAdapter->CurTxIndex		  =	0;
	pAdapter->CurEncryptIndex	   = 0;
	pAdapter->CurAtimIndex		  =	0;
	pAdapter->CurPrioIndex		  =	0;
	pAdapter->NextEncryptDoneIndex = 0;
	pAdapter->NextTxDoneIndex	  =	0;
	pAdapter->NextAtimDoneIndex	  =	0;
	pAdapter->NextPrioDoneIndex	  =	0;
	pAdapter->NextDecryptDoneIndex = 0;
	pAdapter->PushMgmtIndex		  =	0;
	pAdapter->PopMgmtIndex		  =	0;
	pAdapter->MgmtQueueSize		  =	0;
	
	pAdapter->PrivateInfo.TxRingFullCnt		  =	0;
	
	DBGPRINT(RT_DEBUG_TRACE, "<-- NICInitTransmit\n");
}

inline	VOID	NICDisableInterrupt(
	IN	PRTMP_ADAPTER	pAd)
{
	RTMP_IO_WRITE32(pAd, CSR8, 0xFFFF);
	RTMP_CLEAR_FLAG(pAd, fRTMP_ADAPTER_INTERRUPT_ACTIVE);
}

inline	VOID	NICEnableInterrupt(
	IN	PRTMP_ADAPTER	pAd)
{
	// 0xFF37 :	Txdone & Rxdone, 0xFF07: Txdonw, Rxdone, PrioDone, AtimDone,
	RTMP_IO_WRITE32(pAd, CSR8, 0xFE16);		
	RTMP_SET_FLAG(pAd, fRTMP_ADAPTER_INTERRUPT_ACTIVE);
}

/*
	========================================================================
	
	Routine	Description:
		Read additional	information	from EEPROM, such as MAC address

	Arguments:
		Adapter						Pointer	to our adapter

	Return Value:
		NDIS_STATUS_SUCCESS
		NDIS_STATUS_FAILURE

	Note:
	
	========================================================================
*/
NDIS_STATUS	NICReadAdapterInfo(
	IN	PRTMP_ADAPTER		pAd)
{
	CSR3_STRUC		StaMacReg0;
	CSR4_STRUC		StaMacReg1;
	NDIS_STATUS		Status = NDIS_STATUS_SUCCESS;

	// 
	// Read	MAC	address	from CSR3 &	CSR4, these	CSRs reflects real value
	// stored with EEPROM.
	//
	RTMP_IO_READ32(pAd,	CSR3, &StaMacReg0.word);
	RTMP_IO_READ32(pAd,	CSR4, &StaMacReg1.word);
	pAd->PermanentAddress[0] = StaMacReg0.field.Byte0;
	pAd->PermanentAddress[1] = StaMacReg0.field.Byte1;
	pAd->PermanentAddress[2] = StaMacReg0.field.Byte2;
	pAd->PermanentAddress[3] = StaMacReg0.field.Byte3;
	pAd->PermanentAddress[4] = StaMacReg1.field.Byte4;
	pAd->PermanentAddress[5] = StaMacReg1.field.Byte5;
	// Set Current address to permanet address.
	// TODO: put current address check within registery	read out
	pAd->CurrentAddress[0] = pAd->PermanentAddress[0];
	pAd->CurrentAddress[1] = pAd->PermanentAddress[1];
	pAd->CurrentAddress[2] = pAd->PermanentAddress[2];
	pAd->CurrentAddress[3] = pAd->PermanentAddress[3];
	pAd->CurrentAddress[4] = pAd->PermanentAddress[4];
	pAd->CurrentAddress[5] = pAd->PermanentAddress[5];

	return Status;
}

/*
	========================================================================
	
	Routine	Description:
		Read initial parameters	from EEPROM
		
	Arguments:
		Adapter						Pointer	to our adapter

	Return Value:
		None

	Note:
		
	========================================================================
*/
VOID	NICReadEEPROMParameters(
	IN	PRTMP_ADAPTER	pAdapter)
{
	ULONG			data;
	USHORT			i, value;
	EEPROM_TX_PWR_STRUC	Power;
	EEPROM_VERSION_STRUC	Version;

	DBGPRINT(RT_DEBUG_TRACE, "--> NICReadEEPROMParameters\n");

	// Init	EEPROM Address Number, before access EEPROM; if	93c46, EEPROMAddressNum=6, else	if 93c66, EEPROMAddressNum=8
	RTMP_IO_READ32(pAdapter, CSR21,	&data);

	if(data	& 0x20)
		pAdapter->EEPROMAddressNum = 6;		
	else
		pAdapter->EEPROMAddressNum = 8;

	// if E2PROM version mismatch with driver's	expectation, then skip
	// all subsequent E2RPOM retieval and set a	system error bit to	notify GUI
	Version.word = RTMP_EEPROM_READ16(pAdapter,	EEPROM_VERSION_OFFSET);
	if (Version.field.Version != VALID_EEPROM_VERSION)
	{
		DBGPRINT(RT_DEBUG_ERROR, "*****	WRONG E2PROM VERSION %d, should	be %d\n",Version.field.Version,	VALID_EEPROM_VERSION);
		pAdapter->PortCfg.SystemErrorBitmap	|= 0x00000001;
		return;
	}

	// Read	BBP	default	value from EEPROM and store	to array(EEPROMDefaultValue) in	pAdapter
	for(i =	0; i < NUM_EEPROM_BBP_PARMS; i++)
	{
		value =	RTMP_EEPROM_READ16(pAdapter, EEPROM_BBP_BASE_OFFSET	+ i*2);
		
		pAdapter->EEPROMDefaultValue[i]	= value;
	}

#if	1
	// Read	Tx power value for all 14 channels
	// Value from 1	- 0x7f.	Default	value is 0x27.
	for	(i = 0;	i <	NUM_EEPROM_TX_PARMS; i++)
	{
		Power.word = RTMP_EEPROM_READ16(pAdapter, EEPROM_TX_PWR_OFFSET + i*2);
		pAdapter->PortCfg.ChannelTxPower[i * 2]		= ((Power.field.Byte0 >	32)	? 24 : Power.field.Byte0);
		pAdapter->PortCfg.ChannelTxPower[i * 2 + 1]	= ((Power.field.Byte1 >	32)	? 24 : Power.field.Byte1);
	}
#endif	

	//CountryRegion	byte offset	= 0x35
	value =	pAdapter->EEPROMDefaultValue[2]	>> 8;
	if ((value <= 7))
	{
		 pAdapter->PortCfg.CountryRegion = (UCHAR) value;
	}
	DBGPRINT(RT_DEBUG_TRACE, "<-- NICReadEEPROMParameters\n");
}

/*
	========================================================================
	
	Routine	Description:
		Set	default	value from EEPROM
		
	Arguments:
		Adapter						Pointer	to our adapter

	Return Value:
		None

	Note:
		
	========================================================================
*/
VOID	NICInitAsicFromEEPROM(
	IN	PRTMP_ADAPTER	pAdapter)
{
	ULONG					data, BbpCsr1;
	USHORT					i, value;
	UCHAR					TxValue,RxValue;
	EEPROM_ANTENNA_STRUC	Antenna;
	EEPROM_NIC_CONFIG2_STRUC	NicConfig2;

	DBGPRINT(RT_DEBUG_TRACE, "--> NICInitAsicFromEEPROM\n");
	
	for(i =	3; i < NUM_EEPROM_BBP_PARMS; i++)
	{
		value =	pAdapter->EEPROMDefaultValue[i];
		
		if((value != 0xFFFF) &&	(value != 0))
		{
			data = value | 0x18000;
			RTMP_BBP_IO_WRITE32(pAdapter, data);
		}
	}

	Antenna.word = pAdapter->EEPROMDefaultValue[0];

	if ((Antenna.word == 0xFFFF) ||	(Antenna.field.TxDefaultAntenna	> 2) ||	(Antenna.field.RxDefaultAntenna	> 2))
	{
		DBGPRINT(RT_DEBUG_TRACE, "E2PROM error(=0x%04x), hard code as 0x0016\n", Antenna.word);
		Antenna.word = 0x0016;
	}

	pAdapter->PortCfg.NumberOfAntenna =	2;	// (UCHAR)Antenna.field.NumOfAntenna;
	pAdapter->PortCfg.CurrentTxAntenna = (UCHAR)Antenna.field.TxDefaultAntenna;
	pAdapter->PortCfg.CurrentRxAntenna = (UCHAR)Antenna.field.RxDefaultAntenna;

	RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Tx_Configure, &TxValue);
	RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Rx_Configure, &RxValue);
	RTMP_IO_READ32(pAdapter, BBPCSR1, &BbpCsr1);

		// Tx antenna select
	if(Antenna.field.TxDefaultAntenna == 1)	  
	{
		TxValue	= (TxValue & 0xFC) | 0x00; // Antenna A
		BbpCsr1	= (BbpCsr1 & 0xFFFCFFFC) | 0x00000000;
	}
	else if(Antenna.field.TxDefaultAntenna == 2)
	{
		TxValue	= (TxValue & 0xFC) | 0x02; // Antenna B
		BbpCsr1	= (BbpCsr1 & 0xFFFCFFFC) | 0x00020002;
	}
	else
	{
		TxValue	= (TxValue & 0xFC) | 0x01; // Antenna Diversity
		BbpCsr1	= (BbpCsr1 & 0xFFFCFFFC) | 0x00010001;
	}
	RTMP_IO_WRITE32(pAdapter, BBPCSR1, BbpCsr1);

	// Rx antenna select
	if(Antenna.field.RxDefaultAntenna == 1)
		RxValue	= (RxValue & 0xFC) | 0x00; // Antenna A
		else if(Antenna.field.RxDefaultAntenna == 2)
		RxValue	= (RxValue & 0xFC) | 0x02; // Antenna B
	else
		RxValue	= (RxValue & 0xFC) | 0x01; // Antenna Diversity
			
	// Change to match microsoft definition, 0xff: diversity, 0: A,	1: B
	pAdapter->PortCfg.CurrentTxAntenna--;
	pAdapter->PortCfg.CurrentRxAntenna--;
		
	RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter,	BBP_Tx_Configure, TxValue);
#if	0
	RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter,	BBP_Rx_Configure, RxValue);
#else
	// 2003-12-16 software-based RX	antenna	diversity
	// pAdapter->PortCfg.CurrentRxAntenna =	0xff;	// Diversity ON
	AsicSetRxAnt(pAdapter);
#endif

	pAdapter->PortCfg.RfType = (UCHAR) Antenna.field.RfType;
		
	if (Antenna.field.LedMode == LED_MODE_TXRX_ACTIVITY)
		pAdapter->PortCfg.LedMode =	LED_MODE_TXRX_ACTIVITY;
	else if	(Antenna.field.LedMode == LED_MODE_SINGLE)
	{
		pAdapter->PortCfg.LedMode =	LED_MODE_SINGLE;
		ASIC_LED_ACT_ON(pAdapter);
	}
	else if	(Antenna.field.LedMode == LED_MODE_ASUS)
	{
		pAdapter->PortCfg.LedMode =	LED_MODE_ASUS;
		RTMP_IO_WRITE32(pAdapter, LEDCSR, 0x0002FFFF);
	}
	else			
		pAdapter->PortCfg.LedMode =	LED_MODE_DEFAULT;

	NicConfig2.word	= pAdapter->EEPROMDefaultValue[1];
	if (NicConfig2.word	== 0xffff)
		NicConfig2.word	= 0;	// empty E2PROM, use default
	
	// for dynamic BBP R17:RX sensibity	tuning
	{
		UCHAR r17;
		RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, 17, &r17);
		pAdapter->PortCfg.BbpTuningEnable =	(NicConfig2.field.DynamicBbpTuning==0)?	1:0;
		pAdapter->PortCfg.VgcLowerBound	  =	r17;
		DBGPRINT(RT_DEBUG_TRACE,"R17 tuning	enable=%d, R17=LowerBound=0x%02x\n",pAdapter->PortCfg.BbpTuningEnable, r17);
	}

	DBGPRINT(RT_DEBUG_TRACE, "RF IC=%d,	LED	mode=%d\n",	pAdapter->PortCfg.RfType, pAdapter->PortCfg.LedMode);
	DBGPRINT(RT_DEBUG_TRACE, "<-- NICInitAsicFromEEPROM\n");
}

void NICInitializeAdapter(IN	PRTMP_ADAPTER	pAdapter)
{
	TXCSR2_STRUC	TxCSR2;
	RXCSR1_STRUC	RxCSR1;
	ULONG			Value;

	DBGPRINT(RT_DEBUG_TRACE, "--> NICInitializeAdapter\n");

	// Init	spin locks
	NdisAllocateSpinLock(&pAdapter->TxRingLock);
	NdisAllocateSpinLock(&pAdapter->PrioRingLock);
	NdisAllocateSpinLock(&pAdapter->AtimRingLock);
	NdisAllocateSpinLock(&pAdapter->RxRingLock);
	NdisAllocateSpinLock(&pAdapter->TxSwQueueLock);

	// Write TXCSR2	register
	TxCSR2.field.TxDSize = RING_DESCRIPTOR_SIZE;
	TxCSR2.field.NumTxD	 = TX_RING_SIZE;
	TxCSR2.field.NumAtimD  = ATIM_RING_SIZE;
	TxCSR2.field.NumPrioD  = PRIO_RING_SIZE;	
	RTMP_IO_WRITE32(pAdapter, TXCSR2, TxCSR2.word);

	// Write TXCSR3	register
	Value =	pAdapter->TxRing[0].pa_addr;
	RTMP_IO_WRITE32(pAdapter, TX_RING_BASE_REG,	Value);
	
	// Write TXCSR4	register
	Value =	pAdapter->PrioRing[0].pa_addr;
	RTMP_IO_WRITE32(pAdapter, PRIO_RING_BASE_REG, Value);
	
	// Write TXCSR5	register
	Value =	pAdapter->AtimRing[0].pa_addr;
	RTMP_IO_WRITE32(pAdapter, ATIM_RING_BASE_REG, Value);

	// Write TXCSR6	register
	Value =	pAdapter->BeaconRing.pa_addr;
	RTMP_IO_WRITE32(pAdapter, BEACON_BASE_REG, Value);

	// Write RXCSR1	register
	RxCSR1.field.RxDSize = RING_DESCRIPTOR_SIZE;
	RxCSR1.field.NumRxD	 = RX_RING_SIZE;
	RTMP_IO_WRITE32(pAdapter, RXCSR1, RxCSR1.word);
	
	// Write RXCSR2	register
	Value =	pAdapter->RxRing[0].pa_addr;
	RTMP_IO_WRITE32(pAdapter, RX_RING_BASE_REG,	Value);

	// Write CSR1 for host ready
	// Move	Host reay to end of	ASIC initialization	
	// to ensure no	Rx will	perform	before ASIC	init
	// RTMP_IO_WRITE32(pAdapter, CSR1, 0x4);

	// Initialze ASIC for TX & Rx operation
	NICInitializeAsic(pAdapter);
	
	DBGPRINT(RT_DEBUG_TRACE, "<-- NICInitializeAdapter\n");
}	

void	NICInitializeAsic(IN	PRTMP_ADAPTER	pAdapter)
{
	ULONG			Index;
	UCHAR			Value =	0xff;

	DBGPRINT(RT_DEBUG_TRACE, "--> NICInitializeAsic\n");

	// Initialize MAC register to default value
	for	(Index = 0;	Index <	NUM_MAC_REG_PARMS; Index++)
	{
		RTMP_IO_WRITE32(pAdapter, MACRegTable[Index].Register, MACRegTable[Index].Value);
	}

	// Set Host	ready before kicking Rx
	RTMP_IO_WRITE32(pAdapter, CSR1,	0x1); // reset MAC state machine, requested	by Kevin 2003-2-11
	RTMP_IO_WRITE32(pAdapter, CSR1,	0x4);

	// Read	BBP	register, make sure	BBP	is up and running before write new data
	while ((Value == 0xff) || (Value ==	0x00))
	{
		RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Version,	&Value);
		DBGPRINT(RT_DEBUG_TRACE, "BBP version =	%d\n", Value);
	}
		
	// Initialize BBP register to default value
	for	(Index = 0;	Index <	NUM_BBP_REG_PARMS; Index++)
	{
		RTMP_BBP_IO_WRITE32(pAdapter, BBPRegTable[Index]);
	}

	// Initialize RF register to default value
	AsicSwitchChannel(pAdapter,	pAdapter->PortCfg.Channel);
	AsicLockChannel(pAdapter, pAdapter->PortCfg.Channel);

	// Kick	Rx
	RTMP_IO_WRITE32(pAdapter, RXCSR0, 0x56);
	// Clear old FCS jitter	before init	ASIC
	RTMP_IO_READ32(pAdapter, CNT0, &Index);
	// Clear old Rx	FIFO error jitter before init ASIC
	RTMP_IO_READ32(pAdapter, CNT4, &Index);

	DBGPRINT(RT_DEBUG_TRACE, "<-- NICInitializeAsic\n");
}

/*
	========================================================================
	
	Routine	Description:
		Reset NIC Asics

	Arguments:
		Adapter						Pointer	to our adapter

	Return Value:
		None

	Note:
		Reset NIC to initial state AS IS system	boot up	time.
		
	========================================================================
*/
VOID	NICIssueReset(
	IN	PRTMP_ADAPTER	pAdapter)
{
	CSR3_STRUC		StaMacReg0;
	CSR4_STRUC		StaMacReg1;

	DBGPRINT(RT_DEBUG_TRACE, "--> NICIssueReset\n");

	// Abort Tx, prevent ASIC from writing to Host memory
	RTMP_IO_WRITE32(pAdapter, TXCSR0, 0x08);
	
	// Disable Rx, register	value supposed will	remain after reset
	RTMP_IO_WRITE32(pAdapter, RXCSR0, 0x67f);

	if (pAdapter->PortCfg.bLocalAdminMAC)
	{
		// Write Back Permanent	MAC	address	to CSR3	& CSR4
		StaMacReg0.field.Byte0 = pAdapter->PermanentAddress[0];
		StaMacReg0.field.Byte1 = pAdapter->PermanentAddress[1];
		StaMacReg0.field.Byte2 = pAdapter->PermanentAddress[2];
		StaMacReg0.field.Byte3 = pAdapter->PermanentAddress[3];
		StaMacReg1.field.Byte4 = pAdapter->PermanentAddress[4];
		StaMacReg1.field.Byte5 = pAdapter->PermanentAddress[5];		
		RTMP_IO_WRITE32(pAdapter, CSR3,	StaMacReg0.word);
		RTMP_IO_WRITE32(pAdapter, CSR4,	StaMacReg1.word);
	}
	
	// Issue reset and clear from reset	state
	RTMP_IO_WRITE32(pAdapter, CSR1,	0x01);
	RTMP_IO_WRITE32(pAdapter, CSR1,	0x00);

	DBGPRINT(RT_DEBUG_TRACE, "<-- NICIssueReset\n");
}

/*
	========================================================================
	
	Routine	Description:
		Check ASIC registers and find any reason the system	might hang

	Arguments:
		Adapter						Pointer	to our adapter

	Return Value:
		None

	Note:
		
		
	========================================================================
*/
BOOLEAN	NICCheckForHang(
	IN	PRTMP_ADAPTER	pAd)
{
	ULONG	Value/*, OldValue*/;

	// Update FCS counters
	RTMP_IO_READ32(pAd,	CNT0, &Value);
	pAd->WlanCounters.FCSErrorCount	+= Value;
	
	// Update RxNoBuffer counters
	RTMP_IO_READ32(pAd,	CNT4, &Value);
	pAd->Counters.RxNoBuffer +=	Value;
#if	0
	// Read	CCA	error count
	RTMP_IO_READ32(pAd,	CNT3, &Value);
	pAd->PrivateInfo.CCAErrCnt = (Value	& 0x0000ffff);
	DBGPRINT(RT_DEBUG_INFO,	"CCA error count ->	0x%x\n", pAd->PrivateInfo.CCAErrCnt);
#endif
	// Read	PLCP error count
	RTMP_IO_READ32(pAd,	CNT1, &Value);
	pAd->PrivateInfo.PhyRxErrCnt = (Value &	0x0000ffff);
	DBGPRINT(RT_DEBUG_INFO,	"PHY Rx	error count	-> 0x%x\n",	pAd->PrivateInfo.PhyRxErrCnt);
	
	pAd->PrivateInfo.PhyTxErrCnt = (Value &	0xffff0000)	>> 16;
	DBGPRINT(RT_DEBUG_INFO,	"PHY Tx	error count	-> 0x%x\n",	pAd->PrivateInfo.PhyTxErrCnt);

	return (FALSE);
}

/*
	========================================================================
	
	Routine	Description:
		Reset NIC from error

	Arguments:
		Adapter						Pointer	to our adapter

	Return Value:
		None

	Note:
		Reset NIC from error state
		
	========================================================================
*/
VOID	NICResetFromError(
	IN	PRTMP_ADAPTER	pAdapter)
{
//	UCHAR	Index;
	
	// Reset BBP (according	to alex, reset ASIC	will force reset BBP
	// Therefore, skip the reset BBP
	// RTMP_IO_WRITE32(pAdapter, CSR1, 0x2);
	// Release BBP reset
	// RTMP_IO_WRITE32(pAdapter, CSR1, 0x0);

	RTMP_IO_WRITE32(pAdapter, CSR1,	0x1);
	// Remove ASIC from	reset state
	RTMP_IO_WRITE32(pAdapter, CSR1,	0x0);
	
	// Init	send data structures and related parameters
	NICInitTransmit(pAdapter);

	NICInitializeAdapter(pAdapter);	
	NICInitAsicFromEEPROM(pAdapter);

	// Switch to current channel, since	during reset process, the connection should	remains	on.	
	AsicSwitchChannel(pAdapter,	pAdapter->PortCfg.Channel);
	AsicLockChannel(pAdapter, pAdapter->PortCfg.Channel);
}
/*
	========================================================================
	
	Routine	Description:
		Verify section is valid	for	Get	key	parameter.

	Arguments:
		buffer						Pointer	to the buffer to start find	the	key	section
		ptr							pointer	to section

	Return Value:
		TRUE						Success
		FALSE						Fail
	========================================================================
*/
INT	RTMPIsFindSection(
	IN	PUCHAR	ptr,
	IN	PUCHAR	buffer)
{
	if(ptr == buffer)
		return TRUE;
	else if	(ptr > buffer) 
	{
		while (ptr > buffer)
		{
			ptr--;
			if(	*ptr ==	0x0a)
				return TRUE;
			else if( (*ptr == '	') || (*ptr	== '\t'))
				continue;
			else
				return FALSE;
		}
		return TRUE;
	}
		
	return FALSE;
}
/*
	========================================================================
	
	Routine	Description:
		Find key section for Get key parameter.

	Arguments:
		buffer						Pointer	to the buffer to start find	the	key	section
		section						the	key	of the secion to be	find

	Return Value:
		NULL						Fail
		Others						Success
	========================================================================
*/
PUCHAR	RTMPFindSection(
	IN	PCHAR	buffer,
	IN	PCHAR	section)
{
	CHAR temp_buf[255];
	PUCHAR	ptr;

	strcpy(temp_buf, "[");					/*	and	the	opening	bracket	[  */
	strcat(temp_buf, section);
	strcat(temp_buf, "]");

	if((ptr	= strstr(buffer, temp_buf))	!= NULL)
	{
		if(RTMPIsFindSection(ptr, buffer))
			return (ptr+strlen("\n"));
		else
			return NULL;
	}
	else
		return NULL;
}	
/*
	========================================================================
	
	Routine	Description:
		Get	key	parameter.

	Arguments:
		section						the	key	of the secion
		key							Pointer	to key string
		dest						Pointer	to destination		
		destsize					The	datasize of	the	destination
		buffer						Pointer	to the buffer to start find	the	key

	Return Value:
		TRUE						Success
		FALSE						Fail

	Note:
		This routine get the value with	the	matched	key	(case case-sensitive)
	========================================================================
*/
INT	RTMPGetKeyParameter(
	IN	PUCHAR	section,
	IN	PCHAR	key,
	OUT	PCHAR	dest,	
	IN	INT		destsize,
	IN	PCHAR	buffer)
{
	char temp_buf1[600];
	char temp_buf2[600];
	char *start_ptr;
	char *end_ptr;
	char *ptr;
	char *too_far_ptr;
	char *offset;
	int	 len;

	//find section
	if((offset = RTMPFindSection(buffer, section)) == NULL)
		return (FALSE);

	strcpy(temp_buf1, "\n");
	strcat(temp_buf1, key);
	strcat(temp_buf1, "=");

	//search key
	if((start_ptr=strstr(offset, temp_buf1))==NULL)
		return FALSE;

	start_ptr+=strlen("\n");
	if((too_far_ptr=strstr(offset+1, "["))==NULL)
	   too_far_ptr=offset+strlen(offset);

	if((end_ptr=strstr(start_ptr, "\n"))==NULL)
	   end_ptr=start_ptr+strlen(start_ptr);

	if (too_far_ptr<start_ptr)
		return FALSE;

	memcpy(temp_buf2, start_ptr, end_ptr-start_ptr);
	temp_buf2[end_ptr-start_ptr]='\0';
	len	= strlen(temp_buf2);
	strcpy(temp_buf1, temp_buf2);
	if((start_ptr=strstr(temp_buf1,	"=")) == NULL)
		return FALSE;

	strcpy(temp_buf2, start_ptr+1);
	ptr	= temp_buf2;
	//trim space or	tab
	while(*ptr != 0x00)
	{
		if(	(*ptr == ' ') || (*ptr == '\t')	)
			ptr++;
		else
		   break;
	}

	len	= strlen(ptr);	  
	memset(dest, 0x00, destsize);
	strncpy(dest, ptr, len >= destsize ?  destsize:	len);

	return TRUE;
}

/*
	========================================================================
	
	Routine	Description:
		In kernel mode read	parameters from	file

	Arguments:
		src						the	location of	the	file.
		dest						put	the	parameters to the destination.
		Length					size to	read.

	Return Value:
		None

	Note:
		
	========================================================================
*/

VOID RTMPReadParametersFromFile(
	IN	PRTMP_ADAPTER pAd)
{
	PUCHAR					src;
	struct file				*srcf;
	INT						retval,	orgfsuid, orgfsgid;
	mm_segment_t			orgfs;
	CHAR					buffer[MAX_INI_BUFFER_SIZE];
	CHAR					tmpbuf[600];
	UCHAR					keyMaterial[40];
	ULONG					BbpCsr1;
	UCHAR					TxValue;
	UCHAR					RxValue;
	ULONG					RtsThresh;
	ULONG					FragThresh;
	NDIS_802_11_WEP_STATUS	WepStatus;
	ULONG					KeyIdx;
	ULONG					KeyType;
	ULONG					KeyLen;
	MACADDR					macAddress;
	PUCHAR					macptr;						
	INT						i=0,j=0;


	src	= PROFILE_PATH;
	
	// Save	uid	and	gid	used for filesystem	access.
	// Set user	and	group to 0 (root)	
	orgfsuid = current->fsuid;
	orgfsgid = current->fsgid;
	current->fsuid=current->fsgid =	0;
	orgfs =	get_fs();
	set_fs(KERNEL_DS);

	if (src	&& *src) 
	{
		srcf = filp_open(src, O_RDONLY,	0);
		if (IS_ERR(srcf)) 
		{
			DBGPRINT(RT_DEBUG_TRACE,	"--> Error %ld opening %s\n", -PTR_ERR(srcf),src);	  
		}
		else 
		{
			/* The object must have	a read method */
			if (srcf->f_op && srcf->f_op->read)	
			{
				NdisZeroMemory(buffer,MAX_INI_BUFFER_SIZE);
				retval=srcf->f_op->read(srcf, buffer, MAX_INI_BUFFER_SIZE, &srcf->f_pos);
				if (retval < 0)
				{
					DBGPRINT(RT_DEBUG_TRACE,	"--> Read %s error %d\n", src, -retval);
				}
				else
				{
					// set file	parameter to portcfg
					//CountryRegion
					if(RTMPGetKeyParameter("Default", "CountryRegion", tmpbuf, 255,	buffer))
					{
						pAd->PortCfg.CountryRegion = (UCHAR) simple_strtol(tmpbuf, 0, 10);
						DBGPRINT(RT_DEBUG_TRACE, "CountryRegion=%d\n", pAd->PortCfg.CountryRegion);
					}
					else
					{
						DBGPRINT(RT_DEBUG_TRACE, "CountryRegion=XXXXXXXXX\n" );
					}
					//SSID
					if(RTMPGetKeyParameter("Default", "SSID", pAd->PortCfg.Ssid, 32, buffer))
					{
						pAd->PortCfg.SsidLen = strlen(pAd->PortCfg.Ssid);
						DBGPRINT(RT_DEBUG_TRACE, "SSID=%s\n", pAd->PortCfg.Ssid);
					}
					//WirelessMode
					if(RTMPGetKeyParameter("Default", "WirelessMode", tmpbuf, 10, buffer))
					{
						switch(simple_strtol(tmpbuf, 0,	10))
						{
							case PHY_11B:
								pAd->PortCfg.PhyMode = PHY_11B;
								break;
							case PHY_11G:
								pAd->PortCfg.PhyMode = PHY_11G;
								break;
							case PHY_11A: // currently not support
							case PHY_11ABG_MIXED: // currently not support
							case PHY_11BG_MIXED:
							default:
								pAd->PortCfg.PhyMode = PHY_11BG_MIXED;
								break;
						}
			
						DBGPRINT(RT_DEBUG_TRACE, "PhyMode=%d\n", pAd->PortCfg.PhyMode);
					}
					//TxRate					
					if(RTMPGetKeyParameter("Default", "TxRate",	tmpbuf,	10,	buffer))
					{
						NdisZeroMemory(pAd->PortCfg.DesiredRates, MAX_LEN_OF_SUPPORTED_RATES);
						switch (pAd->PortCfg.PhyMode)
						{
							case PHY_11A: // A only
						switch(simple_strtol(tmpbuf, 0,	10))
						{
							case 1:
								pAd->PortCfg.DesiredRates[0] = 0x0c; // 6M
								break;
							case 2:
								pAd->PortCfg.DesiredRates[0] = 0x12; // 9M
								break;
							case 3:
								pAd->PortCfg.DesiredRates[0] = 0x18; // 12M
								break;
							case 4:
								pAd->PortCfg.DesiredRates[0] = 0x24; // 18M
								break;
							case 5:
								pAd->PortCfg.DesiredRates[0] = 0x30; // 24M
								break;
							case 6:
								pAd->PortCfg.DesiredRates[0] = 0x48; // 36M
								break;
							case 7:
								pAd->PortCfg.DesiredRates[0] = 0x60; // 48M
								break;
							case 8:
								pAd->PortCfg.DesiredRates[0] = 0x6c; // 54M
								break;
							case 0:	
								pAd->PortCfg.DesiredRates[0] = 0x6c; // 54Mbps
								pAd->PortCfg.DesiredRates[1] = 0x60; // 48Mbps
								pAd->PortCfg.DesiredRates[2] = 0x48; // 36Mbps
								pAd->PortCfg.DesiredRates[3] = 0x30; // 24Mbps
								pAd->PortCfg.DesiredRates[4] = 0x24; // 18M
								pAd->PortCfg.DesiredRates[5] = 0x18; // 12M
								pAd->PortCfg.DesiredRates[6] = 0x12; // 9M
								pAd->PortCfg.DesiredRates[7] = 0x0c; // 6M
								break;
							}
							break;
						case PHY_11BG_MIXED: //	B/G	Mixed
						case PHY_11B: // B only
						case PHY_11G: // G Only
						case PHY_11ABG_MIXED: // A/B/G Mixed
						default:
								switch (simple_strtol(tmpbuf, 0, 10))
								{
									case 0:
											switch (pAd->PortCfg.PhyMode)
											{
												case PHY_11B: // B Only
													pAd->PortCfg.DesiredRates[0] = 0x16; //	11Mbps
													pAd->PortCfg.DesiredRates[1] = 0x0b; //	5.5Mbps
													pAd->PortCfg.DesiredRates[2] = 0x04; //	2Mbps
													pAd->PortCfg.DesiredRates[3] = 0x02; //	1Mbps
													break;
																			case PHY_11G: // G Only
											case PHY_11BG_MIXED: // B/G Mixed
											case PHY_11ABG_MIXED: // A/B/G Mixed
											default:
												pAd->PortCfg.DesiredRates[0] = 0x6c; // 54Mbps
												pAd->PortCfg.DesiredRates[1] = 0x60; // 48Mbps
												pAd->PortCfg.DesiredRates[2] = 0x48; // 36Mbps
												pAd->PortCfg.DesiredRates[3] = 0x30; // 24Mbps
												pAd->PortCfg.DesiredRates[4] = 0x16; // 11Mbps
												pAd->PortCfg.DesiredRates[5] = 0x0b; // 5.5Mbps
												pAd->PortCfg.DesiredRates[6] = 0x04; // 2Mbps
												pAd->PortCfg.DesiredRates[7] = 0x02; // 1Mbps
												break;
										}
										break;
									case 1:
										pAd->PortCfg.DesiredRates[0] = 0x02; // 1M
										break;
									case 2:
										pAd->PortCfg.DesiredRates[0] = 0x04; // 2M
										break;
									case 3:
										pAd->PortCfg.DesiredRates[0] = 0x0b; // 5.5M
										break;
									case 4:
										pAd->PortCfg.DesiredRates[0] = 0x16; // 11M
										break;
									case 5:
										pAd->PortCfg.DesiredRates[0] = 0x0c; // 6M
										break;
									case 6:
										pAd->PortCfg.DesiredRates[0] = 0x12; // 9M
										break;
									case 7:
										pAd->PortCfg.DesiredRates[0] = 0x18; // 12M
										break;
									case 8:
										pAd->PortCfg.DesiredRates[0] = 0x24; // 18M
										break;
									case 9:
										pAd->PortCfg.DesiredRates[0] = 0x30; // 24M
										break;
									case 10:
										pAd->PortCfg.DesiredRates[0] = 0x48; // 36M
										break;
									case 11:
										pAd->PortCfg.DesiredRates[0] = 0x60; // 48M
										break;
									case 12:
										pAd->PortCfg.DesiredRates[0] = 0x6c; // 54M
										break;

								
								}
								break;
						}
					
						DBGPRINT(RT_DEBUG_TRACE, "TxRate=(%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x)\n", 
								pAd->PortCfg.DesiredRates[0],pAd->PortCfg.DesiredRates[1],
								pAd->PortCfg.DesiredRates[2],pAd->PortCfg.DesiredRates[3],
								pAd->PortCfg.DesiredRates[4],pAd->PortCfg.DesiredRates[5],
								pAd->PortCfg.DesiredRates[6],pAd->PortCfg.DesiredRates[7] );
					}
					//Channel
					if(RTMPGetKeyParameter("Default", "Channel", tmpbuf, 10, buffer))
					{
						pAd->PortCfg.Channel = (UCHAR) simple_strtol(tmpbuf, 0,	10);
						DBGPRINT(RT_DEBUG_TRACE, "Channel=%d\n", pAd->PortCfg.Channel);				
					}
					//BeaconPeriod
					if(RTMPGetKeyParameter("Default", "BeaconPeriod", tmpbuf, 10, buffer))
					{
						pAd->PortCfg.BeaconPeriod =	(USHORT) simple_strtol(tmpbuf, 0, 10);
						DBGPRINT(RT_DEBUG_TRACE, "BeaconPeriod=%d\n", pAd->PortCfg.BeaconPeriod);
					}
					//BGProtection
					if(RTMPGetKeyParameter("Default", "BGProtection", tmpbuf, 10, buffer))
					{
						switch (simple_strtol(tmpbuf, 0, 10))
						{
							case 1:	//Always On
								pAd->PortCfg.UseBGProtection = 1;
								break;
							case 2:	//Always OFF
								pAd->PortCfg.UseBGProtection = 2;
								break;
							case 0:	//AUTO
							default:
								pAd->PortCfg.UseBGProtection = 0;
								break;
						}
						DBGPRINT(RT_DEBUG_TRACE, "BGProtection=%d\n", pAd->PortCfg.UseBGProtection);
					}
					//TxAntenna
					if(RTMPGetKeyParameter("Default", "TxAntenna", tmpbuf, 10, buffer))
					{		
						RTMP_IO_READ32(pAd,	BBPCSR1, &BbpCsr1);

						switch (simple_strtol(tmpbuf, 0, 10))
						{
							case 1:	//Antenna A
								pAd->PortCfg.CurrentTxAntenna =	0x00;
								RTMP_BBP_IO_READ32_BY_REG_ID(pAd, BBP_Tx_Configure,	&TxValue);
								TxValue	= (TxValue & 0xFC) | 0x00;
								BbpCsr1	= (BbpCsr1 & 0xFFFCFFFC) | 0x00000000;
								RTMP_BBP_IO_WRITE32_BY_REG_ID(pAd, BBP_Tx_Configure, TxValue);
								RTMP_IO_WRITE32(pAd, BBPCSR1, BbpCsr1);
								break;
							case 2:	//Antenna B
								pAd->PortCfg.CurrentTxAntenna =	0x01;
								RTMP_BBP_IO_READ32_BY_REG_ID(pAd, BBP_Tx_Configure,	&TxValue);
								TxValue	= (TxValue & 0xFC) | 0x02;
								BbpCsr1	= (BbpCsr1 & 0xFFFCFFFC) | 0x00020002;
								RTMP_BBP_IO_WRITE32_BY_REG_ID(pAd, BBP_Tx_Configure, TxValue);
								RTMP_IO_WRITE32(pAd, BBPCSR1, BbpCsr1);
								break;
							case 0:	//Diversity
							default: 
								pAd->PortCfg.CurrentTxAntenna =	0xFF;
								RTMP_BBP_IO_READ32_BY_REG_ID(pAd, BBP_Tx_Configure,	&TxValue);
								TxValue	= (TxValue & 0xFC) | 0x01;
								RTMP_BBP_IO_WRITE32_BY_REG_ID(pAd, BBP_Tx_Configure, TxValue);
								BbpCsr1	= (BbpCsr1 & 0xFFFCFFFC) | 0x00010001;
								RTMP_IO_WRITE32(pAd, BBPCSR1, BbpCsr1);
								break;
						}
						DBGPRINT(RT_DEBUG_TRACE, "TxAntenna=0x%02X\n", pAd->PortCfg.CurrentTxAntenna);
					}
					//RxAntenna
					if(RTMPGetKeyParameter("Default", "RxAntenna", tmpbuf, 10, buffer))
					{
						RTMP_IO_READ32(pAd,	BBPCSR1, &BbpCsr1);

						switch (simple_strtol(tmpbuf, 0, 10))
						{
							case 1:	//Antenna A
								pAd->PortCfg.CurrentRxAntenna =	0x00;
								RTMP_BBP_IO_READ32_BY_REG_ID(pAd, BBP_Rx_Configure,	&RxValue);
								RxValue	= (RxValue & 0xFC) | 0x00;
								RTMP_BBP_IO_WRITE32_BY_REG_ID(pAd, BBP_Rx_Configure, RxValue);
								break;
							case 2:	//Antenna B
								pAd->PortCfg.CurrentRxAntenna =	0x01;
								RTMP_BBP_IO_READ32_BY_REG_ID(pAd, BBP_Rx_Configure,	&RxValue);
								RxValue	= (RxValue & 0xFC) | 0x02;
								RTMP_BBP_IO_WRITE32_BY_REG_ID(pAd, BBP_Rx_Configure, RxValue);
								break;
							case 0:	//Diversity
							default: 
								pAd->PortCfg.CurrentRxAntenna =	0xFF;
								RTMP_BBP_IO_READ32_BY_REG_ID(pAd, BBP_Rx_Configure,	&RxValue);
								RxValue	= (RxValue & 0xFC) | 0x01;
								RTMP_BBP_IO_WRITE32_BY_REG_ID(pAd, BBP_Rx_Configure, RxValue);	
								break;
						}
						DBGPRINT(RT_DEBUG_TRACE, "RxAntenna=0x%02X\n", pAd->PortCfg.CurrentRxAntenna);
					}
					//TxPreamble
					if(RTMPGetKeyParameter("Default", "TxPreamble",	tmpbuf,	10,	buffer))
					{
						switch (simple_strtol(tmpbuf, 0, 10))
						{
							case Rt802_11PreambleShort:
								pAd->PortCfg.TxPreamble	= Rt802_11PreambleShort;
								break;
							case Rt802_11PreambleLong:
							default:
								pAd->PortCfg.TxPreamble	= Rt802_11PreambleLong;
								break;
						}
						DBGPRINT(RT_DEBUG_TRACE, "TxPreamble=%d\n",	pAd->PortCfg.TxPreamble);
					}
					//RTSThreshold
					if(RTMPGetKeyParameter("Default", "RTSThreshold", tmpbuf, 10, buffer))
					{
						RtsThresh =	simple_strtol(tmpbuf, 0, 10);
						if(	(RtsThresh >= 1) &&	(RtsThresh <= MAX_RTS_THRESHOLD) )
							pAd->PortCfg.RtsThreshold  = (USHORT)RtsThresh;
						else
							pAd->PortCfg.RtsThreshold =	MAX_RTS_THRESHOLD;
						
						DBGPRINT(RT_DEBUG_TRACE, "RTSThreshold=%d\n", pAd->PortCfg.RtsThreshold);
					}
					//FragThreshold
					if(RTMPGetKeyParameter("Default", "FragThreshold", tmpbuf, 10, buffer))
					{		
						FragThresh = simple_strtol(tmpbuf, 0, 10);
						pAd->PortCfg.bFragmentZeroDisable =	FALSE;			

						if (FragThresh > MAX_FRAG_THRESHOLD	|| FragThresh <	MIN_FRAG_THRESHOLD)
						{ //illegal	FragThresh so we set it	to default
							pAd->PortCfg.FragmentThreshold = MAX_FRAG_THRESHOLD;
							pAd->PortCfg.bFragmentZeroDisable =	TRUE;
						}
						else
							pAd->PortCfg.FragmentThreshold = (USHORT)FragThresh;

						DBGPRINT(RT_DEBUG_TRACE, "FragThreshold=%d\n", pAd->PortCfg.FragmentThreshold);
					}
					//TxBurst
					if(RTMPGetKeyParameter("Default", "TxBurst", tmpbuf, 10, buffer))
					{
						if(simple_strtol(tmpbuf, 0,	10)	!= 0)  //Enable
							pAd->PortCfg.EnableTxBurst = TRUE;
						else //Disable
							pAd->PortCfg.EnableTxBurst = FALSE;

						DBGPRINT(RT_DEBUG_TRACE, "TxBurst=%d\n", pAd->PortCfg.EnableTxBurst);
					}
					//TurboRate
					if(RTMPGetKeyParameter("Default", "TurboRate", tmpbuf, 10, buffer))
					{
						if(simple_strtol(tmpbuf, 0,	10)	!= 0)  //Enable
							pAd->PortCfg.EnableTurboRate = TRUE;
						else //Disable
							pAd->PortCfg.EnableTurboRate = FALSE;
						
						DBGPRINT(RT_DEBUG_TRACE, "TurboRate=%d\n", pAd->PortCfg.EnableTurboRate);
					}
					//NoForwarding
					if(RTMPGetKeyParameter("Default", "NoForwarding", tmpbuf, 10, buffer))
					{
						if(simple_strtol(tmpbuf, 0,	10)	!= 0)  //Enable
							pAd->PortCfg.IsolateInterStaTraffic	= TRUE;
						else //Disable
							pAd->PortCfg.IsolateInterStaTraffic	= FALSE;

						DBGPRINT(RT_DEBUG_TRACE, "NoForwarding=%d\n", pAd->PortCfg.IsolateInterStaTraffic);
					}
					//HideSSID
					if(RTMPGetKeyParameter("Default", "HideSSID", tmpbuf, 10, buffer))
					{
						if(simple_strtol(tmpbuf, 0,	10)	!= 0)  //Enable
							pAd->PortCfg.HideSsid =	TRUE;
						else //Disable
							pAd->PortCfg.HideSsid =	FALSE;

						DBGPRINT(RT_DEBUG_TRACE, "HideSSID=%d\n", pAd->PortCfg.HideSsid);
					}
					//ShortSlot
					if(RTMPGetKeyParameter("Default", "ShortSlot", tmpbuf, 10, buffer))
					{
						if(simple_strtol(tmpbuf, 0,	10)	!= 0)  //Enable
							pAd->PortCfg.UseShortSlotTime =	TRUE;
						else //Disable
							pAd->PortCfg.UseShortSlotTime =	FALSE;

						DBGPRINT(RT_DEBUG_TRACE, "ShortSlot=%d\n", pAd->PortCfg.UseShortSlotTime);
					}
										//AutoChannelSelect
					if(RTMPGetKeyParameter("Default", "AutoChannelSelect", tmpbuf, 10, buffer))
					{
						if(simple_strtol(tmpbuf, 0, 10) != 0)  //Enable
							pAd->PortCfg.AutoChannelAtBootup = TRUE;
						else
							pAd->PortCfg.AutoChannelAtBootup = FALSE;

						DBGPRINT(RT_DEBUG_TRACE, "AutoChannelAtBootup=%d\n", pAd->PortCfg.AutoChannelAtBootup);
					}
					//AuthMode
					if(RTMPGetKeyParameter("Default", "AuthMode", tmpbuf, 10, buffer))
					{
						if ((strcmp(tmpbuf,	"OPEN")	== 0) || (strcmp(tmpbuf, "open") ==	0))
							pAd->PortCfg.AuthMode =	Ndis802_11AuthModeOpen;
						else if	((strcmp(tmpbuf, "SHARED") == 0) ||	(strcmp(tmpbuf,	"shared") == 0))
							pAd->PortCfg.AuthMode =	Ndis802_11AuthModeShared;
						else if	((strcmp(tmpbuf, "WPAPSK") == 0) ||	(strcmp(tmpbuf,	"wpapsk") == 0))
							pAd->PortCfg.AuthMode =	Ndis802_11AuthModeWPAPSK;
						else if ((strcmp(tmpbuf, "WPA") == 0) || (strcmp(tmpbuf, "wpa") == 0))
							pAd->PortCfg.AuthMode = Ndis802_11AuthModeWPA;
						else //Default
							pAd->PortCfg.AuthMode =	Ndis802_11AuthModeOpen;
						RTMPMakeRSNIE(pAd, pAd->PortCfg.AuthMode, pAd->PortCfg.WepStatus);
						DBGPRINT(RT_DEBUG_TRACE, "AuthMode=%d\n", pAd->PortCfg.AuthMode);
					}
					//EncrypType
					if(RTMPGetKeyParameter("Default", "EncrypType",	tmpbuf,	10,	buffer))
					{
						if ((strcmp(tmpbuf,	"NONE")	== 0) || (strcmp(tmpbuf, "none") ==	0))
							pAd->PortCfg.WepStatus = Ndis802_11WEPDisabled;
						else if	((strcmp(tmpbuf, "WEP")	== 0) || (strcmp(tmpbuf, "wep")	== 0))
							pAd->PortCfg.WepStatus = Ndis802_11WEPEnabled;
						else if	((strcmp(tmpbuf, "TKIP") ==	0) || (strcmp(tmpbuf, "tkip") == 0))
						{
							pAd->PortCfg.WepStatus = Ndis802_11Encryption2Enabled;
						}
						else if	((strcmp(tmpbuf, "AES")	== 0) || (strcmp(tmpbuf, "aes")	== 0))
						{
							pAd->PortCfg.WepStatus = Ndis802_11Encryption3Enabled;
						}
						else
							pAd->PortCfg.WepStatus = Ndis802_11WEPDisabled;
						
						RTMPMakeRSNIE(pAd, pAd->PortCfg.AuthMode, pAd->PortCfg.WepStatus);
						DBGPRINT(RT_DEBUG_TRACE, "EncrypType=%d\n",	pAd->PortCfg.WepStatus);
					}
					//WPAPSK_KEY
					if(RTMPGetKeyParameter("Default", "WPAPSK",	tmpbuf,	255, buffer))
					{
							DBGPRINT(RT_DEBUG_TRACE, "WPAPSK_KEY=%s\n",	tmpbuf);
												if ((strlen(tmpbuf) >= 8) && (strlen(tmpbuf) <= 64))
						{
							PasswordHash((char *)tmpbuf, pAd->PortCfg.Ssid, (int)pAd->PortCfg.SsidLen, keyMaterial);
							NdisMoveMemory(pAd->PortCfg.PMK, keyMaterial, 32);
#ifdef RT2500_DBG
							printk("%s() WPAPSK Key => \n", __FUNCTION__);
							for (i = 0; i < 32; i++)
							{
								printk("%02x:", pAd->PortCfg.PMK[i]);
								if ((i%16) == 15)
									printk("\n");
							}
							printk("\n");
#endif
						}
					}
					//DefaultKeyID
					if(RTMPGetKeyParameter("Default", "DefaultKeyID", tmpbuf, 10, buffer))
					{
						KeyIdx = simple_strtol(tmpbuf, 0, 10);
						if((KeyIdx >= 1	) && (KeyIdx <=	4))
							pAd->PortCfg.DefaultKeyId =	(UCHAR)	(KeyIdx	- 1	);
						else
							pAd->PortCfg.DefaultKeyId =	0;
						
						DBGPRINT(RT_DEBUG_TRACE, "DefaultKeyID=%d\n", pAd->PortCfg.DefaultKeyId);
					}
					//Key1Type
					if(RTMPGetKeyParameter("Default", "Key1Type", tmpbuf, 10, buffer))
					{
						KeyType	= simple_strtol(tmpbuf,	0, 10);

						//Key1Str
						if(RTMPGetKeyParameter("Default", "Key1Str", tmpbuf, 255, buffer))
						{	
							KeyLen = strlen(tmpbuf);
							if(KeyType == 0)
							{//Hex type
								if(	(KeyLen	== 10) || (KeyLen == 26))
								{
									pAd->PortCfg.SharedKey[0].KeyLen = KeyLen /	2;
									AtoH(tmpbuf, pAd->PortCfg.SharedKey[0].Key,	KeyLen / 2);

									DBGPRINT(RT_DEBUG_TRACE, "Key1Str=%s and type=%s\n", tmpbuf, (KeyType==0) ?	"Hex":"Ascii");
								}
								else
								{ //Invalid	key	length
									DBGPRINT(RT_DEBUG_TRACE, "Key1Str is Invalid key length!\n");
								}								
							}
							else
							{//Ascii								
								if(	(KeyLen	== 5) || (KeyLen ==	13))
								{
									pAd->PortCfg.SharedKey[0].KeyLen = KeyLen;
									NdisMoveMemory(pAd->PortCfg.SharedKey[0].Key, tmpbuf, KeyLen);
							
									DBGPRINT(RT_DEBUG_TRACE, "Key1Str=%s and type=%s\n", tmpbuf, (KeyType==0) ?	"Hex":"Ascii");		
								}
								else
								{ //Invalid	key	length
									DBGPRINT(RT_DEBUG_TRACE, "Key1Str is Invalid key length!\n");
								}
							}
						}
					}
					//Key2Type
					if(RTMPGetKeyParameter("Default", "Key2Type", tmpbuf, 10, buffer))
					{
						KeyType	= simple_strtol(tmpbuf,	0, 10);
						//Key2Str
						if(RTMPGetKeyParameter("Default", "Key2Str", tmpbuf, 255, buffer))
						{	
							KeyLen = strlen(tmpbuf);
							if(KeyType == 0)
							{//Hex type
								if(	(KeyLen	== 10) || (KeyLen == 26))
								{
									pAd->PortCfg.SharedKey[1].KeyLen = KeyLen /	2;
									AtoH(tmpbuf, pAd->PortCfg.SharedKey[1].Key,	KeyLen / 2);

									DBGPRINT(RT_DEBUG_TRACE, "Key2Str=%s and type=%s\n", tmpbuf, (KeyType==0) ?	"Hex":"Ascii");
								}
								else
								{ //Invalid	key	length
									DBGPRINT(RT_DEBUG_TRACE, "Key2Str is Invalid key length!\n");
								}								
							}
							else
							{//Ascii								
								if(	(KeyLen	== 5) || (KeyLen ==	13))
								{
									pAd->PortCfg.SharedKey[1].KeyLen = KeyLen;
									NdisMoveMemory(pAd->PortCfg.SharedKey[1].Key, tmpbuf, KeyLen);

									DBGPRINT(RT_DEBUG_TRACE, "Key2Str=%s and type=%s\n", tmpbuf, (KeyType==0) ?	"Hex":"Ascii");	
								}
								else
								{ //Invalid	key	length
									DBGPRINT(RT_DEBUG_TRACE, "Key2Str is Invalid key length!\n");
								}
							}
						}
					}
					//Key3Type
					if(RTMPGetKeyParameter("Default", "Key3Type", tmpbuf, 10, buffer))
					{
						KeyType	= simple_strtol(tmpbuf,	0, 10);
						//Key3Str
						if(RTMPGetKeyParameter("Default", "Key3Str", tmpbuf, 255, buffer))
						{	
							KeyLen = strlen(tmpbuf);
							if(KeyType == 0)
							{//Hex type
								if(	(KeyLen	== 10) || (KeyLen == 26))
								{
									pAd->PortCfg.SharedKey[2].KeyLen = KeyLen /	2;
									AtoH(tmpbuf, pAd->PortCfg.SharedKey[2].Key,	KeyLen / 2);

									DBGPRINT(RT_DEBUG_TRACE, "Key3Str=%s and type=%s\n", tmpbuf, (KeyType==0) ?	"Hex":"Ascii");	
								}
								else
								{ //Invalid	key	length
									DBGPRINT(RT_DEBUG_TRACE, "Key3Str is Invalid key length!\n");
								}								
							}
							else
							{//Ascii								
								if(	(KeyLen	== 5) || (KeyLen ==	13))
								{
									pAd->PortCfg.SharedKey[2].KeyLen = KeyLen;
									NdisMoveMemory(pAd->PortCfg.SharedKey[2].Key, tmpbuf, KeyLen);
							
									DBGPRINT(RT_DEBUG_TRACE, "Key3Str=%s and type=%s\n", tmpbuf, (KeyType==0) ?	"Hex":"Ascii");	
								}
								else
								{ //Invalid	key	length
									DBGPRINT(RT_DEBUG_TRACE, "Key3Str is Invalid key length!\n");
								}
							}
						}
					}
					//Key4Type
					if(RTMPGetKeyParameter("Default", "Key4Type", tmpbuf, 10, buffer))
					{
						KeyType	= simple_strtol(tmpbuf,	0, 10);
						//Key4Str
						if(RTMPGetKeyParameter("Default", "Key4Str", tmpbuf, 255, buffer))
						{	
							KeyLen = strlen(tmpbuf);
							if(KeyType == 0)
							{//Hex type
								if(	(KeyLen	== 10) || (KeyLen == 26))
								{
									pAd->PortCfg.SharedKey[3].KeyLen = KeyLen /	2;
									AtoH(tmpbuf, pAd->PortCfg.SharedKey[3].Key,	KeyLen / 2);

									DBGPRINT(RT_DEBUG_TRACE, "Key4Str=%s and type=%s\n", tmpbuf, (KeyType==0) ?	"Hex":"Ascii");
								}
								else
								{ //Invalid	key	length
									DBGPRINT(RT_DEBUG_TRACE, "Key4Str is Invalid key length!\n");
								}								
							}
							else
							{//Ascii								
								if(	(KeyLen	== 5) || (KeyLen ==	13))
								{
									pAd->PortCfg.SharedKey[3].KeyLen = KeyLen;
									NdisMoveMemory(pAd->PortCfg.SharedKey[3].Key, tmpbuf, KeyLen);
							
									DBGPRINT(RT_DEBUG_TRACE, "Key4Str=%s and type=%s\n", tmpbuf, (KeyType==0) ?	"Hex":"Ascii");		
								}
								else
								{ //Invalid	key	length
									DBGPRINT(RT_DEBUG_TRACE, "Key4Str is Invalid key length!\n");
								}
							}
						}
					}				
					//AccessPolicy
					if(RTMPGetKeyParameter("Default", "AccessPolicy", tmpbuf, 10, buffer))
					{
						switch (simple_strtol(tmpbuf, 0, 10))
						{
							case 1:	//Allow	All
								pAd->PortCfg.AccessControlList.Policy =	1;
								break;
							case 2:	//Reject All
								pAd->PortCfg.AccessControlList.Policy =	2;
								break;
							case 0:	//Disable
							default:
								pAd->PortCfg.AccessControlList.Policy =	0;
								break;
						}
						DBGPRINT(RT_DEBUG_TRACE, "AccessPolicy=%d\n", pAd->PortCfg.AccessControlList.Policy);
					}
					//AccessControlList
					if(RTMPGetKeyParameter("Default", "AccessControlList", tmpbuf, 576,	buffer))
					{
						for	(i=0, macptr = strtok(tmpbuf,";"); macptr; macptr =	strtok(NULL,";"), i++) 
						{
							if(strlen(macptr) != 17)  //Mac	address	acceptable format 01:02:03:04:05:06	length 17
								continue; 
						
							for	(j=0; j<ETH_LENGTH_OF_ADDRESS; j++)
							{
								AtoH(macptr, &macAddress.Octet[j], 2);
								macptr=macptr+3;
							}
							
							pAd->PortCfg.AccessControlList.Num++;	
							NdisMoveMemory(pAd->PortCfg.AccessControlList.Entry[i].Addr, &macAddress, ETH_LENGTH_OF_ADDRESS);
						}
						DBGPRINT(RT_DEBUG_TRACE, "AccessControlList=Get	%d Mac Address\n", pAd->PortCfg.AccessControlList.Num);
					}				
#ifdef	WDS
					//WdsList
					if(RTMPGetKeyParameter("Default", "WdsList", tmpbuf, 576, buffer))
					{
						RT_802_11_WDS	Wds;						
						
						memset(&Wds, 0x00, sizeof(RT_802_11_WDS));
						for	(i=0, macptr = strtok(tmpbuf,";"); (macptr && i	< 3); macptr = strtok(NULL,";"), i++) 
						{
							if(strlen(macptr) != 17)  //Mac	address	acceptable format 01:02:03:04:05:06	length 17
								continue; 

							for	(j=0; j<ETH_LENGTH_OF_ADDRESS; j++)
							{
								AtoH(macptr, &macAddress.Octet[j], 2);
								macptr=macptr+3;
							}	
							memcpy(&Wds.Entry[i], &macAddress, ETH_LENGTH_OF_ADDRESS);
							Wds.Num	++;
						}

						pAd->WdsTab.Num	= Wds.Num;						
						for(i =	0; i < pAd->WdsTab.Num;	i++)
						{
							NdisMoveMemory(&pAd->WdsTab.WdsEntry[i].WdsAddr[0],	&Wds.Entry[i], MAC_ADDR_LEN);
							DBGPRINT(RT_DEBUG_WDS/*TRACE*/,"WDS-AP(%d)-%02x:%02x:%02x:%02x:%02x:%02x\n", i,
								pAd->WdsTab.WdsEntry[i].WdsAddr[0],	pAd->WdsTab.WdsEntry[i].WdsAddr[1],	pAd->WdsTab.WdsEntry[i].WdsAddr[2],	
								pAd->WdsTab.WdsEntry[i].WdsAddr[3],	pAd->WdsTab.WdsEntry[i].WdsAddr[4],	pAd->WdsTab.WdsEntry[i].WdsAddr[5]);
						}
					}
					//WdsKey					
					if(RTMPGetKeyParameter("Default", "WdsKey",	tmpbuf,	255, buffer))
					{
						if((strlen(tmpbuf) >= 8) && (strlen(tmpbuf) <= 64))
						{					
							PasswordHash((char *)tmpbuf, (unsigned char *)RALINK, sizeof(RALINK), keyMaterial);

							NdisZeroMemory(&pAd->WdsTab.Wpa_key, sizeof(WPA_KEY));
							NdisMoveMemory(&pAd->WdsTab.Wpa_key.Key, keyMaterial, 16);
							pAd->WdsTab.Wpa_key.KeyLen = 16;
							NdisMoveMemory(&pAd->WdsTab.Wpa_key.RxMic, keyMaterial+16, 8);
							NdisMoveMemory(&pAd->WdsTab.Wpa_key.TxMic, keyMaterial+24, 8);
							DBGPRINT(RT_DEBUG_WDS/*TRACE*/,"WDS-KEY (num=%d)\n", pAd->WdsTab.Num);
#ifdef RT2500_DBG
							printk("=====================================================\n");
							DBGPRINT(RT_DEBUG_WDS, "WdsTab.Wpa_key=>\n");
							for (i=0; i<16; i++)
								printk("%02x:", pAd->WdsTab.Wpa_key.Key[i]);
							printk("\nRxMic Key=>\n");
							for (i=0; i<8; i++)
								printk("%02x:", pAd->WdsTab.Wpa_key.RxMic[i]);
							printk("\nTxMic Key=>\n");
							for (i=0; i<8; i++)
								printk("%02x:", pAd->WdsTab.Wpa_key.TxMic[i]);
							printk("\n");
#endif
						}
					}
					//WdsEnable
					if(RTMPGetKeyParameter("Default", "WdsEnable", tmpbuf, 255,	buffer))
					{						
						if(simple_strtol(tmpbuf, 0,	10)	== 0)
						{ //Disable
							pAd->WdsTab.Num	= 0;
							pAd->WdsTab.Wpa_key.KeyLen = 0;							
							DBGPRINT(RT_DEBUG_WDS/*TRACE*/,"WDS-Enable	(num=%d, keylen=%d)\n",	pAd->WdsTab.Num, pAd->WdsTab.Wpa_key.KeyLen);
						}
					}
#endif
				}
			}
			else
			{
				DBGPRINT(RT_DEBUG_TRACE,	"--> %s	does not have a	write method\n", src);
			}
			
			retval=filp_close(srcf,NULL);
			
			if (retval)
			{
				DBGPRINT(RT_DEBUG_TRACE, "--> Error	%d closing %s\n", -retval, src);
			}
		}
	}
	else
	{
		DBGPRINT(RT_DEBUG_WARN,	"--> Error (src	&& *src)\n")
	}
	set_fs(orgfs);
	current->fsuid = orgfsuid;
	current->fsgid = orgfsgid;

}

/*
	========================================================================
	
	Routine	Description:
		Compare	two	memory block

	Arguments:
		Adapter						Pointer	to our adapter

	Return Value:
		1:			memory are equal
		0:			memory are not equal

	Note:
		
	========================================================================
*/
#if 0
ULONG	RTMPEqualMemory(
	IN	PVOID	pSrc1,
	IN	PVOID	pSrc2,
	IN	ULONG	Length)
{
	return (memcmp(pSrc1, pSrc2, Length)==0);
}

VOID	NdisZeroMemory(
	IN	PVOID	pDest,
	IN	ULONG	Length)
{
	memset(pDest, 0, Length);
}

VOID	NdisFillMemory(
	IN	PVOID	pDest,
	IN	ULONG	Length,
	IN	UCHAR	Fill)
{
	memset(pDest, Fill,	Length);
}

VOID	NdisMoveMemory(
	OUT	PVOID	pDest,
	IN	PVOID	pSrc,
	IN	ULONG	Length)
{
	memcpy(pDest, pSrc,	Length);
}
#endif

/*
	========================================================================
	
	Routine	Description:
		Initialize port	configuration structure

	Arguments:
		Adapter						Pointer	to our adapter

	Return Value:
		None

	Note:
		
	========================================================================
*/
VOID	PortCfgInit(
	IN	PRTMP_ADAPTER pAdapter)
{
	UINT i;
//	ULONG	Now;
	// WPAPSK, support TKIP	for	unicast	and	mcast, 
//	  UCHAR	  WPA_RSNIE[22]={0x00,0x50,0xf2,0x01,0x01,0x00,0x00,0x50,0xf2,0x02,0x01,0x00,0x00,0x50,0xf2,0x02,0x01,0x00,0x00,0x50,0xf2,0x02};

   UCHAR	CipherSuiteWPATKIP[] = {
		0x00, 0x50, 0xf2, 0x01,	// oui
		0x01, 0x00,				// Version
		0x00, 0x50, 0xf2, 0x02,	// Multicast
		0x01, 0x00,				// Number of unicast
		0x00, 0x50, 0xf2, 0x02,	// unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x50, 0xf2, 0x01	// authentication
		};
	UCHAR	CipherSuiteWPATKIPLen = (sizeof(CipherSuiteWPATKIP) / sizeof(UCHAR));
	DBGPRINT(RT_DEBUG_TRACE, "--> PortCfgInit\n");	  

	// the following default value can be overwritten by successive	set(RT_OID_802_11_AP_CONFIG)
	// or by Window	Registry settings.
	pAdapter->PortCfg.UseShortSlotTime = 1;		   // 1- default use SHORT SLOT	time
	pAdapter->PortCfg.UseBGProtection =	2;		   // 2- always	OFF, 0-	Auto, 1- always	on (tt_lin)
	pAdapter->PortCfg.IsolateInterStaTraffic = 0;  // 0- no	isolation
	pAdapter->PortCfg.HideSsid = 0;				   // 0- do	not	hide SSID
	pAdapter->PortCfg.EnableTxBurst	= 0;		   // 0- no	TX packet burst
	
	pAdapter->PortCfg.CapabilityInfo = 0x0000;
	pAdapter->PortCfg.BeaconPeriod = 100;	  // in	mSec
	pAdapter->PortCfg.AuthMode = Ndis802_11AuthModeOpen;
	//WPA
	for(i =	0; i < SHARE_KEY_NO; i++) {
		pAdapter->PortCfg.SharedKey[i].KeyLen =	0;
	}
	pAdapter->PortCfg.BANClass3Data=FALSE;
	pAdapter->PortCfg.RSNIE_Len=0x16;
	NdisZeroMemory(pAdapter->PortCfg.RSN_IE, MAX_LEN_OF_RSNIE);
	NdisZeroMemory(pAdapter->PortCfg.R_Counter, LEN_KEY_DESC_REPLAY);
	NdisZeroMemory(pAdapter->PortCfg.Key_Counter, 32);
	NdisZeroMemory(pAdapter->PortCfg.PMK,  32);

	NdisMoveMemory(pAdapter->PortCfg.RSN_IE, CipherSuiteWPATKIP, CipherSuiteWPATKIPLen);
//	  NdisZeroMemory(pAdapter->PortCfg.Key_Counter,	32); //repleat with	last item
	pAdapter->PortCfg.BANClass3Data=FALSE;
	pAdapter->PortCfg.WepStatus	= Ndis802_11EncryptionDisabled; 
	pAdapter->PortCfg.DefaultKeyId = 0;
	pAdapter->PortCfg.PrivacyFilter	= Ndis802_11PrivFilterAcceptAll;
	pAdapter->PortCfg.WpaGTKState =	SETKEYS_DONE;
	pAdapter->PortCfg.GKeyDoneStations = 0;
	pAdapter->PortCfg.MICFailureCounter	= 0;
	pAdapter->PortCfg.WPAREKEY.ReKeyMethod = TIME_REKEY;
	pAdapter->PortCfg.WPAREKEY.ReKeyInterval = 0; // 3 min
	pAdapter->PortCfg.MICFailureCounter	= 0;
	pAdapter->PortCfg.WPAGKeyID = 1;
	for	(i = 1;	i <	GROUP_KEY_NO; i++)
	{
		NdisZeroMemory(pAdapter->PortCfg.GroupKey[i].RxTsc,	6);
		pAdapter->PortCfg.GroupKey[i].RxTsc[0]=0x01;
		NdisZeroMemory(pAdapter->PortCfg.GroupKey[i].TxTsc,	6);
		pAdapter->PortCfg.GroupKey[i].KeyLen = 16;
	}

	if (pAdapter->PortCfg.AuthMode >=Ndis802_11AuthModeWPA)
	{	
		//	note that the same actions must	be taken in	 OID_AUTHMODE  in rtmp_info.c  too
		pAdapter->PortCfg.CapabilityInfo|=0x10;	   
	}

	// 802.1x port control
	pAdapter->PortCfg.PortSecured =	WPA_802_1X_PORT_NOT_SECURED;
	
	pAdapter->PortCfg.RtsThreshold = 2347;
	pAdapter->PortCfg.FragmentThreshold	= 2346;
	pAdapter->PortCfg.bFragmentZeroDisable = FALSE;
	pAdapter->PortCfg.CurrentTxAntenna = 0xff;	// diversity
	pAdapter->PortCfg.CurrentRxAntenna = 0xff;	// diversity
	pAdapter->PortCfg.NumberOfAntenna =	2;	
	pAdapter->PortCfg.TxPower =	MAX_TX_POWER_LEVEL;	//mW
   pAdapter->PortCfg.TxPowerPercentage = 100;      // 100% as calibrated during manufacturing
	NdisZeroMemory(&pAdapter->PortCfg.Bssid, MAC_ADDR_LEN);
	NdisFillMemory(&pAdapter->PortCfg.Broadcast, MAC_ADDR_LEN, 0xff);
	pAdapter->PortCfg.LastRssi = 60;
	pAdapter->PortCfg.Channel =	1;
	pAdapter->PortCfg.SsidLen =	0;
	NdisZeroMemory(pAdapter->PortCfg.Ssid, MAX_LEN_OF_SSID);  // NOT NULL-terminated

	if((pAdapter->PortCfg.SsidLen <= 0)	|| (pAdapter->PortCfg.SsidLen >= MAX_LEN_OF_SSID))
	{
		NdisMoveMemory(pAdapter->PortCfg.Ssid, "AP2500-", 7);
		pAdapter->PortCfg.Ssid[7] =	(((pAdapter->CurrentAddress[5] >> 4) > 9) ?	((pAdapter->CurrentAddress[5] >> 4)	- 10 + 'A')	: ((pAdapter->CurrentAddress[5]	>> 4) +	'0'));
		pAdapter->PortCfg.Ssid[8] =	(((pAdapter->CurrentAddress[5] & 0x0F) > 9)	? ((pAdapter->CurrentAddress[5]& 0x0F) - 10	+ 'A') : ((pAdapter->CurrentAddress[5]&	0x0F) +	'0'));
		pAdapter->PortCfg.SsidLen =	9;
		DBGPRINT(RT_DEBUG_TRACE, "DefApSSID	(Len=%d, ssid=%s...)\n", pAdapter->PortCfg.SsidLen,	pAdapter->PortCfg.Ssid);
	}

	// PHY specification
	pAdapter->PortCfg.PhyMode =	0xff;
	RTMPSetPhyMode(pAdapter, PHY_11BG_MIXED);	// default in 11BG mixed mode
	pAdapter->PortCfg.Dsifs	= 10;	   // in units of usec 
	pAdapter->PortCfg.TxPreamble = Rt802_11PreambleLong; //	use	Long preamble on TX	by defaut

	// user	desired	power mode
	pAdapter->PortCfg.WindowsPowerMode = Ndis802_11PowerModeCAM; //	Ndis802_11PowerModeFast_PSP;
	pAdapter->PortCfg.WindowsBatteryPowerMode =	Ndis802_11PowerModeCAM;	// Ndis802_11PowerModeFast_PSP;
	pAdapter->PortCfg.WindowsACCAMEnable = FALSE;
//	  pAdapter->PortCfg.PacketFilter = NDIS_PACKET_TYPE_ALL_MULTICAST |	NDIS_PACKET_TYPE_DIRECTED |	NDIS_PACKET_TYPE_BROADCAST;
	pAdapter->bAcceptDirect	= TRUE;
	pAdapter->bAcceptMulticast = FALSE;
	pAdapter->bAcceptBroadcast = TRUE;
	pAdapter->bAcceptAllMulticast =	TRUE;

	pAdapter->PortCfg.RfType = RFIC_2522;
	pAdapter->PortCfg.LedMode =	LED_MODE_DEFAULT;
	init_timer(&pAdapter->PortCfg.RfTuningTimer);
	pAdapter->PortCfg.RfTuningTimer.data = (unsigned long)pAdapter;
	pAdapter->PortCfg.RfTuningTimer.function = &AsicRfTuningExec;
	
	pAdapter->bTxBusy =	FALSE;

//	  pAdapter->bRaConfig =	FALSE;

	pAdapter->PortCfg.bLocalAdminMAC = TRUE;

// dynamic BBP R17:sensibity tuning	to overcome	background noise
	pAdapter->PortCfg.BbpTuningEnable  = TRUE;	// overwritten by E2PROM setting
	pAdapter->PortCfg.VgcLowerBound	   = 0x38;	// overwritten by E2PROM setting
	pAdapter->PortCfg.BbpTuning.FalseCcaLowerThreshold = 100;
	pAdapter->PortCfg.BbpTuning.FalseCcaUpperThreshold = 4;	// unit	128; 4*128=512
	pAdapter->PortCfg.BbpTuning.VgcDelta			   = 1;
	pAdapter->PortCfg.BbpTuning.VgcUpperBound		   = 0x40;

#ifdef RALINK_ATE
	memset(&pAdapter->ate, 0, sizeof(ATE_INFO));
	pAdapter->ate.Mode = ATE_APSTART;
	pAdapter->ate.TxCount = TX_RING_SIZE;
	pAdapter->ate.TxLength = PRIO_BUFFER_SIZE;
	pAdapter->ate.TxRate = RATE_11;
	memcpy(&pAdapter->ate.Addr1,"001122334455", ETH_LENGTH_OF_ADDRESS);
	memcpy(&pAdapter->ate.Addr2,"001122334455", ETH_LENGTH_OF_ADDRESS);
	memcpy(&pAdapter->ate.Addr3,"001122334455", ETH_LENGTH_OF_ADDRESS);
#endif	//#ifdef RALINK_ATE

	RTMP_IO_READ32(pAdapter, 0, &pAdapter->PortCfg.Rt2560Version);
	DBGPRINT(RT_DEBUG_TRACE, "<-- PortCfgInit (rt2560 ver#%d)\n", pAdapter->PortCfg.Rt2560Version);
}

UCHAR BtoH(char	ch)
{
	if (ch >= '0' && ch	<= '9')	return (ch - '0');		  // Handle	numerals
	if (ch >= 'A' && ch	<= 'F')	return (ch - 'A' + 0xA);  // Handle	capitol	hex	digits
	if (ch >= 'a' && ch	<= 'f')	return (ch - 'a' + 0xA);  // Handle	small hex digits
	return(255);
}

//
//	FUNCTION: AtoH(char	*, UCHAR *,	int)
//
//	PURPOSE:  Converts ascii string	to network order hex
//
//	PARAMETERS:
//	  src	 - pointer to input	ascii string
//	  dest	 - pointer to output hex
//	  destlen -	size of	dest
//
//	COMMENTS:
//
//	  2	ascii bytes	make a hex byte	so must	put	1st	ascii byte of pair
//	  into upper nibble	and	2nd	ascii byte of pair into	lower nibble.
//

void AtoH(char * src, UCHAR	* dest,	int	destlen)
{
	char *srcptr;
	PUCHAR destTemp;

	srcptr = src;	
	destTemp = (PUCHAR)	dest; 

	while(destlen--)
	{
		*destTemp =	BtoH(*srcptr++)	<< 4;	 //	Put	1st	ascii byte in upper	nibble.
		*destTemp += BtoH(*srcptr++);	   // Add 2nd ascii	byte to	above.
		destTemp++;
	}
}

