/******************************************************************************

    File:               isl38xx_gen.c
    Author:             W.Termorshuizen
    Version:            0.3.0.2
    Created:            June 19th, 2002
    Updated:            November 11th, 2002
    Company:            Intersil Americas Inc.
    Description:        This file contains the linux driver for the Intersil
                        Wireless LAN adapters.
    History:	    	Maintained in file isl38xx.h
    		
******************************************************************************/
#define __KERNEL_SYSCALLS__


#include <linux/version.h>
#ifdef MODULE
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#include <linux/module.h>
#else
#define MOD_INC_USE_COUNT
#define MOD_DEC_USE_COUNT
#endif

#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <linux/wait.h>

#include <asm/processor.h>      // Processor type for cache alignment.
#include <asm/bitops.h>
#include <asm/io.h>

#include <linux/netdevice.h>
#include <linux/if_arp.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>

#include <pcmcia/driver_ops.h>
#include <asm/uaccess.h>
#include <linux/unistd.h>
#include <linux/wireless.h>

#include "bloboidv2.h"      // additional types and defs for isl38xx fw
#include "isl38xx.h"


#define DEBUG( f, args... ) 	K_DEBUG( f, pc_debug, args )

/******************************************************************************
    Global variable definition section
******************************************************************************/
extern int pc_debug;

/******************************************************************************
    Driver general functions
******************************************************************************/
void display_buffer(char *buffer, int length)
{
    if( ( pc_debug & SHOW_BUFFER_CONTENTS ) == 0 )
        return;

    while (length > 0)
    {
        printk( "[%02x]", *buffer & 255 );
        length--;
        buffer++;
    }

    printk( "\n" );
}

void print_frame(struct sk_buff *skb)
{
    int offset;

    printk("pr_frame: size %d, skb->data %p, skb %p\n",
        skb->len, skb->data, skb);
    for (offset = 0; offset < skb->len; offset++)
        printk("%02X ", skb->data[offset]);
    printk("\n");
}


void string_to_macaddress( unsigned char *string, unsigned char *mac )
{
    unsigned char *wp = mac, *rp;
    unsigned int value;
    unsigned int count = 0;

    for( rp = string; *rp != '\0'; rp++, wp++, count++ )
    {
        if( count == 6 )
            break;

        if( *rp >= '0' && *rp <= '9' )
            value = *rp - '0';
        else if( *rp >= 'a' && *rp <= 'f' )
            value = *rp - 'a' + 10;
        else if( *rp >= 'A' && *rp <= 'F' )
            value = *rp - 'A' + 10;
        else
            break;

        value <<= 4;
            rp++;
        if( *rp >= '0' && *rp <= '9' )
            value |= *rp - '0';
        else if( *rp >= 'a' && *rp <= 'f')
            value |= *rp - 'a' + 10;
        else if( *rp >= 'A' && *rp <= 'F')
            value |= *rp - 'A' + 10;
        else
            break;

        *wp = (unsigned char) value;
    }
}

int address_compare( unsigned char *address1, unsigned char *address2 )
{
    u32 *address1_hi, *address2_hi;
    u16 *address1_lo, *address2_lo;

    address2_hi = (u32 *) address2;
    address1_hi = (u32 *) address1;
    address2_lo = (u16 *) (address2 + 4);
    address1_lo = (u16 *) (address1 + 4);

    DEBUG(SHOW_TRACING, "address_compare: a1 %08x:%04x a2 %08x:%04x\n",
        *address1_hi, *address1_lo, *address2_hi, *address2_lo );

    return ((*address2_hi == *address1_hi) && (*address2_lo == *address1_lo));
}

/******************************************************************************
    Memory Management functions
******************************************************************************/
void init_queue(queue_root * queue)
{
    queue->host_address = (u32) NULL;
    queue->dev_address = (u32) NULL;
    queue->size = 0;
    queue->fragments = 0;
}

int put_queue(void *device, queue_root * queue, queue_entry * entry)
{
    queue_entry *last;

    // the size and next members are both accessed from kernel code and from
    // interrupt handler, disable the update interrupt as short as possible
    disable_update_interrupt(device);

    // check whether the queue is empty or not
    if (queue->size == 0)
    {
        // queue is empty, add the entry at the start of the queue
        queue->next = (void *) entry;
        queue->last = (void *) entry;
    }
    else
    {
        // the queue is not empty, add the entry at the back
        last = (queue_entry *) queue->last;
        last->next = (void *) entry;
        queue->last = (void *) entry;
    }

    // increment the queue size
    queue->size++;

    // enable the update interrupt again
    enable_update_interrupt(device);

    return 0;
}

int get_queue(void *device, queue_root * queue,
                     queue_entry ** entry)
{
    queue_entry *first;

    // the size and next members are both accessed from kernel code and from
    // interrupt handler, disable the update interrupt as short as possible
    disable_update_interrupt(device);

    // check whether the queue is empty or not
    if (queue->size == 0)
    {
        // queue is empty, nothing to get
        // enable the update interrupt again
        enable_update_interrupt(device);

        return -1;
    }
    else
    {
        // the queue is not empty, get the entry at the start
        first = (queue_entry *) queue->next;
        queue->next = first->next;
        first->next = NULL;
        *entry = first;
    }

    // decrement the queue size
    queue->size--;

    // enable the update interrupt again
    enable_update_interrupt(device);

    return 0;
}

#if 0
int queue_size(void *device, queue_root * queue)
{
    int qsize;

    // disable the update interrupt of the device
    disable_update_interrupt(device);

    // read the size of the queue from the root entry
    qsize = (int) queue->size;

    // enable the update interrupt of the device
    enable_update_interrupt(device);

    return qsize;
}
#endif	/* 0 */








