/******************************************************************************
 *
 * Name:	skgehw.h
 * Project:	GEnesis, PCI Gigabit Ethernet Adapter
 * Version:	$Revision: 1.3 $
 * Date:	$Date: 2002/08/19 19:20:33 $
 * Purpose:	Defines and Macros for the Gigabit Ethernet Adapter Product
 *		Family
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 1998-2000 SysKonnect GmbH.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * History:
 * $Log: skgehw.h,v $
 * Revision 1.3  2002/08/19 19:20:33  m4
 * Upgrade to changes put in by australian snapgear -- uclinux.org (2.4.17).
 * Upgrade to kernel 2.4.19 (kernel.org) with brecis linux changes.
 *
 * Revision 1.36  2000/11/09 12:32:49  rassmann
 * Renamed variables.
 *
 * Revision 1.35  2000/05/19 10:17:13  cgoos
 * Added inactivity check in PHY_READ (in DEBUG mode only).
 *
 * Revision 1.34  1999/11/22 13:53:40  cgoos
 * Changed license header to GPL.
 *
 * Revision 1.33  1999/08/27 11:17:10  malthoff
 * It's more savely to put bracket around marco parameters.
 * Brackets added for PHY_READ and PHY_WRITE.
 *
 * Revision 1.32  1999/05/19 07:31:01  cgoos
 * Changes for 1000Base-T.
 * Added HWAC_LINK_LED macro.
 *
 * Revision 1.31  1999/03/12 13:27:40  malthoff
 * Remove __STDC__.
 *
 * Revision 1.30  1999/02/09 09:28:20  malthoff
 * Add PCI_ERRBITS.
 *
 * Revision 1.29  1999/01/26 08:55:48  malthoff
 * Bugfix: The 16 bit field releations inside the descriptor are
 * 	endianess dependend if the descriptor reversal feature
 * 	(PCI_REV_DESC bit in PCI_OUR_REG_2) is enabled.
 * 	Drivers which use this feature has to set the define
 * 	SK_USE_REV_DESC.
 *
 * Revision 1.28  1998/12/10 11:10:22  malthoff
 * bug fix: IS_IRQ_STAT and IS_IRQ_MST_ERR has been twisted.
 *
 * Revision 1.27  1998/11/13 14:19:21  malthoff
 * Bug Fix: The bit definition of B3_PA_CTRL has completely
 * changed from HW Spec v1.3 to v1.5.
 *
 * Revision 1.26  1998/11/04 08:31:48  cgoos
 * Fixed byte ordering in XM_OUTADDR/XM_OUTHASH macros.
 *
 * Revision 1.25  1998/11/04 07:16:25  cgoos
 * Changed byte ordering in XM_INADDR/XM_INHASH again.
 *
 * Revision 1.24  1998/11/02 11:08:43  malthoff
 * RxCtrl and TxCtrl must be volatile.
 *
 * Revision 1.23  1998/10/28 13:50:45  malthoff
 * Fix: Endian support missing in XM_IN/OUT-ADDR/HASH macros.
 *
 * Revision 1.22  1998/10/26 08:01:36  malthoff
 * RX_MFF_CTRL1 is split up into RX_MFF_CTRL1,
 * RX_MFF_STAT_TO, and RX_MFF_TIST_TO.
 * TX_MFF_CTRL1 is split up TX_MFF_CTRL1 and TX_MFF_WAF.
 *
 * Revision 1.21  1998/10/20 07:43:10  malthoff
 * Fix: XM_IN/OUT/ADDR/HASH macros:
 * The pointer must be casted.
 *
 * Revision 1.20  1998/10/19 15:53:59  malthoff
 * Remove ML proto definitions.
 *
 * Revision 1.19  1998/10/16 14:40:17  gklug
 * fix: typo B0_XM_IMSK regs
 *
 * Revision 1.18  1998/10/16 09:46:54  malthoff
 * Remove temp defines for ML diag prototyp.
 * Fix register definition for B0_XM1_PHY_DATA, B0_XM1_PHY_DATA
 * B0_XM2_PHY_DATA, B0_XM2_PHY_ADDR, B0_XA1_CSR, B0_XS1_CSR,
 * B0_XS2_CSR, and B0_XA2_CSR.
 *
 * Revision 1.17  1998/10/14 06:03:14  cgoos
 * Changed shifted constant to ULONG.
 *
 * Revision 1.16  1998/10/09 07:05:41  malthoff
 * Rename ALL_PA_ENA_TO to PA_ENA_TO_ALL.
 *
 * Revision 1.15  1998/10/05 07:54:23  malthoff
 * Split up RB_CTRL and it's bit definition into
 * RB_CTRL, RB_TST1, and RB_TST2.
 * Rename RB_RX_HTPP to RB_RX_LTPP.
 * Add ALL_PA_ENA_TO. Modify F_WATER_MARK
 * according to HW Spec. v1.5.
 * Add MFF_TX_CTRL_DEF.
 *
 * Revision 1.14  1998/09/28 13:31:16  malthoff
 * bug fix: B2_MAC_3 is 0x110 not 0x114
 *
 * Revision 1.13  1998/09/24 14:42:56  malthoff
 * Split the RX_MFF_TST into RX_MFF_CTRL2,
 * RX_MFF_TST1, and RX_MFF_TST2.
 * Rename RX_MFF_CTRL to RX_MFF_CTRL1.
 * Add BMU bit CSR_SV_IDLE.
 * Add macros PHY_READ() and PHY_WRITE().
 * Rename macro SK_ADDR() to SK_HW_ADDR()
 * because of conflicts with the Address Module.
 *
 * Revision 1.12  1998/09/16 07:25:33  malthoff
 * Change the parameter order in the XM_INxx and XM_OUTxx macros,
 * to have the IoC as first parameter.
 *
 * Revision 1.11  1998/09/03 09:58:41  malthoff
 * Rework the XM_xxx macros. Use {} instead of () to
 * be compatible with SK_xxx macros which are defined
 * with {}.
 *
 * Revision 1.10  1998/09/02 11:16:39  malthoff
 * Temporary modify B2_I2C_SW to make tests with
 * the GE/ML prototyp.
 *
 * Revision 1.9  1998/08/19 09:11:49  gklug
 * fix: struct are removed from c-source (see CCC)
 * add: typedefs for all structs
 *
 * Revision 1.8  1998/08/18 08:27:27  malthoff
 * Add some temporary workarounds to test GE
 * sources with the ML.
 *
 * Revision 1.7  1998/07/03 14:42:26  malthoff
 * bug fix: Correct macro XMA().
 * Add temporary workaround to access the PCI config space over IO
 *
 * Revision 1.6  1998/06/23 11:30:36  malthoff
 * Remove ';' with ',' in macors.
 *
 * Revision 1.5  1998/06/22 14:20:57  malthoff
 * Add macro SK_ADDR(Base,Addr).
 *
 * Revision 1.4  1998/06/19 13:35:43  malthoff
 * change 'pGec' with 'pAC'
 *
 * Revision 1.3  1998/06/17 14:58:16  cvs
 * Lost keywords reinserted.
 *
 * Revision 1.1  1998/06/17 14:16:36  cvs
 * created
 *
 *
 ******************************************************************************/

#ifndef __INC_SKGEHW_H
#define __INC_SKGEHW_H

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */

/* defines ********************************************************************/

/*
 * Configuration Space header
 * Since this module is used for different OS', those may be
 * duplicate on some of them (e.g. Linux). But to keep the
 * common source, we have to live with this...
 */
#define	PCI_VENDOR_ID	0x00	/* 16 bit	Vendor ID */
#define	PCI_DEVICE_ID	0x02	/* 16 bit	Device ID */
#define	PCI_COMMAND		0x04	/* 16 bit	Command */
#define	PCI_STATUS		0x06	/* 16 bit	Status */
#define	PCI_REV_ID		0x08	/*  8 bit	Revision ID */
#define	PCI_CLASS_CODE	0x09	/* 24 bit	Class Code */
#define	PCI_CACHE_LSZ	0x0c	/*  8 bit	Cache Line Size */
#define	PCI_LAT_TIM		0x0d	/*  8 bit	Latency Timer */
#define	PCI_HEADER_T	0x0e	/*  8 bit	Header Type */
#define	PCI_BIST		0x0f	/*  8 bit	Built-in selftest */
#define	PCI_BASE_1ST	0x10	/* 32 bit	1st Base address */
#define	PCI_BASE_2ND	0x14	/* 32 bit	2nd Base address */
	/* Byte 18..2b:	reserved */
#define	PCI_SUB_VID		0x2c	/* 16 bit	Subsystem Vendor ID */
#define	PCI_SUB_ID		0x2e	/* 16 bit	Subsystem ID */
#define	PCI_BASE_ROM	0x30	/* 32 bit	Expansion ROM Base Address */
	/* Byte 34..33:	reserved */
#define PCI_CAP_PTR		0x34	/*  8 bit 	Capabilities Ptr */
	/* Byte 35..3b:	reserved */
#define	PCI_IRQ_LINE	0x3c	/*  8 bit	Interrupt Line */
#define	PCI_IRQ_PIN		0x3d	/*  8 bit	Interrupt Pin */
#define	PCI_MIN_GNT		0x3e	/*  8 bit	Min_Gnt */
#define	PCI_MAX_LAT		0x3f	/*  8 bit	Max_Lat */
	/* Device Dependent Region */
#define	PCI_OUR_REG_1	0x40	/* 32 bit 	Our Register 1 */
#define	PCI_OUR_REG_2	0x44	/* 32 bit 	Our Register 2 */
	/* Power Management Region */
#define PCI_PM_CAP_ID	0x48	/*  8 bit 	Power Management Cap. ID */
#define PCI_PM_NITEM	0x49	/*  8 bit 	Next Item Ptr */
#define PCI_PM_CAP_REG	0x4a	/* 16 bit 	Power Management Capabilities */
#define PCI_PM_CTL_STS	0x4c	/* 16 bit 	Power Manag. Control/Status */
	/* Byte 0x4e:	reserved */
#define PCI_PM_DAT_REG	0x4f	/*  8 bit 	Power Manag. Data Register */
	/* VPD Region */
#define	PCI_VPD_CAP_ID	0x50	/*  8 bit 	VPD Cap. ID */
#define PCI_VPD_NITEM	0x51	/*  8 bit 	Next Item Ptr */
#define PCI_VPD_ADR_REG	0x52	/* 16 bit 	VPD Address Register */
#define PCI_VPD_DAT_REG	0x54	/* 32 bit 	VPD Data Register */
	/* Byte 58..ff:	reserved */

/*
 * I2C Address (PCI Config)
 *
 * Note: The temperature and voltage sensors are relocated on a different
 *	 I2C bus.
 */
#define I2C_ADDR_VPD	0xA0	/* I2C address for the VPD EEPROM */

/*
 * Define Bits and Values of the registers
 */
/*	PCI_VENDOR_ID	16 bit	Vendor ID */
/*	PCI_DEVICE_ID	16 bit	Device ID */
/* Values for Vendor ID and Device ID shall be patched into the code */
/*	PCI_COMMAND	16 bit	Command */
								/* Bit 15..10:	reserved */
#define	PCI_FBTEN		(1<<9)	/* Bit 9:	Fast Back-To-Back enable */
#define	PCI_SERREN		(1<<8)	/* Bit 8:	SERR enable */
#define	PCI_ADSTEP		(1<<7)	/* Bit 7:	Address Stepping */
#define	PCI_PERREN		(1<<6)	/* Bit 6:	Parity Report Response enable */
#define	PCI_VGA_SNOOP	(1<<5)	/* Bit 5:	VGA palette snoop */
#define	PCI_MWIEN		(1<<4)	/* Bit 4:	Memory write an inv cycl ena */
#define	PCI_SCYCEN		(1<<3)	/* Bit 3:	Special Cycle enable */
#define	PCI_BMEN		(1<<2)	/* Bit 2:	Bus Master enable */
#define	PCI_MEMEN		(1<<1)	/* Bit 1:	Memory Space Access enable */
#define	PCI_IOEN		(1<<0)	/* Bit 0:	IO Space Access enable */

/*	PCI_STATUS	16 bit	Status */
#define	PCI_PERR		(1<<15)	/* Bit 15:	Parity Error */
#define	PCI_SERR		(1<<14)	/* Bit 14:	Signaled SERR */
#define	PCI_RMABORT		(1<<13)	/* Bit 13:	Received Master Abort */
#define	PCI_RTABORT		(1<<12)	/* Bit 12:	Received Target Abort */
								/* Bit 11:	reserved */
#define	PCI_DEVSEL		(3<<9)	/* Bit 10..9:	DEVSEL Timing */
#define	PCI_DEV_FAST	(0<<9)	/*		fast */
#define	PCI_DEV_MEDIUM	(1<<9)	/*		medium */
#define	PCI_DEV_SLOW	(2<<9)	/*		slow */
#define	PCI_DATAPERR	(1<<8)	/* Bit 8:	DATA Parity error detected */
#define	PCI_FB2BCAP		(1<<7)	/* Bit 7:	Fast Back-to-Back Capability */
#define	PCI_UDF			(1<<6)	/* Bit 6:	User Defined Features */
#define PCI_66MHZCAP	(1<<5)	/* Bit 5:	66 MHz PCI bus clock capable */
#define PCI_NEWCAP		(1<<4)	/* Bit 4:	New cap. list implemented */
								/* Bit 3..0:	reserved */

#define PCI_ERRBITS	(PCI_PERR | PCI_SERR | PCI_RMABORT | PCI_RTABORT |\
			PCI_DATAPERR)

/*	PCI_CLASS_CODE	24 bit	Class Code */
/*	Byte 2:		Base Class		(02) */
/*	Byte 1:		SubClass		(00) */
/*	Byte 0:		Programming Interface	(00) */

/*	PCI_CACHE_LSZ	8 bit	Cache Line Size */
/*	Possible values: 0,2,4,8,16,32,64,128	*/

/*	PCI_HEADER_T	8 bit	Header Type */
#define	PCI_HD_MF_DEV	(1<<7)	/* Bit 7:	0= single, 1= multi-func dev */
#define	PCI_HD_TYPE		0x7f	/* Bit 6..0:	Header Layout 0= normal */

/*	PCI_BIST	8 bit	Built-in selftest */
/*	Built-in Self test not supported (optional) */

/*	PCI_BASE_1ST	32 bit	1st Base address */
#define	PCI_MEMSIZE		0x4000L		/* use 16 kB Memory Base */
#define	PCI_MEMBASE_MSK 0xffffc000L	/* Bit 31..14:	Memory Base Address */
#define	PCI_MEMSIZE_MSK 0x00003ff0L	/* Bit 13.. 4:	Memory Size Req. */
#define	PCI_PREFEN		(1L<<3)		/* Bit	3:	Prefetchable */
#define	PCI_MEM_TYP		(3L<<2)		/* Bit	2.. 1:	Memory Type */
#define	PCI_MEM32BIT	(0L<<1)		/* Base addr anywhere in 32 Bit range */
#define	PCI_MEM1M		(1L<<1)		/* Base addr below 1 MegaByte */
#define	PCI_MEM64BIT	(2L<<1)		/* Base addr anywhere in 64 Bit range */
#define	PCI_MEMSPACE	(1L<<0)		/* Bit	0:	Memory Space Indic. */

/*	PCI_BASE_2ND	32 bit	2nd Base address */
#define	PCI_IOBASE		0xffffff00L	/* Bit 31..8:	I/O Base address */
#define	PCI_IOSIZE		0x000000fcL	/* Bit	7..2:	I/O Size Requirements */
									/* Bit	1:	reserved */
#define	PCI_IOSPACE		(1L<<0)		/* Bit	0:	I/O Space Indicator */

/*	PCI_BASE_ROM	32 bit	Expansion ROM Base Address */
#define	PCI_ROMBASE		(0xfffeL<<17)	/* Bit 31..17:	ROM BASE address (1st)*/
#define	PCI_ROMBASZ		(0x1cL<<14)	/* Bit 16..14:	Treat as BASE or SIZE */
#define	PCI_ROMSIZE		(0x38L<<11)	/* Bit 13..11:	ROM Size Requirements */
									/* Bit 10.. 1:	reserved */
#define	PCI_ROMEN		(0x1L<<0)	/* Bit 0:	Address Decode enable */

/* Device Dependent Region */
/*	PCI_OUR_REG_1		32 bit	Our Register 1 */
									/* Bit 31..26:	reserved */
#define PCI_VIO			(1L<<25)	/* Bit 25:	PCI IO Voltage, */
									/*		0 = 3.3V / 1 = 5V */
#define	PCI_EN_BOOT		(1L<<24)	/* Bit 24:	Enable BOOT via ROM */
									/*		1 = Don't boot wth ROM*/
									/*		0 = Boot with ROM */
#define	PCI_EN_IO		(1L<<23)	/* Bit 23:	Mapping to IO space */
#define	PCI_EN_FPROM	(1L<<22)	/* Bit 22:	FLASH mapped to mem? */
									/*		1 = Map Flash to Mem */
									/*		0 = Disable addr. dec*/
#define	PCI_PAGESIZE	(3L<<20)	/* Bit 21..20:	FLASH Page Size	*/
#define	PCI_PAGE_16		(0L<<20)	/*		16 k pages	*/
#define	PCI_PAGE_32K	(1L<<20)	/*		32 k pages	*/
#define	PCI_PAGE_64K	(2L<<20)	/*		64 k pages	*/
#define	PCI_PAGE_128K	(3L<<20)	/*		128 k pages	*/
									/* Bit 19:	reserved	*/
#define	PCI_PAGEREG		(7L<<16)	/* Bit 18..16:	Page Register	*/
#define PCI_NOTAR		(1L<<15)	/* Bit 15:	No turnaround cycle */
#define	PCI_FORCE_BE	(1L<<14)	/* Bit 14:	Assert all BEs on MR */
#define	PCI_DIS_MRL		(1L<<13)	/* Bit 13:	Disable Mem R Line */
#define	PCI_DIS_MRM		(1L<<12)	/* Bit 12:	Disable Mem R multip */
#define	PCI_DIS_MWI		(1L<<11)	/* Bit 11:	Disable Mem W & inv */
#define	PCI_DISC_CLS	(1L<<10)	/* Bit 10:	Disc: cacheLsz bound */
#define	PCI_BURST_DIS	(1L<<9)		/* Bit	9:	Burst Disable */
#define	PCI_DIS_PCI_CLK	(1L<<8)		/* Bit	8:	Disable PCI clock driv*/
#define	PCI_SKEW_DAS	(0xfL<<4)	/* Bit	7..4:	Skew Ctrl, DAS Ext */
#define	PCI_SKEW_BASE	(0xfL<<0)	/* Bit	3..0:	Skew Ctrl, Base	*/


/*	PCI_OUR_REG_2		32 bit	Our Register 2 */
#define PCI_VPD_WR_THR	(0xffL<<24)	/* Bit 31..24:	VPD Write Threshold */
#define	PCI_DEV_SEL		(0x7fL<<17)	/* Bit 23..17:	EEPROM Device Select */
#define	PCI_VPD_ROM_SZ	(7L<<14)	/* Bit 16..14:	VPD ROM Size	*/
									/* Bit 13..12:	reserved	*/
#define	PCI_PATCH_DIR	(0xfL<<8)	/* Bit 11.. 8:	Ext Patchs dir 3..0 */
#define	PCI_PATCH_DIR_0	(1L<<8)
#define	PCI_PATCH_DIR_1	(1L<<9)
#define	PCI_PATCH_DIR_2	(1L<<10)
#define	PCI_PATCH_DIR_3	(1L<<11)
#define PCI_EXT_PATCHS	(0xfL<<4)	/* Bit	7..4:	Extended Patches 3..0 */
#define	PCI_EXT_PATCH_0	(1L<<4)
#define	PCI_EXT_PATCH_1	(1L<<5)
#define	PCI_EXT_PATCH_2	(1L<<6)
#define	PCI_EXT_PATCH_3	(1L<<7)
#define	PCI_EN_DUMMY_RD	(1L<<3)		/* Bit	3:	Enable Dummy Read */
#define PCI_REV_DESC	(1L<<2)		/* Bit	2:	Reverse Desc. Bytes */
									/* Bit	1:	reserved */
#define PCI_USEDATA64	(1L<<0)		/* Bit	0:	Use 64Bit Data bus ext*/


/* Power Management Region */
/*	PCI_PM_CAP_REG		16 bit	Power Management Capabilities */
#define	PCI_PME_SUP		(0x1f<<11)	/* Bit 15..11:	PM Manag. Event Sup */
#define PCI_PM_D2_SUB	(1<<10)		/* Bit 10:	D2 Support Bit */
#define PCI_PM_D1_SUB	(1<<9)		/* Bit	9:	D1 Support Bit */
									/* Bit	8..6:	reserved */
#define PCI_PM_DSI		(1<<5)		/* Bit	5:	Device Specific Init.*/
#define PCI_PM_APS		(1<<4)		/* Bit	4:	Auxialiary Power Src */
#define PCI_PME_CLOCK	(1<<3)		/* Bit	3:	PM Event Clock */
#define PCI_PM_VER		(7<<0)		/* Bit	2..0:	PM PCI Spec. version */

/*	PCI_PM_CTL_STS		16 bit	Power Manag. Control/Status */
#define	PCI_PME_STATUS	(1<<15)		/* Bit 15: 	PGA doesn't sup. PME# */
#define PCI_PM_DAT_SCL	(3<<13)		/* Bit 14..13:	dat reg Scaling factor*/
#define PCI_PM_DAT_SEL	(0xf<<9)	/* Bit 12.. 9:	PM data selector field*/
#define PCI_PME_EN		(1<<8)		/* Bit	8:	PGA doesn't sup. PME# */
									/* Bit	7.. 2:	reserved */
#define PCI_PM_STATE	(3<<0)		/* Bit	1.. 0:	Power Management State*/
#define PCI_PM_STATE_D0	(0<<0)		/* D0:	Operational (default) */
#define	PCI_PM_STATE_D1	(1<<0)		/* D1:	not supported */
#define PCI_PM_STATE_D2	(2<<0)		/* D2:	not supported */
#define PCI_PM_STATE_D3 (3<<0)		/* D3:	HOT, Power Down and Reset */

/* VPD Region */
/*	PCI_VPD_ADR_REG		16 bit	VPD Address Register */
#define	PCI_VPD_FLAG	(1L<<15)	/* Bit 15:	starts VPD rd/wd cycle*/
#define PCI_VPD_ADDR	(0x3fffL<<0)	/* Bit 14..0:	VPD address */

/*
 *	Control Register File:
 *	Bank 0
 */
#define	B0_RAP			0x0000	/*  8 bit	Register Address Port */
	/* 0x0001 - 0x0003:	reserved */
#define	B0_CTST			0x0004	/* 16 bit	Control/Status register */
#define	B0_LED			0x0006	/*  8 Bit	LED register */
	/* 0x0007:		reserved */
#define	B0_ISRC			0x0008	/* 32 bit	Interrupt Source Register */
#define	B0_IMSK			0x000c	/* 32 bit	Interrupt Mask Register */
#define B0_HWE_ISRC		0x0010	/* 32 bit	HW Error Interrupt Src Reg */
#define B0_HWE_IMSK		0x0014	/* 32 bit	HW Error Interrupt Mask Reg */
#define B0_SP_ISRC		0x0018	/* 32 bit	Special Interrupt Source Reg */
	/* 0x001c:		reserved */

/* B0 XMAC 1 registers */
#define	B0_XM1_IMSK		0x0020	/* 16 bit r/w	XMAC 1 Interrupt Mask Register*/
	/* 0x0022 - 0x0027	reserved */
#define B0_XM1_ISRC		0x0028	/* 16 bit ro	XMAC 1 Interrupt Status Reg */
	/* 0x002a - 0x002f	reserved */
#define B0_XM1_PHY_ADDR 0x0030	/* 16 bit r/w	XMAC 1 PHY Address Register */
	/* 0x0032 - 0x0033	reserved */
#define B0_XM1_PHY_DATA 0x0034	/* 16 bit r/w	XMAC 1 PHY Data Register */
	/* 0x0036 - 0x003f	reserved */

/* B0 XMAC 2 registers */
#define	B0_XM2_IMSK		0x0040	/* 16 bit r/w	XMAC 2 Interrupt Mask Register*/
	/* 0x0042 - 0x0047	reserved */
#define B0_XM2_ISRC		0x0048	/* 16 bit ro	XMAC 2 Interrupt Status Reg */
	/* 0x004a - 0x004f	reserved */
#define B0_XM2_PHY_ADDR 0x0050	/* 16 bit r/w	XMAC 2 PHY Address Register */
	/* 0x0052 - 0x0053	reserved */
#define B0_XM2_PHY_DATA 0x0054	/* 16 bit r/w	XMAC 2 PHY Data Register */
				/* 0x0056 - 0x005f	reserved */

/* BMU Control Status Registers */
#define	B0_R1_CSR		0x0060	/* 32 bit	BMU Ctrl/Stat Rx Queue 1 */
#define	B0_R2_CSR		0x0064	/* 32 bit	BMU Ctrl/Stat Rx Queue 2 */
#define	B0_XS1_CSR		0x0068	/* 32 bit	BMU Ctrl/Stat Sync Tx Queue 1 */
#define	B0_XA1_CSR		0x006c	/* 32 bit	BMU Ctrl/Stat Async Tx Queue 1*/
#define	B0_XS2_CSR		0x0070	/* 32 bit	BMU Ctrl/Stat Sync Tx Queue 2 */
#define	B0_XA2_CSR		0x0074	/* 32 bit	BMU Ctrl/Stat Async Tx Queue 2*/
	/* x0078 - 0x007f	reserved */

/*
 *	Bank 1
 *	- completely empty (this is the RAP Block window)
 *	Note: if RAP = 1 this page is reserved
 */

/*
 *	Bank 2
 */
/* NA reg = 48 bit Network Address Register, 3x16 or 8x8 bit readable */

#define	B2_MAC_1		0x0100	/* NA reg	 MAC Address 1 */
	/* 0x0106 - 0x0107	reserved */
#define	B2_MAC_2		0x0108	/* NA reg	 MAC Address 2 */
	/* 0x010e - 0x010f	reserved */
#define	B2_MAC_3		0x0110	/* NA reg	 MAC Address 3 */
	/* 0x0116 - 0x0117	reserved */
#define B2_CONN_TYP		0x0118	/*  8 bit	Connector type */
#define B2_PMD_TYP		0x0119	/*  8 bit	PMD type */
#define B2_MAC_CFG		0x011a	/*  8 bit	MAC Configuration */
#define B2_CHIP_REV		0x011b	/*  8 bit 	Queen Chip Revision Number */
	/* Eprom registers are currently of no use */
#define B2_E_0			0x011c	/*  8 bit	EPROM Byte 0 */
#define B2_E_1			0x011d	/*  8 bit	EPROM Byte 1 */
#define B2_E_2			0x011e	/*  8 bit	EPROM Byte 2 */
#define B2_E_3			0x011f	/*  8 bit	EPROM Byte 3 */
#define B2_FAR			0x0120	/* 32 bit	Flash-Prom Addr Reg/Cnt */
#define B2_FDP			0x0124	/*  8 bit	Flash-Prom Data Port */
	/* 0x0125 - 0x0127:	reserved */
#define B2_LD_CRTL		0x0128	/*  8 bit	EPROM loader control register */
#define B2_LD_TEST		0x0129	/*  8 bit	EPROM loader test register */
	/* 0x012a - 0x012f:	reserved */
#define B2_TI_INI		0x0130	/* 32 bit	Timer init value */
#define B2_TI_VAL		0x0134	/* 32 bit	Timer value */
#define B2_TI_CRTL		0x0138	/*  8 bit	Timer control */
#define B2_TI_TEST		0x0139	/*  8 Bit	Timer Test */
	/* 0x013a - 0x013f:	reserved */
#define B2_IRQM_INI		0x0140	/* 32 bit	IRQ Moderation Timer Init Reg.*/
#define B2_IRQM_VAL		0x0144	/* 32 bit	IRQ Moderation Timer Value */
#define B2_IRQM_CTRL	0x0148	/*  8 bit	IRQ Moderation Timer Control */
#define B2_IRQM_TEST	0x0149	/*  8 bit	IRQ Moderation Timer Test */
#define B2_IRQM_MSK 	0x014c	/* 32 bit	IRQ Moderation Mask */
#define B2_IRQM_HWE_MSK 0x0150	/* 32 bit	IRQ Moderation HW Error Mask */
	/* 0x0154 - 0x0157:	reserved */
#define	B2_TST_CTRL1	0x0158	/*  8 bit	Test Control Register 1 */
#define B2_TST_CTRL2	0x0159	/*  8 bit	Test Control Register 2 */
	/* 0x015a - 0x015b:	reserved */
#define B2_GP_IO		0x015c	/* 32 bit	General Purpose IO Register */
#define B2_I2C_CTRL		0x0160	/* 32 bit	I2C HW Control Register */
#define B2_I2C_DATA		0x0164	/* 32 bit	I2C HW Data Register */
#define B2_I2C_IRQ		0x0168	/* 32 bit	I2C HW IRQ Register */
#define B2_I2C_SW		0x016c	/* 32 bit	I2C SW Port Register */
#define B2_BSC_INI		0x0170	/* 32 bit	Blink Source Counter Init Val */
#define B2_BSC_VAL		0x0174	/* 32 bit	Blink Source Counter Value */
#define B2_BSC_CTRL		0x0178	/*  8 bit	Blink Source Counter Control */
#define B2_BSC_STAT		0x0179	/*  8 bit	Blink Source Counter Status */
#define B2_BSC_TST		0x017a	/* 16 bit	Blink Source Counter Test Reg */
	/* 0x017c - 0x017f:	reserved */

/*
 *	Bank 3
 */
#define B3_RAM_ADDR		0x0180	/* 32 bit	RAM Address, to read or write */
#define B3_RAM_DATA_LO	0x0184	/* 32 bit	RAM Data Word (low dWord) */
#define B3_RAM_DATA_HI	0x0188	/* 32 bit	RAM Data Word (high dWord) */
	/* 0x018c - 0x018f:	reserved */
/* RAM Interface Registers */
/*
 * The HW-Spec. call this registers Timeout Value 0..11. But this names are
 * not usable in SW. Please notice these are NOT real timeouts, these are
 * the number of qWords transfered continously.
 */
#define B3_RI_WTO_R1	0x0190	/* 8 bit RAM Iface WR Timeout Queue R1	(TO0) */
#define B3_RI_WTO_XA1	0x0191	/* 8 bit RAM Iface WR Timeout Queue XA1	(TO1) */
#define B3_RI_WTO_XS1	0x0192	/* 8 bit RAM Iface WR Timeout Queue XS1 (TO2) */
#define B3_RI_RTO_R1	0x0193	/* 8 bit RAM Iface RD Timeout Queue R1	(TO3) */
#define B3_RI_RTO_XA1	0x0194	/* 8 bit RAM Iface RD Timeout Queue XA1	(TO4) */
#define B3_RI_RTO_XS1	0x0195	/* 8 bit RAM Iface RD Timeout Queue XS1	(TO5) */
#define B3_RI_WTO_R2	0x0196	/* 8 bit RAM Iface WR Timeout Queue R2	(TO6) */
#define B3_RI_WTO_XA2	0x0197	/* 8 bit RAM Iface WR Timeout Queue XA2	(TO7) */
#define B3_RI_WTO_XS2	0x0198	/* 8 bit RAM Iface WR Timeout Queue XS2	(TO8) */
#define B3_RI_RTO_R2	0x0199	/* 8 bit RAM Iface RD Timeout Queue R2	(TO9) */
#define B3_RI_RTO_XA2	0x019a	/* 8 bit RAM Iface RD Timeout Queue XA2	(TO10)*/
#define B3_RI_RTO_XS2	0x019b	/* 8 bit RAM Iface RD Timeout Queue XS2	(TO11)*/
#define B3_RI_TO_VAL	0x019c	/* 8 bit RAM Iface Current Timeout Count Val */
	/* 0x019d - 0x019f	reserved */
#define B3_RI_CTRL		0x01a0	/* 16 bit	RAM Iface Control Register */
#define B3_RI_TEST		0x01a2	/*  8 bit	RAM Iface Test Register */
	/* 0x01a3 - 0x01af	reserved */
/* MAC Arbiter Registers */
/* Please notice these are the number of qWord tranfered continously and */
/* NOT real timeouts */
#define B3_MA_TOINI_RX1	0x01b0	/* 8 bit Timeout Init Value Rx Path MAC 1 */
#define B3_MA_TOINI_RX2	0x01b1	/* 8 bit Timeout Init Value Rx Path MAC 2 */
#define B3_MA_TOINI_TX1	0x01b2	/* 8 bit Timeout Init Value Tx Path MAC 1 */
#define B3_MA_TOINI_TX2	0x01b3	/* 8 bit Timeout Init Value Tx Path MAC 2 */
#define B3_MA_TOVAL_RX1	0x01b4	/* 8 bit Timeout Value Rx Path MAC 1 */
#define B3_MA_TOVAL_RX2	0x01b5	/* 8 bit Timeout Value Rx Path MAC 1 */
#define B3_MA_TOVAL_TX1	0x01b6	/* 8 bit Timeout Value Tx Path MAC 2 */
#define B3_MA_TOVAL_TX2	0x01b7	/* 8 bit Timeout Value Tx Path MAC 2 */
#define B3_MA_TO_CTRL	0x01b8	/* 16 bit	MAC Arbiter Timeout Ctrl Reg */
#define B3_MA_TO_TEST	0x01ba	/* 16 bit	MAC Arbiter Timeout Test Reg */
	/* 0x01bc - 0x01bf	reserved */
#define B3_MA_RCINI_RX1	0x01c0	/* 8 bit Recovery Init Value Rx Path MAC 1 */
#define B3_MA_RCINI_RX2	0x01c1	/* 8 bit Recovery Init Value Rx Path MAC 2 */
#define B3_MA_RCINI_TX1	0x01c2	/* 8 bit Recovery Init Value Tx Path MAC 1 */
#define B3_MA_RCINI_TX2	0x01c3	/* 8 bit Recovery Init Value Tx Path MAC 2 */
#define B3_MA_RCVAL_RX1	0x01c4	/* 8 bit Recovery Value Rx Path MAC 1 */
#define B3_MA_RCVAL_RX2	0x01c5	/* 8 bit Recovery Value Rx Path MAC 1 */
#define B3_MA_RCVAL_TX1	0x01c6	/* 8 bit Recovery Value Tx Path MAC 2 */
#define B3_MA_RCVAL_TX2	0x01c7	/* 8 bit Recovery Value Tx Path MAC 2 */
#define B3_MA_RC_CTRL	0x01c8	/* 16 bit	MAC Arbiter Recovery Ctrl Reg */
#define B3_MA_RC_TEST	0x01ca	/* 16 bit	MAC Arbiter Recovery Test Reg */
	/* 0x01cc - 0x01cf	reserved */
/* Packet Arbiter Registers, This are real timeouts */
#define B3_PA_TOINI_RX1	0x01d0	/* 16 bit	Timeout Init Val Rx Path MAC 1*/
	/* 0x01d2 - 0x01d3:	reserved */
#define B3_PA_TOINI_RX2	0x01d4	/* 16 bit	Timeout Init Val Rx Path MAC 2*/
	/* 0x01d6 - 0x01d7:	reserved */
#define B3_PA_TOINI_TX1	0x01d8	/* 16 bit	Timeout Init Val Tx Path MAC 1*/
	/* 0x01da - 0x01db:	reserved */
#define B3_PA_TOINI_TX2	0x01dc	/* 16 bit	Timeout Init Val Tx Path MAC 2*/
	/* 0x01de - 0x01df:	reserved */
#define B3_PA_TOVAL_RX1	0x01e0	/* 16 bit	Timeout Val Rx Path MAC 1 */
	/* 0x01e2 - 0x01e3:	reserved */
#define B3_PA_TOVAL_RX2	0x01e4	/* 16 bit	Timeout Val Rx Path MAC 2 */
	/* 0x01e6 - 0x01e7:	reserved */
#define B3_PA_TOVAL_TX1	0x01e8	/* 16 bit	Timeout Val Tx Path MAC 1 */
	/* 0x01ea - 0x01eb:	reserved */
#define B3_PA_TOVAL_TX2	0x01ec	/* 16 bit	Timeout Val Tx Path MAC 2 */
	/* 0x01ee - 0x01ef:	reserved */
#define B3_PA_CTRL	0x01f0	/* 16 bit	Packet Arbiter Ctrl Register */
#define B3_PA_TEST	0x01f2	/* 16 bit	Packet Arbiter Test Register */
	/* 0x01f4 - 0x01ff:	reserved */

/*
 *	Bank 4 - 5
 */

/* Transmit Arbiter Registers MAC 1 and 2, user MR_ADDR() to address */
#define TXA_ITI_INI		0x0200	/* 32 bit	Tx Arb Interval Timer Init Val*/
#define TXA_ITI_VAL		0x0204	/* 32 bit	Tx Arb Interval Timer Value */
#define TXA_LIM_INI		0x0208	/* 32 bit	Tx Arb Limit Counter Init Val */
#define TXA_LIM_VAL		0x020c	/* 32 bit	Tx Arb Limit Counter Value */
#define TXA_CTRL		0x0210	/*  8 bit	Tx Arbiter Control Register */
#define TXA_TEST		0x0211	/*  8 bit	Tx Arbiter Test Register */
#define TXA_STAT		0x0212	/*  8 bit	Tx Arbiter Status Register */
	/* 0x0213 - 0x027f:	reserved */

/*
 *	Bank 6
 */
/* External registers */
#define B6_EXT_REG		0x0300

/*
 *	Bank 7
 */
/* This is a copy of the Configuration register file (lower half) */
#define B7_CFG_SPC		0x0380

/*
 *	Bank 8 - 15
 */
/* Receive and Transmit Queue Registers, use Q_ADDR() to access */
#define	B8_Q_REGS		0x0400

/* Queue Register Offsets, use Q_ADDR() to access */
#define Q_D		0x00	/* 8*32	bit	Current Descriptor */
#define Q_DA_L	0x20	/* 32 bit	Current Descriptor Address Low dWord */
#define Q_DA_H	0x24	/* 32 bit	Current Descriptor Address High dWord */
#define Q_AC_L	0x28	/* 32 bit	Current Address Counter Low dWord */
#define Q_AC_H	0x2c	/* 32 bit	Current Address Counter High dWord */
#define Q_BC	0x30	/* 32 bit	Current Byte Counter */
#define Q_CSR	0x34	/* 32 bit	BMU Control/Status Register */
#define Q_F		0x38	/* 32 bit	Flag Register */
#define Q_T1	0x3c	/* 32 bit	Test Register 1 */
#define Q_T1_TR	0x3c	/*  8 bit	Test Register 1 Transfer SM */
#define Q_T1_WR	0x3d	/*  8 bit	Test Register 1 Write Descriptor SM */
#define Q_T1_RD	0x3e	/*  8 bit	Test Register 1 Read Descriptor SM */
#define Q_T1_SV	0x3f	/*  8 bit	Test Register 1 Supervisor SM */
#define Q_T2	0x40	/* 32 bit	Test Register 2	*/
#define Q_T3	0x44	/* 32 bit	Test Register 3	*/
	/* 0x48 - 0x7f:	reserved */

/*
 *	Bank 16 - 23
 */
/* RAM Buffer Registers */
#define	B16_RAM_REGS	0x0800

/* RAM Buffer Register Offsets */
/* use RB_ADDR(Queue,Offs) to address */
#define RB_START	0x00	/* 32 bit	RAM Buffer Start Address */
#define RB_END		0x04	/* 32 bit	RAM Buffer End Address */
#define RB_WP		0x08	/* 32 bit	RAM Buffer Write Pointer */
#define RB_RP		0x0c	/* 32 bit	RAM Buffer Read Pointer */
#define RB_RX_UTPP	0x10	/* 32 bit	Rx Upper Threshold, Pause Pack*/
#define RB_RX_LTPP	0x14	/* 32 bit	Rx Lower Threshold, Pause Pack*/
#define RB_RX_UTHP	0x18	/* 32 bit	Rx Upper Threshold, High Prio */
#define RB_RX_LTHP	0x1c	/* 32 bit	Rx Lower Threshold, High Prio */
	/* 0x10 - 0x1f:		reserved for Tx RAM Buffer Registers */
#define RB_PC		0x20	/* 32 bit	RAM Buffer Packet Counter */
#define RB_LEV		0x24	/* 32 bit	RAM Buffer Level Register */
#define RB_CTRL		0x28	/*  8 bit	RAM Buffer Control Register */
#define RB_TST1		0x29	/*  8 bit	RAM Buffer Test Register 1 */
#define RB_TST2		0x2A	/*  8 bit	RAM Buffer Test Register 2 */
	/* 0x2c - 0x7f:		reserved */

/*
 *	Bank 24 - 25
 */
/* Receive MAC FIFO, Receive LED, and Link Sync regs, use MR_ADDR() to address*/
#define RX_MFF_EA		0x0c00	/* 32 bit	Receive MAC FIFO End Address */
#define RX_MFF_WP		0x0c04	/* 32 bit 	Receive MAC FIFO Write Pointer*/
	/* 0x0c08 - 0x0c0b	reserved */
#define RX_MFF_RP		0x0c0c	/* 32 bit	Receive MAC FIFO Read Pointer */
#define RX_MFF_PC		0x0c10	/* 32 bit	Receive MAC FIFO Packet Cnt */
#define RX_MFF_LEV		0x0c14	/* 32 bit	Receive MAC FIFO Level */
#define RX_MFF_CTRL1	0x0c18	/* 16 bit	Receive MAC FIFO Control Reg 1*/
#define RX_MFF_STAT_TO	0x0c1a	/*  8 bit	Receive MAC Status Timeout */
#define RX_MFF_TIST_TO	0x0c1b	/*  8 bit	Receive MAC Timestamp Timeout */
#define RX_MFF_CTRL2	0x0c1c	/*  8 bit	Receive MAC FIFO Control Reg 2*/
#define RX_MFF_TST1		0x0c1d	/*  8 bit	Receive MAC FIFO Test Reg 1 */
#define RX_MFF_TST2		0x0c1e	/*  8 bit	Receive MAC FIFO Test Reg 2 */
	/* 0x0c1f		reserved */
#define RX_LED_INI		0x0c20	/* 32 bit	Receive LED Cnt Init Value */
#define RX_LED_VAL		0x0c24	/* 32 bit	Receive LED Cnt Current Value */
#define RX_LED_CTRL		0x0c28	/*  8 bit	Receive LED Cnt Control Reg */
#define RX_LED_TST		0x0c29	/*  8 bit	Receive LED Cnt Test Register */
	/* 0x0c2a - 0x0c2f	reserved */
#define LNK_SYNC_INI	0x0c30	/* 32 bit	Link Sync Cnt Init Value */
#define LNK_SYNC_VAL	0x0c34	/* 32 bit	Link Sync Cnt Current Value */
#define LNK_SYNC_CTRL	0x0c38	/*  8 bit	Link Sync Cnt Control Register*/
#define LNK_SYNC_TST	0x0c39	/*  8 bit	Link Sync Cnt Test Register */
	/* 0x0c3a - 0x0c3b	reserved */
#define LNK_LED_REG		0x0c3c	/*  8 bit	Link LED Register */
	/* 0x0c3d - 0x0c7f	reserved */

/*
 *	Bank 26 - 27
 */
/* Transmit MAC FIFO and Transmit LED Registers, use MR_ADDR() to address */
#define TX_MFF_EA		0x0d00	/* 32 bit	Transmit MAC FIFO End Address */
#define TX_MFF_WP		0x0d04	/* 32 bit 	Transmit MAC FIFO WR Pointer */
#define TX_MFF_WSP		0x0d08	/* 32 bit	Transmit MAC FIFO WR Shadow Pt*/
#define TX_MFF_RP		0x0d0c	/* 32 bit	Transmit MAC FIFO RD Pointer */
#define TX_MFF_PC		0x0d10	/* 32 bit	Transmit MAC FIFO Packet Cnt */
#define TX_MFF_LEV		0x0d14	/* 32 bit	Transmit MAC FIFO Level */
#define TX_MFF_CTRL1	0x0d18	/* 16 bit	Transmit MAC FIFO Ctrl Reg 1 */
#define TX_MFF_WAF		0x0d1a	/*  8 bit	Transmit MAC Wait after flush*/
	/* 0x0c1b		reserved */
#define TX_MFF_CTRL2	0x0d1c	/*  8 bit	Transmit MAC FIFO Ctrl Reg 2 */
#define TX_MFF_TST1		0x0d1d	/*  8 bit	Transmit MAC FIFO Test Reg 1 */
#define TX_MFF_TST2		0x0d1e	/*  8 bit	Transmit MAC FIFO Test Reg 2 */
	/* 0x0d1f		reserved */
#define TX_LED_INI		0x0d20	/* 32 bit	Transmit LED Cnt Init Value */
#define TX_LED_VAL		0x0d24	/* 32 bit	Transmit LED Cnt Current Val */
#define TX_LED_CTRL		0x0d28	/*  8 bit	Transmit LED Cnt Control Reg */
#define TX_LED_TST		0x0d29	/*  8 bit	Transmit LED Cnt Test Register*/
	/* 0x0d2a - 0x0d7f	reserved */

/*
 *	Bank 28
 */
/* Descriptor Poll Timer Registers */
#define B28_DPT_INI		0x0e00	/* 32 bit	Descriptor Poll Timer Init Val*/
#define B28_DPT_VAL		0x0e04	/* 32 bit	Descriptor Poll Timer Curr Val*/
#define B28_DPT_CTRL	0x0e08	/*  8 bit	Descriptor Poll Timer Ctrl Reg*/
	/* 0x0e09:		reserved */
#define B28_DPT_TST		0x0e0a	/*  8 bit	Descriptor Poll Timer Test Reg*/
	/* 0x0e0b - 0x0e8f:	reserved */

/*
 *	Bank 29 - 31
 */
/* 0x0e90 - 0x0fff:	reserved */

/*
 *	Bank 0x20 - 0x3f
 */
/* 0x1000 - 0x1fff:	reserved */

/*
 *	Bank 0x40 - 0x4f
 */
/* XMAC 1 registers */
#define B40_XMAC1	0x2000

/*
 *	Bank 0x50 - 0x5f
 */
/* 0x2800 - 0x2fff:	reserved */

/*
 *	Bank 0x60 - 0x6f
 */
/* XMAC 2 registers */
#define B40_XMAC2	0x3000

/*
 *	Bank 0x70 - 0x7f
 */
/* 0x3800 - 0x3fff:	reserved */

/*
 *	Control Register Bit Definitions:
 */
/*	B0_RAP		8 bit	Register Address Port */
				/* Bit 7:	reserved */
#define	RAP_RAP			0x3f	/* Bit 6..0:	0 = block 0, .., 6f = block 6f*/

/*	B0_CTST		16 bit	Control/Status register */
				/* Bit 15..10:	reserved */
#define CS_BUS_CLOCK	(1<<9)	/* Bit	9:	Bus Clock 0/1 = 33/66MHz */
#define CS_BUS_SLOT_SZ	(1<<8)	/* Bit	8:	Slot Size 0/1 = 32/64 bit slot*/
#define CS_ST_SW_IRQ	(1<<7)	/* Bit	7:	Set IRQ SW Request	*/
#define CS_CL_SW_IRQ	(1<<6)	/* Bit	6:	Clear IRQ SW Request	*/
#define CS_STOP_DONE	(1<<5)	/* Bit	5:	Stop Master is finished */
#define	CS_STOP_MAST	(1<<4)	/* Bit	4:	Command Bit to stop the master*/
#define	CS_MRST_CLR		(1<<3)	/* Bit	3:	Clear Master reset	*/
#define	CS_MRST_SET		(1<<2)	/* Bit	2:	Set Master reset	*/
#define	CS_RST_CLR		(1<<1)	/* Bit	1:	Clear Software reset	*/
#define	CS_RST_SET		(1<<0)	/* Bit	0:	Set Software reset	*/

/*	B0_LED		 8 Bit	LED register */
				/* Bit 7..2:	reserved */
#define LED_STAT_ON		(1<<1)	/* Bit 1:	Status LED on	*/
#define LED_STAT_OFF	(1<<0)	/* Bit 0:	Status LED off	*/

/*	B0_ISRC		32 bit	Interrupt Source Register */
/*	B0_IMSK		32 bit	Interrupt Mask Register */
/*	B0_SP_ISRC	32 bit	Special Interrupt Source Reg */
/*	B2_IRQM_MSK 	32 bit	IRQ Moderation Mask */
#define IS_ALL_MSK		0xbfffffffL	/* 		All Interrupt bits */
#define IS_HW_ERR		(1UL<<31)	/* Bit 31:	Interrupt HW Error */
									/* Bit 30:	reserved */
#define IS_PA_TO_RX1	(1L<<29)	/* Bit 29:	Packet Arb Timeout Rx1*/
#define IS_PA_TO_RX2	(1L<<28)	/* Bit 28:	Packet Arb Timeout Rx2*/
#define IS_PA_TO_TX1	(1L<<27)	/* Bit 27:	Packet Arb Timeout Tx1*/
#define IS_PA_TO_TX2	(1L<<26)	/* Bit 26:	Packet Arb Timeout Tx2*/
#define IS_I2C_READY	(1L<<25)	/* Bit 25:	IRQ on end of I2C tx */
#define IS_IRQ_SW		(1L<<24)	/* Bit 24:	SW forced IRQ	*/
#define IS_EXT_REG		(1L<<23)	/* Bit 23:	IRQ from external reg */
#define	IS_TIMINT		(1L<<22)	/* Bit 22:	IRQ from Timer	*/
#define IS_MAC1			(1L<<21)	/* Bit 21:	IRQ from MAC 1	*/
#define IS_LNK_SYNC_M1	(1L<<20)	/* Bit 20:	Link Sync Cnt wrap M1 */
#define IS_MAC2			(1L<<19)	/* Bit 19:	IRQ from MAC 2	*/
#define IS_LNK_SYNC_M2	(1L<<18)	/* Bit 18:	Link Sync Cnt wrap M2 */
/* Receive Queue 1 */
#define	IS_R1_B			(1L<<17)	/* Bit 17:	Q_R1 End of Buffer */
#define	IS_R1_F			(1L<<16)	/* Bit 16:	Q_R1 End of Frame */
#define	IS_R1_C			(1L<<15)	/* Bit 15:	Q_R1 Encoding Error */
/* Receive Queue 2 */
#define	IS_R2_B			(1L<<14)	/* Bit 14:	Q_R2 End of Buffer */
#define	IS_R2_F			(1L<<13)	/* Bit 13:	Q_R2 End of Frame */
#define	IS_R2_C			(1L<<12)	/* Bit 12:	Q_R2 Encoding Error */
/* Synchronous Transmit Queue 1 */
#define	IS_XS1_B		(1L<<11)	/* Bit 11:	Q_XS1 End of Buffer */
#define	IS_XS1_F		(1L<<10)	/* Bit 10:	Q_XS1 End of Frame */
#define	IS_XS1_C		(1L<<9)		/* Bit	9:	Q_XS1 Encoding Error */
/* Asynchronous Transmit Queue 1 */
#define	IS_XA1_B		(1L<<8)		/* Bit	8:	Q_XA1 End of Buffer */
#define	IS_XA1_F		(1L<<7)		/* Bit	7:	Q_XA1 End of Frame */
#define	IS_XA1_C		(1L<<6)		/* Bit	6:	Q_XA1 Encoding Error */
/* Synchronous Transmit Queue 2 */
#define	IS_XS2_B		(1L<<5)		/* Bit	5:	Q_XS2 End of Buffer */
#define	IS_XS2_F		(1L<<4)		/* Bit	4:	Q_XS2 End of Frame */
#define	IS_XS2_C		(1L<<3)		/* Bit	3:	Q_XS2 Encoding Error */
/* Asynchronous Transmit Queue 2 */
#define	IS_XA2_B		(1L<<2)		/* Bit	2:	Q_XA2 End of Buffer */
#define	IS_XA2_F		(1L<<1)		/* Bit	1:	Q_XA2 End of Frame */
#define	IS_XA2_C		(1L<<0)		/* Bit	0:	Q_XA2 Encoding Error */


/*	B0_HWE_ISRC	32 bit	HW Error Interrupt Src Reg */
/*	B0_HWE_IMSK	32 bit	HW Error Interrupt Mask Reg */
/*	B2_IRQM_HWE_MSK 32 bit	IRQ Moderation HW Error Mask */
#define IS_ERR_MSK		0x00000fffL	/* 		All Error bits */
									/* Bit 31..12:	reserved */
#define	IS_IRQ_MST_ERR	(1L<<11)	/* Bit 11:	IRQ master error */
									/*	PERR,RMABORT,RTABORT,DATAPERR */
#define	IS_IRQ_STAT		(1L<<10)	/* Bit 10:	IRQ status execption */
									/*	RMABORT, RTABORT, DATAPERR */
#define IS_NO_STAT_M1	(1L<<9)		/* Bit	9:	No Rx Status from MAC1*/
#define IS_NO_STAT_M2	(1L<<8)		/* Bit	8:	No Rx Status from MAC2*/
#define IS_NO_TIST_M1	(1L<<7)		/* Bit	7:	No Timestamp from MAC1*/
#define IS_NO_TIST_M2	(1L<<6)		/* Bit	6:	No Timestamp from MAC2*/
#define IS_RAM_RD_PAR	(1L<<5)		/* Bit	5:	RAM Read Parity Error */
#define IS_RAM_WR_PAR	(1L<<4)		/* Bit	4:	RAM Write Parity Error*/
#define IS_M1_PAR_ERR	(1L<<3)		/* Bit	3:	MAC 1 Parity Error */
#define IS_M2_PAR_ERR	(1L<<2)		/* Bit	2:	MAC 2 Parity Error */
#define IS_R1_PAR_ERR	(1L<<1)		/* Bit	1:	Queue R1 Parity Error */
#define IS_R2_PAR_ERR	(1L<<0)		/* Bit	0:	Queue R2 Parity Error */

/*	B2_CONN_TYP	 8 bit	Connector type */
/*	B2_PMD_TYP	 8 bit	PMD type */
/*	Values of connector and PMD type comply to SysKonnect internal std */

/*	B2_MAC_CFG	 8 bit	MAC Configuration */
								/* Bit 7..2:	reserved */
#define	CFG_DIS_M2_CLK	(1<<1)	/* Bit 1:	Disable Clock for 2nd MAC */
#define CFG_SNG_MAC		(1<<0)	/* Bit 0:	MAC Config: 1=2 MACs / 0=1 MAC*/

/*	B2_CHIP_REV	 8 bit 	Queen Chip Revision Number */
#define FIRST_CHIP_REV	0x0a	/* Initial Revision Value */

/*	B2_FAR		32 bit	Flash-Prom Addr Reg/Cnt */
#define	FAR_ADDR		0x1ffffL	/* Bit 16..0:	FPROM Address mask */

/*	B2_LD_CRTL	 8 bit	EPROM loader control register */
/*	Bits are currently reserved */

/*	B2_LD_TEST	 8 bit	EPROM loader test register */
								/* Bit 7..4:	reserved */
#define	LD_T_ON			(1<<3)	/* Bit 3:	Loader Testmode on */
#define	LD_T_OFF		(1<<2)	/* Bit 2:	Loader Testmode off */
#define	LD_T_STEP		(1<<1)	/* Bit 1:	Decrement FPROM addr. Counter */
#define	LD_START		(1<<0)	/* Bit 0:	Start loading FPROM */

/*
 *	Timer Section
 */
/*	B2_TI_CRTL	 8 bit	Timer control */
/*	B2_IRQM_CTRL	 8 bit	IRQ Moderation Timer Control */
								/* Bit 7..3:	reserved */
#define TIM_START		(1<<2)	/* Bit 2:	Start Timer */
#define TIM_STOP		(1<<1)	/* Bit 1:	Stop Timer */
#define TIM_CLR_IRQ		(1<<0)	/* Bit 0:	Clear Timer IRQ, (!IRQM) */

/*	B2_TI_TEST	 8 Bit	Timer Test */
/*	B2_IRQM_TEST	 8 bit	IRQ Moderation Timer Test */
/*	B28_DPT_TST	 8 bit	Descriptor Poll Timer Test Reg */
								/* Bit 7..3:	reserved */
#define	TIM_T_ON		(1<<2)	/* Bit 2:	Test mode on */
#define	TIM_T_OFF		(1<<1)	/* Bit 1:	Test mode off */
#define	TIM_T_STEP		(1<<0)	/* Bit 0:	Test step */

/*	B28_DPT_INI	32 bit	Descriptor Poll Timer Init Val */
/*	B28_DPT_VAL	32 bit	Descriptor Poll Timer Curr Val */
								/* Bit 31..24:	reserved */
#define DPT_MSK		0x00ffffffL	/* Bit 23.. 0:	Desc Poll Timer Bits */

/*	B28_DPT_CTRL	 8 bit	Descriptor Poll Timer Ctrl Reg */
								/* Bit 7..2:	reserved */
#define DPT_START		(1<<1)	/* Bit 1:	Start Desciptor Poll Timer */
#define DPT_STOP		(1<<0)	/* Bit 0:	Stop Desciptor Poll Timer */


/*	B2_TST_CTRL1	 8 bit	Test Control Register 1 */
#define	TST_FRC_DPERR_MR	(1<<7)	/* Bit 7: force DATAPERR on MST RD */
#define	TST_FRC_DPERR_MW	(1<<6)	/* Bit 6: force DATAPERR on MST WR */
#define	TST_FRC_DPERR_TR	(1<<5)	/* Bit 5: force DATAPERR on TRG RD */
#define	TST_FRC_DPERR_TW	(1<<4)	/* Bit 4: force DATAPERR on TRG WR */
#define	TST_FRC_APERR_M		(1<<3)	/* Bit 3: force ADDRPERR on MST */
#define	TST_FRC_APERR_T		(1<<2)	/* Bit 2: force ADDRPERR on TRG */
#define	TST_CFG_WRITE_ON	(1<<1)	/* Bit 1: Enable Config Reg WR */
#define	TST_CFG_WRITE_OFF	(1<<0)	/* Bit 0: Disable Config Reg WR */

/*	B2_TST_CTRL2	 8 bit	Test Control Register 2 */
									/* Bit 7..4:	reserved */
					/* force the following error on */
					/* the next master read/write	*/
#define TST_FRC_DPERR_MR64	(1<<3)	/* Bit 3:	DataPERR RD 64	*/
#define TST_FRC_DPERR_MW64	(1<<2)	/* Bit 2:	DataPERR WR 64	*/
#define TST_FRC_APERR_1M64	(1<<1)	/* Bit 1:	AddrPERR on 1. phase */
#define TST_FRC_APERR_2M64	(1<<0)	/* Bit 0:	AddrPERR on 2. phase */

/*	B2_GP_IO	32 bit	General Purpose IO Register */
								/* Bit 31..26:	reserved */
#define	GP_DIR_9	(1L<<25)	/* Bit 25:	IO_9 direct, 0=I/1=O */
#define	GP_DIR_8	(1L<<24)	/* Bit 24:	IO_8 direct, 0=I/1=O */
#define	GP_DIR_7	(1L<<23)	/* Bit 23:	IO_7 direct, 0=I/1=O */
#define	GP_DIR_6	(1L<<22)	/* Bit 22:	IO_6 direct, 0=I/1=O */
#define	GP_DIR_5	(1L<<21)	/* Bit 21:	IO_5 direct, 0=I/1=O */
#define	GP_DIR_4	(1L<<20)	/* Bit 20:	IO_4 direct, 0=I/1=O */
#define	GP_DIR_3	(1L<<19)	/* Bit 19:	IO_3 direct, 0=I/1=O */
#define	GP_DIR_2	(1L<<18)	/* Bit 18:	IO_2 direct, 0=I/1=O */
#define	GP_DIR_1	(1L<<17)	/* Bit 17:	IO_1 direct, 0=I/1=O */
#define	GP_DIR_0	(1L<<16)	/* Bit 16:	IO_0 direct, 0=I/1=O */
								/* Bit 15..10:	reserved */
#define	GP_IO_9		(1L<<9)		/* Bit	9:	IO_9 pin */
#define	GP_IO_8		(1L<<8)		/* Bit	8:	IO_8 pin */
#define	GP_IO_7		(1L<<7)		/* Bit	7:	IO_7 pin */
#define	GP_IO_6		(1L<<6)		/* Bit	6:	IO_6 pin */
#define	GP_IO_5		(1L<<5)		/* Bit	5:	IO_5 pin */
#define	GP_IO_4		(1L<<4)		/* Bit	4:	IO_4 pin */
#define	GP_IO_3		(1L<<3)		/* Bit	3:	IO_3 pin */
#define	GP_IO_2		(1L<<2)		/* Bit	2:	IO_2 pin */
#define	GP_IO_1		(1L<<1)		/* Bit	1:	IO_1 pin */
#define	GP_IO_0		(1L<<0)		/* Bit	0:	IO_0 pin */

/*	B2_I2C_CTRL	32 bit	I2C HW Control Register */
#define	I2C_FLAG		(1UL<<31)	/* Bit 31:	Start read/write if WR*/
#define I2C_ADDR	(0x7fffL<<16)	/* Bit 30..16:	Addr to be RD/WR */
#define	I2C_DEV_SEL		(0x7fL<<9)	/* Bit 15.. 9:	I2C Device Select */
									/* Bit	8.. 5:	reserved	*/
#define I2C_BURST_LEN	(1L<<4)		/* Bit	4:	Burst Len, 1/4 bytes */
#define I2C_DEV_SIZE	(7L<<1)		/* Bit	3.. 1:	I2C Device Size	*/
#define I2C_025K_DEV	(0L<<1)		/*		0: 256 Bytes or smal. */
#define I2C_05K_DEV		(1L<<1)		/* 		1: 512	Bytes	*/
#define	I2C_1K_DEV		(2L<<1)		/*		2: 1024 Bytes	*/
#define I2C_2K_DEV		(3L<<1)		/*		3: 2048	Bytes	*/
#define	I2C_4K_DEV		(4L<<1)		/*		4: 4096 Bytes	*/
#define	I2C_8K_DEV		(5L<<1)		/*		5: 8192 Bytes	*/
#define	I2C_16K_DEV		(6L<<1)		/*		6: 16384 Bytes	*/
#define	I2C_32K_DEV		(7L<<1)		/*		7: 32768 Bytes	*/
#define I2C_STOP		(1L<<0)		/* Bit	0:	Interrupt I2C transfer*/

/*	B2_I2C_IRQ	32 bit	I2C HW IRQ Register */
								/* Bit 31..1	reserved */
#define I2C_CLR_IRQ		(1<<0)	/* Bit 0:	Clear I2C IRQ */

/*	B2_I2C_SW	32 bit	I2C HW SW Port Register */
								/* Bit 7..3:	reserved */
#define	I2C_DATA_DIR	(1<<2)	/* Bit 2:	direction of I2C_DATA */
#define I2C_DATA		(1<<1)	/* Bit 1:	I2C Data Port	*/
#define	I2C_CLK			(1<<0)	/* Bit 0:	I2C Clock Port	*/

/*
 * I2C Address
 */
#define	I2C_SENS_ADDR	LM80_ADDR	/* I2C Sensor Address, (Volt and Temp)*/


/*	B2_BSC_CTRL	 8 bit	Blink Source Counter Control */
							/* Bit 7..2:	reserved */
#define BSC_START	(1<<1)	/* Bit 1:	Start Blink Source Counter */
#define BSC_STOP	(1<<0)	/* Bit 0:	Stop Blink Source Counter */

/*	B2_BSC_STAT	 8 bit	Blink Source Counter Status */
							/* Bit 7..1:	reserved */
#define BSC_SRC		(1<<0)	/* Bit 0:	Blink Source, 0=Off / 1=On */

/*	B2_BSC_TST	16 bit	Blink Source Counter Test Reg */
#define	BSC_T_ON	(1<<2)	/* Bit 2:	Test mode on */
#define	BSC_T_OFF	(1<<1)	/* Bit 1:	Test mode off */
#define	BSC_T_STEP	(1<<0)	/* Bit 0:	Test step */


/*	B3_RAM_ADDR	32 bit	RAM Address, to read or write */
					/* Bit 31..19:	reserved */
#define RAM_ADR_RAN	0x0007ffffL	/* Bit 18.. 0:	RAM Address Range */

/* RAM Interface Registers */
/*	B3_RI_CTRL	16 bit	RAM Iface Control Register */
								/* Bit 15..10:	reserved */
#define RI_CLR_RD_PERR	(1<<9)	/* Bit	9:	Clear IRQ RAM Read Parity Err */
#define RI_CLR_WR_PERR	(1<<8)	/* Bit	8:	Clear IRQ RAM Write Parity Err*/
								/* Bit	7..2:	reserved */
#define RI_RST_CLR		(1<<1)	/* Bit	1:	Clear RAM Interface Reset */
#define RI_RST_SET		(1<<0)	/* Bit	0:	Set RAM Interface Reset */

/*	B3_RI_TEST	 8 bit	RAM Iface Test Register */
								/* Bit 15..4:	reserved */
#define RI_T_EV			(1<<3)	/* Bit	3:	Timeout Event occured */
#define RI_T_ON			(1<<2)	/* Bit	2:	Timeout Timer Test On */
#define RI_T_OFF		(1<<1)	/* Bit	1:	Timeout Timer Test Off */
#define RI_T_STEP		(1<<0)	/* Bit	0:	Timeout Timer Step */

/* MAC Arbiter Registers */
/*	B3_MA_TO_CTRL	16 bit	MAC Arbiter Timeout Ctrl Reg */
								/* Bit 15..4:	reserved */
#define MA_FOE_ON		(1<<3)	/* Bit	3:	XMAC Fast Output Enable ON */
#define MA_FOE_OFF		(1<<2)	/* Bit	2:	XMAC Fast Output Enable OFF */
#define MA_RST_CLR		(1<<1)	/* Bit	1:	Clear MAC Arbiter Reset */
#define MA_RST_SET		(1<<0)	/* Bit	0:	Set MAC Arbiter Reset */

/*	B3_MA_RC_CTRL	16 bit	MAC Arbiter Recovery Ctrl Reg */
								/* Bit 15..8:	reserved */
#define MA_ENA_REC_TX2	(1<<7)	/* Bit	7:	Enable Recovery Timer TX2 */
#define MA_DIS_REC_TX2	(1<<6)	/* Bit	6:	Disable Recovery Timer TX2 */
#define MA_ENA_REC_TX1	(1<<5)	/* Bit	5:	Enable Recovery Timer TX1 */
#define MA_DIS_REC_TX1	(1<<4)	/* Bit	4:	Disable Recovery Timer TX1 */
#define MA_ENA_REC_RX2	(1<<3)	/* Bit	3:	Enable Recovery Timer RX2 */
#define MA_DIS_REC_RX2	(1<<2)	/* Bit	2:	Disable Recovery Timer RX2 */
#define MA_ENA_REC_RX1	(1<<1)	/* Bit	1:	Enable Recovery Timer RX1 */
#define MA_DIS_REC_RX1	(1<<0)	/* Bit	0:	Disable Recovery Timer RX1 */

/* Packet Arbiter Registers */
/*	B3_PA_CTRL	16 bit	Packet Arbiter Ctrl Register */
								/* Bit 15..14:	reserved */
#define PA_CLR_TO_TX2	(1<<13)	/* Bit 13:	Clear IRQ Packet Timeout TX2 */
#define PA_CLR_TO_TX1	(1<<12)	/* Bit 12:	Clear IRQ Packet Timeout TX1 */
#define PA_CLR_TO_RX2	(1<<11)	/* Bit 11:	Clear IRQ Packet Timeout RX2 */
#define PA_CLR_TO_RX1	(1<<10)	/* Bit 10:	Clear IRQ Packet Timeout RX1 */
#define PA_ENA_TO_TX2	(1<<9)	/* Bit	9:	Enable Timeout Timer TX2 */
#define PA_DIS_TO_TX2	(1<<8)	/* Bit	8:	Disable Timeout Timer TX2 */
#define PA_ENA_TO_TX1	(1<<7)	/* Bit	7:	Enable Timeout Timer TX1 */
#define PA_DIS_TO_TX1	(1<<6)	/* Bit	6:	Disable Timeout Timer TX1 */
#define PA_ENA_TO_RX2	(1<<5)	/* Bit	5:	Enable Timeout Timer RX2 */
#define PA_DIS_TO_RX2	(1<<4)	/* Bit	4:	Disable Timeout Timer RX2 */
#define PA_ENA_TO_RX1	(1<<3)	/* Bit	3:	Enable Timeout Timer RX1 */
#define PA_DIS_TO_RX1	(1<<2)	/* Bit	2:	Disable Timeout Timer RX1 */
#define PA_RST_CLR		(1<<1)	/* Bit	1:	Clear MAC Arbiter Reset */
#define PA_RST_SET		(1<<0)	/* Bit	0:	Set MAC Arbiter Reset */

#define PA_ENA_TO_ALL	(PA_ENA_TO_RX1 | PA_ENA_TO_RX2 |\
						PA_ENA_TO_TX1 | PA_ENA_TO_TX2)

/* Rx/Tx Path related Arbiter Test Registers */
/*	B3_MA_TO_TEST	16 bit	MAC Arbiter Timeout Test Reg */
/*	B3_MA_RC_TEST	16 bit	MAC Arbiter Recovery Test Reg */
/*	B3_PA_TEST	16 bit	Packet Arbiter Test Register */
/*			Bit 15, 11, 7, and 3 are reserved in B3_PA_TEST */
#define TX2_T_EV	(1<<15)	/* Bit 15: 	TX2 Timeout/Recv Event occured*/
#define TX2_T_ON	(1<<14)	/* Bit 14:	TX2 Timeout/Recv Timer Test On*/
#define TX2_T_OFF	(1<<13)	/* Bit 13:	TX2 Timeout/Recv Timer Tst Off*/
#define TX2_T_STEP	(1<<12)	/* Bit 12:	TX2 Timeout/Recv Timer Step */
#define TX1_T_EV	(1<<11)	/* Bit 11:	TX1 Timeout/Recv Event occured*/
#define TX1_T_ON	(1<<10)	/* Bit 10:	TX1 Timeout/Recv Timer Test On*/
#define TX1_T_OFF	(1<<9)	/* Bit	9:	TX1 Timeout/Recv Timer Tst Off*/
#define TX1_T_STEP	(1<<8)	/* Bit	8:	TX1 Timeout/Recv Timer Step */
#define RX2_T_EV	(1<<7)	/* Bit	7:	RX2 Timeout/Recv Event occured*/
#define RX2_T_ON	(1<<6)	/* Bit	6:	RX2 Timeout/Recv Timer Test On*/
#define RX2_T_OFF	(1<<5)	/* Bit	5:	RX2 Timeout/Recv Timer Tst Off*/
#define RX2_T_STEP	(1<<4)	/* Bit	4:	RX2 Timeout/Recv Timer Step */
#define RX1_T_EV	(1<<3)	/* Bit	3:	RX1 Timeout/Recv Event occured*/
#define RX1_T_ON	(1<<2)	/* Bit	2:	RX1 Timeout/Recv Timer Test On*/
#define RX1_T_OFF	(1<<1)	/* Bit	1:	RX1 Timeout/Recv Timer Tst Off*/
#define RX1_T_STEP	(1<<0)	/* Bit	0:	RX1 Timeout/Recv Timer Step */


/* Transmit Arbiter Registers MAC 1 and 2, user MR_ADDR() to address */
/*	TXA_ITI_INI	32 bit	Tx Arb Interval Timer Init Val */
/*	TXA_ITI_VAL	32 bit	Tx Arb Interval Timer Value */
/*	TXA_LIM_INI	32 bit	Tx Arb Limit Counter Init Val */
/*	TXA_LIM_VAL	32 bit	Tx Arb Limit Counter Value */
								/* Bit 31..24:	reserved */
#define	TXA_MAX_VAL	0x00ffffffL	/* Bit 23.. 0:	Max TXA Timer/Cnt Val */

/*	TXA_CTRL	 8 bit	Tx Arbiter Control Register */
#define TXA_ENA_FSYNC	(1<<7)	/* Bit 7:	Enable force of sync tx queue */
#define TXA_DIS_FSYNC	(1<<6)	/* Bit 6:	Disable force of sync tx queue*/
#define TXA_ENA_ALLOC	(1<<5)	/* Bit 5:	Enable alloc of free bandwidth*/
#define TXA_DIS_ALLOC	(1<<4)	/* Bit 4:	Disabl alloc of free bandwidth*/
#define TXA_START_RC	(1<<3)	/* Bit 3:	Start sync Rate Control */
#define TXA_STOP_RC		(1<<2)	/* Bit 2:	Stop sync Rate Control */
#define TXA_ENA_ARB		(1<<1)	/* Bit 1:	Enable Tx Arbiter */
#define TXA_DIS_ARB		(1<<0)	/* Bit 0:	Disable Tx Arbiter */

/*	TXA_TEST	 8 bit	Tx Arbiter Test Register */
				/* Bit 7..6:	reserved */
#define TXA_INT_T_ON	(1<<5)	/* Bit 5:	Tx Arb Interval Timer Test On */
#define TXA_INT_T_OFF	(1<<4)	/* Bit 4:	Tx Arb Interval Timer Test Off*/
#define TXA_INT_T_STEP	(1<<3)	/* Bit 3:	Tx Arb Interval Timer Step */
#define TXA_LIM_T_ON	(1<<2)	/* Bit 2:	Tx Arb Limit Timer Test On */
#define TXA_LIM_T_OFF	(1<<1)	/* Bit 1:	Tx Arb Limit Timer Test Off */
#define TXA_LIM_T_STEP	(1<<0)	/* Bit 0:	Tx Arb Limit Timer Step */

/*	TXA_STAT	 8 bit	Tx Arbiter Status Register */
								/* Bit 7..1:	reserved */
#define	TXA_PRIO_XS		(1<<0)	/* Bit 0:	sync queue has prio to send */

/*	Q_BC	32 bit	Current Byte Counter */
				/* Bit 31..16:	reserved */
#define BC_MAX			0xffff	/* Bit 15.. 0:	Byte counter */

/* BMU Control Status Registers */
/*	B0_R1_CSR	32 bit	BMU Ctrl/Stat Rx Queue 1 */
/*	B0_R2_CSR	32 bit	BMU Ctrl/Stat Rx Queue 2 */
/*	B0_XA1_CSR	32 bit	BMU Ctrl/Stat Sync Tx Queue 1 */
/*	B0_XS1_CSR	32 bit	BMU Ctrl/Stat Async Tx Queue 1 */
/*	B0_XA2_CSR	32 bit	BMU Ctrl/Stat Sync Tx Queue 2 */
/*	B0_XS2_CSR	32 bit	BMU Ctrl/Stat Async Tx Queue 2 */
/*	Q_CSR	32 bit	BMU Control/Status Register */
									/* Bit 31..25:	reserved */
#define CSR_SV_IDLE		(1L<<24)	/* Bit 24: 	BMU SM Idle */
									/* Bit 23..22:	reserved */
#define	CSR_DESC_CLR	(1L<<21)	/* Bit 21:	Clear Reset for Descr */
#define	CSR_DESC_SET	(1L<<20)	/* Bit 20:	Set Reset for Descr */
#define	CSR_FIFO_CLR	(1L<<19)	/* Bit 19:	Clear Reset for FIFO */
#define	CSR_FIFO_SET	(1L<<18)	/* Bit 18:	Set Reset for FIFO */
#define	CSR_HPI_RUN		(1L<<17)	/* Bit 17:	Release HPI SM */
#define	CSR_HPI_RST		(1L<<16)	/* Bit 16:	Reset HPI SM to Idle */
#define	CSR_SV_RUN		(1L<<15)	/* Bit 15:	Release Supervisor SM */
#define	CSR_SV_RST		(1L<<14)	/* Bit 14:	Reset Supervisor SM */
#define	CSR_DREAD_RUN	(1L<<13)	/* Bit 13:	Release Descr Read SM */
#define	CSR_DREAD_RST	(1L<<12)	/* Bit 12:	Reset Descr Read SM */
#define	CSR_DWRITE_RUN	(1L<<11)	/* Bit 11:	Rel. Descr Write SM */
#define	CSR_DWRITE_RST	(1L<<10)	/* Bit 10:	Reset Descr Write SM */
#define	CSR_TRANS_RUN	(1L<<9)		/* Bit	9:	Release Transfer SM */
#define	CSR_TRANS_RST	(1L<<8)		/* Bit	8:	Reset Transfer SM */
#define CSR_ENA_POL		(1L<<7)		/* Bit	7:	Enable Descr Polling */
#define CSR_DIS_POL		(1L<<6)		/* Bit	6:	Disable Descr Polling */
#define CSR_STOP		(1L<<5)		/* Bit	5:	Stop Rx/Tx Queue */
#define	CSR_START		(1L<<4)		/* Bit	4:	Start Rx/Tx Queue */
#define	CSR_IRQ_CL_P	(1L<<3)		/* Bit	3: (Rx)	Clear Parity IRQ */
#define	CSR_IRQ_CL_B	(1L<<2)		/* Bit	2:	Clear EOB IRQ */
#define	CSR_IRQ_CL_F	(1L<<1)		/* Bit	1:	Clear EOF IRQ */
#define	CSR_IRQ_CL_C	(1L<<0)		/* Bit	0:	Clear ERR IRQ */

#define CSR_SET_RESET	(CSR_DESC_SET|CSR_FIFO_SET|CSR_HPI_RST|CSR_SV_RST|\
						CSR_DREAD_RST|CSR_DWRITE_RST|CSR_TRANS_RST)
#define CSR_CLR_RESET	(CSR_DESC_CLR|CSR_FIFO_CLR|CSR_HPI_RUN|CSR_SV_RUN|\
						CSR_DREAD_RUN|CSR_DWRITE_RUN|CSR_TRANS_RUN)


/*	Q_F	32 bit	Flag Register */
					/* Bit 28..31:	reserved */
#define F_ALM_FULL		(1L<<27) (Rx)	/* Bit 27: (Rx)	FIFO almost full */
#define F_EMPTY			(1L<<27) (Tx)	/* Bit 27: (Tx)	FIFO empty flag */
#define F_FIFO_EOF		(1L<<26)	/* Bit 26: 	Fag bit in FIFO */
#define F_WM_REACHED	(1L<<25)	/* Bit 25: 	Watermark reached */
									/* Bit 24:	reserved */
#define F_FIFO_LEVEL	(0x1fL<<16)	/* Bit 23..16:	# of Qwords in FIFO */
									/* Bit 15..11: 	reserved */
#define F_WATER_MARK	0x0007ffL	/* Bit 10.. 0:	Watermark */

/*	Q_T1	32 bit	Test Register 1 */
/*		Holds four State Machine control Bytes */
#define	SM_CRTL_SV	(0xffL<<24)	/* Bit 31..24:	Control Supervisor SM */
#define	SM_CRTL_RD	(0xffL<<16)	/* Bit 23..16:	Control Read Desc SM */
#define	SM_CRTL_WR	(0xffL<<8)	/* Bit 15.. 8:	Control Write Desc SM */
#define	SM_CRTL_TR	(0xffL<<0)	/* Bit	7.. 0:	Control Transfer SM */

/*	Q_T1_TR	 8 bit	Test Register 1 Transfer SM */
/*	Q_T1_WR	 8 bit	Test Register 1 Write Descriptor SM */
/*	Q_T1_RD	 8 bit	Test Register 1 Read Descriptor SM */
/*	Q_T1_SV	 8 bit	Test Register 1 Supervisor SM */
/* The control status byte of each machine looks like ... */
#define	SM_STATE	0xf0	/* Bit 7..4:	State which shall be loaded */
#define	SM_LOAD		(1<<3)	/* Bit 3:	Load the SM with SM_STATE */
#define	SM_TEST_ON	(1<<2)	/* Bit 2:	Switch on SM Test Mode */
#define	SM_TEST_OFF	(1<<1)	/* Bit 1:	Go off the Test Mode */
#define	SM_STEP		(1<<0)	/* Bit 0:	Step the State Machine */
/* The encoding of the states is not supported by the Diagnostics Tool */

/*	Q_T2	32 bit	Test Register 2	*/
				/* Bit 31..8:	reserved */
#define	T2_AC_T_ON	(1<<7)	/* Bit 7:	Address Counter Test Mode on */
#define	T2_AC_T_OFF	(1<<6)	/* Bit 6:	Address Counter Test Mode off*/
#define	T2_BC_T_ON	(1<<5)	/* Bit 5:	Byte Counter Test Mode on */
#define	T2_BC_T_OFF	(1<<4)	/* Bit 4:	Byte Counter Test Mode off */
#define	T2_STEP04	(1<<3)	/* Bit 3:	Inc AC/Dec BC by 4 */
#define	T2_STEP03	(1<<2)	/* Bit 2:	Inc AC/Dec BC by 3 */
#define	T2_STEP02	(1<<1)	/* Bit 1:	Inc AC/Dec BC by 2 */
#define	T2_STEP01	(1<<0)	/* Bit 0:	Inc AC/Dec BC by 1 */

/*	Q_T3	32 bit	Test Register 3	*/
							/* Bit 31..7:	reserved */
#define	T3_MUX		(7<<4)	/* Bit 6.. 4:	Mux Position */
							/* Bit 3:	reserved */
#define	T3_VRAM		(7<<0)	/* Bit 2.. 0:	Virtual RAM Buffer Address */

/* RAM Buffer Register Offsets */
/* use RB_ADDR(Queue,Offs) to address */
/*	RB_START	32 bit	RAM Buffer Start Address */
/*	RB_END		32 bit	RAM Buffer End Address */
/*	RB_WP		32 bit	RAM Buffer Write Pointer */
/*	RB_RP		32 bit	RAM Buffer Read Pointer */
/*	RB_RX_UTPP	32 bit	Rx Upper Threshold, Pause Pack */
/*	RB_RX_LTPP	32 bit	Rx Lower Threshold, Pasue Pack */
/*	RB_RX_UTHP	32 bit	Rx Upper Threshold, High Prio */
/*	RB_RX_LTHP	32 bit	Rx Lower Threshold, High Prio */
/*	RB_PC		32 bit	RAM Buffer Packet Counter */
/*	RB_LEV		32 bit	RAM Buffer Level Register */
				/* Bit 31..19:	reserved */
#define RB_MSK	0x0007ffff	/* Bit 18.. 0:	RAM Buffer Pointer Bits */

/*	RB_TST2		8 bit	RAM Buffer Test Register 2 */
							/* Bit 4..7:	reserved */
#define	RB_PC_DEC	(1<<3)	/* Bit 3:	Packet Counter Decrem */
#define RB_PC_T_ON	(1<<2)	/* Bit 2:	Packet Counter Test On */
#define RB_PC_T_OFF	(1<<1)	/* Bit 1:	Packet Counter Tst Off */
#define RB_PC_INC	(1<<0)	/* Bit 0:	Packet Counter Increm */

/*	RB_TST1		8 bit	RAM Buffer Test Register 1 */
				/* Bit 7:	reserved */
#define RB_WP_T_ON	(1<<6)	/* Bit 6:	Write Pointer Test On */
#define RB_WP_T_OFF	(1<<5)	/* Bit 5:	Write Pointer Test Off */
#define RB_WP_INC	(1<<4)	/* Bit 4:	Write Pointer Increm */
							/* Bit 3:	reserved */
#define RB_RP_T_ON	(1<<2)	/* Bit 2:	Read Pointer Test On */
#define RB_RP_T_OFF	(1<<1)	/* Bit 1:	Read Pointer Test Off */
#define RB_RP_DEC	(1<<0)	/* Bit 0:	Read Pointer Decrement */

/*	RB_CTRL		8 bit	RAM Buffer Control Register */
								/* Bit	7..6:	reserved */
#define RB_ENA_STFWD	(1<<5)	/* Bit	5:	Enable Store & Forward */
#define RB_DIS_STFWD	(1<<4)	/* Bit	4:	Disab. Store & Forward */
#define RB_ENA_OP_MD	(1<<3)	/* Bit	3:	Enable Operation Mode */
#define RB_DIS_OP_MD	(1<<2)	/* Bit	2:	Disab. Operation Mode */
#define RB_RST_CLR		(1<<1)	/* Bit	1:	Clr RAM Buf STM Reset */
#define RB_RST_SET		(1<<0)	/* Bit	0:	Set RAM Buf STM Reset */


/* Receive and Transmit MAC FIFO Registers, use MR_ADDR() to address */
/*	RX_MFF_EA	32 bit	Receive MAC FIFO End Address */
/*	RX_MFF_WP	32 bit 	Receive MAC FIFO Write Pointer */
/*	RX_MFF_RP	32 bit	Receive MAC FIFO Read Pointer */
/*	RX_MFF_PC	32 bit	Receive MAC FIFO Packet Counter*/
/*	RX_MFF_LEV	32 bit	Receive MAC FIFO Level */
/*	TX_MFF_EA	32 bit	Transmit MAC FIFO End Address */
/*	TX_MFF_WP	32 bit 	Transmit MAC FIFO Write Pointer*/
/*	TX_MFF_WSP	32 bit	Transmit MAC FIFO WR Shadow Pt*/
/*	TX_MFF_RP	32 bit	Transmit MAC FIFO Read Pointer */
/*	TX_MFF_PC	32 bit	Transmit MAC FIFO Packet Cnt */
/*	TX_MFF_LEV	32 bit	Transmit MAC FIFO Level */
							/* Bit 31..6:	reserved */
#define MFF_MSK		0x007fL	/* Bit	5..0:	MAC FIFO Address/Pointer Bits */

/*	RX_MFF_CTRL1	16 bit	Receive MAC FIFO Control Reg 1 */
									/* Bit 15..14:	reserved */
#define MFF_ENA_RDY_PAT	(1<<13)		/* Bit 13:	Enable Ready Patch */
#define MFF_DIS_RDY_PAT	(1<<12)		/* Bit 12:	Disable Ready Patch */
#define MFF_ENA_TIM_PAT	(1<<11)		/* Bit 11:	Enable Timing Patch */
#define MFF_DIS_TIM_PAT	(1<<10)		/* Bit 10:	Disable Timing Patch */
#define MFF_ENA_ALM_FUL	(1<<9)		/* Bit	9:	Enable AlmostFull Sign*/
#define MFF_DIS_ALM_FUL	(1<<8)		/* Bit	8:	Disab. AlmostFull Sign*/
#define MFF_ENA_PAUSE	(1<<7)		/* Bit	7:	Enable Pause Signaling*/
#define MFF_DIS_PAUSE	(1<<6)		/* Bit	6:	Disab. Pause Signaling*/
#define MFF_ENA_FLUSH	(1<<5)		/* Bit	5:	Enable Frame Flushing */
#define MFF_DIS_FLUSH	(1<<4)		/* Bit	4:	Disab. Frame Flushing */
#define MFF_ENA_TIST	(1<<3)		/* Bit	3:	Enable Timestamp Gener*/
#define MFF_DIS_TIST	(1<<2)		/* Bit	2:	Disab. Timestamp Gener*/
#define MFF_CLR_INTIST	(1<<1)		/* Bit	1:	Clear IRQ No Timestamp*/
#define MFF_CLR_INSTAT	(1<<0)		/* Bit	0:	Clear IRQ No Status */

#define MFF_RX_CTRL_DEF MFF_ENA_TIM_PAT

/*	TX_MFF_CTRL1	16 bit	Transmit MAC FIFO Control Reg 1 */
#define MFF_CLR_PERR	(1<<15)		/* Bit 15:	Clear Parity Error IRQ*/
									/* Bit 14:	reserved */
#define MFF_ENA_PKT_REC	(1<<13)		/* Bit 13:	Enable Packet Recovery*/
#define MFF_DIS_PKT_REC (1<<12)		/* Bit 12:	Disable Packet Recov. */
/*	MFF_ENA_TIM_PAT	 (see RX_MFF_CTRL1)Bit 11:	Enable Timing Patch */
/*	MFF_DIS_TIM_PAT	 (see RX_MFF_CTRL1)Bit 10:	Disable Timing Patch */
/*	MFF_ENA_ALM_FUL	 (see RX_MFF_CTRL1)Bit	9:	Enable AlmostFull Sign*/
/*	MFF_DIS_ALM_FUL	 (see RX_MFF_CTRL1)Bit	8:	Disab. AlmostFull Sign*/
#define	MFF_ENA_W4E		(1<<7)		/* Bit	7:	Enable Wait for Empty */
#define MFF_DIS_W4E		(1<<6)		/* Bit	6:	Disab. Wait for Empty */
/*	MFF_ENA_FLUSH	 (see RX_MFF_CTRL1)Bit	5:	Enable Frame Flushing */
/*	MFF_DIS_FLUSH	 (see RX_MFF_CTRL1)Bit	4:	Disab. Frame Flushing */
#define MFF_ENA_LOOPB	(1<<3)		/* Bit	3:	Enable Loopback */
#define MFF_DIS_LOOPB	(1<<2)		/* Bit	2:	Disable Loopback */
#define MFF_CLR_MAC_RST	(1<<1)		/* Bit	1:	Clear XMAC Reset */
#define MFF_SET_MAC_RST	(1<<0)		/* Bit	0:	Set XMAC Reset */

#define MFF_TX_CTRL_DEF	(MFF_ENA_PKT_REC | MFF_ENA_TIM_PAT | MFF_ENA_FLUSH)

/*	RX_MFF_TST2	 8 bit	Receive MAC FIFO Test Register 2 */
/*	TX_MFF_TST2	 8 bit	Transmit MAC FIFO Test Register 2 */
								/* Bit 7:	reserved */
#define MFF_WSP_T_ON	(1<<6)	/* Bit 6: (Tx)	Write Shadow Pt TestOn */
#define MFF_WSP_T_OFF	(1<<5)	/* Bit 5: (Tx)	Write Shadow Pt TstOff */
#define MFF_WSP_INC		(1<<4)	/* Bit 4: (Tx)	Write Shadow Pt Increm */
#define	MFF_PC_DEC		(1<<3)	/* Bit 3:	Packet Counter Decrem  */
#define MFF_PC_T_ON		(1<<2)	/* Bit 2:	Packet Counter Test On */
#define MFF_PC_T_OFF	(1<<1)	/* Bit 1:	Packet Counter Tst Off */
#define MFF_PC_INC		(1<<0)	/* Bit 0:	Packet Counter Increm  */

/*	RX_MFF_TST1	 8 bit	Receive MAC FIFO Test Register 1 */
/*	TX_MFF_TST1	 8 bit	Transmit MAC FIFO Test Register 1 */
					/* Bit 7:	reserved */
#define MFF_WP_T_ON		(1<<6)	/* Bit 6:	Write Pointer Test On */
#define MFF_WP_T_OFF	(1<<5)	/* Bit 5:	Write Pointer Test Off */
#define MFF_WP_INC		(1<<4)	/* Bit 4:	Write Pointer Increm */
								/* Bit 3:	reserved */
#define MFF_RP_T_ON		(1<<2)	/* Bit 2:	Read Pointer Test On */
#define MFF_RP_T_OFF	(1<<1)	/* Bit 1:	Read Pointer Test Off */
#define MFF_RP_DEC		(1<<0)	/* Bit 0:	Read Pointer Decrement */

/*	RX_MFF_CTRL2	 8 bit	Receive MAC FIFO Control Reg 2 */
/*	TX_MFF_CTRL2	 8 bit	Transmit MAC FIFO Control Reg 2 */
								/* Bit 7..4:	reserved */
#define MFF_ENA_OP_MD	(1<<3)	/* Bit 3:	Enable Operation Mode */
#define MFF_DIS_OP_MD	(1<<2)	/* Bit 2:	Disab. Operation Mode */
#define MFF_RST_CLR		(1<<1)	/* Bit 1:	Clear MAC FIFO Reset */
#define MFF_RST_SET		(1<<0)	/* Bit 0:	Set MAC FIFO Reset */


/* Receive, Transmit, and Link LED Counter Registers */
/*	RX_LED_CTRL		8 bit	Receive LED Cnt Control Reg */
/*	TX_LED_CTRL		8 bit	Transmit LED Cnt Control Reg */
/*	LNK_SYNC_CTRL	8 bit	Link Sync Cnt Control Register */
							/* Bit 7..3:	reserved */
#define LED_START	(1<<2)	/* Bit 2:	Start Timer */
#define LED_STOP	(1<<1)	/* Bit 1:	Stop Timer */
#define LED_STATE	(1<<0)	/* Bit 0:(Rx/Tx)LED State, 1=LED on */
#define LED_CLR_IRQ	(1<<0)	/* Bit 0:(Lnk) 	Clear Link IRQ */

/*	RX_LED_TST		8 bit	Receive LED Cnt Test Register */
/*	TX_LED_TST		8 bit	Transmit LED Cnt Test Register */
/*	LNK_SYNC_TST	8 bit	Link Sync Cnt Test Register */
							/* Bit 7..3:	reserved */
#define LED_T_ON	(1<<2)	/* Bit 2:	LED Counter Testmode On */
#define LED_T_OFF	(1<<1)	/* Bit 1:	LED Counter Testmode Off */
#define LED_T_STEP	(1<<0)	/* Bit 0:	LED Counter Step */

/*	LNK_LED_REG	 8 bit	Link LED Register */
								/* Bit 7..6:	reserved */
#define LED_BLK_ON		(1<<5)	/* Bit 5:	Link LED Blinking On */
#define LED_BLK_OFF		(1<<4)	/* Bit 4:	Link LED Blinking Off */
#define LED_SYNC_ON		(1<<3)	/* Bit 3:	Use Sync Wire to switch LED */
#define LED_SYNC_OFF	(1<<2)	/* Bit 2:	Disable Sync Wire Input */
#define LED_ON			(1<<1)	/* Bit 1:	switch LED on */
#define LED_OFF			(1<<0)	/* Bit 0:	switch LED off */


/* Receive and Transmit Descriptors ******************************************/

/* Transmit Descriptor struct */
typedef	struct s_HwTxd {
	SK_U32 volatile	TxCtrl;	/* Transmit Buffer Control Field */
	SK_U32	TxNext;			/* Physical Address Pointer to the next TxD */
	SK_U32	TxAdrLo;		/* Physical Tx Buffer Address lower dword */
	SK_U32	TxAdrHi;		/* Physical Tx Buffer Address upper dword */
	SK_U32	TxStat;			/* Transmit Frame Status Word */
#ifndef	SK_USE_REV_DESC
	SK_U16	TxTcpOffs;		/* TCP Checksum Calculation Start Value */
	SK_U16	TxRes1;			/* 16 bit reserved field */
	SK_U16	TxTcpWp;		/* TCP Checksum Write Position */
	SK_U16	TxTcpSp;		/* TCP Checksum Calculation Start Position */
#else	/* SK_USE_REV_DESC */
	SK_U16	TxRes1;			/* 16 bit reserved field */
	SK_U16	TxTcpOffs;		/* TCP Checksum Calculation Start Value */
	SK_U16	TxTcpSp;		/* TCP Checksum Calculation Start Position */
	SK_U16	TxTcpWp;		/* TCP Checksum Write Position */
#endif	/* SK_USE_REV_DESC */
	SK_U32  TxRes2;			/* 32 bit reserved field */
} SK_HWTXD;

/* Receive Descriptor struct */
typedef	struct s_HwRxd {
	SK_U32 volatile RxCtrl;	/* Receive Buffer Control Field */
	SK_U32	RxNext;		/* Physical Address Pointer to the next TxD */
	SK_U32	RxAdrLo;	/* Physical Receive Buffer Address lower dword*/
	SK_U32	RxAdrHi;	/* Physical Receive Buffer Address upper dword*/
	SK_U32	RxStat;		/* Receive Frame Status Word */
	SK_U32	RxTiSt;		/* Receive Timestamp provided by the XMAC */
#ifndef	SK_USE_REV_DESC	
	SK_U16	RxTcpSum1;	/* TCP Checksum 1 */
	SK_U16	RxTcpSum2;	/* TCP Checksum 2 */
	SK_U16	RxTcpSp1;	/* TCP Checksum Calculation Start Position 1 */
	SK_U16	RxTcpSp2;	/* TCP Checksum Calculation Start Position 2 */
#else	/* SK_USE_REV_DESC */
	SK_U16	RxTcpSum2;	/* TCP Checksum 2 */
	SK_U16	RxTcpSum1;	/* TCP Checksum 1 */
	SK_U16	RxTcpSp2;	/* TCP Checksum Calculation Start Position 2 */
	SK_U16	RxTcpSp1;	/* TCP Checksum Calculation Start Position 1 */
#endif	/* SK_USE_REV_DESC */
} SK_HWRXD;

/*
 * Drivers which use the reverse descriptor feature (PCI_OUR_REG_2)
 * should set the define SK_USE_REV_DESC.
 * Structures are 'normaly' not endianess dependent. But in 
 * this case the SK_U16 fields are bound to bit positions inside the
 * descriptor. RxTcpSum1 e.g. must start at bit 0 within the 6.th DWord.
 * The bit positions inside a DWord are of course endianess dependent and
 * swaps if the DWord is swaped by the hardware.
 */


/* Descriptor Bit Definition */
/*	TxCtrl		Transmit Buffer Control Field */
/*	RxCtrl		Receive Buffer Control Field */
#define	BMU_OWN			(1UL<<31)	/* Bit 31:	OWN bit: 0=host/1=BMU */
#define	BMU_STF			(1L<<30)	/* Bit 30:	Start of Frame ? */
#define	BMU_EOF			(1L<<29)	/* Bit 29:	End of Frame ?	*/
#define	BMU_IRQ_EOB		(1L<<28)	/* Bit 28:	Req "End of Buff" IRQ */
#define	BMU_IRQ_EOF		(1L<<27)	/* Bit 27:	Req "End of Frame" IRQ*/
/* TxCtrl specific bits */
#define BMU_STFWD		(1L<<26)	/* Bit 26: (Tx)	Store&Forward Frame */
#define BMU_NO_FCS		(1L<<25)	/* Bit 25: (Tx) disable XMAC FCS gener*/
#define BMU_SW			(1L<<24)	/* Bit 24: (Tx)	1 bit res. for SW use */
/* RxCtrl specific bits */
#define	BMU_DEV_0		(1L<<26)	/* Bit 26: (Rx)	transfer data to Dev0 */
#define BMU_STAT_VAL	(1L<<25)	/* Bit 25: (Rx)	RxStat Valid */
#define BMU_TIST_VAL	(1L<<24)	/* Bit 24: (Rx)	RxTiSt Valid */
									/* Bit 23..16:	BMU Check Opcodes */
#define	BMU_CHECK		0x00550000L	/* 		Default BMU check */
#define	BMU_TCP_CHECK	0x00560000L	/* 		Descr with TCP ext */
#define	BMU_BBC			0x0000FFFFL	/* Bit 15..0:	Buffer Byte Counter */

/*	TxStat		Transmit Frame Status Word */
/*	RxStat		Receive Frame Status Word */
/*
 *Note: TxStat is reserved for ASIC loopback mode only
 *
 *	The Bits of the Status words are defined in xmac_ii.h
 *	(see XMR_FS bits)
 */

/* other defines *************************************************************/

/*
 * FlashProm specification
 */
#define	MAX_PAGES	0x20000L	/* Every byte has a single page */
#define	MAX_FADDR	1			/* 1 byte per page */
#define	SKFDDI_PSZ	8			/* address PROM size */

/* macros ********************************************************************/

/*
 * Receive and Transmit Queues
 */
#define Q_R1	0x0000		/* Receive Queue 1 */
#define Q_R2	0x0080		/* Receive Queue 2 */
#define Q_XS1	0x0200		/* Synchronous Transmit Queue 1 */
#define Q_XA1	0x0280		/* Asynchronous Transmit Queue 1 */
#define Q_XS2	0x0300		/* Synchronous Transmit Queue 2 */
#define Q_XA2	0x0380		/* Asynchronous Transmit Queue 2 */

/*
 *	Macro Q_ADDR()
 *
 *	Use this macro to address the Receive and Transmit Queue Registers.
 *
 * para	Queue	Queue to address.
 *			Values: Q_R1, Q_R2, Q_XS1, Q_XA1, Q_XS2, and Q_XA2
 *	Offs	Queue register offset.
 *			Values: Q_D, Q_DA_L ... Q_T2, Q_T3
 *
 * usage	SK_IN32(pAC,Q_ADDR(Q_R2,Q_BC),pVal)
 */
#define Q_ADDR(Queue,Offs)	(B8_Q_REGS + (Queue) + (Offs))

/*
 *	Macro RB_ADDR()
 *
 *	Use this macro to address the RAM Buffer Registers.
 *
 * para	Queue	Queue to address.
 *			Values: Q_R1, Q_R2, Q_XS1, Q_XA1, Q_XS2, and Q_XA2
 *	Offs	Queue register offset.
 *			Values: RB_START, RB_END ... RB_LEV, RB_CTRL
 *
 * usage	SK_IN32(pAC,RB_ADDR(Q_R2,RB_RP),pVal)
 */
#define RB_ADDR(Queue,Offs)	(B16_RAM_REGS + (Queue) + (Offs))


/*
 * MAC Related Registers
 */
#define	MAC_1		0	/* belongs to the port near the slot */
#define MAC_2		1	/* belongs to the port far away from the slot */

/*
 *	Macro MR_ADDR()
 *
 *	Use this macro to address a MAC Related Registers in side the ASIC.
 *
 * para	Queue	Queue to address.
 *			Values:	TXA_ITI_INI	...	TXA_TEST,
 *				RX_MFF_EA	...	RX_LED_TST,
 *				LNK_SYNC_INI	...	LNK_LED_REG, and
 *				TX_MFF_EA	...	TX_LED_TST
 *	Mac	MAC to address.
 *			Values: MAC_1, MAC_2
 *
 * usage	SK_IN32(pAC,MR_ADDR(MAC_1,TX_MFF_EA),pVal)
 */
#define MR_ADDR(Mac,Offs)	(((Mac) << 7) + (Offs))



/*
 * macros to access the XMAC
 *
 * XM_IN16(),		to read a 16 bit register (e.g. XM_MMU_CMD)
 * XM_OUT16(),		to write a 16 bit register (e.g. XM_MMU_CMD)
 * XM_IN32(),		to read a 32 bit register (e.g. XM_TX_EV_CNT)
 * XM_OUT32(),		to write a 32 bit register (e.g. XM_TX_EV_CNT)
 * XM_INADDR(),		to read a network address register (e.g. XM_SRC_CHK)
 * XM_OUTADDR(),	to write a network address register (e.g. XM_SRC_CHK)
 * XM_INHASH(),		to read the XM_HSM_CHK register
 * XM_OUTHASH()		to write the XM_HSM_CHK register
 *
 * para:	Mac	XMAC to address		values: MAC_1 or MAC_2
 *		IoC	I/O context needed for SK IO macros
 *		Reg	XMAC Register to read or write
 *		(p)Val	Value or pointer to the value which should be read or
 *			written.
 *
 * usage:	XM_OUT16(IoC, MAC_1, XM_MMU_CMD, Value);
 */

#ifdef	SK_LITTLE_ENDIAN
#define	XM_WORD_LO	0
#define XM_WORD_HI	1
#else	/* !SK_LITTLE_ENDIAN */
#define	XM_WORD_LO	1
#define XM_WORD_HI	0
#endif	/* !SK_LITTLE_ENDIAN */

#define	XMA(Mac,Reg)	(((0x1000 << (Mac)) + 0x1000) | ((Reg) << 1))

#define XM_IN16(IoC,Mac,Reg,pVal)	SK_IN16((IoC), XMA((Mac), (Reg)), (pVal))
#define XM_OUT16(IoC,Mac,Reg,Val)	SK_OUT16((IoC), XMA((Mac), (Reg)), (Val))

#define XM_IN32(IoC,Mac,Reg,pVal) {						\
	SK_IN16((IoC), XMA((Mac), (Reg)),					\
		(SK_U16 *)&((SK_U16 *)(pVal))[XM_WORD_LO]);		\
	SK_IN16((IoC), XMA((Mac), (Reg+2)),					\
		(SK_U16 *)&((SK_U16 *)(pVal))[XM_WORD_HI]);		\
}

#define XM_OUT32(IoC,Mac,Reg,Val) {											\
	SK_OUT16((IoC), XMA((Mac), (Reg)), (SK_U16)((Val) & 0x0000ffffL));		\
	SK_OUT16((IoC), XMA((Mac), (Reg+2)),(SK_U16)(((Val)>>16) & 0x0000ffffL));	\
}

/*
 * Remember: we are always writing to / reading from LITTLE ENDIAN memory
 */

#define XM_INADDR(IoC, Mac, Reg, pVal) {				\
	SK_U16	Word;										\
	SK_U8	*pByte;										\
	pByte = (SK_U8 *)&((SK_U8 *)(pVal))[0];				\
	SK_IN16((IoC), XMA((Mac), (Reg)), &Word);			\
	pByte[0] = (SK_U8)(Word  & 0x00ff);					\
	pByte[1] = (SK_U8)((Word >> 8) & 0x00ff);			\
	SK_IN16((IoC), XMA((Mac), (Reg+2)), &Word);			\
	pByte[2] = (SK_U8)(Word  & 0x00ff);					\
	pByte[3] = (SK_U8)((Word >> 8) & 0x00ff);			\
	SK_IN16((IoC), XMA((Mac), (Reg+4)), &Word);			\
	pByte[4] = (SK_U8)(Word  & 0x00ff);					\
	pByte[5] = (SK_U8)((Word >> 8) & 0x00ff);			\
}

#define XM_OUTADDR(IoC, Mac, Reg, pVal) {				\
	SK_U8	*pByte;										\
	pByte = (SK_U8 *)&((SK_U8 *)(pVal))[0];				\
	SK_OUT16((IoC), XMA((Mac), (Reg)), (SK_U16)			\
		(((SK_U16)(pByte[0]) & 0x00ff) |				\
		(((SK_U16)(pByte[1]) << 8) & 0xff00)));			\
	SK_OUT16((IoC), XMA((Mac), (Reg+2)), (SK_U16)		\
		(((SK_U16)(pByte[2]) & 0x00ff) |				\
		(((SK_U16)(pByte[3]) << 8) & 0xff00)));			\
	SK_OUT16((IoC), XMA((Mac), (Reg+4)), (SK_U16)		\
		(((SK_U16)(pByte[4]) & 0x00ff) |				\
		(((SK_U16)(pByte[5]) << 8) & 0xff00)));			\
}

#define XM_INHASH(IoC, Mac, Reg, pVal) {				\
	SK_U16	Word;										\
	SK_U8	*pByte;										\
	pByte = (SK_U8 *)&((SK_U8 *)(pVal))[0];				\
	SK_IN16((IoC), XMA((Mac), (Reg)), &Word);			\
	pByte[0] = (SK_U8)(Word  & 0x00ff);					\
	pByte[1] = (SK_U8)((Word >> 8) & 0x00ff);			\
	SK_IN16((IoC), XMA((Mac), (Reg+2)), &Word);			\
	pByte[2] = (SK_U8)(Word  & 0x00ff);					\
	pByte[3] = (SK_U8)((Word >> 8) & 0x00ff);			\
	SK_IN16((IoC), XMA((Mac), (Reg+4)), &Word);			\
	pByte[4] = (SK_U8)(Word  & 0x00ff);					\
	pByte[5] = (SK_U8)((Word >> 8) & 0x00ff);			\
	SK_IN16((IoC), XMA((Mac), (Reg+6)), &Word);			\
	pByte[6] = (SK_U8)(Word  & 0x00ff);					\
	pByte[7] = (SK_U8)((Word >> 8) & 0x00ff);			\
}

#define XM_OUTHASH(IoC, Mac, Reg, pVal) {				\
	SK_U8	*pByte;										\
	pByte = (SK_U8 *)&((SK_U8 *)(pVal))[0];				\
	SK_OUT16((IoC), XMA((Mac), (Reg)), (SK_U16)			\
		(((SK_U16)(pByte[0]) & 0x00ff)|					\
		(((SK_U16)(pByte[1]) << 8) & 0xff00)));			\
	SK_OUT16((IoC), XMA((Mac), (Reg+2)), (SK_U16)		\
		(((SK_U16)(pByte[2]) & 0x00ff)|					\
		(((SK_U16)(pByte[3]) << 8) & 0xff00)));			\
	SK_OUT16((IoC), XMA((Mac), (Reg+4)), (SK_U16)		\
		(((SK_U16)(pByte[4]) & 0x00ff)|					\
		(((SK_U16)(pByte[5]) << 8) & 0xff00)));			\
	SK_OUT16((IoC), XMA((Mac), (Reg+6)), (SK_U16)		\
		(((SK_U16)(pByte[6]) & 0x00ff)|					\
		(((SK_U16)(pByte[7]) << 8) & 0xff00)));			\
}

/*
 * Different PHY Types
 */
#define SK_PHY_XMAC	0	/* integrated in Xmac II*/
#define SK_PHY_BCOM	1	/* Broadcom BCM5400 */
#define SK_PHY_LONE	2	/* Level One LXT1000 */
#define SK_PHY_NAT	3	/* National DP83891 */ 

/*
 * PHY addresses (bits 8..12 of PHY address reg)
 */
#define PHY_ADDR_XMAC	(0<<8)
#define PHY_ADDR_BCOM	(1<<8)
#define PHY_ADDR_LONE	(3<<8)
#define PHY_ADDR_NAT	(0<<8)

/*
 * macros to access the PHY
 *
 * PHY_READ()		read a 16 bit value from the PHY
 * PHY_WIRTE()		write a 16 bit value to the PHY
 *
 * para:	IoC	I/O context needed for SK IO macros
 *		pPort	Pointer to port struct for PhyAddr
 * 		Mac	XMAC to address		values: MAC_1 or MAC_2
 *		PhyReg	PHY Register to read or write
 *		(p)Val	Value or pointer to the value which should be read or
 *			written.
 *
 * usage:	PHY_READ(IoC, pPort, MAC_1, PHY_CTRL, Value);
 * Warning: a PHY_READ on an uninitialized PHY (PHY still in reset) never
 *          comes back. This is checked in DEBUG mode.
 */
#ifndef DEBUG
#define PHY_READ(IoC, pPort, Mac, PhyReg, pVal) {						\
	SK_U16 Mmu;  														\
																		\
	XM_OUT16((IoC), (Mac), XM_PHY_ADDR, (PhyReg) | (pPort)->PhyAddr);	\
	XM_IN16((IoC), (Mac), XM_PHY_DATA, (pVal));							\
	if ((pPort)->PhyType != SK_PHY_XMAC) {								\
		do {  															\
			XM_IN16((IoC), (Mac), XM_MMU_CMD, &Mmu);					\
		} while ((Mmu & XM_MMU_PHY_RDY) == 0);							\
		XM_IN16((IoC), (Mac), XM_PHY_DATA, (pVal));						\
	}  																	\
}
#else
#define PHY_READ(IoC, pPort, Mac, PhyReg, pVal) {						\
	SK_U16 Mmu;  														\
	int __i = 0;														\
																		\
	XM_OUT16((IoC), (Mac), XM_PHY_ADDR, (PhyReg) | (pPort)->PhyAddr);	\
	XM_IN16((IoC), (Mac), XM_PHY_DATA, (pVal));							\
	if ((pPort)->PhyType != SK_PHY_XMAC) {								\
		do {  															\
			XM_IN16((IoC), (Mac), XM_MMU_CMD, &Mmu);					\
			__i++;														\
			if (__i > 100000) {											\
				SK_DBG_PRINTF("*****************************\n");		\
				SK_DBG_PRINTF("PHY_READ on uninitialized PHY\n");		\
				SK_DBG_PRINTF("*****************************\n");		\
				break;													\
			}															\
		} while ((Mmu & XM_MMU_PHY_RDY) == 0);							\
		XM_IN16((IoC), (Mac), XM_PHY_DATA, (pVal));						\
	}  																	\
}
#endif

#define PHY_WRITE(IoC, pPort, Mac, PhyReg, Val) {						\
	SK_U16 Mmu;															\
																		\
	if ((pPort)->PhyType != SK_PHY_XMAC) {								\
		do {  															\
			XM_IN16((IoC), (Mac), XM_MMU_CMD, &Mmu);					\
		} while ((Mmu & XM_MMU_PHY_BUSY) != 0);							\
	}  																	\
	XM_OUT16((IoC), (Mac), XM_PHY_ADDR, (PhyReg) | (pPort)->PhyAddr);	\
	XM_OUT16((IoC), (Mac), XM_PHY_DATA, (Val));							\
	if ((pPort)->PhyType != SK_PHY_XMAC) {								\
		do {  															\
			XM_IN16((IoC), (Mac), XM_MMU_CMD, &Mmu);					\
		} while ((Mmu & XM_MMU_PHY_BUSY) != 0);							\
	}  																	\
}

/*
 *	Macro PCI_C()
 *
 *	Use this macro to address PCI config register from the IO space.
 *
 * para	Addr	PCI configuration register to address.
 *			Values:	PCI_VENDOR_ID	...	PCI_VPD_ADDR,
 *
 * usage	SK_IN16(pAC,PCI_C(PCI_VENDOR_ID),pVal);
 */
#define PCI_C(Addr)	(B7_CFG_SPC + (Addr))	/* PCI Config Space */

/*
 *	Macro SK_ADDR(Base,Addr)
 *
 *	Calculates the effective HW address
 *
 * para Base	IO- or memory base address
 *	Addr	Address offset
 *
 * usage:	May be used in SK_INxx and SK_OUTxx macros
 *		#define SK_IN8(pAC,Addr,pVal) ...\
 *			*pVal = (SK_U8) inp(SK_ADDR(pAC->Hw.Iop,Addr)))
 */
#ifdef	SK_MEM_MAPPED_IO
#define	SK_HW_ADDR(Base,Addr)	((Base)+(Addr))
#else	/* SK_MEM_MAPPED_IO */
#define SK_HW_ADDR(Base,Addr)	((Base)+(((Addr)&0x7F)|((Addr)>>7 ? 0x80:0)))
#endif	/* SK_MEM_MAPPED_IO */

#define	SZ_LONG	(sizeof(SK_U32))

/*
 *	Macro SK_HWAC_LINK_LED()
 *
 *	Use this macro to set the link LED mode.
 * para pAC	Pointer to adapter context struct
 *	IoC	I/O context needed for SK IO macros
 *     	Port	Port number
 *	Mode	Mode to set for this LED
 */
#define SK_HWAC_LINK_LED(pAC, IoC, Port, Mode) \
	SK_OUT8(IoC, MR_ADDR(Port,LNK_LED_REG), Mode); 

 
/* typedefs *******************************************************************/


/* function prototypes ********************************************************/

#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif	/* __INC_SKGEHW_H */
