/*
 $Header: /projects/proj/software/pub/CVSROOT/uClinux/linux/drivers/net/phyethgeneric.h,v 1.8 2003/01/07 17:36:24 rsewill Exp $
 */

/******************************************************************/
/* Copyright (c) 2002 BRECIS Communications                       */
/*                                                                */
/*     This program is free software; you can redistribute it     */
/*     and/or modify it under the terms of the GNU General        */
/*     Public License as published by the Free Software           */
/*     Foundation; either version 2 of the License, or (at your   */
/*     option) any later version.                                 */
/*                                                                */
/*     This program is distributed in the hope that it will be    */
/*     useful, but WITHOUT ANY WARRANTY; without even the implied */
/*     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR    */
/*     PURPOSE.  See the GNU General Public License for more      */
/*     details.                                                   */
/*                                                                */
/*     You should have received a copy of the GNU General Public  */
/*     License along with this program; if not, write to the Free */
/*     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA     */
/*     02139, USA.                                                */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/


/* PHY Register Addresses */  

#define PHYG_CONTROL							0
#define PHYG_STATUS_REG_ONE						1
#define PHYG_PHY_ID_REG_ONE						2
#define PHYG_PHY_ID_REG_TWO						3
#define PHYG_AUTO_NEG_ADVERTISING				4
#define PHYG_AUTO_NEG_LINK_PARTNER_ABILITY		5
#define PHYG_AUTO_NEG_EXPANSION					6
#define PHYG_AUTO_NEG_NEXT_PAGE_TX				7
#define PHYG_AUTO_NEG_LINK_PARTNER_RX_NEXT		8


/* Bit Defines for PHYG_CONTROL  			*/
/* ---------------------------------------- */
#define PHYGb_CONTROL_RESET						0x8000
#define PHYGb_CONTROL_LOOPBACK					0x4000
#define PHYGb_CONTROL_SELECT_SPEED				0x2000
#define PHYGb_CONTROL_AUTONEG					0x1000
#define PHYGb_CONTROL_POWERDOWN					0x0800
#define PHYGb_CONTROL_ISOLATE					0x0400
#define PHYGb_CONTROL_RESTART_AUTONEG			0x0200
#define PHYGb_CONTROL_DUPLEXMODE				0x0100
#define PHYGb_CONTROL_COLLISION_TEST			0x0080
#define PHYGb_CONTROL_SPEED_10_HALF				0x0000
#define PHYGb_CONTROL_SPEED_10_FULL				(PHYGb_CONTROL_DUPLEXMODE)
#define PHYGb_CONTROL_SPEED_100_HALF			(PHYGb_CONTROL_SELECT_SPEED )
#define PHYGb_CONTROL_SPEED_100_FULL			(PHYGb_CONTROL_SELECT_SPEED | PHYGb_CONTROL_DUPLEXMODE)
 
/* Bit Defines for PHYG_STATUS_REG_ONE 	*/
/* -------------------------------------	*/
#define PHYGb_STATUS_REG_ONE_100BASE_T4_OK		0x8000
#define PHYGb_STATUS_REG_ONE_100BASE_TX_FULL	0x4000
#define PHYGb_STATUS_REG_ONE_100BASE_TX_HALF	0x2000
#define PHYGb_STATUS_REG_ONE_10BASE_T_FULL		0x1000
#define PHYGb_STATUS_REG_ONE_10BASE_T_HALF		0x0800
	/* not used									0x0400	*/
	/* not used									0x0200	*/
	/* not used									0x0100	*/
	/* not used									0x0080	*/
#define PHYGb_STATUS_REG_ONE_NO_PREAMBLE		0x0040
#define PHYGb_STATUS_REG_ONE_AUTO_NEG_DONE		0x0020
#define PHYGb_STATUS_REG_ONE_REMOTE_FAULT		0x0010
#define PHYGb_STATUS_REG_ONE_AUTO_NEG_ABILITY	0x0008
#define PHYGb_STATUS_REG_ONE_LINK_STATUS		0x0004
#define PHYGb_STATUS_REG_ONE_JABBER_DETECT		0x0002
#define PHYGb_STATUS_REG_ONE_EXT_CAPABILITY		0x0001

#define PHYGb_MEDIAMASK							  \
		(PHYGb_STATUS_REG_ONE_100BASE_T4_OK		| \
		PHYGb_STATUS_REG_ONE_100BASE_TX_FULL	| \
		PHYGb_STATUS_REG_ONE_100BASE_TX_HALF	| \
		PHYGb_STATUS_REG_ONE_10BASE_T_FULL		| \
		PHYGb_STATUS_REG_ONE_10BASE_T_HALF		| \
		PHYGb_STATUS_REG_ONE_AUTO_NEG_ABILITY)

/* Bit Defines for PHYG_AUTO_NEG_ADVERTISING 	*/
/* -------------------------------------------- */
#define PHYGb_AUTO_NEG_ADVERT_NEXT_PAGE			0x8000
	/* not used									0x4000	*/
#define PHYGb_AUTO_NEG_ADVERT_REMOTE_FAULT		0x2000
	/* not used									0x1000	*/
	/* not used									0x0800	*/
#define PHYGb_AUTO_NEG_ADVERT_REMOTE_PAUSE		0x0400
#define PHYGb_AUTO_NEG_ADVERT_100BASE_T4		0x0200
#define PHYGb_AUTO_NEG_ADVERT_100BASE_TX_FULL	0x0100
#define PHYGb_AUTO_NEG_ADVERT_100BASE_TX		0x0080
#define PHYGb_AUTO_NEG_ADVERT_10BASE_T_FULL		0x0040
#define PHYGb_AUTO_NEG_ADVERT_10BASE_T			0x0020
	/* selector field 			bits 0 - 4				*/

/* Bit Defines for PHYG_AUTO_NEG_LINK_PARTNER_ABILITY	*/
/* ---------------------------------------------------- */
#define PHYGb_AUTO_NEG_LINK_NEXT_PAGE			0x8000
#define PHYGb_AUTO_NEG_LINK_ACKNOWLEDGE			0x4000
#define PHYGb_AUTO_NEG_LINK_REMOTE_FAULT		0x2000
	/* PAUSE field 			bits 10 - 11			*/
#define PHYGb_AUTO_NET_LINK_100BASE_T4			0x0200
#define PHYGb_AUTO_NET_LINK_100BASE_TX_FULL		0x0100
#define PHYGb_AUTO_NET_LINK_100BASE_TX			0x0080
#define PHYGb_AUTO_NEG_LINK_10BASE_T_FULL		0x0040
#define PHYGb_AUTO_NEG_LINK_10BASE_T			0x0020
	/* selector field 			bits 0 - 4				*/



/* Operation Delays */  
/* ---------------- */

#define MD_REGISTER_UDELAY			(1)	/* 1 us delay */
#define PHYG_UDELAY_FOR_RESPONSE		(50)	/* 50 us delay max */
#define PHYG_MAX_UDELAY_FOR_AUT_NEG		(3)	/* 3 us delay max */
#define PHYG_MAX_UDELAY_FOR_EXIT_RESET		(5)	/* 5 us delay */
#define PHYG_MAX_MDELAY_FOR_TO_AUTONEG		(300)	/* 300 ms */
#define PHYG_MAX_MDELAY_FOR_EXIT_RESET		(300)	/* 300 ms */

/* One and two seconds doesn't work.  Three does.  Ten was a very long timeout. */
#define MAX_TIME_TO_WAIT_FOR_LINK		(3 * HZ)	/* seconds */

/* AMIT Requirement, add by hook 20030610
   define lan port number */
#ifdef _MSP2100		
#define LANPORT		2	/* MSP2100 - LAN PORT */
#else		
#define LANPORT		0	/* MSP2000 - LAN PORT */	
#endif		
		
/* 
 * All access to the phy must be through readPhyRegister and writePhyRegister
 * because the PHY_BASE address might be shared by more than one interface
 */
typedef struct PHY_BASE {
	spinlock_t	lock;
	MAC_BASE	*mac_base;
} PHY_BASE;

#define RdPhy(pDrvCtrl,reg) (pDrvCtrl->phy_base->mac_base->reg)
#define WrPhy(pDrvCtrl,reg,value) (pDrvCtrl->phy_base->mac_base->reg=(value))

extern int readPhyRegister(MSP_DEVICE *pDrvCtrl, U32 reg, U32 *variable);
extern int writePhyRegister(MSP_DEVICE *pDrvCtrl, U32 reg, U32 value);
extern void printPhyRegister(MSP_DEVICE *pDrvCtrl, U32 reg);

/* Definitions for Generic MAC PHY */

extern void MSPPHYGSetup(MSP_DEVICE *pDrvCtrl);
extern void MSPPHYGDisplayGenericRegisters (U32 interface);
extern U32 MSPPHYGGetSpeedAndDuplex(MSP_DEVICE *pDrvCtrl);
extern U32 MSPPHYGCheckCable(MSP_DEVICE *pDrvCtrl);
extern U32 MSPPHYGWaitForLink(MSP_DEVICE *pDrvCtrl) ;

