/*
 $Header: /proj/software/pub/CVSROOT/uClinux/linux/drivers/net/phy971.c,v 1.4 2003/01/07 17:36:24 rsewill Exp $
 */

/******************************************************************/
/* Copyright (c) 2002 BRECIS Communications                       */
/*                                                                */
/*     This program is free software; you can redistribute it     */
/*     and/or modify it under the terms of the GNU General        */
/*     Public License as published by the Free Software           */
/*     Foundation; either version 2 of the License, or (at your   */
/*     option) any later version.                                 */
/*                                                                */
/*     This program is distributed in the hope that it will be    */
/*     useful, but WITHOUT ANY WARRANTY; without even the implied */
/*     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR    */
/*     PURPOSE.  See the GNU General Public License for more      */
/*     details.                                                   */
/*                                                                */
/*     You should have received a copy of the GNU General Public  */
/*     License along with this program; if not, write to the Free */
/*     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA     */
/*     02139, USA.                                                */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

#include "brecismspeth.h"
#include "phyethgeneric.h"
#include "phy971.h"

/*************************************************************************
*
* MSPPHY971DisplayRegisters - displays the register of the PHY 971.
*
* RETURNS: OK, or ERROR
*  
**************************************************************************/
void MSPPHY971DisplayRegisters(U32 interfaceNum)
{
	MSP_DEVICE	*pDrvCtrl; 


	if (interfaceNum >= MSP_ETH_MAX_UNITS)
	{
		printk (KERN_INFO "interface %d out of range\n", 
				(int) interfaceNum);
		return;
	}

	pDrvCtrl = gEthDrvCtrl[interfaceNum];

	printk(KERN_INFO "\n---------------------------------------------------\n");
	printk(KERN_INFO "Displaying PHY971 Registers.\n");
	printPhyRegister(pDrvCtrl, PHY971_1000BASE_T_100BASE_T2_CONTROL );
	printPhyRegister(pDrvCtrl, PHY971_1000BASE_T_100BASE_T2_STATUS );
	printPhyRegister(pDrvCtrl, PHY971_EXTENDED_STATUS );
	printPhyRegister(pDrvCtrl, PHY971_PORT_CONFIG );
	printPhyRegister(pDrvCtrl, PHY971_STATUS_REG_TWO );
	printPhyRegister(pDrvCtrl, PHY971_INTERRUPT_ENABLE );
	printPhyRegister(pDrvCtrl, PHY971_INTERRUPT_STATUS );
	printPhyRegister(pDrvCtrl, PHY971_LED_CONFIG );
	printPhyRegister(pDrvCtrl, PHY971_TRANSMIT_CONTROL );
}

/*************************************************************************
*
* MSPPHY971DuplexIntEnable - Enables the Duplex change Interrupt for the PHY 971
*
*
* RETURNS:N/A
*  
**************************************************************************/
void MSPPHY971DuplexIntEnable(MSP_DEVICE *pDrvCtrl)
{
	/* send the data to the PHY */
   	if (writePhyRegister(pDrvCtrl, PHY971_INTERRUPT_ENABLE, 
			     PHY971_INTERRUPT_ENABLE_DUPLEXMSK))
	{
		printk(KERN_INFO "MSPPHY971DuplexIntEnable:  PHY BUSY PHY971_INTERRUPT_ENABLE\n");
		return;
	}
}



/*************************************************************************
*
* MSPPHY971HandleInt - Handles the interrupt from the PHY 971.
*
*
* RETURNS:N/A
*  
**************************************************************************/
U32 MSPPHY971HandleInt(MSP_DEVICE *pDrvCtrl)
{
	U32 data, srdata;

	/*
	 * Read the ISR of the PHY971 to determine the cause of the interrupt.
	 */
	if (readPhyRegister(pDrvCtrl, PHY971_INTERRUPT_STATUS, &data)) 
	{
		printk(KERN_INFO "MSPPHY971HandleInt: PHY971 BUSY\n");
		return MSP_MAC_PHY_ERROR ;
	}	

	/* 
	 * Read status register 2 has status of PHY at this time 
	 */
   	if (readPhyRegister(pDrvCtrl, PHY971_STATUS_REG_TWO, &srdata))
   	{
		printk(KERN_INFO "PHY971 BUSY Getting Status Register 17\n");
		return MSP_MAC_PHY_ERROR ;
   	}

	if (data & PHY971_INTERRUPT_STATUS_LINKCHG)
	{
		if ((srdata & PHY971b_STATUS_REG_TWO_LINK) == 0)
		{
			/* we no longer have a link */
			/* should really mark the interface down */
			return MSP_MAC_PHY_NO_LINK ;
		}
	}

	return MSPPHYGGetSpeedAndDuplex(pDrvCtrl);
}

