 /*
 $Header: /projects/proj/software/pub/CVSROOT/uClinux/linux/drivers/net/brecismspeth.c,v 1.90 2003/05/02 04:56:48 m4 Exp $ 
 */


/******************************************************************
 * Copyright (c) 2002, 2003 BRECIS Communications
 *
 *     This program is free software; you can redistribute it
 *     and/or modify it under the terms of the GNU General
 *     Public License as published by the Free Software
 *     Foundation; either version 2 of the License, or (at your
 *     option) any later version.
 *
 *     This program is distributed in the hope that it will be
 *     useful, but WITHOUT ANY WARRANTY; without even the implied
 *     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *     PURPOSE.  See the GNU General Public License for more
 *     details.
 *
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
 *     02139, USA.
 *
 * BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 *
 */

/***********************************************************************
 *  brecisethmsp.c : BRECIS EVM ethernet driver for linux
 * 
 * Originally based on MSPEthDrv.c et al, which was a complete re-write
 * by Philip Rakity for the Wind River BSP.
 * 
 * Ideas and code were taken from MaTed mated@lineo.ca when he converted
 * the older code to a Linux driver.

      based on mips BRECIS EVM Board driver for wind river BSP
          Written 2001 by Jey K Surier
        & isa-skeleton.c: A network driver outline for linux.
	    Written 1993-94 by Donald Becker.

		Copyright 2002 BRECIS Communication

	Copyright 1993 United States Government as represented by the
	Director, National Security Agency.

	This software may be used and distributed according to the terms
	of the GNU Public License, incorporated herein by reference.

	The author may be reached as becker@CESDIS.gsfc.nasa.gov, or C/O
	Center of Excellence in Space Data and Information Sciences
	   Code 930.5, Goddard Space Flight Center, Greenbelt MD 20771

	Known Limitations:
	- Because the MAC controller is so "intelligent", it manages the
	buffer list on it's own. Therefore you create the Buffer List for
	the controller without knowing the length required. A maximum MTU
	buffer is pre-allocated regardless of the actual requirements. Either
	the controller firmware can be changed to pick buffers whose size
	is closer to the actual size required, or we can memcpy (ugh!!!) to
	a smaller buffer.

*************************************************************************/

/************************************************************************
 * modification history
 * --------------------
 *
 * 09/01/01 P Rakity		Complete re-write of original WindRiver driver.
 * 11/15/01 R Sewill		Port of re-written driver.
 *	- PLEASE set TABS==4
 ************************************************************************/


#include <asm/brecis/prom.h>
#include <asm/brecis/brecisint.h>

#include <asm/bootinfo.h>

#include "brecismspeth.h"
#include "phyethgeneric.h"

#ifdef CONFIG_BRECIS_ETH /* skip the entire file if ethernet not enabled */


#if 0
static const char *version =
"brecismspeth.c:v0.10 02/15/2002 R Sewill (rsewill@brecis.com)\n";
#endif

#define ND struct net_device *
#define RESERVE2

extern char *prom_getenv(char *envname);

int __init	brecis_eth_probe( ND dev);
static int	brecis_eth_probe1( ND dev, int ioaddr, int unit,
				   unsigned char *ptr);

static void	brecis_eth_tx_timeout( ND dev);
static void	brecis_eth_InitVars( ND dev, int ioaddr);
static int	brecis_eth_open( ND dev);
static int	brecis_eth_send_packet( struct sk_buff *skb, ND dev);
static void	brecis_eth_interrupt( int irq, void *dev_id, 
					struct pt_regs *regs);
static int	brecis_eth_close( ND dev);
#if 0
static int	brecis_eth_do_ioctl(ND dev, struct ifreq *rq, int cmd);
#endif
static int	brecis_eth_set_mac_address(ND dev, void *addr);
static struct	net_device_stats	*brecis_eth_get_stats( ND dev);
static void	set_multicast_list( ND dev);
static unsigned int MspEthArcAdd(MSP_DEVICE *pDrvCtrl, unsigned char *pAddr,
				 int swEntryNumber);

static void MSPEthMemoryFree(MSP_DEVICE *pDrvCtrl);

/* #define DEBUGDISPLAYMACREGISTERS */

static void MSPEthPhyInit(MSP_DEVICE *pDrvCtrl);
static void MSPEthPhyInit_complete(MSP_DEVICE *pDrvCtrl);
static void brecis_eth_complete_open(MSP_DEVICE *priv);
static void MSPEthSetDuplex(MSP_DEVICE *pDrvCtrl, U32 duplexMode);
static void MacSetupRegistersTx(MSP_DEVICE *pDrvCtrl);
static void MacSetupRegistersRx(MSP_DEVICE *pDrvCtrl, U32 fdaSize);
static void RXbh(void *data) ;
static void reload_tq(void *data) ;
#ifdef ETHERNETUSESCRATCHRAM
static UINT8 *kmallocSRAM(int size);
static void kfreeSRAM(void *);
#endif
static UINT8 *kmallocBDS(int size);
static void kfreeBDS(void *);
static UINT8 *memalign16(UINT8 *);

static void reloadchecks(unsigned long);
static void reloadcheck_timer(unsigned long);
static DECLARE_TASKLET(mspeth_reloadcheck_task, reloadchecks, 0);
static struct timer_list mspeth_reloadcheck_timer;

static void checkphys(unsigned long);
static void checkphys_timer(unsigned long);
static DECLARE_TASKLET(mspeth_checkphys_task, checkphys, 0);
static void monitor_phy_negotiation(void);
static struct timer_list mspeth_checkphys_timer;

/*
 * The name of the card. Is used for messages and in the requests for
 * io regions, irqs and dma channels
 */
static const char* cardname = "brecismspeth";

MSP_DEVICE	*gEthDrvCtrl[MSP_ETH_MAX_UNITS];

#ifdef DEBUG_RX_TX_STATS
static unsigned int fdaExhausedCounts[MSP_ETH_MAX_UNITS];
static unsigned int blExhausedCounts[MSP_ETH_MAX_UNITS];
#endif


/* #define DEBUGINTCOUNT	(ETH_RX_BD_COUNT+1) */
#ifdef DEBUGINTCOUNT
#define MAX_DEVICES	3
int	rxpackets[MAX_DEVICES][DEBUGINTCOUNT];
int	intcount[MAX_DEVICES];
#endif

/******************************************************
 * Internal brecismspeth data structures
 ******************************************************/
// 2 things to remember - use the KSEG1 address to hardware
//                      - is the ordering of the indices correct
static ULONG  		MacBases[ MSP_ETH_MAX_UNITS + 1]=
  { MAC0_BASE, MAC1_BASE, MAC2_BASE, 0};
static ULONG		MacRSTBases [ MSP_ETH_MAX_UNITS + 1]=
{ MAC0_RST, MAC1_RST, MAC2_RST, 0};
static ULONG 		MacIRQs[ MSP_ETH_MAX_UNITS + 1] = 
  { BRECISINT_MAC0, BRECISINT_MAC1, BRECISINT_MAC2, 0}; 
static PHY_BASE		PhyBases[ MSP_ETH_MAX_UNITS + 1] =
  { {SPIN_LOCK_UNLOCKED, (MAC_BASE *) MAC0_BASE}, 
    {SPIN_LOCK_UNLOCKED, (MAC_BASE *) MAC1_BASE}, 
    {SPIN_LOCK_UNLOCKED, (MAC_BASE *) MAC2_BASE}, 
    {SPIN_LOCK_UNLOCKED, 0}};

static U32 phyAddresses[MSP_ETH_MAX_UNITS];
static int mspeth_inited;

static int gethspeedduplex[MSP_ETH_MAX_UNITS];	/* duplex of eth interface */
static int gethswitch[MSP_ETH_MAX_UNITS];	/* non-zero if eth switch */

static char *		MacName[]
	= {"ethaddr0", "ethaddr1", "ethaddr2", "unknown"};

#ifdef ETHERNETUSESCRATCHRAM
#define SCRATCH_LAST	0	/* must be zero */
#define SCRATCH_FREE	1
#define SCRATCH_INUSE	2

static unsigned long scratchramaddr[MAXSCRATCHRAMPARTITIONS + 1] =
{ SCRATCHRAMADDR, SCRATCHRAMADDR + ETHERNETSCRATCHRAMLEN};

static unsigned long scratchramstate[MAXSCRATCHRAMPARTITIONS + 1] =
{ SCRATCH_FREE, SCRATCH_LAST };
#endif

// #define DEBUGJIFFIEINT
#ifdef DEBUGJIFFIEINT
#define MAXINTSPERJIFFIE	10000
static int debuginterruptcount;
static int debugjiffiecount;
int debugintdev[MAXINTSPERJIFFIE];
int debugintstat[MAXINTSPERJIFFIE];
#endif

/***************************************************************************


 +--------+-----------+---------+---------+
  Byte 3     Byte 2     Byte 1     Byte 0
 +--------+-----------+---------+---------+
            FRAME DESCRIPTOR

+------------------------------------------+
|               FDNext			   | 0x00
+------------------------------------------+
|              FDSystem			   | 0x04
+------------------------------------------+
|               FDStat			   | 0x08	
+------------------+-----------------------+
|   FDCtl          |          FDLength     | 0x0c
+------------------+-----------------------+




            BUFFER DESCRIPTOR
+------------------------------------------+
|    BuffData (pointer to the buffer)      | 0x00
+------------------------------------------+
|              BStatus                     | 0x04
+------------------------------------------+


*****************************************************************************/

static inline void InvalidateFDBD(FDBD *fdbd)
{
#ifdef ETHERNETUSESCRATCHRAM
	if ((unsigned long) fdbd >= SCRATCHRAMADDR &&
	    (unsigned long) fdbd < (SCRATCHRAMADDR + ETHERNETSCRATCHRAMLEN))
	{
		return;
	}
#endif
#if MAX_BD_PER_FRAME == 2
	invalidate_dcache_line((UINT32) fdbd);
	invalidate_dcache_line(((UINT32) fdbd) + L1_CACHE_BYTES);
#else
	InvalidateBuffer(fdbd, sizeof(FDBD));
#endif
}

static inline struct sk_buff *getskb(MSP_DEVICE *pDrvCtrl)
{
	struct sk_buff *skb;

	skb = dev_alloc_skb(MSP_END_BUFSIZE+15);

	if (skb != NULL)
	{
		skb->dev = pDrvCtrl->netdevice;
#ifdef RESERVE2
		/* The symbol RESERVE2 is defined.
		 * The way our hardware works is as follows:
		 * 1) the BlFrmPtr.BuffData pointer must be 32 bit word
		 *    aligned.
		 * 2) We offset the buffer by 2 to get the IP header
		 *    32 bit aligned.
		 * 3) When RESERVE2 is defined, the DMA_CTL register bit
		 *    DMA_CTL_RxAlignSkip2 is defined causes the hardware
		 *    to advance two bytes into the buffer when receiving
		 *    a packet.
		 */
		skb_reserve(skb, 2 + MSP_END_PREPEND);
#endif
	}

	return skb;
}

static inline UCHAR *getRxBuffData(UCHAR *BuffData)
{
	return ((UCHAR *) (((unsigned long) BuffData) & ~0x3));
}

static inline int MACOwnsTxFD(FDBD *fdbd)
{
	InvalidateFDBD(fdbd);

	return ((fdbd->FD.FDCtl & MAC_OWNS_FD) || 
		! (fdbd->FD.FDStat & TX_STAT_Comp));
}

static inline int TxFDInUse(FDBD *fdbd)
{
	return fdbd->FD.FDSystem != 0;
}

static inline int MACOwnsRxFD(FDBD *fdbd)
{
	InvalidateFDBD(fdbd);

	return (fdbd->FD.FDCtl & MAC_OWNS_FD);
}

static inline void setup_delayed_reload(ND dev)
{
	MSP_DEVICE	*priv = dev->priv;

	printk(KERN_ERR "setup_delayed_reload: dev<%x>->name<%s>\n",
		   (unsigned int) dev, dev->name);

	netif_carrier_off(dev);
	netif_stop_queue( dev);
	priv->reloadflag = 1;
}

/*********************************************************************
 *	Function Name:  MacSetupTxBDs
 *
 *  Purpose:		To allocate memory for transmit frame and buffer descriptors
 *                  and set up initial values for these.
 *
 *  Inputs:			interface number: 0 or 1.
 *
 *   Return Value:
 *					MSP_SUCCESS
 *					MSP_MAC_MEM_ALLOC_ERROR
 *
 *********************************************************************/
static U32 MacSetupTxBDs(MSP_DEVICE *pDrvCtrl)
{
	int	i;
	FDBD	*tempFdBd;
	U32	txBdCount = pDrvCtrl->txBdCount;
 
	PRINTK( KERN_INFO "MacSetupTxBDs: Setting up TX Buffer Descriptors\n");
	PRINTK( KERN_INFO "MAC# %d, txBdCount: %d\n", 
		(UINT) pDrvCtrl->unit, (UINT) txBdCount);
    
	/*
	 * Set up the TXQ. The TXQ will have MAX_BD_PER_FRAME BDs hanging off 
	 * of each FD. There will be txBdCount of FDBD. 
	 * But to make sure 16 byte aligned for each FD, the MAX_BD_PER_FRAME 
	 * should be even number.
	 * Allocate memory for transmit frame and  buffer descriptors.
	 */
	if(!(pDrvCtrl->TxFrmPtr_Orig = kmallocBDS(txBdCount * sizeof(FDBD)))) 
	{ 
		printk( KERN_INFO "MacSetupTxBDs: ERROR Can't allocate memory for TxQ!!");
		return MSP_MAC_MEM_ALLOC_ERROR ;
	}

	pDrvCtrl->TxFrmPtr = (FDBD *) memalign16(pDrvCtrl->TxFrmPtr_Orig);

	memset(pDrvCtrl->TxFrmPtr, 0, txBdCount * sizeof(FDBD));

	tempFdBd = pDrvCtrl->TxFrmPtr;
 
	for(i = 0; i < txBdCount; i++) 
	{  
		FDBD	*temp;

		tempFdBd->FD.FDCtl	= BD_PER_TX_FRAME;
		temp			= tempFdBd;
		temp++;
		tempFdBd->FD.FDNext	= &(temp->FD);
		tempFdBd		= temp;
	}	
		
	/* Set the FDNext in the last FD, to point to the first.*/
	tempFdBd--;
	tempFdBd->FD.FDNext		= &(pDrvCtrl->TxFrmPtr->FD); 


	/* Set the TxFrmPtrCur to the base of the TXQ. */
	pDrvCtrl->TxFrmPtrCur		= pDrvCtrl->TxFrmPtr;
	pDrvCtrl->TxFrmPtrFreeBuf	= pDrvCtrl->TxFrmPtr;

	PRINTK( KERN_INFO "\nTxFrmPtr[%d]: 0x%x\n",
			(UINT) pDrvCtrl->unit, (UINT) pDrvCtrl->TxFrmPtr);
	PRINTK( KERN_INFO "TxFrmPtrCur[%d]: 0x%x\n", 
			(UINT) pDrvCtrl->unit, (UINT)
			pDrvCtrl->TxFrmPtrCur);

	return MSP_SUCCESS ;
}


/****************************************************************************
 *	Function Name:	MacSetupRxBDs                              
 *                                                                          
 *  Purpose:        Prepare memory for receive buffers and frame descriptors
 *                  and buffer descriptors.                                
 *                                                                         
 *  Inputs:			
 *			rxBdCount	 - Receive Buffer Descriptor Count. In the first version 
 *					   of the driver, each BD points to one Rx Buffer, 
 *					   hence rxBdCount is equal to the receive buffer count.
 *			rxBuffCount	 - Receive Buffer Count.
 *
 *	Return Value:
 *			MSP_SUCCESS
 *			MSP_MAC_MEM_ALLOC_ERROR
 *
 *****************************************************************************/
static U32 MacSetupRxBDs(MSP_DEVICE *pDrvCtrl) 
{
	int		i;
	U32		fdaSize;
	U32		blSize;
	U32		fdaCount;	
	FD		*tempFd;
	struct sk_buff	*skb;

	PRINTK(KERN_INFO "MacSetupRxBDs: Setting up Rx Buffers and Descriptors\n");
	PRINTK( KERN_INFO "MAC# %d, rxBdCount: %d\n", 
		(UINT) pDrvCtrl->unit, (UINT) pDrvCtrl->rxBdCount);

	/*
	 * Buffer List: (which conisits of single FD and multiple BDs)
	 * There will be rxBdCount counts of BDs, and each BD points to one 
	 * RecBuffSpace of size of MAX_BUFF_SIZE.
	 *
	 */
	blSize = pDrvCtrl->rxBdCount*sizeof(BD) + sizeof(FD);
	if(!(pDrvCtrl->BLFrmPtr_Orig = kmallocBDS(blSize) ))
	{ 
		printk(KERN_WARNING "MacSetupRxBDs: ERROR Can't allocate memory for BL !!\n");
		return(MSP_MAC_MEM_ALLOC_ERROR);
	}
	
	pDrvCtrl->BLFrmPtr = (BLFDBD *) memalign16(pDrvCtrl->BLFrmPtr_Orig);

	memset(pDrvCtrl->BLFrmPtr, 0, blSize);

	/*
	 * Allocate memory for (FDA)descriptors for received buffers.
	 * For each frame received, one FD+BD will be written in the FDA if the
	 * rx buffer that is pointed by the BD could fit the entire packet.
	 * The maximum space need in the free area is 1FD + 1BD rounded by to 
	 * a multiple of the FD size.  So, since 2BD's == 1FD, the minimum
	 * size a good receive packet will take is 2 FD's worth of space.
	 *
	 *
	 * WARNING ==  It is important that FdaCount NOT exceed the buffer
	 * limit number for rx buffers.  Eg.. we have an FDA Exhausted
	 * interrupt and NOT a BLExhausted Interrupt... 
	 */
	fdaCount = 2 * pDrvCtrl->rxBdCount;
	fdaSize = fdaCount * sizeof(FD);
	if(!(pDrvCtrl->FDAPtr_Orig = kmallocBDS(fdaSize) ))
	{ 
		printk(KERN_WARNING "MacSetupRxBDs: ERROR Can't allocate memory for FDA !!");
		return(MSP_MAC_MEM_ALLOC_ERROR);
	}

	pDrvCtrl->rskbp = 
		kmalloc(sizeof(struct sk_buff *) * pDrvCtrl->rxBdCount,
			GFP_KERNEL);

	if (pDrvCtrl->rskbp == NULL)
	{
		printk(KERN_WARNING "MacSetupRxBDs: ERROR Can't allocate memory for rskbp !!");
		return(MSP_MAC_MEM_ALLOC_ERROR);
	}

	pDrvCtrl->FDAPtr = (FDBD *) memalign16(pDrvCtrl->FDAPtr_Orig);

	memset(pDrvCtrl->FDAPtr, 0, fdaSize);

	pDrvCtrl->FDAPtrCur = pDrvCtrl->FDAPtr;

	/*
	 * Initialize the FDA Area. Give the ownership of each 16 byte block
	 * to the controller. (The patterns of  0xBBBBBBBB etc is for debugging only!)
	 */
	tempFd = &(pDrvCtrl->FDAPtr->FD);
	for(i = 0; i < fdaCount; i++)
	{
		tempFd->FDSystem = 0xBBBBBBBB;
		tempFd->FDStat   = 0xCCCCCCCC;
		tempFd->FDCtl    = MAC_OWNS_FD;
		tempFd->FDLength = 0xEEEE;
		tempFd->FDNext   = &tempFd[1];
		tempFd++;
	}
	
	/* last FD points to first */
	tempFd--;
	tempFd->FDNext   = &(pDrvCtrl->FDAPtr->FD);


	/*
	 * Initialize the BL Area. We have only one FD with rxBdCount BDs here,
	 * so point to self as FDNext
	 */
	pDrvCtrl->BLFrmPtr->FD.FDNext	 = &(pDrvCtrl->BLFrmPtr->FD);
	pDrvCtrl->BLFrmPtr->FD.FDSystem	 = 0xAAAAAAAA;	/* debugging  */
	
	/*
	 * Set the number of BDs in the FDLength field of BLFrmPtr 
	 * according to the spec.
	 *
	 * Controller owns the FD, BDCount left blank as the controller
	 * uses FDLength to show the number of BDs available in the Buffer
	 * List queue, but FDLength is set to rxBdCount buffer descriptors 
	 */
	pDrvCtrl->BLFrmPtr->FD.FDCtl	 = MAC_OWNS_FD;
	pDrvCtrl->BLFrmPtr->FD.FDLength  = pDrvCtrl->rxBdCount;	


	/*
	 * Each BD points to a large enough buffer so that for each 
	 * incoming packet
	 * only one BD per packet will be used. So, the number of BD should be 
	 * the same as number of the receive buffers which is rxBuffCount
	 *
	 */
	for(i = 0; i < pDrvCtrl->rxBdCount; i++) 
	{
		unsigned long	intlock;

		save_and_cli(intlock);
		
		/* Get a Buffer and attach to the BD.*/
		skb = getskb(pDrvCtrl);

		restore_flags(intlock);

		if (skb == NULL)
		{
			printk(KERN_INFO "MacSetupRxBDs: skb NULL for MAC%d, on Cnt=%d\n", 
				   (UINT) pDrvCtrl->unit, i);
			return MSP_MAC_MEM_ALLOC_ERROR;
		}

		pDrvCtrl->rskbp[i] = skb;
			
		/* place index of sk_buff structure in BDStat */

		pDrvCtrl->BLFrmPtr->BD[i].BuffData = getRxBuffData(skb->data);
		pDrvCtrl->BLFrmPtr->BD[i].BDCtl	= MAC_OWNS_BD;
		pDrvCtrl->BLFrmPtr->BD[i].BDStat = i;
		pDrvCtrl->BLFrmPtr->BD[i].BuffLength = MSP_END_BUFSIZE;
	}

#ifdef DEBUGPRINTK
	{
		unsigned int *ptr = (unsigned int *) pDrvCtrl->BLFrmPtr;

		PRINTK (KERN_INFO "BLFrmPtr[%d] %x, %08x, %08x, %08x, %08x\n", 
			(UINT) pDrvCtrl->unit, (UINT) ptr,
			ptr[0], ptr[1], ptr[2], ptr[3]);

		ptr = (unsigned int *) &pDrvCtrl->BLFrmPtr->BD[0];

		PRINTK (KERN_INFO "BLFrmPtr[%d]->BD[0] = %08X, %08x, %08x\n", 
			(UINT) pDrvCtrl->unit, 
			(UINT) ptr, ptr[0], ptr[1]);

		ptr = (unsigned int *) &pDrvCtrl->BLFrmPtr->BD[1];

		PRINTK (KERN_INFO "BLFrmPtr[%d]->BD[1] = %08X, %08x, %08x\n", 
			(UINT) pDrvCtrl->unit, 
			(UINT) ptr, ptr[0], ptr[1]);

		i--;

		ptr = (unsigned int *) &pDrvCtrl->BLFrmPtr->BD[i];

		PRINTK (KERN_INFO "BLFrmPtr[%d]->BD[%d] = %08X, %08x, %08x\n", 
			(UINT) pDrvCtrl->unit, i, 
			(UINT) ptr, ptr[0], ptr[1]);
	}
#endif
	MacSetupRegistersRx(pDrvCtrl, fdaSize);
#ifdef DEBUGPRINTK
	{
		unsigned int *ptr = (unsigned int *) pDrvCtrl->FDAPtrCur;

		PRINTK(KERN_INFO "FDAPtrCur[%d] %x, %08x, %08x, %08x %08x\n", 
		       (UINT) pDrvCtrl->unit, (UINT) ptr,
		       ptr[0], ptr[1], ptr[2], ptr[3]);

		PRINTK(KERN_INFO "     %08x, %08x, %08x, %08x\n",
		       ptr[4], ptr[5], ptr[6], ptr[7]);

		ptr = (unsigned int *) tempFd;

		PRINTK(KERN_INFO "tempFd[%d] %x, %08x, %08x, %08x %08x\n", 
		       (UINT) fdaCount - 1, (UINT) ptr,
		       ptr[0], ptr[1], ptr[2], ptr[3]);

		PRINTK(KERN_INFO "     %08x, %08x, %08x, %08x\n",
		       ptr[4], ptr[5], ptr[6], ptr[7]);
	}
#endif
	return(MSP_SUCCESS);
}

/*************************************************************************
*
* MSPEthFreeTxBuffs -	This function looks for any tranmit completed
*			Descriptors and frees up the buffer associated
*			with them.
*
* RETURNS: N/A.
***************************************************************************/
static void MSPEthFreeTxBuffsInternal(MSP_DEVICE *priv)
{
	FDBD		*fdbd;	
	unsigned long	flags;
	struct sk_buff	*skb;
	UINT32		status;		
	int		wakequeue = 0;
	
	spin_lock_irqsave( &priv->lock, flags);

	/* 
	 * If the FDStat field is non-zero, then it indicates a transmission. 
	 * Go and find all such FDs and frees up the buffers that have been 
	 * already transmitted.
	 */
	/* Free up the Tx Buffers */
	do
	{
		fdbd = priv->TxFrmPtrFreeBuf;

		priv->TxFrmPtrFreeBuf = (FDBD *) fdbd->FD.FDNext;

		skb = (struct sk_buff *) fdbd->FD.FDSystem;

		/*
		 * gather statistics
		 */
		status = fdbd->FD.FDStat;

#if 0
		PRINTK(KERN_INFO "Freeing %x skb %x buf %x len %x status %x\n",
		       (unsigned int) fdbd, (unsigned int) skb,
		       (unsigned int) skb->data, skb->len, 
		       (unsigned int) status);
#endif

		if (status & TX_STAT_ANYERROR)
		{
			priv->stats.tx_errors++;

			// now log specific error
			if ( status & (TX_EX_COLL + TX_LATE_COLL))
				priv->stats.collisions++;

			if ( status & (TX_DEFER + TX_PAUSED + TX_EXDEFER +TX_HALTED))
				priv->stats.tx_aborted_errors++;

			if ( status & (TX_DEFER + TX_EXDEFER))
				priv->stats.tx_aborted_errors++;
			
			if ( status & TX_EXDEFER)
				priv->stats.tx_carrier_errors++;

			if ( status & (TX_PARITY + TX_UNDER))	// Underrun is here??
				priv->stats.tx_fifo_errors++;

			if ( status & TX_SQERR)
				priv->stats.tx_heartbeat_errors++;
			
#if 0	// there are circumstances when the  transmitter has to be restarted
			/*	if ( status & (TX_PARITY + ???))
				// restart transmitter */
#endif
		}
		else
		{
			priv->stats.tx_bytes += skb->len;	// total bytes transmitted
			priv->stats.tx_packets++;		// total packets transmitted
		}

		/*
		 * Free up the Transmit Buffers. 
		 */
		fdbd->FD.FDStat = 0;
		fdbd->FD.FDSystem = 0;
		dev_kfree_skb_any(skb);
		wakequeue = 1;
	} while (! MACOwnsTxFD(priv->TxFrmPtrFreeBuf));

	if (wakequeue  > 0 && netif_queue_stopped(priv->netdevice))
	{
		/* 
		 * We freed a packet, let non-interrupt processing 
		 * free TX packets
		 */
		MSPEthTxIntDisable(priv);
		priv->netdevice->trans_start = jiffies;
		netif_wake_queue(priv->netdevice);
	}

	spin_unlock_irqrestore( &priv->lock, flags);
}

static inline void MSPEthFreeTxBuffs(MSP_DEVICE *priv)
{
    if (TxFDInUse(priv->TxFrmPtrFreeBuf) && 
	! MACOwnsTxFD(priv->TxFrmPtrFreeBuf))
    {
	    MSPEthFreeTxBuffsInternal(priv);
    }
}


/**********************************************************************
 * Function Name:	MSPEthMemoryFree
 *
 *   Purpose:       Stop transmission and reception and free memory 
 *					that was used for buffers.
 *   
 *   Parameters:	None
 *
 *   Return Value:	None    
 *
 ***********************************************************************/
static void MSPEthMemoryFree(MSP_DEVICE *pDrvCtrl) 
{
	U32 Counter;
	unsigned long	flags;

	save_and_cli(flags) ;

	/* prevent 1 second timer from accessing this structure */

	gEthDrvCtrl[pDrvCtrl->unit] = NULL;

	/* prevent any calls from rest of kernel getting in.
	   Every routine that could be called must check priv != NULL */

	pDrvCtrl->netdevice->priv = NULL;

	/* remove RX bottom half from from being scheduled if necessary */

	if (TQ_ACTIVE(pDrvCtrl->rx_bh.list))
	{
		
		list_del(&pDrvCtrl->rx_bh.list);
		pDrvCtrl->rx_bh.sync = 0;
	}

	/* remove reload task from from being scheduled if necessary */

	if (TQ_ACTIVE(pDrvCtrl->reload_tq.list))
	{
		list_del(&pDrvCtrl->reload_tq.list);
		pDrvCtrl->reload_tq.sync = 0;
	}

	/* stop interrupts and disable rx and tx */

	MSPEthIntDisable(pDrvCtrl);

	MSPEthEnableTxHalt(pDrvCtrl);
	MSPEthDisableRx(pDrvCtrl);

	restore_flags(flags) ;

	/* Free up the Rx Buffers */

	if (pDrvCtrl->rskbp != NULL) 
	{
		for(Counter = 0; Counter < pDrvCtrl->rxBdCount; Counter++) 
		{
			if (pDrvCtrl->rskbp[Counter] != NULL)
			{
				dev_kfree_skb(pDrvCtrl->rskbp[Counter]);
			}
		}
		kfree(pDrvCtrl->rskbp);
	}

	/* mark all tx descriptors not in use so we can free them */

	if (pDrvCtrl->TxFrmPtr != NULL)
	{
		FDBD	*fdbd;

		fdbd = pDrvCtrl->TxFrmPtr;

		do {
			if (TxFDInUse(fdbd) && MACOwnsTxFD(fdbd))
			{
				/* force packet owned by us */

				fdbd->FD.FDCtl &= ~MAC_OWNS_FD;
				fdbd->FD.FDStat |= TX_STAT_Comp;
			}

			fdbd = (FDBD *) fdbd->FD.FDNext;

		} while (pDrvCtrl->TxFrmPtr != fdbd);

		MSPEthFreeTxBuffs(pDrvCtrl);
	}

	if(pDrvCtrl->BLFrmPtr_Orig)
		kfreeBDS(pDrvCtrl->BLFrmPtr_Orig);

	if(pDrvCtrl->FDAPtr_Orig)
		kfreeBDS(pDrvCtrl->FDAPtr_Orig);

	if(pDrvCtrl->TxFrmPtr_Orig)
		kfreeBDS(pDrvCtrl->TxFrmPtr_Orig);

#ifndef CONFIG_BRECIS_ENET_SCRATCH
	kfree(pDrvCtrl);
#endif	/* !CONFIG_BRECIS_ENET_SCRATCH */
}


#if 0
static void MSPEthDisplayPhyInfo(U32 interfaceNum)
{
	MSP_DEVICE *pDrvCtrl;

	if (interfaceNum >= MSP_ETH_MAX_UNITS || gEthDrvCtrl[interfaceNum] == NULL)
	{
		printk ( KERN_WARNING "Interface %d out of range\n", 
			 (UINT) interfaceNum);
		return;
	}
	
	pDrvCtrl = gEthDrvCtrl[interfaceNum];
	
	switch (pDrvCtrl->phyType)
	{
	case PHYTYPE_INTEL971a:
		printk ( KERN_INFO "Phy is %s\n", PHY_INTEL971a);
		break;
	case PHYTYPE_KENDINSWITCH:
		printk ( KERN_INFO "Phy is %s\n", PHY_KENDINSWITCH);
		break;
	case PHYTYPE_KENDIN_8721:
		printk ( KERN_INFO "Phy is %s\n", PHY_KENDIN_8721);
		break;
	case PHYTYPE_GENERIC:
		printk ( KERN_INFO "Phy is %s\n", PHY_GENERIC);
		break;
	case PHYTYPE_NONE:
		printk ( KERN_INFO "Phy is %s\n", PHY_NONE);
		break;
	}

	switch (pDrvCtrl->ethMode)
	{
	case ETH_AUTO:
		printk( KERN_INFO "Phy is set to AUTO NEGOTIATION\n");
		printk ( KERN_INFO "Current Speed is %s\n", 
			(pDrvCtrl->speed == MSPEth_10MBS ? "10Mbps" : "100Mbps"));
		printk ( KERN_INFO "Current Duplex is %s\n", 
			(pDrvCtrl->duplexMode == MAC_DPX_MODE_HALF ? "Half" : "Full"));
		break;
	case ETH_10Mbps_HALF:
		printk( KERN_INFO "Phy is set to 10 Mbps - Half Duplex\n");
		break;
	case ETH_10Mbps_FULL:
		printk( KERN_INFO "Phy is set to 10 Mbps - Full Duplex\n");
		break;
	case ETH_100Mbps_HALF:
		printk( KERN_INFO "Phy is set to 100 Mbps - Half Duplex\n");
		break;
	case ETH_100Mbps_FULL:
		printk( KERN_INFO "Phy is set to 100 Mbps - Full Duplex\n");
		break;
	}
}

static void MSPEthDisplayConfigInfo(U32 interfaceNum)
{
	MSP_DEVICE *pDrvCtrl;

	if (interfaceNum >= MSP_ETH_MAX_UNITS || gEthDrvCtrl[interfaceNum] == NULL)
	{
		printk ( KERN_WARNING "Interface %d out of range\n", 
			 (UINT) interfaceNum);
		return;
	}
	
	pDrvCtrl = gEthDrvCtrl[interfaceNum];

    printk( KERN_INFO "\nReading MAC Registers for MAC #  %d", 
	    (UINT) interfaceNum);		

	printk( KERN_INFO "\n\n");
	printk( KERN_INFO "------------------------------------------------\n");
	printk( KERN_INFO "Configuration Information for MAC: %d\n", 
		(UINT) interfaceNum);
	printk( KERN_INFO "rxBdCount       = %d\n", pDrvCtrl->rxBdCount);
	printk( KERN_INFO "txBdCount       = %d\n", pDrvCtrl->txBdCount);
	printk( KERN_INFO "FDAPtr          = 0x%x\n", 
		(UINT) pDrvCtrl->FDAPtr);
	printk( KERN_INFO "FDAPtrCur       = 0x%x\n", 
		(UINT) pDrvCtrl->FDAPtrCur);
	printk( KERN_INFO "BLFrmPtr        = 0x%x\n", 
		(UINT) pDrvCtrl->BLFrmPtr);
	printk( KERN_INFO "TxFrmPtr        = 0x%x\n", 
		(UINT) pDrvCtrl->TxFrmPtr);
	printk( KERN_INFO "TxFrmPtrCur     = 0x%x\n", 
		(UINT) pDrvCtrl->TxFrmPtrCur);
	printk( KERN_INFO "TxFrmPtrFreeBuf = 0x%x\n", 
		(UINT) pDrvCtrl->TxFrmPtrFreeBuf);
	printk ( KERN_INFO "\nVLAN Information\n");
	printk ( KERN_INFO "----------------\n");

	printk( KERN_INFO "-------------------------------------------------\n");
}

#endif
#if 0

static void MSPEthDisplayEthTxRxDescriptors(U32 interfaceNum)
{
	MSP_DEVICE *pDrvCtrl;

	if (interfaceNum >= MSP_ETH_MAX_UNITS || gEthDrvCtrl[interfaceNum] == NULL)
	{
		printk ( KERN_WARNING "Interface %d out of range\n", 
			 (UINT) interfaceNum);
		return;
	}

	pDrvCtrl = gEthDrvCtrl[interfaceNum];

	printk( KERN_INFO "\n\n");
	printk( KERN_INFO "-----------------------------------------------\n");
	printk( KERN_INFO "Tx, Rx Descriptor Info for MAC: %d\n", 
		(UINT) interfaceNum);
	printk( KERN_INFO "FDAPtr[%d]          = 0x%08X\n", 
		(UINT) interfaceNum, (UINT) pDrvCtrl->FDAPtr);
	printk( KERN_INFO "FDAPtrCur[%d]       = 0x%08X\n", 
		(UINT) interfaceNum, (UINT) pDrvCtrl->FDAPtrCur);
	printk( KERN_INFO "BLFrmPtr[%d]        = 0x%08X\n", 
		(UINT) interfaceNum, (UINT) pDrvCtrl->BLFrmPtr);
	printk( KERN_INFO "TxFrmPtr[%d]        = 0x%08X\n", 
		(UINT) interfaceNum, (UINT) pDrvCtrl->TxFrmPtr);
	printk( KERN_INFO "TxFrmPtrCur[%d]     = 0x%08X\n", 
		(UINT) interfaceNum, (UINT) pDrvCtrl->TxFrmPtrCur);
	printk( KERN_INFO "TxFrmPtrFreeBuf[%d] = 0x%08X\n", 
		(UINT) interfaceNum, (UINT)pDrvCtrl->TxFrmPtrFreeBuf);

	printk( KERN_INFO "-----------------------------------------------\n");
}
#endif

#define DMA_BURST_5000_SIZE	(64)
#define DMA_BURST_4000_SIZE	(128)
#ifdef RESERVE2
#define DMA_SET_NORMAL \
	(DMA_CTL_M66EnStat | \
	 DMA_CTL_RxBigE | \
	 DMA_CTL_TxBigE | \
	 DMA_CTL_RxAlignSkip2)
#else
#define DMA_SET_NORMAL \
	(DMA_CTL_M66EnStat | \
	 DMA_CTL_RxBigE | \
	 DMA_CTL_TxBigE)
#endif

#define DMA_SET_TEST	(DMA_SET_NORMAL | DMA_CTL_TestMode)

static void MacSetupRegistersTx(MSP_DEVICE *pDrvCtrl)
{
#if 1
		WriteMacRegister(pDrvCtrl, DMA_CTL,  
				 DMA_SET_NORMAL | 64);
#else
	if (identify_family() != FAMILY_TRIAD &&
	    (identify_family() != FAMILY_FPGA || 
	     ! FPGA_IS_5000(identify_revision())))
		WriteMacRegister(pDrvCtrl, DMA_CTL,  
				 DMA_SET_NORMAL | DMA_BURST_4000_SIZE);
	else
		WriteMacRegister(pDrvCtrl, DMA_CTL,  
				 DMA_SET_NORMAL | DMA_BURST_5000_SIZE);
#endif

	WriteMacRegister(pDrvCtrl, MAC_CTL,  0x00000000);  
#if 0
	WriteMacRegister(pDrvCtrl, TXTHRSH,  0x00000200); 
#else
	WriteMacRegister(pDrvCtrl, TXTHRSH,  0x000005EA); 
#endif
/*	WriteMacRegister(pDrvCtrl, TXTHRSH,  0x00000040); */
	WriteMacRegister(pDrvCtrl, TXPOLLCTR,0x0000FFFF);
	WriteMacRegister(pDrvCtrl, TX_CTL,   0x00000000);	/* Turn off Tx */
}

static void MacSetupRegistersRx(MSP_DEVICE *pDrvCtrl, U32 fdaSize)
{
	PRINTK( KERN_INFO "FDASize = %d, FDAPTR %x, FDA_LIM %d, BLFRMPTR %x\n",
		(int) fdaSize, 
		(unsigned int) pDrvCtrl->FDAPtr,
		(int) fdaSize - 32*sizeof(BD),
		(unsigned int) pDrvCtrl->BLFrmPtr);

	WriteMacRegister(pDrvCtrl, FDA_BAS, (U32) pDrvCtrl->FDAPtr); 

	/* Leave Room for 1 FD and 30 BD's */
	WriteMacRegister(pDrvCtrl, FDA_LIM, (fdaSize - 32*sizeof(BD)));  

	WriteMacRegister(pDrvCtrl, RXFRAGSIZE, 0x00); 

	WriteMacRegister(pDrvCtrl, ARC_CTL, ARC_NegARC); /* promiscuous on*/
	WriteMacRegister(pDrvCtrl, ARC_ENA, 0x00);  /* Disable ARC Entries */

	WriteMacRegister(pDrvCtrl, BLFRMPTR, (U32)pDrvCtrl->BLFrmPtr); 
	WriteMacRegister(pDrvCtrl, RX_CTL, 0x00000000);	/* Turn off Rx */
}

static int getEthUnit(struct net_device *dev)
{
	int		unit;
	
	/* 
	 * All our devices are eth%d devices (please see space.c).
	 * Get the unit number from the %d as our unit number.
	 */
	if (strncmp("eth", dev->name, strlen("eth")) != 0)
		return -1;		/* not eth%d device */

	if (sscanf(&dev->name[strlen("eth")], "%d", &unit) != 1)
		return -1;

	if (unit < 0 || unit >= MSP_ETH_MAX_UNITS)
		return -1;

	return unit;
}

int compute_hwunit(int unit)
{
	int logicalunit = 0;
	int hwunit;
	int noexist = MSP_ETH_MAX_UNITS;

	for (hwunit = 0; hwunit < MSP_ETH_MAX_UNITS; hwunit++)
	{
		if (identify_enet(hwunit) != FEATURE_NOEXIST)
		{
			if (logicalunit++ == unit)
				return hwunit;
		}
		else
			noexist = hwunit;
	}
	return noexist;
}

#ifdef	CONFIG_BRECIS_ENET_SCRATCH
MSP_DEVICE	DrvCtrl[MSP_ETH_MAX_UNITS] __fast = { {0} };
#endif	/* CONFIG_BRECIS_ENET_SCRATCH */

static U32 MSPEthSetup(struct net_device *dev)
{
	int		ethspeedduplex;
	int		ethswitch;
	int		unit;
	int		hwunit;
	MSP_DEVICE	*pDrvCtrl;

	/* Free any old MSP_DEVICE structure */

	pDrvCtrl = dev->priv;

	if (pDrvCtrl != NULL)
	{
		MSPEthReset(pDrvCtrl);
		MSPEthMemoryFree(pDrvCtrl);
	}

	unit = getEthUnit(dev);
	if (unit < 0 || gEthDrvCtrl[unit] != NULL || unit >= MSP_ETH_MAX_UNITS)
	{
		printk (KERN_ERR "MSPEthSetup: Bad Unit number or already in use\n");
		return MSP_FAIL;
	}

	/* Create new MSP_DEVICE structure */
#ifdef	CONFIG_BRECIS_ENET_SCRATCH
    dev->priv = &DrvCtrl[unit];
#else
    dev->priv = kmalloc(sizeof(MSP_DEVICE), GFP_KERNEL);
#endif	/* CONFIG_BRECIS_ENET_SCRATCH */

    if (dev->priv == NULL) {
		printk (KERN_ERR "MSPEthSetup: MEM ERROR : kmalloc returned NULL\n");
		return MSP_FAIL;
    }

    memset(dev->priv, 0, sizeof(MSP_DEVICE));

    pDrvCtrl = dev->priv;
    pDrvCtrl->netdevice = dev;
    INIT_TQUEUE(&pDrvCtrl->rx_bh, RXbh, pDrvCtrl);
    INIT_TQUEUE(&pDrvCtrl->reload_tq, reload_tq, dev);

#ifdef ETHERNETUSESCRATCHRAM
    if (identify_spad() == FEATURE_NOEXIST)
    {
	    pDrvCtrl->txBdCount	= ETH_TX_BD_COUNT;
	    pDrvCtrl->rxBdCount	= ETH_RX_BD_COUNT;
    }
    else
    {
	    pDrvCtrl->txBdCount	= ETH_TX_BD_COUNT_SPAD;
	    pDrvCtrl->rxBdCount	= ETH_RX_BD_COUNT_SPAD;
    }
#else
    pDrvCtrl->txBdCount	= ETH_TX_BD_COUNT;
    pDrvCtrl->rxBdCount	= ETH_RX_BD_COUNT;
#endif
    hwunit = compute_hwunit(unit);
    pDrvCtrl->enetType = identify_enet(hwunit);
    pDrvCtrl->enetTxD = identify_enetTxD(hwunit);

    pDrvCtrl->unit = unit;

    pDrvCtrl->mac_base = (MAC_BASE *) MacBases[hwunit];

    pDrvCtrl->phy_base = &PhyBases[phyAddresses[hwunit] >> 16];

    if (hwunit == 2)
    {
		switch (identify_family())
		{
		case FAMILY_POLO:
		case FAMILY_ZEUS:
			/* if Polo or Zeus, set GPIO bit to enable MAC 2 */
			*GPIO_CFG7_REG |= POLO_MAC2_ENABLE;
			break;

		default:
			break;
		}
    }

    pDrvCtrl->rst_base = MacRSTBases[hwunit];

    ethspeedduplex = gethspeedduplex[unit];
    ethswitch = gethswitch[unit];

	// add by hook 20030609 
	// for eth2 setting fixed mod as 100fullduplex
#ifdef _MSP2100
	if (unit == LANPORT)
    	ethspeedduplex = 200;
#endif	
	//end of add by hook

    switch (ethspeedduplex)
    {
    case 10:
	    pDrvCtrl->ethMode = ETH_10Mbps_HALF;
	    pDrvCtrl->speed = MSPEth_10MBS;
	    pDrvCtrl->duplexMode = MAC_DPX_MODE_HALF;
	    break;
    case 20:
	    pDrvCtrl->ethMode = ETH_10Mbps_FULL;
	    pDrvCtrl->speed = MSPEth_10MBS;
	    pDrvCtrl->duplexMode = MAC_DPX_MODE_FULL;
	    break;
    case 100:
	    pDrvCtrl->ethMode = ETH_100Mbps_HALF;
	    pDrvCtrl->speed = MSPEth_100MBS;
	    pDrvCtrl->duplexMode = MAC_DPX_MODE_HALF;
	    break;
    case 200:
	    pDrvCtrl->ethMode = ETH_100Mbps_FULL;
	    pDrvCtrl->speed = MSPEth_100MBS;
	    pDrvCtrl->duplexMode = MAC_DPX_MODE_FULL;
	    break;
    case -1:
    default:
	    pDrvCtrl->ethMode = ETH_AUTO;
    }

// add ifdef by hook 20030611	
#ifdef _MSP2100
	if (ethswitch)
	    pDrvCtrl->phyType = PHYTYPE_NONE;
    else
	    pDrvCtrl->phyType = PHYTYPE_GENERIC;
#else
	if(unit == 0)
        pDrvCtrl->phyType = PHYTYPE_KENDINSWITCH;
    else
        pDrvCtrl->phyType = PHYTYPE_KENDIN_8721;
#endif

    gEthDrvCtrl[unit] = pDrvCtrl;

	// add by hook
    /* printk(KERN_INFO "eth%d, hwunit %d, mac_base %x\n", 
	   unit, hwunit, (unsigned int) pDrvCtrl->mac_base);*/

    MSPEthReset(pDrvCtrl);

    MSPEthIntDisable(pDrvCtrl);

    if (MacSetupTxBDs(pDrvCtrl) != MSP_SUCCESS)
    {
	    MSPEthMemoryFree(pDrvCtrl);
	    return MSP_FAIL;
    }

    if (MacSetupRxBDs(pDrvCtrl) != MSP_SUCCESS)
    {
	    MSPEthMemoryFree(pDrvCtrl);
	    return MSP_FAIL;
    }

    MacSetupRegistersTx(pDrvCtrl);
    MacSetUpTxFrmPtrRegister(pDrvCtrl, (U32) pDrvCtrl->TxFrmPtrCur);

#if defined(CONFIG_VLAN_8021Q) || defined(CONFIG_VLAN_8021Q_MODULE)
    MSPEthEnableVLAN(pDrvCtrl);
#endif

    if (mspeth_inited)
	    MSPEthPhyInit(pDrvCtrl);

	// add by hook 20030728- print ethernet macPhyId
   	/* printk(KERN_INFO "eth%d, hwunit %d, macPhyId %x\n", 
			unit, hwunit, (unsigned int) pDrvCtrl->macPhyId);*/

    return MSP_SUCCESS;
}

/*************************************************************************
*
* ethPhyInit - initialize and configure the PHY device.
*
* RETURNS: OK, or ERROR
* Needs to be modified according to the PHY, and 
* also there are two different PHYs connected to MAC 1 and 2.....
* needs to be modified according to the SPEC of Level1 971 and 905.
*  
**************************************************************************/
static void determinePhyAddress(MSP_DEVICE *pDrvCtrl)
{
	U32	j;
	U32	ethIndex;
	U32	hwIndex;
	U32	myPhyAddress;
	U32	phyAddress;
	U32	phyIndex;
	U32	reg1;	

	myPhyAddress = phyAddresses[pDrvCtrl->unit];
	hwIndex = myPhyAddress >> 16;
	phyIndex = myPhyAddress & 0xffff;

	if (phyIndex != MD_DYNAMIC_PHY)
	{
		pDrvCtrl->macPhyId = phyIndex << MD_CA_PhyShift;
		printk("MAC#: %d PHY is statically configured %d:%d\n",
		       pDrvCtrl->unit,
		       (unsigned int) hwIndex, (unsigned int) phyIndex);
		return;
	}
	
	/*
	 * determine PHY address
	 * hwIndex is index for selecting mdc/mdio hardware
	 * phyIndex is phy address index
	 */
	for (phyIndex = 0, ethIndex = 0; phyIndex < MD_MAX_PHY; phyIndex++)
	{
		/* we are testing for the phyAddress hwIndex:phyIndex */
		phyAddress = (hwIndex << 16) | phyIndex;

		for (j = 0; j < MSP_ETH_MAX_UNITS; j++)
			if (phyAddress == phyAddresses[j])
				break;

		/* check for phyAddress under test statically assigned */
		if (j < MSP_ETH_MAX_UNITS)
			continue;	/* already statically assigned */

		pDrvCtrl->macPhyId = phyIndex << MD_CA_PhyShift;

		if (readPhyRegister(pDrvCtrl, PHYG_STATUS_REG_ONE, &reg1))
			continue;			/* No PHY responding */

		if (reg1 != 0 && reg1 != 0xffff && 
		    (reg1 & PHYGb_MEDIAMASK) != 0)
		{
			/* 
			 * We found a PHY we can dynamically assign.
			 * We assign PHYs matching those ethernet interfaces
			 * that take dynamic PHY assignment.  I.e., the first
			 * dynamically assignable PHY goes with the first
			 * ethernet interface that wants a PHY dynamically
			 * assigned on that particular hardware mdc/mdio.
			 * ethIndex is the index for the current ethernet
			 * interface to check for dynamic assignment.
			 * When ethIndex equals pDrvCtrl->unit, we found
			 * our interface.
			 */
			while (phyAddresses[ethIndex] != myPhyAddress)
				ethIndex++;

			if (ethIndex == pDrvCtrl->unit)
				break;	/* we found PHY for our interface */

			/* increment to next possible ethernet interface */
			ethIndex++;
		}
	}

	if (phyIndex == MD_MAX_PHY) 
	{
		printk(KERN_INFO "determinePhyAddress(): no PHY address found, using default\n");
		pDrvCtrl->macPhyId = 0 << MD_CA_PhyShift;
	}
}

static void MSPEthPhyInit(MSP_DEVICE *pDrvCtrl)
{
	switch(pDrvCtrl->phyType)
	{
		case PHYTYPE_NONE:
		case PHYTYPE_KENDINSWITCH:
			MSPEthPhyInit_complete(pDrvCtrl);
			brecis_eth_complete_open(pDrvCtrl);
			break;

		case PHYTYPE_GENERIC:
		case PHYTYPE_KENDIN_8721:
		case PHYTYPE_INTEL971a:
			determinePhyAddress(pDrvCtrl);
#ifndef _MSP2100
			pDrvCtrl->macPhyId = 5 << 5;    // add by hook 2003/04/07
#endif			
			MSPPHYGSetup(pDrvCtrl);
			break;
	}
}

static void MSPEthPhyInit_complete(MSP_DEVICE *pDrvCtrl)
{
	ND	dev = pDrvCtrl->netdevice;
		
	MSPEthSetDuplex(pDrvCtrl, pDrvCtrl->duplexMode);

	switch (pDrvCtrl->enetTxD)
	{
	case ENETTXD_RISING:
		/* Set TxD rising edge - I was told this was best default */

		MSPEthRMIITxDRisingEdge(pDrvCtrl);
		break;

	case ENETTXD_FALLING:
		/* Set TxD falling edge */

		MSPEthRMIITxDFallingEdge(pDrvCtrl);
		break;

	default:
		/* do not touch the TxD bit */
		break;
	}

	
	if (pDrvCtrl->enetType == ENET_RMII)
	{
		/* Set speed of RMII based on PHY setup/negotiation */

		if (pDrvCtrl->speed == MSPEth_10MBS)
			MSPEthRMIIEnable10Mbit(pDrvCtrl);
		else
			MSPEthRMIIEnable100Mbit(pDrvCtrl);
	}

	if (pDrvCtrl->phyType == PHYTYPE_KENDINSWITCH
	||  pDrvCtrl->phyType == PHYTYPE_NONE)
	{
		/* a SWITCH ALWAYS has carrier */
		printk(KERN_INFO "Switch eth%d is set for %d Mbps %s Duplex\n",
		       pDrvCtrl->unit,
		       pDrvCtrl->speed == MSPEth_10MBS ? 10 : 
		       (pDrvCtrl->speed == MSPEth_100MBS ? 100 : 0),
		       pDrvCtrl->duplexMode == MAC_DPX_MODE_HALF ?
		       "Half" : 
		       (pDrvCtrl->duplexMode == MAC_DPX_MODE_FULL ? 
			"Full" : "UNKNOWN"));
		return;
	}

	/*
	 * tell upper layer our carrier status
	 */
	if (MSPPHYGCheckCable(pDrvCtrl) != 0)
	{
		/* if link is up */

		if (! netif_carrier_ok(dev))
		{
			netif_carrier_on(dev);
		}
	}
	else
	{
		/* if link is not up */

		if (netif_carrier_ok(dev))
		{
			netif_carrier_off(dev);
		}
	}
} 

/*************************************************************************
*
* MSPEthSetDuplex - sets the duplex mode on the MAC
*
* NOTE: This function is called after setting the PHY and the
* autonegotiatin is complete on the PHY. Find out the duplex
* mode from the PHY and set it at the MAC to match it.
*
* Input: duplexMode:
*				0 - Half Fuplex
*				1 - Full Duplex
*
*  
**************************************************************************/
static void MSPEthSetDuplex(MSP_DEVICE *pDrvCtrl, U32 duplexMode)
{
	if(duplexMode == MAC_DPX_MODE_HALF)
	{
		printk( KERN_INFO "MSPEthSetDuplex(): Setting MAC# %d for Half Duplex Mode\n", 
			pDrvCtrl->unit);
		WriteMacRegister(pDrvCtrl, MAC_CTL, 
			((ReadMacRegister(pDrvCtrl, MAC_CTL)) & (~MAC_CTL_FullDup)));
	}
	else if(duplexMode == MAC_DPX_MODE_FULL) 
	{
		printk( KERN_INFO "MSPEthSetDuplex(): Setting MAC# %d for Full Duplex Mode\n", 
			pDrvCtrl->unit);
		WriteMacRegister(pDrvCtrl, MAC_CTL, 
			((ReadMacRegister(pDrvCtrl, MAC_CTL)) | MAC_CTL_FullDup));
	}
} 

#ifdef DEBUGDISPLAYMACREGISTERS
static void MSPEthDisplayMacRegisters(U32 interfaceNum)
{
	MSP_DEVICE *pDrvCtrl;

	if (interfaceNum >= MSP_ETH_MAX_UNITS || gEthDrvCtrl[interfaceNum] == NULL)
	{
		printk ( KERN_WARNING "Interface %d out of range\n", 
			 (UINT) interfaceNum);
		return;
	}
	
	pDrvCtrl = gEthDrvCtrl[interfaceNum];
	
	printk( KERN_INFO "Reading MAC Registers for MAC #  %d\n", 
		(UINT) interfaceNum);		
	
	printk( KERN_INFO 
		"Reading MAC Register DMA_CTL      0x00\t 0x%08X\n", 
		(unsigned int) ReadMacRegister(pDrvCtrl,DMA_CTL));
	
	printk( KERN_INFO
		"Reading MAC Register TXTHRSH      0x08\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,TXTHRSH));

	printk( KERN_INFO
		"Reading MAC Register TXPOLLCTR    0x0c\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,TXPOLLCTR));

	printk( KERN_INFO
		"Reading MAC Register BLFRMPTR     0x10\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,BLFRMPTR));

	printk( KERN_INFO 
		"Reading MAC Register RXFRAGSIZE   0x14\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,RXFRAGSIZE));

	printk( KERN_INFO
		"Reading MAC Register INT_EN       0x18\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,INT_EN));
	
	printk( KERN_INFO
		"Reading MAC Register FDA_BAS      0x1c\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,FDA_BAS));

	printk( KERN_INFO
		"Reading MAC Register FDA_LIM      0x20\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,FDA_LIM));

	printk( KERN_INFO
		"Reading MAC Register INT_SRC      0x24\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,INT_SRC));

	printk( KERN_INFO
		"Reading MAC Register PAUSECNT     0x30\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,PAUSECNT));

	printk( KERN_INFO
		"Reading MAC Register REMPAUCNT    0x34\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,REMPAUCNT));

	printk( KERN_INFO
		"Reading MAC Register TXCONFRMSTAT 0x38\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,TXCONFRMSTAT));

	printk( KERN_INFO
		"Reading MAC Register MAC_CTL      0x40\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,MAC_CTL));

	printk( KERN_INFO
		"Reading MAC Register ARC_CTL      0x44\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,ARC_CTL));

	printk( KERN_INFO
		"Reading MAC Register TX_CTL       0x48\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,TX_CTL));

	printk( KERN_INFO
		"Reading MAC Register TX_STAT      0x4c\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,TX_STAT));

	printk( KERN_INFO
		"Reading MAC Register RX_CTL       0x50\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,RX_CTL));

	printk( KERN_INFO
		"Reading MAC Register RX_STAT      0x54\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,RX_STAT));
	
	printk( KERN_INFO 
		"Reading MAC Register MD_DATA      0x58\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,MD_DATA));
	
	printk( KERN_INFO
		"Reading MAC Register MD_CA        0x5c\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,MD_CA));

	printk( KERN_INFO
		"Reading MAC Register ARC_ADR      0x60\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,ARC_ADR));

	printk( KERN_INFO 
		"Reading MAC Register ARC_DATA     0x64\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,ARC_DATA));
	
	printk( KERN_INFO
		"Reading MAC Register ARC_ENA      0x68\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,ARC_ENA));
	
	printk( KERN_INFO
		"Reading MAC Register MISS_CNT     0x7c\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,MISS_CNT));
	
#if 0
	printk( KERN_INFO 
		"Reading MAC Register CNTDATA      0x80\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,CNTDATA));
	
	printk( KERN_INFO
		"Reading MAC Register CNTACC       0x84\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,CNTACC));

	printk( KERN_INFO
		"Reading MAC Register TXRMINTEN    0x88\t 0x%08X\n",
		(unsigned int) ReadMacRegister(pDrvCtrl,TXRMINTEN));

	printk(KERN_INFO
	       "Reading MAC Register RXRMINTEN    0x8c\t 0x%08X\n\n",
	       (unsigned int) ReadMacRegister(pDrvCtrl, RXRMINTEN));
#endif

	switch (identify_family())
	{
	case FAMILY_POLO:
	case FAMILY_ZEUS:
		printk(KERN_INFO
		       "Reading MAC Register MAC_BRCTRL_REG 0x8c\t 0x%08X\n\n",
		       (unsigned int) ReadMacRegister(pDrvCtrl, 
						      MAC_BRCTRL_REG));
		break;

	default:
		break;
	}
}
#endif

#if 0

/*
 * getIPaddr - kludge to get ip configuration until userland is available
 */
static u32 __init
getIPaddr(char *basestr, int unit)
{
	int i, j;
	u32 k, addr;
	char *env_str;
	char buf[80];

	addr = 0;

	sprintf(buf, "%s%d", basestr, unit);
	env_str = prom_getenv(buf);
	if (env_str == NULL)
		return addr;

	for (i = 0, k = 0, j = 24; i < strlen(env_str); i++)
	{
		if (isdigit(env_str[i]))
			k = (k * 10) + env_str[i] - '0';
		else {
			addr = addr + (k << j);
			k = 0;
			j -= 8;
			if (j < 0)
				break;
		}
	}

	if (j >= 0)
		addr = addr + (k << j);

	return addr;
}
#endif

/************************************************************************
 * Check for a network adaptor of this type, and return '0' iff one exists.
 *  - we just allocate them the number of times I'm called
 *  NOTE: we ignore the following values for base_addr ...MaTed
 * If dev->base_addr == 0, probe all likely locations.
 * If dev->base_addr == 1, always return failure.
 * If dev->base_addr == 2, allocate space for the device and return success
 * (detachable devices only).
 ************************************************************************/
int __init 
brecis_eth_probe( ND dev)
{
  int		unit;	
  int		hwunit;
  ULONG	baseAddr;
  char enetType;
  unsigned char ptr[20];

  unit = getEthUnit(dev);
  // check if all allocated

  IDBG( KERN_INFO "getEthUnit returns %d for %s\n", unit, dev->name);

  hwunit = compute_hwunit(unit);
  if (unit < 0 || gEthDrvCtrl[unit] != NULL || hwunit >= MSP_ETH_MAX_UNITS)
	  return (-ENODEV);

  enetType = identify_enet(hwunit);

  if (enetType == FEATURE_NOEXIST)
	  return (-ENODEV);	/* interface doesn't exist for this chip */

  /* Retrieve (from environment) and print the ethernet address. */
  if (get_ethernet_addr( MacName[unit], ptr))
  { // no ethernet MAC address in environment
    pkinit( KERN_INFO " No Mac addr specified for eth%d %s\n",
	    unit, MacName[unit]);
    return (-ENODEV);
  }

  if (*ptr&1)
  {
	  pkinit(KERN_INFO "Bad Multicast Mac addr specified for eth%d %s %02x:%02x:%02x:%02x:%02x%02x\n",
		 unit, MacName[unit], 
		 ptr[0], ptr[1], ptr[2], ptr[3], ptr[4], ptr[5]);
	  return (-ENODEV);
  }

  IDBG( KERN_INFO "Retrieved MAC address for eth%d %s, enetType %c\n",
		  unit, MacName[unit], enetType );

  // SET_MODULE_OWNER( dev);
  dev->irq = MacIRQs[hwunit];
  baseAddr = MacBases[hwunit];

  if ( check_mem_region( baseAddr, MSPEthExtent))
    return (-ENODEV);
  if ( brecis_eth_probe1(dev, baseAddr, unit, ptr) == 0)
  {
	  return 0;
  }
  return (-ENODEV);
}

/************************************************************************
 * This routine initializes all the vars in dev
 ************************************************************************/
static void
brecis_eth_InitVars( ND dev, int ioaddr)
{
  dev->base_addr = ioaddr;

  dev->open				= &brecis_eth_open;
  dev->stop				= &brecis_eth_close;
  dev->hard_start_xmit	= &brecis_eth_send_packet;
  dev->get_stats		= &brecis_eth_get_stats;
  dev->set_multicast_list = &set_multicast_list;
  dev->tx_timeout		= &brecis_eth_tx_timeout;
  dev->watchdog_timeo	= MY_TX_TIMEOUT; 
#if 0
  dev->do_ioctl			= &brecis_eth_do_ioctl;
#endif
  dev->set_mac_address		= &brecis_eth_set_mac_address;
}

/************************************************************************
 * This is the real probe routine. Linux has a history of friendly device
 * probes on the ISA bus. A good device probes avoids doing writes, and
 * verifies that the correct device exists and functions.
 ************************************************************************/
static int __init 
brecis_eth_probe1( ND dev, int ioaddr, int unit, unsigned char *ptr)
{
  int		i;	
  int	    irqval;
  MSP_DEVICE	*pDrvCtrl;
  
  IDBG( KERN_INFO "%s: found at %#3x\n", dev->name, ioaddr);
  /* Fill in the 'dev' fields. */
  dev->base_addr = ioaddr;

  dev->addr_len = EADDR_LEN;
  for (i = 0; i < dev->addr_len; i++)
	  dev->dev_addr[i] = ptr[i];

  IDBG(KERN_INFO "MAC address for eth%d is %02x:%02x:%02x:%02x:%02x:%02x\n",
		 unit, ptr[0], ptr[1], ptr[2], ptr[3], ptr[4], ptr[5]);

  /*
   * The ethernet MACS have fixed interrupts, allocate the interrupt
   * vector now. There is no point in waiting since no other device
   * can use the interrupt, and this marks the irq as busy. Jumpered
   * interrupts are typically not reported by the boards. MAC 0 is 
   * fixed at IRQ 10, MAC 1 is fixed IRQ11
   */
  irqval = request_irq( dev->irq, &brecis_eth_interrupt,
			SA_SAMPLE_RANDOM, cardname, dev);
  if ( irqval)
  {
    pkinit( KERN_WARNING "%s: unable to get IRQ %d (irqval=%d).\n",
	    dev->name, dev->irq, irqval);
    return ( -EAGAIN);
  }

  /* Grab the region so that no one else tries to probe our ioports. */
  if (! request_mem_region( ioaddr, MSPEthExtent, cardname))
  {
    pkinit( KERN_WARNING "%s: unable to get memory/io address region %x\n",
	    dev->name, ioaddr);
    return (-EAGAIN);
  }
  ether_setup(dev);
  if (MSPEthSetup(dev) != MSP_SUCCESS)
	  return ( -EAGAIN);

  pDrvCtrl = dev->priv;

  brecis_eth_InitVars( dev, ioaddr);
  return 0;
}

/***********************************************************************
 * Transmit timeout
 *	Kernel calls this routine when a transmit has timed out
 ***********************************************************************/
static void 
brecis_eth_tx_timeout( ND dev)
{
#if 0

  int stp ;
  FDBD *ofree ;
  static int ctr ;

  stp = netif_queue_stopped(priv->netdevice) ;
  ofree = priv->TxFrmPtrFreeBuf ;
  
  if(ctr++ < 10)
  {
	  printk("TxFrmPtrFreeBuf descriptor:\n") ;
	  printk("   Ethernet Unit: %d\n", priv->unit) ;
	  printk("   Address: %p\n", ofree) ;
	  printk("      Stat: %x  Ctl: %x\n",
		 (unsigned int)ofree->FD.FDStat, ofree->FD.FDCtl) ;
  }
#endif	  

  setup_delayed_reload(dev);

#if 0
  printk("brecis_eth_tx_timeout called txintr %x", priv->dbgint) ;
  if ( stp != netif_queue_stopped(priv->netdevice) )
	  printk(" queue_stop changed from %x to %x ", stp,
		 netif_queue_stopped(priv->netdevice) ) ;
  if (  ofree != priv->TxFrmPtrFreeBuf)
	  printk(" free ptr changed from %p to %p", ofree,
		 priv->TxFrmPtrFreeBuf) ;
  printk("\n") ;
#endif
}

#ifdef ETHERNETUSESCRATCHRAM
static UINT8 *kmallocSRAM(int size)
{
	int index;
	int tmp;
	int tmpsize = ((size + 0x0f) & ~0x0f);

	if (identify_spad() == FEATURE_NOEXIST)
		return NULL;

	for (index = 0; index < MAXSCRATCHRAMPARTITIONS; index++)
	{
		if (scratchramstate[index] != SCRATCH_FREE)
			continue;

		if (scratchramaddr[index+1] - scratchramaddr[index] >= tmpsize)
		{
			break;
		}
	}

	if (scratchramstate[index] != SCRATCH_FREE)
		return NULL;

	scratchramstate[index] = SCRATCH_INUSE;
	
	if (scratchramaddr[index+1] - scratchramaddr[index] == tmpsize)
		return (UINT8 *) scratchramaddr[index];

	if (scratchramstate[index+1] != SCRATCH_FREE)
	{
		for (tmp = MAXSCRATCHRAMPARTITIONS; tmp > index; tmp--)
		{
			scratchramaddr[tmp] = scratchramaddr[tmp-1];
			scratchramstate[tmp] = scratchramstate[tmp-1];
		}

		scratchramstate[index+1] = SCRATCH_FREE;
	}
	
	scratchramaddr[index+1] = scratchramaddr[index] + tmpsize;
	return (UINT8 *) scratchramaddr[index];
}

static void kfreeSRAM(void *buf)
{
	int index;
	unsigned long addr = (unsigned long) buf;

	for (index = 0; index < MAXSCRATCHRAMPARTITIONS; index++)
	{
		if (scratchramstate[index] != SCRATCH_INUSE)
			continue;

		if (addr == scratchramaddr[index])
		{
			scratchramstate[index] = SCRATCH_FREE;

			if (scratchramstate[index+1] != SCRATCH_FREE)
				return;

			for (index++; index < MAXSCRATCHRAMPARTITIONS; index++)
			{
				scratchramaddr[index] = 
					scratchramaddr[index+1];
				scratchramstate[index] = 
					scratchramstate[index+1];
			}

			return;
		}
	}
}
#endif

static UINT8 *kmallocBDS(int size)
{
#ifdef ETHERNETUSESCRATCHRAM
	UINT8 *buf;

	buf = kmallocSRAM(size);

	if (buf != NULL)
		return buf;
#endif

	return kmalloc(size + 15, GFP_KERNEL | __GFP_DMA);
}

static void kfreeBDS(void *buf)
{
#ifdef ETHERNETUSESCRATCHRAM
	if ((unsigned long) buf >= SCRATCHRAMADDR &&
	    (unsigned long) buf < (SCRATCHRAMADDR + ETHERNETSCRATCHRAMLEN))
	{
		kfreeSRAM(buf);
	}
	else
#endif
	{
		kfree(buf);
	}
}

static UINT8 *memalign16(UINT8 *buf)
{
	return (UINT8 *) (((unsigned long) buf + 15) & ~15);
}

/******************************************************************************
*
* MSPEthReceive - pass a received frame to the next layer up
*
* RETURNS: 0 if no more RX descriptors to process, non-zero otherwise
*/
static int MSPEthReceive
    (
    MSP_DEVICE *  pDrvCtrl       /* pointer to MSP_DEVICE structure */
    )
{
#ifdef DEBUGINTCOUNT
	int			count = 0;
#endif
	int			bdCount;
	U32			len;
	int			maxloopcount;
	U32			status;
	UINT8		bdNum;
	FDBD		*pFDBD;
	struct sk_buff *skb;
	int tmpreg;
#if 0
	FD			*tempFd;

	tempFd = (FD *) &(pDrvCtrl->FDAPtrCur->FD);
	PRINTK(KERN_INFO "Cur-%x Next-%x System-%x Stat-%x Ctl-%x Length-%x\n",
		   (unsigned int) tempFd,
		   (unsigned int) tempFd->FDNext,
		   (unsigned int) tempFd->FDSystem,
		   (unsigned int) tempFd->FDStat,
		   (unsigned int) tempFd->FDCtl,
		   (unsigned int) tempFd->FDLength);
#endif

	for (maxloopcount = pDrvCtrl->rxBdCount >> ETH_RX_RCV_SHIFT; 
	     maxloopcount >= 0;
	     maxloopcount--)
	{
		pFDBD = pDrvCtrl->FDAPtrCur ;
		
		if (MACOwnsRxFD(pFDBD))
		{
			MSPEthReadIntSrcReg(pDrvCtrl); /* ensure data leave MAC to DXU */
			tmpreg = *MEM_CNFG1_REG;			/* ensure the data leaves DXU to SDRAM */
			if (MACOwnsRxFD(pFDBD))
			{
#ifdef DEBUGINTCOUNT
				rxpackets[pDrvCtrl->unit][count]++;
#endif			
				return 0;		/* if packet belongs to MAC */
			}
		}

#ifdef DEBUGINTCOUNT
		count++;
#endif			

		tmpreg = *MEM_CNFG1_REG;			/* ensure the data leaves DXU to SDRAM */
		status = pFDBD->FD.FDStat;

		/*
		 * A good or bad packet has been received.
		 */
		len	= pFDBD->FD.FDLength;
		
		/* include CRC for Ethernet in total */
		pDrvCtrl->stats.rx_bytes += len;
		pDrvCtrl->stats.rx_packets++;

		/* remove CRC length from size of frame returned to user */
   		len -= ETHERNET_CRC_SIZE; 

#if 0
		{
			UCHAR		*p_buf;

			p_buf = (UCHAR *) pFDBD->BD[0].BuffData;
			PRINTK(KERN_INFO 
				"Packet received: %x, %d, %x: %x %x %x %x\n",
				(unsigned int) p_buf, 
				(unsigned int) len, 
				(unsigned int) status,
				*((unsigned int *)&p_buf[0]),
				*((unsigned int *)&p_buf[4]),
				*((unsigned int *)&p_buf[8]),
				*((unsigned int *)&p_buf[12]));
		}
#endif

		/* 
		 * Get a new skb and attach to the corresponding BD in the 
		 * BL area so that buffer is readily available for incoming packet. 
		 * And also the this function assumes only one BD is used per 
		 * incoming packet.
		 */
		bdNum = pFDBD->BD[0].BDStat;

		if(status & RCVD_OK_PKT) /* if it is a good packet */
		{
			skb = pDrvCtrl->rskbp[bdNum];

			/* Assume sending packet up stack, start SDRAM fetch */
			InvalidateBuffer(skb->data, len);
			pref(skb->data,0x000);
			pref(skb->data,0x010);
			pref(skb->data,0x020);
			pref(skb->data,0x030);

			pDrvCtrl->rskbp[bdNum] = getskb(pDrvCtrl);

			if (pDrvCtrl->rskbp[bdNum] != NULL)
			{
				/* finish skb and send it up */

				__skb_put(skb, len);

				skb->protocol = eth_type_trans(skb, pDrvCtrl->netdevice);
				netif_rx( skb);
				pDrvCtrl->netdevice->last_rx = jiffies;
			}
			else
			{

				PRINTK(KERN_INFO "MSPEthReceive-dev_ alloc_skb failed\n");
				/* MIB2 Statistic */
				pDrvCtrl->stats.rx_dropped++;	// do all count as a dropped pkt??
				pDrvCtrl->rskbp[bdNum] = skb;
			}
		}
		else
		{
			int errorFound = 0;

			pDrvCtrl->stats.rx_errors++;
			pDrvCtrl->stats.rx_dropped++;	// do all count as a dropped pkt??
			if (status & (RCVD_LEN_ERR | RCVD_LONG_ERR))
			{
				pDrvCtrl->stats.rx_length_errors++;
				errorFound = 1;
			}

			if (status & RCVD_OVRFLW_ERR)
			{
				pDrvCtrl->stats.rx_over_errors++;
				errorFound = 1;
			}
			else if (status & RCVD_CRC_ERR ) 
			{
				pDrvCtrl->stats.rx_crc_errors++;
				errorFound = 1;
			}

			if (status & RCVD_PAR_ERR) 	// ?? where else to put
			{
				pDrvCtrl->stats.rx_fifo_errors++;
				errorFound = 1;
			}

			if (status & RCVD_ALIGN_ERR)
			{
				pDrvCtrl->stats.rx_frame_errors++;
				errorFound = 1;
			}

			if (errorFound == 0)
				pDrvCtrl->stats.rx_missed_errors++;
#if 0	/* rsewill */
			printk(KERN_INFO 
			       "eth%d-rx error FDBD %x, status %x\n", 
			       pDrvCtrl->unit, 
			       (unsigned int) pFDBD,
			       (unsigned int) status);
			{
				void (*reboot) (void);
				reboot = (void (*) (void) ) 0xbfc00000;
				reboot();
			}
#endif
		}

		/* 
		 * Return ownership of frame and buffer descriptors in both FDA and BL.
		 * In case of Jabbers, there could be several BDs, so make sure that
		 * all the BDs that MAC used are cleared here.
		 */
		pFDBD = (FDBD *) &(pDrvCtrl->FDAPtrCur->FD); 
		for (bdCount=0; 
			bdCount < (pFDBD->FD.FDCtl & FDCTL_BD_COUNT_MASK); 
			bdCount++)
		{
			bdNum = pFDBD->BD[bdCount].BDStat;
			pFDBD->BD[bdCount].BDCtl = MAC_OWNS_BD;
			pDrvCtrl->BLFrmPtr->BD[bdNum].BuffData =
				getRxBuffData(pDrvCtrl->rskbp[bdNum]->data);
			pDrvCtrl->BLFrmPtr->BD[bdNum].BuffLength = MSP_END_BUFSIZE;
			pDrvCtrl->BLFrmPtr->BD[bdNum].BDCtl      = MAC_OWNS_BD;
		}
		
		/* return free descriptor area back to controller */
		pDrvCtrl->FDAPtrCur = (FDBD *) pDrvCtrl->FDAPtrCur->FD.FDNext;
		pFDBD->FD.FDCtl = MAC_OWNS_FD;
	}

#ifdef DEBUGINTCOUNT
	rxpackets[pDrvCtrl->unit][count]++;
#endif			
	return 1;		/* more RX descriptors to process */
}

/*********************************************************************
 *	RXbh is called when the interrupts schedule it.
 *
 *********************************************************************/
static void RXbh(void *data)
{
	MSP_DEVICE	*pDrvCtrl = data;
	unsigned long	flags;
	int		recovery;

	save_and_cli(flags) ;
	recovery = pDrvCtrl->bh_recovery ;
	pDrvCtrl->bh_recovery = 0 ;
	restore_flags(flags) ;

	if (pDrvCtrl->reloadflag)
	{
		return;
	}

	MSPEthRxIntEnable(pDrvCtrl);
	MSPEthReceive(pDrvCtrl);

	if (recovery)
	{
		MSPEthFdaFullIntEnable(pDrvCtrl);
		MSPEthBlFullIntEnable(pDrvCtrl);
	}

	if (! MACOwnsRxFD(pDrvCtrl->FDAPtrCur)) 
	{
		queue_task(&pDrvCtrl->rx_bh, &tq_immediate);
		mark_bh(IMMEDIATE_BH);
	}

}

/************************************************************************
 * Open/initialize the board. This is called (in the current kernel)
 * sometime after booting when the 'ifconfig' program is run.
 *
 * This routine should set everything up anew at each open, even
 * registers that "should" only need to be set once at boot, so that
 * there is non-reboot way to recover if something goes wrong.
 ***********************************************************************/
static int
brecis_eth_open( ND dev)
{
  UINT		basePort = dev->base_addr;
  RET_CODE	rc;

  PRINTK(KERN_INFO "***** Entering brecis_eth_open(), %s, MSP_DEVICE=%x\n", 
		 dev->name, (unsigned int) dev->priv);

  /*
   * This is used if the interrupt line can turned off (shared).
   * - Can we share? - might as well register
   */
  if (dev->priv == NULL)
  {
	  /* if not already initialized */
	  if ( request_irq( dev->irq, &brecis_eth_interrupt, SA_SAMPLE_RANDOM, 
			    cardname, dev))
	  {
		  printk(KERN_INFO "brecis_eth_open(), failed request_irq %s\n", dev->name);
		  return -EAGAIN;
	  }

 	  /* Grab the region so that no one else tries to probe our ioports. */
	  if ( ! request_mem_region( basePort, MSPEthExtent, cardname))
	  {
		  printk(KERN_INFO "brecis_eth_open(), failed request_mem_region %s\n", 
				 dev->name);
		  return -EAGAIN;
	  }

	  /*
	   * Always allocate the DMA channel after the IRQ,
	   * and clean up on failure.
	   */
	  // Already initialized in the Probe when allocated, do it again
	  // Initialize vars in private area- Again!
	  brecis_eth_InitVars( dev, dev->base_addr);
	  
  }

  /* Reset the hardware here. Don't forget to set the station address. */
	  
  if (MSP_SUCCESS != (rc = MSPEthSetup(dev)))
  {
	  printk( KERN_ERR "brecismspeth: Phys init failed \n");
	  return -ENOMEM;
  }

  monitor_phy_negotiation();

  return 0;
}

static void brecis_eth_complete_open(MSP_DEVICE *priv)
{
  memset( &priv->stats, 0, sizeof( struct net_device_stats ));

  MSPEthAckAllInt(priv);
  MSPEthIntEnable(priv);
  MSPEthEnableTxRx(priv);

  /* We are now ready to accept transmit requests from
   * the queueing layer of the networking.
   */
  netif_start_queue(priv->netdevice);

}

/************************************************************************
 This will only be invoked if your driver is _not_ in XOFF state.
 * What this means is that you need not check it, and that this
 * invariant will hold if you make sure that the netif_*_queue()
 * calls are done at the proper times.
 ************************************************************************/
static int brecis_eth_send_packet( struct sk_buff *skb, ND dev)
{
  MSP_DEVICE *priv = dev->priv;
  unsigned long flags;
  FDBD *FrmPtr ;
  
  if (priv == NULL || priv->reloadflag)
  {
	  /* 
	   * It should be impossible to get here because whoever set
	   * priv to NULL or set the reloadflag should have done
	   * netif_stop_queue(), but stop us again
	   */
	  printk(KERN_INFO "brecis_eth_send_packet -- priv == NULL or reloading\n");
	  netif_stop_queue( dev);
	  return (-1);
  }
  
  /* If some error occurs while trying to transmit this
   * packet, you should return '1' from this function.
   * In such a case you _may not_ do anything to the
   * SKB, it is still owned by the network queueing
   * layer when an error is returned.  This means you
   * may not modify any SKB fields, you may not free
   * the SKB, etc.
   */

  /* Finish and free any completed transmits if not using INTR_Tx */

  MSPEthFreeTxBuffs(priv);
  
  /* This is the most common case for modern hardware.
   * The spinlock protects this code from the TX complete
   * hardware interrupt handler.  Queue flow control is
   * thus managed under this lock as well.
   */
  spin_lock_irqsave( &priv->lock, flags);

  FrmPtr = priv->TxFrmPtrCur ;

  if (TxFDInUse(FrmPtr))
  {
	  netif_stop_queue( dev);
	  MSPEthTxIntEnable(priv);
	  spin_unlock_irqrestore( &priv->lock, flags);
	  return 1;			/* we are busy */
  }

  priv->TxFrmPtrCur = (FDBD *) FrmPtr->FD.FDNext;

  FrmPtr->BD[0].BuffData = skb->data;
  FrmPtr->BD[0].BuffLength = skb->len;
  FrmPtr->FD.FDSystem = (UINT32) skb;

  FrmPtr->BD[0].BDCtl = MAC_OWNS_BD;
  FrmPtr->FD.FDCtl |= MAC_OWNS_FD;

  spin_unlock_irqrestore( &priv->lock, flags);

  // Let the MAC know there is something to send
  MSPEthTxWakeUp(priv);

  dev->trans_start = jiffies;

  return 0;
}

/************************************************************************
 * The typical workload of the driver:
 * Handle the network interface interrupts.
 ************************************************************************/
static void brecis_eth_interrupt( int irq, void *dev_id, struct pt_regs * regs)
{
	ND dev = dev_id;
	MSP_DEVICE *pDrvCtrl = (MSP_DEVICE *)dev->priv;
	int doreceive = 0;
	int dorecovery = 0;
	int status;
	int tmpreg;

#ifdef DEBUGINTCOUNT
	if (pDrvCtrl->unit < MAX_DEVICES)
		intcount[pDrvCtrl->unit]++;
#endif

	status = MSPEthReadIntSrcReg(pDrvCtrl);

	tmpreg = *MEM_CNFG1_REG;			/* ensure the data gets to SDRAM */

	if (status == INTR_Rx)
	{
		MSPEthAckRxInt(pDrvCtrl);
		MSPEthRxIntDisable(pDrvCtrl);
		if (! pDrvCtrl->reloadflag)
		{
			queue_task(&pDrvCtrl->rx_bh, &tq_immediate);
			mark_bh(IMMEDIATE_BH);
		}
		return ;
	}
	
#ifdef DEBUGJIFFIEINT
	if (debuginterruptcount >= MAXINTSPERJIFFIE)
	{
		/* 
		 * disable ints, stop traffic, 
		 * arbitrarily ack all interrupts
		 */
		MSPEthMACIntDisable(pDrvCtrl);
		MSPEthDisableTxRxHalt(pDrvCtrl);
		MSPEthAckOtherInt(pDrvCtrl, status);

		if (debuginterruptcount == MAXINTSPERJIFFIE)
		{
			debuginterruptcount++;
			printk(KERN_INFO "at max ints per jiffie\n");
		}
		return;		/* be quiet */
	}

	if (debugjiffiecount != jiffies)
	{
		debugjiffiecount = jiffies;
		debuginterruptcount = 0;
	}
	else
	    debuginterruptcount++;

	debugintdev[debuginterruptcount] = pDrvCtrl->unit;
	debugintstat[debuginterruptcount] = status;

#endif
	if(status & INTR_REQ_RELOAD)
	{
		MSPEthAckOtherInt(pDrvCtrl, status);

		PRINTK(KERN_ERR "brecis_eth_interrupt: dev<%x>->name<%s>, reload\n",
			   (unsigned int) dev, dev->name);

		setup_delayed_reload(dev);
		return;
	}

	if (status & INTR_Tx)
	{
		MSPEthAckTxInt(pDrvCtrl);
		MSPEthFreeTxBuffs(pDrvCtrl);
	}
	
	if (status & (INTR_FDAEx | INTR_IntFDAEx))
	{
#ifdef DEBUG_RX_TX_STATS
		fdaExhausedCounts[pDrvCtrl->unit]++;
#endif
		doreceive = 1;
		dorecovery = 1;

		MSPEthFdaFullIntDisable(pDrvCtrl);

		if (status & INTR_FDAEx)
		{
			MSPEthAckFdaFullInt(pDrvCtrl);
		}
	}

	if(status & (INTR_BLEx | INTR_IntBLEx))
	{
		doreceive = 1;
		dorecovery = 1;

#ifdef DEBUG_RX_TX_STATS
		blExhausedCounts[pDrvCtrl->unit]++;
#endif
		MSPEthBlFullIntDisable(pDrvCtrl);

		if (status & INTR_BLEx)
		{
		    MSPEthAckBlFullInt(pDrvCtrl);
		}
	}

	if (status & INTR_Rx)
	{
		doreceive = 1;

		/* ack interrupt */
		
		MSPEthAckRxInt(pDrvCtrl);
	}
		
	if (doreceive || dorecovery)
	{
		MSPEthRxIntDisable(pDrvCtrl);

		if (dorecovery)
			pDrvCtrl->bh_recovery = 1;

		if (! pDrvCtrl->reloadflag)
		{
			queue_task(&pDrvCtrl->rx_bh, &tq_immediate);
			mark_bh(IMMEDIATE_BH);
		}
	}

	if (status & INTR_OTHER)
	{
		MSPEthAckOtherInt(pDrvCtrl, status & INTR_OTHER);
	}
}

/************************************************************************
 * The inverse routine to net_open().
 ************************************************************************/
static int
brecis_eth_close( ND dev)
{
  MSP_DEVICE *priv = dev->priv;

  PRINTK(KERN_INFO "***** Entering brecis_eth_close(), %s, MSP_DEVICE=%x\n", 
		 dev->name, (unsigned int) dev->priv);

  netif_carrier_off(dev);
  netif_stop_queue( dev);

  /* Flush the Tx and disable Rx here. */

  if (priv != NULL)
  {
	  MSPEthMACIntDisable(priv);
	  MSPEthDisableTxRxHalt(priv);
	  MSPEthMemoryFree(priv);
  }

  free_irq( dev->irq, dev);
  release_mem_region(dev->base_addr, MSPEthExtent);

#ifdef DEBUGJIFFIEINT
  {
	  int i;

	  printk(KERN_INFO "debug interruptcount %d, jiffie count %d\n",
		 debuginterruptcount, debugjiffiecount);

	  for (i = 0; i < debuginterruptcount; i++)
		  printk(KERN_INFO "%08d) %08x  %08x\n",
			 i, debugintdev[i], debugintstat[i]);
  }
#endif  

  return 0;
}
/**************************************************************************
 * Reload ethernet MAC interface because we have a problem or lost carrier.
 **************************************************************************/

static void reload_tq(void *data)
{
	ND	dev = data;

	brecis_eth_close(dev);
	brecis_eth_open(dev);
	netif_wake_queue(dev);
}

static void reloadcheck_timer(unsigned long unused)
{
	tasklet_schedule(&mspeth_reloadcheck_task);
	mspeth_reloadcheck_timer.expires = jiffies + RELOAD_CHECK_DELAY * HZ;
	add_timer(&mspeth_reloadcheck_timer);
}

static void reloadchecks(unsigned long unused)
{
	int		i;
	MSP_DEVICE	*priv;
	ND		dev;

	/*
	 * For every ethernet interface, check for carrier
	 * and signal a change link event if necessary
	 */
	for (i = 0; i < MSP_ETH_MAX_UNITS; i++)
	{
		priv = gEthDrvCtrl[i];

		if (priv != NULL)
		{
			dev = priv->netdevice;

			/* try to free completed tx buffs */

			if (priv->reloadflag)
			{
				/* if reload is being forced */

				schedule_task(&priv->reload_tq);
				continue;
			}

			if (jiffies - dev->last_rx < dev->watchdog_timeo)
			{
				/*
				 * we either a packet (last_rx)
				 * within the last watchdog_timeo interval 
				 * so this interface was alive so don't 
				 * have to check cable this time
				 */
				continue;
			}

			MSPEthFreeTxBuffs(priv);

			if (TxFDInUse(priv->TxFrmPtrFreeBuf) &&
			    jiffies - dev->trans_start > dev->watchdog_timeo &&
			    priv->tx_packets == priv->stats.tx_packets &&
			    priv->tx_errors == priv->stats.tx_errors)
			{
				/* 
				 * If we have a packet in use -and-
				 * the jiffies check makes sure no TX packet
				 * was just put on the interface -and-
				 * we haven't finished any tx packet,
				 * then we timed out.
				 */
				printk(KERN_INFO 
				       "eth%d tx packet timed out\n",
				       priv->unit);
				schedule_task(&priv->reload_tq);
				continue;
			}

			priv->tx_packets = priv->stats.tx_packets;
			priv->tx_errors = priv->stats.tx_errors;

			if (priv->phyType == PHYTYPE_KENDINSWITCH
			||  priv->phyType == PHYTYPE_NONE)
			{
			
				/* A switch always HAS carrier */
				continue;
			}

			if (priv->phyWaiting)
			{
				/* found a PHY coming up */
				continue;
			}
			
			if (MSPPHYGCheckCable(priv) != 0)
			{
				/* we have a carrier */

				if (! netif_carrier_ok(dev))
				{
					/* if need to notify upper layer */

					if ((jiffies - priv->carrier_off) >
					    CARRIER_RELOAD_DELAY)
					{
						/* carrier was off too long */

						schedule_task(&priv->reload_tq);
					}
					else
					{
						/* only tell upper layer */
						netif_carrier_on(dev);
					}
				}
			}
			else
			{
				/* we don't have a carrier */

				if (netif_carrier_ok(dev))
				{
					/* if need to notify upper layer */

					netif_carrier_off(dev);
					priv->carrier_off = jiffies;
				}
			}
		}
	}
}

/**************************************************************************
 * Monitor PHY Negotation.
 **************************************************************************/
static void monitor_phy_negotiation(void)
{
	if (timer_pending(&mspeth_checkphys_timer))
		return;

	tasklet_schedule(&mspeth_checkphys_task);
}

static void checkphys_timer(unsigned long unused)
{
	tasklet_schedule(&mspeth_checkphys_task);
}

static void checkphys(unsigned long unused)
{
	int		i;
	int		needphycheck = 0;
	MSP_DEVICE	*priv;

	/*
	 * For every ethernet interface, check for PHY negotation
	 */
	for (i = 0; i < MSP_ETH_MAX_UNITS; i++)
	{
		priv = gEthDrvCtrl[i];
		
		if (priv != NULL)
		{
			if (priv->phyWaiting)
			{
				/* found a PHY coming up */

				needphycheck = 1;

				switch (MSPPHYGWaitForLink(priv))
				{
				case MSP_SUCCESS:
					MSPEthPhyInit_complete(priv);
					brecis_eth_complete_open(priv);
					break;
				case MSP_FAIL:
					break;
				}
			}
		}
	}

	if (needphycheck)
	{
		mspeth_checkphys_timer.expires = jiffies + 1;
		add_timer(&mspeth_checkphys_timer);
	}
}


/************************************************************************
 * Get the current statistics.
 * This may be called with the card open or closed.
 ************************************************************************/
static struct net_device_stats *brecis_eth_get_stats( ND dev)
{
  MSP_DEVICE *priv = (MSP_DEVICE *)dev->priv;

  if (priv == NULL)
	  return NULL;

#ifdef DEBUGDISPLAYMACREGISTERS
	MSPEthDisplayMacRegisters(priv->unit);
#endif
#ifdef DEBUG_RX_TX_STATS
	printk(KERN_INFO  "Packet stats - unit %d\n", (UINT) priv->unit);
	printk(KERN_INFO  "rx_len_errors    %d\n", (UINT)priv->stats.rx_length_errors);
	printk(KERN_INFO  "rx_crc_errors    %d\n", (UINT)priv->stats.rx_crc_errors);
	printk(KERN_INFO  "rx_over_errors   %d\n", (UINT)priv->stats.rx_over_errors);
	printk(KERN_INFO  "rx_fifo_errors   %d\n", (UINT)priv->stats.rx_fifo_errors);
	printk(KERN_INFO  "rx_frame_errors  %d\n", (UINT)priv->stats.rx_frame_errors);
	printk(KERN_INFO  "rx_missed_errors %d\n", (UINT)priv->stats.rx_missed_errors);
	printk(KERN_INFO  "fdaExhausedCounts %d\n", (UINT)fdaExhausedCounts[priv->unit]);
	printk(KERN_INFO  "blExhausedCounts %d\n", (UINT)blExhausedCounts[priv->unit]);
					
	printk(KERN_INFO  "tx_collisions       %d\n", (UINT)priv->stats.collisions);				
	printk(KERN_INFO  "tx_aborted_errors   %d\n", (UINT)priv->stats.tx_aborted_errors);				
	printk(KERN_INFO  "tx_carrier_errors   %d\n", (UINT)priv->stats.tx_carrier_errors);				
	printk(KERN_INFO  "tx_fifo_errors      %d\n", (UINT)priv->stats.tx_fifo_errors);				
	printk(KERN_INFO  "tx_heartbeat_errors %d\n", (UINT)priv->stats.tx_heartbeat_errors);				
#endif

#ifdef DEBUGINTCOUNT
  {
	  int i;

	  for (i = 0; i < DEBUGINTCOUNT; i++)
		  if (rxpackets[priv->unit][i])
			  printk(KERN_INFO 
				 "eth%d: rx num %d time %d\n", 
				 priv->unit, i, rxpackets[priv->unit][i]);
	  printk(KERN_INFO "eth%d: %d ints\n", 
		 priv->unit, intcount[priv->unit]);
  }
#endif

  return (&priv->stats);
}

/************************************************************************
 * Set hardware MAC address
 ************************************************************************/
static int	brecis_eth_set_mac_address(ND dev, void *addr)
{
	struct sockaddr *mac = addr;

	memcpy(dev->dev_addr, mac->sa_data, EADDR_LEN);
	set_multicast_list(dev);
	
	return 0;
}

#if 0
/************************************************************************
 * Perform ioctls.
 ************************************************************************/
static int brecis_eth_do_ioctl(ND dev, struct ifreq *rq, int cmd)
{
	int result = 0;

	switch (cmd)
	{
	default:
		result = -EOPNOTSUPP;
		break;
	}

	return result;
}
#endif

/************************************************************************
 * Set or clear the multicast filter for this adaptor.
 * num_addrs == -1	Promiscuous mode, receive all packets
 * num_addrs == 0	Normal mode, clear multicast list
 * num_addrs > 0	Multicast mode, receive normal and MC packets,
 *			and do best-effort filtering.
 ************************************************************************/
static void
set_multicast_list( ND dev)
{
  int swEntryNumber;
  MSP_DEVICE *priv = (MSP_DEVICE *)dev->priv;
  struct    dev_mc_list * ptr = dev->mc_list;

  PRINTK(KERN_INFO "***** Entering set_multicast_list, %s, MSP_DEVICE=%x\n", 
		 dev->name, (unsigned int) dev->priv);

  if (priv == NULL)
	  return;

  if (dev->flags & IFF_PROMISC)
  {
	  PRINTK(KERN_INFO "set_multicast_list IFF_PROMISC\n");
	  MSPEthEnablePromiscMode(priv);
	  return;
  }

  WriteMacRegister(priv, ARC_ENA, 0);

  swEntryNumber = 0;
  MspEthArcAdd(priv, dev->dev_addr, swEntryNumber++);

  if (dev->flags & IFF_ALLMULTI)
  {
	  PRINTK(KERN_INFO "set_multicast_list IFF_ALLMULTI\n");
	  WriteMacRegister(priv, ARC_CTL, 
					   ARC_CompEn | ARC_BroadAcc | ARC_GroupAcc);
	  return;
  }

  for (ptr = dev->mc_list; 
	   ptr != NULL && swEntryNumber < MAX_ARC_ENTRIES; 
	   ptr = ptr->next)
  {
	  MspEthArcAdd(priv, ptr->dmi_addr, swEntryNumber++);
  }

  if (swEntryNumber == MAX_ARC_ENTRIES)
  {
	  PRINTK(KERN_INFO "set_multicast_list MAX_ARC_ENTRIES\n");	  
	  WriteMacRegister(priv, ARC_CTL, 
					   ARC_CompEn | ARC_BroadAcc | ARC_GroupAcc);
  }

  PRINTK(KERN_INFO "***** Exiting set_multicast_list, %s, MSP_DEVICE=%x\n", 
		 dev->name, (unsigned int) dev->priv);
}

static unsigned int MspEthArcAdd(MSP_DEVICE *pDrvCtrl, unsigned char *pAddr,
								 int swEntryNumber)
{
	unsigned int temp;
	int arcEntry;
	int arcOffset;
	union
	{
		unsigned long  L [2];
		unsigned char  M [8];
	} mac;

	PRINTK(KERN_INFO "MspEthArcAdd %d)  %02x:%02x:%02x:%02x:%02x:%02x\n",
		   swEntryNumber, 
		   pAddr[0], pAddr[1], pAddr[2], pAddr[3], pAddr[4], pAddr[5]);

	/* 
	 * move mac over byte by byte.  pointer may not be
	 * word aligned 
	 */
	mac.L[1] = 0;
	memcpy(mac.M, pAddr, MAC_ADDR_LEN);
	
	/*
	 * swEntryNumber corrsponds to the addrss of 
	 * (swEntryNumber*6bytes) in the HW ARC Table.
	 * In the  HW ARC Table, each entry is placed 
	 * in two address location. Each address contains
	 * only 4 bytes.
	 */
 
	arcEntry  = (swEntryNumber*6) / 4;
	arcOffset = (swEntryNumber*6) % 4;
	
	WriteMacRegister(pDrvCtrl, ARC_ADR, arcEntry*4);
	if (arcOffset == 0)
	{	
		WriteMacRegister(pDrvCtrl, ARC_DATA, mac.L[0]); 
		WriteMacRegister(pDrvCtrl, ARC_ADR, (arcEntry+1)*4);

		temp = ReadMacRegister(pDrvCtrl, ARC_DATA);
		temp = temp & 0x0000FFFF;
		temp = temp | (mac.L[1] & 0xFFFF0000);
	}
	else
	{
		temp = ReadMacRegister(pDrvCtrl, ARC_DATA);
		temp = temp & 0xFFFF0000;
		temp = temp | ((mac.L[0] >> 16) & 0x0000FFFF);
		WriteMacRegister(pDrvCtrl, ARC_DATA, temp); 
	
		temp = ((mac.L[0]<<16) & 0xFFFF0000) | ((mac.L[1] >> 16) & 0x0000FFFF);
	}
	WriteMacRegister(pDrvCtrl, ARC_ADR, (arcEntry+1)*4);
	WriteMacRegister(pDrvCtrl, ARC_DATA, temp); 		

	/*
	 * Enable the Entry that has just been added.
	 */
	temp = ReadMacRegister(pDrvCtrl, ARC_ENA);
	WriteMacRegister(pDrvCtrl, ARC_ENA, temp|(1<<swEntryNumber));
	return(MSP_SUCCESS);
}

/************************************************************************
 * set up initialization/cleanup
 ************************************************************************/
static void __init init_phyaddresses(void)
{
	int i;
	int hwindex;
	int phyindex;
	char *phyaddr;
	char name[80];

	for (i = 0; i < MSP_ETH_MAX_UNITS; i++)
	{
		sprintf(name, "phyaddr%d", i);
		phyaddr = prom_getenv(name);

		if (phyaddr != NULL &&
		    sscanf(phyaddr, "%d:%d", &hwindex, &phyindex) == 2 &&
		    hwindex < MSP_ETH_MAX_UNITS && 
		    (phyindex < MD_MAX_PHY || phyindex == MD_DYNAMIC_PHY) &&
		    PhyBases[hwindex].mac_base != NULL)
		{
			phyAddresses[i] = (hwindex << 16) | phyindex;
		}
		else if (gethswitch[i])
		{
			phyAddresses[i] = MD_NO_PHY;
		}
		else
		{
			/* if Polo, assume we use mdc/mdio index 0 hardware */
			/* Otherwise, assume each phy has own mdc/mdio */

			switch (identify_family())
			{
			case FAMILY_POLO:
			case FAMILY_ZEUS:
				phyAddresses[i] = MD_DYNAMIC_PHY;
				break;
			
			default:
				phyAddresses[i] = (i << 16) | MD_DYNAMIC_PHY;
			}

			if (phyaddr != NULL)
			{
				pkinit(KERN_INFO 
				       "init_phyaddresses: %s bad value %s\n",
				       name, phyaddr);
			}
		}
	}
}

static void __init init_speedduplexswitchsettings(void)
{
	int index;
	int unit;
	char c = ' ';
	char command_line[COMMAND_LINE_SIZE];
	char *ptr = &command_line[0];
	char *ethptr = NULL;

	strcpy(command_line, prom_getcmdline());

	while (c != '\0')
	{
		if (c != ' ' || memcmp(ptr, "ip=", 3) != 0)
		{
			c = *ptr++;
			continue;
		}

		c = *ptr++;
		index = 0;
		unit = -1;

		while (index < 8)
		{
			c = *ptr++;

			if (c == '\0' || c == ' ')
			{
				if (index == 7)
				{
					index++;
					*--ptr = '\0';
					ptr++;
				}

				break;
			}

			if (c == ':')
			{
				index++;

				if (index == 5)
				{
					if (memcmp(ptr, "eth", 3) != 0)
					{
						break;
					}
					
					ethptr = &ptr[3];
					ptr = ethptr;
				}

				if (index == 6)
				{
					*--ptr = '\0';
					ptr++;
					unit = simple_strtol(ethptr, NULL, 0);
				}

				if (index == 7)
				{
					ethptr = ptr;
				}

				if (index == 8)
				{
					*--ptr = '\0';
					ptr++;
				}
			}
		}

		if (index < 8 || unit < 0 || unit > MSP_ETH_MAX_UNITS)
			continue;

		if (strcmp(ethptr, "an") == 0)
			gethspeedduplex[unit] = -1;
		else if (strcmp(ethptr, "10h") == 0)
			gethspeedduplex[unit] = 10;
		else if (strcmp(ethptr, "10f") == 0)
			gethspeedduplex[unit] = 20;
		else if (strcmp(ethptr, "100h") == 0)
			gethspeedduplex[unit] = 100;
		else if (strcmp(ethptr, "100f") == 0)
			gethspeedduplex[unit] = 200;
		else if (strcmp(ethptr, "10hs") == 0)
		{
			gethspeedduplex[unit] = 10;
			gethswitch[unit] = 1;
		}
		else if (strcmp(ethptr, "10fs") == 0)
		{
			gethspeedduplex[unit] = 20;
			gethswitch[unit] = 1;
		}
		else if (strcmp(ethptr, "100hs") == 0)
		{
			gethspeedduplex[unit] = 100;
			gethswitch[unit] = 1;
		}
		else if (strcmp(ethptr, "100fs") == 0)
		{
			gethspeedduplex[unit] = 200;
			gethswitch[unit] = 1;
		}
	}
}

static int __init mspeth_init(void)
{
	init_timer(&mspeth_reloadcheck_timer);
	mspeth_reloadcheck_timer.expires = jiffies + RELOAD_CHECK_DELAY * HZ;
	mspeth_reloadcheck_timer.function = reloadcheck_timer;
	mspeth_reloadcheck_timer.data = 0;
	add_timer(&mspeth_reloadcheck_timer);

	init_timer(&mspeth_checkphys_timer);
	mspeth_checkphys_timer.expires = 0;
	mspeth_checkphys_timer.function = checkphys_timer;
	mspeth_checkphys_timer.data = 0;
	init_speedduplexswitchsettings();
	init_phyaddresses();
	mspeth_inited = 1;
	return 0;
}

module_init(mspeth_init);

/*
 * Local variables:
 *  version-control: t
 *  kept-new-versions: 5
 *  tab-width: 8
 *  c-indent-level: 0
 * End:
 */
#endif // CONFIG_BRECIS_ETH
