/*
  $Header: /proj/software/pub/CVSROOT/uClinux/linux/drivers/brecis/lg79063/slacpri.h,v 1.5 2003/03/07 06:48:43 awarner Exp $
*/
#ifndef    SLACPRI_H_INC_
#define    SLACPRI_H_INC_



/******************************************************************/
/* Copyright (c) 2001-2002 BRECIS Communications                  */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

/****************************************************************************
 *
 *       Include File Title
 *       slacpri.h
 *
 *****************************************************************************
 *
 *       Module Description:
 *
 *
 *
 *
 *
 ****************************************************************************/

#define SLAC_DEBOUNCE_TIMER_INTERVAL   50 /* milliseconds */

#define SLIC_RINGER_FREQ 20 /* 20 Hz ringer */

#define SLAC_MAX_NUM_OF_CHIP     8
#define CHANNELS_PER_QSLAC       4

#define SLAC_DEFAULT_NO_RING_DEBOUNCE_COUNT       3    /* 150ms */
#define SLAC_DEFAULT_RINGING_DEBOUNCE_COUNT       3    /* 150 ms */
#define SLAC_DEFAULT_B2_TRANSIT_DEBOUNCE_COUNT    4    /* 200 ms */

/**********************************************************************
 **                             QSLAC Commands
 ***********************************************************************/
#define WR_2_SW_RESET            0x02

#define WR_3_HW_RES_REG          0x04

#define WR_5_ACTIVATE_REG        0x0E

#define WR_6_TX_TS_SEL_REG       0x40

#define WR_8_RX_TS_SEL_REG       0x42

#define WR_10_CLOCK_EDGE_REG     0x44

#define WR_12_CONFIG_REG         0x46
#define RD_13_CONFIG_REG         0x47


#define WR_14_ENABLE_CH_REG      0x4A

#define RD_16_RT_DATA_REG        0x4D

#define RD_17_RT_DATA_REG_CL     0x4F

#define WR_20_SLIC_IO_REG        0x52

#define WR_22_IO_DIR_REG         0x54

#define WR_24_OP_REG             0x60

#define WR_26_INT_MASK_REG       0x6C

#define WR_28_OP_COND_REG        0x70

/* Filter coefficient registers */
#define WR_18_AISN_ANA_GAIN      0x50

#define WR_31_GX_FILTER          0x80

#define WR_33_GR_FILTER          0x82

#define WR_35_Z_FILTER           0x84

#define WR_37_B_FILTER           0x86

#define WR_39_X_FILTER           0x88

#define WR_41_R_FILTER           0x8A

#define WR_43_B2_FILTER          0x96

#define WR_45_DEBOUNCE_TIME_REG  0xC8

#ifdef    CURRENTLY_UNUSED_READ_REGISTERS
#define RD_7_TX_TS_SEL_REG       0x41

#define RD_9_RX_TS_SEL_REG       0x43

#define RD_15_ENABLE_CH_REG      0x4B

#define RD_21_SLIC_IO_REG        0x53

#define RD_25_OP_REG             0x61

/* Filter coefficient registers */
#define RD_19_AISN_ANA_GAIN      0x51

#define RD_32_GX_FILTER          0x81

#define RD_34_GR_FILTER          0x83

#define RD_36_Z_FILTER           0x85

#define RD_38_B_FILTER           0x87

#define RD_40_X_FILTER           0x89

#define RD_42_R_FILTER           0x8B

#define RD_44_B2_FILTER          0x97

#define RD_46_DEBOUNCE_TIME_REG  0xC9
#endif /* CURRENTLY_UNUSED_READ_REGISTERS */

#define COMPRESSED            (0 << 7)
#define LINEAR                (1 << 7)
#define MULAW_BIT             (1 << 6)
#define ALAW_BIT              (0 << 6)
#define EGR_BIT               (1 << 5)
#define EGX_BIT               (1 << 4)
#define EX_BIT                (1 << 3)
#define ER_BIT                (1 << 2)
#define EZ_BIT                (1 << 1)
#define EB_BIT                (1 << 0)

#define ENABLE_PROG_FILTERS (EGR_BIT | EGX_BIT | EX_BIT|ER_BIT | EZ_BIT | EB_BIT)


/**********************************************************************
 **                         QSLAC Port Definitions
 ***********************************************************************/

#define  SLIC_IO_SETUP           0x1E        /*c1: input, c2--c5 output.*/

/* HW information:
   SLIC battery: B2EN=0: VBat2 (-24v)
   B2EN=1: VBat1 (-60v)
			       7	6     5		4   3	2     1	   0
   QSLAC control pin mapping: C7,      C6, CD1B,       C5, C4, C3,  CD2, CD1
      normal (79Q063 -> 79R79):
   QSLAC to SLIC connection:  RING_ON, E1,  n/a,       C3, C2, C1, B2EN, DET
      ENABLE_79Q061_NOT_79Q063 (79Q061 --> 79R79):
   QSLAC to SLIC connection:  n/a,    n/a,  n/a,  RING_ON, C2, C1, B2EN, DET
*/

#define  SLIC_OPEN_CIRCUIT_MODE  (0x00 << 2)
#define  SLIC_RINGING_MODE       (0x01 << 2)
#define  SLIC_ACTIVE_MODE        (0x02 << 2)
#define  SLIC_OHT_MODE           (0x03 << 2)
#ifndef   ENABLE_79Q061_NOT_79Q063
#define  SLIC_TIP_OPEN_MODE      (0x04 << 2)
#define  SLIC_STANDBY_MODE       (0x05 << 2)
#define  SLIC_APR_MODE           (0x06 << 2)
#define  SLIC_OHT_PR_MODE        (0x07 << 2)
#endif /* ENABLE_79Q061_NOT_79Q063 */

#ifndef   ENABLE_79Q061_NOT_79Q063
#define  SLIC_RING_ON            (1 << 7)
#define  SLIC_RING_OFF           (0 << 7)
#else  /* ENABLE_79Q061_NOT_79Q063 */
#define  SLIC_RING_ON            (1 << 4)
#define  SLIC_RING_OFF           (0 << 4)
#endif /* ENABLE_79Q061_NOT_79Q063 */

#define  SLIC_E1_LOOP_START      (1 << 6)
#ifndef   ENABLE_79Q061_NOT_79Q063
#define  SLIC_E1_GROUND_START    (0 << 6)
#endif /* ENABLE_79Q061_NOT_79Q063 */

#define  SLIC_B2EN_ON            (0 << 1)
#define  SLIC_B2EN_OFF           (1 << 1)
#define  SLIC_B2EN_MASK          (1 << 1)


#define  SLIC_DETECT_MASK        0x55     /* for all D1 bits */
#define  SLIC_INT_MASK           0x55     /* for all 4 channels */

#define  SLIC_DET_BIT            0x00

#define  QSLAC_CONF_SETUP        0x01     /*use MCLK, freq=1.544MHz.*/
#define  QSLAC_CLK_EDGE_SETUP    0x40     /*Transmit changes on positive edge of PCLK //was 0x00*/

#define  ENABLE_ALL_CHANNELS     0x0F



/**********************************************************************
 **                             SLACDRV Private structure
 ***********************************************************************/

typedef enum {
	SLIC_OPEN_CIRCUIT,
	SLIC_RINGING,
	SLIC_ACTIVE,
	SLIC_OHT,
#ifndef   ENABLE_79Q061_NOT_79Q063
	SLIC_TIP_OPEN,
	SLIC_STANDBY,
	SLIC_APR,
	SLIC_OHT_PR,
#endif /* ENABLE_79Q061_NOT_79Q063 */
	SLIC_STATE_MAX
} slac_slic_state;

typedef struct {
	unsigned int	source;	   /* TDM Bus Number */
	unsigned int	port;      /* DS0 Number within the TDM bus */
} slac_channel;

typedef struct {
   slac_circuit_type    CircuitType;
   slac_channel         SlacChannel;	/* TDM bus number */		
} slac_channel_info;

typedef struct {
	slac_channel_info    SlacChannelInfo[CHANNELS_PER_QSLAC]; /*4 channels */
} slac_info;


typedef struct {
   unsigned char AISN;
   unsigned char GX[2];
   unsigned char GR[2];
   unsigned char Z[15];
   unsigned char B[14];
   unsigned char X[12];
   unsigned char R[14];
   unsigned char B2[2];
   unsigned char AX;
   unsigned char AR;
} slac_coeff_type;

typedef enum {
   SLAC_A_LAW,
   SLAC_MU_LAW,
} slac_companding_law;

typedef struct {
   unsigned int   NoRingDebounceTimer;    /* detection when not ringing, in millisecond. typical: 1--15ms*/
   unsigned int   RingingDebounceTimer;   /* detection when ringing, in millisecond. typical: 100--150ms */
   unsigned int   B2TransitDebounceTimer;   /* detection after Battery transit, in millisecond. typical: 100--150ms */
} slac_debounce_timer;

typedef struct {
	/* configuration data: */
	unsigned int               ChansInModule;

	struct fasync_struct*   async_queue[CHANNELS_PER_QSLAC]; /*Queue for signals */
	wait_queue_head_t poll_q[CHANNELS_PER_QSLAC]; /*Queuse for poll */
	struct phone_device     PhoneDevice[CHANNELS_PER_QSLAC];/*Phone device associated with SLICs */
	slac_circuit_type CircuitType[CHANNELS_PER_QSLAC];
	slac_channel      SlacChannel[CHANNELS_PER_QSLAC];	      /* TDM bus number */		

	unsigned char                TimeSlotMap[CHANNELS_PER_QSLAC];     /*Time slot on TDM bus */

	/* status data: */
	slac_slic_state   SLICState[CHANNELS_PER_QSLAC];         /* remember what command was issued */

	unsigned char              OpStatus;                              /* One per QSLAC */

	unsigned char                SLACLiveStatus;                        /* the most updated port status */

	unsigned char             SLICEnable[CHANNELS_PER_QSLAC];
	unsigned char                SLICCurrentStatus[CHANNELS_PER_QSLAC];
	unsigned char                SLICCheckStatus[CHANNELS_PER_QSLAC];
	unsigned char                SLICTimerCounter[CHANNELS_PER_QSLAC];
	unsigned char                SLICExceptionFlag[CHANNELS_PER_QSLAC];
	unsigned char                NoRingDBCount[CHANNELS_PER_QSLAC];
	unsigned char                RingingDBCount[CHANNELS_PER_QSLAC];
	unsigned char                B2TransitDBCount[CHANNELS_PER_QSLAC];

} sSLACInfo;

void set_slic_state(U8 ChipNo, U8 Channel, slac_slic_state NewState) ;
void slic_xopen(U8 ChipNo, U8 Channel) ;
#endif  /* SLACPRI_H_INC_ */
/* ************************** End of slacpri.h **************************** */

