/*************************************************************
 * File: lib/a5000.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

/* 
 * Remove most of the code from this file.
 *
 * The code from this file had initialization code for the chip and evm board.
 * One of the things initialized was SDRAM.
 * Code in this file runs from SDRAM....
 * 
 * pmon has already initialized the chip and evm board.
 */

#include <linux/config.h>
#include <linux/sys.h>

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>
#include <asm/offset.h>

#define UART_BASE	0xBC000100	/* Base address to UART            */
#define NSREG(x) ((x)*4)
#define DATA (NSREG(0))	/* data register (R/W)             */
#define IER  (NSREG(1))	/* interrupt enable (W)            */
#define IIR  (NSREG(2))	/* interrupt identification (R)    */
#define	FIFO (NSREG(2))	/* 16550 fifo control (W)          */
#define CFCR (NSREG(3))	/* line control register (R/W)     */
#define MCR  (NSREG(4))	/* modem control register (R/W)    */
#define LSR  (NSREG(5))	/* line status register (R/W)      */
#define MSR  (NSREG(6))	/* modem status register (R/W)     */
#define SCR  (NSREG(7))	/* scratch register (R/W)          */

#define LSR_RXRDY       0x01    /* receiver ready */
#define LSR_TXRDY       0x20    /* transmitter ready */
#define LSR_ERRBRK      0x9e    /* Read UART error, or break */

/*
 * Routine to output a character
 */

NESTED(a5000PrintChar, 0, sp)
	.set	at
	.set	mips32
	.set	noreorder
	mfc0	t0, CP0_STATUS
	mtc0	zero, CP0_STATUS	# disable all interrupts
	nop
	nop
	nop
	.set	reorder
	li	t3,UART_BASE
1:
	lw	t4,LSR(t3)
#	and	t3,t4,LSR_ERRBRK
#	bnez	t3,1b
	and	t4,LSR_TXRDY
	beqz	t4,1b
	sw	a0,DATA(t3)
2:
	lw	t4,LSR(t3)
#	and	t3,t4,LSR_ERRBRK
#	bnez	t3,2b
	and	t4,LSR_TXRDY
	beqz	t4,2b
	nop
	.set	noreorder
	j	ra
	mtc0	t0, CP0_STATUS	# put all interrupts back.
	.set	reorder
END(a5000PrintChar)


NESTED(a5000GetChar, 0, sp)
	.set	at
	.set	mips32
	.set	reorder
	li	t3,UART_BASE
1:
	lw	t4,LSR(t3)
	and	t4,LSR_RXRDY
	beqz	t4,1b
	lw	v0,DATA(t3)
	j	ra
END(a5000GetChar)
