/* #define DEBUG_IRQ_PRINT */

/*
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 1999, 2000 MIPS Technologies, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 * Interrupt exception dispatch code.
 *
 */
#include <linux/config.h>

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>

#ifdef DEBUG_IRQ_PRINT
#define DEBUG_I_P(a) PRINT(a)
#else
#define DEBUG_I_P(a)
#endif

/* A lot of complication here is taken away because:
 *
 * 1) We handle one interrupt and return, sitting in a loop and moving across
 *    all the pending IRQ bits in the cause register is _NOT_ the answer, the
 *    common case is one pending IRQ so optimize in that direction.
 *
 * 2) We need not check against bits in the status register IRQ mask, that
 *    would make this routine slow as hell.
 *
 * 3) Linux only thinks in terms of all IRQs on or all IRQs off, nothing in
 *    between like BSD spl() brain-damage.
 *
 * Furthermore, the IRQs on the BRECIS IC look basically (barring software
 * IRQs which we don't use at all and all external interrupt sources are
 * combined together on hardware interrupt 0 (MIPS IRQ 2)) like:
 *
 *	MIPS IRQ INT#	Source
 *      --------        ------
 *             0        Software Request 0 (ignored)
 *             1        Software Request 1 (Ignored)
 *             2  0	Ethernet MAC 0
 *             3  1     Ethernet MAC 1
 *             4  2     Option 2 (Voice, Packet or Security engine)
 *             5  3     Option 3 (voice, Packet or Security Engine)
 *             6  4     System Logic Module - the ones stuck together
 *             7  5     MIPS Internal Timer
 *
 * We handle the IRQ according to _our_ priority which is:
 *
 * Highest ----     R4k Timer
 * Lowest  ----     Combined hardware interrupt (NOTE: Still to be determined)
 *
 * then we just return, if multiple IRQs are pending then we will just take
 * another exception, big deal.
 */

#define SLM_ERROR_BITS	0x3f00000	// just the error bits
			// 0x3f00300	// clear mask bits

#define CAUSEF_IP23456 \
	(CAUSEF_IP2 | CAUSEF_IP3 | CAUSEF_IP4 | CAUSEF_IP5 | CAUSEF_IP6)

	.text
	.set	noreorder
	.set	noat
	.align	5
	NESTED(mipsIRQ, PT_SIZE, sp)
	SAVE_ALL
#ifdef GMON_PROF
	la	AT,mipsIRQ
	jal	_mcount
	subu	sp,sp,8		# _mcount pops 2 words from  stack
#endif
/* DEBUG_I_P("mipsIRQ\n"); */
	CLI
	.set	at

	mfc0	t0, CP0_CAUSE		# get irq mask

	/* First we check for r4k counter/timer IRQ. */
	andi	a0, t0, CAUSEF_IP7
	beq	a0, zero, 1f
	andi	a0, t0, CAUSEF_IP23456	# delay slot, check hw0 interrupt

	/* Wheee, a timer interrupt. */
	jal	mips_timer_interrupt
	move	a0, sp		# delay slot

	j	ret_from_irq
	nop
1:
	beq	a0, zero, 1f
	nop			# delay slot
	/***
	 *** Combined hardware interrupt for 2,3,4,5, and 6
	 ***/
	jal	brecis_hw0_irqdispatch
	move	a0, sp			#delay slot
	j	ret_from_irq
	nop				# delay slot
1:
	/*
	 * Here by mistake?  This is possible, what can happen is that by the
	 * time we take the exception the IRQ pin goes low, so just leave if
	 * this is the case.
	 */
DEBUG_I_P("mipsIRQ no interrupt to process\n");
	j	ret_from_irq
	nop
	END(mipsIRQ)
