#include "gmon.h"
#include <asm/system.h>

extern struct gmonparam _gmonparam;

#ifdef CHECKSTACK
extern void     xxx_stack_check(unsigned long);
static volatile int dontnestcheckstack = 0;

#define GetSP() ({ unsigned long __v_; __asm__ volatile ("move %0, $29" : "=r" (__v_)); __v_;})
#endif

unsigned int __last32time = 0;
unsigned int __last32perf = 0;

struct _gmon_mcount_struct {
  long long       _gmon_mcount_count;
  long long       _gmon_mcount_off;
  long long       _gmon_mcount_busy;
  long long       _gmon_mcount_error;
  long long       _gmon_mcount_toolowpc;
  long long       _gmon_mcount_toohighpc;
} _gmon_mcount_struct = { 0LL, 0LL, 0LL, 0LL, 0LL, 0LL };

extern int      printk(const char *fmt,...) __attribute__((format(printf, 1, 2)));

/* ------------------------------------------------------------------------ */
void            __mcount(unsigned int frompc, unsigned int selfpc,
	unsigned int now32time, unsigned int now32perf)
{
  unsigned short *frompcindex;
  struct tostruct *top;
  struct tostruct *prevtop;
  struct gmonparam *p;
  long            toindex;
  int             i;

  long long       now64time;
  unsigned int    timediff32;

  long long       now64perf;
  unsigned int    perfdiff32;

#ifdef CHECKSTACK
  if (dontnestcheckstack++ == 0) {
    xxx_stack_check(GetSP());
    dontnestcheckstack--;
  } else {
    dontnestcheckstack--;
    return;
  }
#endif					/* CHECKSTACK */

  if (__last32time > now32time) {		/* if counter wrapped */
    now64time = now32time + 4294967296LL;	/* 2^32 */
  } else {
    now64time = now32time;
  }
  timediff32 = now64time - __last32time;

  if (__last32perf > now32perf) {		/* if counter wrapped */
    now64perf = now32perf + 4294967296LL;	/* 2^32 */
  } else {
    now64perf = now32perf;
  }
  perfdiff32 = now64perf - __last32perf;

  p = &_gmonparam;
  _gmon_mcount_struct._gmon_mcount_count++;

  switch (p->state) {
    case GMON_PROF_OFF:;
      _gmon_mcount_struct._gmon_mcount_off++;
      goto clearthisroutineusage;
    case GMON_PROF_BUSY:
      _gmon_mcount_struct._gmon_mcount_busy++;
      goto clearthisroutineusage;
    case GMON_PROF_ERROR:
      _gmon_mcount_struct._gmon_mcount_error++;
      goto clearthisroutineusage;
    case GMON_PROF_ON:
      p->state = GMON_PROF_BUSY;
      break;
    default:
      printk("unknown _gmonparam_state=%ld\n", p->state);
      goto clearthisroutineusage;
  }

 /*
  * check that frompcindex is a reasonable pc value.
  * for example:	signal catchers get called from the stack,
  *		not from text space.  too bad.
  */
  if (frompc < p->lowpc) {
/* printk("frompc (%8.8x) < lowpc (%8.8lx) -- selfpc=%8.8x\n", frompc, p->lowpc, selfpc); */
    _gmon_mcount_struct._gmon_mcount_toolowpc++;
    goto done;
  }
  frompc -= p->lowpc;
  if (frompc > p->textsize) {
/* printk("frompc (%8.8lx) above textend (%8.8lx) -- selfpc=%8.8x\n", frompc+p->lowpc, p->lowpc+p->textsize, selfpc); */
    _gmon_mcount_struct._gmon_mcount_toohighpc++;
    goto done;
  }

 /* The following test used to be if (p->log_hashfraction >= 0) But we can simplify this if we assume
    the profiling data is always initialized by the functions in gmon.c.  But then it is possible to
    avoid a runtime check and use the smae `if' as in gmon.c.  So keep these tests in sync.  */
/* 	if ((HASHFRACTION & (HASHFRACTION - 1)) == 0) { */
 /* avoid integer divide if possible: */
/* 	    i = frompc >> p->log_hashfraction; */
/* 	} else { */
  i = frompc / (p->hashfraction * sizeof(*p->froms));
/* 	} */
  frompcindex = &p->froms[i];
  toindex = *frompcindex;
  if (toindex == 0) {		/* first time traversing this arc */
    goto initialize_link;
  }
  top = &p->tos[toindex];
  if (top->selfpc == selfpc) {	/* arc at front of chain; usual case. */
    goto increment_link;
  }
/* have to go looking down chain for it. top points to what we are looking at,
   prevtop points to previous top. we know it is not at the head of the chain. */
  for (; /* goto done */ ;) {
    if (top->link == 0) {
/* top is end of the chain and none of the chain had top->selfpc == selfpc.
   so we allocate a new tostruct and link it to the head of the chain.  */
 initialize_link:
      toindex = ++p->tos[0].link;
      if (toindex >= p->tolimit) {
	goto overflow;
      }
      top = &p->tos[toindex];
      top->selfpc = selfpc;
      top->count = 1;
      top->timediff = timediff32;
      top->timeminimum = timediff32;
      top->timemaximum = timediff32;
      top->performance_count = perfdiff32;
      top->performance_count_minimum = perfdiff32;
      top->performance_count_maximum = perfdiff32;
      top->link = *frompcindex;
      *frompcindex = toindex;
      goto done;
    }
/* otherwise, check the next arc on the chain.  */
    prevtop = top;
    top = &p->tos[top->link];
    if (top->selfpc == selfpc) {
/* there it is.  move it to the head of the chain.  Increment counters. */
      toindex = prevtop->link;
      prevtop->link = top->link;
      top->link = *frompcindex;
      *frompcindex = toindex;
 increment_link:
      top->count++;
      top->timediff += timediff32;
      if (timediff32 < top->timeminimum) {
	top->timeminimum = timediff32;
      }
      if (timediff32 > top->timemaximum) {
	top->timemaximum = timediff32;
      }
      top->performance_count += perfdiff32;
      if (perfdiff32 < top->performance_count_minimum) {
	top->performance_count_minimum = perfdiff32;
      }
      if (perfdiff32 > top->performance_count_maximum) {
	top->performance_count_maximum = perfdiff32;
      }
      goto done;
    }
  }
done:
  p->state = GMON_PROF_ON;
clearthisroutineusage:
  return;

overflow:
  printk("__mcount overflow error\n");
  p->state = GMON_PROF_ERROR;
  goto clearthisroutineusage;

}

/* ------------------------------------------------------------------------ */
