/*-
 * Copyright (c) 1983, 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <linux/stddef.h>
#include <linux/mm.h>
#include <linux/slab.h>
#include <linux/bootmem.h>
#include "gmon.h"

struct gmonparam _gmonparam = {GMON_PROF_OFF};

extern unsigned int __last32time;
extern unsigned int __last32perf;

/* Note: #define CP0_COUNT $9 */
#define Get_COP_0_COUNT() ({ unsigned long __v_; __asm__ volatile ("mfc0 %0, $9" : "=r" (__v_)); __v_;})

/*
 * See profil(2) where this is described:
 */
/* static int	s_scale; */


void            moncontrol(int mode);
void            __moncontrol(int mode);

/* ------------------------------------------------------------------------ */
/*
 * Control profiling
 *	profiling is what mcount checks to see if
 *	all the data structures are ready.
 */
void            __moncontrol(mode)
int             mode;
{
  struct gmonparam *p = &_gmonparam;

  /* Don't change the state if we ran into an error.  */
  if (p->state == GMON_PROF_ERROR)
    return;

  if (mode) {
/* start */
/*       __profil((void *) p->kcount, p->kcountsize, p->lowpc, s_scale); */
    p->state = GMON_PROF_ON;
  } else {
/* stop */
/*       __profil(NULL, 0, 0, 0); */
    p->state = GMON_PROF_OFF;
  }
}

/* ------------------------------------------------------------------------ */
void            __monstartup(lowpc, highpc)
unsigned long   lowpc;
unsigned long   highpc;
{
  int             o;
  char           *cp;
  struct gmonparam *p = &_gmonparam;

  /*
   * round lowpc and highpc to multiples of the density we're using
   * so the rest of the scaling (here and in gprof) stays in ints.
   */
  p->lowpc = ROUNDDOWN(lowpc, HISTFRACTION * sizeof(HISTCOUNTER));
  p->highpc = ROUNDUP(highpc, HISTFRACTION * sizeof(HISTCOUNTER));
  p->textsize = p->highpc - p->lowpc;
  p->kcountsize = 0;
  p->hashfraction = HASHFRACTION;
  p->log_hashfraction = -1;
  p->fromssize = p->textsize / HASHFRACTION;
  p->tolimit = p->textsize * ARCDENSITY / 100;

  if (p->tolimit < MINARCS)
    p->tolimit = MINARCS;
  else if (p->tolimit > MAXARCS)
    p->tolimit = MAXARCS;
  p->tossize = p->tolimit * sizeof(struct tostruct);

  cp = (char *) alloc_bootmem(p->fromssize + p->tossize);
  if (cp == NULL) {
    printk("monstartup: out of memory\n");
    return;
  }
  p->tos = (struct tostruct *) cp;
  cp += p->tossize;
  p->kcount = NULL;
  p->froms = (u_short *) cp;

  p->tos[0].link = 0;

  o = p->highpc - p->lowpc;
  __moncontrol(1);

/* Initialize saved counter */
/* PERF_MON_CTL_REG_Instruction_Complete */
 *((volatile unsigned int*)(0xBC000140)) = 0x01;	/* Instruction_Complete */
/*  *((volatile unsigned int*)(0xBC000140)) = 0x02; */	/* Data_Cache_Hit */
/*  *((volatile unsigned int*)(0xBC000140)) = 0x04; */	/* Data_Cache_Miss */
/*  *((volatile unsigned int*)(0xBC000140)) = 0x08; */	/* Instruction_Cache_Hit */
/*  *((volatile unsigned int*)(0xBC000140)) = 0x10; */	/* Instruction_Cache_Miss */

  *((volatile unsigned int*)(0xBC000144)) = 0x00;	/* Clear performance counter */

  __last32perf = 0;					/* assumption. */
  __last32time = Get_COP_0_COUNT();
}

/* ------------------------------------------------------------------------ */
