/* $Header: /proj/software/pub/CVSROOT/uClinux/brecis/ve-api/tdmdvrtest.c,v 1.31 2002/12/30 21:59:08 tld Exp $ */
/* ************************************************************************ *
 *
 * tdmdvrtest.c
 *
 *                  Copyright 2002, Brecis Communications
 *
 * Originator: TL Donahue
 *
 *          [Generated by tld on Fri 23 Aug 2002 at 20:11:41 UTC]
 * ************************************************************************ */
#include <linux/config.h>	/* for config variables */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <signal.h>
#include <assert.h>
#include <sys/resource.h> /* for process priority functions */
#include <errno.h>
#include <libgen.h>	/* for basename() */
#include <sys/ioctl.h>
#include <sys/wait.h>	/* for WXXX() macros */

#include <asm/brecis/BrecisSysRegs.h>   /* for device ID */
#include <asm/brecis/BrecisSysReset.h>  /* for PER_RST */

#include "brecis_tdmsdma_dvr.h"

static int exit_now=0;

static void int_sig(int sig)
{
	exit_now = (~0);
}

#define DEFAULT_PROCESS_PRIORITY (0)	/* 19 (low) -- -20 (high) */

static void print_usage(char *argv0)
{
	fprintf(stderr, "usage: %s\n", basename(argv0));
	fprintf(stderr, "  [-h] -- help (this message)\n");
	fprintf(stderr, "  [-m <debug level>] -- set debug level of TDM driver\n");
	fprintf(stderr, "  [-p <priority>] -- CAUTION! set process priority (default %d)\n",
		DEFAULT_PROCESS_PRIORITY);
	fprintf(stderr, "  [-r <RX frames> -- RX frames in buffer]\n");
	fprintf(stderr, "  [-t <TX frames> -- TX frames in buffer]\n");
	fprintf(stderr, "  [-c <RX burst cnt> -- RX burst cnt]\n");
	fprintf(stderr, "  [-b <TX burst cnt> -- TX burst cnt]\n");
	fprintf(stderr, "  [-s <slots>] -- TDM slots\n");
	fprintf(stderr, "  [-M <mask>] -- TDM unmasked slots (1=unmasked, 0=masked)\n");
	fprintf(stderr, "  [-n] -- open as non-blocking\n");
	fprintf(stderr, "  [-x] -- transmit data\n");
	fprintf(stderr, "  [-g] -- read data\n");
	fprintf(stderr, "  [-d] -- dump transmit data\n");
	fprintf(stderr, "  [-e] -- perror() strings\n");
	fprintf(stderr, "  [-R] -- start receive DMA\n");
	fprintf(stderr, "  [-T] -- start transmit DMA\n");
	fprintf(stderr, "  [-S] -- <special flags>\n");
	fprintf(stderr, "  [-L] -- 0 = no ILB, not 0 = ILB\n");
	fprintf(stderr, "  [-O] -- <Port 1 Time Slot offset>\n");
	fprintf(stderr, "  [-C] -- <SLAC clock in KHz>\n");
	fprintf(stderr, "  [-V] -- show version and exit\n");
}

void do_script_command(char *cmd)
{
	int ret=system(cmd);

	if (-1 == ret)
	{
		fprintf(stderr, "Can't execute \"%s\"\n", cmd);
		exit(3);
	}
	if (0 != WIFEXITED(ret))
	{
		/* normal exit -- can check exit status */
		if (0 != WEXITSTATUS(ret))
		{
			fprintf(stderr, "\"%s\" returned non-zero: %d\n",
				cmd, WEXITSTATUS(ret));
		}
	}
	return;
}

static int number_option(int *output, char *optstring)
{
    long temp=0;
    char *endptr;

    temp = strtoul(optstring, &endptr, 0);
    /* test for error */
    if (*endptr != '\0')
    {
        return (~0);
    }
    else
    {
        *output = temp;
    }
    return 0;
}

static void perror_strings(void)
{
	int error;

	for (error=1; error <= EMEDIUMTYPE; error++)
	{
		char buf[10];

		errno = error;
		snprintf(buf, sizeof(buf)-1, "%4d", errno);
		perror(buf);
	}
}

static void tdm_clocks(void)
{
	while(*SYS_RST_REG & PER_RST)
	{
		fprintf(stderr, "Awaiting peripheral block out of reset\n");
	}
	fprintf(stderr, "Peripheral block out of reset\n");
	/* some magic moved to TDM driver conditioned on CONFIG_BRECIS_FPGA */
}

inline static int count_bits(unsigned int mask)
{
	int cnt=0;
	unsigned int more_bits=(~0);

	while (more_bits)
	{
		if (mask & 1){++cnt;} /* count a 1 bit */
		mask >>= 1; /* get the next bit to test */
		more_bits <<= 1; /* will be 0 when all bits positions tested */
	}
	return cnt;
}

static TDM_IOCTL_BURST burst={0};
static int DMA_slots=0;
static unsigned int opt_M=0;	/* 0 = use default from driver */

static void ioctl_test(int fd, int slots, int r, int t, int c, int b)
{
	{
		TDM_IOCTL_CONFIG config={0};

		config.slots = slots;
		config.rx_frames_in_buffer = r;
		config.tx_frames_in_buffer = t;
		config.rx_active_time_slot_mask = opt_M;
		config.tx_active_time_slot_mask = opt_M;
		if (-1 == ioctl(fd, TDMSDMA_DVR_IOC_CONFIG, &config))
		{
			perror("CONFIG");
			return;
		}
		assert(config.rx_active_time_slot_mask == config.rx_active_time_slot_mask);
		assert(((config.slots >= 1) && (config.slots <= 4)) ||
			(config.slots == 24) || (config.slots == 32));
		DMA_slots = count_bits(config.rx_active_time_slot_mask);
		if (config.slots > DMA_slots)
		{
			fprintf(stderr, "***** INFO: with unmasked slots"
				" 0x%08x only %d slot(s) of %d"
				" between frame syncs visible to DMA!\n",
				config.rx_active_time_slot_mask,
				DMA_slots,
				config.slots);
		}
		else
		{
			if (config.slots < DMA_slots)
			{
				fprintf(stderr, "***** ERROR: %d is too many"
					" slot(s) in mask 0x%08x for"
					" slots between frame syncs %d!\n",
					DMA_slots,
					config.rx_active_time_slot_mask,
					config.slots);
				exit(2);
			}
		}
		fprintf(stderr, "CONFIG: slots: %d  RX: %d  TX: %d"
			"  RX Mask: 0x%08x  TX Mask: 0x%08x\n",
			config.slots,
			config.rx_frames_in_buffer,
			config.tx_frames_in_buffer,
			config.rx_active_time_slot_mask,
			config.tx_active_time_slot_mask);
	}
	{
		burst.rx_burst_cnt = c;
		burst.tx_burst_cnt = b;
		if (-1 == ioctl(fd, TDMSDMA_DVR_IOC_BURST, &burst))
		{
			perror("BURST");
			return;
		}
		fprintf(stderr, "BURST: RX: %d  TX: %d  SZ: %d\n",
			burst.rx_burst_cnt, burst.tx_burst_cnt, burst.burst_length);
	}
}

static void dump(unsigned char *data, int len)
{
	int indx;
	enum {line_len=16};

	for (indx = 0; indx < len; indx++)
	{
		if ((0 == indx % line_len) && indx){printf("\n");}
		else
		if ((0 == indx % (line_len/2)) && indx){printf(" --");}
		printf(" %02x", data[indx]);
	}
	printf("\n");
}

#define MAX_BURST_SIZE	(32)
#define MAX_TIME_SLOTS	(32)

static unsigned char xBuffer[MAX_TIME_SLOTS*MAX_BURST_SIZE]={0};
static unsigned char gBuffer[MAX_TIME_SLOTS*MAX_BURST_SIZE]={0};

static unsigned int sysGetPllDivider(int getPLLOne)
{
	/* use PLL 0 if parameter is 0, else use PLL 1 */
	/*   conveniently, 0 uses PLL 0, 1 uses PLL 1 */
	/* use register names from 4000/5000, even though Polo has new names */
	enum {PLL_DIVIDER_MASK=0x1F, PLL_OUT_OF_RANGE_DIVIDER=0x00000008};
	enum {PLL_1_HI_RANGE_SHIFT=24, PLL_1_LO_RANGE_SHIFT=16,
		PLL_0_HI_RANGE_SHIFT=8, PLL_0_LO_RANGE_SHIFT=0,
		PLL_RANGE_MASK=0x1F};
	unsigned int pllDivider=((getPLLOne) ?
		(*PCM3_CLK_REG) : (*PLL_DIV_REG));
	unsigned int pllRangeHI=((*PCM1_CLK_REG >>
		((getPLLOne) ? PLL_1_HI_RANGE_SHIFT : PLL_0_HI_RANGE_SHIFT))
		& PLL_RANGE_MASK);
	unsigned int pllRangeLO=((*PCM1_CLK_REG >>
		((getPLLOne) ? PLL_1_LO_RANGE_SHIFT : PLL_0_LO_RANGE_SHIFT))
		& PLL_RANGE_MASK);

	/* compute number of half steps */
	pllDivider = ((pllDivider & PLL_DIVIDER_MASK)*2) |
		((pllDivider & (1 << 31)) ? 1 : 0);
	/* check range -- NOTE: extra 1/2 step can put divider outside range! */
	if ((pllDivider > (pllRangeHI*2)) || (pllDivider < (pllRangeLO*2)))
	{
		pllDivider = PLL_OUT_OF_RANGE_DIVIDER*2;
		/* write back the default on out-of-range condition */
		if (getPLLOne)
		{
			*PCM3_CLK_REG = PLL_OUT_OF_RANGE_DIVIDER;
		}
		else
		{
			*PLL_DIV_REG = PLL_OUT_OF_RANGE_DIVIDER;
		}
	}

	/* return half-steps */
	return (pllDivider);
}

int main(int argc, char **argv)
{
	int opt_mdebug_level=0;
	int opt_special_flags=0;
	int opt_S_present=0;
	int opt_priority=DEFAULT_PROCESS_PRIORITY;
	int opt_slots=24;
	int opt_R=0;
	int opt_T=0;
	int opt_r=0;
	int opt_t=0;
	int opt_c=0;
	int opt_b=0;
	int opt_n=0;
	int opt_x=0;
	int opt_g=0;
	int opt_d=0;
	int opt_L=0;
	int opt_O=0;
	int opt_C=0;
	int fd;

	{
		int option;

		while (-1 != (option = getopt(argc, argv, "hm:p:s:eVRTr:t:c:b:nxgdM:S:LO:C:")))
		{
			switch (option)
			{
				case 'm':
					if (number_option(&opt_mdebug_level, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					break;
				case 'S':
					if (number_option(&opt_special_flags, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					opt_S_present = (~0);
					break;
				case 'p':
					if (number_option(&opt_priority, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					if (opt_priority > 19){opt_priority = 19;}
					if (opt_priority < -20){opt_priority = -20;}
					break;
				case 'r':
					if (number_option(&opt_r, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					break;
				case 't':
					if (number_option(&opt_t, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					break;
				case 'c':
					if (number_option(&opt_c, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					break;
				case 'b':
					if (number_option(&opt_b, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					break;
				case 's':
					if (number_option(&opt_slots, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					break;
				case 'M':
					if (number_option(&opt_M, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					break;
				case 'e':
					perror_strings();
					exit(0);
				case 'h':
					print_usage(argv[0]);
					exit(0);
				case 'V':
					fprintf(stderr, "%s %s %s\n", basename(argv[0]), __DATE__, __TIME__);
					exit(0);
				case 'R':
					opt_R = (~0);
					break;
				case 'T':
					opt_T = (~0);
					break;
				case 'n':
					opt_n = (~0);
					break;
				case 'x':
					opt_x = (~0);
					break;
				case 'g':
					opt_g = (~0);
					break;
				case 'd':
					opt_d = (~0);
					break;
				case 'L':
					opt_L = (~0);
					break;
				case 'O':
					if (number_option(&opt_O, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					break;
				case 'C':
					if (number_option(&opt_C, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					break;
				default: /* intentionally falls through */
				case '?':
					print_usage(argv[0]);
					exit(1);

			}
		}
	}
	if (SIG_ERR == signal(SIGQUIT, int_sig))
	{
		fprintf(stderr, "sig registration failed\n");
	}
	{
		/* not compatibility mode so do the preliminaries */
		do_script_command("rmmod brecis_slac_dvr 2>/dev/null");
		do_script_command("rmmod brecis_tdmsdma_dvr 2>/dev/null");
		{
			char cmd[80];

			snprintf(cmd, sizeof(cmd), "insmod brecis_slac_dvr"
				" loopback=%d tsoffset=%d clock=%d",
				opt_L, opt_O, opt_C);
			do_script_command(cmd);
		}
		{
			char cmd[80];

			if (opt_S_present)
			{
				snprintf(cmd, sizeof(cmd), "insmod brecis_tdmsdma_dvr dlvl=0x%08x special=0x%08x",
					opt_mdebug_level, opt_special_flags);
			}
			else
			{
				snprintf(cmd, sizeof(cmd), "insmod brecis_tdmsdma_dvr dlvl=0x%08x",
					opt_mdebug_level);
			}
			do_script_command(cmd);
		}
		{
			unsigned int devID=(*DEV_ID_REG);

			switch ((devID >> 8) &0xFF)
			{
				case 0x20:
					switch ((devID & 0x00070000) >> 16)
					{
						case 0x05:	/* 2020 */
							/* program a reasonalble value for TDM clock */
							{
								long long baseFreq=(25000000LL*(long long)sysGetPllDivider(0))/2LL;
								unsigned int divider=(unsigned int)((((long long)((opt_C) ? (opt_C*1000LL) : 1544000LL))*(1LL << 32))/baseFreq);

								*PCM0_CLK_REG = divider;
								fprintf(stderr, "[0x%08x]: %u (%u) %u\n",
									(unsigned int)PCM0_CLK_REG,
									*PCM0_CLK_REG, divider, sysGetPllDivider(0));
							}
							break;
						case 0x01:	/* 2005 */
						case 0x02:	/* 2007 */
						case 0x03:	/* 2010 */
						case 0x06:	/* 2100 */
						default:
							fprintf(stderr, "Unknown device ID: 0x%08x\n", devID);
							exit(4);
					}
				case 0x50:
					break;
				case 0x40:
					break;
#ifdef    CONFIG_BRECIS_FPGA
				case 0x00:
					break;
#endif /* CONFIG_BRECIS_FPGA */
				default:
					fprintf(stderr, "Unknown device ID: 0x%08x\n", devID);
					exit(4);
			}
		}
	}
	{
		int current_priority;
		int new_priority;

		errno = 0;	/* see man page */
		current_priority = getpriority(PRIO_PROCESS,
			0 /* current process */);
		if (current_priority != opt_priority)
		{
			/* only adjust priority if not already at requested value */
			if (setpriority(PRIO_PROCESS,
				0 /* current process */, opt_priority) == -1)
			{
				perror("setpriority()");
			}
			errno = 0;
			new_priority = getpriority(PRIO_PROCESS,
				0 /* current process */);
			fprintf(stderr, "Process priority set to: %d [was: %d]\n",
				new_priority, current_priority);
		}
	}
	fd = open(BRECIS_TDMSDMA_API, O_RDWR |
		((opt_n) ? O_NONBLOCK : 0)); /* open non-blocking if requested */
	if (fd < 0)
	{
		perror(BRECIS_TDMSDMA_API);
		exit(1);
	}
	/* configure clock -- maybe temporary */
	tdm_clocks();
	ioctl_test(fd, opt_slots, opt_r, opt_t, opt_c, opt_b);
	if (opt_R || opt_T)
	{
		int startDMA=0;
		int bytes=burst.burst_length*burst.tx_burst_cnt;

		if (opt_x)
		{
			/* initialize transmit buffer */
			int indx;

			for (indx = 0; indx < bytes; indx++)
			{
				xBuffer[indx] = 0x80 |
					((((indx % DMA_slots)+1) << 1) & 0x7e);
			}
			if (opt_d){dump(xBuffer, bytes);}
			if (-1 == write(fd, xBuffer, bytes))
			{
				perror("***** TX");
			}
		}
		if (opt_R){startDMA |= TDM_RX;}
		if (opt_T){startDMA |= TDM_TX;}
		if (-1 == ioctl(fd, TDMSDMA_DVR_IOC_START, &startDMA))
		{
			perror("START");
			exit(255);
		}
		if (!opt_x && !opt_g)
		{
			/* if no real I/O is requested, just sleep until awakened */
			/* even though the arg is unsigned, can't use ~0 */
			sleep(0x7fffffff);
			exit(0);
		}
		if (!opt_n)
		{
			while (!exit_now)
			{
				if (opt_g) /* blocking read */
				{
					int rc=read(fd, gBuffer, bytes);

					if (-1 == rc)
					{
						perror("***** READ");
						exit(1);
					}
					if (rc != bytes)
					{
						fprintf(stderr, "READ expected: %d actual %d\n",
							bytes, rc);
					}
					{
						static int Once=0;

						if (!Once)
						{
							dump(gBuffer, bytes);
							Once = (~0);
						}
					}
				}
				if (opt_x) /* blocking write */
				{
					int rc=write(fd, xBuffer, bytes);

					if (-1 == rc)
					{
						perror("***** WRITE");
						exit(1);
					}
					if (rc != bytes)
					{
						fprintf(stderr, "WRITE expected: %d actual %d\n",
							bytes, rc);
					}
				}
			}
			exit(0);
		}
		else
		{
			while (!exit_now)
			{
				if (opt_g) /* non-blocking read */
				{
					int rc;
					
					while(-1 == (rc=read(fd, gBuffer, bytes)))
					{
						if (EAGAIN != rc)
						{
							perror("***** nREAD");
							exit(1);
						}
					}
					if (rc != bytes)
					{
						fprintf(stderr, "nREAD expected: %d actual %d\n",
							bytes, rc);
					}
				}
				if (opt_x) /* non-blocking write */
				{
					int rc;
					
					while(-1 == (rc=write(fd, xBuffer, bytes)))
					{
						if (EAGAIN != rc)
						{
							perror("***** nWRITE");
							exit(1);
						}
					}
					if (rc != bytes)
					{
						fprintf(stderr, "nWRITE expected: %d actual %d\n",
							bytes, rc);
					}
				}
			}
			exit(0);
		}
	}
	else
	{
		static char spinner[]="|/-\\";
		int ctr=0;

		for(;;)
		{
			ctr %= 4;
			fprintf(stderr, "%c\r", spinner[ctr++]);
			sleep(1);
			if (exit_now)break;
		}
	}
	if (close(fd))
	{
		perror(BRECIS_TDMSDMA_API);
		exit(2);
	}
	fprintf(stderr, "device closed\n");
	return 0;
}

/* ************************ End of tdmdvrtest.c *************************** */
