#define    DEBUG_MSPVPMAPI
/* $Header: /proj/software/pub/CVSROOT/uClinux/brecis/ve-api/mspvpmapi.c,v 1.12 2003/03/07 17:03:11 tld Exp $ */
/* ************************************************************************ *
 *
 * mspvpmapi.c
 *
 *                  Copyright 2002, Brecis Communications
 *
 * Originator: TL Donahue
 *
 *          [Generated by tld on Tue 14 May 2002 at 20:40:22 UTC]
 * ************************************************************************ */
#include <stdio.h>	/* printf() */
#include <fcntl.h>
#include <signal.h>
#include <string.h>	/* memcpy() */
#include <sys/ioctl.h>	/* ioctl() */
#include <unistd.h>	/* read() and write() */
#include <errno.h>

#include "mspCommon.h"
#include "mspvpmapi.h"
#include "mspVeDef.h"
#include "mspVeStruct.h"
#include "brecis_vpm_dvr.h"
#include "mspCESVPMDefs.h"
#include "mspVOPVPMDefs.h"


/*
 * Maintain a handle to the VPM local to the API implementation and
 *  hidden from the user.
 */	
#define INVALID_FILE_DESCRIPTOR	(-1)
static int vpm_fd=INVALID_FILE_DESCRIPTOR;

static int MspVpmSendCmdDefer(msp_vpm_cmd *cmd, void *unused,
	void *response, U32 callerRefId)
{
	VPM_COMMAND_RESPONSE cmd_rsp;

	if (INVALID_FILE_DESCRIPTOR == vpm_fd)
	{
		/* MspVpmStartBlkDev() not successfully called */
		return ~MSP_SUCCESS;
	}
	{
		int rc;

		memcpy(cmd_rsp.command, cmd, sizeof(msp_vpm_cmd));
		rc = ioctl(vpm_fd, MSP_VPM_DVR_IOC_API, &cmd_rsp);
		if (rc < 0)
		{
			return MSP_VPM_BCOPY_ERROR;
		}
	}
	// ????? what about commands that return data?
	// ????? should probably get copied into *response
	switch (cmd->cmdHdr.cmdId)
	{
		case DIVPM_TESTRESPONSE_CMD:
			memcpy(response, cmd_rsp.response, sizeof(cmd_rsp.response));
			break;
		default:
			break;
	}
	*(U32 *)response = cmd_rsp.return_code;
	return cmd_rsp.return_code;
}

static int MspVpmCESTDMEnableCheck(U32 tdmHighway)
{
	static int Once=0;

	if (!Once)
	{
		/* allocate buffers */
		// ????? should be from kernel space
		// ????? non-cached?  special IOCTL to get memory?
//		if (0 != ces_buffers)	// ????? temporarily disable
		{
			return MSP_SUCCESS;
		}
	}
	else
	{
		// ????? should actually look to see if tdmHighway is
		// ?????  configured for CES -- how to tell with no
		// ?????  global data?
		return (MSP_VPM_TDM_NOT_CONFIG_FOR_CES);
	}
	return (~MSP_SUCCESS);
}

/****************************************************************************/
/*																			*/
/*	function:	MspVpmCESTDMCfgCheck										*/
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*	Tony Raetz:10-19-2001	: Initial version of function					*/
/*																			*/
/****************************************************************************/
/*	Description:															*/
/*																			*/
/*	Input:																	*/
/*																			*/
/*	Output:																	*/
/*																			*/
/****************************************************************************/

static U32 MspVpmCESTDMCfgCheck(U32 tdmHighway,
		U32 tdmFrameType,
		U32 tdmClockSource,
   		U32 tdmDSOTimeSlotMask,
   		U32 tdmNumberOfFramesPerBuffer
#ifdef    USE_GLOBAL_VPM_DATA
   		,void * pUserRxFunc)
#else  /* USE_GLOBAL_VPM_DATA */
		)
#endif /* USE_GLOBAL_VPM_DATA */
{
	U32 returnValue = 0;
	U32 FrameTypeMask;
#ifdef    USE_GLOBAL_VPM_DATA
	tdmb_ces_descriptor *pCESTDMHighwayConfig;	
#endif /* USE_GLOBAL_VPM_DATA */

	if(tdmFrameType == CES_E1_FRAME)
	{
		FrameTypeMask = CES_TDM_E1_INVALID_TIMESLOT_MASK;
	}
	else
	{
		FrameTypeMask = CES_TDM_DS1_INVALID_TIMESLOT_MASK;
	}
	if(tdmHighway > CES_TDM_HIGHWAY_1)
	{
		return(MSP_VPM_INVALID_TDM_HIGHWAY);
	}
	if(tdmFrameType > CES_E1_FRAME)
	{
		return(MSP_VPM_UNUSED_ERROR_VALUE_36);
	}
	if(tdmClockSource >  TDMB1_PCM_DERIVED_CLOCK)
	{
		return(MSP_VPM_UNUSED_ERROR_VALUE_37);
	}
	if((tdmHighway ==  CES_TDM_HIGHWAY_0) &&
		(tdmDSOTimeSlotMask & FrameTypeMask))
	{
		return(MSP_VPM_INVALID_TIMESLOT_MASK);
	}
	if((tdmHighway ==  CES_TDM_HIGHWAY_1) &&
		(tdmDSOTimeSlotMask & FrameTypeMask))
	{
		return(MSP_VPM_INVALID_TIMESLOT_MASK);
	}
	if((tdmNumberOfFramesPerBuffer < CES_MIN_TDM_FRAMES_PER_BUFFER) ||	
		(tdmNumberOfFramesPerBuffer > CES_MAX_TDM_FRAMES_PER_BUFFER))
	{
		return(MSP_VPM_INVALID_NUM_FRAMES_PER_BUFFER);
	}

#ifdef    USE_GLOBAL_VPM_DATA
	pCESTDMHighwayConfig = MspVpmGetCESHighConfigPtr(tdmHighway);

	if(pCESTDMHighwayConfig->vpmCESTdmbEnableState < CES_ENABLED)
	{
		pCESTDMHighwayConfig->vpmCESTdmbTDMFrameType 		=  tdmFrameType;
		pCESTDMHighwayConfig->vpmCESTdmbClockSource 		=  tdmClockSource;
		pCESTDMHighwayConfig->vpmCESTdmbNumPCMFramesPerBlk 	=  tdmNumberOfFramesPerBuffer;
		pCESTDMHighwayConfig->vpmCESTdmbActiveSlotsMask		=  tdmDSOTimeSlotMask;
		pCESTDMHighwayConfig->vpmCESFrameSize				=  (frameWidth[pCESTDMHighwayConfig->vpmCESTdmbTDMFrameType] *
																tdmNumberOfFramesPerBuffer);
		pCESTDMHighwayConfig->vpmCESTdmbEnableState			=  CES_CONFIGURED;
		pCESTDMHighwayConfig->pFunc						    =  pUserRxFunc;
		pCESTDMHighwayConfig->pCESPrivateBufferFifo		=  NULL;
	}
	else
	{
		return(MSP_VPM_INVALID_STATE_FOR_CONFIG);
	}
#endif /* USE_GLOBAL_VPM_DATA */

	return(returnValue);
}

/****************************************************************************/
/*																			*/
/*	Function:	MspVpmStartDev												*/
/*	Copyright:  Brecis Communications 2002									*/
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*	Tony Raetz:11-19-2002	: Initial version of function					*/
/*																			*/
/****************************************************************************/
/*	Description:															*/
/*  Upon competion of the firmware download                                 */
/*  The VE will respond with a Ping interrupt.  The VE will then call the   */
/*  the function MspVeSetResponseEventQ.  When the VE responds from this  	*/
/*  call the initial function passed in by the user will be invoked.  Until */
/*  the user gets a response from the VE via the callback function it is    */
/*  not to send any requests to the VE via the serialization task.			*/
/*																			*/
/*	Input																	*/
/*  None.                                                                   */
/*	Output:																	*/
/*	Return Value:  Value indicates command failure or success.  Success = 0 */
/*				   failure = a non-zero value. 								*/
/*																			*/
/****************************************************************************/

U32 MspVpmStartBlkDev(void)
{

	vpm_fd = open(BRECIS_MSP_VPM_API, O_RDWR);
	if (vpm_fd < 0)
	{
#ifdef    DEBUG_MSPVPMAPI
		perror(BRECIS_MSP_VPM_API ": ");
#endif /* DEBUG_MSPVPMAPI */
		return (-1);	// ?????
	}
	/* nothing else to do yet */
	return MSP_SUCCESS;
}

/****************************************************************************/
/*							   												*/
/*	function:	MspVpmSetCompandorBlkTdmb									*/
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*	Tony Raetz:11/19/2002	: Initial version of function (Linux)   		*/
/*																			*/
/****************************************************************************/
/*	Description:															*/
/*  																		*/
/*	This function is used to set the companding type in use on the TDM		*/
/*  busses.  Two companding methods are supported, A_Law and u_Law.			*/
/*																			*/
/*	Input:																	*/
/*		compandingType:	1 = G.711 u_Law, 2 = G.711 A_Law.					*/
/*																			*/
/*	Output:																	*/
/*		U32:  Contains response information from the unset event attempt.   */
/* 		The return value will be 0 for success and any other value for 		*/
/*		failure.															*/
/*																			*/
/****************************************************************************/
U32 MspVpmSetCompandorBlkTdmb(U32 compandingType)
{
	msp_vpm_companding *cbMessage;
	msp_vpm_cmd commandMsg;
	U32 compandingSetStatus, returnValue = MSP_SUCCESS;

	if ((compandingType < MSP_VPM_COMPANDING_G711U) ||
	    (compandingType > MSP_VPM_COMPANDING_G711A))
	{
		returnValue =  MSP_VPM_INVALID_COMPANDING_TYPE;
	}
	else
	{
		cbMessage = (msp_vpm_companding *) &commandMsg;
		cbMessage->cmdHdr.cmdId                 = DIVPM_CNFG_CMPNDR_CMD;
		cbMessage->cmdHdr.cmdLen                = 5;
		cbMessage->cmdHdr.hsHandleHigh          = MSP_ALL_ONES_16BITS;
		cbMessage->cmdHdr.hsHandleLow           = MSP_VPM_EVENT_RECORD_VALID;
		cbMessage->compandingType               = compandingType;

		returnValue = MspVpmSendCmdDefer(&commandMsg, NULL, &compandingSetStatus, 0);
		if (returnValue == MSP_SUCCESS)
		{
			return(compandingSetStatus);
		}
	}
	return(returnValue);
}

/****************************************************************************/
/*																			*/
/*	function:	MspVpmSetVCORateBlkDev										*/
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*	Tony Raetz:11-19-2002	: Initial version of function					*/
/*																			*/
/****************************************************************************/
/*	Description:															*/
/*	This function will allow the user to program the VCO of the VE to 		*/
/*	output a clock at one of two rates.  0 = 2.048 Mhz and 1 = 4.096 Mhz.	*/
/*																			*/
/*	Input:																	*/
/*		clockRate:	Contains 0 or 1 to program VE output clock.				*/
/*																			*/
/*	Output:																	*/
/*		U32: Returns an indication that the command was executed 			*/
/*			successfully.													*/
/*																			*/
/****************************************************************************/
U32 MspVpmSetVCORateBlkDev(U32 clockRate,
			   U32 timeSlotOffset,
			   U32 numberOfActiveTimeSlots,
			   U32 tdmBusIdentifier,
			   U32 clockMode)
{
	msp_vpm_vco *cbMessage;
	msp_vpm_cmd commandMsg;
	U32 returnValue = MSP_SUCCESS;
	U32 vcoSetStatus;
	U32 getClockCoefficient = 0, maxTimeSlots = 0;

	cbMessage = (msp_vpm_vco *) &commandMsg;

	switch (clockRate)
	{
		case MSP_VPM_VCORATE_1533:
			getClockCoefficient     = MSP_VPM_VCOCOEFFICIENT_1533;
			maxTimeSlots            = MSP_TDM_BUS24_SLOT;
			break;
		case MSP_VPM_VCORATE_1544:
			getClockCoefficient     = MSP_VPM_VCOCOEFFICIENT_1544;
			maxTimeSlots            = MSP_TDM_BUS24_SLOT;
			break;
		case MSP_VPM_VCORATE_2048:
			getClockCoefficient     = MSP_VPM_VCOCOEFFICIENT_2048;
			maxTimeSlots            = MSP_TDM_BUS32_SLOT;
			break;
		case MSP_VPM_VCORATE_4096:
			getClockCoefficient     = MSP_VPM_VCOCOEFFICIENT_4096;
			maxTimeSlots            = MSP_TDM_BUS64_SLOT;
			break;
		case MSP_VPM_VCORATE_8192:
			getClockCoefficient     = MSP_VPM_VCOCOEFFICIENT_8192;
			maxTimeSlots            = MSP_TDM_BUS128_SLOT;
			break;
		default:
			returnValue = MSP_VPM_INVALID_CLOCK_RATE;
	}

	if (returnValue == MSP_SUCCESS)
	{
		if ((numberOfActiveTimeSlots) > maxTimeSlots)
		{
			returnValue = MSP_VPM_INVALID_TIMESLOT_ALLOCATION;
		}
	}

	if (returnValue == MSP_SUCCESS)
	{
		if (tdmBusIdentifier > MSP_VPM_TDMBUS_1)
		{
			returnValue = MSP_VPM_INVALID_TDMBUS_SELECT;
		}
	}

#ifdef    USE_GLOBAL_VPM_DATA
	if (returnValue == MSP_SUCCESS)
	{
		if (tdmBusIdentifier == MSP_VPM_TDMBUS_0)
		{
			pVpmHALData->pVpmTimeSlotInfoTdmbZeroOne->vpmTdmb0BusSlotOffset = timeSlotOffset;
			pVpmHALData->pVpmTimeSlotInfoTdmbZeroOne->vpmTdmb0ClockRate      = clockRate;
			pVpmHALData->pVpmTimeSlotInfoTdmbZeroOne->vpmTdmb0NumActiveTimeslots = numberOfActiveTimeSlots;
			pVpmHALData->pVpmTimeSlotInfoTdmbZeroOne->vpmTdmb0ClockMode     = clockMode;
		}
		else
		{
			pVpmHALData->pVpmTimeSlotInfoTdmbZeroOne->vpmTdmb1BusSlotOffset = timeSlotOffset;
			pVpmHALData->pVpmTimeSlotInfoTdmbZeroOne->vpmTdmb1ClockRate      = clockRate;
			pVpmHALData->pVpmTimeSlotInfoTdmbZeroOne->vpmTdmb1NumActiveTimeslots = numberOfActiveTimeSlots;
			pVpmHALData->pVpmTimeSlotInfoTdmbZeroOne->vpmTdmb1ClockMode     = clockMode;
		}
	}
#endif /* USE_GLOBAL_VPM_DATA */
	if (returnValue == MSP_SUCCESS)
	{
		cbMessage->cmdHdr.cmdId                         = DIVPM_CNFG_VCO_DEVCMD;
		cbMessage->cmdHdr.cmdLen                        = 10;
		cbMessage->cmdHdr.hsHandleHigh          = MSP_ALL_ONES_16BITS;
		cbMessage->cmdHdr.hsHandleLow           = MSP_VPM_EVENT_RECORD_VALID;
		cbMessage->totalNumTimeSlots            = maxTimeSlots;
		cbMessage->startingTimeSlot             = timeSlotOffset;
		cbMessage->numberActiveTimeslots        = numberOfActiveTimeSlots;
		cbMessage->tdmBusSelect                         = tdmBusIdentifier;
		cbMessage->clockMode                            = clockMode;


		returnValue = MspVpmSendCmdDefer(&commandMsg, NULL, &vcoSetStatus, 0);
//		if (returnValue == MSP_SUCCESS)
//		{
//			returnValue = SEMTAKE(veSem, WAIT_FOREVER);
//		}
	}
	if (returnValue == MSP_SUCCESS)
	{
		return(vcoSetStatus);
	}
	else
	{
		return(returnValue);
	}
}

/****************************************************************************/
/*																			*/
/*	function:	MspVpmCESEnableBlkTdmb		   								*/
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*	Tony Raetz:10-26-2001	: Initial version of function					*/
/*																			*/
/****************************************************************************/
/*	Description:															*/
/*																			*/
/*	Input:																	*/
/*																			*/
/*	Output:																	*/
/*																			*/
/****************************************************************************/
U32 MspVpmCESEnableBlkTdmb(U32 tdmHighway)
{
	msp_vpm_ces_enable *cbMessage;
#ifdef    USE_GLOBAL_VPM_DATA
	tdmb_ces_descriptor *pCESTDMHighwayConfig;
#endif /* USE_GLOBAL_VPM_DATA */
	msp_vpm_cmd commandMsg;
	U32 cesTdmSetEnable, returnValue;

	returnValue = MspVpmCESTDMEnableCheck(tdmHighway);

	if (returnValue)
	{
		return(returnValue);
	}
#ifdef    USE_GLOBAL_VPM_DATA
	pCESTDMHighwayConfig = MspVpmGetCESHighConfigPtr(tdmHighway);
	/* Check to see if PFD Mode has bee enabled 		*/
	/* If it has send TX Frame Sync Disable to the VPM 	*/
	/* When CES mode is enabled it will begin to tx	   	*/
	/* frame sync.										*/
#endif /* USE_GLOBAL_VPM_DATA */
//	cesInterruptCode = 0;							/* reset interrupt count to prevent startup problems */
	cbMessage = (msp_vpm_ces_enable *) &commandMsg;

#ifdef    USE_GLOBAL_VPM_DATA
	pBufTraverse = pCESTDMHighwayConfig->pCESPrivateBufferFifo->pMspBDPool->pDataBlockSpace;
#endif /* USE_GLOBAL_VPM_DATA */

	cbMessage->cmdHdr.cmdId             = DIVPM_CESENABLE_CMD;
	cbMessage->cmdHdr.cmdLen            = 10;
	cbMessage->cmdHdr.hsHandleHigh      = MSP_ALL_ONES_16BITS;
	cbMessage->cmdHdr.hsHandleLow       = MSP_VPM_EVENT_RECORD_VALID;
	cbMessage->tdmHighway               = tdmHighway;
// ????? this stuff will be filled in by special code in the driver
// ?????	cbMessage->dataBufStartHighAddress  = GETUPPER16BITS((U32)pBufTraverse);
// ?????	cbMessage->dataBufStartLowAddress   = GETLOWER16BITS((U32)pBufTraverse);
	cbMessage->dataBufStartHighAddress  = 0; // ????? driver must fill in
	cbMessage->dataBufStartLowAddress   = 0; // ????? driver must fill in
#ifdef    USE_GLOBAL_VPM_DATA
	cbMessage->bufferLength             = pCESTDMHighwayConfig->pCESPrivateBufferFifo->pMspBDPool->pGet->maxLength;
	cbMessage->offset                   = 64;
#else  /* USE_GLOBAL_VPM_DATA */
	cbMessage->bufferLength             = 0; // ????? driver must fill this in
	cbMessage->offset                   = 0; // ????? need correct value
#endif /* USE_GLOBAL_VPM_DATA */
// ?????	cbMessage->numberOfBuffers          = CES_MSP_BUFFER_ALLOCATE;
	cbMessage->numberOfBuffers          = 0; // ????? driver must fill in

	returnValue = MspVpmSendCmdDefer(&commandMsg, NULL, &cesTdmSetEnable, 0);
//	if (returnValue == MSP_SUCCESS)
//	{
//		returnValue = SEMTAKE(veSem, WAIT_FOREVER);
//	}
	if (returnValue == MSP_SUCCESS)
	{
//		SEMCREATE(SEM_Q_FIFO, SEM_EMPTY, cesSem);
//		pCESTDMHighwayConfig->handleToCESTask = taskSpawn("CESRx", 45, 0, 1024,
//								  (FUNCPTR) MSPCESEntry, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

		returnValue = cesTdmSetEnable;
	}
	return(returnValue);
}

/****************************************************************************/
/*																			*/
/*	function:	MspVpmCESTDMCfgBlkTdmb										*/
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*	Tony Raetz:10-19-2001	: Initial version of function					*/
/*																			*/
/****************************************************************************/
/*	Description:															*/
/*																			*/
/*	Input:																	*/
/*																			*/
/*	Output:																	*/
/*																			*/
/****************************************************************************/
U32 MspVpmCESTDMCfgBlkTdmb(U32 tdmHighway,
			   U32 tdmFrameType,
			   U32 tdmClockSource,
			   U32 tdmDSOTimeSlotMask,
			   U32 tdmNumberOfFramesPerBuffer)
{
	msp_vpm_ces_config_data *cbMessage;
	msp_vpm_cmd commandMsg;
#ifdef    USE_GLOBAL_VPM_DATA
	tdmb_ces_descriptor *pCESTDMHighwayConfig;
#endif /* USE_GLOBAL_VPM_DATA */
	U32 returnValue, cesTdmSetStatus;

	returnValue = MspVpmCESTDMCfgCheck(tdmHighway, tdmFrameType, tdmClockSource,
//		tdmDSOTimeSlotMask, tdmNumberOfFramesPerBuffer, UserReceiveFunc);
		tdmDSOTimeSlotMask, tdmNumberOfFramesPerBuffer);
	if (returnValue)
	{
		return(returnValue);
	}
	cbMessage = (msp_vpm_ces_config_data *) &commandMsg;


	cbMessage->cmdHdr.cmdId                 = DIVPM_CESCONFIG_CMD;
	cbMessage->cmdHdr.cmdLen                = 10;
	cbMessage->cmdHdr.hsHandleHigh          = MSP_ALL_ONES_16BITS;
	cbMessage->cmdHdr.hsHandleLow           = MSP_VPM_EVENT_RECORD_VALID;
	cbMessage->tdmHighway                   = tdmHighway;
//	cbMessage->tdmFrameType                 = tdmFrameType;
	cbMessage->tdmDS0TimeSlotUpper          = GETUPPER16BITS(tdmDSOTimeSlotMask);
	cbMessage->tdmDS0TimeSlotLower          = GETLOWER16BITS(tdmDSOTimeSlotMask);
//	cbMessage->tdmClockSource               = tdmClockSource;
	cbMessage->tdmFramesPerRxBuffer         = tdmNumberOfFramesPerBuffer;

	returnValue = MspVpmSendCmdDefer(&commandMsg, NULL, &cesTdmSetStatus, 0);
//	if (returnValue == MSP_SUCCESS)
//	{
//		returnValue = SEMTAKE(veSem, WAIT_FOREVER);
//	}
	if (returnValue == MSP_SUCCESS)
	{
		return(cesTdmSetStatus);
	}
#ifdef    USE_GLOBAL_VPM_DATA
	else
	{
		pCESTDMHighwayConfig =
			MspVpmGetCESHighConfigPtr(tdmHighway);
		pCESTDMHighwayConfig->vpmCESTdmbEnableState = CES_UNINITIALIZED;
	}
#endif /* USE_GLOBAL_VPM_DATA */
	return(returnValue);
}

/****************************************************************************/
/*                                                                           */
/*	function:	MspVpmRdMem                                          */
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*	Tony Raetz:7-27-2001	: Initial version of function					*/
/*																			*/
/****************************************************************************/
/*	Description:															*/
/*  																		*/
/*																			*/
/*	Input:																	*/
/*																			*/
/*	Output:																	*/
/*																			*/
/****************************************************************************/
U32 MspVpmRdMem(U16 address, U16 length, U16 *pReturnWord)
{
	msp_vpm_cmd *cbMessage;
	msp_vpm_cmd commandMsg;
	U32 returnValue = MSP_SUCCESS, commandnum, numpackets;
	U16 returnData[18], temp;

	numpackets = (U32) length/14;
	temp = address;
	for(commandnum = 0; commandnum <= numpackets; commandnum++)
	{

		cbMessage = (msp_vpm_cmd *) &commandMsg;

		cbMessage->cmdHdr.cmdId		= DIVPM_TESTRESPONSE_CMD;
		cbMessage->cmdHdr.cmdLen 	= 5;
		cbMessage->cmdHdr.hsHandleHigh 	= MSP_ALL_ONES_16BITS;
		cbMessage->cmdHdr.hsHandleLow 	= MSP_VPM_EVENT_RECORD_VALID;
		cbMessage->parameters[0]	= temp;

		returnValue = MspVpmSendCmdDefer(&commandMsg, NULL, &returnData[0], 0);

//		if(returnValue == MSP_SUCCESS)
//		{
//			 returnValue = SEMTAKE(veSem, WAIT_FOREVER);
//		}
		if((returnValue == MSP_SUCCESS) && (pReturnWord == NULL))
		{

			printf("0x%04x: %04x %04x %04x %04x %04x %04x %04x\n", temp, returnData[4], returnData[5],
					returnData[6], returnData[7], returnData[8], returnData[9], returnData[10]);
			printf("0x%4x: %04x %04x %04x %04x %04x %04x %04x\n", temp+7, returnData[11], returnData[12],
					returnData[13], returnData[14], returnData[15], returnData[16], returnData[17]);
		}
		temp += 14;
	}
	if(pReturnWord != NULL)
	{
		memcpy(pReturnWord, &returnData[4], length*sizeof(U16));
	}
	return(returnValue);
}

static int ces_fd=INVALID_FILE_DESCRIPTOR;

static inline int isCESDeviceOpen(int Blocking)
{
	static int Once=0;

	if (ces_fd != INVALID_FILE_DESCRIPTOR){return (~0);}
	/* have we tried to open it once? */
	if (Once){return 0; /* tried once, failed, return failure */}
	Once = (~0);
	// ????? register signal handler, at exit handler and close vpm_fd?
	if (!Blocking)
	{
		ces_fd = open(BRECIS_MSP_VPM_CES "01", (O_RDWR|O_NONBLOCK));
	}
	else
	{
		ces_fd = open(BRECIS_MSP_VPM_CES "01", (O_RDWR));
	}
	if (ces_fd < 0)
	{
#ifdef    DEBUG_MSPVPMAPI
		perror(BRECIS_MSP_VPM_CES ": ");
#endif /* DEBUG_MSPVPMAPI */
		return (0);	// ?????
	}
	/* nothing else to do yet */
	return (~0);

}

static inline int isCESDeviceOpenTestOnly(void)
{
	if (ces_fd != INVALID_FILE_DESCRIPTOR){return (~0);}
	return 0;
}

U32 MspCESSendDataToVpm(U8 *data, U32 dataLen, U32 tdmHighway)
{
	if (isCESDeviceOpenTestOnly())
	{
		/* device is open -- continue */
		if (dataLen == write(ces_fd, data, dataLen)){return MSP_SUCCESS;}
	}
	return (~MSP_SUCCESS);
}

static inline int CESGetDataFromVPMInternal(U8 *data, U32 dataLen, U32 tdmHighway,
	int Blocking)
{
	ssize_t bytesRead;

	if (isCESDeviceOpen(Blocking))
	{
		bytesRead = read(ces_fd, data, dataLen);

		if (bytesRead == (-1))
		{
#ifdef    DEBUG_MSPVPMAPI
			if (errno != EAGAIN){perror(BRECIS_MSP_VPM_CES ": ");}
#endif /* DEBUG_MSPVPMAPI */
			switch (errno)
			{
				case EINTR : /* interrupted - no data read - retry */
				case EAGAIN: /* no data available yet */
					return 0;
					break;
				default:
					break;
			}
			return (-1);
		}
		return dataLen;
	}
	return (-1);
}

int CESGetDataFromVPM(U8 *data, U32 dataLen, U32 tdmHighway)
{
	return CESGetDataFromVPMInternal(data, dataLen, tdmHighway,
		0 /* non-blocking */);
}

int CESGetDataFromVPMBlk(U8 *data, U32 dataLen, U32 tdmHighway)
{
	return CESGetDataFromVPMInternal(data, dataLen, tdmHighway,
		(~0) /* blocking */);
}

/* ************************* End of mspvpmapi.c *************************** */
