/* $Header: /proj/software/pub/CVSROOT/uClinux/brecis/ve-api/demo.c,v 1.27 2002/12/20 16:28:34 tld Exp $ */
/* ************************************************************************ *
 *
 * demo.c
 *
 *                  Copyright 2002, Brecis Communications
 *
 * Originator: TL Donahue
 *
 *           [Generated by tld on Sun 2 Jun 2002 at 19:07:35 UTC]
 * ************************************************************************ */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <sys/resource.h> /* for process priority functions */
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <sched.h>
#include <time.h>
#include <sys/wait.h>	/* for WXXX() macros */
#include <libgen.h>	/* for basename() */
#include <sys/ioctl.h>

#include <asm/brecis/BrecisSysRegs.h>   /* for device ID */

#include "mspCommon.h"
#include "mspvpmapi.h"
#include "brecis_vpm_dvr.h"
#include "brecis_tdmsdma_dvr.h"

#ifndef   INCLUDE_GIPS
#define   TWO_SYSTEM_UDP
//#define    USER_SPACE_TIMESLOT_INTERCHANGE
#endif /* INCLUDE_GIPS */

#ifdef    INCLUDE_GIPS
#define   NO_ECHO_CANCELLATION
#include "GIPS_API.h"
#include "NECFIX_GIPS_API.h"
#endif /* INCLUDE_GIPS */

#define UDP_PORT	(9999)

#define TDM_BUS_TO_USE 0

#define TDM_FRAME_TYPE          (CES_DS1_FRAME)
#define TDM_CLK_SRC             (WAN_DERIVED_CLOCK)
#define TDM_TIMESLOT_MASK       (0x00FFFFFF)

#define TIME_SLOT_TO_USE	(0)	/* 0-based */
#define TIME_SLOT_INDEX(ts)	(ts)
#define NEC_ECHO_TAIL_LENGTH 	(32)
#define TDM_FRAMES_PER_BUFFER   (16)
#define BYTES_PER_FRAME		(24)
#define MAX_BYTES_PER_FRAME	(32)
#define FRAMES_PER_BUNDLE	(80)
#define FRAMES_PER_10MSEC	(80)

static char *progName;
static int isTDM=0;
static int TDMslots=24;

extern int G711_GIPS_decodeM(unsigned char *logbuf, short *linbuf, long lseg);

static int number_option(int *output, char *optstring)
{
    long temp=0;
    char *endptr;

    temp = strtoul(optstring, &endptr, 0);
    /* test for error */
    if (*endptr != '\0')
    {
        return (~0);
    }
    else
    {
        *output = temp;
    }
    return 0;
}

#ifdef    INCLUDE_GIPS
static NETEQ_inst *NetEq_inst;
static EG711U_inst *EG_inst;
#ifndef NO_ECHO_CANCELLATION
static NEC_inst *nec_inst;
#endif

void initGIPS(void)
{
	int retValue;

	assert(FRAMES_PER_BUNDLE == FRAMES_PER_10MSEC);

	fprintf(stderr, "Creation of NetEq struct:\n");
	retValue=NETEQ_GIPS_10MS16B_create(&NetEq_inst);
	fprintf(stderr, "retValue= %i\n",retValue);

	fprintf(stderr, "Creation of EG711 struct:\n");
	retValue=EG711U_GIPS_10MS16B_create(&EG_inst);
	fprintf(stderr, "retValue= %i\n",retValue);

	fprintf(stderr, "Initialization NetEq:\n");
	retValue = NETEQ_GIPS_10MS16B_init(NetEq_inst,8000);
	fprintf(stderr, "retValue= %i\n",retValue);

	fprintf(stderr, "Initialization enhenced G711 encoder:\n");
	retValue =EG711U_GIPS_10MS16B_InitEncoder( EG_inst, EG711_LINEAR_IN , 160);
	fprintf(stderr, "retValue= %i\n",retValue);

	fprintf(stderr, "Attaching the EG711 state to the NetEq state:\n");
	retValue =NETEQEG711U_GIPS_10MS16B_init(NetEq_inst,  EG_inst);
	fprintf(stderr, "retValue= %i\n",retValue);

	fprintf(stderr, "Attach dynamic codepoint (97) to EG711:\n");
	retValue=NETEQ_GIPS_10MS16B_initCodepoint(NetEq_inst, "EG711U", 8000, 97);
	fprintf(stderr, "retValue= %i\n",retValue);

#ifndef NO_ECHO_CANCELLATION
	fprintf(stderr, "Creating NEC instance\n");
	retValue= NECFIX_GIPS_API_create(&nec_inst, NEC_ECHO_TAIL_LENGTH );
	fprintf(stderr, "retValue= %i\n",retValue);
#endif
}
#endif /* INCLUDE_GIPS */

int createRTPpackage(unsigned char* coded,int len,int ver,int P,
			int pad_len,int X,int ext_len,int CC,
			unsigned long timestamp,unsigned long ssrc,
			int coderType,int rtpnumber,
			unsigned char *RTPpackage)
{
	int i,insertRTPpos=0;
	if (ver==2)
	{
		RTPpackage[insertRTPpos]=(unsigned char)0x80;
	}
	else
	{
		fprintf(stderr, "Only RTP version 2 are supported in the test\n");
		return(0);
	}
	if (X==1)
	{
		RTPpackage[insertRTPpos]=RTPpackage[insertRTPpos] | 0x10;
	}
	if (P==1)
	{
		RTPpackage[insertRTPpos]=RTPpackage[insertRTPpos] | 0x20;
	}
	RTPpackage[insertRTPpos++]=RTPpackage[0] | CC;
	RTPpackage[insertRTPpos++]=(unsigned char)coderType;
	RTPpackage[insertRTPpos++]=(unsigned char)(rtpnumber>>8);
	RTPpackage[insertRTPpos++]=(unsigned char)(rtpnumber);
	RTPpackage[insertRTPpos++]=(unsigned char)(timestamp>>24);
	RTPpackage[insertRTPpos++]=(unsigned char)((timestamp<<8)>>24);
	RTPpackage[insertRTPpos++]=(unsigned char)((timestamp<<16)>>24);
	RTPpackage[insertRTPpos++]=(unsigned char)((timestamp<<24)>>24);
	RTPpackage[insertRTPpos++]=(unsigned char)(ssrc>>24);
	RTPpackage[insertRTPpos++]=(unsigned char)((ssrc<<8)>>24);
	RTPpackage[insertRTPpos++]=(unsigned char)((ssrc<<16)>>24);
	RTPpackage[insertRTPpos++]=(unsigned char)((ssrc<<24)>>24);

	if (X==1)
	{
		insertRTPpos+=2;
		RTPpackage[insertRTPpos++]=((unsigned short)ext_len)>>8;
		RTPpackage[insertRTPpos++]=ext_len & 0xFF;
		insertRTPpos+=4*ext_len;
	}
	else
	{
		ext_len=0;
	}
	if (CC>0)
	{
		insertRTPpos+=CC*4;
	}

	/* Insert payload */
	for(i=0;i<len;i++)
	{
		RTPpackage[insertRTPpos++]=coded[i];
	}

	if (P==1)
	{
		insertRTPpos+=(pad_len-1);
		RTPpackage[insertRTPpos++]=(unsigned char)pad_len;
	}
	else
	{
		pad_len=0;
	}

	return(insertRTPpos);
}

#define DEFAULT_PROCESS_PRIORITY (-20)	/* 19 (low) -- -20 (high) */

static void print_usage(void)
{
	fprintf(stderr, "usage: %s <Peer IP Addr>\n", progName);
	fprintf(stderr, "  [-h] -- help (this message)\n");
	fprintf(stderr, "  [-d] -- show packet counter for debug\n");
	fprintf(stderr, "  [-m <debug level>] -- set debug level of %s driver\n",
		((isTDM) ? "TDM" : "VPM"));
	fprintf(stderr, "  [-n] -- use non-blocking mode (default blocking)\n");
	fprintf(stderr, "  [-p <priority>] -- CAUTION! set process priority (default %d)\n",
		DEFAULT_PROCESS_PRIORITY);
	if(!isTDM)fprintf(stderr, "  [-C] -- compatibility mode for old scripts only\n");
	if(isTDM)fprintf(stderr, "  [-s] -- TDM slots [1..4], 24 or 32\n");
	fprintf(stderr, "  [-V] -- show version and exit\n");
}

void do_script_command(char *cmd)
{
	int ret=system(cmd);

	if (-1 == ret)
	{
		fprintf(stderr, "Can't execute \"%s\"\n", cmd);
		exit(3);
	}
	if (0 != WIFEXITED(ret))
	{
		/* normal exit -- can check exit status */
		if (0 != WEXITSTATUS(ret))
		{
			fprintf(stderr, "\"%s\" returned non-zero: %d\n",
				cmd, WEXITSTATUS(ret));
		}
	}
	return;
}

static int fdTDM=-1;

static void configTDM(int fd, int slots, int r, int t, int c, int b)
{
	{
		TDM_IOCTL_CONFIG config={0};

		config.slots = slots;
		config.rx_frames_in_buffer = r;
		config.tx_frames_in_buffer = t;
		if (-1 == ioctl(fd, TDMSDMA_DVR_IOC_CONFIG, &config))
		{
			perror("CONFIG");
			return;
		}
		fprintf(stderr, "CONFIG: slots: %d  RX: %d  TX: %d\n", config.slots,
			config.rx_frames_in_buffer, config.tx_frames_in_buffer);
	}
	{
		TDM_IOCTL_BURST burst={0};

		burst.rx_burst_cnt = c;
		burst.tx_burst_cnt = b;
		if (-1 == ioctl(fd, TDMSDMA_DVR_IOC_BURST, &burst))
		{
			perror("BURST");
			return;
		}
		fprintf(stderr, "BURST: RX: %d  TX: %d  SZ: %d\n",
			burst.rx_burst_cnt, burst.tx_burst_cnt, burst.burst_length);
	}
}

int getTDMsize(int slots)
{
	switch (slots)
	{
		case 1: /* intentionally falls thru */
		case 2: /* intentionally falls thru */
		case 3: /* intentionally falls thru */
		case 4:
			return FRAMES_PER_10MSEC*4;
			break;
		case 24: /* intentionally falls thru */
		case 32:
			return FRAMES_PER_10MSEC*32;
			break;
		default:
			fprintf(stderr, "Uh oh, slots %d not [1..4], 24 or 32, don't know what to do. Bye.\n",
				slots);
			exit(4);
	}
}

static int readData(U8 *buffer, int max_size, int opt_n)
{
	int ret=(-1);	/* default to error */

	if (!isTDM)
	{
		assert(FRAMES_PER_BUNDLE*BYTES_PER_FRAME <= max_size);
		if (!opt_n)
		{
			ret = CESGetDataFromVPMBlk(buffer,
				FRAMES_PER_BUNDLE*BYTES_PER_FRAME,
				TDM_BUS_TO_USE);
		}
		else
		{
			ret = CESGetDataFromVPM(buffer,
				FRAMES_PER_BUNDLE*BYTES_PER_FRAME,
				TDM_BUS_TO_USE);
		}
	}
	else
	{
		int TDMsize=getTDMsize(TDMslots);

		assert(TDMsize <= max_size);
		ret = read(fdTDM, buffer, TDMsize);

		if (-1 == ret)
		{
			if (EAGAIN == errno)
			{
				ret = 0; /* signal no data available */
			}
			else
			{
				perror("TDM read");
				return (-1);
			}
		}
		if ((ret != 0) && (ret != TDMsize))
		{
			fprintf(stderr, "readData() requested: %d  actual: %d\n",
				TDMsize, ret);
			ret = (-1);	/* stop! configuration problem */
		}
	}
	return ret;
}

static void writeData(U8 *buffer, int max_size)
{
	int ret;

	if (!isTDM)
	{
		assert(FRAMES_PER_BUNDLE*BYTES_PER_FRAME <= max_size);
		ret = MspCESSendDataToVpm(buffer,
			FRAMES_PER_BUNDLE*BYTES_PER_FRAME,
			TDM_BUS_TO_USE);

		if (ret != MSP_SUCCESS)
		{
			fprintf(stderr, "MspCESSendDataToVpm() returned: %d [0x%08x]\n",
				ret, ret);
		}
	}
	else
	{
		int TDMsize=getTDMsize(TDMslots);

		assert(TDMsize <= max_size);
     		ret = write(fdTDM, buffer, TDMsize);

		if (-1 == ret)
		{
			perror("TDM write");
		}
		if (ret != TDMsize)
		{
			fprintf(stderr, "writeData() requested: %d  actual: %d\n",
				TDMsize, ret);
		}
	}
	return;
}

int main(int argc, char **argv)
{
	U32 rc;
	int tdm=TDM_BUS_TO_USE;
	const int frames_per_buffer=TDM_FRAMES_PER_BUFFER;

	int opt_n=0;
	int opt_d=0;
	int opt_mdebug_level=0;
	int opt_priority=DEFAULT_PROCESS_PRIORITY;
	int opt_C=0;
	int opt_J=0;

	/* UDP socket stuff */
	int socket_fd;
	struct sockaddr_in addr={0};
	int localPort=UDP_PORT;

#if       defined(TWO_SYSTEM_UDP) || defined(INCLUDE_GIPS)
	int recv_addr_len;
#endif /* defined(TWO_SYSTEM_UDP) || defined(INCLUDE_GIPS) */

#ifdef    INCLUDE_GIPS
	unsigned char RTPpacket[500];
	unsigned long Rectimestamp = (((unsigned long)(rand()&0xFFFF))<<16)+(((unsigned long)rand())&0xFFFF);
	unsigned long Sendtimestamp=0;
	unsigned long ssrc;

	srand( (unsigned)time( NULL ) );
	ssrc=(((unsigned long)(rand()&0xFFFF))<<16)+(((unsigned long)rand())&0xFFFF);
	Sendtimestamp=(((unsigned long)(rand()&0xFFFF))<<16)+(((unsigned long)rand())&0xFFFF);
#endif /* INCLUDE_GIPS */

	{
		/* set the personality */
		progName=basename(argv[0]);
		if (0 == progName){progName = "unknown";}
		if (0 == strcmp(progName, "tdmdemo")){isTDM = (~0);}
	}

	{
		int option;

		while (-1 != (option = getopt(argc, argv,
			((isTDM) ? "hbdm:p:s:VJ" : "hbdm:p:CVJ"))))
		{
			switch (option)
			{
				case 'd':
					opt_d = (~0);
					break;
				case 'm':
					if (number_option(&opt_mdebug_level, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					break;
				case 'n':
					opt_n = (~0);
					break;
				case 'p':
					if (number_option(&opt_priority, optarg))
					{
						fprintf(stderr, "bad option -%c value: %s\n",
							option, optarg);
						exit(2);
					}
					if (opt_priority > 19){opt_priority = 19;}
					if (opt_priority < -20){opt_priority = -20;}
					break;
				case 'C':
					opt_C = (~0);
					break;
				case 'J':
					opt_J = (~0);
					break;
				case 'h':
					print_usage();
					exit(0);
				case 's':
					{
						int slots;

						if (number_option(&slots, optarg))
						{
							fprintf(stderr, "bad option -%c value: %s\n",
								option, optarg);
							exit(2);
						}
						if ((slots < 0) || (slots > 4))
						{
							if ((slots != 24) && (slots != 32))
							{
								fprintf(stderr, "TDM slots not [1..4], 24 or 32\n");
								exit(3);
							}
						}
						TDMslots = slots;
					}
					break;
				case 'V':
					fprintf(stderr, "%s %s %s\n", progName, __DATE__, __TIME__);
					exit(0);
				default: /* intentionally falls through */
				case '?':
					print_usage();
					exit(1);

			}
		}
		if (argc <= optind)	/* require 1 parameter for Peer IP Addr */
		{
			print_usage();
			exit(255);
		}
	}

	if (isTDM)
	{
		do_script_command("rmmod brecis_slac_dvr 2>/dev/null");
		do_script_command("rmmod brecis_tdmsdma_dvr 2>/dev/null");
		do_script_command("insmod brecis_slac_dvr");
		{
			char cmd[50];

			snprintf(cmd, sizeof(cmd), "insmod brecis_tdmsdma_dvr dlvl=0x%08x",
				opt_mdebug_level);
			do_script_command(cmd);
		}
		{
			unsigned char devID=((*DEV_ID_REG >> 8) & 0xFF);

			switch (devID)
			{
				case 0x50:
					break;
				case 0x40:
					break;
#ifdef    CONFIG_BRECIS_FPGA
				case 0x00:
					break;
#endif /* CONFIG_BRECIS_FPGA */
				default:
					fprintf(stderr, "Unknown device ID: %02x\n", devID);
					exit(4);
			}
		}
	}
	else
	{
		if (!opt_C)
		{
			/* not compatibility mode so do the preliminaries */
			do_script_command("rmmod brecis_slac_dvr 2>/dev/null");
			do_script_command("rmmod brecis_vpm_dvr 2>/dev/null");
			do_script_command("insmod brecis_slac_dvr");
			{
				char cmd[50];

				snprintf(cmd, sizeof(cmd), "insmod brecis_vpm_dvr dlvl=0x%08x",
					opt_mdebug_level);
				do_script_command(cmd);
			}
			{
				U8 devID=((*DEV_ID_REG >> 8) & 0xFF);

				switch (devID)
				{
					case 0x50:
						if(opt_J)
						{
							printf("Calling JTAG Build\n ldvpm -j\n");
							do_script_command("ldvpm -j");
						}
						else
						{
							do_script_command("ldvpm -g");
						}
						break;
					case 0x40:
						if(opt_J)
						{
							do_script_command("ldvpm4K -j");
						}
						else
						{					
							do_script_command("ldvpm4K -a ve_gips4000.lst");
						}
						break;
					default:
						fprintf(stderr, "Unknown device ID: %02x\n", devID);
						exit(4);
				}
			}
		}
	}

#ifdef    INCLUDE_GIPS
	initGIPS();
#endif /* INCLUDE_GIPS */

	{
		int current_priority;
		int new_priority;

		errno = 0;	/* see man page */
		current_priority = getpriority(PRIO_PROCESS,
			0 /* current process */);
		if (setpriority(PRIO_PROCESS,
			0 /* current process */, opt_priority) == -1)
                {
                        perror("setpriority()");
                }
                errno = 0;
                new_priority = getpriority(PRIO_PROCESS,
			0 /* current process */);
		fprintf(stderr, "Process priority set to: %d [was: %d]\n",
			new_priority, current_priority);
	}
	/* UDP socket */
	if ((socket_fd = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP)) == -1)
	{
		/* error opening socket */
	       	perror("socket()");
		exit(1);
	}
	addr.sin_family = AF_INET;
	addr.sin_port = htons(localPort);
	/* set up UDP listener */
	addr.sin_addr.s_addr = htonl(INADDR_ANY);
	if (bind(socket_fd, (struct sockaddr *)&addr,
		sizeof(addr)) == -1)
	{
		perror("bind()");
		exit(1);
	}
	/* set peer address for sending */
	if (inet_aton(argv[1], &addr.sin_addr) == -1)
	{
		perror("peer inet_aton()");
	}
	/* make the socket non-blocking -- so we can poll */
	if (fcntl(socket_fd, F_SETFL, O_NONBLOCK) == -1)
	{
		perror("fcntl()");
		exit(1);
	}

	if (isTDM)
	{
		/* open, nonblocking if requested */
		fdTDM = open(BRECIS_TDMSDMA_API, (O_RDWR |
			((opt_n) ? O_NONBLOCK : 0)));
		if (fdTDM < 0)
		{
			perror(BRECIS_TDMSDMA_API);
			exit(1);
		}
		configTDM(fdTDM, TDMslots /* slots */, 0, 0, 0, 0 /* all default */);
	}
	else
	{
		rc = MspVpmStartBlkDev();
		if (MSP_SUCCESS != rc)
		{
			fprintf(stderr, "MspVpmStartBlkDev() returned: %d [0x%08x]\n",
				rc, rc);
			exit(1);
		}
		fprintf(stderr, "MspVpmSetCompandorBlkTdmb()\n");
		rc = MspVpmSetCompandorBlkTdmb(MSP_VPM_COMPANDING_G711U);
		if (MSP_SUCCESS != rc)
		{
			fprintf(stderr, "MspVpmSetCompandorBlkTdmb() returned: %d [0x%08x]\n",
				rc, rc);
			exit(2);
		}
		fprintf(stderr, "MspVpmCESTDMCfgBlkTdmb(TDM: %u FrType: %u ClkSrc: %u TSMask: 0x%08x Fr/Buf: %u )\n",
			tdm, TDM_FRAME_TYPE, TDM_CLK_SRC,
			TDM_TIMESLOT_MASK, frames_per_buffer);
		rc = MspVpmCESTDMCfgBlkTdmb(tdm, TDM_FRAME_TYPE, TDM_CLK_SRC,
			TDM_TIMESLOT_MASK, frames_per_buffer);
		if (MSP_SUCCESS != rc)
		{
			fprintf(stderr, "MspVpmCESTDMCfgBlkTdmb() returned: %d [0x%08x]\n",
				rc, rc);
			exit(3);
		}

		fprintf(stderr, "MspVpmCESEnableBlkTdmb()\n");
		/* print out the "shared" memory address for the other program */
		rc = MspVpmCESEnableBlkTdmb(tdm);
		if (MSP_SUCCESS != rc)
		{
			fprintf(stderr, "MspVpmCESEnableBlkTdmb() returned: %d [0x%08x]\n",
				rc, rc);
			exit(4);
		}
	}

	for (;;)
	{
		/* static buffer to read into and discard */
		static U8 buffer[FRAMES_PER_BUNDLE*MAX_BYTES_PER_FRAME];
		int dataAvailable;
#ifdef    INCLUDE_GIPS
		static U8 CESBuffer[FRAMES_PER_BUNDLE*MAX_BYTES_PER_FRAME]={0};
		short NetEqSpeechOut[FRAMES_PER_10MSEC];
		char TenMsData[FRAMES_PER_10MSEC];
		short LengthOfEncodedData;
		int NetEqOutputLen;
		int retValue;
		short RTPpacketLen;
		static int rtpnumber=0;
		short LinearSpeechIn[500];
		unsigned char EG711RTPData[500];
		char uLawData[FRAMES_PER_10MSEC];
#ifndef   NO_ECHO_CANCELLATION
		short NECLinearSpeechOut[500];
#endif /* NO_ECHO_CANCELLATION */
#endif /* INCLUDE_GIPS */

		dataAvailable = readData(buffer, sizeof(buffer), opt_n);

		switch (dataAvailable)
		{
			static unsigned int noData=0;
			static unsigned int dataAv=0;

			case -1:
				fprintf(stderr, "Error getting voice data - exiting\n");
				exit(255);
			case 0:
				/* no data available -- try again */
				++noData;
				break;
			default:
				++dataAv;
				{
					if (opt_d)
					{
						if ((dataAv % 100) == 0){fprintf(stderr, "%10u  %10u                               \r",
							dataAv, noData);}
					}
				}
#ifdef    USER_SPACE_TIMESLOT_INTERCHANGE
				{
					/* user space interchange */
					char *ptr=buffer;
					int cnt;
					for (cnt = 0;
					     cnt < ((isTDM) ? 4 : FRAMES_PER_BUNDLE);
					     cnt++)
					{
						ptr[0] ^= ptr[1];
						ptr[1] ^= ptr[0];
						ptr[0] ^= ptr[1];
						ptr += BYTES_PER_FRAME;
					}
					writeData(buffer, sizeof(buffer));

				}
#endif /* USER_SPACE_TIMESLOT_INTERCHANGE */
#ifdef    TWO_SYSTEM_UDP
				if (sendto(socket_fd, buffer,
					((isTDM) ? getTDMsize(TDMslots) :
					(FRAMES_PER_BUNDLE*BYTES_PER_FRAME)),
					0,
					(struct sockaddr *)&addr, sizeof(addr)) == -1)
				{
					perror("sendto()");
					exit(1);
				}
				/* we are done with that data -- reuse buffer for receive */
				/* now see if other system has data for us -- only want whole buffer */
				if(-1 == (rc = recvfrom(socket_fd, buffer,
					((isTDM) ? getTDMsize(TDMslots) :
					(FRAMES_PER_BUNDLE*BYTES_PER_FRAME)),
					MSG_WAITALL,
					(struct sockaddr *)&addr, &recv_addr_len)))
				{
					if (errno != EAGAIN)
					{
						perror("recvfrom()");
						exit(1);
					}
				}
				else
				{
					if (rc >= 0)
					{
						assert(rc ==
							((isTDM) ? getTDMsize(TDMslots) :
							(FRAMES_PER_BUNDLE*BYTES_PER_FRAME))
							);
						/* send data from other system to VPM */
						writeData(buffer, sizeof(buffer));
					}
					else
					{
						fprintf(stderr, "Huh?\n");
					}
				}
#endif /* TWO_SYSTEM_UDP */
#ifdef    INCLUDE_GIPS
				// ========================================
				/* 10ms are up -- get data out of NetEq and encode as PCM */
				retValue = NETEQ_GIPS_10MS16B_RecOut(NetEq_inst,
					NetEqSpeechOut, &NetEqOutputLen);
				assert(retValue == 0);
				assert(NetEqOutputLen == FRAMES_PER_BUNDLE);
				retValue = G711U_GIPS_10MS16B_Encoder(FRAMES_PER_10MSEC,
					NetEqSpeechOut, TenMsData, &LengthOfEncodedData);
				assert(retValue == 0);
				assert(LengthOfEncodedData == FRAMES_PER_BUNDLE);
				assert(LengthOfEncodedData != 0);

				/* play out the data and save NetEq speech out for EC */
				/* need data in CES format */
				{
					int indx;
					char *ptr=CESBuffer;

					for (indx=0; indx < FRAMES_PER_BUNDLE; indx++)
					{
						ptr[TIME_SLOT_INDEX(TIME_SLOT_TO_USE)] = TenMsData[indx];
						ptr += BYTES_PER_FRAME;
					}
				}
				writeData(CESBuffer, sizeof(CESBuffer));
				// ========================================
				/* CES data is in buffer */
				/* extract the CES data from buffer into uLawData */
				{
					int indx;
					char *ptr=buffer;

					for (indx=0; indx < FRAMES_PER_BUNDLE; indx++)
					{
						uLawData[indx] = ptr[TIME_SLOT_INDEX(TIME_SLOT_TO_USE)];
						ptr += BYTES_PER_FRAME;
					}
				}
				/* Convert uLaw Data from QSLAC into linear for echo canceller and EG711 encoder */
				// ????? what about return code?
				G711_GIPS_decodeM(uLawData, LinearSpeechIn, FRAMES_PER_BUNDLE);
#ifdef    NO_ECHO_CANCELLATION
				retValue = EG711U_GIPS_10MS16B_Encoder(EG_inst,
					LinearSpeechIn, EG711RTPData, &LengthOfEncodedData);
#else  /* NO_ECHO_CANCELLATION */
				retValue = NECFIX_GIPS_API_apply(&nec_inst,
					NetEqSpeechOut, LinearSpeechIn, NECLinearSpeechOut);
				assert(retValue != -1);
				retValue = EG711U_GIPS_10MS16B_Encoder(EG_inst,
					NECLinearSpeechOut, EG711RTPData, &LengthOfEncodedData);
#endif /* NO_ECHO_CANCELLATION */
				assert(retValue != -1);
				if (LengthOfEncodedData != 0)
				{
					/* create RTP packet */
					RTPpacketLen = createRTPpackage(EG711RTPData,
						LengthOfEncodedData, 2, 0, 0, 0, 0,
						0, Sendtimestamp, ssrc, 97, rtpnumber, RTPpacket);
					Sendtimestamp += 160;
					++rtpnumber;
					if (sendto(socket_fd, RTPpacket, RTPpacketLen, 0,
						(struct sockaddr *)&addr, sizeof(addr)) == -1)
					{
						perror("sendto()");
						exit(1);
					}
				}
				// ========================================
				/* now see if other system has data for us -- only want whole buffer */
				if(-1 == (rc = recvfrom(socket_fd, RTPpacket, sizeof(RTPpacket), MSG_WAITALL,
					(struct sockaddr *)&addr, &recv_addr_len)))
				{
					if (errno != EAGAIN)
					{
						perror("recvfrom()");
						exit(1);
					}
				}
				else
				{
					if (rc >= 0)
					{
						Rectimestamp += 160;
						rc = NETEQ_GIPS_10MS16B_RecIn(NetEq_inst,
							RTPpacket, rc, Rectimestamp);
						if (rc != 0)
						{
							fprintf(stderr, "Error Inserting Data into NetEq\n");
						}
					}
					else
					{
						fprintf(stderr, "Huh?\n");
					}
				}
#endif /* INCLUDE_GIPS */
				break;
		}
	}
	return 0;
}



/* *************************** End of demo.c ****************************** */
