# ============================================================================
# WAN Router Configuration File.
# ============================================================================
# Protocol: Cisco HDLC  (CHDLC):  PRIMARY Port Configuration 
# ----------------------------------------------------------------------------

#*****************************************
# Device Definition Section              *
#*****************************************
#
# The [devices] section defines physical WAN connections. Each
# statement in this section has the following format:
#
# Usage: {device} = {protocol}, Comment
#
#        {device} : WAN device name; First card in the system
#                   must be named "wanpipe1".
#
#        {protocol} : WAN protocol currently supported:
#                             WAN_X25   generic X.25 configuration
#                             WAN_PPP   generic PPP configuration
#                             WAN_FR    generic frame relay configuration
#                             WAN_CHDLC generic Cisco HDLC configuration
#        

[devices]
wanpipe1 = WAN_CHDLC, Cisco HDLC

#****************************************
# Network Interfaces Definitions        *
#****************************************
#
# The [interfaces] section defines logical channels and corresponding
# network interfaces created by the router. Each statement in this section
# has the following format:
#
#       {interface name} = {device}, {media_addr}, {function}, Comment
#
#       Where:  {interface name} : Interface name must be the same
#                                  as interface file name defined in
#                                  /usr/local/wanrouter/interface.
#
#               {device}         : Defined above in [devices] section
#
#               {media_addr}     : Not used, leave blank 
#
#               {function}       : Options: WANPIPE or API
#                                     WANPIPE: used for routing chdlc packets.
#                                     API: used for raw socket interface to the
#                                          board.
#
# NOTE: CHDLC uses two ports PRI (primary high speed) and 
#       SEC (secondary low speed)
#       Each port is treated as a separate device, thus on one physical card, 
#       we can have two wanpipe devices defined for each port !! 
#
# NOTE: It is recomended that the PRIMARY port be used first. The
#       second port is optional !!!

[interfaces]

wp1_chdlc = wanpipe1, ,API, PRI port connection (high speed 2Mbps) 

#********************************************
# Link configuration section                *
#********************************************
#
# Each statement of the configuration section has the following format:
#
#       parameter=value
#
# where:
#       parameter       symbolic name of the configuration parameter.
#       value           number or symbolic name representing value of the
#                       configuration parameter.
#
# NOTE: A link configuration section must be specified for each device
#       defined in [device] section. The name must also be the same as
#       declared above in [devices]  
#
# For s508 Card:
#       Set the IOPort and IRQ options and
#       comment out the S514CPU and PCISlot options.
# For S514 PCI Card:
#       Set the S514CPU and PCISlot options and
#       comment out the IOPort and IRQ options
#
# Using PRI and SEC port on one card:
#     For S508 Card:
#           For both wanpipe1 and wanpipe1 definitions, IOport and IRQ 
#           must have the same values. 
#     For S514 Card:
#	    For both wanpipe1 and wanpipe1 definitions, S514CPU and
#           PCISlot must have the same values.
#     
#     This is know as 'piggybacking', since SEC port uses the resources
#     of the PRI port. 
#     

#------------------------ WANPIPE 1 -------------------------------------

[wanpipe1]			
	# ----- Hardware configuration ---------------
S514CPU         = A		# S514 PCI Card CPU: A or B      (s514 only)
AUTO_PCISLOT    = YES		# Autodetect pci slot		 (s514 only)
PCISlot         = 0		# PCI Slot num: 0 for autodetect (s514 only)
				#
#IOPort		= 0x360		# I/O port base                  (s508 only)
#IRQ		= 10		# interrupt request level        (s508 only)
				#
CommPort        = SEC		# PRI: High speed (2 MBps) primary port
				# SEC: Low speed (512 MBps) secondary port 
				#
Firmware	= /usr/local/wanrouter/firmware/cdual514.sfm	# adapter firmware
				#
				# ----- Dual Port Memory Base Address --------
#Memaddr	= 0xD0000	# Commenting this out enables Auto Memory 
				# selection. Valid Memory addresses are:
				# 0xA0000,0xA2000...0xAE000 / 0xC0000,0xC2000...
				# 0xCE000 / 0xD0000,0xD2000...0xDE000 / 0xE0000,
				# 0xE2000...0xEE000
				#
    	# ----- Physical interface configuration -----
Interface       = RS232           # physical interface type, RS232/V35
Clocking        = Internal      # Tx/Rx clock source, External/Internal
				#
				# * Jumpers must be set for internal or external
				#   clocking for: 
				#        s508 : RS232 SEC port 
				#        s514 : RS232 PRI and SEC port 
				#
				#
BaudRate        = 19200       # data transfer rate in bps, 1200..2048000
                                # Note: Max 256KBps for RS232 interface !!!
				#

Receive_only 	= NO            #   

    	# ----- Media-specific configuration ---------
MTU             = 1500          # maximum data transfer unit, bytes
TTL             = 0x7F          # Time To Live parameter for UDP packets
UDPPORT         = 9000          # UDP Port, used by cpipemon debugger


#*************************************************************
# Logical channel (interface) configuration sections.        *
#*************************************************************
#
# Each statement of the configuration section has the following format:
#
#       parameter=value
#
# where:
#       parameter       symbolic name of the configuration parameter
#       value           number or symbolic name representing value of the
#                       configuration parameter.
#
# Interface name must be the same as the interface file
# name defined in /usr/local/wanrouter/interfaces !
#
# Recomended nameing convention: (wp#_chldc)
#                        where wp# represents wanpipe1,2,3 ...   
#
# A Logical section must be defined for each interface name 
# defined in [interfaces] section.
#
# To turn OFF Dynamic IP addressing set SLARP_TIMER to 0.
                          


[wp1_chdlc]

	# --------- Link Management parameters ---------
MULTICAST 	= NO            # Enable Multicasting
				#
IGNORE_DCD 	= NO		# Ignore DCD when determining active link status
				# (YES/NO) Default: NO (ONLY USED FOR TESTING)
				#
IGNORE_CTS 	= NO		# Ignore CTS when determining active link status
				# (YES/NO) Default: NO (ONLY USED FOR TESTING)
				#
IGNORE_KEEPALIVE= NO		# Ignore Keep alives when determining active 
				# link status (YES/NO) Default: NO
				# (ONLY USED FOR TESTING)
				#
HDLC_STREAMING = YES		# Options YES or NO
				#   YES: Turns OFF cisco hdlc protocol
				#        and uses raw frames, and no polling.
				#    NO: Turns ON the cisco hdlc protocol 
				#
KEEPALIVE_TX_TIMER   = 10000	# Interval between Keep Alive (0-60000 ms) 
				# Default 10000ms
				#
KEEPALIVE_RX_TIMER   = 11000	# Interval to expect Keepalives (10-60000 ms)
				# Default 10000ms
				#
KEEPALIVE_ERR_MARGIN = 5	# Consecutive keepalive timeouts before bringing  
                                # down the link. Default 3, range: 1 - 20
				#
SLARP_TIMER 	= 0		# Used for DYNAMIC/STATIC IP addressing 
				#
				#   0    : Static IP addressing.
                                #          IP addresses are obtained from 
				#          the interface file: 
				#          (usr/lib/wanrouter/interfaces/wp1_chdlc)
				#
				#   Non Zero : Dynamic IP addressing.
				#              IP addresses are requested from 
                                #              the remote station.
				#              Valid values are from 1-6000(ms)
       				#              Default: 5000
				#              Note: A dummy interface file 
				#                    is still required !!!

				
ASYNC_MODE 		= YES   # Enables Async mode
ASY_DATA_TRANSPARENT  	= NO
RTS_HS_FOR_RECEIVE 	= NO 
XON_XOFF_HS_FOR_RECEIVE = NO
XON_XOFF_HS_FOR_TRANSMIT = NO
DCD_HS_FOR_TRANSMIT 	= NO
CTS_HS_FOR_TRANSMIT 	= NO
TX_BITS_PER_CHAR 	= 8		
RX_BITS_PER_CHAR 	= 8
STOP_BITS 		= ONE 
PARITY 			= NONE 
BREAK_TIMER 		= 50
INTER_CHAR_TIMER 	= 123
RX_COMPLETE_LENGTH 	= 20
XON_CHAR 		= 0xFE
XOFF_CHAR 		= 0xFF



#--------------------- END OF WANPIPE CONFIGURATION ------------------------
