/*
 * Copyright (c) 2001
 *	Alex Feldman <al.feldman@sangoma.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Alex Feldman.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Alex Feldman AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Alex Feldman OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	$Id: sdla_te1.h,v 1.1 2002/01/25 20:09:46 mrustad Exp $
 */

/*****************************************************************************
 * sdla_te1.h	Sangoma TE1 configuration definitions.
 *
 * Author:      Alex Feldman
 *
 * ============================================================================
 * Aprl 30, 2001	Alex Feldman	Initial version.
 ****************************************************************************
*/
#ifndef	_SDLA_TE1_H
#    define	_SDLA_TE1_H

#ifdef SDLA_TE1
# define EXTERN
#else
# define EXTERN extern
#endif

/*
 ******************************************************************************
			  DEFINES AND MACROS
 ******************************************************************************
*/
#define IS_TE1(te_cfg)	(te_cfg.media == WANOPT_MEDIA_T1 || 		\
			 te_cfg.media == WANOPT_MEDIA_E1) ? 1 : 0

#define IS_T1(wandev)	(wandev.te_cfg.media == WANOPT_MEDIA_T1)
#define IS_E1(wandev)	(wandev.te_cfg.media == WANOPT_MEDIA_E1)
 
#define NUM_OF_T1_CHANNELS	24
#define NUM_OF_E1_CHANNELS	32

/* Alram bit mask */
#define BIT_ALOS_ALARM		0x0001
#define BIT_LOS_ALARM		0x0002
#define BIT_ALTLOS_ALARM	0x0004
#define BIT_OOF_ALARM		0x0008
#define BIT_RED_ALARM		0x0010
#define BIT_AIS_ALARM		0x0020
#define BIT_OOSMF_ALARM		0x0040
#define BIT_OOCMF_ALARM		0x0080
#define BIT_OOOF_ALARM		0x0100
#define BIT_RAI_ALARM		0x0200
#define BIT_YEL_ALARM		0x0400
#define BIT_TE1_ALARM		0x8000	/* for Windows only */

/* Performamce monitor counter defines */
#define frm_bit_error		pmon1	/* E1/T1   */
#define oof_errors		pmon2	/* T1 only */
#define far_end_blk_errors	pmon2	/* E1 only */
#define bit_errors		pmon3	/* T1 only */
#define crc_errors		pmon3	/* E1 only */
#define lcv			pmon4	/* E1/T1   */

#define ALOS_ALARM(val)		(val & BIT_ALOS_ALARM) ? "ON" : "OFF"
#define LOS_ALARM(val)		(val & BIT_LOS_ALARM) ? "ON" : "OFF"
#define ALTLOS_ALARM(val)	(val & BIT_ALTLOS_ALARM) ? "ON" : "OFF"
#define OOF_ALARM(val)		(val & BIT_OOF_ALARM) ? "ON" : "OFF"
#define RED_ALARM(val)		(val & BIT_RED_ALARM) ? "ON" : "OFF"
#define AIS_ALARM(val)		(val & BIT_AIS_ALARM) ? "ON" : "OFF"
#define OOSMF_ALARM(val)	(val & BIT_OOSMF_ALARM) ? "ON" : "OFF"
#define OOCMF_ALARM(val)	(val & BIT_OOCMF_ALARM) ? "ON" : "OFF"
#define OOOF_ALARM(val)		(val & BIT_OOOF_ALARM) ? "ON" : "OFF"
#define RAI_ALARM(val)		(val & BIT_RAI_ALARM) ? "ON" : "OFF"
#define YEL_ALARM(val)		(val & BIT_YEL_ALARM) ? "ON" : "OFF"


/* T1/E1 UDP commands */
#define READ_PMC_REGISTER	0x90
#define SET_PMC_REGISTER	0x91

/* ALEX */
#define ACTIVATE_LINELB_MODE	0xA0
#define DEACTIVATE_LINELB_MODE	0xA1
#define ACTIVATE_PAYLB_MODE	0xA2
#define DEACTIVATE_PAYLB_MODE	0xA3
#define ACTIVATE_DDLB_MODE	0xA4
#define DEACTIVATE_DDLB_MODE	0xA5
#define ACTIVATE_LB_MODE	0xA6
#define DEACTIVATE_LB_MODE	0xA7

#define ACTIVATE_LOOPBACK	0x01
#define DEACTIVATE_LOOPBACK	0x02

/* Loopback commands (T1.107-1995 p.44) */
#define LINELB_TE1_TIMER	40	/* 40ms */
#define LINELB_CODE_CNT		10	/* no. of repetitions for lb_code */
#define LINELB_CHANNEL_CNT	10	/* no. of repetitions for channel */
#define LINELB_ACTIVATE_CODE	0x07
#define LINELB_DEACTIVATE_CODE	0x1C
#define LINELB_DS3LINE		0x1B
#define LINELB_DS1LINE_1	0x21	
#define LINELB_DS1LINE_2	0x22
#define LINELB_DS1LINE_3	0x23
#define LINELB_DS1LINE_4	0x24
#define LINELB_DS1LINE_5	0x25
#define LINELB_DS1LINE_6	0x26
#define LINELB_DS1LINE_7	0x27
#define LINELB_DS1LINE_8	0x28
#define LINELB_DS1LINE_9	0x29
#define LINELB_DS1LINE_10	0x2A
#define LINELB_DS1LINE_11	0x2B
#define LINELB_DS1LINE_12	0x2C
#define LINELB_DS1LINE_13	0x2D
#define LINELB_DS1LINE_14	0x2E
#define LINELB_DS1LINE_15	0x2F
#define LINELB_DS1LINE_16	0x30
#define LINELB_DS1LINE_17	0x31
#define LINELB_DS1LINE_18	0x32
#define LINELB_DS1LINE_19	0x33
#define LINELB_DS1LINE_20	0x34
#define LINELB_DS1LINE_21	0x35
#define LINELB_DS1LINE_22	0x36
#define LINELB_DS1LINE_23	0x37
#define LINELB_DS1LINE_24	0x38
#define LINELB_DS1LINE_25	0x39
#define LINELB_DS1LINE_26	0x3A
#define LINELB_DS1LINE_27	0x3B
#define LINELB_DS1LINE_28	0x3C
#define LINELB_DS1LINE_ALL	0x13
#define LINELB_DS1LINE_MASK	0x1F

/* Interrupt polling delay */
#define POLLING_TE1_TIMER	1000	/* 1 sec */

/* TE1 critical flag */
#define TE_TIMER_RUNNING 	0x01
#define TE_TIMER_KILL 		0x02
#define LINELB_WAITING		0x04
#define LINELB_CODE_BIT		0x08
#define LINELB_CHANNEL_BIT	0x10

/* TE1 timer flags */
#define TE_LINELB_TIMER		0x01
#define TE_LINKDOWN_TIMER	0x02
#define TE_SET_INTR		0x03

/* TE1 T1/E1 interrupt setting delay */
#define INTR_TE1_TIMER		50	/* 50 ms */

/*
 ******************************************************************************
			STRUCTURES AND TYPEDEFS
 ******************************************************************************
*/
typedef struct sdla_te_cfg {
	unsigned char media;
	unsigned char lcode;
	unsigned char frame;
	unsigned char lbo;
	unsigned char te_clock;
	unsigned long active_ch;
} sdla_te_cfg_t;

/* Performamce monitor counters */
typedef struct pmc_pmon {
	unsigned long pmon1;
	unsigned long pmon2;
	unsigned long pmon3;
	unsigned long pmon4;
} pmc_pmon_t;

#if defined (__KERNEL__) || defined (_KERNEL) || defined (KERNEL) || defined (__WINDOWS__)

#if defined (__FreeBSD__) || defined (__OpenBSD__)
# include <net/sdla_front_end.h>
# include <net/sdla_te1_def.h>
#elif defined (__WINDOWS__)
# include "sdla_front_end.h"
# include "sdla_te1_def.h"
#else
# include <linux/sdla_front_end.h>
# include <linux/sdla_te1_def.h>
#endif

/*
 ******************************************************************************
			  FUNCTION PROTOTYPES
 ******************************************************************************
*/
EXTERN short sdla_te_config(void*);
EXTERN void sdla_te_unconfig(void*);
EXTERN unsigned long sdla_te_alarm(void*, int);
EXTERN void sdla_te_pmon(void*);
EXTERN void sdla_flush_te1_pmon(void*);
EXTERN void sdla_te_intr(void*);
EXTERN void sdla_te_lineloopback(void*, int);
EXTERN int sdla_te_linelb(void*, int);
EXTERN int sdla_te_paylb(void*, int);
EXTERN int sdla_te_ddlb(void*, int);
EXTERN void sdla_te_polling(void* card_id);
#if defined(__FreeBSD__) || defined(__OpenBSD__)
EXTERN void sdla_te_timer(void*);
#elif defined(__WINDOWS__)
EXTERN void sdla_te_timer(void*,void*,void*,void*);
#else
EXTERN void sdla_te_timer(unsigned long);
#endif
EXTERN int sdla_te_lb(void*, unsigned char);
#endif /* __KERNEL__ || _KERNEL || KERNEL || __WINDOWS__ */

#undef EXTERN

#endif /* _SDLA_TE1_H */
