/*************************************************************************
 sdla_edu.h	Sangoma Educatonal Kit definitions

 Author:      	David Rokhvarg <drokhvarg@sangoma.com>	

 Copyright:	(c) 2001 Sangoma Technologies Inc.

		This program is free software; you can redistribute it and/or
		modify it under the term of the GNU General Public License
		as published by the Free Software Foundation; either version
		2 of the License, or (at your option) any later version.

===========================================================================
  Sept 10, 2001  David Rokhvarg    Initial version
===========================================================================

 Organization
	- Constants defining the shared memory control block (mailbox)
	- IOCTL codes
	- Structures for performing IOCTLs

*************************************************************************/

#ifndef _SDLA_EDU_H
#  define _SDLC_EDU_H

/*------------------------------------------------------------------------
   Notes:

	All structres defined in this file are byte-aligned.  

	Compiler	Platform
	------------------------
	GNU C		Linux

------------------------------------------------------------------------*/

#ifndef	PACKED
#define	PACKED __attribute__((packed))
#endif	/* PACKED */

#define MAX_DATA_LENGTH		4096

#define IOCTL_READ_BLOCK	1
#define IOCTL_WRITE_BLOCK	2
#define IOCTL_REGISTER_CARD	3
#define IOCTL_DEREGISTER_CARD	4
#define IOCTL_SETUP		5
#define IOCTL_CLEAN_UP		6
#define IOCTL_LOAD		7
#define IOCTL_START_CODE_LOADING	8
#define IOCTL_COPY_FIRMWARE		9

typedef struct edu_exec_cmd{
	unsigned char  ioctl PACKED;                   	// the ioctl code
	unsigned char  return_code PACKED;
	unsigned short buffer_length PACKED;           	// the data length
	unsigned long  offset	PACKED;			// offset on the card
}edu_exec_cmd_t;
 
#endif	/* _SDLA_EDU_H */


