/*	$Id: main.c,v 1.3 2003/02/25 23:30:32 m4 Exp $	*/
/*
 * main.c - Main program for bcopytst
 *
 * Mark D. Rustad, 01/21/2002
 *
 * Copyright BRECIS Corp. 2002, all rights reserved.
 */

#include <stdlib.h>
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>

#include <asm/brecis/BrecisTriadMap.h>
#include <brecis/dma_bcopy.h>

void dump(char *addr, int len);


int	main(int argc, char *argv[])
{
	int	fd;
	int	result;
	static char	buf[80] =
		{ "1234567890 ABCDEFGHIJKLMNOPQRSTUVWXYZ "
		  "abcdefghijklmnopqrstuvwxyz "
		};
	char	obuf[80];
	cpy_ioctl	ctl;

	printf("bcopytst\n");

	printf("opening bcopy device\n");

	fd = open(COPYDEV, O_RDWR);

	if (fd < 0)
	{
		perror(COPYDEV);
   		fprintf(stderr, "failed to open %s\n", COPYDEV);
		fflush(stderr);
		exit(1);
	}

	printf("bcopy device opened\n");

	printf("dest before bcopy:\n");
	dump(obuf, 80);

	ctl.mode = BC_CP_DINC_SINC_NINT_MODE;
	ctl.length = 40;
	ctl.src = &buf;
	ctl.dest = &obuf;

	result = ioctl(fd, BRECIS_COPY_CTL, &ctl);
	printf("ioctl result = %d\n", result);

	printf("dest after bcopy:\n");
	dump(obuf, 80);

	return 0;
}


void	dump(char *addr, int len)
{
	char *p;
	int n,i,a;
	a=0;
	while(len > 0) {
		n = (len < 16) ? len : 16;
		printf("%08x  ",a);
		p = addr;
		for(i=0; i<n; i++,p++) {
			printf("%02X ",*p & 0xff);
			if(i == 7) printf("- ");
		}
		if(i == 7) printf("  ");
		while(i++ < 16) {
			printf("   ");
			if(i == 7) printf("  ");
		}
		printf("   ");
		p = addr;
		for(i=0; i<n; i++,p++) {
			if((*p < 0x7f) && (*p > 0x1f)) 
				printf("%c",*p);
			else
				printf(".");
		}
		printf("\n");
		addr += 16;
		a += 16;
		len -= n;
	}
}


/* End of main.c */

