/*
  $Header: /proj/software/pub/CVSROOT/uClinux/brecis/slac/slactest.c,v 1.4 2002/06/28 02:10:48 sjoshi Exp $
*/
/****************************************************************************
 *
 * Program to test SLAC driver
 *  
 *****************************************************************************/

/******************************************************************/
/* Copyright (c) 2001 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/telephony.h>


#define SLAC0 "/var/phone0"

void getdata(int);
int slac = -1;
int main(int argc,char **argv)
{
	int oflags1;

	slac = open(SLAC0,O_RDWR);
	if (slac < 1)
	{
		printf("Error Opening SLAC Device %s \n",SLAC0);
		perror("open ");
		return (-1);
	}

	signal(SIGIO, &getdata);
	fcntl(slac, F_SETOWN, getpid());
	oflags1 = fcntl(slac, F_GETFL);
	fcntl(slac, F_SETFL, oflags1 | FASYNC);

	getchar();

	close(slac);
	return(0);
}

void getdata(int x)
{
	  fd_set  rfds,wfds,efds;
	  struct timeval tv;
	  int hookState =-1;
	  int nmax = slac+1;
	  static int count=0;
	  FD_ZERO(&rfds);
	  FD_ZERO(&wfds);
	  FD_ZERO(&efds);
	  FD_SET(slac, &rfds);
	  FD_SET(slac, &wfds);
	  FD_SET(slac, &efds);

	  tv.tv_sec =0 ;
	  tv.tv_usec =30;

	  select(nmax,&rfds, &wfds, &efds, &tv);
	  if(FD_ISSET(slac,&efds)) 
	  {
		  hookState = ioctl(slac,PHONE_HOOKSTATE);
	  }
	  switch(hookState)
	  {
	  case  PSTN_ON_HOOK:
		  printf("Phone ON Hook :%d\n ",count++);
		  break;
	  case  PSTN_OFF_HOOK:
		  printf("Phone OFF Hook :%d\n ",count++);
		  break;
	  default:
		  printf("Phone State %d :%d\n",hookState,count++);
		  break;
	  }
}
