
#define MSP_SUCCESS 0
#define ERROR -1
#define OK 0
extern int errno ;

typedef void (*SecCompletionFunc) (unsigned int callerRefId,
				   unsigned int status);

typedef struct {
	U32			            Key1High;
	U32			            Key1Low;
	U32						Key1Mode;
	U32			            Key2High;
	U32			            Key2Low;
	U32						Key2Mode;
	U32			            Key3High;
	U32			            Key3Low;
	U32						Key3Mode;
} msp_sec_3des_key;

typedef struct {
	U32			IVHigh;
	U32			IVLow;
} msp_sec_des_iv;


typedef struct {
	U32	ChainVarA;
	U32	ChainVarB;
	U32	ChainVarC;
	U32	ChainVarD;
	U32	ChainVarE;
} msp_sec_hsh_chaining_vars;

int secapi_fd ;

extern void perror() ;
extern int ioctl() ;

#define CHECK_SEC_FD { \
		if (secapi_fd <= 0) secapi_fd = open(SECDEV,0) ; \
		if (secapi_fd <= 0) { perror(SECDEV) ; return -1 ; } \
	}
 

static inline int MspSecDESXncryptFast(void *src, void *dst,
			   msp_sec_3des_key *key,
			   msp_sec_des_iv *iv,
			   int length, int mode)
{
	sec_ioctl desc ;
	int rc ;

	CHECK_SEC_FD ;

	desc.status    = 0 ;
	desc.type      = MSP_SEC_DES ;
	desc.options   = mode & MSP_SEC_DO_PADDING ;
	desc.cbufcount = 0 ;
	desc.cbuflist  = NULL ;
	desc.buflen    = length ;
	desc.srcaddr   = src ;
	desc.dstaddr   = dst ;
	desc.ivhigh    = iv->IVHigh ;
	desc.ivlow     = iv->IVLow ;

	desc.desc_key1low  = key->Key1Low ;
	desc.desc_key1high = key->Key1High ;
	desc.desc_key2low  = key->Key2Low ;
	desc.desc_key2high = key->Key2High ;
	desc.desc_key3low  = key->Key3Low ;
	desc.desc_key3high = key->Key3High ;

	desc.mode = mode ;
	if (mode & DMC_3DES)
		desc.mode |= key->Key1Mode | key->Key2Mode | key->Key3Mode ;

	if ( (rc = ioctl(secapi_fd, MSP_SEC_CTL, &desc)) )
	{
		printf("ioctl failed\n") ;
		return rc ;
	}

	return desc.status ;
}

#define MspSecDESXncryptBlk MspSecDESXncryptFast

static inline int MspSecDESXncrypt(unsigned int id,
			      void *src,
			      void *dst,
			      msp_sec_3des_key *key,
			      msp_sec_des_iv *iv,
			      int length,
			      int mode,
			      SecCompletionFunc comp)
{
	int rc ;
	rc = MspSecDESXncryptFast(src, dst, key, iv, length, mode) ;
	comp(id, rc) ;

	return rc ;
}

/* Chain building:  for now assuming building one chain at a time. */

int curchain ;
sec_cbuf chainbufs[64] ;

static inline int MspSecBuildChain(int *chainid,
			       int length,
			       void *src, void *dst)
{
	if(curchain >= 64)
		return -1 ;

	chainbufs[curchain].buflen  = length ;
	chainbufs[curchain].srcaddr = src ;
	chainbufs[curchain].dstaddr = dst ;

	curchain++ ;
	return 0 ;
		
}
	

	
static inline int MspSecDESXncryptChain(unsigned int id,
				   int chain,
				   msp_sec_3des_key *key,
				   msp_sec_des_iv *iv,
				   int mode,
				   SecCompletionFunc comp)
{
	sec_ioctl desc ;
	int rc ;

	CHECK_SEC_FD ;

	desc.status    = 0 ;
	desc.type      = MSP_SEC_DES ;
	desc.options   = mode & MSP_SEC_DO_PADDING ;
	desc.cbufcount = curchain - 1 ;
	desc.cbuflist  = &chainbufs[1] ;
	desc.buflen    = chainbufs[0].buflen ;
	desc.srcaddr   = chainbufs[0].srcaddr ;
	desc.dstaddr   = chainbufs[0].dstaddr ;
	desc.ivhigh    = iv->IVHigh ;
	desc.ivlow     = iv->IVLow ;

	desc.desc_key1low  = key->Key1Low ;
	desc.desc_key1high = key->Key1High ;
	desc.desc_key2low  = key->Key2Low ;
	desc.desc_key2high = key->Key2High ;
	desc.desc_key3low  = key->Key3Low ;
	desc.desc_key3high = key->Key3High ;

	desc.mode = mode ;
	if (mode & DMC_3DES)
		mode |= key->Key1Mode | key->Key2Mode | key->Key3Mode ;

	rc = ioctl(secapi_fd, MSP_SEC_CTL, &desc) ;
	if (rc == 0)
		rc = desc.status ;
	else
		printf("ioctl failed, rc %d, errno %d\n", rc, errno) ;

	curchain = 0 ;

	if(comp)
		comp(id, rc) ;

	return rc ;
}

#define MspSecDESXncryptChainFast(chain, key, iv, mode) \
		MspSecDESXncryptChain(0, chain, key, iv, mode, 0)


static inline int MspSecHshFast(void *src, void *dst,
			    int length,
			    msp_sec_hsh_chaining_vars *chainvars,
			    int mode)
{
	sec_ioctl desc ;
	int rc ;

	CHECK_SEC_FD ;

	desc.status    = 0 ;
	desc.type      = MSP_SEC_HASH ;
	desc.options   = mode & MSP_SEC_DO_PADDING ;
	desc.cbufcount = 0 ;
	desc.cbuflist  = NULL ;
	desc.buflen    = length ;
	desc.srcaddr   = src ;
	desc.dstaddr   = dst ;

	if(chainvars)
		memcpy((void *)&desc.chainvar[0], (void *)chainvars, sizeof(*chainvars)) ;

	desc.mode = mode & ~MSP_SEC_DO_PADDING ;

	if ( (rc = ioctl(secapi_fd, MSP_SEC_CTL, &desc)) )
	{
		printf("ioctl failed\n") ;
		return rc ;
	}
	return desc.status ;
}

#define MspSecHshBlk MspSecHshFast

static inline int MspSecHsh(unsigned int id,
			void *src,
			void *dst,
			int length,
			msp_sec_hsh_chaining_vars *chainvars,
			int mode,
			SecCompletionFunc comp)
{
	int rc ;
	rc = MspSecHshFast(src, dst, length, chainvars, mode) ;
	comp(id, rc) ;
	return rc ;
}

static inline int MspSecHshChain(unsigned int id,
			     int chain,
			     msp_sec_hsh_chaining_vars *chainvars,
			     int mode,
			     SecCompletionFunc comp)
{
	sec_ioctl desc ;
	int rc ;

	CHECK_SEC_FD ;

	desc.status    = 0 ;
	desc.type      = MSP_SEC_HASH ;
	desc.options   = mode & MSP_SEC_DO_PADDING ;
	desc.cbufcount = curchain - 1 ;
	desc.cbuflist  = &chainbufs[1] ;
	desc.buflen    = chainbufs[0].buflen ;
	desc.srcaddr   = chainbufs[0].srcaddr ;
	desc.dstaddr   = chainbufs[0].dstaddr ;

	memcpy((void *)chainvars, (void *)&desc.chainvar[0], sizeof(*chainvars)) ;

	desc.mode = mode & ~MSP_SEC_DO_PADDING ;

	rc = ioctl(secapi_fd, MSP_SEC_CTL, &desc) ;
	if (rc == 0)
		rc = desc.status ;
	else
		printf("ioctl failed\n") ;


	curchain = 0 ;

	if(comp)
		comp(id, rc) ;

	return rc ;
}

#if 0

static inline int MspSecHshHMACFast(void *src, void *dst,
				int length,
				msp_sec_hsh_chaining_vars *chainvars,
				unsigned int keylength,
				unsigned char *key,
				int mode)
{
	sec_ioctl desc ;
	sec_cbuf  cbuf ;
	int rc ;

	CHECK_SEC_FD ;

	desc.status    = 0 ;
	desc.type      = MSP_SEC_HMAC ;
	desc.options   = mode & MSP_SEC_DO_PADDING ;
	desc.cbufcount = 1 ;
	desc.cbuflist  = &cbuf ;
	desc.buflen    = keylength ;
	desc.srcaddr   = key ;
	desc.dstaddr   = dst ;

	cbuf.buflen    = length ;
	cbuf.srcaddr   = src ;
	cbuf.dstaddr   = dst ;

	memcpy((void *)chainvars, (void *)&desc.chainvar[0], sizeof(*chainvars)) ;

	desc.mode = mode & ~MSP_SEC_DO_PADDING ;

	if ( (rc = ioctl(secapi_fd, MSP_SEC_CTL, &desc)) )
	{
		printf("ioctl failed\n") ;
		return rc ;
	}

	return desc.status ;
}

#else

static inline int MspSecHshHMACFast(void *src, void *dst,
				int length,
				msp_sec_hsh_chaining_vars *chainvars,
				unsigned int keylength,
				unsigned char *key,
				int mode)
{
	/* Do the second version of hashing, with the pre-calculated */
	/* partial hashes for the key */

	sec_ioctl desc ;
	sec_cbuf  cbuf ;
	unsigned char ipad[20], opad[20] ;
	unsigned char hash_buf[HSH_BLK] ;
	int rc ;
	int hashlen ;
	int i;

	CHECK_SEC_FD ;

	if (mode & HMC_SHA1)
		hashlen = 20 ;
	else
		hashlen = 16 ;

	/* if key is longer than blocksize, hash it down to size */

	if (keylength <= HSH_BLK)
	{
		for (i = 0 ; i < keylength ; i++)
			hash_buf[i] = key[i] ^ 0x36 ;

		for ( ; i < HSH_BLK; i++)
			hash_buf[i] = 0x36 ;
	}
	else
	{
		desc.status    = 0 ;
		desc.type      = MSP_SEC_HASH ;
		desc.options   = MSP_SEC_DO_PADDING ;
		desc.cbufcount = 0 ;
		desc.cbuflist  = 0 ;
		desc.buflen    = keylength ;
		desc.srcaddr   = key ;
		desc.dstaddr   = hash_buf ;
		desc.mode      = mode & HMC_SHA1 ;

		if ( (rc = ioctl(secapi_fd, MSP_SEC_CTL, &desc)) )
		{
			printf("ioctl failed\n") ;
			return rc ;
		}

		if (desc.status)
		{
			printf("ioctl status was %d\n", desc.status) ;
			return desc.status ;
		}

		for (i = 0 ; i < hashlen; i++)
			hash_buf[i] ^= 0x36 ;
		for ( ; i < HSH_BLK; i++)
			hash_buf[i] = 0x36 ;
	
	}

	/* compute inner partial hash */

	desc.status    = 0 ;
	desc.type      = MSP_SEC_HASH ;
	desc.options   = 0 ;
	desc.cbufcount = 0 ;
	desc.cbuflist  = 0 ;
	desc.buflen    = HSH_BLK ;
	desc.srcaddr   = hash_buf ;
	desc.dstaddr   = ipad ;
	desc.mode      = mode & HMC_SHA1 ;
	
	if ( (rc = ioctl(secapi_fd, MSP_SEC_CTL, &desc)) )
	{
		printf("ioctl failed\n") ;
		return rc ;
	}

	if (desc.status)
	{
		printf("ioctl status was %d\n", desc.status) ;
		return desc.status ;
	}

	/*
	** Create (K XOR opad) from ( (K XOR ipad) XOR (ipad XOR opad) )
	*/
	for (i = 0 ; i < (HSH_BLK/4) ; i++)
		((unsigned long *)hash_buf)[i] ^= 0x6A6A6A6AUL ;

	/* compute outer partial hash */

	desc.status    = 0 ;
	desc.type      = MSP_SEC_HASH ;
	desc.options   = 0 ;
	desc.cbufcount = 0 ;
	desc.cbuflist  = 0 ;
	desc.buflen    = HSH_BLK ;
	desc.srcaddr   = hash_buf ;
	desc.dstaddr   = opad ;
	desc.mode      = mode & HMC_SHA1 ;
	
	if ( (rc = ioctl(secapi_fd, MSP_SEC_CTL, &desc)) )
	{
		printf("ioctl failed\n") ;
		return rc ;
	}

	if (desc.status)
	{
		printf("ioctl status was %d\n", desc.status) ;
		return desc.status ;
	}

	
	

	desc.status    = 0 ;
	desc.type      = MSP_SEC_HMAC2 ;
	desc.options   = 0 ;
	desc.cbufcount = 1 ;
	desc.cbuflist  = &cbuf ;
	desc.buflen    = hashlen ;
	desc.srcaddr   = ipad ;
	desc.dstaddr   = opad ;

	cbuf.buflen    = length ;
	cbuf.srcaddr   = src ;
	cbuf.dstaddr   = dst ;

	desc.mode = mode & ~MSP_SEC_DO_PADDING ;

	if ( (rc = ioctl(secapi_fd, MSP_SEC_CTL, &desc)) )
	{
		printf("ioctl failed\n") ;
		return rc ;
	}

	return desc.status ;
}

#endif
