
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>

#include <brecis/msp_sec.h>

void dump(char *addr, int len) ;

int secfd ;

#define PASSES 200000

#define MAX_DESC 4
#define DESC_SZ 256 

#define MUNGE_INDEX(tr, ty, lo, ex) \
 ( (tr * 0x1) + (ty * 0x2) + (ex * 0x8) + (lo * 0x10) )
int timings [ 256 ] ;

void
des_single_timing(int triple, int type, int layout, int extra64)
{
	static int ib[( (MAX_DESC * DESC_SZ) + 64 ) / 4] ;
	static int ob[( (MAX_DESC * DESC_SZ) + 64 ) / 4] ;
	static unsigned char *ibuf = (unsigned char *)ib ;
	static unsigned char *obuf = (unsigned char *)ob ;
	sec_ioctl secparm ;
	sec_cbuf  contbuf[MAX_DESC] ;
	int numdesc ;
	int i ;
	int remain ;
	struct timeval tv1, tv2 ;

	numdesc = layout + 1 ;

	printf("*** %sDES test with %d descriptors, ",
	       triple?"3":"", numdesc) ;
	if (extra64)
		printf("with extra 64 bytes, total %d bytes, ",
		       MAX_DESC * DESC_SZ + 64) ;
	else
		printf("total %d bytes, ", MAX_DESC * DESC_SZ) ;
	if (type)
		printf("in CBC mode:\n") ;
	else
		printf("in ECB mode:\n") ;
	

	/* fill buffer with something */
	for (i = 0 ; i < sizeof(ib); i++)
	{
		ibuf[i] = i & 0xff ;
		obuf[i] = 0 ;
	}

	/* fill in the security ioctl structure */
	/* to do a DES encryption */
	secparm.type = MSP_SEC_DES ;
	secparm.options = 0 ;
	secparm.cbufcount = numdesc - 1 ;
	if (extra64)
		secparm.cbufcount ++ ;
	secparm.cbuflist = &contbuf[0] ;
	secparm.buflen = (numdesc == 1) ? (MAX_DESC * DESC_SZ) : DESC_SZ ;
	secparm.srcaddr = ibuf ;
	secparm.dstaddr = obuf ;

	if (triple)
	{
		secparm.mode = DMC_3DES | DMC_MOD_ENC ;
		secparm.mode |= DMC_K1_ENC | DMC_K2_DEC | DMC_K3_ENC ;
	}
	else
		secparm.mode = DMC_MOD_ENC ;
	if (type)
		secparm.mode |= DMC_MOD_CBC ;
		
	secparm.ivhigh = 0x01020304 ;
	secparm.ivlow  = 0xFEFDFCFB ;

	secparm.desc_key1low  = 0xCCDDAABB ;
	secparm.desc_key1high = 0xEE11FF22 ;
	secparm.desc_key2low  = 0xBA98FEDC ;
	secparm.desc_key2high = 0x32107654 ;
	secparm.desc_key3low  = 0xCCDDAABB ;
	secparm.desc_key3high = 0xEE11FF22 ;

	remain = (MAX_DESC * DESC_SZ) - secparm.buflen ;

	for(i = 0 ; i < numdesc-1 ; i++)
	{
		contbuf[i].buflen = DESC_SZ ;
		remain -= DESC_SZ ;
		contbuf[i].srcaddr = &ibuf[DESC_SZ * (i + 1)] ;
		contbuf[i].dstaddr = &obuf[DESC_SZ * (i + 1)] ;
	}
	contbuf[i-1].buflen += remain ;

	if (extra64)
	{
		contbuf[i].buflen = 64 ;
		contbuf[i].srcaddr = &ibuf[MAX_DESC * DESC_SZ] ;
		contbuf[i].dstaddr = &obuf[MAX_DESC * DESC_SZ] ;
	}

	gettimeofday(&tv1, NULL) ;
	for(i = 0 ; i < PASSES; i++)
	{
		ioctl(secfd, MSP_SEC_CTL, &secparm) ;
	}
	gettimeofday(&tv2, NULL) ;

	tv2.tv_sec -= tv1.tv_sec ;
	tv2.tv_usec -= tv1.tv_usec ;
	if (tv2.tv_usec < 0)
	{
		tv2.tv_usec += 1000000 ;
		tv2.tv_sec -= 1 ;
	}

	printf("     %d des operations in %ld ms\n\n", PASSES,
	       tv2.tv_sec * 1000 + tv2.tv_usec / 1000) ;

	timings[ MUNGE_INDEX(triple, type, layout, extra64) ] =
		tv2.tv_sec * 1000 + tv2.tv_usec / 1000 ;

}



	

void
des_timings(void)
{
	int triple ;		/* 0 = DES, 1 = 3des */
	int type ;		/* 0 = ECB, 1 = CBC */
	int layout ;
	int extra ;

	printf("Sleep to allow output to drain...\n") ;
	sleep(5) ;

	for (triple = 1 ; triple < 2 ; triple ++)
	{
		for (type = 1; type < 2 ; type++)
		{
			for (extra = 0 ; extra < 2 ; extra++)
				for (layout = 0 ; layout < 3 ; layout ++)
				{
					des_single_timing(triple, type, layout, extra) ;
				}
		}
	}

	printf("\n%d Passes, times in ms:\n", PASSES) ;
	printf("NDESC	ECB DES		CBC DES		ECB 3DES	CBC 3DES\n") ;
	for (extra = 0 ; extra < 2 ; extra++)
	{
		for (layout = 0 ; layout < 3 ; layout++)
		{
			
			printf("%d%s\t%d\t\t%d\t\t%d\t\t%d\n",
			       layout + 1,
			       extra ? "+" : "",
			       timings[ MUNGE_INDEX(0, 0, layout, extra) ],
			       timings[ MUNGE_INDEX(0, 1, layout, extra) ],
			       timings[ MUNGE_INDEX(1, 0, layout, extra) ],
			       timings[ MUNGE_INDEX(1, 1, layout, extra) ]) ;
		}
	}

}


/* example user level security engine code */

int
main(int argc, char **argv)
{
	int i ;
#if 0
	time_t t1, t2 ;
#endif
	static unsigned char buf[512] ;
#if 0
	unsigned char hash[20], hash1[20] ;
	unsigned char *secret = "secret" ;
	sec_cbuf  contbuf[1] ;
#endif
	sec_ioctl secparm ;
	struct timeval tv1, tv2 ;

	printf("opening security device\n") ;

	secfd = open(SECDEV, O_RDWR) ;

	if(secfd < 0)
	{
		perror(SECDEV) ;
   		printf("failed to open %s\n", SECDEV) ;
		fflush(stdout) ;
		exit(1) ;
	}

	printf("sec device opened\n") ;

	/* fill buffer with something */
	for (i = 0 ; i < 512; i++)
		buf[i] = i & 0xff ;

#if 0
	/* fill in the security ioctl structure */
	/* this time do a DES encryption */
	secparm.type = MSP_SEC_DES ;
	secparm.options = 0 ;
	secparm.cbufcount = 0 ;
	secparm.cbuflist = NULL ;
	secparm.buflen = 512 ;
	secparm.srcaddr = buf ;
	secparm.dstaddr = buf ;

	secparm.mode = DMC_3DES | DMC_MOD_ENC | DMC_MOD_CBC ;
	secparm.mode |= DMC_K1_ENC | DMC_K2_DEC | DMC_K3_ENC ;
	
	secparm.ivhigh = 0x01020304 ;
	secparm.ivlow  = 0xFEFDFCFB ;

	secparm.desc_key1low  = 0xCCDDAABB ;
	secparm.desc_key1high = 0xEE11FF22 ;
	secparm.desc_key2low  = 0xBA98FEDC ;
	secparm.desc_key2high = 0x32107654 ;
	secparm.desc_key3low  = 0xCCDDAABB ;
	secparm.desc_key3high = 0xEE11FF22 ;

	printf("doing first ioctl\n") ;

	ioctl(secfd, MSP_SEC_CTL, &secparm) ;

	printf("encrypted message:\n") ;
	dump(buf, 512) ;
	printf("\n\n") ;

	/*
	** now, calculate a hash from the concatenation of a secret
	** word and the message.
	*/

	secparm.type = MSP_SEC_HASH ;
	secparm.options = 0 ;
	secparm.cbufcount = 1 ;
	secparm.cbuflist  = &contbuf[0] ;
	secparm.buflen = strlen(secret) ;
	secparm.srcaddr = secret ;
	secparm.dstaddr = hash ;

	secparm.mode = HMC_SHA1 | HMC_CHAIN_DEFAULT ;

	contbuf[0].buflen = 512 ;
	contbuf[0].srcaddr = buf ;
	contbuf[0].dstaddr = hash ;

	/*
	** don't have to fill in secparm.chainvar_x because we are
	** using defaults.
	*/

	memset(hash, 0, 20) ;
	printf("hash results before call:\n") ;
	dump(hash, 20) ;

	printf("doing second ioctl\n") ;

	ioctl(secfd, MSP_SEC_CTL, &secparm) ;

	printf("hash value:\n") ;
	dump(hash, 20) ;

	contbuf[0].buflen -= secparm.buflen ;
#if 1
	printf("timing operations\n") ;

	i = 0 ;
	t1 = time(NULL) ;
	while( (t2 = time(NULL)) == t1 ) ;
	t1 = t2 + 10 ;

	while (t1 != t2)
	{
		ioctl(secfd, MSP_SEC_CTL, &secparm) ;
		i++ ;
		t2 = time(NULL) ;
	}

	printf("%d hash computations in 10 seconds\n", i) ;
#else
	ioctl(secfd, MSP_SEC_CTL, &secparm) ;
#endif

	printf("hash value, second time:\n") ;
	dump(hash, 20) ;


	secparm.type = MSP_SEC_HASH ;
	secparm.options = 0 ;
	secparm.cbufcount = 0 ;
	secparm.cbuflist = 0 ;
	secparm.buflen = 512 ;
	secparm.srcaddr = buf ;
	secparm.dstaddr = hash ;
	secparm.mode = HMC_MD5 | HMC_CHAIN_DEFAULT ;

	memset(hash, 0, 20) ;

	ioctl(secfd, MSP_SEC_CTL, &secparm) ;

	printf("First hash of loop:\n") ;
	dump(hash, 20) ;

	for (i = 1 ; i < 511 ; i++)
	{

		printf("%d, ", i) ;
		fflush(stdout) ;
		secparm.type = MSP_SEC_HASH ;
		secparm.options = 0 ;
		secparm.cbufcount = 1 ;
		secparm.cbuflist  = &contbuf[0] ;
		secparm.buflen = i ;
		secparm.srcaddr = buf ;
		secparm.dstaddr = hash1 ;

		secparm.mode = HMC_MD5 | HMC_CHAIN_DEFAULT ;

		contbuf[0].buflen = 512-i ;
		contbuf[0].srcaddr = buf+i ;
		contbuf[0].dstaddr = hash1 ;

		memset(hash1, 0, 20) ;

		ioctl(secfd, MSP_SEC_CTL, &secparm) ;

		if(memcmp(hash, hash1, 20))
		{
			printf("\n**** mismatch.\n hash:\n") ;
			dump(hash, 20) ;
			printf("\nhash1:\n") ;
			dump(hash1, 20) ;
			printf("\n\n") ;
		}
	}

	printf("Timing split operations\n") ;

	i = 0 ;
	t1 = time(NULL) ;
	while( (t2 = time(NULL)) == t1 ) ;
	t1 = t2 + 10 ;

	while (t1 != t2)
	{
		ioctl(secfd, MSP_SEC_CTL, &secparm) ;
		i++ ;
		t2 = time(NULL) ;
	}

	printf("\n%d split hash computations in 10 seconds\n", i) ;


#endif
	printf("testing ioctl overhead:\n") ;
	
	gettimeofday(&tv1, NULL) ;
	for(i = 0 ; i < PASSES; i++)
	{
		ioctl(secfd, 11, &secparm) ;
	}
	gettimeofday(&tv2, NULL) ;

	tv2.tv_sec -= tv1.tv_sec ;
	tv2.tv_usec -= tv1.tv_usec ;
	if (tv2.tv_usec < 0)
	{
		tv2.tv_usec += 1000000 ;
		tv2.tv_sec -= 1 ;
	}

	printf("\n%d bad ioctl calls in %ld ms\n", PASSES,
	       tv2.tv_sec * 1000 + tv2.tv_usec / 1000) ;

	des_timings() ;


	printf("\nfinished\n") ;

	exit(0) ;
}

	

void
dump(char *addr, int len)
{
	char *p;
	int n,i,a;
	a=0;
	while(len > 0) {
		n = (len < 16) ? len : 16;
		printf("%08x  ",a);
		p = addr;
		for(i=0; i<n; i++,p++) {
			printf("%02X ",*p & 0xff);
			if(i == 7) printf("- ");
		}
		if(i == 7) printf("  ");
		while(i++ < 16) {
			printf("   ");
			if(i == 7) printf("  ");
		}
		printf("   ");
		p = addr;
		for(i=0; i<n; i++,p++) {
			if((*p < 0x7f) && (*p > 0x1f)) 
				printf("%c",*p);
			else
				printf(".");
		}
		printf("\n");
		addr += 16;
		a += 16;
		len -= n;
	}
}
