
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <time.h>
#include <stdlib.h>

#include <brecis/msp_sec.h>

/* manipulate kernel test module */
int
main(int argc, char **argv)
{
	int i, fd ;
	
	if (argc != 2)
	{
		fprintf(stderr, "Usage: %s {value}\n", argv[0]) ;
		fflush(stderr) ;
		exit(1) ;
	}

	i = atoi(argv[1]) ;
	fd = open("/var/sectest", O_RDWR) ;
	if (fd < 0)
	{
		perror("/var/sectest") ;
		fprintf(stderr, "failed to open /var/sectest\n") ;
		fflush(stderr) ;
		exit(1) ;
	}

	i = ioctl(fd, 42, i) ;
	if( i < 0 )
		perror("ioctl") ;
	printf("ioctl returns %d\n", i)  ;

	return 0 ;
}
