/*
** Test new version 2 api, concentrating on new features (ESP, AES)
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <brecis/msp_secv2.h>

int GlobalErrors ;

typedef unsigned char  uchar ;
//typedef unsigned short ushort ;
//typedef unsigned int   uint ;


typedef enum {
    CRYPT, HASH, HASHPAD, HMAC, ESPIN, ESPOUT
} ENG_MODE;

typedef enum {
    DES, TRIPLEDES, AES128, AES192, AES256, CRYPTALGNU
} CRYPT_ALG;

typedef enum {
    ECB, CTR, CBCD, CBCE, CFBE, CFBD, OFB, BLKMODENU
} CRYPT_BLK_MODE;

typedef enum {
    INCOMING, OUTGOING, CRYPTDIRNU
} CRYPT_DIR;

typedef enum {
    MD5, SHA1, MD596, SHA196, AALGNULL, AUTHALGNU
} AUTH_ALG;

typedef enum {
    DEFAULT, USER, AUTHUCVNU
} AUTH_UCV;

typedef enum {
    CMPARE, NOCMPARE, CPINU
} COMP_ICV;

typedef enum {
    USERNG, NORNG, CRINU
} CREA_IV;

typedef enum {
    INCREM, NOINCREM, SINU
} INC_SEQ;

typedef enum {
    INTERMODE, POLLMODE
} I_OR_POLL;

typedef struct {
    uint             index;
    ENG_MODE        eMode;
    CRYPT_ALG       cAlg;
    CRYPT_BLK_MODE  cBlkMode;
    CRYPT_DIR       cDirection;
    uchar              *cKeys;
    uchar              *cIv;
    AUTH_ALG        aAlg;
    AUTH_UCV        uChVars;
    uchar              *aKeys;
    uint             aKeySize;
    uchar              *eHeader;
    COMP_ICV        eCmpIcv;
    CREA_IV         eCreatIv;
    INC_SEQ         eIncSeq;
    I_OR_POLL       iOrPoll;
} AssocVectors;

typedef struct {
    uint             index;
    uint             saIndex;
    uint             nProtocol;
    uchar              *srcAddr0;
    uint             srcSize0;
    uchar              *srcAddr1;
    uint             srcSize1;
    uchar              *expData;
    uint             expSize;
    uint             chainIndex;
} AssocXVectors;


uchar  PCSecKey0 [] = { 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef };

uchar  PCSecKey1 [] = { 0x71, 0x71, 0x71, 0x71, 0x72, 0x72, 0x72, 0x72 };

uchar  PASecKey4 [] = { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
                     0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
                     0x0b, 0x0b, 0x0b, 0x0b };

uchar  PCSecKey6 [] = { 0x57, 0xb3, 0xea, 0x0b, 0x3e, 0x1f, 0x83, 0xfe,
			0x57, 0xb3, 0xea, 0x0b, 0x3e, 0x1f, 0x83, 0xfe,
			0x0c, 0xc3, 0x38, 0x7d, 0x73, 0x2d, 0x5a, 0x34 };

uchar  PCSecIv6  [] = { 0x0c, 0xc3, 0x38, 0x7d, 0x73, 0x2d, 0x5a, 0x34 };

uchar  PESecHdr6 [] = { 0x12, 0x34, 0x56, 0x78, 0x00, 0x00, 0x00, 0x01 };

uchar  PCSecKey7 [] = { 0x57, 0xb3, 0xea, 0x0b, 0x3e, 0x1f, 0x83, 0xfe,
                     0x57, 0xb3, 0xea, 0x0b, 0x3e, 0x1f, 0x83, 0xfe,
                     0x57, 0xb3, 0xea, 0x0b, 0x3e, 0x1f, 0x83, 0xfe };

uchar  PCSecKey8 [] = { 0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64 };

uchar  PASecKey8 [] = { 0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                     0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                     0x61, 0x62, 0x63, 0x64 };

/* Associations 9 and 10-  Crypt AES128-ECB */

uchar  PCSecKey9 [] = { 0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
                     0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c };

/* Associations 11,12,17,18,19,20-  Crypt AES 128/192/256 CBC */

uchar  PCSecKey11 [] = { 0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6,
                      0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c };

uchar  PCSecIv11 [] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                     0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f };

/* Association 13- ESP Outgoing w AES */

uchar  PCSecKey13 [] = { 0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                      0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64 };

uchar  PCSecIv13 [] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                     0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f };

uchar  PASecKey13 [] = { 0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                      0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                      0x61, 0x62, 0x63, 0x64 };

uchar  PESecHdr13 [] = { 0x00, 0x00, 0x0F, 0xA0, 0x00, 0x00, 0x00, 0x01 };

/* Association 17 and 18-  Crypt AES-192 */

uchar  PCSecKey17 [] = { 0x8e, 0x73, 0xb0, 0xf7, 0xda, 0x0e, 0x64, 0x52,
                      0xc8, 0x10, 0xf3, 0x2b, 0x80, 0x90, 0x79, 0xe5,
                      0x62, 0xf8, 0xea, 0xd2, 0x52, 0x2c, 0x6b, 0x7b };

/* Association 19 and 20-  Crypt AES-256 */

uchar  PCSecKey19 [] = { 0x60, 0x3d, 0xeb, 0x10, 0x15, 0xca, 0x71, 0xbe,
                      0x2b, 0x73, 0xae, 0xf0, 0x85, 0x7d, 0x77, 0x81,
                      0x1f, 0x35, 0x2c, 0x07, 0x3b, 0x61, 0x08, 0xd7,
                      0x2d, 0x98, 0x10, 0xa3, 0x09, 0x14, 0xdf, 0xf4 };

/* Association 22-  Crypt AES-128 */

uchar PCSecKey22 [] = { 0x06, 0xa9, 0x21, 0x40, 0x36, 0xb8, 0xa1, 0x5b,
                     0x51, 0x2e, 0x03, 0xd5, 0x34, 0x12, 0x00, 0x06 };

uchar PCSecIv22 [] = { 0x3d, 0xaf, 0xba, 0x42, 0x9d, 0x9e, 0xb4, 0x30,
                    0xb4, 0x22, 0xda, 0x80, 0x2c, 0x9f, 0xac, 0x41 };
    
/* Association 23-  Crypt AES-128 */

uchar PCSecKey23 [] = { 0xc2, 0x86, 0x69, 0x6d, 0x88, 0x7c, 0x9a, 0xa0,
                     0x61, 0x1b, 0xbb, 0x3e, 0x20, 0x25, 0xa4, 0x5a };

uchar PCSecIv23 [] = { 0x56, 0x2e, 0x17, 0x99, 0x6d, 0x09, 0x3d, 0x28,
                    0xdd, 0xb3, 0xba, 0x69, 0x5a, 0x2e, 0x6f, 0x58 };
    
/* Association 24-  Crypt AES-128 */

uchar PCSecKey24 [] = { 0x6c, 0x3e, 0xa0, 0x47, 0x76, 0x30, 0xce, 0x21,
                     0xa2, 0xce, 0x33, 0x4a, 0xa7, 0x46, 0xc2, 0xcd };

uchar PCSecIv24 [] = { 0xc7, 0x82, 0xdc, 0x4c, 0x09, 0x8c, 0x66, 0xcb,
                    0xd9, 0xcd, 0x27, 0xd8, 0x25, 0x68, 0x2c, 0x81 };

/* Association 25-  Crypt AES-128 */

uchar PCSecKey25 [] = { 0x56, 0xe4, 0x7a, 0x38, 0xc5, 0x59, 0x89, 0x74,
                     0xbc, 0x46, 0x90, 0x3d, 0xba, 0x29, 0x03, 0x49 };

uchar PCSecIv25 [] = { 0x8c, 0xe8, 0x2e, 0xef, 0xbe, 0xa0, 0xda, 0x3c,
                    0x44, 0x69, 0x9e, 0xd7, 0xdb, 0x51, 0xb7, 0xd9 };

/* Association 26-  ESP-Out AES-128 */
uchar  PCSecKey26 [] = { 0x90, 0xd3, 0x82, 0xb4, 0x10, 0xee, 0xba, 0x7a,
                      0xd9, 0x38, 0xc4, 0x6c, 0xec, 0x1a, 0x82, 0xbf };

uchar  PCSecIv26  [] = { 0xe9, 0x6e, 0x8c, 0x08, 0xab, 0x46, 0x57, 0x63,
                      0xfd, 0x09, 0x8d, 0x45, 0xdd, 0x3f, 0xf8, 0x93 };

uchar  PESecHdr26 [] = { 0x00, 0x00, 0x43, 0x21, 0x00, 0x00, 0x00, 0x01 };

/* Association 27-  ESP-Out AES-128 */
uchar  PCSecIv27  [] = { 0x69, 0xd0, 0x8d, 0xf7, 0xd2, 0x03, 0x32, 0x9d,
                      0xb0, 0x93, 0xfc, 0x49, 0x24, 0xe5, 0xbd, 0x80 };

uchar  PESecHdr27 [] = { 0x00, 0x00, 0x43, 0x21, 0x00, 0x00, 0x00, 0x08 };

/* Association 28-  ESP-Out AES-128 */
uchar  PCSecKey28 [] = { 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
                      0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef };

uchar  PCSecIv28  [] = { 0xf4, 0xe7, 0x65, 0x24, 0x4f, 0x64, 0x07, 0xad,
                      0xf1, 0x3d, 0xc1, 0x38, 0x0f, 0x67, 0x3f, 0x37 };

uchar  PESecHdr28 [] = { 0x00, 0x00, 0x87, 0x65, 0x00, 0x00, 0x00, 0x02 };

/* Association 29-  ESP-Out AES-128 */
uchar  PCSecIv29  [] = { 0x85, 0xd4, 0x72, 0x24, 0xb5, 0xf3, 0xdd, 0x5d,
                      0x21, 0x01, 0xd4, 0xea, 0x8d, 0xff, 0xab, 0x22 };

uchar  PESecHdr29 [] = { 0x00, 0x00, 0x87, 0x65, 0x00, 0x00, 0x00, 0x05 };

/* 0-  DES/Crypt */
uchar NistSrc1 [] = { 0x4e, 0x6f, 0x77, 0x20, 0x69, 0x73, 0x20, 0x74 }; 
uchar NistExp1 [] = { 0x3f, 0xa4, 0x0e, 0x8a, 0x98, 0x4d, 0x48, 0x15 };

/* 1- DES/Crypt (2 sources) */
uchar  PCSrcData1a [] = { 0x70, 0x01, 0x02, 0x03,  0x74, 0x05, 0x06, 0x07,
                         0x78, 0x09, 0x0a, 0x0b,  0x7c, 0x0d, 0x0e, 0x0f,
                         0x70, 0x11, 0x12, 0x13,  0x74, 0x15, 0x16, 0x17,
                         0x78, 0x19, 0x1a, 0x1b,  0x7c, 0x1d, 0x1e, 0x1f };

uchar  PCSrcData1b [] = { 0x70, 0x21, 0x22, 0x23,  0x74, 0x25, 0x26, 0x27,
                         0x78, 0x29, 0x2a, 0x2b,  0x7c, 0x2d, 0x2e, 0x2f };

uchar  PCExpData1 [] = { 0x8e, 0x65, 0x3a, 0x30,  0x04, 0x1f, 0xf9, 0x5b,
                         0x58, 0x2d, 0xdf, 0x02,  0x38, 0x43, 0xe2, 0x63,
                         0x04, 0x85, 0x86, 0x36,  0x9d, 0xfd, 0xf6, 0x92,
                         0xa7, 0xbc, 0xde, 0x8a,  0x08, 0xcb, 0xfe, 0x54,
                         0x1b, 0xfe, 0xa0, 0x88,  0x39, 0xe2, 0xc3, 0x8a,
                         0x46, 0x90, 0x0b, 0x0a,  0x29, 0x3b, 0x82, 0x9b };

/* 2-  Hash */
uchar  SrcData9 [] = { 0x55, 0x55, 0x55, 0x55, 0xaa, 0xaa, 0xaa, 0xaa,
                       0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
                       0x66, 0x66, 0x66, 0x66, 0x99, 0x99, 0x99, 0x99,
                       0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                       0x55, 0x55, 0x55, 0x55, 0xaa, 0xaa, 0xaa, 0xaa,
                       0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
                       0x66, 0x66, 0x66, 0x66, 0x80, 0x00, 0x00, 0x00,
                       0xa0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

uchar  ExpData5 [] = { 0x3f, 0x56, 0x62, 0x34,
                    0x16, 0xfc, 0x63, 0x7d, 0x7c, 0x81, 0x2b, 0xca,
                    0xef, 0x8a, 0xb4, 0xae };


/* 3-  Hash with Pad */
uchar md5Vector2[] = "a";
uchar md5Result2[] = {	0x0c, 0xc1, 0x75, 0xb9, 0xc0, 0xf1, 0xb6, 0xa8, 
			0x31, 0xc3, 0x99, 0xe2, 0x69, 0x77, 0x26, 0x61};

/* 4-  HMAC MD5 */
uchar hmacVector1 [] =		"Hi There";	
uchar hmacKey1 [] 	=	{	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 
					0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b };
uint hmacResult1 []	=	{	0x9294727au, 0x3638bb1cu, 
					0x13f48ef8u, 0x158bfc9du	};

/* 5-  HMAC SHA1 */
uchar hmacVector8 [] =		"Hi There";	
uchar hmacKey8 [] 	=	{	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
					0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b };
uint hmacResult8 []	=	{	0xb6173186, 0x55057264, 0xe28bc0b6, 0xfb378c8e, 0xf146be00 };

/* 6-  Esp Outgoing */
uchar  PSrcData6 [] = { 0x72, 0xac, 0x3c, 0x01, 0xc5, 0xf2, 0xf5, 0x7d,
                     0xa0, 0xb1, 0x00, 0xbd, 0xf9, 0x9d, 0x96, 0x2a,
                     0x63, 0x8b, 0x88, 0x62, 0xd5, 0x27, 0x23, 0x8b,
                     0xad, 0xe5, 0x56, 0xe8, 0xf4, 0x3a, 0x17, 0xa9,
                     0xe4, 0x0b, 0x02, 0x08, 0xa7, 0x66, 0x43, 0x91 };

uchar  PExpData6 [] = { 0x12, 0x34, 0x56, 0x78, 0x00, 0x00, 0x00, 0x01, 
                     0x0c, 0xc3, 0x38, 0x7d, 0x73, 0x2d, 0x5a, 0x34,
                     0xde, 0x06, 0x9b, 0x14, 0x47, 0x1f, 0x42, 0x1f,
                     0x22, 0xbb, 0xd5, 0x79, 0xea, 0xdf, 0x73, 0xc3,
                     0x5f, 0x8b, 0xf6, 0x0e, 0xa8, 0xc0, 0x5c, 0x45,
                     0x69, 0x2c, 0x07, 0xab, 0x1d, 0xec, 0x93, 0xc4,
                     0xef, 0x1d, 0xfb, 0xac, 0x84, 0x55, 0xee, 0x6b,
                     0x9e, 0x62, 0x98, 0xec, 0x9a, 0xd0, 0x1d, 0x73,
                     0x7a, 0x43, 0xc0, 0x5b, 0x46, 0x42, 0xc9, 0xa6,
                     0x54, 0x06, 0xf7, 0x23, 0x8b, 0x74, 0xf4, 0x37,
                     0xcf, 0xb7, 0xa9, 0x5c };

/* 7-  Esp Incoming */
uchar  PSrcData7a [] = { 0x12,0x34,0x56,0x78,0x00,0x00,0x00,0x01, 
                      0x0c,0xc3,0x38,0x7d,0x73,0x2d,0x5a,0x34,
                      0x16,0xed,0xdc,0x24,0x32,0x76,0x9d,0xac,
                      0xc1,0xb5,0x89,0x11,0x88,0xef,0x7d,0x63,
                      0x9f,0x6c,0xda,0x54,0x42,0x79,0x2e,0x12,
                      0x86,0x66,0x48,0xd8,0x6a,0x91,0xf7,0xe5,
                      0x82,0xbe,0x9e,0xa4,0x29,0xeb,0xd5,0xef,
                      0x6c,0x27,0x21,0x7b,0x36,0x8b,0x97,0x55 };

uchar  PSrcData7b [] = { 0x5C,0x27,0x6C,0xC8,0x44,0x2A,0x7B,0x24,
                      0xBF,0xCF,0xC7,0x64,0xB3,0xC4,0xC2,0xEE,
                      0x83,0x77,0x7A,0x94 };

uchar  PExpData7 [] = { 0x72,0xac,0x3c,0x01,0xc5,0xf2,0xf5,0x7d,
                     0xa0,0xb1,0x00,0xbd,0xf9,0x9d,0x96,0x2a,
                     0x63,0x8b,0x88,0x62,0xd5,0x27,0x23,0x8b,
                     0xad,0xe5,0x56,0xe8,0xf4,0x3a,0x17,0xa9,
                     0xe4,0x0b,0x02,0x08,0xa7,0x66,0x43,0x91,
                     0x62,0x70,0xb7,0xc1,0x72,0x9e,0x4e,0xd3 };

/* 8 and 9- Crypt AES128 ECB */ 

uchar  PSrcData8 [] = { 0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
                     0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
                     0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
                     0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
                     0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
                     0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
                     0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
                     0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10 };

uchar  PExpData8 [] = { 0x3a, 0xd7, 0x7b, 0xb4, 0x0d, 0x7a, 0x36, 0x60,
                     0xa8, 0x9e, 0xca, 0xf3, 0x24, 0x66, 0xef, 0x97,
                     0xf5, 0xd3, 0xd5, 0x85, 0x03, 0xb9, 0x69, 0x9d,
                     0xe7, 0x85, 0x89, 0x5a, 0x96, 0xfd, 0xba, 0xaf,
                     0x43, 0xb1, 0xcd, 0x7f, 0x59, 0x8e, 0xce, 0x23,
                     0x88, 0x1b, 0x00, 0xe3, 0xed, 0x03, 0x06, 0x88,
                     0x7b, 0x0c, 0x78, 0x5e, 0x27, 0xe8, 0xad, 0x3f,
                     0x82, 0x23, 0x20, 0x71, 0x04, 0x72, 0x5d, 0xd4 };

/* 10,11,17,18,19,20 - Crypt AES128/192/256 CBC Testing */ 

uchar  PSrcData10 [] = { 0x6b, 0xc1, 0xbe, 0xe2, 0x2e, 0x40, 0x9f, 0x96,
                      0xe9, 0x3d, 0x7e, 0x11, 0x73, 0x93, 0x17, 0x2a,
                      0xae, 0x2d, 0x8a, 0x57, 0x1e, 0x03, 0xac, 0x9c,
                      0x9e, 0xb7, 0x6f, 0xac, 0x45, 0xaf, 0x8e, 0x51,
                      0x30, 0xc8, 0x1c, 0x46, 0xa3, 0x5c, 0xe4, 0x11,
                      0xe5, 0xfb, 0xc1, 0x19, 0x1a, 0x0a, 0x52, 0xef,
                      0xf6, 0x9f, 0x24, 0x45, 0xdf, 0x4f, 0x9b, 0x17,
                      0xad, 0x2b, 0x41, 0x7b, 0xe6, 0x6c, 0x37, 0x10 };

/* 10 and 11-  AES128-CBC */

uchar  PExpData10 [] = { 0x76, 0x49, 0xab, 0xac, 0x81, 0x19, 0xb2, 0x46,
                      0xce, 0xe9, 0x8e, 0x9b, 0x12, 0xe9, 0x19, 0x7d,
                      0x50, 0x86, 0xcb, 0x9b, 0x50, 0x72, 0x19, 0xee,
                      0x95, 0xdb, 0x11, 0x3a, 0x91, 0x76, 0x78, 0xb2,
                      0x73, 0xbe, 0xd6, 0xb8, 0xe3, 0xc1, 0x74, 0x3b,
                      0x71, 0x16, 0xe6, 0x9e, 0x22, 0x22, 0x95, 0x16,
                      0x3f, 0xf1, 0xca, 0xa1, 0x68, 0x1f, 0xac, 0x09,
                      0x12, 0x0e, 0xca, 0x30, 0x75, 0x86, 0xe1, 0xa7 };

/* 12- ESP Outgoing AES Testing */ 

uchar  PSrcData12 [] = { 0x45, 0x00, 0x00, 0x3C, 0x13, 0xDB, 0x00, 0x00,
                      0x7F, 0x01, 0x9F, 0x69, 0xC0, 0xA8, 0x04, 0x16,
                      0xC0, 0xA8, 0x03, 0x16, 0x00, 0x00, 0x44, 0x5B,
                      0x02, 0x00, 0x0F, 0x01, 0x61, 0x62, 0x63, 0x64,
                      0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C,
                      0x6D, 0x6E, 0x6F, 0x70, 0x71, 0x72, 0x73, 0x74,
                      0x75, 0x76, 0x77, 0x61, 0x62, 0x63, 0x64, 0x65,
                      0x66, 0x67, 0x68, 0x69 };

uchar  PExpData12 [] = { 0x00, 0x00, 0x0f, 0xa0, 0x00, 0x00, 0x00, 0x01,
                      0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                      0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
                      0xdd, 0x90, 0x5d, 0x5d, 0x70, 0x22, 0x87, 0x2b,
                      0x61, 0x00, 0xe1, 0x0f, 0x7f, 0x60, 0xcd, 0x1c,
                      0x6a, 0xab, 0xe7, 0x39, 0x7c, 0x2d, 0x42, 0xff,
                      0x1b, 0x9c, 0x16, 0x01, 0x23, 0xed, 0x4f, 0xba,
                      0xdf, 0x4a, 0x93, 0xc3, 0xf5, 0xe8, 0xa9, 0x03,
                      0x77, 0xca, 0x79, 0x13, 0xe4, 0x1e, 0x91, 0x59,
                      0xc7, 0xef, 0x23, 0x83, 0x05, 0x2b, 0xc4, 0x78,
                      0xfe, 0x5c, 0x94, 0x60, 0xfa, 0xa3, 0x70, 0xd1,
                      0xee, 0xdf, 0xf6, 0x36, 0xbc, 0x07, 0xf2, 0x9f,
                      0x02, 0xd2, 0x65, 0x3a };

/* 13- ESP Incoming AES Testing */ 

uchar  PSrcData13a [] = { 0x00, 0x00, 0x0f, 0xa0, 0x00, 0x00, 0x00, 0x01,
                       0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                       0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
                       0xdd, 0x90, 0x5d, 0x5d, 0x70, 0x22, 0x87, 0x2b,
                       0x61, 0x00, 0xe1, 0x0f, 0x7f, 0x60, 0xcd, 0x1c,
                       0x6a, 0xab, 0xe7, 0x39, 0x7c, 0x2d, 0x42, 0xff,
                       0x1b, 0x9c, 0x16, 0x01, 0x23, 0xed, 0x4f, 0xba,
                       0xdf, 0x4a, 0x93, 0xc3, 0xf5, 0xe8, 0xa9, 0x03,
                       0x77, 0xca, 0x79, 0x13, 0xe4, 0x1e, 0x91, 0x59,
                       0xc7, 0xef, 0x23, 0x83, 0x05, 0x2b, 0xc4, 0x78,
                       0xfe, 0x5c, 0x94, 0x60, 0xfa, 0xa3, 0x70, 0xd1 };
    
uchar  PSrcData13b [] = { 0xee, 0xdf, 0xf6, 0x36, 0xbc, 0x07, 0xf2, 0x9f,
                       0x02, 0xd2, 0x65, 0x3a };

uchar  PExpData13 [] = { 0x45, 0x00, 0x00, 0x3C, 0x13, 0xDB, 0x00, 0x00,
                      0x7F, 0x01, 0x9F, 0x69, 0xC0, 0xA8, 0x04, 0x16,
                      0xC0, 0xA8, 0x03, 0x16, 0x00, 0x00, 0x44, 0x5B,
                      0x02, 0x00, 0x0F, 0x01, 0x61, 0x62, 0x63, 0x64,
                      0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C,
                      0x6D, 0x6E, 0x6F, 0x70, 0x71, 0x72, 0x73, 0x74,
                      0x75, 0x76, 0x77, 0x61, 0x62, 0x63, 0x64, 0x65,
                      0x66, 0x67, 0x68, 0x69, 0x01, 0x02 };
/* 16- HMAC test */

uchar  PSrcData16 [] = { 0x00, 0x00, 0x0F, 0xA0, 0x00, 0x00, 0x00, 0x01,
                      0x9F, 0x7F, 0x56, 0x4F, 0x5C, 0x6C, 0x62, 0x6A,
                      0x2F, 0xD2, 0x41, 0x45, 0x4A, 0x92, 0x7A, 0x86,
                      0x57, 0xDA, 0xE6, 0x09, 0x82, 0x61, 0x1C, 0x1F,
                      0xAB, 0xEF, 0x1C, 0xB5, 0x65, 0xE6, 0xCE, 0x53,
                      0x01, 0x7E, 0xCC, 0x99, 0x95, 0xB1, 0x55, 0xED,
                      0xF8, 0x05, 0x4E, 0x95, 0x6E, 0xD4, 0xCF, 0x01,
                      0x51, 0x29, 0x04, 0x8F, 0x05, 0x49, 0xE0, 0xDA,
                      0x6D, 0x57, 0x1F, 0x93, 0x35, 0xDB, 0xC0, 0x61,
                      0x93, 0x0F, 0xDF, 0x63, 0xCD, 0xCF, 0x2A, 0xA8,
                      0xA0, 0xC3, 0x6E, 0xB8, 0x14, 0x76, 0xAE, 0x2D,
                      0xB6, 0x5F, 0x94, 0x2B, 0xA7, 0x53, 0x75, 0xF6 };

uchar  PExpData16 [] = { 0x5B, 0xCC, 0x06, 0x65, 0xA3, 0x65, 0x6D, 0xB2,
                      0xC3, 0x27, 0x27, 0x41 };

/* 17 and 18-  AES-192 */
uchar  PExpData17 [] = { 0x4f, 0x02, 0x1d, 0xb2, 0x43, 0xbc, 0x63, 0x3d,
                      0x71, 0x78, 0x18, 0x3a, 0x9f, 0xa0, 0x71, 0xe8,
                      0xb4, 0xd9, 0xad, 0xa9, 0xad, 0x7d, 0xed, 0xf4,
                      0xe5, 0xe7, 0x38, 0x76, 0x3f, 0x69, 0x14, 0x5a,
                      0x57, 0x1b, 0x24, 0x20, 0x12, 0xfb, 0x7a, 0xe0,
                      0x7f, 0xa9, 0xba, 0xac, 0x3d, 0xf1, 0x02, 0xe0,
                      0x08, 0xb0, 0xe2, 0x79, 0x88, 0x59, 0x88, 0x81,
                      0xd9, 0x20, 0xa9, 0xe6, 0x4f, 0x56, 0x15, 0xcd };

/* 19 and 20-  AES-256 */
uchar  PExpData19 [] = { 0xf5, 0x8c, 0x4c, 0x04, 0xd6, 0xe5, 0xf1, 0xba,
                      0x77, 0x9e, 0xab, 0xfb, 0x5f, 0x7b, 0xfb, 0xd6,
                      0x9c, 0xfc, 0x4e, 0x96, 0x7e, 0xdb, 0x80, 0x8d,
                      0x67, 0x9f, 0x77, 0x7b, 0xc6, 0x70, 0x2c, 0x7d,
                      0x39, 0xf2, 0x33, 0x69, 0xa9, 0xd9, 0xba, 0xcf,
                      0xa5, 0x30, 0xe2, 0x63, 0x04, 0x23, 0x14, 0x61,
                      0xb2, 0xeb, 0x05, 0xe2, 0xc3, 0x9b, 0xe9, 0xfc,
                      0xda, 0x6c, 0x19, 0x07, 0x8c, 0x6a, 0x9d, 0x1b };

/* 22-  AES-128 */
uchar  PSrcData22 [] = "Single block msg";

uchar  PExpData22 [] = { 0xe3, 0x53, 0x77, 0x9c, 0x10, 0x79, 0xae, 0xb8,
                      0x27, 0x08, 0x94, 0x2d, 0xbe, 0x77, 0x18, 0x1a };

/* 23-  AES-128 */
uchar  PSrcData23 [] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                      0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
                      0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
                      0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f };

uchar  PExpData23 [] = { 0xd2, 0x96, 0xcd, 0x94, 0xc2, 0xcc, 0xcf, 0x8a,
                      0x3a, 0x86, 0x30, 0x28, 0xb5, 0xe1, 0xdc, 0x0a,
                      0x75, 0x86, 0x60, 0x2d, 0x25, 0x3c, 0xff, 0xf9,
                      0x1b, 0x82, 0x66, 0xbe, 0xa6, 0xd6, 0x1a, 0xb1 };

/* 24-  AES-128 */
uchar  PSrcData24 [] = "This is a 48-byte message (exactly 3 AES blocks)";

uchar  PExpData24 [] = { 0xd0, 0xa0, 0x2b, 0x38, 0x36, 0x45, 0x17, 0x53,
                      0xd4, 0x93, 0x66, 0x5d, 0x33, 0xf0, 0xe8, 0x86,
                      0x2d, 0xea, 0x54, 0xcd, 0xb2, 0x93, 0xab, 0xc7,
                      0x50, 0x69, 0x39, 0x27, 0x67, 0x72, 0xf8, 0xd5,
                      0x02, 0x1c, 0x19, 0x21, 0x6b, 0xad, 0x52, 0x5c,
                      0x85, 0x79, 0x69, 0x5d, 0x83, 0xba, 0x26, 0x84 };

/* 25-  AES-128 */
uchar  PSrcData25 [] = { 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
                      0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
                      0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
                      0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
                      0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
                      0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
                      0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
                      0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf };

uchar  PExpData25 [] = { 0xc3, 0x0e, 0x32, 0xff, 0xed, 0xc0, 0x77, 0x4e,
                      0x6a, 0xff, 0x6a, 0xf0, 0x86, 0x9f, 0x71, 0xaa,
                      0x0f, 0x3a, 0xf0, 0x7a, 0x9a, 0x31, 0xa9, 0xc6,
                      0x84, 0xdb, 0x20, 0x7e, 0xb0, 0xef, 0x8e, 0x4e,
                      0x35, 0x90, 0x7a, 0xa6, 0x32, 0xc3, 0xff, 0xdf,
                      0x86, 0x8b, 0xb7, 0xb2, 0x9d, 0x3d, 0x46, 0xad,
                      0x83, 0xce, 0x9f, 0x9a, 0x10, 0x2e, 0xe9, 0x9d,
                      0x49, 0xa5, 0x3e, 0x87, 0xf4, 0xc3, 0xda, 0x55 };

/* 26-  ESP-Out AES-128 */
uchar  PSrcData26 [] = { 0x08, 0x00, 0x0e, 0xbd, 0xa7, 0x0a, 0x00, 0x00,
                      0x8e, 0x9c, 0x08, 0x3d, 0xb9, 0x5b, 0x07, 0x00,
                      0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
                      0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
                      0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
                      0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
                      0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
                      0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37 };

uchar  PExpData26 [] = { 0x00, 0x00, 0x43, 0x21, 0x00, 0x00, 0x00, 0x01,
                      0xe9, 0x6e, 0x8c, 0x08, 0xab, 0x46, 0x57, 0x63,
                      0xfd, 0x09, 0x8d, 0x45, 0xdd, 0x3f, 0xf8, 0x93,
                      0xf6, 0x63, 0xc2, 0x5d, 0x32, 0x5c, 0x18, 0xc6,
                      0xa9, 0x45, 0x3e, 0x19, 0x4e, 0x12, 0x08, 0x49,
                      0xa4, 0x87, 0x0b, 0x66, 0xcc, 0x6b, 0x99, 0x65,
                      0x33, 0x00, 0x13, 0xb4, 0x89, 0x8d, 0xc8, 0x56,
                      0xa4, 0x69, 0x9e, 0x52, 0x3a, 0x55, 0xdb, 0x08,
                      0x0b, 0x59, 0xec, 0x3a, 0x8e, 0x4b, 0x7e, 0x52,
                      0x77, 0x5b, 0x07, 0xd1, 0xdb, 0x34, 0xed, 0x9c,
                      0x53, 0x8a, 0xb5, 0x0c, 0x55, 0x1b, 0x87, 0x4a,
                      0xa2, 0x69, 0xad, 0xd0, 0x47, 0xad, 0x2d, 0x59,
                      0x13, 0xac, 0x19, 0xb7, 0xcf, 0xba, 0xd4, 0xa6 };

/* 27-  ESP-Out AES-128 */
uchar  PSrcData27 [] = { 0x08, 0x00, 0xb5, 0xe8, 0xa8, 0x0a, 0x05, 0x00,
                      0xa6, 0x9c, 0x08, 0x3d, 0x0b, 0x66, 0x0e, 0x00,
                      0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
                      0x77, 0x77, 0x77, 0x77 };

uchar  PExpData27 [] = { 0x00, 0x00, 0x43, 0x21, 0x00, 0x00, 0x00, 0x08,
                      0x69, 0xd0, 0x8d, 0xf7, 0xd2, 0x03, 0x32, 0x9d,
                      0xb0, 0x93, 0xfc, 0x49, 0x24, 0xe5, 0xbd, 0x80,
                      0xf5, 0x19, 0x95, 0x88, 0x1e, 0xc4, 0xe0, 0xc4,
                      0x48, 0x89, 0x87, 0xce, 0x74, 0x2e, 0x81, 0x09,
                      0x68, 0x9b, 0xb3, 0x79, 0xd2, 0xd7, 0x50, 0xc0,
                      0xd9, 0x15, 0xdc, 0xa3, 0x46, 0xa8, 0x9f, 0x75 };

/* 28-  ESP-Out AES-128 */
uchar  PSrcData28 [] = { 0x45, 0x00, 0x00, 0x54, 0x09, 0x04, 0x00, 0x00,
                      0x40, 0x01, 0xf9, 0x88, 0xc0, 0xa8, 0x7b, 0x03,
                      0xc0, 0xa8, 0x7b, 0xc8,
                      0x08, 0x00, 0x9f, 0x76, 0xa9, 0x0a, 0x01, 0x00,
                      0xb4, 0x9c, 0x08, 0x3d, 0x02, 0xa2, 0x04, 0x00,
                      0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
                      0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
                      0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
                      0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
                      0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
                      0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37 };

uchar  PExpData28 [] = { 0x00, 0x00, 0x87, 0x65, 0x00, 0x00, 0x00, 0x02,
                      0xf4, 0xe7, 0x65, 0x24, 0x4f, 0x64, 0x07, 0xad,
                      0xf1, 0x3d, 0xc1, 0x38, 0x0f, 0x67, 0x3f, 0x37,
                      0x77, 0x3b, 0x52, 0x41, 0xa4, 0xc4, 0x49, 0x22,
                      0x5e, 0x4f, 0x3c, 0xe5, 0xed, 0x61, 0x1b, 0x0c,
                      0x23, 0x7c, 0xa9, 0x6c, 0xf7, 0x4a, 0x93, 0x01,
                      0x3c, 0x1b, 0x0e, 0xa1, 0xa0, 0xcf, 0x70, 0xf8,
                      0xe4, 0xec, 0xae, 0xc7, 0x8a, 0xc5, 0x3a, 0xad,
                      0x7a, 0x0f, 0x02, 0x2b, 0x85, 0x92, 0x43, 0xc6,
                      0x47, 0x75, 0x2e, 0x94, 0xa8, 0x59, 0x35, 0x2b,
                      0x8a, 0x4d, 0x4d, 0x2d, 0xec, 0xd1, 0x36, 0xe5,
                      0xc1, 0x77, 0xf1, 0x32, 0xad, 0x3f, 0xbf, 0xb2,
                      0x20, 0x1a, 0xc9, 0x90, 0x4c, 0x74, 0xee, 0x0a,
                      0x10, 0x9e, 0x0c, 0xa1, 0xe4, 0xdf, 0xe9, 0xd5,
                      0xa1, 0x00, 0xb8, 0x42, 0xf1, 0xc2, 0x2f, 0x0d };

/* 29-  ESP-Out AES-128 */
uchar  PSrcData29 [] = { 0x45, 0x00, 0x00, 0x44, 0x09, 0x0c, 0x00, 0x00,
                      0x40, 0x01, 0xf9, 0x90, 0xc0, 0xa8, 0x7b, 0x03,
                      0xc0, 0xa8, 0x7b, 0xc8, 0x08, 0x00, 0xd6, 0x3c,
                      0xaa, 0x0a, 0x02, 0x00, 0xc6, 0x9c, 0x08, 0x3d,
                      0xa3, 0xde, 0x03, 0x00, 0xff, 0xff, 0xff, 0xff,
                      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                      0xff, 0xff, 0xff, 0xff };

uchar  PExpData29 [] = { 0x00, 0x00, 0x87, 0x65, 0x00, 0x00, 0x00, 0x05,
                      0x85, 0xd4, 0x72, 0x24, 0xb5, 0xf3, 0xdd, 0x5d,
                      0x21, 0x01, 0xd4, 0xea, 0x8d, 0xff, 0xab, 0x22,
                      0x15, 0xb9, 0x26, 0x83, 0x81, 0x95, 0x96, 0xa8,
                      0x04, 0x72, 0x32, 0xcc, 0x00, 0xf7, 0x04, 0x8f,
                      0xe4, 0x53, 0x18, 0xe1, 0x1f, 0x8a, 0x0f, 0x62,
                      0xed, 0xe3, 0xc3, 0xfc, 0x61, 0x20, 0x3b, 0xb5,
                      0x0f, 0x98, 0x0a, 0x08, 0xc9, 0x84, 0x3f, 0xd3,
                      0xa1, 0xb0, 0x6d, 0x5c, 0x07, 0xff, 0x96, 0x39,
                      0xb7, 0xeb, 0x7d, 0xfb, 0x35, 0x12, 0xe5, 0xde,
                      0x43, 0x5e, 0x72, 0x07, 0xed, 0x97, 0x1e, 0xf3,
                      0xd2, 0x72, 0x6d, 0x9b, 0x5e, 0xf6, 0xaf, 0xfc,
                      0x6d, 0x17, 0xa0, 0xde, 0xcb, 0xb1, 0x38, 0x92 };

uchar  SrcData6 [] = { 0x70, 0x01, 0x02, 0x03,  0x74, 0x05, 0x06, 0x07,
                         0x78, 0x09, 0x0a, 0x0b,  0x7c, 0x0d, 0x0e, 0x0f };

uchar  SrcData7 [] = { 0x70, 0x11, 0x12, 0x13,  0x74, 0x15, 0x16, 0x17,
                         0x78, 0x19, 0x1a, 0x1b,  0x7c, 0x1d, 0x1e, 0x1f };

uchar  SrcData8 [] = { 0x70, 0x21, 0x22, 0x23,  0x74, 0x25, 0x26, 0x27,
                         0x78, 0x29, 0x2a, 0x2b,  0x7c, 0x2d, 0x2e, 0x2f };

uchar  ExpData4 [] = { 0x8e, 0x65, 0x3a, 0x30,  0x04, 0x1f, 0xf9, 0x5b,
                         0x58, 0x2d, 0xdf, 0x02,  0x38, 0x43, 0xe2, 0x63,
                         0x04, 0x85, 0x86, 0x36,  0x9d, 0xfd, 0xf6, 0x92,
                         0xa7, 0xbc, 0xde, 0x8a,  0x08, 0xcb, 0xfe, 0x54,
                         0x1b, 0xfe, 0xa0, 0x88,  0x39, 0xe2, 0xc3, 0x8a,
                         0x46, 0x90, 0x0b, 0x0a,  0x29, 0x3b, 0x82, 0x9b };

uint SecTotalAssocTestVecs = 38;

AssocVectors assocVectors2Test [] =
{
    {0, CRYPT, DES, ECB, OUTGOING, PCSecKey0, NULL, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {1, CRYPT, DES, ECB, OUTGOING, PCSecKey1, NULL, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {2, HASH, CRYPTALGNU, BLKMODENU, CRYPTDIRNU, NULL, NULL, MD5, DEFAULT, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {3, HASHPAD, CRYPTALGNU, BLKMODENU, CRYPTDIRNU, NULL, NULL, MD5, DEFAULT, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {4, HMAC, CRYPTALGNU, BLKMODENU, CRYPTDIRNU, NULL, NULL, MD5, USER, PASecKey4, 16, NULL, CPINU, CRINU, SINU, INTERMODE },
    {5, HMAC, CRYPTALGNU, BLKMODENU, CRYPTDIRNU, NULL, NULL, SHA1, USER, hmacKey8, 20, NULL, CPINU, CRINU, SINU, INTERMODE },
    {6, ESPOUT, TRIPLEDES, ECB, OUTGOING, PCSecKey6, PCSecIv6, SHA1, USER, PASecKey4, 20, PESecHdr6, CPINU, NORNG, NOINCREM, INTERMODE },
    {7, ESPIN, DES, CBCD, INCOMING, PCSecKey7, NULL, SHA1, USER, PASecKey4, 20, NULL, CMPARE, CRINU, SINU, INTERMODE },
    {8, ESPIN, DES, CBCD, INCOMING, PCSecKey8, NULL, SHA196, USER, PASecKey8, 20, NULL, CMPARE, CRINU, SINU, INTERMODE },
    {9, CRYPT, AES128, ECB, OUTGOING, PCSecKey9, NULL, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {10, CRYPT, AES128, ECB, INCOMING, PCSecKey9, NULL, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {11, CRYPT, AES128, CBCE, OUTGOING, PCSecKey11, PCSecIv11, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {12, CRYPT, AES128, CBCD, INCOMING, PCSecKey11, PCSecIv11, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {13, ESPOUT, AES128, CBCE, OUTGOING, PCSecKey13, PCSecIv13, SHA196, USER, PASecKey13, 20, PESecHdr13, CPINU, NORNG, NOINCREM, INTERMODE },
    {14, ESPIN, AES128, CBCD, INCOMING, PCSecKey13, PCSecIv13, SHA196, USER, PASecKey13, 20, NULL, CMPARE, CRINU, SINU, INTERMODE },
    {15, HMAC, CRYPTALGNU, BLKMODENU, CRYPTDIRNU, NULL, NULL, SHA196, USER, PASecKey13, 20, NULL, CPINU, CRINU, SINU, INTERMODE },
    {16, HMAC, CRYPTALGNU, BLKMODENU, CRYPTDIRNU, NULL, NULL, SHA1, USER, PASecKey4, 20, NULL, CPINU, CRINU, SINU, INTERMODE },
    {17, CRYPT, AES192, CBCE, OUTGOING, PCSecKey17, PCSecIv11, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {18, CRYPT, AES192, CBCD, INCOMING, PCSecKey17, PCSecIv11, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {19, CRYPT, AES256, CBCE, OUTGOING, PCSecKey19, PCSecIv11, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {20, CRYPT, AES256, CBCD, INCOMING, PCSecKey19, PCSecIv11, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {21, ESPIN, AES128, CBCD, INCOMING, PCSecKey13, PCSecIv13, AALGNULL, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {22, CRYPT, AES128, CBCE, OUTGOING, PCSecKey22, PCSecIv22, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {23, CRYPT, AES128, CBCE, OUTGOING, PCSecKey23, PCSecIv23, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {24, CRYPT, AES128, CBCE, OUTGOING, PCSecKey24, PCSecIv24, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {25, CRYPT, AES128, CBCE, OUTGOING, PCSecKey25, PCSecIv25, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {26, ESPOUT, AES128, CBCE, OUTGOING, PCSecKey26, PCSecIv26, AALGNULL, AUTHUCVNU, NULL, 0, PESecHdr26, CPINU, NORNG, NOINCREM, INTERMODE },
    {27, ESPOUT, AES128, CBCE, OUTGOING, PCSecKey26, PCSecIv27, AALGNULL, AUTHUCVNU, NULL, 0, PESecHdr27, CPINU, NORNG, NOINCREM, INTERMODE },
    {28, ESPOUT, AES128, CBCE, OUTGOING, PCSecKey28, PCSecIv28, AALGNULL, AUTHUCVNU, NULL, 0, PESecHdr28, CPINU, NORNG, NOINCREM, INTERMODE },
    {29, ESPOUT, AES128, CBCE, OUTGOING, PCSecKey28, PCSecIv29, AALGNULL, AUTHUCVNU, NULL, 0, PESecHdr29, CPINU, NORNG, NOINCREM, INTERMODE },
    {30, CRYPT, AES128, CBCD, INCOMING, PCSecKey22, PCSecIv22, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {31, CRYPT, AES128, CBCD, INCOMING, PCSecKey23, PCSecIv23, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {32, CRYPT, AES128, CBCD, INCOMING, PCSecKey24, PCSecIv24, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {33, CRYPT, AES128, CBCD, INCOMING, PCSecKey25, PCSecIv25, AUTHALGNU, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {34, ESPIN, AES128, CBCD, INCOMING, PCSecKey26, PCSecIv26, AALGNULL, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {35, ESPIN, AES128, CBCD, INCOMING, PCSecKey26, PCSecIv27, AALGNULL, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {36, ESPIN, AES128, CBCD, INCOMING, PCSecKey28, PCSecIv28, AALGNULL, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE },
    {37, ESPIN, AES128, CBCD, INCOMING, PCSecKey28, PCSecIv29, AALGNULL, AUTHUCVNU, NULL, 0, NULL, CPINU, CRINU, SINU, INTERMODE }
};

uint SecTotalAssocXTestVecs = 38;

AssocXVectors assocXVectors2Test [] =
{
    {0, 0, 0, NistSrc1, 8, NULL, 0, NistExp1, 8, 0},
    {1, 1, 0, PCSrcData1a, 32, PCSrcData1b, 16, PCExpData1, 48, 0},
    {2, 2, 0, SrcData9, 64, NULL, 0, ExpData5, 16, 0},
    {3, 3, 0, md5Vector2, 1, NULL, 0, md5Result2, 16, 0},
    {4, 4, 0, hmacVector1, 8, NULL, 0, (uchar *)hmacResult1, 16, 0},
    {5, 5, 0, hmacVector8, 8, NULL, 0, (uchar *)hmacResult8, 20, 0},
    {6, 6, 0x06, PSrcData6, 40, NULL, 0, PExpData6, 84, 0},
    {7, 7, 0, PSrcData7a, 64, PSrcData7b, 20, PExpData7, 48, 0},
    {8, 9, 0, PSrcData8, 64, NULL, 0, PExpData8, 64, 0},
    {9, 10, 0, PExpData8, 64, NULL, 0, PSrcData8, 64, 0},
    {10, 11, 0, PSrcData10, 64, NULL, 0, PExpData10, 64, 0},
    {11, 12, 0, PExpData10, 64, NULL, 0, PSrcData10, 64, 0},
    {12, 13, 0x04, PSrcData12, 60, NULL, 0, PExpData12, 100, 0},
    {13, 14, 0, PSrcData13a, 88, PSrcData13b, 12, PExpData13, 62, 0},
    {14, 15, 0, PSrcData13a, 88, NULL, 0, PSrcData13b, 12, 0},
    {15, 16, 0, PSrcData7a, 64, NULL, 0, PSrcData7b, 20, 0},
    {16, 15, 0, PSrcData16, 96, NULL, 0, PExpData16, 12, 0},
    {17, 17, 0, PSrcData10, 64, NULL, 0, PExpData17, 64, 0},
    {18, 18, 0, PExpData17, 64, NULL, 0, PSrcData10, 64, 0},
    {19, 19, 0, PSrcData10, 64, NULL, 0, PExpData19, 64, 0},
    {20, 20, 0, PExpData19, 64, NULL, 0, PSrcData10, 64, 0},
    {21, 21, 0, PSrcData13a, 88, NULL, 0, PExpData13, 62, 0},
    {22, 22, 0, PSrcData22, 16, NULL, 0, PExpData22, 16, 0},
    {23, 23, 0, PSrcData23, 32, NULL, 0, PExpData23, 32, 0},
    {24, 24, 0, PSrcData24, 48, NULL, 0, PExpData24, 48, 0},
    {25, 25, 0, PSrcData25, 64, NULL, 0, PExpData25, 64, 0},
    {26, 26, 0x01, PSrcData26, 64, NULL, 0, PExpData26, 104, 0},
    {27, 27, 0x01, PSrcData27, 28, NULL, 0, PExpData27, 56, 0},
    {28, 28, 0x04, PSrcData28, 84, NULL, 0, PExpData28, 120, 0},
    {29, 29, 0x04, PSrcData29, 68, NULL, 0, PExpData29, 104, 0},
    {30, 30, 0, PExpData22, 16, NULL, 0, PSrcData22, 16, 0},
    {31, 31, 0, PExpData23, 32, NULL, 0, PSrcData23, 32, 0},
    {32, 32, 0, PExpData24, 48, NULL, 0, PSrcData24, 48, 0},
    {33, 33, 0, PExpData25, 64, NULL, 0, PSrcData25, 64, 0},
    {34, 34, 0, PExpData26, 104, NULL, 0, PSrcData26, 64, 0},
    {35, 35, 0, PExpData27, 56, NULL, 0, PSrcData27, 28, 0},
    {36, 36, 0, PExpData28, 120, NULL, 0, PSrcData28, 84, 0},
    {37, 37, 0, PExpData29, 104, NULL, 0, PSrcData29, 68, 0}
};

    
MSP_SEC2_SA SecTestAssoc[100];

static void SecShowSA(MSP_SEC2_SA      *sa)
{
	int i ;
	uchar *d ;
	printf("dump of SA:\n") ;
	d = (uchar *)sa ;
	for (i = 0 ; i < sizeof(*sa); i++)
	{
		if ( (i % 16) == 0)
			printf("%04x ", i) ;
		printf(" %02x", d[i]) ;
		if ( (i % 16) == 15)
			printf("\n") ;
	}
	if ( (i % 16) != 0 )
		printf("\n") ;
}

uint     SecTestResultsLoud = 1;

void SecTestPrintErrorStatus(uint    retStatus)
{
    printf("Error status returned:  ");
#if 1
    printf(" %d\n", retStatus) ;
#else
    switch (retStatus)
    {
        case MSP_PSE_ERROR_INVALID_ASSOC_ID_ADDR:
            printf("Invalid association id address\n");
            break;
        case MSP_PSE_ERROR_INVALID_CKEYS_ADDR:
            printf("Invalid crypt keys address\n");
            break;
        case MSP_PSE_ERROR_INVALID_HKEYS_ADDR:
            printf("Invalid hash keys address\n");
            break;
        case MSP_PSE_ERROR_INVALID_HKEYS_LENGTH:
            printf("Invalid hash keys length\n");
            break;
        case MSP_PSE_ERROR_INVALID_ESPHDR_ADDR:
            printf("Invalid esp header address\n");
            break;
        case MSP_PSE_ERROR_INVALID_CIV_ADDR:
            printf("Invalid crypt iv address\n");
            break;
        case MSP_PSE_ERROR_INVALID_CRYPT_ALG:
            printf("Invalid crypt algorithm in mode\n");
            break;
        case MSP_PSE_ERROR_INVALID_CRYPT_BLK_MODE:
            printf("Invalid crypt block mode in mode\n");
            break;
        case MSP_PSE_ERROR_INVALID_HASH_ALG:
            printf("Invalid hash algorithm in mode\n");
            break;
        case MSP_PSE_ERROR_INVALID_ASSOC_ID:
            printf("Invalid association id\n");
            break;
        case MSP_PSE_ERROR_INVALID_SOURCE_ADDR:
            printf("Invalid source address\n");
            break;
        case MSP_PSE_ERROR_INVALID_SOURCE_SIZE:
            printf("Invalid source size\n");
            break;
        case MSP_PSE_ERROR_INVALID_DEST_ADDR:
            printf("Invalid destination address\n");
            break;
        case MSP_PSE_ERROR_INVALID_DEST_SIZE:
            printf("Invalid destination size\n");
            break;
        case MSP_PSE_ERROR_INVALID_CHAIN_ID:
            printf("Invalid chain id\n");
            break;
        case MSP_PSE_ERROR_RESOURCES:
            printf("Driver is out of resources\n");
            break;
        case MSP_PSE_ERROR_ICV_MISCOMPARE:
            printf("Miscompare on ICV\n");
            break;
        case MSP_PSE_ERROR_INVALID_COMP_FUNC:
            printf("Invalid completion function pointer\n");
            break;
    }
#endif
}

void MspSecTestAssocStart(uint   assocIndex)
{
	MSP_SEC2_SA	*sa ;
	uint	 	retStatus;
	uint		mode = 0;
	uint		errorFound = 0;
	AssocVectors	*av ;

	av = &assocVectors2Test[assocIndex] ;

	switch (av->eMode)
	{
        case CRYPT:
		mode |= SAFLG_MODE_CRYPT;
		break;
        case HASH:
		mode |= SAFLG_MODE_HASH;
		break;
        case HASHPAD:
		mode |= SAFLG_MODE_HASH_PAD;
		break;
        case HMAC:
		mode |= SAFLG_MODE_HMAC;
		break;
        case ESPOUT:
		mode |= SAFLG_MODE_ESP_OUT;
		break;
        case ESPIN:
		mode |= SAFLG_MODE_ESP_IN;
		break;
        default:
		errorFound = 1;
		break;
	}

	switch (av->cAlg)
	{
        case DES:
		mode |= SAFLG_DES;
		break;
        case TRIPLEDES:
		mode |= SAFLG_3DES;
		break;
        case AES128:
		mode |= SAFLG_AES_128;
		break;
        case AES192:
		mode |= SAFLG_AES_192;
		break;
        case AES256:
		mode |= SAFLG_AES_256;
		break;
        case CRYPTALGNU:
		break;
        default:
		errorFound = 2;
		break;
	}

	switch (av->cBlkMode)
	{
        case ECB:
		mode |= SAFLG_ECB;
		break;
        case CTR:
		mode |= SAFLG_CTR;
		break;
        case CBCD:
		mode |= SAFLG_CBC_DECRYPT;
		break;
        case CBCE:
		mode |= SAFLG_CBC_ENCRYPT;
		break;
        case CFBD:
		mode |= SAFLG_CFB_DECRYPT;
		break;
        case CFBE:
		mode |= SAFLG_CFB_ENCRYPT;
		break;
        case OFB:
		mode |= SAFLG_OFB;
		break;
        case BLKMODENU:
		break;
        default:
		errorFound = 3;
		break;
	}

	switch (av->cDirection)
	{
        case INCOMING:
		mode |= SAFLG_DES_K1_DECRYPT |
			SAFLG_DES_K3_DECRYPT;
		break;
        case OUTGOING:
		mode |= SAFLG_DES_K2_DECRYPT;
		break;
        case CRYPTDIRNU:
		break;
        default:
		errorFound = 4;
		break;
	}

	switch (av->aAlg)
	{
        case MD5:
		mode |= SAFLG_MD5;
		break;
        case SHA1:
		mode |= SAFLG_SHA1;
		break;
        case MD596:
		mode |= SAFLG_MD5_96;
		break;
        case SHA196:
		mode |= SAFLG_SHA1_96;
		break;
        case AALGNULL:
		mode |= SAFLG_HASHNULL;
		break;
        case AUTHALGNU:
		break;
        default:
		errorFound = 5;
		break;
	}

	switch (av->uChVars)
	{
        case DEFAULT:
		break;
        case USER:
		mode |= SAFLG_CV;
		break;
        case AUTHUCVNU:
		break;
        default:
		errorFound = 6;
		break;
	}

	switch (av->eCmpIcv)
	{
        case CMPARE:
		mode |= SAFLG_CPI;
		break;
        case NOCMPARE:
        case CRINU:
		break;
        default:
		errorFound = 7;
		break;
	}

	switch (av->eCreatIv)
	{
        case USERNG:
		mode |= SAFLG_CRI;
		break;
        case NORNG:
        case CRINU:
		break;
        default:
		errorFound = 8;
		break;
	}

	switch (av->eIncSeq)
	{
        case INCREM:
		mode |= SAFLG_SI;
		break;
        case NOINCREM:
        case SINU:
		break;
        default:
		errorFound = 9;
		break;
	}

	switch (av->iOrPoll)
	{
        case INTERMODE:
		// ???
		break;
        case POLLMODE:
		// ???
		break;
        default:
		errorFound = 10;
		break;
	}

	if (errorFound) {
		printf("Error found in test case:  %d\n",errorFound);
		return;
	}

    
	sa = &SecTestAssoc[assocIndex] ;

	sa->flags = mode ;
	sa->esp_sequence = 0 ;
	if (av->eHeader != 0)
		memcpy((void*)&sa->esp_spi, av->eHeader, 8);
	if (av->cKeys != 0)
		memcpy(sa->crypt_keys, av->cKeys, 32) ;
	if (av->cIv)
		memcpy(sa->crypt_iv, av->cIv, 16) ;

	switch (av->eMode)
	{
        case HASH:
        case HASHPAD:
		if (av->aKeys)
			memcpy(sa->hash_chain_a, av->aKeys, 20) ;
		break;
        case HMAC:
        case ESPOUT:
        case ESPIN:
		if (av->aKeys)
		{
			retStatus  = MSP_SEC2_SET_HMAC_KEY(sa, av->aKeys,
							   av->aKeySize,
							   0, 0) ;
			if (retStatus)
				SecTestPrintErrorStatus(retStatus) ;
		}
		break;
        default:
		break;
	}

	switch (av->cAlg)
	{
        case AES128:
        case AES192:
        case AES256:
		if (av->cDirection == INCOMING)
		{
			retStatus = MSP_SEC2_SET_AES_DECRYPT_KEY(sa, 0, 0) ;
			if (retStatus)
				SecTestPrintErrorStatus(retStatus) ;
		}
		break;
        default:
		break;
	}

	if (SecTestResultsLoud)
		SecShowSA(&SecTestAssoc[assocIndex]);
}

void MspSecTestShowOneAssoc(uint assocIndex)
{
    uint     errorFound = 0;

    if (SecTestAssoc[assocIndex].flags)
        printf(" X  ");
    else
        printf("    ");

    printf("%02d ",assocVectors2Test[assocIndex].index);

    switch (assocVectors2Test[assocIndex].eMode)
    {
        case CRYPT:
            printf("Crpt ");
            break;
        case HASH:
            printf("Hash ");
            break;
        case HASHPAD:
            printf("HsPd ");
            break;
        case HMAC:
            printf("Hmac ");
            break;
        case ESPOUT:
            printf("EspO ");
            break;
        case ESPIN:
            printf("EspI ");
            break;
        default:
            errorFound = 1;
            break;
    }
    
    switch (assocVectors2Test[assocIndex].cAlg)
    {
        case DES:
            printf("Des  ");
            break;
        case TRIPLEDES:
            printf("3Des ");
            break;
        case AES128:
            printf("A128 ");
            break;
        case AES192:
            printf("A192 ");
            break;
        case AES256:
            printf("A256 ");
            break;
        case CRYPTALGNU:
            printf(" --  ");
            break;
        default:
            errorFound = 2;
            break;
    }

    switch (assocVectors2Test[assocIndex].cBlkMode)
    {
        case ECB:
            printf("ECB   ");
            break;
        case CTR:
            printf("Cnter ");
            break;
        case CBCD:
            printf("CBC-D ");
            break;
        case CBCE:
            printf("CBC-E ");
            break;
        case CFBD:
            printf("CFB-D ");
            break;
        case CFBE:
            printf("CFB-E ");
            break;
        case OFB:
            printf("OFB   ");
            break;
        case BLKMODENU:
            printf(" --   ");
            break;
        default:
            errorFound = 3;
            break;
    }

    switch (assocVectors2Test[assocIndex].cDirection)
    {
        case INCOMING:
            printf("In  ");
            break;
        case OUTGOING:
            printf("Out ");
            break;
        case CRYPTDIRNU:
            printf(" -  ");
            break;
        default:
            errorFound = 4;
            break;
    }

    if (assocVectors2Test[assocIndex].cKeys)
        printf("0x%02x. ",(uint)*assocVectors2Test[assocIndex].cKeys);
    else
        printf("  -   ");

    if (assocVectors2Test[assocIndex].cIv)
        printf("0x%02x. ",(uint)*assocVectors2Test[assocIndex].cIv);
    else
        printf("  -   ");
                             
    switch (assocVectors2Test[assocIndex].aAlg)
    {
        case MD5:
            printf("Md5  ");
            break;
        case SHA1:
            printf("Sha1 ");
            break;
        case MD596:
            printf("Md96 ");
            break;
        case SHA196:
            printf("Sh96 ");
            break;
        case AALGNULL:
            printf("Null ");
            break;
        case AUTHALGNU:
            printf(" --  ");
            break;
        default:
            errorFound = 5;
            break;
    }

    switch (assocVectors2Test[assocIndex].uChVars)
    {
        case DEFAULT:
            printf("Def ");
            break;
        case USER:
            printf("Usr ");
            break;
        case AUTHUCVNU:
            printf(" -  ");
            break;
        default:
            errorFound = 6;
            break;
    }

    if (assocVectors2Test[assocIndex].aKeys)
        printf("0x%02x. ",(uint)*assocVectors2Test[assocIndex].aKeys);
    else
        printf("  -   ");
                             
    if (assocVectors2Test[assocIndex].aKeySize)
        printf(" %02d  ",assocVectors2Test[assocIndex].aKeySize);
    else
        printf(" --  ");

    if (assocVectors2Test[assocIndex].eHeader)
        printf("0x%02x. ",(uint)*assocVectors2Test[assocIndex].eHeader);
    else
        printf("  -   ");
                             
    switch (assocVectors2Test[assocIndex].eCmpIcv)
    {
        case CMPARE:
            printf("Cmp ");
            break;
        case NOCMPARE:
            printf("Noc ");
            break;
        case CRINU:
            printf(" -  ");
            break;
        default:
            errorFound = 7;
            break;
    }

    switch (assocVectors2Test[assocIndex].eCreatIv)
    {
        case USERNG:
            printf("Rnd ");
            break;
        case NORNG:
            printf("Fsa ");
            break;
        case CRINU:
            printf(" -  ");
            break;
        default:
            errorFound = 8;
            break;
    }

    switch (assocVectors2Test[assocIndex].eIncSeq)
    {
        case INCREM:
            printf("Inc ");
            break;
        case NOINCREM:
            printf("Noi ");
            break;
        case SINU:
            printf(" -  ");
            break;
        default:
            errorFound = 9;
            break;
    }

    switch (assocVectors2Test[assocIndex].iOrPoll)
    {
        case INTERMODE:
            printf("Int ");
            break;
        case POLLMODE:
            printf("Pol ");
            break;
        default:
            errorFound = 10;
            break;
    }

    if (errorFound) {
        printf("Error found in test case:  %d\n",assocIndex);
        printf("Error number:  %d\n",errorFound);
    }

    printf("\n");

}

void MspSecTestShowAssocs()
{
    uint     i;

    printf("Security Associations to test:\n");
    printf("\n");
    printf("Rdy In EMde CAlg CBlkM Dir CKeys CIv   AAlg AUC AKeys AKSz EHdr  ECI ECr EIS IoP\n");
    printf("--- -- ---- ---- ----- --- ----- ----- ---- --- ----- ---- ----- --- --- --- ---\n");
    
    for (i=0;i<SecTotalAssocTestVecs;i++) {
        MspSecTestShowOneAssoc(i);
    }

    printf("\n");

}

extern void SecHandleCompQ(uint     cmpQIndex);

void MspSecTestAssocX(uint   assocXIndex)
{
	MSP_SEC2_WQE		wqe ;
	uchar                      *destAddress;
	uint                     saIndex;
	uchar                      *tempAddrPtr;
	uchar                      *tempAddrPtr2;
	uint                     i;
	uint                     totalErrors = 0;
	uchar                    *gatherLoc0;
	uchar                    *gatherLoc1;
	uchar			 *gatherLoc2 = 0 ;
	void                     *scatterLoc;
	uint			 gatherLen0 ;
	uint			 gatherLen1 ;
	uint			 gatherLen2 = 0 ;
	uint                     retStatus;
	uint                     control ;
	uint			 destlen = 0 ;
	uint			 modulo ;
	uint			 padlen ;
	uchar			 icvbuf[20] ;
	uint			 icvlen = 0 ;


	destAddress = (uchar *)malloc(1500);

	saIndex = assocXVectors2Test[assocXIndex].saIndex;

	if (!SecTestAssoc[saIndex].flags) {
		printf("\n");
		printf("Test Association not ready\n");
		printf("MspSecTestAssocStart(%d) must be called first\n",saIndex);
		printf("\n");
		return;
	}

	scatterLoc = (void*)destAddress;
	gatherLoc0 = (void*)assocXVectors2Test[assocXIndex].srcAddr0;
	gatherLoc1 = (void*)assocXVectors2Test[assocXIndex].srcAddr1;

	gatherLen0 = assocXVectors2Test[assocXIndex].srcSize0 ;
	gatherLen1 = assocXVectors2Test[assocXIndex].srcSize1 ;

	control = 0 ;
	switch (assocVectors2Test[saIndex].eMode)
	{
	case CRYPT:
		destlen = gatherLen0 ;
		destlen += gatherLen1 ;
		break ;
	case HASH:
	case HASHPAD:
	case HMAC:
		switch (assocVectors2Test[saIndex].aAlg)
		{
		case MD5:
			destlen = 16 ;
			break ;
		case SHA1:
			destlen = 20 ;
			break ;
		case MD596:
		case SHA196:
			destlen = 12 ;
			break;
		default:
			destlen = 0 ;
		}
		break ;
	case ESPIN:
		destlen = gatherLen0 ;
		destlen += gatherLen1 ;
		destlen -= 8 ;	/* esp hdr */
		/* subtract IV */
		switch (assocVectors2Test[saIndex].cAlg)
		{
		case DES:
		case TRIPLEDES:
			destlen -= 8 ;
			break;
		case AES128:
		case AES192:
		case AES256:
			destlen -= 16 ;
			break;
		default:
			break;
		}
		/* subtract ICV */
		switch (assocVectors2Test[saIndex].aAlg)
		{
		case MD5:
			destlen -= 16 ;
			icvlen = 16 ;
			break ;
		case SHA1:
			destlen -= 20 ;
			icvlen = 20 ;
			break ;
		case MD596:
		case SHA196:
			destlen -= 12 ;
			icvlen = 12 ;
			break;
		default:
			break;
		}
		
		break ;
	case ESPOUT:
		destlen = gatherLen0 ;
		destlen += gatherLen1 ;

		/* add IV */
		switch (assocVectors2Test[saIndex].cAlg)
		{
		case DES:
		case TRIPLEDES:
			destlen += 8 ;
			modulo = 8 ;
			break;
		case AES128:
		case AES192:
		case AES256:
			destlen += 16 ;
			modulo = 16 ;
			break;
		default:
			modulo = 1 ;
		}

		/* add in trailer size */
		destlen += 2 ;

		/* destlen is now length of encrypted portion + iv. */
		/* The added in IV makes no difference wrt the % operation */

		padlen = (0x10000 - destlen) % modulo ;

		destlen += padlen ;

		destlen += 8 ; 	/* esp hdr */

		/* add ICV */
		switch (assocVectors2Test[saIndex].aAlg)
		{
		case MD5:
			destlen += 16 ;
			break ;
		case SHA1:
			destlen += 20 ;
			break ;
		case MD596:
		case SHA196:
			destlen += 12 ;
			break;
		default:
			break;
		}
		
		control = padlen << SEC2_WE_CTRL_PADLEN_SHF ;

		control |= assocXVectors2Test[assocXIndex].nProtocol
			<< SEC2_WE_CTRL_NXTHDR_SHF ;
		
		break ;
	}
	

	if (assocVectors2Test[saIndex].eMode == ESPIN)
	{
		gatherLoc0 = (uchar *)scatterLoc + 20;
		if (assocXVectors2Test[assocXIndex].srcAddr1)
			gatherLoc1 = (uchar *)gatherLoc0 + gatherLen0 ;
		else
			gatherLoc1 = 0;
		tempAddrPtr = assocXVectors2Test[assocXIndex].srcAddr0;
		tempAddrPtr2 = (uchar *)gatherLoc0;
		for (i=0;i< gatherLen0;i++)
			*tempAddrPtr2++ = *tempAddrPtr++;
		tempAddrPtr = assocXVectors2Test[assocXIndex].srcAddr1;
		tempAddrPtr2 = (uchar *)gatherLoc1;
		for (i=0;i < gatherLen1;i++)
			*tempAddrPtr2++ = *tempAddrPtr++;

		/* now, adjust buffering so gatherLoc2 points to ICV */
		if(gatherLen1 >= icvlen)
		{
			/* icv is totally in 2nd buffer */
			gatherLoc2 = gatherLoc1 + gatherLen1 - icvlen ;
			gatherLen2 = icvlen ;
			gatherLen1 -= icvlen ;
		}
		else if (gatherLen1 != 0)
		{
			/* icv is SPLIT across buffers */
			gatherLoc2 = &icvbuf[icvlen - gatherLen1] ;
			memcpy(gatherLoc2, gatherLoc1, gatherLen1) ;
			memcpy(icvbuf, gatherLoc0 + gatherLen0 - (icvlen - gatherLen1),
			       icvlen - gatherLen1) ;

			gatherLen0 -= icvlen - gatherLen1 ;

			gatherLoc1 = 0 ;
			gatherLen1 = 0 ;
			gatherLoc2 = icvbuf ;
			gatherLen2 = icvlen ;
		}
		else
		{
			/* icv is in first buffer */
			gatherLoc2 = gatherLoc0 + gatherLen0 - icvlen ;
			gatherLen2 = icvlen ;
			gatherLen0 -= icvlen ;
		}
	}

	if (assocVectors2Test[saIndex].eMode == ESPOUT)
	{
		tempAddrPtr = assocXVectors2Test[assocXIndex].srcAddr0;
		tempAddrPtr2 = destAddress;
		for (i=0;i< gatherLen0;i++)
			*tempAddrPtr2++ = *tempAddrPtr++;
    
		gatherLoc0 = scatterLoc;
		(uchar *)scatterLoc += 20;
	}
        
	MSP_SEC2_NEW_REQUEST(&wqe, 0, &SecTestAssoc[saIndex], control) ;
	printf("Gather lengths: %d, %d, %d\n", gatherLen0, gatherLen1, gatherLen2) ;
	printf("icvlen %d\n", icvlen) ;
	if (gatherLen0)
		MSP_SEC2_ADD_SG(&wqe, SG_GATHER, gatherLoc0, gatherLen0) ;
	if (gatherLen1)
		MSP_SEC2_ADD_SG(&wqe, SG_GATHER, gatherLoc1, gatherLen1) ;
	if (gatherLen2)
		MSP_SEC2_ADD_SG(&wqe, SG_GATHER, gatherLoc2, gatherLen2) ;
	MSP_SEC2_ADD_SG(&wqe, SG_SCATTER, scatterLoc, destlen) ;

	retStatus = MSP_SEC2_END_REQUEST(&wqe) ;

	if (retStatus)
	{
		printf("Status value was %d\n", (int)wqe.status) ;
		SecTestPrintErrorStatus(retStatus);
	}

	/* Compare results */
	tempAddrPtr = (uchar *)scatterLoc;
	tempAddrPtr2 = assocXVectors2Test[assocXIndex].expData;
	for (i=0;i<assocXVectors2Test[assocXIndex].expSize;i++) 
	{
		if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
			printf("Compare Error!\n");
			totalErrors++;

			

			break;
		}
	}

	if (SecTestResultsLoud) {
		tempAddrPtr = (uchar *)scatterLoc;
		printf("Got:\n");
		for (i=0;i<assocXVectors2Test[assocXIndex].expSize;i++) 
		{
			printf(" 0x%02x,",*tempAddrPtr++);
			if ((i % 8) == 7)
				printf("\n");
		}

		printf("\n");

		tempAddrPtr = assocXVectors2Test[assocXIndex].expData;
		printf("Expected:\n");
		for (i=0;i<assocXVectors2Test[assocXIndex].expSize;i++) 
		{
			printf(" 0x%02x,",*tempAddrPtr++);
			if ((i % 8) == 7)
				printf("\n");
		}
		printf("\n");
	}

	if (!totalErrors) 
		printf("Results compared!\n");

	free(destAddress);

	GlobalErrors += totalErrors ;
}

void MspSecTestShowAssocX(uint    assocXIndex)
{
    uint     saIndex;
    uchar      *tempAddrPtr = NULL;
    uint     pSize = 0;
    uint     i;
    uint     j;

    printf("Test Vector:\n");
    printf("\n");

    saIndex = assocXVectors2Test[assocXIndex].saIndex;
    printf("Assoc: %d\n",saIndex);
    printf("Rdy In EMde CAlg CBlkM Dir CKeys CIv   AAlg AUC AKeys AKSz EHdr  ECI ECr EIS IoP\n");
    printf("--- -- ---- ---- ----- --- ----- ----- ---- --- ----- ---- ----- --- --- --- ---\n");
    MspSecTestShowOneAssoc(saIndex);

    printf("\n");
    for (j=0;j<7;j++) 
    {
        switch (j) 
        {
            case (0):
                printf("SourceData0:\n");
                tempAddrPtr = assocXVectors2Test[assocXIndex].srcAddr0;
                pSize = assocXVectors2Test[assocXIndex].srcSize0;
                break;
            case (1):
                if (assocXVectors2Test[assocXIndex].srcAddr1) {
                    printf("SourceData1:\n");
                    tempAddrPtr = assocXVectors2Test[assocXIndex].srcAddr1;
                    pSize = assocXVectors2Test[assocXIndex].srcSize1;
                } else {
                    pSize = 0;
                }
                break;
            case (2):
                printf("Expected Data:\n");
                tempAddrPtr = assocXVectors2Test[assocXIndex].expData;
                pSize = assocXVectors2Test[assocXIndex].expSize;
                break;
            case (3):
                if (assocVectors2Test[saIndex].cKeys) {
                    printf("Crypt Keys:\n");
                    tempAddrPtr = assocVectors2Test[saIndex].cKeys;
                    
                    switch (assocVectors2Test[saIndex].cAlg) {
                        case DES:
                            pSize = 8;
                            break;
                        case AES128:
                            pSize = 16;
                            break;
                        case TRIPLEDES:
                        case AES192:
                            pSize = 24;
                            break;
                        case AES256:
                            pSize = 32;
                            break;
                        case CRYPTALGNU:
                            pSize = 0;
                            break;
                    }
                } else {
                    pSize = 0;
                }
                break;
            case (4):
                if (assocVectors2Test[saIndex].cIv) {
                    printf("Crypt IV:\n");
                    tempAddrPtr = assocVectors2Test[saIndex].cIv;
                    switch (assocVectors2Test[saIndex].cAlg) {
                        case DES:
                        case TRIPLEDES:
                            pSize = 8;
                            break;
                        case AES128:
                        case AES192:
                        case AES256:
                            pSize = 16;
                            break;
                        case CRYPTALGNU:
                            pSize = 0;
                            break;
                    }
                } else {
                    pSize = 0;
                }
                break;
            case (5):
                if (assocVectors2Test[saIndex].aKeys) {
                    printf("Authentication Keys:\n");
                    tempAddrPtr = assocVectors2Test[saIndex].aKeys;
                    pSize = assocVectors2Test[saIndex].aKeySize;
                } else {
                    pSize = 0;
                }
                break;
            case (6):
                if (assocVectors2Test[saIndex].eHeader) {
                    printf("ESP Out Header:\n");
                    tempAddrPtr = assocVectors2Test[saIndex].eHeader;
                    pSize = 8;
                } else {
                    pSize = 0;
                }
                break;
        }

        for (i=0;i< pSize;i++)
        {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 8) == 7)
                printf("\n");
        }
        if (pSize)
            printf("\n");
    }
    printf("\n");
    printf("Next Protocol:  0x%04x\n",assocXVectors2Test[assocXIndex].nProtocol);
}

void MspSecTestAssocStartAll()
{
    uint         i;

    for (i=0;i<SecTotalAssocTestVecs;i++) {
        if (!SecTestAssoc[i].flags) {
            MspSecTestAssocStart(i);
            printf("Added asociation:  %d\n",i);
        }
    }
}

void MspSecTestAssocFreeAll()
{
#if 0
    uint         i;

    for (i=0;i<SecTotalAssocTestVecs;i++) {
        if (SecTestAssocIds[i]) {
            MspSecAssocFree(SecTestAssocIds[i]);
            SecTestAssocIds[i] = 0;
            printf("Freed asociation:  %d\n",i);
        }
    }
#endif
}
void MspSecTestAssocXAllVec()
{
    uint         i;

    for (i=0;i<SecTotalAssocXTestVecs;i++) {
        printf("AssociationX:  %02d:  ",i);
        MspSecTestAssocX(i);
    }
}
#if 0
typedef struct {
    uint     assocXIndex;
    uchar      *destAddr;
    uint     scatterLoc;
} SecTestAssocXTotInfo;

SecTestAssocXTotInfo    SecTestAssocXTotItem[400];

volatile uint     SecTestAssocXTotSucc;
volatile uint     SecTestAssocXTotErrors;

uint     SecStressComplete = 0;
uint     SecStressStatus = 0;

static uchar			*pfreeList[1000];
static volatile uint	pfreeCount;

static uchar			*pfreeList2[1000];
static volatile uint	pfreeCount2;

static uchar			*pfreeList3[1000];
static volatile uint	pfreeCount3;

static uchar			*pfreeList4[1000];
static volatile uint	pfreeCount4;

static uchar			*pfreeList5[1000];
static volatile uint	pfreeCount5;

static uchar			*pfreeList6[1000];
static volatile uint	pfreeCount6;

static void prepareGlobalMemory()
{
	pfreeCount = 0;
	pfreeCount2 = 0;
	pfreeCount3 = 0;
	pfreeCount4 = 0;
	pfreeCount5 = 0;
	pfreeCount6 = 0;
	memset (pfreeList, 0, sizeof (pfreeList));
	memset (pfreeList2, 0, sizeof (pfreeList2));
	memset (pfreeList3, 0, sizeof (pfreeList3));
	memset (pfreeList4, 0, sizeof (pfreeList4));
	memset (pfreeList5, 0, sizeof (pfreeList5));
	memset (pfreeList6, 0, sizeof (pfreeList6));
}

static void returnGlobalMemory()
{
	int	i;

	for (i = 0; i < pfreeCount; i++)
	{
		free (pfreeList[i]);
		pfreeList[i] = 0;
	}
	pfreeCount = 0;

	for (i = 0; i < pfreeCount2; i++)
	{
		free (pfreeList2[i]);
		pfreeList2[i] = 0;
	}
	pfreeCount2 = 0;
	
    for (i = 0; i < pfreeCount3; i++)
	{
		free (pfreeList3[i]);
		pfreeList3[i] = 0;
	}
	pfreeCount3 = 0;

    for (i = 0; i < pfreeCount4; i++)
	{
		free (pfreeList4[i]);
		pfreeList4[i] = 0;
	}
	pfreeCount4 = 0;
    
    for (i = 0; i < pfreeCount5; i++)
	{
		free (pfreeList5[i]);
		pfreeList5[i] = 0;
	}
	pfreeCount5 = 0;

    for (i = 0; i < pfreeCount6; i++)
	{
		free (pfreeList6[i]);
		pfreeList6[i] = 0;
	}
	pfreeCount6 = 0;

}

void MspSecTestAssocXCBRout(uint      callerRefId,
                            uint      status)
{
    uint     assocXIndex;
    uint     scatterLoc;
    uchar      *destAddr;
    uchar      *tempAddrPtr;
    uchar      *tempAddrPtr2;
    uint     i;

    if (status)
        SecTestPrintErrorStatus(status);

    assocXIndex = SecTestAssocXTotItem[callerRefId].assocXIndex;
    scatterLoc = SecTestAssocXTotItem[callerRefId].scatterLoc;
    destAddr = SecTestAssocXTotItem[callerRefId].destAddr;

    /* Compare results */
    tempAddrPtr = (uchar *)scatterLoc;
    tempAddrPtr2 = assocXVectors2Test[assocXIndex].expData;
    for (i=0;i<assocXVectors2Test[assocXIndex].expSize;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            SecTestAssocXTotErrors++;
            break;
        }
    }

    SecTestAssocXTotSucc++;

	pfreeList [pfreeCount] = destAddr;
    pfreeCount++;
}

void MspSecTestAssocXTotal()
{
    msp_sec_assoc_params    secParams;
    uchar                      *destAddress;
    uint                     saIndex;
    STATUS                  delayStat;
    uint                     i;
    uint                     j;
    uint                     gatherLoc0;
    uint                     gatherLoc1;
    uint                     scatterLoc;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     assocXIndex = 0;
    uint                     noErrors = 1;

    MspSecTestAssocStartAll();

    prepareGlobalMemory();
    SecTestAssocXTotErrors = 0;

    while (noErrors) {
        SecTestAssocXTotSucc = 0;
        for (j=0;j < 400;j++)
        {
            destAddress = (uchar *)malloc(140);
    
            saIndex = assocXVectors2Test[assocXIndex].saIndex;
    
            scatterLoc = (uint)destAddress;
            gatherLoc0 = (uint)assocXVectors2Test[assocXIndex].srcAddr0;
            gatherLoc1 = (uint)assocXVectors2Test[assocXIndex].srcAddr1;
    
            if (assocVectors2Test[saIndex].eMode == ESPIN)
            {
                gatherLoc0 = scatterLoc + 20;
                gatherLoc1 = gatherLoc0 + assocXVectors2Test[assocXIndex].srcSize0;
                tempAddrPtr = assocXVectors2Test[assocXIndex].srcAddr0;
                tempAddrPtr2 = (uchar *)gatherLoc0;
                for (i=0;i< assocXVectors2Test[assocXIndex].srcSize0;i++)
                    *tempAddrPtr2++ = *tempAddrPtr++;
                tempAddrPtr = assocXVectors2Test[assocXIndex].srcAddr1;
                tempAddrPtr2 = (uchar *)gatherLoc1;
                for (i=0;i < assocXVectors2Test[assocXIndex].srcSize1;i++)
                    *tempAddrPtr2++ = *tempAddrPtr++;
            }
    
            if (assocVectors2Test[saIndex].eMode == ESPOUT)
            {
                tempAddrPtr = assocXVectors2Test[assocXIndex].srcAddr0;
                tempAddrPtr2 = destAddress;
                for (i=0;i< assocXVectors2Test[assocXIndex].srcSize0;i++)
                    *tempAddrPtr2++ = *tempAddrPtr++;
         
                gatherLoc0 = scatterLoc;
                scatterLoc += 20;
            }
         
            secParams.associationId = SecTestAssocIds[saIndex];
            secParams.nextProtocol = assocXVectors2Test[assocXIndex].nProtocol;
            secParams.sourceAddr0 = (uchar *)gatherLoc0;
            secParams.size0 = assocXVectors2Test[assocXIndex].srcSize0;
            secParams.sourceAddr1 = (uchar *)gatherLoc1;
            secParams.size1 = assocXVectors2Test[assocXIndex].srcSize1;
            secParams.destAddr0 = (uchar *)scatterLoc;
            secParams.destAddr1 = NULL;
    
            SecTestAssocXTotItem[j].destAddr = destAddress;
            SecTestAssocXTotItem[j].scatterLoc = scatterLoc;
            SecTestAssocXTotItem[j].assocXIndex = assocXIndex;
    
            MspSecAssocX ( j,
                           &secParams,
                           MspSecTestAssocXCBRout);
    
            if (assocVectors2Test[saIndex].iOrPoll == POLLMODE) {
                delayStat = taskDelay(100);
    
                SecHandleCompQ(0);
                SecHandleCompQ(1);
            }

            assocXIndex++;

            if (assocXIndex == SecTotalAssocXTestVecs)
                assocXIndex = 0;
        }

        delayStat = taskDelay(5);

        if (SecTestResultsLoud) {
            printf("\n");
            printf("Total completed and compared:   %d\n",SecTestAssocXTotSucc);
            printf("Total completed with comp err:  %d\n",SecTestAssocXTotErrors);
            printf("\n");
        } else {
            SecStressComplete += SecTestAssocXTotSucc;
        }

        if (SecTestAssocXTotErrors)
            noErrors = 0;

        returnGlobalMemory();
    }
}

/* Polo Support */

uint     PoloCryptSessionId = 0;
uint     PoloCryptFullSessionId = 0;
uint     PoloHashSessionId = 0;
uint     PoloHashPadSessionId = 0;
uint     PoloHmacSessionId = 0;
uint     PoloEspOutSessionId = 0;
uint     PoloEspInSessionId = 0;
uint     PoloEspInInPlaceSessionId = 0;

uint     PoloCryptSessionMode = MSP_SEC_SA_ENG_MODE_CRYPT |
                               MSP_SEC_SA_CRYPT_BLK_ECB |
                               MSP_SEC_SA_CRYPT_ALG_DES |
                               MSP_SEC_SA_INTERRUPT_MODE;

uint     PoloCryptFullSessionMode = MSP_SEC_SA_ENG_MODE_CRYPT |
                                   MSP_SEC_SA_CRYPT_BLK_ECB |
                                   MSP_SEC_SA_CRYPT_ALG_DES |
                                   /* MSP_SEC_SA_INTERRUPT_MODE; */
                                   MSP_SEC_SA_POLLING_MODE;

uint     PoloHashSessionMode = MSP_SEC_SA_ENG_MODE_HASH |
                              MSP_SEC_SA_HASH_ALG_MD5 |
                              MSP_SEC_SA_USE_DEF_CHAIN_VARS |
                              MSP_SEC_SA_INTERRUPT_MODE;

uint     PoloHashPadSessionMode = MSP_SEC_SA_ENG_MODE_HASH_PAD |
                                 MSP_SEC_SA_HASH_ALG_MD5 |
                                 MSP_SEC_SA_USE_DEF_CHAIN_VARS |
                                 MSP_SEC_SA_INTERRUPT_MODE;

uint     PoloHmacSessionMode = MSP_SEC_SA_ENG_MODE_HMAC |
                              MSP_SEC_SA_HASH_ALG_SHA1 |
                              MSP_SEC_SA_USE_CHAINING_VARS |
                              MSP_SEC_SA_INTERRUPT_MODE;

uint     PoloEspOutSessionMode = MSP_SEC_SA_ENG_MODE_ESP_OUT |
                                MSP_SEC_SA_CRYPT_ALG_3_DES |
                                MSP_SEC_SA_DES_KEY_2_DECRYPT |
                                MSP_SEC_SA_HASH_ALG_SHA1 |
                                MSP_SEC_SA_USE_CHAINING_VARS |
                                MSP_SEC_SA_CRYPT_BLK_ECB |
                                MSP_SEC_SA_INTERRUPT_MODE;

uint     PoloEspInSessionMode = MSP_SEC_SA_ENG_MODE_ESP_IN |
                               MSP_SEC_SA_HASH_ALG_SHA1 |
                               MSP_SEC_SA_DES_KEY_1_DECRYPT |
                               MSP_SEC_SA_USE_CHAINING_VARS |
                               MSP_SEC_SA_CRYPT_BLK_CBC_DEC |
                               MSP_SEC_SA_INTERRUPT_MODE;

uint     PoloEspInInPlaceSessionMode = MSP_SEC_SA_ENG_MODE_ESP_IN |
                                      MSP_SEC_SA_ESP_CMP_ICV |
                                      MSP_SEC_SA_HASH_ALG_SHA1_96 |
                                      MSP_SEC_SA_DES_KEY_1_DECRYPT |
                                      MSP_SEC_SA_USE_CHAINING_VARS |
                                      MSP_SEC_SA_CRYPT_BLK_CBC_DEC |
                                      MSP_SEC_SA_INTERRUPT_MODE;

void MspSecTestSetPoloModeCryptPoll()
{
    PoloCryptSessionMode = MSP_SEC_SA_ENG_MODE_CRYPT |
                           MSP_SEC_SA_CRYPT_BLK_ECB |
                           MSP_SEC_SA_CRYPT_ALG_DES |
                           MSP_SEC_SA_POLLING_MODE;
}

void MspSecTestSetPoloModeCryptInt()
{
    PoloCryptSessionMode = MSP_SEC_SA_ENG_MODE_CRYPT |
                           MSP_SEC_SA_CRYPT_BLK_ECB |
                           MSP_SEC_SA_CRYPT_ALG_DES |
                           MSP_SEC_SA_INTERRUPT_MODE;
}

void MspSecTestSetPoloModeHashPoll()
{
    PoloHashSessionMode = MSP_SEC_SA_ENG_MODE_HASH |
                          MSP_SEC_SA_HASH_ALG_MD5 |
                          MSP_SEC_SA_USE_DEF_CHAIN_VARS |
                          MSP_SEC_SA_POLLING_MODE;
}

void MspSecTestSetPoloModeHashInt()
{
    PoloHashSessionMode = MSP_SEC_SA_ENG_MODE_HASH |
                          MSP_SEC_SA_HASH_ALG_MD5 |
                          MSP_SEC_SA_USE_DEF_CHAIN_VARS |
                          MSP_SEC_SA_INTERRUPT_MODE;
}

void MspSecTestSetPoloModeHashPadPoll()
{
    PoloHashPadSessionMode = MSP_SEC_SA_ENG_MODE_HASH_PAD |
                             MSP_SEC_SA_HASH_ALG_MD5 |
                             MSP_SEC_SA_USE_DEF_CHAIN_VARS |
                             MSP_SEC_SA_POLLING_MODE;
}

void MspSecTestSetPoloModeHashPadInt()
{
    PoloHashPadSessionMode = MSP_SEC_SA_ENG_MODE_HASH_PAD |
                             MSP_SEC_SA_HASH_ALG_MD5 |
                             MSP_SEC_SA_USE_DEF_CHAIN_VARS |
                             MSP_SEC_SA_INTERRUPT_MODE;
}

void MspSecTestSetPoloModeHmacPoll()
{
    PoloHmacSessionMode = MSP_SEC_SA_ENG_MODE_HMAC |
                          MSP_SEC_SA_HASH_ALG_SHA1 |
                          MSP_SEC_SA_USE_CHAINING_VARS |
                          MSP_SEC_SA_POLLING_MODE;
}

void MspSecTestSetPoloModeHmacInt()
{
    PoloHmacSessionMode = MSP_SEC_SA_ENG_MODE_HMAC |
                          MSP_SEC_SA_HASH_ALG_SHA1 |
                          MSP_SEC_SA_USE_CHAINING_VARS |
                          MSP_SEC_SA_INTERRUPT_MODE;
}

void MspSecTestSetPoloModeEspOutPoll()
{
    PoloEspOutSessionMode = MSP_SEC_SA_ENG_MODE_ESP_OUT |
                            MSP_SEC_SA_CRYPT_ALG_3_DES |
                            MSP_SEC_SA_DES_KEY_2_DECRYPT |
                            MSP_SEC_SA_HASH_ALG_SHA1 |
                            MSP_SEC_SA_USE_CHAINING_VARS |
                            MSP_SEC_SA_CRYPT_BLK_ECB |
                            MSP_SEC_SA_POLLING_MODE;

}

void MspSecTestSetPoloModeEspOutInt()
{
    PoloEspOutSessionMode = MSP_SEC_SA_ENG_MODE_ESP_OUT |
                            MSP_SEC_SA_CRYPT_ALG_3_DES |
                            MSP_SEC_SA_DES_KEY_2_DECRYPT |
                            MSP_SEC_SA_HASH_ALG_SHA1 |
                            MSP_SEC_SA_USE_CHAINING_VARS |
                            MSP_SEC_SA_CRYPT_BLK_ECB |
                            MSP_SEC_SA_INTERRUPT_MODE;

}

void MspSecTestSetPoloModeEspInPoll()
{

    PoloEspInSessionMode = MSP_SEC_SA_ENG_MODE_ESP_IN |
                           MSP_SEC_SA_ESP_INC_SEQ_NUM |
                           MSP_SEC_SA_HASH_ALG_SHA1 |
                           MSP_SEC_SA_USE_CHAINING_VARS |
                           MSP_SEC_SA_DES_KEY_1_DECRYPT |
                           MSP_SEC_SA_DES_KEY_3_DECRYPT |
                           MSP_SEC_SA_CRYPT_BLK_CBC_DEC |
                           MSP_SEC_SA_POLLING_MODE;
}

void MspSecTestSetPoloModeEspInInt()
{
    PoloEspInSessionMode = MSP_SEC_SA_ENG_MODE_ESP_IN |
                           MSP_SEC_SA_ESP_INC_SEQ_NUM |
                           MSP_SEC_SA_HASH_ALG_SHA1 |
                           MSP_SEC_SA_USE_CHAINING_VARS |
                           MSP_SEC_SA_DES_KEY_1_DECRYPT |
                           MSP_SEC_SA_DES_KEY_3_DECRYPT |
                           MSP_SEC_SA_CRYPT_BLK_CBC_DEC |
                           MSP_SEC_SA_INTERRUPT_MODE;

}

void MspSecTestCryptAssocStart()
{
	uchar                  *keyValue;
    uint                 retStatus;

    keyValue = PCSecKey0;

    retStatus = MspSecAssocStart(&PoloCryptSessionId,
                                 PoloCryptSessionMode,
                                 keyValue,
                                 NULL,
                                 0,
                                 NULL,
                                 NULL,
                                 0);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    printf("PoloCryptSessionId:  0x%x\n",PoloCryptSessionId);

    if (SecTestResultsLoud)
        SecShowSA(PoloCryptSessionId);
}

void MspSecTestCryptFullAssocStart()
{
	uchar                  *keyValue;
    uint                 retStatus;

    keyValue = PCSecKey1;

    retStatus = MspSecAssocStart(&PoloCryptFullSessionId,
                                 PoloCryptFullSessionMode,
                                 keyValue,
                                 NULL,
                                 0,
                                 NULL,
                                 NULL,
                                 0);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    printf("PoloCryptFullSessionId:  0x%x\n",PoloCryptFullSessionId);

    if (SecTestResultsLoud)
        SecShowSA(PoloCryptFullSessionId);
}

void MspSecTestHashAssocStart()
{
    msp_sec_hsh_chaining_vars   chVars;
    uchar                          *hashKeysAddr;
    uint                         hashKeyLength;
    uint                         retStatus;

    chVars.ChainVarA = 0;
    chVars.ChainVarB = 0;
    chVars.ChainVarC = 0;
    chVars.ChainVarD = 0;
    chVars.ChainVarE = 0;

    hashKeysAddr = (uchar *)&chVars;
    hashKeyLength = 0;

    retStatus = MspSecAssocStart(&PoloHashSessionId,
                                 PoloHashSessionMode,
                                 NULL,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 NULL,
                                 NULL,
                                 0);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    printf("PoloHashSessionId:  0x%x\n",PoloHashSessionId);

    SecShowSA(PoloHashSessionId);
}

void MspSecTestHashPadAssocStart()
{
    msp_sec_hsh_chaining_vars   chVars;
    uchar                          *hashKeysAddr;
    uint                         hashKeyLength;
    uint                         retStatus;

    chVars.ChainVarA = 0;
    chVars.ChainVarB = 0;
    chVars.ChainVarC = 0;
    chVars.ChainVarD = 0;
    chVars.ChainVarE = 0;

    hashKeysAddr = (uchar *)&chVars;
    hashKeyLength = 0;

    retStatus = MspSecAssocStart(&PoloHashPadSessionId,
                                 PoloHashPadSessionMode,
                                 NULL,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 NULL,
                                 NULL,
                                 0);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    printf("PoloHashPadSessionId:  0x%x\n",PoloHashPadSessionId);

    SecShowSA(PoloHashPadSessionId);
}

void MspSecTestHmacAssocStart()
{
    uchar                  *hashKeysAddr;
    uint                 hashKeyLength;
    uint                 retStatus;

    hashKeysAddr = hmacKey8;
    hashKeyLength = 20;

    retStatus = MspSecAssocStart(&PoloHmacSessionId,
                                 PoloHmacSessionMode,
                                 NULL,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 NULL,
                                 NULL,
                                 0);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    printf("PoloHmacSessionId:  0x%x\n",PoloHmacSessionId);

    /* SecHandleCompQ(0); */

    SecShowSA(PoloHmacSessionId);
}

void MspSecTestEspOutAssocStart()
{
	uchar                          *keyValue;
    uchar                          *ivValue;
    uchar                          *hashKeysAddr;
    uint                         hashKeyLength;
    uint                         retStatus;
    uchar                          *espInitialHeader;

    keyValue = PCSecKey6;

    ivValue = PCSecIv6;

    hashKeysAddr = PASecKey4;
    hashKeyLength = 20;

    espInitialHeader = PESecHdr6;

    retStatus = MspSecAssocStart(&PoloEspOutSessionId,
                                 PoloEspOutSessionMode,
                                 keyValue,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 espInitialHeader,
                                 ivValue,
                                 0);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    printf("PoloEspOutSessionId:  0x%x\n",PoloEspOutSessionId);

    SecShowSA(PoloEspOutSessionId);
}

void MspSecTestEspInAssocStart()
{
	uchar                          *keyValue;
	msp_sec_des_iv	            IV;
    uchar                          *hashKeysAddr;
    uint                         hashKeyLength;
    uint                         retStatus;
    uint                         *tempLongPtr;

    keyValue = (uchar *)malloc(24);
    tempLongPtr = (uint *)keyValue;
    *tempLongPtr++ = 0x57b3ea0b;
    *tempLongPtr++ = 0x3e1f83fe;
    *tempLongPtr++ = 0x57b3ea0b; 
    *tempLongPtr++ = 0x3e1f83fe;
    *tempLongPtr++ = 0x57b3ea0b; 
    *tempLongPtr++ = 0x3e1f83fe;
    /* *tempLongPtr++ = 0x61626364;
    *tempLongPtr++ = 0x61626364; */
    IV.IVHigh = 0x0cc3387d;
    IV.IVLow = 0x732d5a34;

    hashKeysAddr = hmacKey8;
    hashKeyLength = 20;

    retStatus = MspSecAssocStart(&PoloEspInSessionId,
                                 PoloEspInSessionMode,
                                 keyValue,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 NULL,
                                 (uchar *)&IV,
                                 0);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    printf("PoloEspInSessionId:  0x%x\n",PoloEspInSessionId);

    free(keyValue);

    SecShowSA(PoloEspInSessionId);
}

void SecTestAssocXCompFunc(uint callerRefId, uint status)
{
    if (status)
        SecTestPrintErrorStatus(status);

    printf("  callerRefId: 0x%x\n",callerRefId);
}

void MspSecTestAssocXCrypt()
{
    msp_sec_assoc_params    secParams;
    uchar                      *destAddress;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uint                     retStatus;
    uint                     totalErrors = 0;

    destAddress = (uchar *)malloc(64);

    secParams.associationId = PoloCryptSessionId;
    secParams.nextProtocol = 0;
    secParams.sourceAddr0 = NistSrc1;
    secParams.size0 = 8;
    secParams.sourceAddr1 = NULL;
    secParams.size1 = 0;
    secParams.destAddr0 = destAddress;
    secParams.destAddr1 = NULL;

    retStatus = MspSecAssocXBlk ( &secParams);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    /* Compare results */
    tempAddrPtr = destAddress;
    tempAddrPtr2 = NistExp1;
    for (i=0;i<8;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }

    if (SecTestResultsLoud) {
        tempAddrPtr = destAddress;
        printf("Got:\n");
        for (i=0;i<8;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }

        tempAddrPtr = NistExp1;
        printf("Expected:\n");
        for (i=0;i<8;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    }

    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

void MspSecTestAssocXCryptFull()
{
    msp_sec_assoc_params    secParams;
    uchar                      *destAddress;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uint                     retStatus;
    uint                     totalErrors = 0;

    destAddress = (uchar *)malloc(64);

    secParams.associationId = PoloCryptFullSessionId;
    secParams.nextProtocol = 0;
    secParams.sourceAddr0 = PCSrcData1a;
    secParams.size0 = 32;
    secParams.sourceAddr1 = PCSrcData1b;
    secParams.size1 = 16;
    secParams.destAddr0 = destAddress;
    secParams.destAddr1 = NULL;

    retStatus = MspSecAssocXBlk (&secParams);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    /* Compare results */
    tempAddrPtr = destAddress;
    tempAddrPtr2 = PCExpData1;
    for (i=0;i<48;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }

    if (SecTestResultsLoud) {
        tempAddrPtr = destAddress;
        printf("Got:\n");
        for (i=0;i<48;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }

        tempAddrPtr = PCExpData1;
        printf("Expected:\n");
        for (i=0;i<48;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    }

    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

void MspSecTestAssocXHash()
{
    msp_sec_assoc_params    secParams;
    uchar                      *destAddress;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uint                     retStatus;
    uint                     totalErrors = 0;

    destAddress = (uchar *)malloc(64);

    secParams.associationId = PoloHashSessionId;
    secParams.nextProtocol = 0;
    secParams.sourceAddr0 = SrcData9;
    secParams.size0 = 64;
    secParams.sourceAddr1 = NULL;
    secParams.size1 = 0;
    secParams.destAddr0 = destAddress;
    secParams.destAddr1 = NULL;

    retStatus = MspSecAssocXBlk (&secParams);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    /* Compare results */
    tempAddrPtr = destAddress;
    tempAddrPtr2 = ExpData5;
    for (i=0;i<16;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }

    if (SecTestResultsLoud) {
        tempAddrPtr = destAddress;
        printf("Got:\n");
        for (i=0;i<16;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    
        tempAddrPtr = ExpData5;
        printf("Expected:\n");
        for (i=0;i<16;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    }

    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

void MspSecTestAssocXHashPad()
{
    msp_sec_assoc_params    secParams;
    uchar                      *destAddress;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uint                     retStatus;
    uint                     totalErrors = 0;

    destAddress = (uchar *)malloc(64);

    secParams.associationId = PoloHashPadSessionId;
    secParams.nextProtocol = 0;
    secParams.sourceAddr0 = md5Vector2;
    secParams.size0 = 1;
    secParams.sourceAddr1 = NULL;
    secParams.size1 = 0;
    secParams.destAddr0 = destAddress;
    secParams.destAddr1 = NULL;

    retStatus = MspSecAssocXBlk(&secParams);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    /* Compare results */
    tempAddrPtr = destAddress;
    tempAddrPtr2 = md5Result2;
    for (i=0;i<16;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }

    if (SecTestResultsLoud) {
        tempAddrPtr = destAddress;
        printf("Got:\n");
        for (i=0;i<16;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    
        tempAddrPtr = md5Result2;
        printf("Expected:\n");
        for (i=0;i<16;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    }

    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

void MspSecTestAssocXHmac()
{
    msp_sec_assoc_params    secParams;
    uchar                      *destAddress;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uint                     retStatus;
    uint                     totalErrors = 0;

    destAddress = (uchar *)malloc(64);

    secParams.associationId = PoloHmacSessionId;
    secParams.nextProtocol = 0;
    /* secParams.sourceAddr0 = hmacVector1; */
    secParams.sourceAddr0 = hmacVector8;
    secParams.size0 = 8;
    secParams.sourceAddr1 = NULL;
    secParams.size1 = 0;
    secParams.destAddr0 = destAddress;
    secParams.destAddr1 = NULL;

    retStatus = MspSecAssocXBlk(&secParams);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    /* Compare results */
    tempAddrPtr = destAddress;
    /* tempAddrPtr2 = hmacResult1; */
    tempAddrPtr2 = hmacResult8;
    for (i=0;i<16;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }

    if (SecTestResultsLoud) {
        tempAddrPtr = destAddress;
        printf("Got:\n");
        for (i=0;i<16;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }

        /* tempAddrPtr = hmacResult1; */
        tempAddrPtr = hmacResult8;
        printf("Expected:\n");
        for (i=0;i<16;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    }

    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

void MspSecTestAssocXEspOut()
{
    msp_sec_assoc_params    secParams;
    uchar                      *destAddress;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uint                     retStatus;
    uint                     totalErrors = 0;

    destAddress = (uchar *)malloc(128);

    secParams.associationId = PoloEspOutSessionId;
    secParams.nextProtocol = 0x06;
    secParams.sourceAddr0 = PSrcData6;
    secParams.size0 = 40;
    secParams.sourceAddr1 = NULL;
    secParams.size1 = 0;
    secParams.destAddr0 = destAddress;
    secParams.destAddr1 = NULL;

    retStatus = MspSecAssocXBlk (&secParams);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    /* Compare results */
    tempAddrPtr = destAddress;
    tempAddrPtr2 = PExpData6;
    for (i=0;i<84;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }

    if (SecTestResultsLoud) {
        tempAddrPtr = destAddress;
        printf("Got:\n");
        for (i=0;i<84;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }

        tempAddrPtr = PExpData6;
        printf("Expected:\n");
        for (i=0;i<84;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    }

    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

void MspSecTestAssocXEspIn()
{
    msp_sec_assoc_params    secParams;
    uchar                      *destAddress;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uint                     retStatus;
    uint                     totalErrors = 0;

    destAddress = (uchar *)malloc(128);

    secParams.associationId = PoloEspInSessionId;
    secParams.nextProtocol = 0;
    secParams.sourceAddr0 = PSrcData7a;
    secParams.size0 = 64;
    secParams.sourceAddr1 = PSrcData7b;
    secParams.size1 = 20;
    secParams.destAddr0 = destAddress;
    secParams.destAddr1 = NULL;

    retStatus = MspSecAssocXBlk (&secParams);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    /* Compare results */
    tempAddrPtr = destAddress;
    tempAddrPtr2 = PExpData7;
    for (i=0;i<48;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }

    if (SecTestResultsLoud) {
        tempAddrPtr = destAddress;
        printf("Got:\n");
        for (i=0;i<48;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }

        tempAddrPtr = PExpData7;
        printf("Expected:\n");
        for (i=0;i<48;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    }

    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

uint HoldUp = 50;
uint SecTotalXAll = 100;

static  uint     SecTotalAssocXAllErrors;
static  uint     SecTotalAssocXAllCompares;

void SecTestAssocXCryptCompFunc(uint callerRefId, uint status)
{
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     erroredOut = 0;
    uint                     j;

#if 0   
    printf("SecTestAssocXCryptCompFunc called\n");
    printf("  Status: 0x%x\n",status);
    printf("  callerRefId: 0x%x\n",callerRefId);
#endif

    if (status)
        SecTestPrintErrorStatus(status);

    /* Compare results */
    tempAddrPtr = (uchar *)callerRefId;
    tempAddrPtr2 = PCExpData1;
    for (j=0;j<48;j++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            if (SecTestResultsLoud)
                printf("Compare Error!\n");
            SecTotalAssocXAllErrors++;
            SecStressStatus = 1;
            erroredOut = 1;
            break;
        }
    }

    if (!erroredOut)
        SecTotalAssocXAllCompares++;

	pfreeList [pfreeCount] = (uchar *) callerRefId;
    pfreeCount++;

}

void SecTestAssocXHashCompFunc(uint callerRefId, uint status)
{
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     erroredOut = 0;
    uint                     j;

#if 0   
    printf("SecTestAssocXCryptCompFunc called\n");
    printf("  Status: 0x%x\n",status);
    printf("  callerRefId: 0x%x\n",callerRefId);
#endif

    if (status)
        SecTestPrintErrorStatus(status);

    /* Compare results */
    tempAddrPtr = (uchar *)callerRefId;
    tempAddrPtr2 = ExpData5;
    for (j=0;j<16;j++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            if (SecTestResultsLoud)
                printf("Compare Error!\n");
            SecTotalAssocXAllErrors++;
            SecStressStatus = 2;
            erroredOut = 1;
            break;
        }
    }
    
    if (!erroredOut)
        SecTotalAssocXAllCompares++;

	pfreeList2 [pfreeCount2] = (uchar *) callerRefId;
    pfreeCount2++;

}

void SecTestAssocXHashPadCompFunc(uint callerRefId, uint status)
{
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     erroredOut = 0;
    uint                     j;

#if 0   
    printf("SecTestAssocXCryptCompFunc called\n");
    printf("  Status: 0x%x\n",status);
    printf("  callerRefId: 0x%x\n",callerRefId);
#endif

    if (status)
        SecTestPrintErrorStatus(status);

    /* Compare results */
    tempAddrPtr = (uchar *)callerRefId;
    tempAddrPtr2 = md5Result2;
    for (j=0;j<16;j++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            if (SecTestResultsLoud)
                printf("Compare Error!\n");
            SecTotalAssocXAllErrors++;
            SecStressStatus = 3;
            erroredOut = 1;
            break;
        }
    }
    
    if (!erroredOut)
        SecTotalAssocXAllCompares++;

	pfreeList3 [pfreeCount3] = (uchar *) callerRefId;
    pfreeCount3++;

}

void SecTestAssocXHmacCompFunc(uint callerRefId, uint status)
{
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     erroredOut = 0;
    uint                     j;

#if 0   
    printf("SecTestAssocXCryptCompFunc called\n");
    printf("  Status: 0x%x\n",status);
    printf("  callerRefId: 0x%x\n",callerRefId);
#endif

    if (status)
        SecTestPrintErrorStatus(status);

    /* Compare results */
    tempAddrPtr = (uchar *)callerRefId;
    /* tempAddrPtr2 = hmacResult1; */
    tempAddrPtr2 = hmacResult8;
    for (j=0;j<16;j++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            if (SecTestResultsLoud)
                printf("Compare Error!\n");
            SecTotalAssocXAllErrors++;
            SecStressStatus = 4;
            erroredOut = 1;
            break;
        }
    }
    
    if (!erroredOut)
        SecTotalAssocXAllCompares++;

	pfreeList4 [pfreeCount4] = (uchar *) callerRefId;
    pfreeCount4++;

}

void SecTestAssocXEspOutCompFunc(uint callerRefId, uint status)
{
    uint                     tempLoc;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     erroredOut = 0;
    uint                     i;

#if 0   
    printf("SecTestAssocXCryptCompFunc called\n");
    printf("  Status: 0x%x\n",status);
    printf("  callerRefId: 0x%x\n",callerRefId);
#endif

    if (status)
        SecTestPrintErrorStatus(status);

    /* Compare results */
    tempLoc = callerRefId;
    tempLoc += 16;
    tempAddrPtr = (uchar *)tempLoc;
    tempAddrPtr2 = PCExpData1;
    for (i=0;i<68;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            if (SecTestResultsLoud)
                printf("Compare Error!\n");
            SecTotalAssocXAllErrors++;
            SecStressStatus = 5;
            erroredOut = 1;
            break;
        }
    }

    if (!erroredOut)
        SecTotalAssocXAllCompares++;

	pfreeList5 [pfreeCount5] = (uchar *) callerRefId;
    pfreeCount5++;

}

void SecTestAssocXEspInCompFunc(uint callerRefId, uint status)
{
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     erroredOut = 0;
    uint                     i;

#if 0   
    printf("SecTestAssocXCryptCompFunc called\n");
    printf("  Status: 0x%x\n",status);
    printf("  callerRefId: 0x%x\n",callerRefId);
#endif

    if (status)
        SecTestPrintErrorStatus(status);

    /* Compare results */
    tempAddrPtr = (uchar *)callerRefId;
    tempAddrPtr2 = PExpData7;
    for (i=0;i<48;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            if (SecTestResultsLoud)
                printf("Compare Error!\n");
            SecTotalAssocXAllErrors++;
            SecStressStatus = 6;
            erroredOut = 1;
            break;
        }
    }

    if (!erroredOut)
        SecTotalAssocXAllCompares++;

	pfreeList6 [pfreeCount6] = (uchar *) callerRefId;
    pfreeCount6++;

}

void MspSecTestPrepareAssocXAll()
{
    MspSecTestSetPoloModeCryptInt();

    MspSecTestCryptAssocStart();

    MspSecTestSetPoloModeHashInt();
    
    MspSecTestHashAssocStart();

    MspSecTestSetPoloModeHashPadInt();
    
    MspSecTestHashPadAssocStart();

    MspSecTestSetPoloModeHmacInt();
    
    MspSecTestHmacAssocStart();

    MspSecTestSetPoloModeEspOutInt();
    
    MspSecTestEspOutAssocStart();

    MspSecTestSetPoloModeEspInInt();
    
    MspSecTestEspInAssocStart();

}

void MspSecTestAssocXAll()
{
    msp_sec_assoc_params    secParams;
    uint                     callerRefId;
    uchar                      *destAddress;
    STATUS                  delayStat;
    uint                     i;
    uint                     retStatus;
    uint                     noErrors;
    uint                     noIters;

    MspSecTestPrepareAssocXAll();

    prepareGlobalMemory();

    noErrors = 1;
    noIters = 1;

    while (noErrors) {
        SecTotalAssocXAllErrors = 0;
        SecTotalAssocXAllCompares = 0;

        if (SecTestResultsLoud) {
            printf("Iteration:  %d\n",noIters);
        }

        for (i=0;i< SecTotalXAll;i++ )
        {

            destAddress = (uchar *)malloc(64);

            callerRefId = (uint)destAddress;

            secParams.associationId = PoloCryptSessionId;
            secParams.nextProtocol = 0;
            secParams.sourceAddr0 = PCSrcData1a;
            secParams.size0 = 32;
            secParams.sourceAddr1 = PCSrcData1b;
            secParams.size1 = 16;
            secParams.destAddr0 = destAddress;
            secParams.destAddr1 = NULL;

            retStatus = MspSecAssocX ( callerRefId,
                                       &secParams,
                                       SecTestAssocXCryptCompFunc);

            if (retStatus) {
                printf("Failed on crypt op\n");
                SecTestPrintErrorStatus(retStatus);
            }

            if (!(PoloCryptSessionMode & MSP_SEC_SA_INTERRUPT_MODE)) {
                delayStat = taskDelay(HoldUp);

                SecHandleCompQ(0);
            }
        
            destAddress = (uchar *)malloc(64);

            callerRefId = (uint)destAddress;

            secParams.associationId = PoloHashSessionId;
            secParams.nextProtocol = 0;
            secParams.sourceAddr0 = SrcData9;
            secParams.size0 = 64;
            secParams.sourceAddr1 = NULL;
            secParams.size1 = 0;
            secParams.destAddr0 = destAddress;
            secParams.destAddr1 = NULL;
    
            retStatus = MspSecAssocX ( callerRefId,
                                       &secParams,
                                       SecTestAssocXHashCompFunc);
    
            if (retStatus) {
                printf("Failed on hash op\n");
                SecTestPrintErrorStatus(retStatus);
            }

            if (!(PoloHashSessionMode & MSP_SEC_SA_INTERRUPT_MODE)) {
                delayStat = taskDelay(HoldUp);

                SecHandleCompQ(0);
            
            }

            destAddress = (uchar *)malloc(64);

            callerRefId = (uint)destAddress;

            secParams.associationId = PoloHashPadSessionId;
            secParams.nextProtocol = 0;
            secParams.sourceAddr0 = md5Vector2;
            secParams.size0 = 1;
            secParams.sourceAddr1 = NULL;
            secParams.size1 = 0;
            secParams.destAddr0 = destAddress;
            secParams.destAddr1 = NULL;

            retStatus = MspSecAssocX ( callerRefId,
                                       &secParams,
                                       SecTestAssocXHashPadCompFunc);

            if (retStatus) {
                printf("Failed on hash with pad op\n");
                SecTestPrintErrorStatus(retStatus);
            }

            if (!(PoloHashPadSessionMode & MSP_SEC_SA_INTERRUPT_MODE)) {
                delayStat = taskDelay(HoldUp);

                /* JRR-DEBUG */
                SecHandleCompQ(0);
            }

            destAddress = (uchar *)malloc(64);

            callerRefId = (uint)destAddress;

            secParams.associationId = PoloHmacSessionId;
            secParams.nextProtocol = 0;
            /* secParams.sourceAddr0 = hmacVector1; */
            secParams.sourceAddr0 = hmacVector8;
            secParams.size0 = 8;
            secParams.sourceAddr1 = NULL;
            secParams.size1 = 0;
            secParams.destAddr0 = destAddress;
            secParams.destAddr1 = NULL;

            retStatus = MspSecAssocX ( callerRefId,
                                       &secParams,
                                       SecTestAssocXHmacCompFunc);
                
            if (retStatus) {
                printf("Failed on hmac op\n");
                SecTestPrintErrorStatus(retStatus);
            }

            if (!(PoloHmacSessionMode & MSP_SEC_SA_INTERRUPT_MODE)) {
                delayStat = taskDelay(HoldUp);

                /* JRR-DEBUG */
                SecHandleCompQ(0);
            }

            destAddress = (uchar *)malloc(128);

            callerRefId = (uint)destAddress;
    
            secParams.associationId = PoloEspOutSessionId;
            secParams.nextProtocol = 0x06;
            secParams.sourceAddr0 = PSrcData6;
            secParams.size0 = 40;
            secParams.sourceAddr1 = NULL;
            secParams.size1 = 0;
            secParams.destAddr0 = destAddress;
            secParams.destAddr1 = NULL;

            retStatus = MspSecAssocX (callerRefId,
                                      &secParams,
                                      SecTestAssocXEspOutCompFunc);

            if (retStatus) {
                printf("Failed on esp out op\n");
                SecTestPrintErrorStatus(retStatus);
            }

            if (!(PoloEspOutSessionMode & MSP_SEC_SA_INTERRUPT_MODE)) {
                delayStat = taskDelay(HoldUp);

                /* JRR-DEBUG */
                SecHandleCompQ(0);
            }

            destAddress = (uchar *)malloc(128);

            callerRefId = (uint)destAddress;

            secParams.associationId = PoloEspInSessionId;
            secParams.nextProtocol = 0;
            secParams.sourceAddr0 = PSrcData7a;
            secParams.size0 = 64;
            secParams.sourceAddr1 = PSrcData7b;
            secParams.size1 = 20;
            secParams.destAddr0 = destAddress;
            secParams.destAddr1 = NULL;

            retStatus = MspSecAssocX (callerRefId,
                                      &secParams,
                                      SecTestAssocXEspInCompFunc);

            if (retStatus) {
                printf("Failed on esp in op\n");
                SecTestPrintErrorStatus(retStatus);
            }

            if (!(PoloEspInSessionMode & MSP_SEC_SA_INTERRUPT_MODE)) {
                delayStat = taskDelay(100);

                /* JRR-DEBUG */
                SecHandleCompQ(0);
            }
        }

        delayStat = taskDelay(5);

        if (SecTestResultsLoud) {
            printf("\n");
            printf("Total Done:  %d\n",SecTotalXAll * 5);
            printf("Total completed and compared:   %d\n",SecTotalAssocXAllCompares);
            printf("Total completed with comp err:  %d\n",SecTotalAssocXAllErrors);
            printf("\n");
        } else {
            SecStressComplete += SecTotalXAll * 5;
        }

        returnGlobalMemory();

        if (SecTotalAssocXAllErrors)
            noErrors = 0;

        noIters++;
    }
}

void MspSecTestSpawnStress(uint      priority)
{
    if (!priority)
        priority = 80;

	taskSpawn("MspSecTestAssocXAll", priority, 0, 4096 * 2, (FUNCPTR)MspSecTestAssocXAll,
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
}

void MspSecTestSpawnStress2(uint      priority)
{
    if (!priority)
        priority = 80;

	taskSpawn("MspSecTestAssocXTotal", priority, 0, 4096 * 2, (FUNCPTR)MspSecTestAssocXTotal,
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
}

#ifdef SEC_OLD_SESSION

void TempHashTest()
{
    uchar      *tempAddrPtr;
    uint     mode = 0;
    uchar      *destAddr;
    uint     i;

    destAddr = (uchar *)malloc(64);
    /* mode = 0x0001; */
    mode = 0x0002;
    /* MspSecHshHmacStartSession(0,16,hmacKey1,mode); */
    MspSecHshHmacStartSession(0,20,hmacKey8,mode);

    /* MspSecHshHMACSession(0,hmacVector1,destAddr,8); */
    MspSecHshHMACSession(0,hmacVector8,destAddr,8);

    tempAddrPtr = destAddr;
    printf("Got:\n");
    for (i=0;i<20;i++) 
	{
        printf(" 0x%02x,",*tempAddrPtr++);
        if ((i % 4) == 3)
            printf("\n");
    }

    /* tempAddrPtr = hmacResult1; */
    tempAddrPtr = hmacResult8;
    printf("Expected:\n");
    for (i=0;i<20;i++) 
	{
        printf(" 0x%02x,",*tempAddrPtr++);
        if ((i % 4) == 3)
            printf("\n");
    }

    free(destAddr);
}
#endif

extern void PoloSecPolling();

void MspSecTestSpawnPoll()
{
	taskSpawn("PoloSecPolling", 80, 0, 4096, (FUNCPTR)PoloSecPolling,
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
}

void MspSecTestAssocXCryptChain()
{
    uint                     associationId;
    uint                     chainId;
    uint                     callerRefId;
    uchar                      *destAddress;
    uint                     destLoc;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uint                     retStatus;
    uint                     totalErrors = 0;

    callerRefId = 0x93;

    destAddress = (uchar *)malloc(64);

    associationId = PoloCryptFullSessionId;
    chainId = 0;

    retStatus = MspSecAssocBuildChain(&chainId,
                                      PCSrcData1a,
                                      destAddress,
                                      32,
                                      32);

    if (retStatus) {
        printf("Build chain failed\n");
        SecTestPrintErrorStatus(retStatus);
    }

    destLoc = (uint)destAddress;
    destLoc += 32;
    tempAddrPtr = (uchar *)destLoc;

    retStatus = MspSecAssocBuildChain(&chainId,
                                      PCSrcData1b,
                                      tempAddrPtr,
                                      16,
                                      16);

    if (retStatus) {
        printf("Build chain failed\n");
        SecTestPrintErrorStatus(retStatus);
    }

    retStatus = MspSecAssocXChainBlk (associationId,
                                      chainId,
                                      0);

    if (retStatus) {
        printf("Chain op failed\n");
        SecTestPrintErrorStatus(retStatus);
    }

    /* Compare results */
    tempAddrPtr = destAddress;
    tempAddrPtr2 = PCExpData1;
    for (i=0;i<48;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }

    if (SecTestResultsLoud) {
        tempAddrPtr = destAddress;
        printf("Got:\n");
        for (i=0;i<48;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }

        tempAddrPtr = PCExpData1;
        printf("Expected:\n");
        for (i=0;i<48;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    }

    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

void MspSecTestAssocXCryptChain2()
{
    uint                     associationId;
    uint                     chainId;
    uint                     callerRefId;
    uchar                      *destAddress;
    uint                     destLoc;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    STATUS                  delayStat;
    uint                     i;
    uint                     retStatus;
    uint                     totalErrors = 0;

    callerRefId = 0x93;

    destAddress = (uchar *)malloc(64);

    associationId = PoloCryptSessionId;
    chainId = 0;

    retStatus = MspSecAssocBuildChain(&chainId,
                                      SrcData6,
                                      destAddress,
                                      16,
                                      16);

    if (retStatus) {
        printf("Build chain failed\n");
        SecTestPrintErrorStatus(retStatus);
    }

    destLoc = (uint)destAddress;
    destLoc += 16;
    tempAddrPtr = (uchar *)destLoc;

    retStatus = MspSecAssocBuildChain(&chainId,
                                      SrcData7,
                                      tempAddrPtr,
                                      16,
                                      16);

    if (retStatus) {
        printf("Build chain failed\n");
        SecTestPrintErrorStatus(retStatus);
    }

    destLoc = (uint)tempAddrPtr;
    destLoc += 16;
    tempAddrPtr = (uchar *)destLoc;

    retStatus = MspSecAssocBuildChain(&chainId,
                                      SrcData8,
                                      tempAddrPtr,
                                      16,
                                      16);

    if (retStatus) {
        printf("Build chain failed\n");
        SecTestPrintErrorStatus(retStatus);
    }

    retStatus = MspSecAssocXChain (callerRefId,
                                   associationId,
                                   chainId,
                                   0,
                                   SecTestAssocXCompFunc);

    if (retStatus) {
        printf("Chain op failed\n");
        SecTestPrintErrorStatus(retStatus);
    }

    if (!(PoloCryptSessionMode & MSP_SEC_SA_INTERRUPT_MODE)) {
        delayStat = taskDelay(100);

        /* JRR-DEBUG */
        SecHandleCompQ(0);
    }

    delayStat = taskDelay(100);

    /* Compare results */
    tempAddrPtr = destAddress;
    tempAddrPtr2 = ExpData4;
    for (i=0;i<48;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }
#if 0
    tempAddrPtr = destAddress;
    printf("Got:\n");
    for (i=0;i<48;i++) 
	{
        printf(" 0x%02x,",*tempAddrPtr++);
        if ((i % 4) == 3)
            printf("\n");
    }

    tempAddrPtr = ExpData4;
    printf("Expected:\n");
    for (i=0;i<48;i++) 
	{
        printf(" 0x%02x,",*tempAddrPtr++);
        if ((i % 4) == 3)
            printf("\n");
    }
#endif


    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

void MspSecTestAssocXCryptBlk()
{
    msp_sec_assoc_params    secParams;
    uint                     callerRefId;
    uchar                      *destAddress;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uint                     totalErrors = 0;
    uint                     retStatus;

    callerRefId = 0x99;

    destAddress = (uchar *)malloc(64);

    secParams.associationId = PoloCryptSessionId;
    secParams.nextProtocol = 0;
    secParams.sourceAddr0 = PCSrcData1a;
    secParams.size0 = 32;
    secParams.sourceAddr1 = PCSrcData1b;
    secParams.size1 = 16;
    secParams.destAddr0 = destAddress;
    secParams.destAddr1 = NULL;

    retStatus = MspSecAssocXBlk (&secParams);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);
    
    /* Compare results */
    tempAddrPtr = destAddress;
    tempAddrPtr2 = PCExpData1;
    for (i=0;i<48;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error at %d\n",i);
            totalErrors++;
            break;
        }
    }
#if 0
    tempAddrPtr = destAddress;
    printf("Got:\n");
    for (i=0;i<48;i++) 
	{
        printf(" 0x%02x,",*tempAddrPtr++);
        if ((i % 4) == 3)
            printf("\n");
    }

    tempAddrPtr = PCExpData1;
    printf("Expected:\n");
    for (i=0;i<48;i++) 
	{
        printf(" 0x%02x,",*tempAddrPtr++);
        if ((i % 4) == 3)
            printf("\n");
    }
#endif


    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

void MspSecTestEspInInPlaceAssocStart()
{
	uchar                          *keyValue;
	msp_sec_des_iv	            IV;
    uchar                          *hashKeysAddr;
    uint                         hashKeyLength;
    uint                         retStatus;
    uint                         *tempLongPtr;

    keyValue = (uchar *)malloc(24);

    tempLongPtr = (uint *)keyValue;

    *tempLongPtr++ = 0x61626364;
    *tempLongPtr++ = 0x61626364; 
    IV.IVHigh = 0x0cc3387d;
    IV.IVLow = 0x732d5a34;

    hashKeysAddr = PASecKey8;
    hashKeyLength = 20;

    retStatus = MspSecAssocStart(&PoloEspInInPlaceSessionId,
                                 PoloEspInInPlaceSessionMode,
                                 keyValue,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 NULL,
                                 (uchar *)&IV,
                                 0);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);
    
    printf("Return value:  %d\n",retStatus);
    printf("PoloEspInInPlaceSessionId:  0x%x\n",PoloEspInInPlaceSessionId);

    free(keyValue);

    SecShowSA(PoloEspInInPlaceSessionId);
}

void MspSecTestAssocXEspInInPlace()
{
    msp_sec_assoc_params    secParams;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uchar                      *samplePacket;
    uint                     srcLoc;
    uint                     src2Loc;
    uint                     destLoc;
    uint                     len;
    uint                     retStatus;
    uint                     totalErrors = 0;

    samplePacket = (uchar *)malloc(192);
    tempAddrPtr = samplePacket;
    len = 150;

    /* MAC DEST (0) */
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x02;
    *tempAddrPtr++ = 0xD8;
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x01;

    /* MAC SOURCE (6) */
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x02;
    *tempAddrPtr++ = 0xD8;
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0xF1;

    /* CRC (12) */
    *tempAddrPtr++ = 0x08;
    *tempAddrPtr++ = 0x00;

    /* IP DATAGRAM START */
    /* VER/HDR LEN (14) */
    *tempAddrPtr++ = 0x45;

    /* TOS  (15) */
    *tempAddrPtr++ = 0x00;

    /* TOTAL IP LENGTH  (16) */
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x88;

    /* DATAGRAM ID (18) */
    *tempAddrPtr++ = 0x5E;
    *tempAddrPtr++ = 0x65;

    /* FLAGS/FRAG OFFSET (20) */
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x00;

    /* TIME TO LIVE (22) */
    *tempAddrPtr++ = 0x1E;

    /* PROTOCOL (23) */
    *tempAddrPtr++ = 0x32;

    /* HEADER CHECKSUM (24) */
    *tempAddrPtr++ = 0xB8;
    *tempAddrPtr++ = 0x8B;

    /* SOURCE IP ADDR (26) */
    *tempAddrPtr++ = 0xC0;
    *tempAddrPtr++ = 0xA8;
    *tempAddrPtr++ = 0x02;
    *tempAddrPtr++ = 0x02;

    /* DEST IP ADDR  (30) */
    *tempAddrPtr++ = 0xC0;
    *tempAddrPtr++ = 0xA8;
    *tempAddrPtr++ = 0x02;
    *tempAddrPtr++ = 0x01;

    /* SPI (34) */
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x0F;
    *tempAddrPtr++ = 0xA0;

    /* SEQ NUMBER (38) */
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0x0F;

    /* IV (42) */
    *tempAddrPtr++ = 0x2D;
    *tempAddrPtr++ = 0xE7;
    *tempAddrPtr++ = 0x58;
    *tempAddrPtr++ = 0x88;
    *tempAddrPtr++ = 0xE2;
    *tempAddrPtr++ = 0x88;
    *tempAddrPtr++ = 0xCA;
    *tempAddrPtr++ = 0x72;

    /* ENCRYPTED PAYLOAD (50) */

    *tempAddrPtr++ = 0x42;
    *tempAddrPtr++ = 0x8E;
    *tempAddrPtr++ = 0x4B;
    *tempAddrPtr++ = 0xD4;
    *tempAddrPtr++ = 0xBF;
    *tempAddrPtr++ = 0xEA;
    *tempAddrPtr++ = 0x65;
    *tempAddrPtr++ = 0x60;
    *tempAddrPtr++ = 0xE9;
    *tempAddrPtr++ = 0xA8;
    *tempAddrPtr++ = 0x3B;
    *tempAddrPtr++ = 0x17;
    *tempAddrPtr++ = 0xF5;
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0xB8;
    *tempAddrPtr++ = 0x21;
    *tempAddrPtr++ = 0xBE;
    *tempAddrPtr++ = 0x12;
    *tempAddrPtr++ = 0x33;
    *tempAddrPtr++ = 0xFB;
    *tempAddrPtr++ = 0x5A;
    *tempAddrPtr++ = 0xCC;
    *tempAddrPtr++ = 0xB4;
    *tempAddrPtr++ = 0xB2;
    *tempAddrPtr++ = 0xAB;
    *tempAddrPtr++ = 0xBE;
    *tempAddrPtr++ = 0x3E;
    *tempAddrPtr++ = 0xD6;
    *tempAddrPtr++ = 0xF9;
    *tempAddrPtr++ = 0x2C;
    *tempAddrPtr++ = 0xA2;
    *tempAddrPtr++ = 0xAA;
    *tempAddrPtr++ = 0xC9;
    *tempAddrPtr++ = 0x25;
    *tempAddrPtr++ = 0xAD;
    *tempAddrPtr++ = 0x74;
    *tempAddrPtr++ = 0xE0;
    *tempAddrPtr++ = 0xB6;
    *tempAddrPtr++ = 0x15;
    *tempAddrPtr++ = 0x66;
    *tempAddrPtr++ = 0xCC;
    *tempAddrPtr++ = 0x09;
    *tempAddrPtr++ = 0x9F;
    *tempAddrPtr++ = 0x17;
    *tempAddrPtr++ = 0x67;
    *tempAddrPtr++ = 0x12;
    *tempAddrPtr++ = 0x27;
    *tempAddrPtr++ = 0xCE;
    *tempAddrPtr++ = 0x65;
    *tempAddrPtr++ = 0xE2;
    *tempAddrPtr++ = 0x6D;
    *tempAddrPtr++ = 0xF8;
    *tempAddrPtr++ = 0x4C;
    *tempAddrPtr++ = 0x2E;
    *tempAddrPtr++ = 0x7C;
    *tempAddrPtr++ = 0x01;
    *tempAddrPtr++ = 0x0E;
    *tempAddrPtr++ = 0xC4;
    *tempAddrPtr++ = 0x00;
    *tempAddrPtr++ = 0xB0;
    *tempAddrPtr++ = 0x7A;
    *tempAddrPtr++ = 0x93;
    *tempAddrPtr++ = 0x53;
    *tempAddrPtr++ = 0x75;
    *tempAddrPtr++ = 0xB0;
    *tempAddrPtr++ = 0x22;
    *tempAddrPtr++ = 0x36;
    *tempAddrPtr++ = 0x8B;
    *tempAddrPtr++ = 0x6B;
    *tempAddrPtr++ = 0x65;
    *tempAddrPtr++ = 0x60;
    *tempAddrPtr++ = 0x42;
    *tempAddrPtr++ = 0x12;
    *tempAddrPtr++ = 0xD4;
    *tempAddrPtr++ = 0xBE;
    *tempAddrPtr++ = 0x76;
    *tempAddrPtr++ = 0xEF;
    *tempAddrPtr++ = 0xB0;
    *tempAddrPtr++ = 0xE9;
    *tempAddrPtr++ = 0x2C;
    *tempAddrPtr++ = 0x6A;
    *tempAddrPtr++ = 0x76;
    *tempAddrPtr++ = 0x0A;
    *tempAddrPtr++ = 0x03;
    *tempAddrPtr++ = 0x1F;
    *tempAddrPtr++ = 0x1F;
    *tempAddrPtr++ = 0x26;
    *tempAddrPtr++ = 0x62;

    /* ICV (138) */
    *tempAddrPtr++ = 0xDC;
    *tempAddrPtr++ = 0x82;
    *tempAddrPtr++ = 0x13;
    *tempAddrPtr++ = 0x03;
    *tempAddrPtr++ = 0x45;
    *tempAddrPtr++ = 0x40;
    *tempAddrPtr++ = 0xB9;
    *tempAddrPtr++ = 0xB2;
    *tempAddrPtr++ = 0x6F;
    *tempAddrPtr++ = 0x92;
    *tempAddrPtr++ = 0x98;
    *tempAddrPtr++ = 0xC1;

    srcLoc = (uint)samplePacket;
    destLoc = srcLoc + 14;
    src2Loc = srcLoc + len - 12;
    srcLoc += 34;

    secParams.associationId = PoloEspInInPlaceSessionId;
    secParams.nextProtocol = 0;
    secParams.sourceAddr0 = (uchar *)srcLoc;
    secParams.size0 = len - 46;
    secParams.sourceAddr1 = (uchar *)src2Loc;
    secParams.size1 = 12;
    secParams.destAddr0 = (uchar *)destLoc;
    secParams.destAddr1 = NULL;

    retStatus = MspSecAssocXBlk(&secParams);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);
    
    /* Compare results */
    tempAddrPtr = (uchar *)samplePacket;
    tempAddrPtr2 = PExpData7;
    for (i=0;i<len-52;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }
#if 1
    tempAddrPtr = (uchar *)samplePacket;
    printf("Got:\n");
    for (i=0;i<len-36;i++) 
	{
        printf(" 0x%02x,",*tempAddrPtr++);
        if ((i % 4) == 3)
            printf("\n");
    }
#endif

    if (!totalErrors) 
        printf("Results compared!\n");

    free(samplePacket);
}

uint     SecEIAssocId = 0;
uint     SecEOAssocId = 0;
uint     SecEspRx = 0;
uint     SecEspTx = 0;
uint     SecAHAssocId = 0;
uint     SecAHSeqNum = 0;
uint     SecAHRx = 0;
uint     SecAHTx = 0;

/* Globals for ESP Processing */
uint     SecFilterEspInStarted = 0;
uint     SecFilterEspOutStarted = 0;
uint     SecFilterAhStarted = 0;
uint     SecEspIcvLen;
uint     SecEspIvLen;
uint     SecEspEspHdrLen = 8;
uint     SecEspEthHdrLen = 14;
uint     SecEspIpHdrLen = 20;
uint     SecEspEspTrlrLen = 2;
uint     SecEspBlockLen;

uchar  SecEspCKey [] = { 0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                      0x64, 0x63, 0x62, 0x61, 0x64, 0x63, 0x62, 0x61,
                      0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                      0x64, 0x63, 0x62, 0x61, 0x64, 0x63, 0x62, 0x61 };

uchar  SecEspHmacKey [] = { 0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                         0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                         0x61, 0x62, 0x63, 0x64 };

uchar  SecEspEspHdr [] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01};

uchar  SecEspCIv [] = { 0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                     0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64 };

uchar  SecEspIncSpi [] = {0x00, 0x00, 0x00, 0x00 };

uchar  SecEspLocalNet[4];
uint SecEspLocalNetNum;
uchar  SecEspLocalNetName[24];
uchar  SecEspRemoteNet[4];
uint SecEspRemoteNetNum;
uchar  SecEspRemoteNetName[24];
uchar  SecEspLocGateAddr[4];
uint SecEspLocGateAddrNum;
uchar  SecEspLocGateAddrName[24];
uchar  SecEspPeerGateAddr[4];
uint SecEspPeerGateAddrNum;
uchar  SecEspPeerGateAddrName[24];
uint SecEspIncSpiNum = 0;
uint SecEspOutSpiNum = 0;
uint SecEspCryptAlg = 0;
uint SecEspHashAlg = 0;

uchar  SecAhLocalNet[4];
uint SecAhLocalNetNum;
uchar  SecAhLocalNetName[24];
uchar  SecAhRemoteNet[4];
uint SecAhRemoteNetNum;
uchar  SecAhRemoteNetName[24];
uchar  SecAhLocGateAddr[4];
uint SecAhLocGateAddrNum;
uchar  SecAhLocGateAddrName[24];
uchar  SecAhPeerGateAddr[4];
uint SecAhPeerGateAddrNum;
uchar  SecAhPeerGateAddrName[24];
uint SecAhIncSpiNum = 0;
uint SecAhOutSpiNum = 0;
uint SecAhHashAlg = 0;

/* ESP testing-  Eth/IP/ESP packet struct */
typedef struct {
    uchar      EtherDest[6];
    uchar      EtherSource[6];
    ushort     EtherType;
    uchar      IpVerHLength;
    uchar      IpTypeOfService;
    ushort     IpTotalLength;
    ushort     IpDataGramId;
    ushort     IpFlagsFragOff;
    uchar      IpTimeToLive;
    uchar      IpProtocol;
    ushort     IpHeaderChecksum;
    uint     IpSourceAddr;
    uint     IpDestAddr;
    uint     EspSPI;
    uint     EspSeqNum;
} __attribute__ ((__packed__)) SecEthIpEspHdr;

/* AH testing-  Eth/IP/AH packet struct */
typedef struct {
    uchar      EtherDest[6];
    uchar      EtherSource[6];
    ushort     EtherType;
    uchar      IpVerHLength;
    uchar      IpTypeOfService;
    ushort     IpTotalLength;
    ushort     IpDataGramId;
    ushort     IpFlagsFragOff;
    uchar      IpTimeToLive;
    uchar      IpProtocol;
    ushort     IpHeaderChecksum;
    uint     IpSourceAddr;
    uint     IpDestAddr;
    uchar      AhNextHeader;
    uchar      AhHdrLength;
    uchar      AhReserved1;
    uchar      AhReserved2;
    uint     AhSPI;
    uint     AhSeqNum;
    uchar      AhICV[12];
} __attribute__ ((__packed__)) SecEthIpAhHdr;

void MspSecTestEspOutProcess(M_BLK *pMblk)
{
    msp_sec_assoc_params    secParams;
    uint                     src0Size;
    uint                     destLoc;
    uint                     padLen;
    uint                     nextProtocol;
    uint                     len;
    ushort                     hdrCheckSum = 0;
    uchar                      *ipByteToCh = NULL;
    uint                     i;
    uint                     ipLength;
    uint                     tempLength;
    uint                     retStatus;
    uint                     notInTheVpn = 0;
    uint                     src0Loc = (uint)pMblk->mBlkHdr.mData;
    SecEthIpEspHdr          *pEthIpEsp =
                                (SecEthIpEspHdr  *)pMblk->mBlkHdr.mData;;

    if (!SecFilterEspOutStarted)
        return;

    /* Mask the source and dest addresses and compare to    */
    /* see if they are both within the protected networks   */
    if ((pEthIpEsp->IpSourceAddr & 0xFFFFFF00) != SecEspLocalNetNum)
        notInTheVpn = 1;

    if ((pEthIpEsp->IpDestAddr & 0xFFFFFF00) != SecEspRemoteNetNum)
        notInTheVpn = 1;

    if (!notInTheVpn) {
        SecEspTx++;
        if (SecTestResultsLoud)
        {
		    unsigned char *p_c;
		    int k;
     
		    printf ("AFTER TX mLen = %d\n", pMblk->mBlkHdr.mLen);
    
		    p_c = pMblk->mBlkHdr.mData;
		    for (k = 0; k < pMblk->mBlkHdr.mLen; k=k+6)
		    {
			    printf ("%02X:%02X:%02X:%02X:%02X:%02X\n",
				        p_c[k+0], p_c[k+1], p_c[k+2],
				        p_c[k+3], p_c[k+4], p_c[k+5]);
		    }
	    }
    
    
        len = pMblk->mBlkHdr.mLen;
    
        src0Loc += SecEspEthHdrLen; 
        destLoc = src0Loc + SecEspIpHdrLen;
        src0Size = len - SecEspEthHdrLen;
        padLen = SecEspBlockLen - ((src0Size + SecEspEspTrlrLen) % SecEspBlockLen);
	    if (SecTestResultsLoud)
            printf("Pad length is %d\n",padLen);
        nextProtocol = 0x04;
	    if (SecTestResultsLoud)
            printf("Next Protocol is 0x%x\n",nextProtocol);
    
        secParams.associationId = SecEOAssocId;
        secParams.nextProtocol = nextProtocol;
        secParams.sourceAddr0 = (uchar *)src0Loc;
        secParams.size0 = src0Size;
        secParams.sourceAddr1 = NULL;
        secParams.size1 = 0;
        secParams.destAddr0 = (uchar *)destLoc;
        secParams.destAddr1 = NULL;
         
        retStatus = MspSecAssocXBlk(&secParams);
    
        if (retStatus) {
            printf("Esp out process error\n");
            SecTestPrintErrorStatus(retStatus);
        }
            
        len += SecEspIpHdrLen +
               SecEspEspHdrLen +
               SecEspIvLen +
               SecEspEspTrlrLen +
               padLen +
               SecEspIcvLen;
    
		pMblk->mBlkHdr.mLen	= pMblk->mBlkPktHdr.len = len;
    
        /* Overwrite ip length field */
        ipLength = len - SecEspEthHdrLen;
	    if (SecTestResultsLoud)
            printf("Ip length is %d\n",ipLength);

        pEthIpEsp->IpTotalLength = (ushort)ipLength;

        /* Overwrite Time to Live field */
        pEthIpEsp->IpTimeToLive = 0x1E;

        /* Overwrite protocol field */
        pEthIpEsp->IpProtocol = 0x32;
  
        /* Overwrite checksum with zero for calc */ 
        pEthIpEsp->IpHeaderChecksum = 0x0000;
    
        /* Overwrite ip src field with  */
        /* source gateway address       */
        pEthIpEsp->IpSourceAddr = SecEspLocGateAddrNum;

        /* Overwrite ip dest field with */
        /* dest gateway address         */
        pEthIpEsp->IpDestAddr = SecEspPeerGateAddrNum;

        /* Calculate checksum */
        ipByteToCh = (uchar *)src0Loc;
    
        for (i=0;i<10;i++) {
            tempLength = (uint)*ipByteToCh++;
            tempLength <<= 8;
            tempLength += (uint)*ipByteToCh++;
            hdrCheckSum += tempLength;
        }
   
        /* Add 2-  but I don't know why!!! */
        hdrCheckSum += 2;

        hdrCheckSum ^= 0xFFFF;
	    if (SecTestResultsLoud)
            printf("Header checksum is 0x%x\n",hdrCheckSum);
    
        /* Overwrite header checksum field */
        pEthIpEsp->IpHeaderChecksum = (ushort)hdrCheckSum;

	    if (SecTestResultsLoud)
	    {
		    unsigned char *p_c;
		    int k;
     
            printf("After Esp out processing mLen = %d:\n", pMblk->mBlkHdr.mLen);
		    p_c = pMblk->mBlkHdr.mData;
		    for (k = 0; k < pMblk->mBlkHdr.mLen; k=k+6)
		    {
			    printf ("%02X:%02X:%02X:%02X:%02X:%02X\n",
				        p_c[k+0], p_c[k+1], p_c[k+2],
				        p_c[k+3], p_c[k+4], p_c[k+5]);
		    }
	    }
    }
}

void MspSecTestEspInProcess(M_BLK *pMblk)
{
    uint                     src0Size;
    uint                     destLoc;
    uint                     padLoc;
    msp_sec_assoc_params    secParams;
    uint                     src2Loc;
    uchar                      *pPadLen;
    uint                     len;
    uint                     retStatus;
    uint                     notInTheVpn = 0;
    uint                     src0Loc = (uint)pMblk->mBlkHdr.mData;
    SecEthIpEspHdr          *pEthIpEsp =
                                (SecEthIpEspHdr *)pMblk->mBlkHdr.mData;;

    if (!SecFilterEspInStarted)
        return;

    /* Check if protocol is esp and spi matches */
    if (pEthIpEsp->IpProtocol != 0x32) {
        notInTheVpn = 1;
    } else {
        if (pEthIpEsp->EspSPI != SecEspIncSpiNum)
            notInTheVpn = 1;
    }

    if (!notInTheVpn)
    {
		if (SecTestResultsLoud)
		{
		    unsigned char *p_c;
			int k;
        
			printf ("RX DEBUG mLen = %d\n", pMblk->mBlkHdr.mLen);

			p_c = pMblk->mBlkHdr.mData;
			for (k = 0; k < pMblk->mBlkHdr.mLen; k=k+6)
			{
			    printf ("%02X:%02X:%02X:%02X:%02X:%02X\n",
			            p_c[k+0], p_c[k+1], p_c[k+2],
			            p_c[k+3], p_c[k+4], p_c[k+5]);
			}
		}

        /* Pass packet through ESP processing   */
        /* before mux receiving it.             */

        SecEspRx++;

        len = pMblk->mBlkHdr.mLen;

		if (SecTestResultsLoud)
            printf("Length before EspIn op:  %d\n",len);

        destLoc = src0Loc + SecEspEthHdrLen; 

        if (SecEspIcvLen)
            src2Loc = src0Loc + len - SecEspIcvLen;
        else
            src2Loc = 0;

        src0Loc += SecEspEthHdrLen + SecEspIpHdrLen;
        src0Size = len - SecEspEthHdrLen - SecEspIpHdrLen - SecEspIcvLen;

		if (SecTestResultsLoud)
            printf("Src0 size: %d\n",src0Size);

        secParams.associationId = SecEIAssocId;
        secParams.nextProtocol = 0;
        secParams.sourceAddr0 = (uchar *)src0Loc;
        secParams.size0 = src0Size;
        secParams.sourceAddr1 = (uchar *)src2Loc;
        secParams.size1 = SecEspIcvLen;
        secParams.destAddr0 = (uchar *)destLoc;
        secParams.destAddr1 = NULL;

        retStatus = MspSecAssocXBlk(&secParams);

        if (retStatus) {
            printf("Esp in process error\n");
            SecTestPrintErrorStatus(retStatus);
        }
            
        len -= SecEspIpHdrLen;
        len -= SecEspEspHdrLen;
        len -= SecEspIvLen;
        len -= SecEspIcvLen;

        padLoc = destLoc;
        padLoc += src0Size;
        padLoc -= SecEspIvLen;
        padLoc -= SecEspEspHdrLen;
        padLoc -= 2;        /* 2nd to last byte */
        pPadLen = (uchar *)padLoc;

        len -= SecEspEspTrlrLen;           /* esp trailer */
        len -= *pPadLen;    /* padding len */

		pMblk->mBlkHdr.mLen	= pMblk->mBlkPktHdr.len = len;
		if (SecTestResultsLoud)
		{
	        unsigned char *p_c;
			int k;
     
			printf ("After Esp in processing mLen = %d\n", pMblk->mBlkHdr.mLen);
     
			p_c = pMblk->mBlkHdr.mData;
			for (k = 0; k < pMblk->mBlkHdr.mLen; k=k+6)
			{
		        printf ("%02X:%02X:%02X:%02X:%02X:%02X\n",
				        p_c[k+0], p_c[k+1], p_c[k+2],
				        p_c[k+3], p_c[k+4], p_c[k+5]);
			}
		}
    } else {
		if (SecTestResultsLoud)
            printf("Non-esp packet rx\n");
    }
}

void MspSecTestAhOutProcess(M_BLK *pMblk)
{
    msp_sec_assoc_params    secParams;
    uint                     src0Size;
    uint                     destLoc;
    uint                     len;
    ushort                     hdrCheckSum = 0;
    uchar                      *ipByteToCh = NULL;
    uint                     i;
    uint                     tempLength;
    uint                     preSrc0Loc;
    uint                     retStatus;
    uint                     notInTheVpn = 0;
    uint                     src0Loc = (uint)pMblk->mBlkHdr.mData;
    SecEthIpAhHdr           *pEthIpAh =
                                (SecEthIpAhHdr  *)pMblk->mBlkHdr.mData;
    SecEthIpAhHdr           *pNewEthIpAh;

    if (!SecFilterAhStarted)
        return;

    len = pMblk->mBlkHdr.mLen;

    /* Mask the source and dest addresses and compare to    */
    /* see if they are both within the protected networks   */
    if ((pEthIpAh->IpSourceAddr & 0xFFFFFF00) != SecAhLocalNetNum) {
        printf("source not supposed to be protected: 0x%x\n",pEthIpAh->IpSourceAddr);
        notInTheVpn = 1;
    }

    if ((pEthIpAh->IpDestAddr & 0xFFFFFF00) != SecAhRemoteNetNum) {
        printf("dest not supposed to be protected: 0x%x\n",pEthIpAh->IpDestAddr);
        notInTheVpn = 1;
    }


    if (!notInTheVpn) {
        SecAHTx++;

        preSrc0Loc = src0Loc - 44;
        pNewEthIpAh = (SecEthIpAhHdr *)preSrc0Loc;

        /* Copy ethernet header */
        for (i=0;i<6;i++)
            pNewEthIpAh->EtherDest[i] = pEthIpAh->EtherDest[i];

        for (i=0;i<6;i++)
            pNewEthIpAh->EtherSource[i] = pEthIpAh->EtherSource[i];
        
        pNewEthIpAh->EtherType = pEthIpAh->EtherType;

        /* Set ver/len */
        pNewEthIpAh->IpVerHLength = 0x45;

        /* Zero out TOS */
        pNewEthIpAh->IpTypeOfService = 0x00;

        /* Calculate new ip length */
        pNewEthIpAh->IpTotalLength = len - SecEspEthHdrLen + 44;

        /* Copy datagram id */
        pNewEthIpAh->IpDataGramId = pEthIpAh->IpDataGramId;

        /* Zero out Flags/Frag offset */
        pNewEthIpAh->IpFlagsFragOff = 0x0000;
           
        /* Zero out TTL */
        pNewEthIpAh->IpTimeToLive = 0x00;

        /* Set protocol to AH */
        pNewEthIpAh->IpProtocol = 0x33;

        /* Zero out Header Checksum */
        pNewEthIpAh->IpHeaderChecksum = 0x0000;

        pNewEthIpAh->IpSourceAddr = SecAhLocGateAddrNum;

        pNewEthIpAh->IpDestAddr = SecAhPeerGateAddrNum;

        /* AH Header */

        /* Set Next header to ip */
        pNewEthIpAh->AhNextHeader = 0x4; 

        /* Set length of AH hdr to 4 */
        pNewEthIpAh->AhHdrLength = 0x4; 

        /* Zero out reserved fields */
        pNewEthIpAh->AhReserved1 = 0x0;
        pNewEthIpAh->AhReserved2 = 0x0;

        /* Set SPI to Outgoing SPI */
        pNewEthIpAh->AhSPI = SecAhOutSpiNum;

        /* Increment Seq # and set */
        SecAHSeqNum++;

        pNewEthIpAh->AhSeqNum = SecAHSeqNum;

        /* Zero out ICV field */
        for (i=0;i<12;i++)
            pNewEthIpAh->AhICV[i] = 0x00;

        len += 44;
        src0Size = len - 14;

        /* Put dest at offset ethHdr + ipHdr + 12 for AH */
        destLoc = preSrc0Loc + 46;

        secParams.associationId = SecAHAssocId;
        secParams.nextProtocol = 0;
        secParams.sourceAddr0 = (uchar *)preSrc0Loc + 14;
        secParams.size0 = src0Size;
        secParams.sourceAddr1 = NULL;
        secParams.size1 = 0;
        secParams.destAddr0 = (uchar *)destLoc;
        secParams.destAddr1 = NULL;
         
        retStatus = MspSecAssocXBlk(&secParams);

        if (retStatus) {
            printf("AH out process error\n");
            SecTestPrintErrorStatus(retStatus);
        }
            
        /* Copy TOS */
        pNewEthIpAh->IpTypeOfService = pEthIpAh->IpTypeOfService;

        /* Copy Flags/Frag offset */
        pNewEthIpAh->IpFlagsFragOff = pEthIpAh->IpFlagsFragOff;

        /* Copy TTL */
        pNewEthIpAh->IpTimeToLive = pEthIpAh->IpTimeToLive;

        /* Write header checksum field */
        ipByteToCh = (uchar *)preSrc0Loc + 14;
        hdrCheckSum = 0;
        for (i=0;i<10;i++) {
            tempLength = (uint)*ipByteToCh++;
            tempLength <<= 8;
            tempLength += (uint)*ipByteToCh++;
            hdrCheckSum += tempLength;
        }
   
        /* Add 2-  but I don't know why!!! */
        hdrCheckSum += 2;

        hdrCheckSum ^= 0xFFFF;
        pNewEthIpAh->IpHeaderChecksum = hdrCheckSum;

		pMblk->mBlkHdr.mLen	= pMblk->mBlkPktHdr.len = len;
        pMblk->mBlkHdr.mData = (uchar *)preSrc0Loc;

	    if (SecTestResultsLoud)
	    {
		    unsigned char *p_c;
		    int k;
    
            printf("After Ah out processing mLen = %d:\n", pMblk->mBlkHdr.mLen);
		    p_c = pMblk->mBlkHdr.mData;
		    for (k = 0; k < pMblk->mBlkHdr.mLen; k=k+6)
		    {
			    printf ("%02X:%02X:%02X:%02X:%02X:%02X\n",
				        p_c[k+0], p_c[k+1], p_c[k+2],
				        p_c[k+3], p_c[k+4], p_c[k+5]);
		    }
	    }
    }
}

void MspSecTestAhInProcess(M_BLK *pMblk)
{
    uint                     src0Size;
    msp_sec_assoc_params    secParams;
    uint                     i;
    uint                     retStatus;
    uchar                      icvAddr[12];
    uchar                      calcIcv[12];
    SecEthIpAhHdr           *pNewEthIpAh;
    uint                     src0Loc = (uint)pMblk->mBlkHdr.mData;
    SecEthIpAhHdr           *pEthIpAh =
                                (SecEthIpAhHdr  *)pMblk->mBlkHdr.mData;
    uint                     notInTheVpn = 0;

    if (!SecFilterAhStarted)
        return;

    /* Check if protocol is ah and spi matches */
    if (pEthIpAh->IpProtocol != 0x33) {
        printf("Wrong protocol:  0x%x\n",(uint)pEthIpAh->IpProtocol);
        notInTheVpn = 1;
    } else {
        if (pEthIpAh->AhSPI != SecAhIncSpiNum) {
            printf("Wrong SPI:  0x%x\n",(uint)pEthIpAh->AhSPI);
            notInTheVpn = 1;
        }
    }

    if (!notInTheVpn)
    {
		if (SecTestResultsLoud)
		{
		    unsigned char *p_c;
			int k;

			printf ("Before AH In processing mLen = %d\n", pMblk->mBlkHdr.mLen);

			p_c = pMblk->mBlkHdr.mData;
			for (k = 0; k < pMblk->mBlkHdr.mLen; k=k+6)
			{
		        printf ("%02X:%02X:%02X:%02X:%02X:%02X\n",
					    p_c[k+0], p_c[k+1], p_c[k+2],
					    p_c[k+3], p_c[k+4], p_c[k+5]);
			}
		}

        SecAHRx++;

        src0Size = pMblk->mBlkHdr.mLen - 14;

        pEthIpAh->IpTypeOfService = 0x00;
        pEthIpAh->IpFlagsFragOff = 0x0000;
        pEthIpAh->IpTimeToLive = 0x00;
        pEthIpAh->IpHeaderChecksum = 0x0000;

        /* Copy ICV */
        for (i=0;i<12;i++)
            icvAddr[i] = pEthIpAh->AhICV[i];

        /* Zero out icv location */
        for (i=0;i<12;i++)
            pEthIpAh->AhICV[i] = 0x00;

        secParams.associationId = SecAHAssocId;
        secParams.nextProtocol = 0;
        secParams.sourceAddr0 = (uchar *)src0Loc + 14;
        secParams.size0 = src0Size;
        secParams.sourceAddr1 = NULL;
        secParams.size1 = 0;
        secParams.destAddr0 = calcIcv;
        secParams.destAddr1 = NULL;
        
        retStatus = MspSecAssocXBlk(&secParams);

        if (retStatus) {
            printf("AH in process error\n");
            SecTestPrintErrorStatus(retStatus);
        }

        for (i=0;i<12;i++) {
            if (calcIcv[i] != icvAddr[i]) {
                printf("ICV doesn't match\n");
                break;
            }
        }

        /* There are 20 bytes of IP header and  */
        /* 24 bytes of AH header to throw out   */

        pMblk->mBlkHdr.mData = (uchar *)src0Loc + 44;
        pMblk->mBlkHdr.mLen -= 44;
		pMblk->mBlkPktHdr.len = pMblk->mBlkHdr.mLen; 

        /* Copy ethernet header to precede tunneled */
        /* ip header and packet                     */
        pNewEthIpAh = (SecEthIpAhHdr *)src0Loc + 44;
        for (i=0;i<6;i++)
            pNewEthIpAh->EtherDest[i] = pEthIpAh->EtherDest[i];

        for (i=0;i<6;i++)
            pNewEthIpAh->EtherSource[i] = pEthIpAh->EtherSource[i];

        pNewEthIpAh->EtherType = pEthIpAh->EtherType;

		if (SecTestResultsLoud)
		{
		    unsigned char *p_c;
			int k;

			printf ("After AH In processing mLen = %d\n", pMblk->mBlkHdr.mLen);

			p_c = pMblk->mBlkHdr.mData;
			for (k = 0; k < pMblk->mBlkHdr.mLen; k=k+6)
			{
			    printf ("%02X:%02X:%02X:%02X:%02X:%02X\n",
					    p_c[k+0], p_c[k+1], p_c[k+2],
					    p_c[k+3], p_c[k+4], p_c[k+5]);
			}
		}
    }

}

void MspSecTestSetupEIAssoc()
{
	uchar                          *keyValue;
    uchar                          *hashKeysAddr;
    uint                         retStatus;
    uint                         sessionMode;
    uint                         hashKeyLength = 0;
    char                        line[20];
    uint                         spi = 0;
    uint                         i;

    if (!SecEspCryptAlg || !SecEspHashAlg) {
        printf("  No crypt algorithm specified in Setup Esp Incoming\n");
        return;
    }

    sessionMode = MSP_SEC_SA_ENG_MODE_ESP_IN |
                  MSP_SEC_SA_USE_CHAINING_VARS |
                  MSP_SEC_SA_DES_KEY_1_DECRYPT |
                  MSP_SEC_SA_DES_KEY_3_DECRYPT |
                  MSP_SEC_SA_CRYPT_BLK_CBC_DEC |
                  MSP_SEC_SA_POLLING_MODE;

    switch (SecEspCryptAlg)
    {
        case 1:
            sessionMode |= MSP_SEC_SA_CRYPT_ALG_DES;
            SecEspIvLen = 8;
            SecEspBlockLen = 8;
            break;
        case 2:
            sessionMode |= MSP_SEC_SA_CRYPT_ALG_3_DES;
            SecEspIvLen = 8;
            SecEspBlockLen = 8;
            break;
        case 3:
            sessionMode |= MSP_SEC_SA_CRYPT_ALG_AES_128;
            SecEspIvLen = 16;
            SecEspBlockLen = 16;
            break;
        case 4:
            sessionMode |= MSP_SEC_SA_CRYPT_ALG_AES_192;
            SecEspIvLen = 16;
            SecEspBlockLen = 16;
            break;
        case 5:
            sessionMode |= MSP_SEC_SA_CRYPT_ALG_AES_256;
            SecEspIvLen = 16;
            SecEspBlockLen = 16;
            break;
        default:
            printf("Bad crypt mode\n");
            return;
            break;
    }
            
    switch (SecEspHashAlg)
    {
        case 1:
            sessionMode |= MSP_SEC_SA_ESP_CMP_ICV |
                           MSP_SEC_SA_HASH_ALG_MD5_96;
            SecEspIcvLen = 12;
            hashKeyLength = 16;
            break;
        case 2:
            sessionMode |= MSP_SEC_SA_ESP_CMP_ICV |
                           MSP_SEC_SA_HASH_ALG_SHA1_96;
            SecEspIcvLen = 12;
            hashKeyLength = 20;
            break;
        case 3:
            sessionMode |= MSP_SEC_SA_HASH_ALG_NULL;
            SecEspIcvLen = 0;
            break;
        default:
            printf("Bad auth mode\n");
            return;
            break;
    }
            
    keyValue = SecEspCKey;

    hashKeysAddr = SecEspHmacKey;

    if (SecFilterEspInStarted)
        MspSecAssocFree(SecEIAssocId);

    retStatus = MspSecAssocStart(&SecEIAssocId,
                                 sessionMode,
                                 keyValue,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 NULL,
                                 SecEspCIv,
                                 0);

    if (retStatus) {
        printf("ESP in assoc start error\n");
        SecTestPrintErrorStatus(retStatus);
    }

    if (SecTestResultsLoud)
        SecShowSA(SecEIAssocId);

    printf("\n");
    printf("Enter incoming Sec Parameter Index in decimal : ");
    if (SecFilterEspInStarted)
        printf("\n < hit return to keep %d > : ",SecEspIncSpiNum);

    fioRdString (STD_IN, line, sizeof (line));

    sscanf(line,"%d", &spi);

    if (spi) {
        SecEspIncSpiNum = spi;
        for (i=4;i>0;i--) { 
            SecEspIncSpi[i-1] = (uchar)(spi & 0x000000FF);
            spi >>= 8;
        }
    }

}

void MspSecTestSetupEOAssoc()
{
	uchar                          *keyValue;
	msp_sec_des_iv	            IV;
    uchar                          *hashKeysAddr;
    uint                         retStatus;
    uint                         sessionMode;
    uchar                          *espHeader;
    uint                         cryptKeyLength = 0;
    uint                         hashKeyLength = 0;
    char                        line[20];
	char                        ip[20];
    uint                         spi = 0;
    uint                         wholeIp = 0;
    uint                         i;

    sessionMode = MSP_SEC_SA_ENG_MODE_ESP_OUT |
                  MSP_SEC_SA_ESP_INC_SEQ_NUM |
                  MSP_SEC_SA_ESP_IV_IS_RANDOM |
                  MSP_SEC_SA_DES_KEY_2_DECRYPT |
                  MSP_SEC_SA_USE_CHAINING_VARS |
                  MSP_SEC_SA_CRYPT_BLK_CBC_ENC |
                  MSP_SEC_SA_POLLING_MODE;

    switch (SecEspCryptAlg)
    {
        case 1:
            sessionMode |= MSP_SEC_SA_CRYPT_ALG_DES;
            SecEspIvLen = 8;
            SecEspBlockLen = 8;
            cryptKeyLength = 8;
            break;
        case 2:
            sessionMode |= MSP_SEC_SA_CRYPT_ALG_3_DES;
            SecEspIvLen = 8;
            SecEspBlockLen = 8;
            cryptKeyLength = 24;
            break;
        case 3:
            sessionMode |= MSP_SEC_SA_CRYPT_ALG_AES_128;
            SecEspIvLen = 16;
            SecEspBlockLen = 16;
            cryptKeyLength = 16;
            break;
        case 4:
            sessionMode |= MSP_SEC_SA_CRYPT_ALG_AES_192;
            SecEspIvLen = 16;
            SecEspBlockLen = 16;
            cryptKeyLength = 24;
            break;
        case 5:
            sessionMode |= MSP_SEC_SA_CRYPT_ALG_AES_256;
            SecEspIvLen = 16;
            SecEspBlockLen = 16;
            cryptKeyLength = 32;
            break;
        default:
            printf("Bad crypt mode\n");
            return;
            break;
    }
            
    switch (SecEspHashAlg)
    {
        case 1:
            sessionMode |= MSP_SEC_SA_HASH_ALG_MD5_96;
                           
            SecEspIcvLen = 12;
            hashKeyLength = 16;
            break;
        case 2:
            sessionMode |= MSP_SEC_SA_HASH_ALG_SHA1_96;
            SecEspIcvLen = 12;
            hashKeyLength = 20;
            break;
        case 3:
            sessionMode |= MSP_SEC_SA_HASH_ALG_NULL;
            SecEspIcvLen = 0;
            break;
        default:
            printf("Bad auth mode\n");
            return;
            break;
    }
            
    keyValue = SecEspCKey;

    IV.IVHigh = 0x61626364;
    IV.IVLow = 0x61626364;

    hashKeysAddr = SecEspHmacKey;

    printf("\n");
    printf("Enter outgoing Sec Parameter Index in decimal : ");
    if (SecFilterEspOutStarted)
        printf("\n < hit return to keep %d > : ",SecEspOutSpiNum);

    fioRdString (STD_IN, line, sizeof (line));

    sscanf(line,"%d", &spi);
   
    if (spi) {
        SecEspOutSpiNum = spi;
        for (i=4;i>0;i--) { 
            SecEspEspHdr[i-1] = (uchar)(spi & 0x000000FF);
            spi >>= 8;
        }
    }

    espHeader = SecEspEspHdr;

    if (SecFilterEspOutStarted)
        MspSecAssocFree(SecEOAssocId);

    retStatus = MspSecAssocStart(&SecEOAssocId,
                                 sessionMode,
                                 keyValue,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 espHeader,
                                 SecEspCIv,
                                 0);

    if (retStatus) {
        printf("ESP out assoc start error\n");
        SecTestPrintErrorStatus(retStatus);
        return;
    }

    if (SecTestResultsLoud)
        SecShowSA(SecEOAssocId);

    printf("\n");
    printf("This VPN only supports 255.255.255.0 masks.\n");
    printf("\n");
    printf("Enter the local network to protect (eg 192.168.3.0 ) : ");
    if (SecFilterEspOutStarted)
        printf("\n < hit return to keep %s > : ",SecEspLocalNetName);

    fioRdString(STD_IN, ip, sizeof(ip));

    wholeIp = inet_addr(ip);

    if (wholeIp) {
        for (i=0;i<sizeof(ip);i++)
            SecEspLocalNetName[i] = ip[i];

        SecEspLocalNetNum = wholeIp;

        wholeIp >>= 8;
        for (i=3;i>0;i--) {
            SecEspLocalNet[i-1] = (uchar)(wholeIp & 0x000000FF);
            wholeIp >>= 8;
        }
    }

    printf("Enter the remote network to protect (eg 192.168.4.0 ) : ");
    if (SecFilterEspOutStarted)
        printf("\n < hit return to keep %s > : ",SecEspRemoteNetName);

    fioRdString(STD_IN, ip, sizeof(ip));

    wholeIp = inet_addr(ip);

    if (wholeIp) {
        for (i=0;i<sizeof(ip);i++)
            SecEspRemoteNetName[i] = ip[i];

        SecEspRemoteNetNum = wholeIp;

        wholeIp >>= 8;
        for (i=3;i>0;i--) {
            SecEspRemoteNet[i-1] = (uchar)(wholeIp & 0x000000FF);
            wholeIp >>= 8;
        }
    }

    printf("Enter the local gateway ip (eg 192.168.2.1 ) : ");
    if (SecFilterEspOutStarted)
        printf("\n < hit return to keep %s > : ",SecEspLocGateAddrName);

    fioRdString(STD_IN, ip, sizeof(ip));

    wholeIp = inet_addr(ip);

    if (wholeIp) {
        for (i=0;i<sizeof(ip);i++)
            SecEspLocGateAddrName[i] = ip[i];

        SecEspLocGateAddrNum = wholeIp;

        for (i=4;i>0;i--) {
            SecEspLocGateAddr[i-1] = (uchar)(wholeIp & 0x000000FF);
            wholeIp >>= 8;
        }
    }

    printf("Enter the peer gateway ip (eg 192.168.2.2 ) : ");
    if (SecFilterEspOutStarted)
        printf("\n < hit return to keep %s > : ",SecEspPeerGateAddrName);

    fioRdString(STD_IN, ip, sizeof(ip));

    wholeIp = inet_addr(ip);

    if (wholeIp) {
        for (i=0;i<sizeof(ip);i++)
            SecEspPeerGateAddrName[i] = ip[i];

        SecEspPeerGateAddrNum = wholeIp;

        for (i=4;i>0;i--) {
            SecEspPeerGateAddr[i-1] = (uchar)(wholeIp & 0x000000FF);
            wholeIp >>= 8;
        }
    }

    /* Print 0ut the Crypt and Hash Keys */

    printf("\n");
    printf("Crypt keys to be used:\n");
    printf("\n");
    for (i=0;i<cryptKeyLength;i++) {
        printf("0x%02x, ",SecEspCKey[i]);
        if ((i % 8) == 7)
            printf("\n");
    }
    printf("\n");
    printf("  < the string is '%.*s' >\n",(int)cryptKeyLength,SecEspCKey);
    printf("\n");

    printf("Authentication keys to be used:\n");
    printf("\n");
    for (i=0;i<hashKeyLength;i++) {
        printf("0x%02x, ",SecEspHmacKey[i]);
        if ((i % 8) == 7)
            printf("\n");
    }
    printf("\n");
    printf("  < the string is '%.*s' >\n",(int)hashKeyLength,SecEspHmacKey);
    printf("\n");

}

void MspSecTestSetupEspTunnel()
{
    uint         cMode = 0;
    uint         aMode = 0;
    char        line[20];

    printf("Single tunnel setup with fixed crypt and hash keys\n");
    printf("\n");
    printf(" What crypt algorithm should be used?\n");
    printf("  (Enter 1 for DES)\n");
    printf("  (Enter 2 for 3DES)\n");
    printf("  (Enter 3 for AES128)\n");
    printf("  (Enter 4 for AES192)\n");
    printf("  (Enter 5 for AES256) : ");

    if (SecFilterEspOutStarted) {
        printf("\n < hit return to keep ");
        switch (SecEspCryptAlg) {
            case 1:
                printf("DES > : ");
                break;
            case 2:
                printf("3DES > : ");
                break;
            case 3:
                printf("AES128 > : ");
                break;
            case 4:
                printf("AES192 > : ");
                break;
            case 5:
                printf("AES256 > : ");
                break;
        }
    }

    fioRdString (STD_IN, line, sizeof (line));

    sscanf(line,"%d", &cMode);
   
    if (cMode) {
        printf("Changing crypt to %d\n",cMode);
        SecEspCryptAlg = cMode;
    }

    printf("\n");
    printf(" What hash algorithm should be used?\n");
    printf("  (Enter 1 for MD5-96)\n");
    printf("  (Enter 2 for SHA1-96)\n");
    printf("  (Enter 3 for no authentication) : ");

    if (SecFilterEspOutStarted) {
        printf("\n < hit return to keep ");
        switch (SecEspHashAlg) {
            case 1:
                printf("MD5-96 > : ");
                break;
            case 2:
                printf("SHA1-96 > : ");
                break;
            case 3:
                printf("no authentication > : ");
                break;
        }
    }

    fioRdString (STD_IN, line, sizeof (line));

    sscanf(line,"%d", &aMode);
   
    if (aMode) {
        printf("Changing hash to %d\n",aMode);
        SecEspHashAlg = aMode;
    }

    MspSecTestSetupEIAssoc();
    MspSecTestSetupEOAssoc();

    SecFilterEspInStarted = 1;
    SecFilterEspOutStarted = 1;

}

void MspSecTestSetupAHAssoc( uint     aMode)
{
    uchar                          *hashKeysAddr;
    uint                         retStatus;
    uint                         sessionMode;
    uint                         hashKeyLength = 0;

    if (!aMode) {
        printf("Needs parameter:\n");
        printf(" Md5   MspSecTestSetupAHAssoc(1)\n");
        printf(" Sha1  MspSecTestSetupAHAssoc(2)\n");
        return;
    }

    sessionMode = MSP_SEC_SA_ENG_MODE_HMAC |
                  MSP_SEC_SA_USE_CHAINING_VARS |
                  MSP_SEC_SA_INTERRUPT_MODE;

    switch (aMode)
    {
        case 1:
            sessionMode |= MSP_SEC_SA_HASH_ALG_MD5_96;
            hashKeyLength = 16;
            break;
        case 2:
            sessionMode |= MSP_SEC_SA_HASH_ALG_SHA1_96;
            hashKeyLength = 20;
            break;
        default:
            printf("Bad auth mode\n");
            return;
            break;
    }
            
    hashKeysAddr = SecEspHmacKey;

    retStatus = MspSecAssocStart(&SecAHAssocId,
                                 sessionMode,
                                 NULL,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 NULL,
                                 NULL,
                                 0);

    if (retStatus) {
        printf("AH assoc start error\n");
        SecTestPrintErrorStatus(retStatus);
    }

    if (SecTestResultsLoud)
        SecShowSA(SecAHAssocId);

    SecFilterAhStarted = 1;
}

/* **************************************************** */
/* MspSecTestEspOutSeqNum tests the incrementing of the */
/* sequence number.  Running the test in its entirety   */
/* takes around 180 hours                               */
/* **************************************************** */

uchar  PSeqNumEspHdr [] = { 0x12, 0x34, 0x56, 0x78, 0x00, 0x00, 0x00, 0x00 };

void MspSecTestEspOutSeqNum()
{
    uint                         espOutAssocId;
    msp_sec_assoc_params        secParams;
    uchar                          *destAddress;
	uchar                          *keyValue;
    uchar                          *hashKeysAddr;
    uint                         retStatus;
    uint                         outMode;
    uchar                          *espHeader;
    uint                         tempLoc;
    uchar                          *seqNum1;
    uchar                          *seqNum2;
    uchar                          *seqNum3;
    uchar                          *seqNum4;
    uint                         i,j,k,l;
    uint                         hashKeyLength = 0;
    uint                         errorFound = 0;

    outMode = MSP_SEC_SA_ENG_MODE_ESP_OUT |
              MSP_SEC_SA_ESP_INC_SEQ_NUM |
              MSP_SEC_SA_ESP_IV_IS_RANDOM |
              MSP_SEC_SA_CRYPT_ALG_3_DES |
              MSP_SEC_SA_HASH_ALG_SHA1 |
              MSP_SEC_SA_DES_KEY_2_DECRYPT |
              MSP_SEC_SA_USE_CHAINING_VARS |
              MSP_SEC_SA_CRYPT_BLK_ECB |
              /* MSP_SEC_SA_INTERRUPT_MODE; */
              MSP_SEC_SA_POLLING_MODE;
            
    keyValue = PCSecKey6;

    hashKeysAddr = PASecKey4;

    espHeader = PSeqNumEspHdr;

    hashKeyLength = 20;

    retStatus = MspSecAssocStart(&espOutAssocId,
                                 outMode,
                                 keyValue,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 espHeader,
                                 PCSecIv6,
                                 0);

    if (retStatus) {
        printf("Assoc start error\n");
        SecTestPrintErrorStatus(retStatus);
    }

    destAddress = (uchar *)malloc(128);

    tempLoc = (uint)destAddress;
    tempLoc += 4;
    seqNum4 = (uchar *)tempLoc++;
    seqNum3 = (uchar *)tempLoc++;
    seqNum2 = (uchar *)tempLoc++;
    seqNum1 = (uchar *)tempLoc;
    for (l=0;l<0x100;l++) {
        for (k=0;k<0x100;k++) {
            for (j=0;j<0x100;j++) {
                for (i=0;i<0x100;i++) {

                    secParams.associationId = espOutAssocId;
                    secParams.nextProtocol = 0x06;
                    secParams.sourceAddr0 = PSrcData6;
                    secParams.size0 = 40;
                    secParams.sourceAddr1 = NULL;
                    secParams.size1 = 0;
                    secParams.destAddr0 = destAddress;
                    secParams.destAddr1 = NULL;

                    retStatus = MspSecAssocXBlk(&secParams);

                    if (retStatus)
                        SecTestPrintErrorStatus(retStatus);

                    if (*seqNum4 != l) {
                        printf("Seq Number mismatch!!!\n");
                        printf("Location:  %02x:%02x:%02x:%02x\n",l,k,j,i);
                        printf("Right here -^\n");
                        errorFound = 1;
                    }

                    if (*seqNum3 != k) {
                        printf("Seq Number mismatch!!!\n");
                        printf("Location:  %02x:%02x:%02x:%02x\n",l,k,j,i);
                        printf("Right here ----^\n");
                        errorFound = 1;
                    }

                    if (*seqNum2 != j) {
                        printf("Seq Number mismatch!!!\n");
                        printf("Location:  %02x:%02x:%02x:%02x\n",l,k,j,i);
                        printf("Right here -------^\n");
                        errorFound = 1;
                    }

                    if (*seqNum1 != i) {
                        printf("Seq Number mismatch!!!\n");
                        printf("Location:  %02x:%02x:%02x:%02x\n",l,k,j,i);
                        printf("Right here ----------^\n");
                        errorFound = 1;
                    }

                    if (errorFound)
                        break;
                }
                if (errorFound)
                    break;
                i--;
                /* printf("Finished:  %02x:%02x:%02x:%02x\n",l,k,j,i); */
            }
            if (errorFound)
                break;
            j--;
            printf("Finished:  %02x:%02x:%02x:%02x\n",l,k,j,i);
        }
        if (errorFound)
            break;
        k--;
        printf("Finished:  %02x:%02x:%02x:%02x\n",l,k,j,i);
    }
    l--;
    printf("Finished:  %02x:%02x:%02x:%02x\n",l,k,j,i);

    free(destAddress);
}

/* Globals used in MspSecTestEspSize and    */
/* MspSecTestMultiSizeChain tests           */

uchar  PEspSizeTestCKeys [] = { 0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                             0x64, 0x63, 0x62, 0x61, 0x64, 0x63, 0x62, 0x61,
                             0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                             0x64, 0x63, 0x62, 0x61, 0x64, 0x63, 0x62, 0x61 };

uchar  PEspSizeTestCIv [] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
                           0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f };

uchar  PEspSizeTestAKeys [] = { 0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                             0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64,
                             0x61, 0x62, 0x63, 0x64 };

uchar  PEspSizeTestEHdr [] = { 0x00, 0x00, 0x0F, 0xA0, 0x00, 0x00, 0x00, 0x01 };

uint     SecTestIVLoud = 0;
uint     SecTestIVRand = 0;

/* ESP Tests use SecTestSetupAssocIds to setup all  */
/* possible different CBC ESP outgoing and incoming */
/* associations.                                    */

void SecTestSetupAssocIds( uint  associationOutIds[5][5],
                           uint  associationInIds[5][5],
                           uint  maxDestSize)
{
    uint     cAlgIndex;
    uint     aAlgIndex;
    uint     outMode;
    uint     inMode;
    uint     retStatus;
    uint     outId;
    uint     aKeySize = 0;

    /* Setup an ESP Outgoing and ESP Incoming association   */
    /* for each the possible combinations of crypt and      */
    /* authentication algorithms (25 total)                 */
    for (cAlgIndex=0;cAlgIndex<5;cAlgIndex++) {
        for (aAlgIndex=0;aAlgIndex<5;aAlgIndex++) {

            outMode = MSP_SEC_SA_ENG_MODE_ESP_OUT |
                      MSP_SEC_SA_ESP_INC_SEQ_NUM |
                      MSP_SEC_SA_DES_KEY_2_DECRYPT |
                      MSP_SEC_SA_USE_CHAINING_VARS |
                      MSP_SEC_SA_CRYPT_BLK_CBC_ENC |
                      /* MSP_SEC_SA_INTERRUPT_MODE; */
                      MSP_SEC_SA_POLLING_MODE;

            if (SecTestIVRand)
                outMode |= MSP_SEC_SA_ESP_IV_IS_RANDOM;

            inMode = MSP_SEC_SA_ENG_MODE_ESP_IN |
                     MSP_SEC_SA_DES_KEY_1_DECRYPT |
                     MSP_SEC_SA_DES_KEY_3_DECRYPT |
                     MSP_SEC_SA_USE_CHAINING_VARS |
                     MSP_SEC_SA_CRYPT_BLK_CBC_DEC |
                      /* MSP_SEC_SA_INTERRUPT_MODE; */
                      MSP_SEC_SA_POLLING_MODE;

            switch (cAlgIndex) 
            {
                case (0):
                    outMode |= MSP_SEC_SA_CRYPT_ALG_DES;
                    inMode |= MSP_SEC_SA_CRYPT_ALG_DES;
                    break;
                case (1):
                    outMode |= MSP_SEC_SA_CRYPT_ALG_3_DES;
                    inMode |= MSP_SEC_SA_CRYPT_ALG_3_DES;
                    break;
                case (2):
                    outMode |= MSP_SEC_SA_CRYPT_ALG_AES_128;
                    inMode |= MSP_SEC_SA_CRYPT_ALG_AES_128;
                    break;
                case (3):
                    outMode |= MSP_SEC_SA_CRYPT_ALG_AES_192;
                    inMode |= MSP_SEC_SA_CRYPT_ALG_AES_192;
                    break;
                case (4):
                    outMode |= MSP_SEC_SA_CRYPT_ALG_AES_256;
                    inMode |= MSP_SEC_SA_CRYPT_ALG_AES_256;
                    break;
                default:
                    break;
            }
    
            switch (aAlgIndex) 
            {
                case (0):
                    outMode |= MSP_SEC_SA_HASH_ALG_MD5;
                    inMode |= MSP_SEC_SA_HASH_ALG_MD5 |
                              MSP_SEC_SA_ESP_CMP_ICV;
                    aKeySize = 16;
                    break;
                case (1):
                    outMode |= MSP_SEC_SA_HASH_ALG_SHA1;
                    inMode |= MSP_SEC_SA_HASH_ALG_SHA1 |
                              MSP_SEC_SA_ESP_CMP_ICV;
                    aKeySize = 20;
                    break;
                case (2):
                    outMode |= MSP_SEC_SA_HASH_ALG_MD5_96;
                    inMode |= MSP_SEC_SA_HASH_ALG_MD5_96 |
                              MSP_SEC_SA_ESP_CMP_ICV;
                    aKeySize = 16;
                    break;
                case (3):
                    outMode |= MSP_SEC_SA_HASH_ALG_SHA1_96;
                    inMode |= MSP_SEC_SA_HASH_ALG_SHA1_96 |
                              MSP_SEC_SA_ESP_CMP_ICV;
                    aKeySize = 20;
                    break;
                case (4):
                    outMode |= MSP_SEC_SA_HASH_ALG_NULL;
                    inMode |= MSP_SEC_SA_HASH_ALG_NULL;
                    aKeySize = 0;
                    break;
                default:
                    break;
            }
    

            retStatus = MspSecAssocStart(&outId,
                                         outMode,
                                         PEspSizeTestCKeys,
                                         PEspSizeTestAKeys,
                                         aKeySize,
                                         PEspSizeTestEHdr,
                                         PEspSizeTestCIv,
                                         maxDestSize);

            if (retStatus) {
                printf("Failed on outgoing %d,%d\n",cAlgIndex,aAlgIndex);
                SecTestPrintErrorStatus(retStatus);
            }

            associationOutIds[cAlgIndex][aAlgIndex] = outId;

            if (SecTestResultsLoud)
                SecShowSA(associationOutIds[cAlgIndex][aAlgIndex]);

            retStatus = MspSecAssocStart(&associationInIds[cAlgIndex][aAlgIndex],
                                         inMode,
                                         PEspSizeTestCKeys,
                                         PEspSizeTestAKeys,
                                         aKeySize,
                                         NULL,
                                         PEspSizeTestCIv,
                                         0);

            if (retStatus) {
                printf("Failed on outgoing %d,%d\n",cAlgIndex,aAlgIndex);
                SecTestPrintErrorStatus(retStatus);
            }

            if (SecTestResultsLoud)
                SecShowSA(associationInIds[cAlgIndex][aAlgIndex]);
        }
    }
}

void SecPrintAlgNames(uint   cAlgIndex,
                      uint   aAlgIndex)
{
    /* Setup variables depending on algorithms used */ 
    switch (cAlgIndex) 
    {
        case (0):
            printf("DES    ");
            break;
        case (1):
            printf("3DES   ");
            break;
        case (2):
            printf("AES128 ");
            break;
        case (3):
            printf("AES192 ");
            break;
        case (4):
            printf("AES256 ");
            break;
    }
        
    switch (aAlgIndex) 
    {
        case (0):
            printf("MD5    ");
            break;
        case (1):
            printf("SHA1   ");
            break;
        case (2):
            printf("MD596  ");
            break;
        case (3):
            printf("SHA196 ");
            break;
        case (4):
            printf("NULL   ");
            break;
    }
}

/* ESP Size Test-  All possible sizes for each mode */
/* using the non-chaining interface                 */

uint     JStart = 28;
uint     JStop = 1500;

void MspSecTestEspSize()
{
    msp_sec_assoc_params    secParams;
    uchar                      *destAddr0;
    uchar                      *destAddr1;
    uchar                      *tempChar;
    uint                     i;
    uint                     j;
    uint                     nextProtocol;
    uint                     src0Length;
    uint                     src1Length;
    uint                     gatherLoc0;
    uint                     gatherLoc1;
    uint                     scatterLoc;
    uint                     origLength;
    uint                     aAlgIndex;
    uint                     cAlgIndex;
    uint                     associationOutIds[5][5];
    uint                     associationInIds[5][5];
    uint                     retStatus;
    uint                     tempSeq;
    uchar                      *tempChar2;
    uint                     ivLen = 0;
    uint                     icvLen = 0;
    uint                     totalErrors = 0;
    uint                     errorFound = 0;
    uint                     totalPassed = 0;
    uint                     totalOps = 0;
    BOOL                    fragmentFrame = FALSE;
    uint                     destSize;
    uint                     maxDestSize;
    uint                     chainId;
    uint                     tempInt;

    destAddr0 = malloc(1600);
    destAddr1 = malloc(240);

    /* Input max dest size */
    maxDestSize = 1500;

    SecTestSetupAssocIds(associationOutIds,
                         associationInIds,
                         maxDestSize);

    /* JRR-DEBUG */
    printf("Finished setting up associds\n");

    /* Perform test on each combination of crypt and    */
    /* authentication algorithms                        */
    for (cAlgIndex=0;cAlgIndex<5;cAlgIndex++) {
        for (aAlgIndex=0;aAlgIndex<5;aAlgIndex++) {

            printf("Testing sizes 28 through 1500 with:  ");
    
            /* Setup variables depending on algorithms used */ 
            switch (cAlgIndex) 
            {
                case (0):
                    printf("DES/");
                    ivLen = 8;
                    break;
                case (1):
                    printf("3DES/");
                    ivLen = 8;
                    break;
                case (2):
                    printf("AES-128/");
                    ivLen = 16;
                    break;
                case (3):
                    printf("AES-192/");
                    ivLen = 16;
                    break;
                case (4):
                    printf("AES-256/");
                    ivLen = 16;
                    break;
            }
                
            switch (aAlgIndex) 
            {
                case (0):
                    printf("MD5\n");
                    icvLen = 16;
                    break;
                case (1):
                    printf("SHA1\n");
                    icvLen = 20;
                    break;
                case (2):
                    printf("MD5-96\n");
                    icvLen = 12;
                    break;
                case (3):
                    printf("SHA1-96\n");
                    icvLen = 12;
                    break;
                case (4):
                    printf("NULL\n");
                    icvLen = 0;
                    break;
            }
  
            /* Test all possible ethernet sizes */
            /* (and maybe a few extra)          */ 
            for (j=28;j<1500;j++) {
    
                totalOps++;

                origLength = src0Length = j;
    
                tempChar = destAddr0;
                for (i=0;i<src0Length;i++)
                    *tempChar++ = (i & 0xFF);
    
                nextProtocol = 0x04;
    
                gatherLoc0 = (uint)destAddr0;
                scatterLoc = gatherLoc0 + 20;
                destSize = MspSecAssocQueryDestSize(associationOutIds[cAlgIndex][aAlgIndex],
                                                    src0Length);

                if (maxDestSize)                                    
                    fragmentFrame = destSize > maxDestSize; 

                secParams.associationId = associationOutIds[cAlgIndex][aAlgIndex];
                secParams.nextProtocol = nextProtocol;
                secParams.sourceAddr0 = (uchar *)gatherLoc0;
                secParams.size0 = src0Length;
                secParams.sourceAddr1 = NULL;
                secParams.size1 = 0;
                secParams.destAddr0 = (uchar *)scatterLoc;
                if (fragmentFrame)
                    secParams.destAddr1 = destAddr1;
                else
                    secParams.destAddr1 = NULL;
         
                retStatus = MspSecAssocXBlk (&secParams);
  
                if (retStatus) {
                    printf("Failed on outgoing size %d\n",origLength);
                    SecTestPrintErrorStatus(retStatus);
                }

                /* Check the first 6 bytes of the esp header */
                tempChar = (uchar *)scatterLoc;
                tempChar2 = PEspSizeTestEHdr;
                for (i=0;i<6;i++) {
                    if (*tempChar++ != *tempChar2++) {
                        errorFound = 1;
                        totalErrors++;
                    }
                }

                /* Check the sequence number is incremented */
                tempSeq = j;
                tempSeq -= 27;
                tempSeq >>= 8;
                if (*tempChar++ != (uchar)tempSeq) {
                    if (!errorFound) {
                        errorFound = 2;
                        totalErrors++;
                    }
                }

                tempSeq = j;
                tempSeq -= 27;
                tempSeq &= 0xFF;
                if (*tempChar++ != (uchar)tempSeq) {
                    if (!errorFound) {
                        errorFound = 2;
                        totalErrors++;
                    }
                }

                tempChar2 = PEspSizeTestCIv;

                if (SecTestIVLoud) {
                    printf("IV: 0x");
                    for (i=0;i<ivLen;i++) {
                        printf("%02x",*tempChar);
                        if (SecTestIVRand)
                            tempChar++;
                        else
                            if (*tempChar++ != *tempChar2++) {
                                if (!errorFound) {
                                    errorFound = 3;
                                    totalErrors++;
                                }
                            }
                    }
                    printf("\n");
                } else {
                    if (!SecTestIVRand)
                        for (i=0;i<ivLen;i++) {
                            if (*tempChar++ != *tempChar2++) {
                                if (!errorFound) {
                                    errorFound = 3;
                                    totalErrors++;
                                }
                            }
                        }
                }

                src0Length = destSize;
    
                if (SecTestResultsLoud) {
                    tempChar = (uchar *)scatterLoc;
                    printf("Encryption:\n");
                    if (fragmentFrame) {
                        src1Length = src0Length - maxDestSize;
                        if (src1Length < icvLen) {
                            tempInt = icvLen - src1Length;
                            src1Length = icvLen;
                        } else {
                            tempInt = 0;
                        }

                        printf("Fragment 1: length: %d\n",maxDestSize - tempInt);
                        for (i=0;i<maxDestSize - tempInt;i++) 
	                    {
                            printf(" 0x%02x,",*tempChar++);
                            if ((i % 8) == 7)
                                printf("\n");
                        }
                        printf("\n");
                        printf("Fragment 2: length : %d\n",src1Length);
                        tempChar = (uchar *)destAddr1;
                        for (i=0;i<src1Length;i++) 
	                    {
                            printf(" 0x%02x,",*tempChar++);
                            if ((i % 8) == 7)
                                printf("\n");
                        }
                    } else {
                        for (i=0;i<src0Length;i++) 
	                    {
                            printf(" 0x%02x,",*tempChar++);
                            if ((i % 8) == 7)
                                printf("\n");
                        }
                    }
         
                    printf("\n");
                }

                gatherLoc0 = scatterLoc;
                scatterLoc = gatherLoc0 - 20;
        
                if (fragmentFrame) {
                    chainId = 0;
                    src0Length -= maxDestSize;
                    if (src0Length < icvLen) {
                        src0Length = maxDestSize - (icvLen - src0Length);
                        src1Length = 0;
                    } else {
                        src1Length = src0Length - icvLen;
                        src0Length = maxDestSize;
                    }

                    gatherLoc1 = (uint)destAddr1 + src1Length;

                    retStatus = MspSecAssocBuildChain(&chainId,
                                (uchar *)gatherLoc0,
                                (uchar *)scatterLoc,
                                src0Length,
                                0);

                    if (src1Length)
                        retStatus = MspSecAssocBuildChain(&chainId,
                                                          destAddr1,
                                                          NULL,
                                                          src1Length,
                                                          0);

                    if (icvLen) {
                        retStatus = MspSecAssocBuildChain(&chainId,
                                    (uchar *)gatherLoc1,
                                    NULL,
                                    icvLen,
                                    0);
                    }

                    retStatus = MspSecAssocXChainBlk(
                                        associationInIds[cAlgIndex][aAlgIndex],
                                        chainId,
                                        0);

                    if (retStatus) {
                        printf("Failed on fragmented size %d : %d\n",
                               src0Length,
                               src1Length);

                        SecTestPrintErrorStatus(retStatus);
                    }

                } else {
                    src0Length -= icvLen;
                    gatherLoc1 = gatherLoc0 + src0Length;
                    secParams.associationId = associationInIds[cAlgIndex][aAlgIndex];
                    secParams.nextProtocol = 0;
                    secParams.sourceAddr0 = (uchar *)gatherLoc0;
                    secParams.size0 = src0Length;
                    if (icvLen) {
                        secParams.sourceAddr1 = (uchar *)gatherLoc1;
                        secParams.size1 = icvLen;
                    } else {
                        secParams.sourceAddr1 = NULL;
                        secParams.size1 = 0;
                    }

                    secParams.destAddr0 = (uchar *)scatterLoc;
                    secParams.destAddr1 = NULL;
             
                    retStatus = MspSecAssocXBlk (&secParams);
         
                    if (retStatus) {
                        printf("Failed on incoming size %d\n",src0Length);
                        SecTestPrintErrorStatus(retStatus);
                    }
                }

                /* Compare results */
                tempChar = (uchar *)scatterLoc;
                for (i=0;i<origLength;i++) 
	            {
                    if (*tempChar++ != (i & 0xFF)) 
		            {
                        if (!errorFound) {
                            totalErrors++;
                            errorFound = 4;
                        }
                    }
                }
     
                if (SecTestResultsLoud) {
                    tempChar = (uchar *)scatterLoc;
                    printf("Decryption:\n");
                    for (i=0;i<origLength;i++) 
	                {
                        printf(" 0x%02x,",*tempChar++);
                        if ((i % 8) == 7)
                            printf("\n");
                    }
         
                    printf("\n");
                }
     
                if (errorFound) {
                    printf("Failed on size %d ",origLength);
                    switch (errorFound) {
                        case 1:
                            printf(" (ESP Header mismatch)\n");
                            break;
                        case 2:
                            printf(" (Seq # mismatch)\n");
                            break;
                        case 3:
                            printf(" (IV mismatch)\n");
                            break;
                        case 4:
                            printf(" (Final Cmp mismatch)\n");
                            break;
                    }

                    errorFound = 0;
                } else {
                    totalPassed++;
                }
            }
            printf("  Total Ops:  %d\n",totalOps);
            printf("  Passed:  %d   Failed:  %d\n",totalPassed,totalErrors);
        }
    }

    for (cAlgIndex=0;cAlgIndex<5;cAlgIndex++)
        for (aAlgIndex=0;aAlgIndex<5;aAlgIndex++) {
            MspSecAssocFree(associationInIds[cAlgIndex][aAlgIndex]);
            MspSecAssocFree(associationOutIds[cAlgIndex][aAlgIndex]);
        }
  
    free(destAddr0);
    free(destAddr1);

    printf("Test Completed with total errors:  %d\n",totalErrors);
     
}

/* ESP 3 (or less) Element Chain Test-  Random size for each    */
/* mode.  All possible chain variations of that size are tested */

typedef struct {
    uint     sampleSize;
    uint     numberOps;
    uint     numberPassed;
    uint     numberFailed;
} SecTestResultsStruct;

/* JRR-DEBUG */
extern uint  SecTooManyHandled;

void MspSecTestMultiSizeChain(uint       runForever)
{
    msp_sec_assoc_params    secParams;
    uint                     chainId;
    uchar                      *destAddr0;
    uchar                      *destAddr1;
    uchar                      *srcAddr;
    uchar                      *tempChar;
    uint                     i;
    uint                     nextProtocol;
    uint                     src0Length;
    uint                     src1Length;
    uint                     src2Length;
    uint                     src2TotLength;
    uint                     src3Length = 0;
    uint                     destLength;
    uint                     gatherLoc0;
    uint                     gatherLoc1;
    uint                     gatherLoc2;
    uint                     gatherLocIcv;
    uint                     scatterLoc;
    uint                     origLength;
    uint                     aAlgIndex;
    uint                     cAlgIndex;
    uint                     associationOutIds[5][5];
    uint                     associationInIds[5][5];
    uint                     retStatus;
    uint                     tempSeq;
    uint                     currSeq;
    uchar                      *tempChar2;
    uint                     splitLength;
    uint                     ivLen = 0;
    uint                     icvLen = 0;
    uint                     totalErrors = 0;
    uint                     errorFound = 0;
    uint                     totalPassed = 0;
    uint                     totalOps = 0;
    uint                     tempOps;
    uint                     opsLeft;
    uint                     testingEspOut;
    SecTestResultsStruct    iResults[5][5];
    SecTestResultsStruct    oResults[5][5];
    BOOL                    fragmentFrame = FALSE;
    uint                     maxDestSize;
    uint                     bytesSoFar;
    uint                     crossedBorder;
    uint                     srcALength;
    uint                     srcBLength;
    uint                     tempInt;

    printf("WARNING:  This test takes on average over 1-2 hours\n");
    printf("          to run one iteration. Give 1 as a parameter\n");
    printf("          to this function to run forever.\n"); 

    destAddr0 = malloc(1600);
    destAddr1 = malloc(240);
    srcAddr = malloc(1600);

    do {
    ivLen = 0;
    icvLen = 0;
    errorFound = 0;

    /* Input max dest size */
    maxDestSize = 1500;

    SecTestSetupAssocIds(associationOutIds,
                         associationInIds,
                         maxDestSize);

    /* JRR-DEBUG */
    /* SecTestResultsLoud = 1; */

    /* Perform test on each combination of crypt and    */
    /* authentication algorithms                        */

    for (cAlgIndex=0;cAlgIndex<5;cAlgIndex++) {
        for (aAlgIndex=0;aAlgIndex<5;aAlgIndex++) {

            currSeq = 0;

            SecPrintAlgNames(cAlgIndex,aAlgIndex);

            /* Setup variables depending on algorithms used */ 
            switch (cAlgIndex) 
            {
                case (0):
                    ivLen = 8;
                    break;
                case (1):
                    ivLen = 8;
                    break;
                case (2):
                    ivLen = 16;
                    break;
                case (3):
                    ivLen = 16;
                    break;
                case (4):
                    ivLen = 16;
                    break;
            }
             
            switch (aAlgIndex) 
            {
                case (0):
                    icvLen = 16;
                    break;
                case (1):
                    icvLen = 20;
                    break;
                case (2):
                    icvLen = 12;
                    break;
                case (3):
                    icvLen = 12;
                    break;
                case (4):
                    icvLen = 0;
                    break;
            }

            for (testingEspOut = 0;testingEspOut < 2;testingEspOut++) {
            printf("Testing all possible chains on random total size:  ");
    
            if (testingEspOut)
                printf("(ESP-out chained)\n");
            else
                printf("(ESP-in chained)\n");
  
            tempChar = srcAddr;
            for (i=0;i<1500;i++)
                *tempChar++ = (i & 0xFF);
 
            /* Get random value (28-1500) for testing size */ 
            origLength = MspSecAssocGetRandom();
            origLength %= 1483;
            origLength += 28;

            src0Length = origLength;

            printf("  Random size:  %d  ",origLength);

            nextProtocol = 0x04;
    
            destLength = MspSecAssocQueryDestSize(associationOutIds[cAlgIndex][aAlgIndex],
                                                  src0Length);

            if (maxDestSize)                                    
                fragmentFrame = destLength > maxDestSize; 

            if (fragmentFrame)
                printf("(ESP Out Dest Fragmentation)\n");
            else
                printf("\n");

            if (testingEspOut)
                splitLength = src0Length;
            else
                splitLength = destLength - icvLen;

            opsLeft = 0;
            tempOps = splitLength;
            for (i=0;i<splitLength;i++)
                opsLeft += tempOps--;

            tempOps = splitLength;

            if (testingEspOut) {
                oResults[cAlgIndex][aAlgIndex].sampleSize = origLength;
                oResults[cAlgIndex][aAlgIndex].numberOps = opsLeft;
                oResults[cAlgIndex][aAlgIndex].numberPassed = 0;
                oResults[cAlgIndex][aAlgIndex].numberFailed = 0;
            } else {
                iResults[cAlgIndex][aAlgIndex].sampleSize = origLength;
                iResults[cAlgIndex][aAlgIndex].numberOps = opsLeft;
                iResults[cAlgIndex][aAlgIndex].numberPassed = 0;
                iResults[cAlgIndex][aAlgIndex].numberFailed = 0;
            }

            /* Two for loops provide all different  */
            /* combinations of chain sizes          */
                
            for (src1Length = 0;src1Length < splitLength;src1Length++) {

                src2TotLength = splitLength - src1Length;

                for (src2Length = 0;src2Length < src2TotLength;src2Length++) {

                    if (errorFound) {
                        /* If there was a data miscompare,  */
                        /* we need to rewrite source data   */
                        tempChar = srcAddr;
                        for (i=0;i<1450;i++)
                            *tempChar++ = (i & 0xFF);
                        errorFound = 0;
                    }
 

                    totalOps++;

                    gatherLoc0 = (uint)srcAddr;
                    scatterLoc = (uint)destAddr0;

                    /* Start ESP out operation */

                    if (testingEspOut) 
                    {
                        chainId = 0;

                        if (src1Length) {
                            retStatus = MspSecAssocBuildChain(&chainId,
                                                              (uchar *)gatherLoc0,
                                                              (uchar *)scatterLoc,
                                                              src1Length,
                                                              0);

                            if (retStatus) {
                                printf("Build chain failed size: %d\n",src1Length);
                                SecTestPrintErrorStatus(retStatus);
                            }
                            if (fragmentFrame)
                                scatterLoc = (uint)destAddr1;
                            else
                                scatterLoc = 0;
                        }


                        gatherLoc1 = gatherLoc0 + src1Length;

                        if (src2Length) {
                            retStatus = MspSecAssocBuildChain(&chainId,
                                                              (uchar *)gatherLoc1,
                                                              (uchar *)scatterLoc,
                                                              src2Length,
                                                              0);

                            if (retStatus) {
                                printf("Build chain failed size: %d\n",src2Length);
                                SecTestPrintErrorStatus(retStatus);
                            }

                            if ((fragmentFrame) &&
                                (scatterLoc != (uint)destAddr1))
                                scatterLoc = (uint)destAddr1;
                            else
                                scatterLoc = 0;
                        }

                        gatherLoc2 = gatherLoc1 + src2Length;

                        src3Length = src2TotLength - src2Length;

                        retStatus = MspSecAssocBuildChain(&chainId,
                                                          (uchar *)gatherLoc2,
                                                          (uchar *)scatterLoc,
                                                          src3Length,
                                                          0);
    
                        if (retStatus) {
                            printf("Build chain failed size: %d\n",src3Length);
                            SecTestPrintErrorStatus(retStatus);
                        }

                        /* If theres only one chain element and */
                        /* the frame needs to be fragmented, we */
                        /* have to give one more dest address   */
                        if ((fragmentFrame) &&
                            (src3Length == splitLength))
                        {

                            retStatus = MspSecAssocBuildChain(&chainId,
                                                              NULL,
                                                              destAddr1,
                                                              0,
                                                              0);
    
                            if (retStatus) {
                                printf("Build chain failed frag extra\n");
                                SecTestPrintErrorStatus(retStatus);
                            }
                        }

                        retStatus = MspSecAssocXChainBlk (associationOutIds[cAlgIndex][aAlgIndex],
                                                          chainId,
                                                          nextProtocol);

                        if (retStatus) {
                            printf("Chain op failed size: %d\n",origLength);
                            SecTestPrintErrorStatus(retStatus);
                        }

                        /* JRR-DEBUG */
                        if (SecTooManyHandled) {
                            printf("Too many loops through comp Q!!!\n");
                            printf("Failed on espout chainblk\n");
                            return;
                        }
                    } else {
                        secParams.associationId = associationOutIds[cAlgIndex][aAlgIndex];
                        secParams.nextProtocol = nextProtocol;
                        secParams.sourceAddr0 = (uchar *)gatherLoc0;
                        secParams.size0 = src0Length;
                        secParams.sourceAddr1 = NULL;
                        secParams.size1 = 0;
                        secParams.destAddr0 = (uchar *)scatterLoc;
                        if (fragmentFrame)
                            secParams.destAddr1 = destAddr1;
                        else
                            secParams.destAddr1 = NULL;
    
                        retStatus = MspSecAssocXBlk (&secParams);

                        if (retStatus) {
                            printf("Min op failed size: %d\n",src0Length);
                            SecTestPrintErrorStatus(retStatus);
                        }

                        /* JRR-DEBUG */
                        if (SecTooManyHandled) {
                            printf("Too many loops through comp Q!!!\n");
                            printf("Failed on espout xblk\n");
                            return;
                        }
                    }

                    /* Check intermediate results   */

                    /* Check the first 4 bytes of the esp header */
                    tempChar = destAddr0;
                    tempChar2 = PEspSizeTestEHdr;
                    for (i=0;i<4;i++) {
                        if (*tempChar++ != *tempChar2++) {
                            errorFound = 1;
                            totalErrors++;
                        }
                    }

                    /* Check the sequence number is incremented */
                    currSeq++;
                    tempSeq = currSeq;
                    tempSeq >>= 24;
                    if (*tempChar++ != (uchar)tempSeq) {
                        if (!errorFound) {
                            errorFound = 2;
                            totalErrors++;
                        }
                    }

                    tempSeq = currSeq;
                    tempSeq >>= 16;
                    if (*tempChar++ != (uchar)tempSeq) {
                        if (!errorFound) {
                            errorFound = 2;
                            totalErrors++;
                        }
                    }

                    tempSeq = currSeq;
                    tempSeq >>= 8;
                    if (*tempChar++ != (uchar)tempSeq) {
                        if (!errorFound) {
                            errorFound = 2;
                            totalErrors++;
                        }
                    }

                    tempSeq = currSeq;
                    tempSeq &= 0xFF;
                    if (*tempChar++ != (uchar)tempSeq) {
                        if (!errorFound) {
                            errorFound = 2;
                            totalErrors++;
                        }
                    }

                    tempChar2 = PEspSizeTestCIv;

                    if (SecTestIVLoud) {
                        printf("IV: 0x");
                        for (i=0;i<ivLen;i++) {
                            printf("%02x",*tempChar);
                            if (SecTestIVRand)
                                tempChar++;
                            else
                                if (*tempChar++ != *tempChar2++) {
                                    if (!errorFound) {
                                        errorFound = 3;
                                        totalErrors++;
                                    }
                                }
                        }
                        printf("\n");
                    } else {
                        if (!SecTestIVRand)
                            for (i=0;i<ivLen;i++) {
                                if (*tempChar++ != *tempChar2++) {
                                    if (!errorFound) {
                                        errorFound = 3;
                                        totalErrors++;
                                    }
                                }
                            }
                    }

                    if (SecTestResultsLoud) {
                        tempChar = (uchar *)destAddr0;
                        printf("Encryption:\n");
                        if (fragmentFrame) {
                            srcBLength = destLength - maxDestSize;
                            if (srcBLength < icvLen) {
                                tempInt = icvLen - srcBLength;
                                srcBLength = icvLen;
                            } else {
                                tempInt = 0;
                            }
    
                            printf("Fragment 1: length: %d\n",maxDestSize - tempInt);
                            for (i=0;i<maxDestSize - tempInt;i++) 
	                        {
                                printf(" 0x%02x,",*tempChar++);
                                if ((i % 8) == 7)
                                    printf("\n");
                            }
                            printf("\n");
                            printf("Fragment 2: length : %d\n",srcBLength);
                            tempChar = (uchar *)destAddr1;
                            for (i=0;i<srcBLength;i++) 
	                        {
                                printf(" 0x%02x,",*tempChar++);
                                if ((i % 8) == 7)
                                    printf("\n");
                            }
                        } else {
                            for (i=0;i<destLength;i++) 
                            {
                                printf(" 0x%02x,",*tempChar++);
                                if ((i % 8) == 7)
                                    printf("\n");
                            }
                        } 
                        printf("\n");
                    }

                    /* Start ESP Incoming operation */

                    gatherLoc0 = (uint)destAddr0;
                    scatterLoc = (uint)srcAddr;
         
                    if (testingEspOut) {
                        srcALength = destLength;
                        if (fragmentFrame) {
                            chainId = 0;
                            srcALength -= maxDestSize;
                            if (srcALength < icvLen) {
                                srcALength = maxDestSize - (icvLen - srcALength);
                                srcBLength = 0;
                            } else {
                                srcBLength = srcALength - icvLen;
                                srcALength = maxDestSize;
                            }

                            gatherLocIcv = (uint)destAddr1 + srcBLength;

                            retStatus = MspSecAssocBuildChain(&chainId,
                                        (uchar *)gatherLoc0,
                                        (uchar *)scatterLoc,
                                        srcALength,
                                        0);

                            if (srcBLength)
                                retStatus = MspSecAssocBuildChain(&chainId,
                                                                destAddr1,
                                                                NULL,
                                                                srcBLength,
                                                                0);

                            if (icvLen) {
                                retStatus = MspSecAssocBuildChain(&chainId,
                                            (uchar *)gatherLocIcv,
                                            NULL,
                                            icvLen,
                                            0);
                            }

                            retStatus = MspSecAssocXChainBlk(
                                                associationInIds[cAlgIndex][aAlgIndex],
                                                chainId,
                                                0);

                            if (retStatus) {
                                printf("Failed on fragmented size %d : %d\n",
                                    srcALength,
                                    srcBLength);

                                SecTestPrintErrorStatus(retStatus);
                            }
                        } else {
                            gatherLocIcv = gatherLoc0 + destLength - icvLen;
                            secParams.associationId = associationInIds[cAlgIndex][aAlgIndex];
                            secParams.nextProtocol = 0;
                            secParams.sourceAddr0 = (uchar *)gatherLoc0;
                            secParams.size0 = destLength - icvLen;
                            if (icvLen) {
                                secParams.sourceAddr1 = (uchar *)gatherLocIcv;
                                secParams.size1 = icvLen;
                            } else {
                                secParams.sourceAddr1 = NULL;
                                secParams.size1 = 0;
                            }

                            secParams.destAddr0 = (uchar *)scatterLoc;
                            secParams.destAddr1 = NULL;
             
                            retStatus = MspSecAssocXBlk (&secParams);

                            if (retStatus) {
                                printf("Min op failed size: %d\n",destLength);
                                SecTestPrintErrorStatus(retStatus);
                            }
                        }

                        /* JRR-DEBUG */
                        if (SecTooManyHandled) {
                            printf("Too many loops through comp Q!!!\n");
                            printf("Failed on espin chainblk\n");
                            return;
                        }
                    } else {
                        chainId = 0;
                        if ((fragmentFrame) &&
                            (splitLength > maxDestSize)) {
                            bytesSoFar = 0;
                            crossedBorder = 0;
                            if (src1Length) {
                                if (src1Length > maxDestSize) {
                                    retStatus = MspSecAssocBuildChain(&chainId,
                                                                      (uchar *)gatherLoc0,
                                                                      (uchar *)scatterLoc,
                                                                      maxDestSize,
                                                                      0);

                                    if (retStatus) {
                                        printf("1Build chain failed size: %d\n",maxDestSize);
                                        SecTestPrintErrorStatus(retStatus);
                                    }

                                    retStatus = MspSecAssocBuildChain(&chainId,
                                                                      destAddr1,
                                                                      NULL,
                                                                      src1Length - maxDestSize,
                                                                      0);

                                    if (retStatus) {
                                        printf("2Build chain failed size: %d\n",src1Length - maxDestSize);
                                        SecTestPrintErrorStatus(retStatus);
                                    }

                                    gatherLoc1 = (uint)destAddr1 + src1Length - maxDestSize;
                                    crossedBorder = 1;
                                } else {
                                    retStatus = MspSecAssocBuildChain(&chainId,
                                                                      (uchar *)gatherLoc0,
                                                                      (uchar *)scatterLoc,
                                                                      src1Length,
                                                                      0);

                                    if (retStatus) {
                                        printf("3Build chain failed size: %d\n",src1Length);
                                        SecTestPrintErrorStatus(retStatus);
                                    }

                                    gatherLoc1 = gatherLoc0 + src1Length;
                                }
                                bytesSoFar = src1Length;
                                scatterLoc = 0;
                            } else {
                                gatherLoc1 = gatherLoc0;
                            }

                            if (src2Length) {
                                if ((!crossedBorder) &&
                                    (bytesSoFar + src2Length > maxDestSize)) {
                                    if (maxDestSize - bytesSoFar)
                                        retStatus = MspSecAssocBuildChain(&chainId,
                                                                          (uchar *)gatherLoc1,
                                                                          (uchar *)scatterLoc,
                                                                          maxDestSize - bytesSoFar,
                                                                          0);

                                    if (retStatus) {
                                        printf("4Build chain failed size: %d\n",maxDestSize - bytesSoFar);
                                        SecTestPrintErrorStatus(retStatus);
                                    }

                                    retStatus = MspSecAssocBuildChain(&chainId,
                                                                      destAddr1,
                                                                      NULL,
                                                                      src2Length - (maxDestSize - bytesSoFar),
                                                                      0);

                                    if (retStatus) {
                                        printf("5Build chain failed size: %d\n",src2Length - (maxDestSize - bytesSoFar));
                                        SecTestPrintErrorStatus(retStatus);
                                    }

                                    gatherLoc2 = (uint)destAddr1 + src2Length - (maxDestSize - src1Length);
                                    crossedBorder = 1;
                                } else {
                                    retStatus = MspSecAssocBuildChain(&chainId,
                                                                      (uchar *)gatherLoc1,
                                                                      (uchar *)scatterLoc,
                                                                      src2Length,
                                                                      0);

                                    if (retStatus) {
                                        printf("6Build chain failed size: %d\n",src2Length);
                                        SecTestPrintErrorStatus(retStatus);
                                    }

                                    gatherLoc2 = gatherLoc1 + src2Length;
                                }
                                bytesSoFar += src2Length;
                                scatterLoc = 0;
                            } else {
                                gatherLoc2 = gatherLoc1;
                            }

                            src3Length = src2TotLength - src2Length;

                            if (!crossedBorder) {
                                if (maxDestSize - bytesSoFar)
                                    retStatus = MspSecAssocBuildChain(&chainId,
                                                                      (uchar *)gatherLoc2,
                                                                      (uchar *)scatterLoc,
                                                                      maxDestSize - bytesSoFar,
                                                                      0);

                                if (retStatus) {
                                    printf("7Build chain failed size: %d\n",maxDestSize - bytesSoFar);
                                    SecTestPrintErrorStatus(retStatus);
                                }

                                retStatus = MspSecAssocBuildChain(&chainId,
                                                                  (uchar *)destAddr1,
                                                                  NULL,
                                                                  src3Length - (maxDestSize - bytesSoFar),
                                                                  0);

                                if (retStatus) {
                                    printf("8Build chain failed size: %d\n",src3Length - (maxDestSize - bytesSoFar));
                                    SecTestPrintErrorStatus(retStatus);
                                }
                                gatherLocIcv = (uint)destAddr1 + (src3Length - (maxDestSize - bytesSoFar));

                            } else {
                                retStatus = MspSecAssocBuildChain(&chainId,
                                                                  (uchar *)gatherLoc2,
                                                                  (uchar *)scatterLoc,
                                                                  src3Length,
                                                                  0);
    
                                if (retStatus) {
                                    printf("9Build chain failed size: %d\n",src3Length);
                                    SecTestPrintErrorStatus(retStatus);
                                }
                                gatherLocIcv = gatherLoc2 + src3Length;

                            }

                        } else {
                            if (src1Length) {
                                retStatus = MspSecAssocBuildChain(&chainId,
                                                                (uchar *)gatherLoc0,
                                                                (uchar *)scatterLoc,
                                                                src1Length,
                                                                0);

                                if (retStatus) {
                                    printf("Build chain failed size: %d\n",src1Length);
                                    SecTestPrintErrorStatus(retStatus);
                                }

                                scatterLoc = 0;
                            }

                            gatherLoc1 = gatherLoc0 + src1Length;

                            if (src2Length) {
                                retStatus = MspSecAssocBuildChain(&chainId,
                                                                (uchar *)gatherLoc1,
                                                                (uchar *)scatterLoc,
                                                                src2Length,
                                                                0);

                                if (retStatus) {
                                    printf("Build chain failed size: %d\n",src2Length);
                                    SecTestPrintErrorStatus(retStatus);
                                }
                                scatterLoc = 0;
                            }

                            gatherLoc2 = gatherLoc1 + src2Length;

                            src3Length = src2TotLength - src2Length;

                            retStatus = MspSecAssocBuildChain(&chainId,
                                                            (uchar *)gatherLoc2,
                                                            (uchar *)scatterLoc,
                                                            src3Length,
                                                            0);
    
                            if (retStatus) {
                                printf("Build chain failed size: %d\n",src3Length);
                                SecTestPrintErrorStatus(retStatus);
                            }
                            
                            if (fragmentFrame)
                                gatherLocIcv = (uint)destAddr1;
                            else
                                gatherLocIcv = gatherLoc2 + src3Length;
                        }

                        if (icvLen) {

                            retStatus = MspSecAssocBuildChain(&chainId,
                                                              (uchar *)gatherLocIcv,
                                                              NULL,
                                                              icvLen,
                                                              0);

                            if (retStatus) {
                                printf("Build chain failed icv\n");
                                SecTestPrintErrorStatus(retStatus);
                            }
                        }

                        retStatus = MspSecAssocXChainBlk (associationInIds[cAlgIndex][aAlgIndex],
                                                          chainId,
                                                          nextProtocol);

                        if (retStatus) {
                            printf("Chain op failed size: %d\n",destLength);
                            printf("src1Length:  %d : src2Length : %d src3Length : %d\n",
                                    src1Length,
                                    src2Length,
                                    src3Length);

                            errorFound = 4;
                            SecTestPrintErrorStatus(retStatus);
                        }

                        /* JRR-DEBUG */
                        if (SecTooManyHandled) {
                            printf("Too many loops through comp Q!!!\n");
                            printf("Failed on espin chainblk\n");
                            return;
                        }
                    }
             
                    /* Compare results */
                    tempChar = srcAddr;
                    for (i=0;i<origLength;i++) 
                    {
                        if (*tempChar++ != (i & 0xFF)) 
	                    {
                            if (!errorFound) {
                                totalErrors++;
                                errorFound = 5;
                                /* SecTestResultsLoud = 1; */
                            }
                        }
                    }
     
                    if (SecTestResultsLoud) {
                        tempChar = (uchar *)srcAddr;
                        printf("Decryption:\n");
                        for (i=0;i<origLength;i++) 
                        {
                            printf(" 0x%02x,",*tempChar++);
                            if ((i % 8) == 7)
                                printf("\n");
                        }
             
                        printf("\n");
                        if (errorFound == 5)
                            return;
                    }

                    if (errorFound) {
                        printf("Failed when testing size %d (%d,%d,%d)",splitLength,src1Length,src2Length,src3Length);
                        switch (errorFound) {
                            case 1:
                                printf(" (ESP Header mismatch)\n");
                                break;
                            case 2:
                                printf(" (Seq # mismatch)\n");
                                break;
                            case 3:
                                printf(" (IV mismatch)\n");
                                break;
                            case 4:
                                printf(" (ICV mismatch)\n");
                                break;
                            case 5:
                                printf(" (Final Cmp mismatch)\n");
                                break;
                        }

                        /* errorFound = 0; */
                        if (testingEspOut)
                            oResults[cAlgIndex][aAlgIndex].numberFailed++;
                        else
                            iResults[cAlgIndex][aAlgIndex].numberFailed++;
                    } else {

                        /* JRR-DEBUG */
                        /* printf("Successful pass\n"); */

                        totalPassed++;
                        if (testingEspOut)
                            oResults[cAlgIndex][aAlgIndex].numberPassed++;
                        else
                            iResults[cAlgIndex][aAlgIndex].numberPassed++;
                    }
                    if (errorFound)
                        break;
                }
                opsLeft -= tempOps--;
                printf("\r%u ops left    ",opsLeft); 
#if 0            
                if (errorFound) {
                    printf("\n");
                    printf("\n");
                    break;
                }
#endif            
            }
            printf("  Done with size:  %d\n",origLength);
            printf("  Total Ops:  %d\n",totalOps);
            printf("  Passed:  %d   Failed:  %d\n",totalPassed,totalErrors);

            if (errorFound)
                break;

        }
        if (errorFound)
            break;
        }
        if (errorFound)
            break;
    }

    /* Print results and release associations */
    printf("Final Results:\n");
    printf("CryptA AuthA  ChainOn Rand Size Total Ops Passed    Failed\n");
    printf("------ -----  ------- --------- --------- --------- ---------\n");
    for (cAlgIndex=0;cAlgIndex<5;cAlgIndex++)
        for (aAlgIndex=0;aAlgIndex<5;aAlgIndex++) {
            SecPrintAlgNames(cAlgIndex,aAlgIndex); 
            printf("Esp Inc ");
            printf("%9d",iResults[cAlgIndex][aAlgIndex].sampleSize);
            printf("%10d",iResults[cAlgIndex][aAlgIndex].numberOps);
            printf("%10d",iResults[cAlgIndex][aAlgIndex].numberPassed);
            printf("%10d\n",iResults[cAlgIndex][aAlgIndex].numberFailed);
            SecPrintAlgNames(cAlgIndex,aAlgIndex); 
            printf("Esp Out ");
            printf("%9d",oResults[cAlgIndex][aAlgIndex].sampleSize);
            printf("%10d",oResults[cAlgIndex][aAlgIndex].numberOps);
            printf("%10d",oResults[cAlgIndex][aAlgIndex].numberPassed);
            printf("%10d\n",oResults[cAlgIndex][aAlgIndex].numberFailed);

            MspSecAssocFree(associationOutIds[cAlgIndex][aAlgIndex]);
            MspSecAssocFree(associationInIds[cAlgIndex][aAlgIndex]);
        }
    printf("------ -----  ------- --------- --------- --------- ---------\n");
    printf("Totals:                         ");
    printf("%9d %9d %9d\n",totalOps,totalPassed,totalErrors);

#if 0         
    if (errorFound)
        break;
#endif      
    } while(runForever); /* while forever */

    free(destAddr0);
    free(destAddr1);
    free(srcAddr);

    printf("Test Completed with total errors:  %d\n",totalErrors);
}

void MspSecTestAssocXCryptChainAD()
{
    uint                     associationId;
    uint                     chainId;
    uint                     callerRefId;
    uchar                      *destAddress;
    uchar                      *tempAddrPtr;
    uchar                      *tempAddrPtr2;
    uint                     i;
    uint                     retStatus;
    uint                     totalErrors = 0;

    callerRefId = 0x93;

    destAddress = (uchar *)malloc(64);

    associationId = PoloCryptFullSessionId;
    chainId = 0;

    retStatus = MspSecAssocBuildChain(&chainId,
                                      PCSrcData1a,
                                      destAddress,
                                      32,
                                      0);

    if (retStatus) {
        printf("Build chain failed\n");
        SecTestPrintErrorStatus(retStatus);
    }

    retStatus = MspSecAssocBuildChain(&chainId,
                                      PCSrcData1b,
                                      NULL,
                                      16,
                                      0);

    if (retStatus) {
        printf("Build chain failed\n");
        SecTestPrintErrorStatus(retStatus);
    }

    retStatus = MspSecAssocXChainBlk (associationId,
                                      chainId,
                                      0);

    if (retStatus) {
        printf("Chain op failed\n");
        SecTestPrintErrorStatus(retStatus);
    }

    /* Compare results */
    tempAddrPtr = destAddress;
    tempAddrPtr2 = PCExpData1;
    for (i=0;i<48;i++) 
	{
        if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
            printf("Compare Error!\n");
            totalErrors++;
            break;
        }
    }

    if (SecTestResultsLoud) {
        tempAddrPtr = destAddress;
        printf("Got:\n");
        for (i=0;i<48;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }

        tempAddrPtr = PCExpData1;
        printf("Expected:\n");
        for (i=0;i<48;i++) 
	    {
            printf(" 0x%02x,",*tempAddrPtr++);
            if ((i % 4) == 3)
                printf("\n");
        }
    }

    if (!totalErrors) 
        printf("Results compared!\n");

    free(destAddress);
}

void MspSecTestEspOutFragment()
{
	uchar                          *keyValue;
    uchar                          *ivValue;
    uchar                          *hashKeysAddr;
    uint                         hashKeyLength;
    uint                         retStatus;
    uchar                          *espInitialHeader;
    uint                         espOutSessionId;
    uint                         mode;
    uchar                          srcAddr[1600];
    uchar                          destAddr0[1600];
    uchar                          destAddr1[240];
    msp_sec_assoc_params        secParams;
    uint                         i;

    keyValue = PCSecKey6;

    ivValue = PCSecIv6;

    hashKeysAddr = PASecKey4;
    hashKeyLength = 20;

    espInitialHeader = PESecHdr6;

    mode = MSP_SEC_SA_ENG_MODE_ESP_OUT |
           MSP_SEC_SA_CRYPT_ALG_3_DES |
           MSP_SEC_SA_DES_KEY_2_DECRYPT |
           MSP_SEC_SA_HASH_ALG_SHA1 |
           MSP_SEC_SA_USE_CHAINING_VARS |
           MSP_SEC_SA_CRYPT_BLK_ECB |
           MSP_SEC_SA_INTERRUPT_MODE;

    retStatus = MspSecAssocStart(&espOutSessionId,
                                 mode,
                                 keyValue,
                                 hashKeysAddr,
                                 hashKeyLength,
                                 espInitialHeader,
                                 ivValue,
                                 1450);

    if (retStatus)
        SecTestPrintErrorStatus(retStatus);

    printf("espOutSessionId:  0x%x\n",espOutSessionId);

    if (SecTestResultsLoud)
        SecShowSA(espOutSessionId);

    for (i=0;i<1440;i++)
        srcAddr[i] = (i & 0xFF);

    secParams.associationId = espOutSessionId;
    secParams.nextProtocol = 0x06;
    secParams.sourceAddr0 = srcAddr;
    secParams.size0 = 1440;
    secParams.sourceAddr1 = NULL;
    secParams.size1 = 0;
    secParams.destAddr0 = destAddr0;
    secParams.destAddr1 = destAddr1;

    retStatus = MspSecAssocXBlk (&secParams);

    if (SecTestResultsLoud) {
        printf("FirstDest:\n");
        for (i=0;i<1456;i++) 
	    {
            printf(" 0x%02x,",destAddr0[i]);
            if ((i % 8) == 7)
                printf("\n");
        }

        printf("Second dest:\n");
        for (i=0;i<96;i++) 
	    {
            printf(" 0x%02x,",destAddr1[i]);
            if ((i % 8) == 7)
                printf("\n");
        }
    }

}

void MspSecTestGetRandom()
{
    uint     randValue;

    randValue = MspSecAssocGetRandom();

    printf("Random value got:  0x%x\n",randValue);
    
}




#endif

/*
** I seem to recall there being some issues with the endianness of
** the hash initial length field.  Let's test for it...
** No, both take big endian initial lengths.
** Save this anyway, it shows how to do a partial hash.
*/

int
test_init_len_endianness()
{
	static uchar src[128] ;
	static uchar dst1[20] ;
	static uchar dst2[20] ;
	static uchar dst3[20] ;
	MSP_SEC2_SA sa ;
	MSP_SEC2_WQE wqe ;
	int pass ;
	int i ;
	int status ;
	int hashlen ;
	int errors = 0 ;

	for (i = 0 ; i < 128; i++)
		src[i] = i ;

	memset((char *)&sa, 0, sizeof(sa)) ;

	for (pass = 0 ; pass < 2 ; pass++)
	{
		/* pass 0 is md5, pass 1 is sha1 */
		hashlen = 16 + 4 * pass ;
		
		sa.hash_init_len[0] = 0 ;
		sa.hash_init_len[1] = 0 ;

		/* first, a hash of the whole message, to compare */
		sa.flags = SAFLG_MODE_HASH_PAD ;
		if (!pass)
			sa.flags |= SAFLG_MD5 ;
		else
			sa.flags |= SAFLG_SHA1 ;

		MSP_SEC2_NEW_REQUEST(&wqe, 0, &sa, 0) ;
		MSP_SEC2_ADD_SG(&wqe, SG_GATHER, src, 128) ;
		MSP_SEC2_ADD_SG(&wqe, SG_SCATTER, dst1, hashlen) ;
		status = MSP_SEC2_END_REQUEST(&wqe) ;

		if (status)
			printf("Warning: bad status from security engine %x\n",
			       status) ;

		/* now, get a partial has of the first 64 bytes */
		sa.flags ++ ;	/* HASH_PAD --> HASH */

		MSP_SEC2_NEW_REQUEST(&wqe, 0, &sa, 0) ;
		MSP_SEC2_ADD_SG(&wqe, SG_GATHER, src, 64) ;
		MSP_SEC2_ADD_SG(&wqe, SG_SCATTER, sa.hash_chain_a, hashlen) ;
		status = MSP_SEC2_END_REQUEST(&wqe) ;

		if (status)
			printf("Warning: partial hash status %x\n",
			       status) ;

		/* Now, try and get the answer with "big endian" init_len */
		sa.hash_init_len[0] = 0 ;
		sa.hash_init_len[1] = 0x200 ;
		sa.flags |= SAFLG_CV ;
		sa.flags -- ;	/* HASH --> HASH_PAD */

		MSP_SEC2_NEW_REQUEST(&wqe, 0, &sa, 0) ;
		MSP_SEC2_ADD_SG(&wqe, SG_GATHER, src + 64, 64) ;
		MSP_SEC2_ADD_SG(&wqe, SG_SCATTER, dst2, hashlen) ;
		status = MSP_SEC2_END_REQUEST(&wqe) ;

		if (status)
			printf("Warning: partial hash status %x\n",
			       status) ;

		/* Now, try and get the answer with "little endian" init_len */
		sa.hash_init_len[0] = 0x00400000 ;
		sa.hash_init_len[1] = 0 ;

		MSP_SEC2_NEW_REQUEST(&wqe, 0, &sa, 0) ;
		MSP_SEC2_ADD_SG(&wqe, SG_GATHER, src + 64, 64) ;
		MSP_SEC2_ADD_SG(&wqe, SG_SCATTER, dst3, hashlen) ;
		status = MSP_SEC2_END_REQUEST(&wqe) ;

		if (status)
			printf("Warning: partial hash status %x\n",
			       status) ;

		if (! memcmp(dst1, dst2, hashlen))
		{
			printf("%s takes big endian init_len\n",
			       pass ? "SHA1" : "MD5" ) ;
		}
		else if (! memcmp(dst1, dst2, hashlen))
		{
			printf("%s takes little endian init_len\n",
			       pass ? "SHA1" : "MD5" ) ;
		}
		else
		{
			errors ++ ;
			printf("%s error in endian test...\n",
			       pass ? "SHA1" : "MD5" ) ;

			printf("sa:\n") ;
			for(i = 0 ; i < sizeof (sa) ; i++)
			{
				if (i % 16 == 0)
					printf("%04x:", i) ;
				printf(" %02x", ((uchar*)&sa)[i] & 0xff) ;
				if (i % 16 == 15)
					printf("\n") ;
			}
			if (i % 16 != 0)
				printf("\n") ;
			
			printf("src:\n") ;
			for(i = 0 ; i < sizeof (src) ; i++)
			{
				if (i % 16 == 0)
					printf("%04x:", i) ;
				printf(" %02x", ((uchar*)&src)[i] & 0xff) ;
				if (i % 16 == 15)
					printf("\n") ;
			}
			if (i % 16 != 0)
				printf("\n") ;
			
		
			printf("dst1:\n") ;
			for(i = 0 ; i < sizeof (dst1) ; i++)
			{
				if (i % 16 == 0)
					printf("%04x:", i) ;
				printf(" %02x", ((uchar*)&dst1)[i] & 0xff) ;
				if (i % 16 == 15)
					printf("\n") ;
			}
			if (i % 16 != 0)
				printf("\n") ;
			
			printf("dst2:\n") ;
			for(i = 0 ; i < sizeof (dst2) ; i++)
			{
				if (i % 16 == 0)
					printf("%04x:", i) ;
				printf(" %02x", ((uchar*)&dst2)[i] & 0xff) ;
				if (i % 16 == 15)
					printf("\n") ;
			}
			if (i % 16 != 0)
				printf("\n") ;
			
			printf("dst3:\n") ;
			for(i = 0 ; i < sizeof (dst3) ; i++)
			{
				if (i % 16 == 0)
					printf("%04x:", i) ;
				printf(" %02x", ((uchar*)&dst3)[i] & 0xff) ;
				if (i % 16 == 15)
					printf("\n") ;
			}
			if (i % 16 != 0)
				printf("\n") ;
			
		}
		
		
	}
	return errors != 0 ;
}

	

int
main(int argc, char **argv)
{
	int testnum ;

	test_init_len_endianness() ;
	MspSecTestAssocStartAll();
	printf("------------------------------\n") ;
	sleep(3) ;
	printf("------------------------------\n") ;
	if (argc > 1)
	{
		testnum = atoi(argv[1]) ;
		MspSecTestAssocX(testnum) ;
	}
	else
		MspSecTestAssocXAllVec() ;

	printf("total errors %d\n", GlobalErrors) ;

	return GlobalErrors ? 1 : 0 ;
}
