/*
 $Header: /proj/software/pub/CVSROOT/uClinux/brecis/pe_api/mspPeSerial.c,v 1.2 2002/01/25 17:17:11 prakity Exp $
 */
/******************************************************************/
/* Copyright (c) 2001 Brecis Communications						  */
/*	This software is the property of Brecis Communications		  */
/*		and may not be copied or distributed in any form without  */
/*		a prior licensing arrangement.							  */
/******************************************************************/

/******************************************************************/
/* mspPeSerial.c												  */
/******************************************************************/

/******************************************************************/
/*																  */
/* modification history											  */
/* --------------------											  */
/* Begun			Tuesday January 23, 2001					  */
/* First version (VxSim bld)	Thursday April 5, 2001			  */
/*																  */
/******************************************************************/

/******************************************************************/
/*																  */
/* DESCRIPTION:													  */
/* This is the main file for serialized functions for the Packet  */
/* engine API.	Most of these routines are scheduled by functions */
/* in the mspPeMain.c file.	 The rest are internally used.		  */
/*																  */
/* AUTHOR:	John Rhodes											  */
/*																  */
/* INCLUDE FILES: mspPeSerial.h									  */
/*				  common.h										  */
/*				  mspBufStruct.h								  */
/*				  mspPeUsr.h									  */
/*				  mspPeDefs.h									  */
/*				  errorGlobalMsp.h								  */
/*				  macrosDef.h									  */
/*																  */
/******************************************************************/

/* includes */
/* All vxworks and msp includes are in this file */
#include <cacheLib.h>
#include "mspvx.h"
#include "hal_api/includeMsp.h"
#include "hal_api/mspBufProto.h"
#include "sys/MspSysApi.h"
#include "hal_api/mspPeCom.h"
#include "hal_api/pe_api/MspPed.h"
#include "hal_api/mspPeDef.h"
#include "hal_api/mspPeStruct.h"

#include "mspPePrivateDef.h"
#include "mspPePrivateStruct.h"
#include "mspPePrivateProto.h"


#define PREF_LOAD(arg)	\
		({ __asm__ volatile (".set push; .set mips4; pref 0, (%0); .set pop" \
		: : "r" (arg)); })
/* Globals */

/* Global FE structure definition */
msp_pe_global_stats	  GlobalFE;
msp_pe_global_stats	  *FE = &GlobalFE;

/* FE VC stats structure definition */
msp_pe_global_vc_stats		 GlobalVC[MSP_PE_MAX_VCS];
msp_pe_global_vc_stats		 *VC[MSP_PE_MAX_VCS];

U32						FEFirstVcIndex;
U32						FELastVcIndex;

U32						PeFirstVcHandle;
U32						PeFirstCidHandle;

/* FE CID stats structure definition */
msp_pe_global_cid_stats		  GlobalCID[MSP_PE_MAX_CIDS];
msp_pe_global_cid_stats		  *CID[MSP_PE_MAX_CIDS];

U32						FEFirstCidIndex;
U32						FELastCidIndex;

/* Event Queue definitions */
msp_ped_gen_rsp *FEEventQueue;

U32		FEEventFirst;
U32		FEEventLast;
U32		FEEventHead;

/* In-Use array indicating whether a VC is in use */
U32		FEVcInUse[MSP_PE_MAX_VCS];

/* Helps avoid needless scheduling of DPR */
static U32	PeNoPendingJob = 1;


/* DEBUG VARIABLES */
U32			PeTotalTx;
U32			PeTotalTxSer;
U32			PeTotalTxCD;
U32			PeTotalTxHan;
U32			PeTotalTxErr;
U32			PeTotalRx;
U32			PeTotalRxErr;
U32			PeTotalTxAlloc;
U32			PeTotalRxAlloc;
U32			PeTotalTxFree;
U32			PeTotalRxFree;
U32			PeTotalTxBdRing;
U32			PeTotalRxBdRing;
U32			PeMaxOutTxBdRing;
U32			PeMaxOutRxBdRing;

/* Externs */


/* Globals to hold blocking function info */
extern U32	FeStartComplete;
extern U32	FeStartStatus;

extern U32	FeConfigComplete;
extern U32	FeConfigStatus;

extern U32	PeGetPeStatsComplete;
extern U32	PeGetPeStatsStatus;

extern U32	FeUtopiaComplete;
extern U32	FeUtopiaStatus;

extern U32	FeNokiaComplete;
extern U32	FeNokiaStatus;

extern U32	FeSatmComplete;
extern U32	FeSatmStatus;

extern U32	FeHdlcComplete;
extern U32	FeHdlcStatus;

extern U32	PeEnaPhyStatus;
extern U32	PeEnaPhyComplete;

extern U32	PeDisPhyStatus;
extern U32	PeDisPhyComplete;

extern U32	PeCfgL2Status;
extern U32	PeCfgL2Complete;

extern U32	PeUpdLSStatus;
extern U32	PeUpdLSComplete;

extern U32	PeGetPhyStatsComplete;
extern U32	PeGetPhyStatsStatus;

extern U32	FeAddAtmVcStatus;
extern U32	FeAddAtmVcHandle;
extern U32	FeAddAtmVcComplete;

extern U32	FeAddFrVcStatus;
extern U32	FeAddFrVcHandle;
extern U32	FeAddFrVcComplete;

extern U32	FeAddHdlcVcStatus;
extern U32	FeAddHdlcVcHandle;
extern U32	FeAddHdlcVcComplete;

extern U32	FeDelVcStatus;
extern U32	FeDelVcComplete;

extern U32	FeEnableVcStatus;
extern U32	FeEnableVcComplete;

extern U32	FeDisableVcStatus;
extern U32	FeDisableVcComplete;

extern U32	FeModAtmVcStatus;
extern U32	FeModAtmVcComplete;

extern U32	FeModFrVcStatus;
extern U32	FeModFrVcComplete;

extern U32	FeModVcCBStatus;
extern U32	FeModVcCBComplete;

extern U32	FeAddCidStatus;
extern U32	FeAddCidHandle;
extern U32	FeAddCidComplete;

extern U32	FeDelCidStatus;
extern U32	FeDelCidComplete;

extern U32	FeModCidStatus;
extern U32	FeModCidComplete;

extern msp_buf_fifo					   *PESerialFifoBig;

extern U32			PeDbgReadMemBufAddr;
extern U32			PeDbgReadMemBufWSize;

/* The following are defined in sysLib.c */
extern U32	sysCalcPllClk();
extern U32	sysCalcPeClk();


/* Semaphore for blocking functions' use */
extern SEM_ID		mspPeStartSemId;
extern SEM_ID		mspPeConfigSemId;
extern SEM_ID		mspPeGetPeSemId;
extern SEM_ID		mspPeUtopiaSemId;
extern SEM_ID		mspPeNokiaSemId;
extern SEM_ID		mspPeSatmSemId;
extern SEM_ID		mspPeHdlcSemId;
extern SEM_ID		mspPeEnaPhySemId;
extern SEM_ID		mspPeDisPhySemId;
extern SEM_ID		mspPeCfgL2SemId;
extern SEM_ID		mspPeUpdLSSemId;
extern SEM_ID		mspPeGetPhySemId;
extern SEM_ID		mspPeAddAtmVcSemId;
extern SEM_ID		mspPeAddFrVcSemId;
extern SEM_ID		mspPeAddHdlcVcSemId;
extern SEM_ID		mspPeDelVcSemId;
extern SEM_ID		mspPeEnaVcSemId;
extern SEM_ID		mspPeDisVcSemId;
extern SEM_ID		mspPeModAtmVcSemId;
extern SEM_ID		mspPeModFrVcSemId;
extern SEM_ID		mspPeModVcCBSemId;
extern SEM_ID		mspPeGetAtmVcSemId;
extern SEM_ID		mspPeGetFrVcSemId;
extern SEM_ID		mspPeGetHdlcVcSemId;
extern SEM_ID		mspPeAddCidSemId;
extern SEM_ID		mspPeDelCidSemId;
extern SEM_ID		mspPeModCidSemId;
extern SEM_ID		mspPeGetCidSemId;
extern SEM_ID		mspPeDbgReadMemSemId;

/* DEBUG DEBUG DEBUG */
U32		JohnError;


/******************************************************************/
/*																  */
/* MspPeGetTxBDMem												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine calls the generic MspPeGetMem for the specific	  */
/* number of transmit buffer descriptors						  */
/*																  */
/* PARAMETERS:													  */
/*			   numBDs-	number of Buffer descriptors required	  */
/*																  */
/* RETURNS:														  */
/*			   pointer to allocated memory						  */
/*																  */
/******************************************************************/
static msp_ped_txbd	   *MspPeGetTxBDMem(U32	 numBDs) 
{
	U32				byteSize; 
	char			*mem; 
	char			*mem1; 

	byteSize = numBDs * sizeof(msp_ped_txbd); 

	mem = memalign(MSP5000_CACHE_DATA_LINE_SIZE,byteSize);

	if (((U32) mem & ~0xffff) == (((U32) mem+byteSize) & ~0xffff))
		return (msp_ped_txbd *) mem;

	mem1 = memalign(MSP5000_CACHE_DATA_LINE_SIZE, byteSize);

	if (mem != NULL)
		free (mem);

	if (((U32) mem1 & ~0xffff) == (((U32) mem1+byteSize) & ~0xffff))
		return (msp_ped_txbd *) mem1;
	
	if (mem1 != NULL)
		free (mem1);

	printf ("Cannot allocate memory in 64k boundary\n");
	return NULL;
}

/******************************************************************/
/*																  */
/* MspPeGetRxBDMem												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine calls the generic MspPeGetMem for the specific	  */
/* number of receive buffer descriptors							  */
/*																  */
/* PARAMETERS:													  */
/*			   numBDs-	number of Buffer descriptors required	  */
/*																  */
/* RETURNS:														  */
/*			   pointer to allocated memory						  */
/*																  */
/******************************************************************/
static msp_ped_rxbd	   *MspPeGetRxBDMem(U32	 numBDs) 
{
	U32			byteSize;
	char		*mem;
	char		*mem1;

	byteSize = numBDs * sizeof(msp_ped_rxbd);
	mem = memalign(MSP5000_CACHE_DATA_LINE_SIZE, byteSize);

	if (((U32) mem & ~0xffff) == (((U32) mem+byteSize) & ~0xffff))
		return (msp_ped_rxbd *) mem;

	mem1 = memalign(MSP5000_CACHE_DATA_LINE_SIZE, byteSize);

	if (mem != NULL)
		free (mem);

	if (((U32) mem1 & ~0xffff) == (((U32) mem1+byteSize) & ~0xffff))
		return (msp_ped_rxbd *) mem1;
	
	if (mem1 != NULL)
		free (mem1);

	printf ("Cannot allocate memory in 64k boundary\n");
	return NULL;
}


/******************************************************************/
/*																  */
/* MspPeFindDirectCidHandle										  */
/*																  */
/* DESCRIPTION:													  */
/*			  This routine is called to find the Direct Cid		  */
/*			  Handle given the API Cid Handle					  */
/*																  */
/* PARAMETERS:													  */
/*			   The API Cid handle (index into the CID array)	  */
/*																  */
/* RETURNS:														  */
/*			   The direct Cid handle							  */
/*																  */
/******************************************************************/
U32 MspPeFindDirectCidHandle(U32 PeCidHandle)
{
	if (CID[peCidHandle]->PedCidHandle != 0)
		return(CID[peCidHandle]->PedCidHandle);

	return (999);
}

#if 0
/******************************************************************/
/*																  */
/* MspPeFindCidFrameLength										  */
/*																  */
/* DESCRIPTION:													  */
/*			  This routine is called to find a CID's frame length */
/*			  given the API CID Handle							  */
/*																  */
/* PARAMETERS:													  */
/*			   The API Cid handle (index into the CID array)	  */
/*																  */
/* RETURNS:														  */
/*			   The CID Frame Length								  */
/*																  */
/******************************************************************/
U32 MspPeFindCidFrameLength(U32	   PeCidHandle)
{
	if (CID[peCidHandle]->FrameLength != 0)
		return(CID[peCidHandle]->FrameLength);

	return (999);
}
#endif



/*
 *******************************************************************																 
 * MspPeHandleConfig											  
 *																  
 *																 
 * DESCRIPTION:													  
 * This is an internally used routine that handles the PE		  
 * config event.												  
 *																  
 * PARAMETERS:	pRsp-  pointer to the response from the cmd
 *******************************************************************
 */

static void MspPeHandleConfig(msp_ped_cmd_rsp *pRsp)
{
#ifdef PE_CFG_DEBUG
	printf("HE/HC (SER):  Entering Handle Config routine\n");
#endif

	FeConfigStatus = pRsp->CmdStatus;
	FeConfigComplete = 1;
}

/******************************************************************/
/*																  */
/* MspPeHandleUtopiaConfig										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the Utopia	  */
/* config event.												  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleUtopiaConfig(msp_ped_cmd_rsp *pRsp)
{
#ifdef PE_UTOPIA_DEBUG
	printf("HE/HU (SER):  Entering Handle Utopia Config routine\n");
#endif

	FeUtopiaStatus = pRsp->CmdStatus;
	FeUtopiaComplete = 1;
}

/******************************************************************/
/*																  */
/* MspPeHandleNokiaConfig										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the Nokia	  */
/* config event.												  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleNokiaConfig(msp_ped_cmd_rsp *pRsp)
{
#ifdef PE_NOKIA_DEBUG
	printf("HE/HN (SER):  Entering Handle Nokia Config routine\n");
#endif

	FeNokiaStatus = pRsp->CmdStatus;
	FeNokiaComplete = 1;
}

/******************************************************************/
/*																  */
/* MspPeHandleSatmConfig										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the Satm		  */
/* config event.												  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleSatmConfig(msp_ped_cmd_rsp *pRsp)
{
	msp_buf		*serBuf;

#ifdef PE_SATM_DEBUG
	printf("HE/HSATM (SER):	 Entering Handle Satm Cfg routine\n");
#endif

	serBuf = (msp_buf *)pRsp->HsHandle;
	MspFIFOBufInUsePut(PESerialFifoBig, serBuf);

	FeSatmStatus = pRsp->CmdStatus;
	FeSatmComplete = 1;
	
#ifdef PE_SATM_DEBUG
	printf("HE/HSATM (SER):	 Giving Satm Config semaphore\n");
#endif

	SEMGIVE(mspPeSatmSemId);
}

/******************************************************************/
/*																  */
/* MspPeHandleHdlcConfig										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the PE Hdlc	  */
/* config event.												  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleHdlcConfig(msp_ped_cmd_rsp *pRsp)
{
	msp_buf		*serBuf;

#ifdef PE_HDLC_DEBUG
	printf("HE/HHDLC (SER):	 Entering Handle Hdlc Cfg routine\n");
#endif

	serBuf = (msp_buf *)pRsp->HsHandle;
	MspFIFOBufInUsePut(PESerialFifoBig, serBuf);

	FeHdlcStatus = pRsp->CmdStatus;
	FeHdlcComplete = 1;
	SEMGIVE(mspPeHdlcSemId);
}

/******************************************************************/
/*																  */
/* MspPeHandleEnablePhy											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the EnablePhy  */
/* event.														  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleEnablePhy(msp_ped_cmd_rsp *pRsp)
{
	U32 InterfaceNum;

	InterfaceNum = pRsp->HsHandle;
		
	if (pRsp->CmdStatus == MSP_SUCCESS)
		FE->PhyEna[InterfaceNum] = 1;

	PeEnaPhyStatus = pRsp->CmdStatus;
	PeEnaPhyComplete = 1;
	SEMGIVE(mspPeEnaPhySemId);
}

/******************************************************************/
/*																  */
/* MspPeHandleDisablePhy										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the DisablePhy */
/* event.														  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleDisablePhy(msp_ped_cmd_rsp *pRsp)
{
	if (pRsp->CmdStatus == MSP_SUCCESS)
		FE->PhyEna[pRsp->HsHandle] = 0;

	PeDisPhyStatus = pRsp->CmdStatus;
	PeDisPhyComplete = 1;
	SEMGIVE(mspPeDisPhySemId);
}

/******************************************************************/
/*																  */
/* MspPeHandleCfgHdlcL2											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the CfgHdlcL2  */
/* event.														  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleCfgHdlcL2(msp_ped_cmd_rsp *pRsp)
{
	PeCfgL2Status = pRsp->CmdStatus;
	PeCfgL2Complete = 1;
	SEMGIVE(mspPeCfgL2SemId);
}

/******************************************************************/
/*																  */
/* MspPeHandleUpdateLS											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the UpdateLS	  */
/* event.														  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleUpdateLS(msp_ped_cmd_rsp *pRsp)
{
	msp_buf		*serBuf;

#ifdef PE_HUPDLS_DEBUG
	printf("HE/HHUPDLS (SER):  Entering Handle Update LS routine\n");
#endif

	serBuf = (msp_buf *)pRsp->HsHandle;
	MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);

	PeUpdLSStatus = pRsp->CmdStatus;
	PeUpdLSComplete = 1;
	SEMGIVE(mspPeUpdLSSemId);
}

/* LEFTOFF HERE-   NEED TO ADD HANDLING THE RETURN OF THE MSP_BUF */

/******************************************************************/
/*																  */
/* MspPeHandleAddVc												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the AddAtmVc,  */
/* AddFrVc, and AddHdlcVc events.								  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleAddVc(msp_ped_cmd_rsp *pRsp)
{
	msp_buf					*serBuf;
	msp_pe_resp				respStruct;
	msp_ped_rxbd_update		xCmd;
	msp_ped_rxbd_update		*pRxCmd= &xCmd;
	U32						peVcHandle;
	U32						tempVcHandle;
	U32						status;
	
#ifdef PE_ADD_ATM_DEBUG
	printf("HE/HADV (SER):	Entering HandleAddVC\n");
#endif
	/* Set the PeVcHandle and call completion	*/
	/* function for particular VC				*/
	respStruct.Status = pRsp->CmdStatus;
	peVcHandle = pRsp->HsHandle;
	serBuf = VC[peVcHandle]->AddSerBufAddr;

	MspFIFOBufInUsePut(PESerialFifoBig, serBuf);
	respStruct.CallerRefId = VC[peVcHandle]->AddRefId;
		
	if (pRsp->CmdStatus == MSP_SUCCESS) 
	{
		/* We successfully added the VC */
		FE->NumberVCs++;
		VC[peVcHandle]->used = 1;

		/* Set the last VC added NextPeVcHandle field */
		tempVcHandle = PeFirstVcHandle;
		
		/* Traverse the list to the end */
		while (tempVcHandle) 
		{ 
			tempVcHandle = VC[tempVcHandle]->NextPeVcHandle;
		}

		/* Insert the VC at the end of the linked list */
		if (PeFirstVcHandle)
			VC[tempVcHandle]->NextPeVcHandle = peVcHandle;
		else
			PeFirstVcHandle = peVcHandle;

		/* Set the PedVcHandle */
		VC[peVcHandle]->PedVcHandle =  pRsp->RspParm1;

		/* Set the PeVcHandle */
		respStruct.PePar1 = peVcHandle;

		pRxCmd->CmdId = MSP_PED_RXBD_UPDATE_CMD;
		pRxCmd->HsHandle = peVcHandle;
		pRxCmd->PedVcHandle = VC[peVcHandle]->PedVcHandle;
		pRxCmd->RxBdPtr = VC[peVcHandle]->RxFwPtr;

#ifdef PE_ADD_ATM_DEBUG
		printf("HE/HADV (SER):	HandleAddVC sending rxbdupdate cmd\n");
#endif
		/* Copy from driver's cmd queue into FE cmd queue */
		TriadBcopy( (U32)pRxCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_rxbd_update));

	} 
	else 
	{
		VC[peVcHandle]->used = 0;
#ifdef PE_ADD_ATM_DEBUG
		printf("HE/HADV (SER):	AddVc failed\n");
#endif
	}
	
	(*VC[peVcHandle]->completeFunc)(&respStruct);

#ifdef PE_ADD_ATM_DEBUG
	printf("HE/HADV (SER):	Exiting HandleAddVC\n");
#endif

}
		
/******************************************************************/
/*																  */
/* MspPeHandleDelVc												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the DelVC	  */
/* event.														  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleDelVc(msp_ped_cmd_rsp *pRsp)
{
	msp_pe_resp		respStruct;
	U32				peVcHandle;
	U32				tempVcHandle;
	
	/* Set the PeVcHandle and call completion	*/
	/* function for particular VC				*/
	respStruct.Status = pRsp->CmdStatus;
	peVcHandle = pRsp->HsHandle;
	respStruct.CallerRefId = VC[peVcHandle]->DelRefId;
	   
	if (pRsp->CmdStatus == MSP_SUCCESS) 
	{
		/* We successfully deleted the VC */
		FE->NumberVCs--;
		VC[peVcHandle]->used = 0;

		/* Remove VC from linked list of used VCs */
		if (PeFirstVcHandle == peVcHandle) 
		{
			PeFirstVcHandle = VC[peVcHandle]->NextPeVcHandle;
			VC[peVcHandle]->NextPeVcHandle=0;
		} 
		else 
		{
			tempVcHandle = PeFirstVcHandle;
			while (tempVcHandle) 
			{
				if (VC[tempVcHandle]->NextPeVcHandle == peVcHandle) {
					VC[tempVcHandle]->NextPeVcHandle =
										VC[peVcHandle]->NextPeVcHandle;
					VC[peVcHandle]->NextPeVcHandle=0;
					break;
				}
				tempVcHandle = VC[tempVcHandle]->NextPeVcHandle;
			}
		}

		/* Free Memory Associate with Rx Buffer Descriptors */
		free(VC[peVcHandle]->RxBDs);

		/* Free Rx Msp Fifo */
		MspFIFOBufDeallocate(VC[peVcHandle]->RxMspFifo);

		/* Free Memory Associate with Tx Buffer Descriptors */
		free(VC[peVcHandle]->TxBDs);

		/* Free Tx Msp Fifo */
		MspFIFOBufDeallocate(VC[peVcHandle]->TxMspFifo);
		VC[peVcHandle]->PedVcHandle = 0;
	} 
	
	(*VC[peVcHandle]->completeFunc)(&respStruct);
}

/******************************************************************/
/*																  */
/* MspPeHandleEnableVc											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the EnableVC	  */
/* event.														  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleEnableVc(msp_ped_cmd_rsp *pRsp)
{
	msp_pe_resp		respStruct;
	U32				peVcHandle;
	
	/* Set the PeVcHandle and call completion	*/
	/* function for particular VC				*/
	respStruct.Status = pRsp->CmdStatus;
	peVcHandle = pRsp->HsHandle;
	respStruct.CallerRefId = VC[peVcHandle]->EnaRefId;

#ifdef PE_ENAVC_DEBUG
	printf("HE/ENAVC:  Entering Handle Enable VC\n");
#endif

	if (pRsp->CmdStatus == MSP_SUCCESS)
		/* We successfully enabled the VC */
		VC[peVcHandle]->Enabled = 1;
	
	(*VC[peVcHandle]->EDcompleteFunc)(&respStruct);

#ifdef PE_ENAVC_DEBUG
	printf("HE/ENAVC:  Exiting Handle Enable VC\n");
#endif

}

/******************************************************************/
/*																  */
/* MspPeHandleDisableVc											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the DisableVC  */
/* event.														  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleDisableVc(msp_ped_cmd_rsp *pRsp)
{
	msp_pe_resp		respStruct;
	U32				peVcHandle;
	
	/* Set the PeVcHandle and call completion	*/
	/* function for particular VC				*/
	respStruct.Status = pRsp->CmdStatus;
	peVcHandle = pRsp->HsHandle;
	respStruct.CallerRefId = VC[peVcHandle]->DisRefId;
		
	if (pRsp->CmdStatus == MSP_SUCCESS)
		/* We successfully disabled the VC */
		VC[peVcHandle]->Enabled = 0;
	
	(*VC[peVcHandle]->EDcompleteFunc)(&respStruct);
}

/******************************************************************/
/*																  */
/* MspPeHandleModVc												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the ModAtmVc	  */
/* and ModFrVc events.											  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleModVc(msp_ped_cmd_rsp *pRsp)
{
	msp_buf			*serBuf;
	msp_pe_resp		respStruct;
	U32				*pVCHan;
	U32				peVcHandle;
	
	/* Set the PeVcHandle and call completion	*/
	/* function for particular VC				*/
	respStruct.Status = pRsp->CmdStatus;
	serBuf = (msp_buf *)pRsp->HsHandle;
	pVCHan = (U32 *)serBuf->dataBuffer;
	peVcHandle = *pVCHan;
	MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);
	respStruct.CallerRefId = VC[peVcHandle]->ModRefId;

	(*VC[peVcHandle]->MODcompleteFunc)(&respStruct);
}

/******************************************************************/
/*																  */
/* MspPeHandleGetVcStats										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the			  */
/* GetVcStats event.											  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/
static void MspPeHandleGetVcStats(msp_ped_cmd_rsp *pRsp)
{
	msp_buf					*serBuf;
	msp_pe_vc_stats_pars	*pGetPars;
	msp_pe_resp				respStruct;
	msp_pe_vc_stats_atm		AStats;
	msp_pe_vc_stats_fr		FStats;
	msp_pe_vc_stats_hdlc	HStats;
	U32						peVcHandle;
	
	/* Set the status and call the completion function */
	respStruct.Status = pRsp->CmdStatus;
		
	serBuf = (msp_buf *)pRsp->HsHandle;
	pGetPars = (msp_pe_vc_stats_pars *)serBuf->dataBuffer;
	respStruct.CallerRefId = pGetPars->CallerRefId;

	peVcHandle = pGetPars->PeVcHandle;

	/* Fill in status in serBuf for blocking calls */
	pGetPars->Status = pRsp->CmdStatus;

	/* Fill in the stats fields if Response Status is	*/
	/* success and this is a non-blocking function.		*/
	if ((pRsp->CmdStatus == MSP_SUCCESS) 
	&& (!(pGetPars->IsBlockingCall))) 
	{
		switch (pGetPars->VcType) 
		{
			case PE_VCTYPE_ATM:
				AStats.CurrPeVcHandle = peVcHandle;
				AStats.NextPeVcHandle = VC[peVcHandle]->NextPeVcHandle;

				AStats.VcCfg.PhyDevice.InterfaceNum =
					VC[peVcHandle]->AtmVcFlds.PhyDevice.InterfaceNum;
				AStats.VcCfg.PhyDevice.PhyAddr =
					VC[peVcHandle]->AtmVcFlds.PhyDevice.PhyAddr;
				AStats.VcCfg.Vpi = VC[peVcHandle]->AtmVcFlds.Vpi;
				AStats.VcCfg.Vci = VC[peVcHandle]->AtmVcFlds.Vci;
				AStats.VcCfg.VcType = VC[peVcHandle]->AtmVcFlds.VcType;
				AStats.VcCfg.ParMod.SrvType =
					VC[peVcHandle]->AtmVcFlds.ParMod.SrvType;
				AStats.VcCfg.ParMod.PeakCellRate =
					VC[peVcHandle]->AtmVcFlds.ParMod.PeakCellRate;
				AStats.VcCfg.ParMod.SustainedCellRate = 
					VC[peVcHandle]->AtmVcFlds.ParMod.SustainedCellRate;
				AStats.VcCfg.ParMod.MaxBurstSize =
					VC[peVcHandle]->AtmVcFlds.ParMod.MaxBurstSize;
				AStats.VcCfg.ParMod.MinCellRate =
					VC[peVcHandle]->AtmVcFlds.ParMod.MinCellRate; 
				AStats.VcCfg.ParMod.VcFlags =
					VC[peVcHandle]->AtmVcFlds.ParMod.VcFlags;
				AStats.VcCfg.ParMod.VoiceProtocolType =
					VC[peVcHandle]->AtmVcFlds.ParMod.VoiceProtocolType;
				AStats.VcCfg.ParMod.MTU =
					VC[peVcHandle]->AtmVcFlds.ParMod.MTU;
				AStats.VcCfg.ParMod.MRU = 
					VC[peVcHandle]->AtmVcFlds.ParMod.MRU;
		
				cacheInvalidate(DATA_CACHE,
								&pGetPars->VcStats.AtmStats,
								sizeof(msp_pe_vc_stats_atm_com));
		
				AStats.ComFlds.TxCells =
					pGetPars->VcStats.AtmStats.TxCells;
				AStats.ComFlds.RxCells =
					pGetPars->VcStats.AtmStats.RxCells;
				AStats.ComFlds.TxOamCells =
					pGetPars->VcStats.AtmStats.TxOamCells;
				AStats.ComFlds.RxOamCells =
					pGetPars->VcStats.AtmStats.RxOamCells;
				AStats.ComFlds.RxCrcErrs =
					pGetPars->VcStats.AtmStats.RxCrcErrs;
				AStats.ComFlds.RxNoRxBdErrs =
					pGetPars->VcStats.AtmStats.RxNoRxBdErrs;
				AStats.ComFlds.RxCellsDropped =
					pGetPars->VcStats.AtmStats.RxCellsDropped;
				AStats.ComFlds.TxAal5Pdus =
					pGetPars->VcStats.AtmStats.TxAal5Pdus;
				AStats.ComFlds.RxAal5Pdus =
					pGetPars->VcStats.AtmStats.RxAal5Pdus;
				AStats.ComFlds.RxAal5PdusDropped =
					pGetPars->VcStats.AtmStats.RxAal5PdusDropped;
				AStats.ComFlds.RxAal5PduTooLong =
					pGetPars->VcStats.AtmStats.RxAal5PduTooLong;
				AStats.ComFlds.RxAal5InvCpiErrs =
					pGetPars->VcStats.AtmStats.RxAal5InvCpiErrs;
				AStats.ComFlds.RxAal5AbortedPdus =
					pGetPars->VcStats.AtmStats.RxAal5AbortedPdus;
				AStats.ComFlds.RxAal5InvLenErrs =
					pGetPars->VcStats.AtmStats.RxAal5InvLenErrs;
				AStats.ComFlds.RxAal2SeqNumErrs =
					pGetPars->VcStats.AtmStats.RxAal2SeqNumErrs;
				AStats.ComFlds.RxAal2UnknownCids =
					pGetPars->VcStats.AtmStats.RxAal2UnknownCids;
				break;
			case PE_VCTYPE_FR:
				FStats.CurrPeVcHandle = peVcHandle;
				FStats.NextPeVcHandle = VC[peVcHandle]->NextPeVcHandle;
	
				FStats.VcCfg.PhyDevice.InterfaceNum =
					VC[peVcHandle]->FrVcFlds.PhyDevice.InterfaceNum;
				FStats.VcCfg.PhyDevice.PhyAddr =
					VC[peVcHandle]->FrVcFlds.PhyDevice.PhyAddr;
				FStats.VcCfg.VcType = VC[peVcHandle]->FrVcFlds.VcType; 
				FStats.VcCfg.Dlci = VC[peVcHandle]->FrVcFlds.Dlci;
				FStats.VcCfg.ParMod.Bc =
					VC[peVcHandle]->FrVcFlds.ParMod.Bc;
				FStats.VcCfg.ParMod.Be =
					VC[peVcHandle]->FrVcFlds.ParMod.Be;
				FStats.VcCfg.ParMod.FragmentSize =
					VC[peVcHandle]->FrVcFlds.ParMod.FragmentSize;
				FStats.VcCfg.ParMod.VcFlags =
					VC[peVcHandle]->FrVcFlds.ParMod.VcFlags;
				FStats.VcCfg.ParMod.VoiceProtocolType =
					VC[peVcHandle]->FrVcFlds.ParMod.VoiceProtocolType;
				FStats.VcCfg.ParMod.MTU =
					VC[peVcHandle]->FrVcFlds.ParMod.MTU;
				FStats.VcCfg.ParMod.MRU =
					VC[peVcHandle]->FrVcFlds.ParMod.MRU;

				cacheInvalidate(DATA_CACHE,
								&pGetPars->VcStats.FrStats,
								sizeof(msp_pe_vc_stats_fr_com));

				FStats.ComFlds.TxFrames =
					pGetPars->VcStats.FrStats.TxFrames;
				FStats.ComFlds.RxFrames =
					pGetPars->VcStats.FrStats.RxFrames;
				FStats.ComFlds.TxBytes =
					pGetPars->VcStats.FrStats.TxBytes;
				FStats.ComFlds.RxBytes =
					pGetPars->VcStats.FrStats.RxBytes;
				FStats.ComFlds.RxCrcErrs =
					pGetPars->VcStats.FrStats.RxCrcErrs;
				FStats.ComFlds.NoRxBdErrs =
					pGetPars->VcStats.FrStats.NoRxBdErrs;
				break;
			case PE_VCTYPE_HDLC:
				HStats.CurrPeVcHandle = peVcHandle;
				HStats.NextPeVcHandle = VC[peVcHandle]->NextPeVcHandle;

				HStats.VcCfg.PhyDevice.InterfaceNum =
					VC[peVcHandle]->HdlcVcFlds.PhyDevice.InterfaceNum;
				HStats.VcCfg.PhyDevice.PhyAddr =
					VC[peVcHandle]->HdlcVcFlds.PhyDevice.PhyAddr;
				HStats.VcCfg.MTU = VC[peVcHandle]->HdlcVcFlds.MTU;
				HStats.VcCfg.MRU = VC[peVcHandle]->HdlcVcFlds.MRU;
		
				cacheInvalidate(DATA_CACHE,
								&pGetPars->VcStats.HdlcStats,
								sizeof(msp_pe_vc_stats_hdlc_com));

				HStats.ComFlds.TxFrames =
					pGetPars->VcStats.HdlcStats.TxFrames;
				HStats.ComFlds.RxFrames =
					pGetPars->VcStats.HdlcStats.RxFrames;
				HStats.ComFlds.TxBytes =
					pGetPars->VcStats.HdlcStats.TxBytes;
				HStats.ComFlds.RxBytes =
					pGetPars->VcStats.HdlcStats.RxBytes;
				HStats.ComFlds.RxCrcErrs =
					pGetPars->VcStats.HdlcStats.RxCrcErrs;
				HStats.ComFlds.NoRxBdErrs =
					pGetPars->VcStats.HdlcStats.NoRxBdErrs;
				break;
		}
	}

	if (!(pGetPars->IsBlockingCall))
		MspFIFOBufInUsePut(PESerialFifoBig, serBuf);
		
	/* Call appropriate completion function */	  
	switch (pGetPars->VcType) {
		case PE_VCTYPE_ATM:
			(*pGetPars->AtmCompleteFunc)(&respStruct, &AStats);
			break;
		case PE_VCTYPE_FR:
			(*pGetPars->FrCompleteFunc)(&respStruct, &FStats);
			break;
		case PE_VCTYPE_HDLC:
			(*pGetPars->HdlcCompleteFunc)(&respStruct, &HStats);
			break;
	}

}

/******************************************************************/
/*																  */
/* MspPeHandleAddCid											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the AddCID	  */
/* event.														  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleAddCid(msp_ped_cmd_rsp *pRsp)
{
	msp_buf				*serBuf;
	msp_pe_resp			respStruct;
	U32					*pCidHan;
	U32					peCidHandle;
	U32					tempCidHandle;
	
#ifdef PE_ADD_CID_DEBUG
	printf("HE/HADC (SER):	Entering HandleAddCid\n");
#endif			  
	/* Set the status and call the completion function */
	respStruct.Status = pRsp->CmdStatus;
	serBuf = (msp_buf *)pRsp->HsHandle;
	pCidHan = (U32 *)serBuf->dataBuffer;
	peCidHandle = *pCidHan;
	MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);

	respStruct.CallerRefId = CID[peCidHandle]->AddRefId;
		
	if (pRsp->CmdStatus == MSP_SUCCESS) 
	{
		/* We successfully added the VC */
		FE->NumberCIDs++;
		CID[peCidHandle]->used = 1;

		/* Set the last VC added NextPeVcHandle field */
		tempCidHandle = PeFirstCidHandle;
		/* Traverse the list to the end */
		while (tempCidHandle) 
		{ 
			tempCidHandle = CID[tempCidHandle]->NextPeCidHandle;
		}

		/* Insert the Cid at the end of the linked list */
		if (PeFirstCidHandle)
			CID[tempCidHandle]->NextPeCidHandle = peCidHandle;
		else
			PeFirstCidHandle = peCidHandle;

		/* Set the PedCidHandle */
		CID[peCidHandle]->PedCidHandle = pRsp->RspParm1;
	
		/* Set the FrameLength */
		CID[peCidHandle]->FrameLength = pRsp->RspParm2;

		/* Set the PeCidHandle */
		respStruct.PePar1 = peCidHandle;
		respStruct.PePar2 = CID[peCidHandle]->PeVcHandle;
	} else {
#ifdef PE_ADD_CID_DEBUG
		printf("HE/HADC (SER):	AddCid Failed\n");
#endif			  
	}

	(*CID[peCidHandle]->completeFunc)(&respStruct);

#ifdef PE_ADD_CID_DEBUG
	printf("HE/HADC (SER):	Exiting HandleAddCid\n");
#endif			  
}

/******************************************************************/
/*																  */
/* MspPeHandleDelCid											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the DelCID	  */
/* event.														  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleDelCid(msp_ped_cmd_rsp *pRsp)
{
	msp_pe_resp		respStruct;
	U32				peCidHandle;
	U32				tempCidHandle;
	
	/* Set the status and call the completion function */
	respStruct.Status = pRsp->CmdStatus;
	peCidHandle = pRsp->HsHandle;
	respStruct.CallerRefId = CID[peCidHandle]->DelRefId;
	   
	if (pRsp->CmdStatus == MSP_SUCCESS) {
		/* We successfully deleted the CID */
		FE->NumberCIDs--;
		CID[peCidHandle]->used = 0;
	 
		/* Remove CID from linked list of used CIDs */
		if (PeFirstCidHandle == peCidHandle) {
			PeFirstCidHandle = CID[peCidHandle]->NextPeCidHandle;
			CID[peCidHandle]->NextPeCidHandle=0;
		} else {
			tempCidHandle = PeFirstCidHandle;
			while (tempCidHandle) {
				if (CID[tempCidHandle]->NextPeCidHandle == peCidHandle) 
				{
					CID[tempCidHandle]->NextPeCidHandle =
										CID[peCidHandle]->NextPeCidHandle;
					CID[peCidHandle]->NextPeCidHandle =0;
					break;
				}
				tempCidHandle = CID[tempCidHandle]->NextPeCidHandle;
			}
		}

		CID[peCidHandle]->PedCidHandle = 0;
	} 
	
	(*CID[peCidHandle]->completeFunc)(&respStruct);
}

/******************************************************************/
/*																  */
/* MspPeHandleModCid											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the ModCID	  */
/* event.														  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleModCid(msp_ped_cmd_rsp *pRsp)
{
	msp_buf			*serBuf;
	msp_pe_resp		respStruct;
	U32				*pCidHan;
	U32				peCidHandle;
	
	/* Set the status and call the completion function */
	respStruct.Status = pRsp->CmdStatus;
	serBuf = (msp_buf *)pRsp->HsHandle;
	pCidHan = (U32 *)serBuf->dataBuffer;
	peCidHandle = *pCidHan;
	MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);

	respStruct.CallerRefId = CID[peCidHandle]->ModRefId;
	   
	(*CID[peCidHandle]->MODcompleteFunc)(&respStruct);
}

/******************************************************************/
/*																  */
/* MspPeHandleGetCidStats										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the			  */
/* getCidStats event.											  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/

static void MspPeHandleGetCidStats(msp_ped_cmd_rsp *pRsp)
{
	msp_buf					*serBuf;
	msp_pe_cid_stats_pars	*pGetPars;
	msp_pe_resp				respStruct;
	msp_pe_cid_stats		Stats;
	U32						peCidHandle;
	
	/* Set the status and call the completion function */
	respStruct.Status = pRsp->CmdStatus;

	serBuf = (msp_buf *)pRsp->HsHandle;
	pGetPars = (msp_pe_cid_stats_pars *)serBuf->dataBuffer;
	respStruct.CallerRefId = pGetPars->CallerRefId;

	peCidHandle = pGetPars->PeCidHandle;

	/* Fill in status in serBuf for blocking calls */
	pGetPars->Status = pRsp->CmdStatus;

	if ((pRsp->CmdStatus == MSP_SUCCESS) &&
		(!(pGetPars->IsBlockingCall))) {
		/* We successfully got CID stats */
		Stats.CurrPeCidHandle = peCidHandle;
		Stats.NextPeCidHandle = CID[peCidHandle]->NextPeCidHandle;

		Stats.Vpi = VC[peCidHandle]->AtmVcFlds.Vpi;
		Stats.Vci = VC[peCidHandle]->AtmVcFlds.Vci;
		Stats.CidCfg.CidNum = CID[peCidHandle]->CidFlds.CidNum;
		Stats.CidCfg.CidMode = CID[peCidHandle]->CidFlds.CidMode;
		Stats.CidCfg.ParMod.CidFlags = CID[peCidHandle]->CidFlds.ParMod.CidFlags;
		Stats.CidCfg.ParMod.VoiceProfileType =
							CID[peCidHandle]->CidFlds.ParMod.VoiceProfileType;

		cacheInvalidate(DATA_CACHE,
						&pGetPars->CidStats,
						sizeof(msp_pe_cid_stats_com));

		Stats.ComFlds.PeVcHandle = pGetPars->CidStats.PeVcHandle;
		Stats.ComFlds.TxPktsFromHost =
						pGetPars->CidStats.TxPktsFromHost;
		Stats.ComFlds.RxPktsToHost = pGetPars->CidStats.RxPktsToHost;
		Stats.ComFlds.TxPktsFromHfp =
						pGetPars->CidStats.TxPktsFromHfp;
		Stats.ComFlds.TxBytesFromHfp =
						pGetPars->CidStats.TxBytesFromHfp;
		Stats.ComFlds.RxPktsToHfp = pGetPars->CidStats.RxPktsToHfp;
		Stats.ComFlds.RxBytesToHfp = pGetPars->CidStats.RxBytesToHfp;
		
		Stats.ComFlds.RxSeqNumErrs =
						pGetPars->CidStats.RxSeqNumErrs;
		Stats.ComFlds.RxParityErrs =
						pGetPars->CidStats.RxParityErrs;
		Stats.ComFlds.RxInvAal2HdrErrs =
						pGetPars->CidStats.RxInvAal2HdrErrs;
	} 
	
	if (!(pGetPars->IsBlockingCall))
		MspFIFOBufInUsePut(PESerialFifoBig, serBuf);
		
	(*pGetPars->CompleteFunc)(&respStruct, &Stats);
}

/******************************************************************/
/*																  */
/* MspPeHandleGetPeStats										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the			  */
/* GetPeStats event.											  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/
static void MspPeHandleGetPeStats(msp_ped_cmd_rsp *pRsp)
{
	msp_pe_resp			respStruct;
	msp_pe_stats		Stats;
	
	/* Set the status and call the completion function */
	respStruct.Status = pRsp->CmdStatus;
	respStruct.CallerRefId = FE->GetRefId;

	cacheInvalidate(DATA_CACHE,
					&FE->Stats,
					sizeof(msp_pe_pe_stats_com));

	if (pRsp->CmdStatus == MSP_SUCCESS) 
	{
#if 0
		Stats.ComFlds.BuildDate = FE->Stats.BuildDate;
		Stats.ComFlds.Version = FE->Stats.Version;
		Stats.ComFlds.ZspCycleSpeed = FE->Stats.ZspCycleSpeed;
		Stats.ComFlds.MaxCmds = FE->Stats.MaxCmds;
		Stats.ComFlds.MaxUTOPIA = FE->Stats.MaxUTOPIA;
		Stats.ComFlds.MaxHDLC = FE->Stats.MaxHDLC;
		Stats.ComFlds.MaxSerialATM = FE->Stats.MaxSerialATM;
		Stats.ComFlds.MaxNokia = FE->Stats.MaxNokia;
		Stats.ComFlds.MaxDataVcs = FE->Stats.MaxDataVcs;
		Stats.ComFlds.MaxVoiceVcs = FE->Stats.MaxVoiceVcs;
		Stats.ComFlds.MaxCidChans = FE->Stats.MaxCidChans;
		Stats.ComFlds.EvtBufAddrStart = FE->Stats.EvtBufAddrStart;
		Stats.ComFlds.EvtBufAddrEnd = FE->Stats.EvtBufAddrEnd;
		Stats.ComFlds.EvtBufWrPtr = FE->Stats.EvtBufWrPtr;
		Stats.ComFlds.EvtCnt = FE->Stats.EvtCnt;
		Stats.ComFlds.LostEvts = FE->Stats.LostEvts;
#else
		Stats.ComFlds = FE->Stats;
#endif
	}

	(*FE->GETcompleteFunc)(&respStruct, &Stats);
}

/******************************************************************/
/*																  */
/* MspPeHandleGetPhyStats										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the			  */
/* GetPhyStats event.											  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/
static void MspPeHandleGetPhyStats(msp_ped_cmd_rsp *pRsp)
{
	msp_pe_resp				respStruct;
	msp_pe_phy_stats		Stats;
	
	/* Set the status and call the completion function */
	respStruct.Status = pRsp->CmdStatus;
	respStruct.CallerRefId = FE->PhyGetRefId;

	cacheInvalidate(DATA_CACHE,
					&FE->PStats,
					sizeof(msp_pe_phy_stats_com));

	if (pRsp->CmdStatus == MSP_SUCCESS) 
	{
		switch (FE->PStats.PhyType) 
		{
			case MSP_PE_PHYTYPE_SERIAL_ATM:
				Stats.ComFlds.PhyStats.SerialAtmIfStats.ConfigFlags =
						FE->PStats.PhyStats.SerialAtmIfStats.ConfigFlags;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.CosetValue =
						FE->PStats.PhyStats.SerialAtmIfStats.CosetValue;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.TdmSlotsPerFrame =
						FE->PStats.PhyStats.SerialAtmIfStats.TdmSlotsPerFrame;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.LineSpeed.RxLineSpeed =
						FE->PStats.PhyStats.SerialAtmIfStats.LineSpeed.RxLineSpeed;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.LineSpeed.TxLineSpeed =
						FE->PStats.PhyStats.SerialAtmIfStats.LineSpeed.TxLineSpeed;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.RxCells =
						FE->PStats.PhyStats.SerialAtmIfStats.RxCells;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.RxCellsDropped =
						FE->PStats.PhyStats.SerialAtmIfStats.RxCellsDropped;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.TxCells =
						FE->PStats.PhyStats.SerialAtmIfStats.TxCells;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.TxCellsDropped =
						FE->PStats.PhyStats.SerialAtmIfStats.TxCellsDropped;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.SyncAcquiredCnt =
						FE->PStats.PhyStats.SerialAtmIfStats.SyncAcquiredCnt;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.SyncLostCnt =
						FE->PStats.PhyStats.SerialAtmIfStats.SyncLostCnt;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.RxOamF4Cells =
						FE->PStats.PhyStats.SerialAtmIfStats.RxOamF4Cells;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.RxOamF5Cells =
						FE->PStats.PhyStats.SerialAtmIfStats.RxOamF5Cells;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.RxOamF4LoopbackCells =
						FE->PStats.PhyStats.SerialAtmIfStats.RxOamF4LoopbackCells;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.RxOamF5LoopbackCells =
						FE->PStats.PhyStats.SerialAtmIfStats.RxOamF5LoopbackCells;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.TxIdleCellCnt =
						FE->PStats.PhyStats.SerialAtmIfStats.TxIdleCellCnt;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.RxIdleCellCnt =
						FE->PStats.PhyStats.SerialAtmIfStats.RxIdleCellCnt;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.RxHecErrCells =
						FE->PStats.PhyStats.SerialAtmIfStats.RxHecErrCells;
				break;
			case MSP_PE_PHYTYPE_NOKIA:
				Stats.ComFlds.PhyStats.NokiaIfStats.ConfigFlags =
						FE->PStats.PhyStats.NokiaIfStats.ConfigFlags;
				Stats.ComFlds.PhyStats.NokiaIfStats.CosetValue =
						FE->PStats.PhyStats.NokiaIfStats.CosetValue;
				Stats.ComFlds.PhyStats.NokiaIfStats.MaxEocFrameBSize =
						FE->PStats.PhyStats.NokiaIfStats.MaxEocFrameBSize;
				Stats.ComFlds.PhyStats.NokiaIfStats.LineSpeed.RxLineSpeed =
						FE->PStats.PhyStats.NokiaIfStats.LineSpeed.RxLineSpeed;
				Stats.ComFlds.PhyStats.NokiaIfStats.LineSpeed.TxLineSpeed =
						FE->PStats.PhyStats.NokiaIfStats.LineSpeed.TxLineSpeed;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxCells =
						FE->PStats.PhyStats.NokiaIfStats.RxCells;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxCellsDropped =
						FE->PStats.PhyStats.NokiaIfStats.RxCellsDropped;
				Stats.ComFlds.PhyStats.NokiaIfStats.TxCells =
						FE->PStats.PhyStats.NokiaIfStats.TxCells;
				Stats.ComFlds.PhyStats.NokiaIfStats.TxCellsDropped =
						FE->PStats.PhyStats.NokiaIfStats.TxCellsDropped;
				Stats.ComFlds.PhyStats.NokiaIfStats.SyncAcquiredCnt =
						FE->PStats.PhyStats.NokiaIfStats.SyncAcquiredCnt;
				Stats.ComFlds.PhyStats.NokiaIfStats.SyncLostCnt =
						FE->PStats.PhyStats.NokiaIfStats.SyncLostCnt;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxOamF4Cells =
						FE->PStats.PhyStats.NokiaIfStats.RxOamF4Cells;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxOamF5Cells =
						FE->PStats.PhyStats.NokiaIfStats.RxOamF5Cells;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxOamF4LoopbackCells =
						FE->PStats.PhyStats.NokiaIfStats.RxOamF4LoopbackCells;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxOamF5LoopbackCells =
						FE->PStats.PhyStats.NokiaIfStats.RxOamF5LoopbackCells;
				Stats.ComFlds.PhyStats.NokiaIfStats.TxIdleCellCnt =
						FE->PStats.PhyStats.NokiaIfStats.TxIdleCellCnt;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxIdleCellCnt =
						FE->PStats.PhyStats.NokiaIfStats.RxIdleCellCnt;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxHecErrCells =
						FE->PStats.PhyStats.NokiaIfStats.RxHecErrCells;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxCrcErrs =
						FE->PStats.PhyStats.NokiaIfStats.RxCrcErrs;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxRaiCnt =
						FE->PStats.PhyStats.NokiaIfStats.RxRaiCnt;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxFebeCnt =
						FE->PStats.PhyStats.NokiaIfStats.RxFebeCnt;
				Stats.ComFlds.PhyStats.NokiaIfStats.TxEocFrames =
						FE->PStats.PhyStats.NokiaIfStats.TxEocFrames;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxEocFrames =
						FE->PStats.PhyStats.NokiaIfStats.RxEocFrames;
				Stats.ComFlds.PhyStats.NokiaIfStats.TxEocBytes =
						FE->PStats.PhyStats.NokiaIfStats.TxEocBytes;
				Stats.ComFlds.PhyStats.NokiaIfStats.RxEocBytes =
						FE->PStats.PhyStats.NokiaIfStats.RxEocBytes;
				break;
			case MSP_PE_PHYTYPE_UTOPIA1:
			case MSP_PE_PHYTYPE_UTOPIA2:
				Stats.ComFlds.PhyStats.UtopiaIfStats.ConfigFlags =
						FE->PStats.PhyStats.UtopiaIfStats.ConfigFlags;
				Stats.ComFlds.PhyStats.UtopiaIfStats.LineSpeed.RxLineSpeed =
						FE->PStats.PhyStats.UtopiaIfStats.LineSpeed.RxLineSpeed;
				Stats.ComFlds.PhyStats.UtopiaIfStats.LineSpeed.TxLineSpeed =
						FE->PStats.PhyStats.UtopiaIfStats.LineSpeed.TxLineSpeed;
				Stats.ComFlds.PhyStats.UtopiaIfStats.RxCells =
						FE->PStats.PhyStats.UtopiaIfStats.RxCells;
				Stats.ComFlds.PhyStats.UtopiaIfStats.RxCellsDropped =
						FE->PStats.PhyStats.UtopiaIfStats.RxCellsDropped;
				Stats.ComFlds.PhyStats.UtopiaIfStats.TxCells =
						FE->PStats.PhyStats.UtopiaIfStats.TxCells;
				Stats.ComFlds.PhyStats.UtopiaIfStats.TxCellsDropped =
						FE->PStats.PhyStats.UtopiaIfStats.TxCellsDropped;
				Stats.ComFlds.PhyStats.SerialAtmIfStats.RxOamF4Cells =
						FE->PStats.PhyStats.UtopiaIfStats.RxOamF4Cells;
				Stats.ComFlds.PhyStats.UtopiaIfStats.RxOamF5Cells =
						FE->PStats.PhyStats.UtopiaIfStats.RxOamF5Cells;
				Stats.ComFlds.PhyStats.UtopiaIfStats.RxOamF4LoopbackCells =
						FE->PStats.PhyStats.UtopiaIfStats.RxOamF4LoopbackCells;
				Stats.ComFlds.PhyStats.UtopiaIfStats.RxOamF5LoopbackCells =
						FE->PStats.PhyStats.UtopiaIfStats.RxOamF5LoopbackCells;
				break;
		  
		}
	}

	(*FE->PhyGETcompleteFunc)(&respStruct, &Stats);
}

/******************************************************************/
/*																  */
/* MspPeHandleDbgReadMem										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the			  */
/* DbgReadMem event.											  */
/*																  */
/* PARAMETERS:	pRsp-  pointer to the response from the cmd		  */
/*																  */
/******************************************************************/
static void MspPeHandleDbgReadMem(msp_ped_cmd_rsp *pRsp)
{
	if (pRsp->CmdStatus != MSP_SUCCESS) {
		printf("PE:	 DbgReadMem Failed\n");
	}

	cacheInvalidate(DATA_CACHE,
					(U32*)PeDbgReadMemBufAddr,
					(PeDbgReadMemBufWSize << 1));

	SEMGIVE(mspPeDbgReadMemSemId);
}

/******************************************************************/
/*																  */
/* MspPeCleanTx													  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that cleans the Tx Queue	  */
/*																  */
/* PARAMETERS:	PeVcHandle-	Index of VC's Tx Queue to clean		  */
/*																  */
/******************************************************************/

__inline__ static void MspPeCleanTx(U32	  PeVcHandle)
{
	msp_buf					*pMspBuf;
	msp_ped_txbd			*pTxBD;
	U32						userTxId;

#ifdef PE_TX_DEBUG
	printf("HE/HTX (SER):  Flags are 0x%x\n",pTxBD->Flags);
#endif
	while (VC[PeVcHandle]->TxTail != VC[PeVcHandle]->TxHead)
	{
		/* Set txbd pointer to the tail and complete as many	*/
		/* tx as possible.	Update the tail as we go.			*/
		pTxBD = (msp_ped_txbd *)VC[PeVcHandle]->TxTail;
		cacheInvalidate(DATA_CACHE, pTxBD, sizeof(msp_ped_txbd));

		if (pTxBD->Flags & MSP_PED_TXBD_READY_FLAG) 
			return;
			
#ifdef PE_TX_DEBUG
		printf("HE/HTX (SER):  Servicing Tx\n");
#endif
		PeTotalTx++;

		/* Remove the oldest MSP Buf from the in-use fifo	*/
		/* and call it's free routine						*/
		pMspBuf = MspFIFOBufInUseGet(VC[PeVcHandle]->TxMspFifo);
		FreeMspBuf(pMspBuf); /* */
		PeTotalTxFree++;

		/* Increment VC Tx Tail */
		PeTotalTxBdRing--;
		if (VC[PeVcHandle]->TxTail == VC[PeVcHandle]->TxLast)
			VC[PeVcHandle]->TxTail = VC[PeVcHandle]->TxFirst;
		else
			VC[PeVcHandle]->TxTail += sizeof(msp_ped_txbd);

		userTxId = VC[PeVcHandle]->UserTxIdFifo[VC[PeVcHandle]->UserTxIdTail];

		if (VC[PeVcHandle]->UserTxIdTail == (MSP_PE_NUM_TXBDS_DEFAULT - 1))
			VC[PeVcHandle]->UserTxIdTail = 0;
		else
			VC[PeVcHandle]->UserTxIdTail++;

		/* Call the TxCompletion function */
		if (VC[PeVcHandle]->TxCompleteFunc)
			(*VC[PeVcHandle]->TxCompleteFunc)(userTxId, PeVcHandle);
	}
}

/******************************************************************/
/*																  */
/* MspPeHandleTx												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the Tx		  */
/* event.														  */
/*																  */
/* PARAMETERS:	pEvt-  pointer to the event generated			  */
/*																  */
/******************************************************************/

__inline__ static void MspPeHandleTx(msp_ped_tx_complete *pTxEvent)
{
	U32	 PeVcHandle;

	PeVcHandle = pTxEvent->HsHandle;

	/* DEBUG */		   
	PeTotalTxHan++;

#ifdef PE_TX_DEBUG
	printf("HE/HTX (SER):  Entered HandleTx-  peVcHandle:  %x\n", PeVcHandle);
#endif

	if (pTxEvent->TxStatus == MSP_PED_TXSTATUS_OK) 
	{
		/* Update Tx Buffer Descriptors */
#ifdef PE_TX_DEBUG
		printf("HE/HTX (SER):  TxHead is 0x%x\n",VC[PeVcHandle]->TxHead);
		printf("HE/HTX (SER):  TxTail is 0x%x\n",VC[PeVcHandle]->TxTail);
#endif
		MspPeCleanTx(PeVcHandle);

	} 
	else 
	{
		/* ********** INCOMPLETE ********** */
		/* MAYBE SHOULD CALL REGISTERED ERROR FUNC */
		printf("HE/HTX (SER):  Tx didn't return success\n");
	}
#ifdef PE_TX_DEBUG
	printf("HE/HTX (SER):  Exiting HandleTx- TxTail= 0x%x\n",VC[PeVcHandle]->TxTail);
#endif
}

/******************************************************************/
/*																  */
/* MspPeHandleRx												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the Rx		  */
/* event.														  */
/*																  */
/* PARAMETERS:	pEvt-  pointer to the event generated			  */
/*																  */
/******************************************************************/

__inline__ static void MspPeHandleRx(msp_ped_gen_rsp *pEvt, U32 peVcHandle)
{
	msp_ped_rxbd			*pRxBD;
	msp_buf					*pMspBuf;
	msp_buf					*tempMspBuf;
	U32						status;
	msp_ped_rxbd_update		xCmd;
	msp_ped_rxbd_update		*pRxCmd = &xCmd;
	U32						oldRxFwPtr;
	U32						errorFlags;
	U32						errorStatus;

#ifdef PE_RX_DEBUG
	printf("HE/HRX (SER):  Entering HandleRx\n");
#endif

	/* Set rxbd pointer to the head and complete as many	*/
	/* rx as possible.	Update the head as we go.			*/
	pRxBD = (msp_ped_rxbd *)VC[PeVcHandle]->RxHead;

#ifdef PE_RX_DEBUG
	printf("HE/HRX (SER):  RxBd Location:  0x%x\n",(U32)pRxBD);
	printf("HE/HRX (SER):  RxBd Flags:	0x%x\n",pRxBD->Flags);
#endif
	/* Update Rx Buffer Descriptors */
	while (!(pRxBD->Flags & MSP_PED_RXBD_READY_FLAG)) {

		pMspBuf = MspFIFOBufInUseGet(VC[PeVcHandle]->RxMspFifo);

#ifdef PE_RX_DEBUG
		if (pRxBD->BufAddr != (U32)pMspBuf->dataBuffer)
			printf("HE/HRX (SER):  MISMATCH ON ADDRESSES\n");
		printf("HE/HRX (SER):  About to call completion function\n");
#endif
		
		if (pRxBD->Flags & MSP_PED_RXBD_ERROR_FLAGS) 
		{
#ifdef PE_RX_DEBUG
			printf("HE/HRX (SER):  RxError\n");
#endif
			PeTotalRxErr++;

			FreeMspBuf(pMspBuf); /* */
			PeTotalRxFree++;
		  
			if (VC[PeVcHandle]->ErrorFunc) 
			{
				errorStatus = MSP_PE_ERROR_RX_UNKNOWN;
				errorFlags = pRxBD->Flags & MSP_PED_RXBD_ERROR_FLAGS; 

				if (errorFlags & MSP_PED_RXBD_LEN_ERROR_FLAG)
					errorStatus = MSP_PE_ERROR_RX_LENGTH;
				
				if (errorFlags & MSP_PED_RXBD_CRC_ERROR_FLAG)
					errorStatus = MSP_PE_ERROR_RX_CRC;
				
				if (errorFlags & MSP_PED_RXBD_ABORT_ERROR_FLAG)
					errorStatus = MSP_PE_ERROR_RX_ABORT;
				
				if (errorFlags & MSP_PED_RXBD_CPI_ERROR_FLAG)
					errorStatus = MSP_PE_ERROR_RX_CPI;
				
				if (errorFlags & MSP_PED_RXBD_OVERRUN_ERROR_FLAG)
					errorStatus = MSP_PE_ERROR_RX_OVERRUN;
				
				(*VC[PeVcHandle]->ErrorFunc)(VC[PeVcHandle]->UserErrorId,
											errorStatus);
			}
		} 
		else 
		{
#ifdef PE_RX_DEBUG
			printf("HE/HRX (SER):  Good Rx\n");
#endif
			PeTotalRx++;

			if (VC[PeVcHandle]->RxCompleteFunc)
			{
				/* pMspBuf->appendStart = pMspBuf->prependStart + (S32)pRxBD->RxSize + 1; */
				pMspBuf = MspAdjustAppendOffset(pMspBuf, pRxBD->RxSize);

				cacheInvalidate(DATA_CACHE,
							MspGetBufferStartOfData(pMspBuf),
							MspGetBufferDataLength(pMspBuf));

				/* Call the RxCompletion function for each receive	*/
				(*VC[PeVcHandle]->RxCompleteFunc)(VC[PeVcHandle]->UserRxId,
												 peVcHandle,
												 pMspBuf);
			}
			else
			{
				FreeMspBuf(pMspBuf);
			}
		}

		PeTotalRxBdRing++;
#ifdef PE_PERF_DEBUG   
		if (PeTotalRxBdRing > PeMaxOutRxBdRing) {
			PeMaxOutRxBdRing = PeTotalRxBdRing;
			printf("HE/HRX (SER):  Rx Bd ring max out:	0x%x\n",PeMaxOutRxBdRing);
		}
#endif		

		/* Break out if we are about to hit the tail */	  
		if (VC[PeVcHandle]->RxHead == VC[PeVcHandle]->RxFwPtr)
			break;

		if (VC[PeVcHandle]->RxHead == VC[PeVcHandle]->RxLast)
			VC[PeVcHandle]->RxHead = VC[PeVcHandle]->RxFirst;
		else
			VC[PeVcHandle]->RxHead += sizeof(msp_ped_rxbd);

		pRxBD = (msp_ped_rxbd *)VC[PeVcHandle]->RxHead;

		cacheInvalidate(DATA_CACHE, pRxBD, sizeof(msp_ped_rxbd));
		PREF_LOAD(VC[PeVcHandle]->RxHead);

		VC[PeVcHandle]->RxBdsReady++;
	}

	/* Now replace as many pointers to buffers as possible */
	/* within the buffer descriptors between the Tail up to Head */
	oldRxFwPtr = VC[PeVcHandle]->RxFwPtr;
	while (VC[PeVcHandle]->RxTail != VC[PeVcHandle]->RxHead) 
	{
		/* Giving 256 bytes of prepend space */
		/* This may change for AAL2 packets */
		if ( VC[PeVcHandle]->RxBufferSize < 512)
			tempMspBuf = MspBufferGet(VC[PeVcHandle]->RxBufferSize,
										MSP_BUF_NOAPPEND_8_BYTES,
										MSP_PE_OWNER_ID,
										DONT_GET_RTOS_BUFFER);
		else
			tempMspBuf = MspBufferGet(VC[PeVcHandle]->RxBufferSize+MSP_BUF_NOAPPEND_64_BYTES,
										MSP_BUF_NOAPPEND_64_BYTES,
										MSP_PE_OWNER_ID,
										DONT_GET_RTOS_BUFFER);
		if (tempMspBuf != NULL) {
			PeTotalRxAlloc++;
			status = MspFIFOBufInUsePut(VC[PeVcHandle]->RxMspFifo, tempMspBuf);
			pRxBD = (msp_ped_rxbd *)VC[PeVcHandle]->RxTail;

			pRxBD->Flags |= MSP_PED_RXBD_READY_FLAG;
			/* tempMspBuf->prependStart = 511; */
			pRxBD->BufAddr = (U32)MspGetBufferStartOfData(tempMspBuf);
			pRxBD->RxSize = VC[PeVcHandle]->RxBufferSize;
			/* The FwPtr always stays one behind the Tail */
			VC[PeVcHandle]->RxFwPtr = VC[PeVcHandle]->RxTail;

			PeTotalRxBdRing--;
			if (VC[PeVcHandle]->RxTail == VC[PeVcHandle]->RxLast)
				VC[PeVcHandle]->RxTail = VC[PeVcHandle]->RxFirst;
			else
				VC[PeVcHandle]->RxTail += sizeof(msp_ped_rxbd);
		} 
		else
		{
			assert(tempMspBuf != NULL); 
			break;
		}
	}

	/* Send down Rx Update command only if we changed the RxFwPtr */
	if ((VC[PeVcHandle]->RxFwPtr != oldRxFwPtr) 
	&&	(VC[PeVcHandle]->RxBdsReady >= 5)) 
	{
		VC[PeVcHandle]->RxBdsReady = 0;
		
		/* 
		 * Setup an RXBD_UPDATE command
		 * Check if we have a command structure available
		 * If we don't, we'll just have to update it on the
		 * next receive
		 */

		pRxCmd->CmdId = MSP_PED_RXBD_UPDATE_CMD;
		pRxCmd->HsHandle = peVcHandle;
		pRxCmd->PedVcHandle = VC[PeVcHandle]->PedVcHandle;
		pRxCmd->RxBdPtr = VC[PeVcHandle]->RxFwPtr;

#ifdef PE_RX_DEBUG
		printf("HE/HRX (SER):  Copying down rx update\n");
#endif
		/* Copy from driver's cmd queue into FE cmd queue */
		TriadBcopy( (U32)pRxCmd,
							MSP_PED_COMMAND_Q_BASE,
							BC_CP_DFIX_SINC_NINT_MODE,
							sizeof(msp_ped_rxbd_update));

	}

#ifdef PE_RX_DEBUG
	printf("HE/HRX (SER):  Exiting HandleRx\n");
#endif
}

/******************************************************************/
/*																  */
/* MspPeHandleNokiaEocTx										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the NokiaEOCTx */
/* event.														  */
/*																  */
/* PARAMETERS:	pEvt-  pointer to the event generated			  */
/*																  */
/******************************************************************/

void MspPeHandleNokiaEocTx(msp_ped_nokia_txeoc *pNTxEvt)
{	 
	/* Call the TxCompletion function */
	if (*FE->NokiaFlds.TxEOCComplete)
	{
		(*FE->NokiaFlds.TxEOCComplete)(FE->NokiaFlds.TxEOCId, 
					pNTxCmd->PhyDevice.InterfaceNum, 
					MSP_SUCCESS);
	}
	addToExtendedQueue(pNTxEvt->HsHandle);
}

/******************************************************************/
/*																  */
/* MspPeHandleNokiaRx											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the NokiaEOCRx */
/* event.														  */
/*																  */
/* PARAMETERS:	pEvt-  pointer to the event generated			  */
/*																  */
/******************************************************************/

void MspPeHandleNokiaRx(msp_ped_gen_rsp *pEvt)
{
	msp_ped_nokia_rxeoc_complete	*pNRxEvt;
	U32				portNum;
	msp_buf			*tempRxEocBuf;

	pNRxEvt = (msp_ped_nokia_rxeoc_complete *)pEvt;
	portNum = pNRxEvt->InterfaceNum;

	/* Get memory and copy eoc frame to it */
	tempRxEocBuf = MspBufferGet(FE->NokiaFlds.ComFlds.Interface[portNum].MaxEocFrameBSize,
								MSP_BUF_NOAPPEND_64_BYTES, 2, DONT_GET_RTOS_BUFFER); 

	TriadBcopy((U32)FE->NokiaRxEocBufAddr[portNum],
					(U32)tempRxEocBuf->dataBuffer,
					BC_CP_DFIX_SINC_NINT_MODE,
					pNRxEvt->RxFrameBSize);

	/* Call the TxCompletion function with copied into buffer */
	(*FE->NokiaFlds.RxEOCComplete)(FE->NokiaFlds.RxEOCId,
					   portNum, 
					   tempRxEocBuf->dataBuffer,
					   pNRxEvt->RxFrameBSize);
}


/******************************************************************/
/*																  */
/* MspPeHandleEvent												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles an event from  */
/* the event queue.	 Once completed, the pEvt->EvtId valid bit	  */
/* is cleared.													  */
/*																  */
/* PARAMETERS:	pEvt-  Pointer to next event to be processed	  */
/*																  */
/******************************************************************/

void MspPeHandleEvent( msp_ped_gen_rsp	*pEvt)
{

#ifdef PE_DEBUG
	printf("HE (SER):  Entering Handle Event routine\n");
	printf("HE (SER):  The event id is %x\n",pEvt->EvtId);
#endif

	/* Clear the valid bit in the event */
	pEvt->EvtId &= ~MSP_PED_VALID_EVT;

	if (pEvt->EvtId == MSP_PED_RX_COMPLETE_EVT)
	{
#ifdef PE_RX_DEBUG
		printf("HE (SER):  Got Rx Event\n");
#endif
		
#if PMR
		SYNC();
#endif
		cacheInvalidate(DATA_CACHE, (msp_ped_rxbd *) VC[PeVcHandle]->RxHead, sizeof(msp_ped_rxbd));
		PREF_LOAD(VC[PeVcHandle]->RxHead);

		MspPeHandleRx(pEvt, pEvt->HsHandle); /* */
		return;
	}

	switch(pEvt->EvtId) 
	{
		case MSP_PED_TX_COMPLETE_EVT:
#ifdef PE_TX_DEBUG
		  printf("HE (SER):	 Got Tx Event\n");
#endif
		MspPeHandleTx((msp_ped_tx_complete *) pEvt);
		break;

#if 0
	case MSP_PED_RX_COMPLETE_EVT:
#ifdef PE_RX_DEBUG
		printf("HE (SER):  Got Rx Event\n");
#endif
		MspPeHandleRx(pEvt, pEvt->HsHandle); /* */
		break;
#endif

	case MSP_PED_NOK_TXEOC_COMPLETE_EVT:
		MspPeHandleNokiaTx(pEvt);
		break;
	case MSP_PED_NOK_RXEOC_COMPLETE_EVT:
		MspPeHandleNokiaRx(pEvt);
		break;

	case MSP_PED_CMD_RSP_EVT: 
	{
		msp_ped_cmd_rsp			*pRsp;

		/* We know the event is a response */
		pRsp = (msp_ped_cmd_rsp *)pEvt;

#ifdef PE_DEBUG
		printf("HE (SER):  Recognized as command response event\n");
		printf("HE (SER):  HsHandle is %x\n",pRsp->HsHandle);
		printf("HE (SER):  Command Id is %x\n",pRsp->CmdId);
		printf("HE (SER):  Command status is %x\n",pRsp->CmdStatus);
		printf("HE (SER):  Response Param is %x\n",pRsp->RspParm1);
		printf("HE (SER):  Event Id is %x\n",pRsp->EvtId);
#endif

		switch(pRsp->CmdId) 
		{
			case MSP_PED_CFG_CMD:
#ifdef PE_CFG_DEBUG
				printf("HE (SER):  Got Handle Config event\n");
#endif
				MspPeHandleConfig(pRsp);
				break;

			case MSP_PED_UTOPIA_CFG_CMD:
				MspPeHandleUtopiaConfig(pRsp);
				break;
				
			case MSP_PED_NOKIA_CFG_CMD:
				MspPeHandleNokiaConfig(pRsp);
				break;
				
			case MSP_PED_SERIAL_ATM_CFG_CMD:
#ifdef PE_SATM_DEBUG
				printf("HE (SER):  Got Handle Satm Cfg event\n");
#endif
				MspPeHandleSatmConfig(pRsp);
				break;
				
			case MSP_PED_HDLC_CFG_CMD:
				MspPeHandleHdlcConfig(pRsp);
				break;
				
			case MSP_PED_ENABLE_PHY_CMD:
				MspPeHandleEnablePhy(pRsp);
				break;
				
			case MSP_PED_DISABLE_PHY_CMD:
				MspPeHandleDisablePhy(pRsp);
				break;
				
			case MSP_PED_BIND_HDLCL2_CMD:
				MspPeHandleCfgHdlcL2(pRsp);
				break;
				
			case MSP_PED_UPDATE_PHY_LINESPEED:
				MspPeHandleUpdateLS(pRsp);
				break;
				
			case MSP_PED_ADD_VC_CMD:
#ifdef PE_ADD_ATM_DEBUG
				printf("HE (SER):  Got Handle Add VC event\n");
#endif
				MspPeHandleAddVc(pRsp);
				break;
				
			case MSP_PED_DEL_VC_CMD:
				MspPeHandleDelVc(pRsp);
				break;
				
			case MSP_PED_ENABLE_VC_CMD:
#ifdef PE_ENAVC_DEBUG
				printf("HE (SER):  Got EnableVC event\n");
#endif
				MspPeHandleEnableVc(pRsp);
				break;
				
			case MSP_PED_DISABLE_VC_CMD:
				MspPeHandleDisableVc(pRsp);
				break;
				
			case MSP_PED_MOD_VC_CMD:
				MspPeHandleModVc(pRsp);
				break;
				
			case MSP_PED_GET_VC_STATS_CMD:
				MspPeHandleGetVcStats(pRsp);
				break;
				
			case MSP_PED_ADD_CID_CMD:
#ifdef PE_ADD_CID_DEBUG
				printf("HE (SER):  Got AddCid event\n");
#endif			  
				MspPeHandleAddCid(pRsp);
				break;
				
			case MSP_PED_DEL_CID_CMD:
				MspPeHandleDelCid(pRsp);
				break;
				
			case MSP_PED_MOD_CID_CMD:
				MspPeHandleModCid(pRsp);
				break;
				
			case MSP_PED_GET_CID_STATS_CMD:
				MspPeHandleGetCidStats(pRsp);
				break;

			case MSP_PED_TXBD_UPDATE_CMD:
				break;
				
			case MSP_PED_RXBD_UPDATE_CMD:
				break;
				
			case MSP_PED_GET_PHY_STATS_CMD:
				MspPeHandleGetPhyStats(pRsp);
				break;
				
			case MSP_PED_GET_PE_STATS_CMD:
				MspPeHandleGetPeStats(pRsp);
				break;
				
			case MSP_PED_READ_MEM_DBGCMD:
				MspPeHandleDbgReadMem(pRsp);
				break;
				
			default:
				break;
		}
	} 
	default:
		break;
	}
	
#ifdef PE_DEBUG
	printf("HE (SER):  Exiting Handle Event routine\n");
#endif
}



/******************************************************************/
/*																  */
/* MspPeStartSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine starts the Packet engine by issuing a ping		  */
/* command to the Packet Engine Firmware.						  */
/*																  */
/* PARAMETERS: none												  */
/*																  */
/******************************************************************/

U32 MspPeStartSer()
{
	U32				i;
	msp_buf			*tempNokiaHead;
	
#ifdef PE_PES_DEBUG
	printf("PES (SER):	Entering PE Start\n");
#endif
	
	if (FeStartComplete) 
		return (MSP_PE_ERROR_START_ALREADY_CALLED);


	/* Ping commands have no response */

	FeStartComplete = 1;

	PeTotalTx = 0;
	PeTotalTxSer = 0;
	PeTotalTxCD = 0;
	PeTotalTxHan = 0;
	PeTotalTxErr = 0;
	PeTotalRx = 0;
	PeTotalTxAlloc = 0;
	PeTotalRxAlloc = 0;
	PeTotalTxFree = 0;
	PeTotalRxFree = 0;
	PeTotalTxBdRing = 0;
	PeTotalRxBdRing = 0;
	PeMaxOutTxBdRing = 0;
	PeMaxOutRxBdRing = 0;

#ifdef PE_PES_DEBUG
	printf("PES (SER):	Giving Start semaphore now\n");
#endif

	return MspPePingTestSer();
);

}


/*
 *																  
 * MspPeConfigSer												  
 *																  
 * DESCRIPTION:													  
 * This routine is called to configure the FE. Numerous resources 
 * are configured with this function, such as:	number of voice
 * channels, number of VCs, number of WAN interfaces and type,	  
 * WAN mode (ATM or frame-relay), and specifics of voice over the
 * interface. 
 *		  
 * PARAMETERS: 
 *			config- pointer to structure containing FE attributes  
 *
 */

U32 MspPeConfigSer(msp_pe_config	*config)
{
	U32					byteSize;
	U32					i;
	U32					PeClk;
	msp_ped_extcmd		xCmd;
	msp_ped_extcmd		*pXCmd = &xCmd;
	msp_ped_cfg			cCmd;
	msp_ped_cfg			*peXCmdAddr = &cCmd;

#ifdef PE_CFG_DEBUG
	printf("CON (SER):	Entering ConfigSer\n");
#endif

	byteSize = MSP_PE_MAX_EVENTS * sizeof(msp_ped_gen_rsp);
	FEEventQueue = (msp_ped_gen_rsp *) memalign(MSP5000_CACHE_DATA_LINE_SIZE, byteSize);
	assert (FEEventQueue != 0);
	
#ifdef PE_CFG_DEBUG
	printf("CON (SER):	Address given by getmem:  %x\n", eventAddr);
#endif

	memset (FEEventQueue, 0, byteSize);

	/* Now setup the Extended command structure */
	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr;
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_cfg);

	/* 
	 * Obtain PE clock speed in MHZ
	 * change PeClk clock speed into MHZ 
	 */
	PeClk = sysCalcPeClk(sysCalcPllClk(EXTERNAL_XTL)) / 1000000;

	/* convert MHz to nanoseconds.	Formula is
	 * NS = (1/(MHz*1,000,000)) * 1,000,000,000	 or
	 * NS = 1000/MHz.
	 * Note: we multiply the clock speed by 100 so the PE gets the clock speed
	 * to the nearest 100th.  
	 * So the ZspCycleSpeed is (1000 * 100)/MHz or (100,000/MHZ)
	 */

	peXCmdAddr->CmdId = MSP_PED_CFG_CMD;
	peXCmdAddr->HsHandle = peXCmdAddr;
	peXCmdAddr->evtBufAddr = FEEventQueue;		
	peXCmdAddr->MaxNumEvts = MSP_PE_MAX_EVENTS;
	peXCmdAddr->ZspCycleSpeed = 100000 PeClk;

	/* The rest of the structure is already there */
  
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy((U32)pXCmd,
					MSP_PED_COMMAND_Q_BASE,
					BC_CP_DFIX_SINC_NINT_MODE,
					sizeof(msp_ped_extcmd));

	
	while (FeConfigComplete == 0)
		NanoDelay(500);
	
	return FeConfigStatus;
}

/******************************************************************/
/*																  */
/* MspPeGetPeStatsSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get the PE's statistics.			  */
/*																  */
/* PARAMETERS:													  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeGetPeStatsSer(U32	callerRefId,
				void	(*completeFunc)( 	msp_pe_resp *pPeResp,
											msp_pe_stats *pStat),
				 msp_pe_stats	*pStat)
{
	msp_ped_get_pe_stats	*xCmd;
	msp_ped_get_pe_stats	*pGSCmd = &xCmd;
	msp_pe_resp				errorResp;
	msp_pe_stats			errorStats;

	FE->GETcompleteFunc = completeFunc;
	FE->GetRefId = callerRefId;

	pGSCmd->CmdId = MSP_PED_GET_PE_STATS_CMD;
	pGSCmd->StatBufPtr = pStat;
	
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pGSCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_get_pe_stats));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeConfigUtopiaSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the FE for a UTOPIA		  */
/* interface.													  */
/*																  */
/* PARAMETERS:													  */
/*				config- pointer to structure containing FE UTOPIA */
/*						attributes								  */
/*																  */
/******************************************************************/

U32 MspPeConfigUtopiaSer (msp_pe_utopia_cfg *config)
{
	msp_ped_extcmd			xCmd;
	msp_ped_extcmd			*pXCmd = &xCmd;
	msp_ped_utopia_cfg		uCmd;
	msp_ped_utopia_cfg		*pUCCmd = &uCmd;
 

	/* Now setup the Extended command structure */
	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = pUCCmd; 
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_utopia_cfg);

	/* Now setup the Utopia Config Command structure */
	pUCCmd->CmdId = MSP_PED_UTOPIA_CFG_CMD;
	pUCCmd->HsHandle = pUCCmd;
	pUCCmd->ComFlds = config;

	/* The rest of the structure is already there */

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_extcmd));

	
	while (FeUtopiaComplete == 0)
		NanoDelay(500);
	
	return FeUtopiaStatus;
}


/******************************************************************/
/*																  */
/* MspPeConfigNokiaSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the FE for a Nokia ATM	  */
/* serial interface.											  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				config- pointer to structure containing FE Nokia  */
/*						attributes								  */
/*																  */
/******************************************************************/

U32 MspPeConfigNokiaSer(msp_pe_nokia_cfg	*config)
{
	msp_ped_extcmd			xCmd;
	msp_ped_extcmd			*pXCmd = &xCmd;
	msp_ped_nokia_cfg		*nCmd;
	msp_ped_nokia_cfg		*pNCCmd = &nCmd;
	U16						i;

	/* Now setup the Extended command structure */
	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = pNCCmd; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_nokia_cfg);

	/* Now setup the Nokia Config Command structure */
	pNCCmd->CmdId = MSP_PED_NOKIA_CFG_CMD;
	pNCCmd->ComFlds = config->ComFlds;
	for (i=0;i < MSP_PE_NOKIA_MAX_PHYS;i++)
		pNCCmd->RxEocBufAddr[i] = FE->NokiaRxEocBufAddr[i];

	/* The rest of the structure is already there */

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
					MSP_PED_COMMAND_Q_BASE,
					BC_CP_DFIX_SINC_NINT_MODE,
					sizeof(msp_ped_extcmd));

	while (FeNokiaComplete == 0)
		NanoDelay(500);
	
	return FeNokiaStatus;
}


/******************************************************************/
/*																  */
/* MspPeConfigSerialAtmSer										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the FE for an SATM		  */
/* interface.													  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				config- pointer to structure containing FE SATM	  */
/*						attributes								  */
/*																  */
/******************************************************************/

U32 MspPeConfigSerialAtmSer(void						*pCmd,
							void						*pParam1,
							void						*pParam2,	
							void						*pParam3,
							serializationTaskData		*pSerData)

{
	msp_buf					*serBuf;
	msp_pe_serial_atm_cfg	*config;
	msp_ped_extcmd			xCmd;
	msp_ped_extcmd			*pXCmd = &xCmd;
	msp_ped_serial_atm_cfg	*pTCCmd;
	U16						i;
	U32						peXCmdAddr;

	serBuf = (msp_buf *)pParam1;
	config = (msp_pe_serial_atm_cfg *)MspGetBufferStartOfData(serBuf);

#ifdef PE_SATM_DEBUG
	printf("SCON (SER):	 Entering ConfigSatmSer\n");
#endif

	/* First, store all the values in the	*/
	/* global variable structure			*/
	for (i=0;i<MSP_PE_SATM_MAX_PHYS;i++) 
	{
		FE->SatmFlds.ComFlds.Interface[i].InterfaceNum
				= config->ComFlds.Interface[i].InterfaceNum;
		FE->SatmFlds.ComFlds.Interface[i].LineSpeed.RxLineSpeed
				= config->ComFlds.Interface[i].LineSpeed.RxLineSpeed;
		FE->SatmFlds.ComFlds.Interface[i].LineSpeed.TxLineSpeed
				= config->ComFlds.Interface[i].LineSpeed.TxLineSpeed;
		FE->SatmFlds.ComFlds.Interface[i].CosetFlag
				= config->ComFlds.Interface[i].CosetFlag;
		FE->SatmFlds.ComFlds.Interface[i].CosetValue
				= config->ComFlds.Interface[i].CosetValue;
		FE->SatmFlds.ComFlds.Interface[i].IdleCellMode
				= config->ComFlds.Interface[i].IdleCellMode;
		FE->SatmFlds.ComFlds.Interface[i].PayloadScrambling
				= config->ComFlds.Interface[i].PayloadScrambling;
		FE->SatmFlds.ComFlds.Interface[i].PhyClockMode
				= config->ComFlds.Interface[i].PhyClockMode;
		FE->SatmFlds.ComFlds.Interface[i].TdmFrameSyncBitMode
				= config->ComFlds.Interface[i].TdmFrameSyncBitMode;
		FE->SatmFlds.ComFlds.Interface[i].TdmExternalTxFrameSync
				= config->ComFlds.Interface[i].TdmExternalTxFrameSync;
		FE->SatmFlds.ComFlds.Interface[i].TdmSlotsPerFrame
				= config->ComFlds.Interface[i].TdmSlotsPerFrame;
		FE->SatmFlds.ComFlds.Interface[i].AutoF5OamLoopback
				= config->ComFlds.Interface[i].AutoF5OamLoopback;
		FE->SatmFlds.ComFlds.Interface[i].AutoF4OamLoopback
				= config->ComFlds.Interface[i].AutoF4OamLoopback;
	}

	/* Set the Mode for GetPhyStats */
	FE->PStats.PhyType = MSP_PE_PHYTYPE_SERIAL_ATM;

	/* Now setup the Extended command structure */
	peXCmdAddr = (U32)serBuf->dataBuffer;
	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_serial_atm_cfg);

	/* Now setup the SATM Config Command structure */
	pTCCmd = (msp_ped_serial_atm_cfg *)peXCmdAddr;
	pTCCmd->CmdId = MSP_PED_SERIAL_ATM_CFG_CMD;
	pTCCmd->HsHandle = (U32)serBuf;

	/* The rest of the structure is already there */

#ifdef PE_SATM_DEBUG
	printf("SCON (SER):	 About to copy command down\n");
#endif

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
					MSP_PED_COMMAND_Q_BASE,
					BC_CP_DFIX_SINC_NINT_MODE,
					sizeof(msp_ped_extcmd));

#ifdef PE_SATM_DEBUG
	printf("SCON (SER):	 Exiting ConfigSer\n");
#endif

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeConfigHdlcSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the FE for an HDLC		  */
/* interface													  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				config- pointer to structure containing FE HDLC	  */
/*						attributes								  */
/*																  */
/******************************************************************/

U32 MspPeConfigHdlcSer(void							*pCmd,
					   void							*pParam1,
					   void							*pParam2,	
					   void							*pParam3,
					   serializationTaskData		*pSerData)
{
	msp_buf					*serBuf;
	msp_pe_hdlc_cfg			*config;
	msp_ped_extcmd			xCmd;
	msp_ped_extcmd			*pXCmd = &xCmd;
	msp_ped_hdlc_cfg		*pHCCmd;
	U16						i;
	U32						peXCmdAddr;

	serBuf = (msp_buf *)pParam1;
	config = (msp_pe_hdlc_cfg *)MspGetBufferStartOfData(serBuf);

   
	/* First, store all the values in the	*/
	/* global variable structure			*/
	for (i=0;i<MSP_PE_HDLC_MAX_PHYS;i++) {
		FE->HdlcFlds.ComFlds.Interface[i].InterfaceNum
				= config->ComFlds.Interface[i].InterfaceNum;
		FE->HdlcFlds.ComFlds.Interface[i].LineSpeed.RxLineSpeed
				= config->ComFlds.Interface[i].LineSpeed.RxLineSpeed;
		FE->HdlcFlds.ComFlds.Interface[i].LineSpeed.TxLineSpeed
				= config->ComFlds.Interface[i].LineSpeed.TxLineSpeed;
		FE->HdlcFlds.ComFlds.Interface[i].ItfPattern
				= config->ComFlds.Interface[i].ItfPattern;
		FE->HdlcFlds.ComFlds.Interface[i].CrcType
				= config->ComFlds.Interface[i].CrcType;
	}

	/* Now setup the Extended command structure */
	peXCmdAddr = (U32)serBuf->dataBuffer;
	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_hdlc_cfg);

	/* Now setup the HDLC Config Command structure */
	pHCCmd = (msp_ped_hdlc_cfg *)peXCmdAddr;
	pHCCmd->CmdId = MSP_PED_HDLC_CFG_CMD;
	pHCCmd->HsHandle = (U32)serBuf;

	/* The rest of the structure is already there */

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_extcmd));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeEnablePhySer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to enable a phy on a WAN interface.	  */
/*																  */
/* PARAMETERS:													  */
/*				PhyDevice-	Physical device to be enabled		  */
/*																  */
/******************************************************************/
U32 MspPeEnablePhySer(void				*pCmd,
			  void				*pParam1,
			  void				*pParam2,	
			  void				*pParam3,
			  serializationTaskData		*pSerData)
{
	msp_ped_enable_phy	xCmd;
	msp_ped_enable_phy	*pEPCmd = &xCmd;
	msp_pe_phy_device	PhyDevice;

	PhyDevice.InterfaceNum = (U32)pParam1;
	PhyDevice.PhyAddr = (U32)pParam2;

	pEPCmd->CmdId = MSP_PED_ENABLE_PHY_CMD;
	pEPCmd->HsHandle = PhyDevice.InterfaceNum;	/* Set HsHandle to Interface # */
	pEPCmd->PhyDevice.InterfaceNum = PhyDevice.InterfaceNum;
	pEPCmd->PhyDevice.PhyAddr = PhyDevice.PhyAddr;
	
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pEPCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_enable_phy));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeDisablePhySer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to disable a phy on a WAN interface.	  */
/*																  */
/* PARAMETERS:													  */
/*				PhyDevice-	Physical device to be disabled		  */
/*																  */
/******************************************************************/
U32 MspPeDisablePhySer( void				*pCmd,
			void				*pParam1,
			void				*pParam2,	
			void				*pParam3,
			serializationTaskData		*pSerData)
{
	msp_ped_disable_phy xCmd;
	msp_ped_disable_phy *pDPCmd = &xCmd;
	msp_pe_phy_device	PhyDevice;

	PhyDevice.InterfaceNum = (U32)pParam1;
	PhyDevice.PhyAddr = (U32)pParam2;

	pDPCmd->CmdId = MSP_PED_DISABLE_PHY_CMD;
	pDPCmd->HsHandle = PhyDevice.InterfaceNum;	/* Set HsHandle to Interface # */
	pDPCmd->PhyDevice.InterfaceNum = PhyDevice.InterfaceNum;
	pDPCmd->PhyDevice.PhyAddr = PhyDevice.PhyAddr;
	
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pDPCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_disable_phy));


	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeConfigHdlcL2Ser											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the layer 2 HDLC interface */
/*																  */
/* PARAMETERS:													  */
/*				PhyDevice-	Physical device to be enabled		  */
/*																  */
/*				L2Intf-	 Layer 2 Interface configuration		  */
/*																  */
/******************************************************************/
U32 MspPeConfigHdlcL2Ser(void				*pCmd,
			  void				*pParam1,
			  void				*pParam2,	
			  void				*pParam3,
			  serializationTaskData		*pSerData)
{
	msp_pe_phy_device	PhyDevice;
	U32					L2Intf;
	msp_ped_extcmd		xCmd;
	msp_ped_extcmd		*pXCmd = &xCmd;
	msp_ped_bind_hdlcl2 *pHCCmd;
	U32					peXCmdAddr;
	msp_buf				*serBuf;

	PhyDevice.InterfaceNum = (U32)pParam1;
	PhyDevice.PhyAddr = (U32)pParam2;
	L2Intf = (U32)pParam3;

	FE->HdlcL2Intf[PhyDevice.InterfaceNum] = L2Intf;

	/* Get serialization buf Here */
	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);

	/* Now setup the Extended command structure */
	peXCmdAddr = (U32)serBuf->dataBuffer;
	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_bind_hdlcl2);

	/* Now setup the HDLC L2 Config Command structure */
	pHCCmd = (msp_ped_bind_hdlcl2 *)peXCmdAddr;
	pHCCmd->CmdId = MSP_PED_BIND_HDLCL2_CMD;
	pHCCmd->HsHandle = (U32)serBuf;

	pHCCmd->PhyDevice.InterfaceNum = PhyDevice.InterfaceNum;
	pHCCmd->PhyDevice.PhyAddr = PhyDevice.PhyAddr;
	pHCCmd->L2Intf = L2Intf;

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_extcmd));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeUpdateLineSpeedSer										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to update the phy line speed.			  */
/*																  */
/* PARAMETERS:													  */
/*				PhyDevice-	Physical device to be configured	  */
/*				LineSpeed-	The new line speeds for the phy		  */
/*																  */
/******************************************************************/
U32 MspPeUpdateLineSpeedSer( void						*pCmd,
							 void						*pParam1,
							 void						*pParam2,	
							 void						*pParam3,
							 serializationTaskData		*pSerData)
{
	msp_buf							*serBuf;
	msp_pe_update_phy_linespeed		*pUpdLS;
	msp_ped_extcmd					xCmd;
	msp_ped_extcmd					*pXCmd = &xCmd;
	msp_ped_update_phy_linespeed	*pULCmd;
	U32								peXCmdAddr;

	serBuf = (msp_buf *)pParam1;
	pUpdLS = (msp_pe_update_phy_linespeed *)MspGetBufferStartOfData(serBuf);

	FE->LineSpeed[pUpdLS->PhyDevice.InterfaceNum].RxLineSpeed =
					pUpdLS->LineSpeed.RxLineSpeed;
	FE->LineSpeed[pUpdLS->PhyDevice.InterfaceNum].TxLineSpeed =
					pUpdLS->LineSpeed.TxLineSpeed;


	/* Now setup the Extended command structure */
	peXCmdAddr = (U32)serBuf->dataBuffer;
	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_update_phy_linespeed);

	/* Now setup the HDLC L2 Config Command structure */
	pULCmd = (msp_ped_update_phy_linespeed *)peXCmdAddr;
	pULCmd->CmdId = MSP_PED_UPDATE_PHY_LINESPEED;
	pULCmd->HsHandle = (U32)serBuf;

	/* The rest of the structure is already there */

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_extcmd));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetPhyStatsSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a specific Phy's statistics.	  */
/*																  */
/* PARAMETERS:													  */
/*				phyDevice-	Physical device to get stats from	  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeGetPhyStatsSer(void						*pCmd,
						void						*pParam1,
						void						*pParam2,	
						void						*pParam3,
						serializationTaskData		*pSerData)
{
	msp_ped_get_phy_stats	xCmd;
	msp_ped_get_phy_stats	*pGSCmd = &xCmd;
	U32						callerRefId;
	msp_buf					*serBuf;
	void					(*completeFunc)( msp_pe_resp *pFeResp,
											 msp_pe_phy_stats *pStat);
	msp_pe_phy_device		*phyDevice;
	msp_pe_resp				errorResp;
	msp_pe_phy_stats		errorStats;

	completeFunc = pParam1;
	callerRefId = (U32)pParam2;
	serBuf = (msp_buf *)pParam3;

	phyDevice = (msp_pe_phy_device *)serBuf->dataBuffer;

	FE->PhyGETcompleteFunc = completeFunc;
	FE->PhyGetRefId = callerRefId;

	pGSCmd->CmdId = MSP_PED_GET_PHY_STATS_CMD;
	pGSCmd->StatBufPtr = (U32)&FE->PStats;
	pGSCmd->PhyDevice.InterfaceNum = phyDevice->InterfaceNum;
	pGSCmd->PhyDevice.PhyAddr = phyDevice->PhyAddr;
	
	/* Finished with the msp buffer used for serialization */
	MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pGSCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_get_pe_stats));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddVcRxTxSetup											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is an internally used routine that sets up a VC's */
/* Rx and Tx buffer descriptor rings.							  */
/*																  */
/* PARAMETERS:													  */
/*				 PeVcHandle-	 Handle of VC just added	      */
/*																  */
/******************************************************************/
void MspPeAddVcTxRxSetup(U32 PeVcHandle )
{
	U32						currRxBdLoc;
	msp_ped_rxbd			*currRxBd;
	U32						currTxBdLoc;
	msp_ped_txbd			*currTxBd;
	msp_buf					*currMspBuf;
	U32						RxRingByteSize;
	U32						TxRingByteSize;
	
	VC[PeVcHandle]->NumTxBDs = MSP_PE_NUM_TXBDS_DEFAULT;
	VC[PeVcHandle]->NumRxBDs = MSP_PE_NUM_RXBDS_DEFAULT;
		
	/* Provision memory for rx buffer descriptors */
	VC[PeVcHandle]->RxBDs = MspPeGetRxBDMem(VC[PeVcHandle]->NumRxBDs);

	/* Setup in use ring of receive buffer descriptors */
	/* Giving 256 bytes of prepend space */
	/* This may change for AAL2 packets */
	if ( VC[PeVcHandle]->RxBufferSize < 512)
		VC[PeVcHandle]->RxMspFifo = MspFIFOBufAllocate( VC[PeVcHandle]->NumRxBDs,
														VC[PeVcHandle]->RxBufferSize,
														MSP_BUF_NOAPPEND_8_BYTES,
														MSP_PE_OWNER_ID,
														DONT_GET_RTOS_BUFFER);
	else
		VC[PeVcHandle]->RxMspFifo = MspFIFOBufAllocate( VC[PeVcHandle]->NumRxBDs,
														VC[PeVcHandle]->RxBufferSize+MSP_BUF_NOAPPEND_64_BYTES,
														 MSP_BUF_NOAPPEND_64_BYTES,
														MSP_PE_OWNER_ID,
														DONT_GET_RTOS_BUFFER);

	/* Go through each Rx buffer descriptor and set the BufAddr */
	/* to an MSP buffer dataBuffer pointer and set flags.		*/
	currRxBdLoc = (U32)VC[PeVcHandle]->RxBDs;
	currMspBuf = VC[PeVcHandle]->RxMspFifo->pGet;

	while (currMspBuf != NULL) {
		currRxBd = (msp_ped_rxbd *)currRxBdLoc;
		/* currMspBuf->prependStart = 511; */
		currRxBd->BufAddr = (U32)MspGetBufferStartOfData(currMspBuf);
		currRxBd->RxSize = VC[PeVcHandle]->RxBufferSize;
		currRxBd->Flags = 0;
		currRxBd->Flags |= MSP_PED_RXBD_READY_FLAG;
		if (VC[PeVcHandle]->IndMode == MSP_PE_VC_INTERRUPT_MODE)
			currRxBd->Flags |= MSP_PED_RXBD_INTERRUPT_FLAG;
		/* Increment the RxBd and the Msp in-use fifo */
		currRxBdLoc += sizeof(msp_ped_rxbd);
		currMspBuf = currMspBuf->pNext;
	}

	/* Setup the address values for receive on the VC */
	RxRingByteSize = sizeof(msp_ped_rxbd) * VC[PeVcHandle]->NumRxBDs;
	VC[PeVcHandle]->RxFirst = VC[PeVcHandle]->RxHead = VC[PeVcHandle]->RxTail = (U32)(VC[PeVcHandle]->RxBDs);
	VC[PeVcHandle]->RxLast = VC[PeVcHandle]->RxFwPtr =
						VC[PeVcHandle]->RxFirst + RxRingByteSize - sizeof(msp_ped_rxbd);
	   
	/* Provision memory for tx buffer descriptors */
	VC[PeVcHandle]->TxBDs = MspPeGetTxBDMem(VC[PeVcHandle]->NumTxBDs);

	/* Setup in use ring of transmit buffer descriptors */
	/* (stays empty until we get a transmit request)	*/
	VC[PeVcHandle]->TxMspFifo = MspFIFOBdInUseInit();

	/* Setup the address values for transmit on the VC */
	TxRingByteSize = sizeof(msp_ped_txbd) * VC[PeVcHandle]->NumTxBDs;
	VC[PeVcHandle]->TxFirst = VC[PeVcHandle]->TxHead = VC[PeVcHandle]->TxTail = (U32)(VC[PeVcHandle]->TxBDs);
	VC[PeVcHandle]->TxLast = VC[PeVcHandle]->TxFirst + TxRingByteSize - sizeof(msp_ped_txbd);

	/* Initialize Tx Buffer Descriptors */ 
	currTxBdLoc = VC[PeVcHandle]->TxFirst;
	while (currTxBdLoc <= VC[PeVcHandle]->TxLast) {
		currTxBd = (msp_ped_txbd *)currTxBdLoc;
		currTxBd->BufAddr = 0;
		currTxBd->BufLen = 0;
		currTxBd->Flags = 0;
		currTxBdLoc += sizeof(msp_ped_txbd);
	}
#if PMR
	SYNC();
#endif
}

/******************************************************************/
/*																  */
/* MspPeAddAtmVcSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to provision an ATM VC to the Packet	  */
/* Engine.														  */
/*																  */
/* PARAMETERS:													  */
/*				pVcSet- pointer to structure containing VC		  */
/*						properties								  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeAddAtmVcSer(void					*pCmd,
					 void					*pParam1,
					 void					*pParam2,	
					 void					*pParam3,
					 serializationTaskData	*pSerData)
{
	int						intLevel;
	msp_buf					*serBuf;
	msp_pe_atm_vc			*pVcSet;
	void					(*completeFunc)(msp_pe_resp *pFeResp);
	U32						callerRefId;
	msp_ped_extcmd			xCmd;
	msp_ped_extcmd			*pXCmd = &xCmd;
	msp_ped_add_vc_atm		*pAACmd;
	U32						clrVc;
	U32						RxRingByteSize;
	U32						TxRingByteSize;
	U32						peXCmdAddr;
	msp_pe_resp				errorResp;
	U32						tempVc;

	/* INCOMPLETE-	cast needed */
	completeFunc = pParam1;
	callerRefId = (U32)pParam2;
	serBuf = (msp_buf *)pParam3;
	pVcSet = (msp_pe_atm_vc *)
		(serBuf->dataBuffer +
		sizeof(msp_ped_add_vc_atm) - 
		sizeof(msp_pe_atm_vc));

#ifdef PE_ADD_ATM_DEBUG
	printf("AATM (SER):	 Entering AddAtmVcSer\n");
#endif

	/* Do error checking */

	/* Lock out interrupt */
	intLevel = intLock();

	/* Find next available VC index */
	clrVc = FEFirstVcIndex;
	while(VC[clrVc]->used) 
	{
		if (clrVc != FELastVcIndex)
		{
			clrVc++;
		}
		else
		{
			intUnlock(intLevel);
	
			/* Finished with the msp buffer used for serialization */
			MspFIFOBufInUsePut(PESerialFifoBig, serBuf);
			errorResp.CallerRefId = callerRefId;
			errorResp.Status = MSP_PE_ERROR_NO_VC_AVAIL;
			(*completeFunc)(&errorResp);
			return (MSP_PE_ERRORS);
		}
	}


	VC[clrVc]->used = 1;
	intUnlock(intLevel);

	/* If the Vpi and Vci aren't unique, error out */
	for (tempVc = FEFirstVcIndex; tempVc < MSP_PE_MAX_VCS; tempVc++) 
	{
		if (VC[tempVc]->used) 
		{
			if ((VC[tempVc]->AtmVcFlds.Vpi == pVcSet->ComFlds.Vpi) 
			&&  (VC[tempVc]->AtmVcFlds.Vci == pVcSet->ComFlds.Vci) 
			&&  (VC[tempVc]->AtmVcFlds.PhyDevice.InterfaceNum ==
						pVcSet->ComFlds.PhyDevice.InterfaceNum))
			{
				/* release reservation */
				VC[clrVc]->used = 0;

				/* Finished with the msp buffer used for serialization */
				MspFIFOBufInUsePut(PESerialFifoBig, serBuf);
				errorResp.CallerRefId = callerRefId;
				errorResp.Status = MSP_PE_ERROR_ADDVC_ALREADY_ADDED;
				printf("new phydev=%d, old phydev=%d\n",
					pVcSet->ComFlds.PhyDevice.InterfaceNum,
					VC[tempVc]->AtmVcFlds.PhyDevice.InterfaceNum);
				(*completeFunc)(&errorResp);
				return (MSP_PE_ERRORS);
			} 
		}
	}

	/* Set attributes in the VC structure from the user */

	VC[clrVc]->VcType = PE_VCTYPE_ATM;
	VC[clrVc]->NextPeVcHandle = 0;
	VC[clrVc]->Enabled = 0;
	VC[clrVc]->IndMode = pVcSet->IndMode;
	VC[clrVc]->UserTxIdHead = VC[clrVc]->UserTxIdTail = 0;
	VC[clrVc]->UserRxId = pVcSet->UserRxId;
	VC[clrVc]->UserErrorId = pVcSet->UserErrorId;
	VC[clrVc]->TxCompleteFunc = pVcSet->TxCompleteFunc;
	VC[clrVc]->RxCompleteFunc = pVcSet->RxCompleteFunc;
	VC[clrVc]->ErrorFunc = pVcSet->ErrorFunc;
	VC[clrVc]->AddRefId = callerRefId;

	VC[clrVc]->AtmVcFlds.PhyDevice.InterfaceNum =
				pVcSet->ComFlds.PhyDevice.InterfaceNum;
	VC[clrVc]->AtmVcFlds.PhyDevice.PhyAddr = 
				pVcSet->ComFlds.PhyDevice.PhyAddr;

	VC[clrVc]->AtmVcFlds.Vpi = pVcSet->ComFlds.Vpi;
	VC[clrVc]->AtmVcFlds.Vci = pVcSet->ComFlds.Vci;
	VC[clrVc]->AtmVcFlds.VcType = pVcSet->ComFlds.VcType;
	
	if (pVcSet->ComFlds.VcType == MSP_PE_ATM_VCTYPE_AAL0)
		VC[clrVc]->TxAal0Restriction = 1;
	else
		VC[clrVc]->TxAal0Restriction = 0;
		
	if (pVcSet->ComFlds.VcType == MSP_PE_ATM_VCTYPE_AAL2)
		VC[clrVc]->TxAal2Restriction = 1;
	else
		VC[clrVc]->TxAal2Restriction = 0;

	VC[clrVc]->AtmVcFlds.ParMod.SrvType = 
				pVcSet->ComFlds.ParMod.SrvType;
	VC[clrVc]->AtmVcFlds.ParMod.PeakCellRate = 
				pVcSet->ComFlds.ParMod.PeakCellRate;
	VC[clrVc]->AtmVcFlds.ParMod.SustainedCellRate = 
				pVcSet->ComFlds.ParMod.SustainedCellRate;
	VC[clrVc]->AtmVcFlds.ParMod.MaxBurstSize = 
				pVcSet->ComFlds.ParMod.MaxBurstSize;
	VC[clrVc]->AtmVcFlds.ParMod.MinCellRate = 
				pVcSet->ComFlds.ParMod.MinCellRate;
	VC[clrVc]->AtmVcFlds.ParMod.VcFlags = 
				pVcSet->ComFlds.ParMod.VcFlags;
	VC[clrVc]->AtmVcFlds.ParMod.VoiceProtocolType = 
				pVcSet->ComFlds.ParMod.VoiceProtocolType;
	VC[clrVc]->AtmVcFlds.ParMod.MTU = 
				pVcSet->ComFlds.ParMod.MTU;
	VC[clrVc]->AtmVcFlds.ParMod.MRU = 
				pVcSet->ComFlds.ParMod.MRU;

	VC[clrVc]->completeFunc = completeFunc;
	VC[clrVc]->RxBufferSize = pVcSet->ComFlds.ParMod.MRU;

	MspPeAddVcTxRxSetup(clrVc);

	/* That's it for error checking, the XCmd will go out.		*/

	/* Now setup the Extended command structure */
	peXCmdAddr = (U32)serBuf->dataBuffer;	  


	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_add_vc_atm);

	VC[clrVc]->AddSerBufAddr = serBuf;
	pAACmd = (msp_ped_add_vc_atm *)peXCmdAddr;
	pAACmd->CmdId = MSP_PED_ADD_VC_CMD;
	pAACmd->HsHandle = clrVc;

	pAACmd->TxBdBaseAddr = (U32)VC[clrVc]->TxBDs;
	TxRingByteSize = sizeof(msp_ped_txbd) * VC[clrVc]->NumTxBDs;
	pAACmd->TxBdSize = TxRingByteSize;
	pAACmd->RxBdBaseAddr = (U32)VC[clrVc]->RxBDs;
	RxRingByteSize = sizeof(msp_ped_rxbd) * VC[clrVc]->NumRxBDs;
	pAACmd->RxBdSize = RxRingByteSize;

	/* The rest of the structure is already there */

#ifdef PE_ADD_ATM_DEBUG
	printf("AATM (SER):	 About to copy down command\n");
#endif

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_extcmd));

#ifdef PE_ADD_ATM_DEBUG
	printf("AATM (SER):	 Exiting AddAtmVcSer:\n");
#endif

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddFrVcSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to provision a FR VC to the Packet	  */
/* Engine.														  */
/*																  */
/* PARAMETERS:													  */
/*				pVcSet- pointer to structure containing VC		  */
/*						properties								  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeAddFrVcSer(void			*pCmd,
			void			*pParam1,
			void			*pParam2,	
			void			*pParam3,
			serializationTaskData	*pSerData)
{
	int						intLevel;
	msp_buf					*serBuf;
	msp_pe_fr_vc			*pVcSet;
	void					(*completeFunc)(msp_pe_resp *pFeResp);
	U32						callerRefId;
	msp_ped_extcmd			*xCmd;
	msp_ped_extcmd			*pXCmd = &xCmd;
	msp_ped_add_vc_fr		*pAFCmd;
	U32						clrVc;
	U32						TxRingByteSize;
	U32						RxRingByteSize;
	U32						peXCmdAddr;
	msp_pe_resp				errorResp;

	/* INCOMPLETE-	cast needed */
	completeFunc = pParam1;
	callerRefId = (U32)pParam2;
	serBuf = (msp_buf *)pParam3;
	pVcSet = (msp_pe_fr_vc *)serBuf->dataBuffer;

#ifdef PE_ADD_FR_DEBUG
	printf("AFR (SER):	Entering AddFrVcSer\n");
#endif

	intLevel = intLock();

	/* Find next available VC index */
	clrVc = FEFirstVcIndex;
	while(VC[clrVc]->used) 
	{
		if (clrVc != FELastVcIndex)
		{
			clrVc++;
		}
		else
		{
			intUnlock(intLevel);

			/* Finished with the msp buffer used for serialization */
			MspFIFOBufInUsePut(PESerialFifoBig, serBuf);
			errorResp.CallerRefId = callerRefId;
			errorResp.Status = MSP_PE_ERROR_NO_VC_AVAIL;
			(*completeFunc)(&errorResp);
			return (MSP_PE_ERRORS);
		}
	}

	/* Set attributes in the VC structure from the user */
	VC[clrVc]->used = 1;
	intUnlock(intLevel);

	VC[clrVc]->VcType = PE_VCTYPE_FR;
	VC[clrVc]->Enabled = 0;
	VC[clrVc]->IndMode = pVcSet->IndMode;
	VC[clrVc]->UserTxIdHead = VC[clrVc]->UserTxIdTail = 0;
	VC[clrVc]->UserRxId = pVcSet->UserRxId;
	VC[clrVc]->UserErrorId = pVcSet->UserErrorId;
	VC[clrVc]->TxCompleteFunc = pVcSet->TxCompleteFunc;
	VC[clrVc]->RxCompleteFunc = pVcSet->RxCompleteFunc;
	VC[clrVc]->ErrorFunc = pVcSet->ErrorFunc;
	VC[clrVc]->AddRefId = callerRefId;

	VC[clrVc]->FrVcFlds.PhyDevice.InterfaceNum =
				pVcSet->ComFlds.PhyDevice.InterfaceNum;
	VC[clrVc]->FrVcFlds.PhyDevice.PhyAddr = 
				pVcSet->ComFlds.PhyDevice.PhyAddr;

	VC[clrVc]->FrVcFlds.VcType = pVcSet->ComFlds.VcType;
	VC[clrVc]->FrVcFlds.Dlci = pVcSet->ComFlds.Dlci;

	VC[clrVc]->FrVcFlds.ParMod.Bc = 
				pVcSet->ComFlds.ParMod.Bc;
	VC[clrVc]->FrVcFlds.ParMod.Be = 
				pVcSet->ComFlds.ParMod.Be;
	VC[clrVc]->FrVcFlds.ParMod.FragmentSize = 
				pVcSet->ComFlds.ParMod.FragmentSize;
	VC[clrVc]->FrVcFlds.ParMod.VcFlags = 
				pVcSet->ComFlds.ParMod.VcFlags;
	VC[clrVc]->FrVcFlds.ParMod.VoiceProtocolType = 
				pVcSet->ComFlds.ParMod.VoiceProtocolType;
	VC[clrVc]->FrVcFlds.ParMod.MTU = 
				pVcSet->ComFlds.ParMod.MTU;
	VC[clrVc]->FrVcFlds.ParMod.MRU = 
				pVcSet->ComFlds.ParMod.MRU;

	VC[clrVc]->NumTxBDs = MSP_PE_NUM_TXBDS_DEFAULT;
	VC[clrVc]->NumRxBDs = MSP_PE_NUM_RXBDS_DEFAULT;
		
	VC[clrVc]->completeFunc = completeFunc;
	VC[clrVc]->RxBufferSize = pVcSet->ComFlds.ParMod.MRU;

	MspPeAddVcTxRxSetup(clrVc);

	/* That's it for error checking, the XCmd will go out.		*/

	/* Now setup the Extended command structure */
	peXCmdAddr = (U32)serBuf->dataBuffer;	  

	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_add_vc_fr);

	VC[clrVc]->AddSerBufAddr = serBuf;
	pAFCmd = (msp_ped_add_vc_fr *)peXCmdAddr;
	pAFCmd->CmdId = MSP_PED_ADD_VC_CMD;
	pAFCmd->HsHandle = clrVc;

	pAFCmd->TxBdBaseAddr = (U32)VC[clrVc]->TxBDs;
	TxRingByteSize = sizeof(msp_ped_txbd) * VC[clrVc]->NumTxBDs;
	pAFCmd->TxBdSize = TxRingByteSize;
	pAFCmd->RxBdBaseAddr = (U32)VC[clrVc]->RxBDs;
	RxRingByteSize = sizeof(msp_ped_rxbd) * VC[clrVc]->NumRxBDs;
	pAFCmd->RxBdSize = RxRingByteSize;

	/* The rest of the structure is already there */

#ifdef PE_ADD_FR_DEBUG
	printf("AFR (SER):	About to copy down command\n");
#endif

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_extcmd));

#ifdef PE_ADD_FR_DEBUG
	printf("AFR (SER):	Exiting AddFrVcSer:\n");
#endif

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddHdlcVcSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to provision an HDLC VC to the Packet	  */
/* Engine.														  */
/*																  */
/* PARAMETERS:													  */
/*				pVcSet- pointer to structure containing VC		  */
/*						properties								  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeAddHdlcVcSer(void					*pCmd,
					  void					*pParam1,
					  void					*pParam2,	
					  void					*pParam3,
					  serializationTaskData *pSerData)
{
	int						intLevel;
	msp_buf					*serBuf;
	msp_pe_hdlc_vc			*pVcSet;
	void					(*completeFunc)(msp_pe_resp *pFeResp);
	U32						callerRefId;
	msp_ped_extcmd			xCmd;
	msp_ped_extcmd			*pXCmd = &xCmd;
	msp_ped_add_vc_hdlc		*pAHCmd;
	U32						clrVc;
	U32						RxRingByteSize;
	U32						TxRingByteSize;
	U32						peXCmdAddr;
	msp_pe_resp				errorResp;

	/* INCOMPLETE-	cast needed */
	completeFunc = pParam1;
	callerRefId = (U32)pParam2;
	serBuf = (msp_buf *)pParam3;
	pVcSet = (msp_pe_hdlc_vc *)serBuf->dataBuffer;

#ifdef PE_ADD_HDLC_DEBUG
	printf("AHDL (SER):	 Entering AddHdlcVcSer\n");
#endif

	/* Do error checking */

	/* Lock out interrupt */
	intLevel = intLock();

	/* Find next available VC index */
	clrVc = FEFirstVcIndex;
	while(VC[clrVc]->used) 
	{
		if (clrVc != FELastVcIndex)
		{
			clrVc++;
		}
		else
		{
			intUnlock(intLevel);
	
			/* Finished with the msp buffer used for serialization */
			MspFIFOBufInUsePut(PESerialFifoBig, serBuf);
			errorResp.CallerRefId = callerRefId;
			errorResp.Status = MSP_PE_ERROR_NO_VC_AVAIL;
			(*completeFunc)(&errorResp);
			return (MSP_PE_ERRORS);
		}
	}

	/* Set attributes in the VC structure from the user */
	VC[clrVc]->used = 1;
	intUnlock(intLevel);
	
	VC[clrVc]->VcType = PE_VCTYPE_HDLC;
	VC[clrVc]->Enabled = 0;
	VC[clrVc]->IndMode = pVcSet->IndMode;
	VC[clrVc]->UserTxIdHead = VC[clrVc]->UserTxIdTail = 0;
	VC[clrVc]->UserRxId = pVcSet->UserRxId;
	VC[clrVc]->UserErrorId = pVcSet->UserErrorId;
	VC[clrVc]->TxCompleteFunc = pVcSet->TxCompleteFunc;
	VC[clrVc]->RxCompleteFunc = pVcSet->RxCompleteFunc;
	VC[clrVc]->ErrorFunc = pVcSet->ErrorFunc;
	VC[clrVc]->AddRefId = callerRefId;

	VC[clrVc]->HdlcVcFlds.PhyDevice.InterfaceNum =
				pVcSet->ComFlds.PhyDevice.InterfaceNum;
	VC[clrVc]->HdlcVcFlds.PhyDevice.PhyAddr = 
				pVcSet->ComFlds.PhyDevice.PhyAddr;
	VC[clrVc]->HdlcVcFlds.MTU = 
				pVcSet->ComFlds.MTU;
	VC[clrVc]->HdlcVcFlds.MRU = 
				pVcSet->ComFlds.MRU;

	VC[clrVc]->NumTxBDs = MSP_PE_NUM_TXBDS_DEFAULT;
	VC[clrVc]->NumRxBDs = MSP_PE_NUM_RXBDS_DEFAULT;
		
	VC[clrVc]->completeFunc = completeFunc;
	VC[clrVc]->RxBufferSize = pVcSet->ComFlds.MRU;

	MspPeAddVcTxRxSetup(clrVc);

	/* That's it for error checking, the XCmd will go out.		*/

	/* Now setup the Extended command structure */
	peXCmdAddr = (U32)serBuf->dataBuffer;	  

	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_add_vc_hdlc);

	VC[clrVc]->AddSerBufAddr = serBuf;
	pAHCmd = (msp_ped_add_vc_hdlc *)peXCmdAddr;
	pAHCmd->CmdId = MSP_PED_ADD_VC_CMD;
	pAHCmd->HsHandle = clrVc;

	pAHCmd->TxBdBaseAddr = (U32)VC[clrVc]->TxBDs;
	TxRingByteSize = sizeof(msp_ped_txbd) * VC[clrVc]->NumTxBDs;
	pAHCmd->TxBdSize = TxRingByteSize;
	pAHCmd->RxBdBaseAddr = (U32)VC[clrVc]->RxBDs;
	RxRingByteSize = sizeof(msp_ped_rxbd) * VC[clrVc]->NumRxBDs;
	pAHCmd->RxBdSize = RxRingByteSize;

	/* The rest of the structure is already there */

#ifdef PE_ADD_HDLC_DEBUG
	printf("AHDL (SER):	 About to copy down command\n");
#endif

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_extcmd));

#ifdef PE_ADD_HDLC_DEBUG
	printf("AHDL (SER):	 Exiting AddHdlcVcSer:\n");
#endif

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeDelVcSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to delete a VC from the WAN interface.  */
/*																  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of VC to be removed			  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeDelVcSer(void						*pCmd,
				  void						*pParam1,
				  void						*pParam2,	
				  void						*pParam3,
				  serializationTaskData		*pSerData)
{
	U32					peVcHandle;
	void				(*completeFunc)(msp_pe_resp *pFeResp);
	U32					callerRefId;
	msp_ped_gen_cmd		xCmd;
	msp_ped_gen_cmd		*pGCmd = &xCmd;
	msp_pe_resp			errorResp;

	peVcHandle = (U32)pParam1;
	/* INCOMPLETE-	cast needed */
	completeFunc = pParam2;
	callerRefId = (U32)pParam3;

	if (!(VC[peVcHandle]->used)) {

		errorResp.CallerRefId = callerRefId;
		errorResp.Status = MSP_PE_ERROR_VC_BAD_PEVCHANDLE;
		(*completeFunc)(&errorResp);
		return (MSP_PE_ERRORS);
	}

	/* Replace the add vc completion function with this one */
	VC[peVcHandle]->completeFunc = completeFunc;
	VC[peVcHandle]->DelRefId = callerRefId;


	pGCmd->CmdId = MSP_PED_DEL_VC_CMD;
	pGCmd->HsHandle = peVcHandle;
	pGCmd->PedVcHandle = VC[peVcHandle]->PedVcHandle;
	
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pGCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_gen_cmd));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeEnableVcSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to enable a VC on the WAN interface.	  */
/*																  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of VC to be enabled			  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeEnableVcSer(void						*pCmd,
					 void						*pParam1,
					 void						*pParam2,	
					 void						*pParam3,
					 serializationTaskData		*pSerData)

{
	U32					peVcHandle;
	void				(*completeFunc)(msp_pe_resp *pFeResp);
	U32					callerRefId;
	msp_ped_gen_cmd		xCmd;
	msp_ped_gen_cmd		*pGCmd = &xCmd;
	msp_pe_resp			errorResp;

	peVcHandle = (U32)pParam1;
	/* INCOMPLETE-	cast needed */
	completeFunc = pParam2;
	callerRefId = (U32)pParam3;

#ifdef PE_ENAVC_DEBUG
	printf("EVC (SER):	Entering EnableVc\n");
#endif


	if (!(VC[peVcHandle]->used)) 
	{
		errorResp.CallerRefId = callerRefId;
		errorResp.Status = MSP_PE_ERROR_VC_BAD_PEVCHANDLE;
		(*completeFunc)(&errorResp);
		return (MSP_PE_ERRORS);
	}

	/* The enable/disable routines share this VC record */
	VC[peVcHandle]->EDcompleteFunc = completeFunc;
	VC[peVcHandle]->EnaRefId = callerRefId;


	pGCmd->CmdId = MSP_PED_ENABLE_VC_CMD;
	pGCmd->HsHandle = peVcHandle;
	pGCmd->PedVcHandle = VC[peVcHandle]->PedVcHandle;
	
#ifdef PE_ENAVC_DEBUG
	printf("EVC (SER):	Sending command down\n");
#endif

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pGCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_gen_cmd));

#ifdef PE_ENAVC_DEBUG
	printf("EVC (SER):	Exiting EnableVc\n");
#endif

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeDisableVcSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to disable a VC on the WAN interface.	  */
/*																  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of VC to be disabled			  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeDisableVcSer(void						*pCmd,
					  void						*pParam1,
					  void						*pParam2,	
					  void						*pParam3,
					  serializationTaskData		*pSerData)
{
	U32					peVcHandle;
	void				(*completeFunc)(msp_pe_resp *pFeResp);
	U32					callerRefId;
	msp_ped_gen_cmd		xCmd;
	msp_ped_gen_cmd		*pGCmd = &xCmd;
	msp_pe_resp			errorResp;

	peVcHandle = (U32)pParam1;
	/* INCOMPLETE-	cast needed */
	completeFunc = pParam2;
	callerRefId = (U32)pParam3;

	if (!(VC[peVcHandle]->used)) 
	{
		errorResp.CallerRefId = callerRefId;
		errorResp.Status = MSP_PE_ERROR_VC_BAD_PEVCHANDLE;
		(*completeFunc)(&errorResp);
		return (MSP_PE_ERRORS);
	}

	/* Replace the add vc completion function with this one */
	VC[peVcHandle]->EDcompleteFunc = completeFunc;
	VC[peVcHandle]->DisRefId = callerRefId;

	pGCmd->CmdId = MSP_PED_DISABLE_VC_CMD;
	pGCmd->HsHandle = peVcHandle;
	pGCmd->PedVcHandle = VC[peVcHandle]->PedVcHandle;
	
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pGCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_gen_cmd));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeModAtmVcSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify an existing Atm VC's		  */
/* attributes.													  */
/*																  */
/* PARAMETERS:													  */
/*				pVcMod- pointer to structure containing Atm VC	  */
/*						properties								  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeModAtmVcSer(void						*pCmd,
					 void						*pParam1,
					 void						*pParam2,	
					 void						*pParam3,
					 serializationTaskData		*pSerData)
{
	msp_buf					*serBuf;
	msp_pe_mod_vc_atm		*pVcMod;
	void					(*completeFunc)(msp_pe_resp *pFeResp);
	U32						callerRefId;
	msp_ped_extcmd			*xCmd;
	msp_ped_extcmd			*pXCmd = &xCmd;
	msp_ped_mod_vc_atm		*pMACmd;
	U32						peVcHandle;
	U32						*pVcHandle;
	U32						peXCmdAddr;
	msp_pe_resp				errorResp;

	/* INCOMPLETE-	cast needed */
	completeFunc = pParam1;
	callerRefId = (U32)pParam2;
	serBuf = (msp_buf *)pParam3;
	pVcMod = (msp_pe_mod_vc_atm *)
		(serBuf->dataBuffer +
		(sizeof(msp_ped_mod_vc_atm) + 4) - 
		sizeof(msp_pe_mod_vc_atm));

	/* Store all the values in the		*/
	/* global VC attribute structure	*/
	peVcHandle = pVcMod->PeVcHandle;

	VC[peVcHandle]->MODcompleteFunc = completeFunc;
	VC[peVcHandle]->ModRefId = callerRefId;

	/* The non-blocking function fills in fields assuming the	*/
	/* modification is successful.	If it fails, the vc attribs */
	/* aren't correct and the modification should be done again */
	if (pVcMod->ComFlds.SrvType != MSP_PE_NO_CHANGE)
	{
		VC[peVcHandle]->AtmVcFlds.ParMod.SrvType = 
					pVcMod->ComFlds.SrvType;
	}
	if (pVcMod->ComFlds.PeakCellRate != MSP_PE_NO_CHANGE)
	{
		VC[peVcHandle]->AtmVcFlds.ParMod.PeakCellRate = 
					pVcMod->ComFlds.PeakCellRate;
	}
	if (pVcMod->ComFlds.SustainedCellRate != MSP_PE_NO_CHANGE)
	{
		VC[peVcHandle]->AtmVcFlds.ParMod.SustainedCellRate = 
					pVcMod->ComFlds.SustainedCellRate;
	}
	if (pVcMod->ComFlds.MaxBurstSize != MSP_PE_NO_CHANGE)
	{
		VC[peVcHandle]->AtmVcFlds.ParMod.MaxBurstSize = 
					pVcMod->ComFlds.MaxBurstSize;
	}
	if (pVcMod->ComFlds.MinCellRate != MSP_PE_NO_CHANGE)
	{
		VC[peVcHandle]->AtmVcFlds.ParMod.MinCellRate = 
					pVcMod->ComFlds.MinCellRate;
	}


	if (pVcMod->ComFlds.VcFlags != MSP_PE_NO_CHANGE)
	{
		VC[peVcHandle]->AtmVcFlds.ParMod.VcFlags = 
					pVcMod->ComFlds.VcFlags;
	}
	if (pVcMod->ComFlds.VoiceProtocolType != MSP_PE_NO_CHANGE)
	{
		VC[peVcHandle]->AtmVcFlds.ParMod.VoiceProtocolType = 
					pVcMod->ComFlds.VoiceProtocolType;
	}

	/* Now setup the Extended command structure */
	pVcHandle = (U32*)serBuf->dataBuffer;
	*pVcHandle = peVcHandle;
	peXCmdAddr = (U32)serBuf->dataBuffer + 4;	  /* The XCmd follows the PeVcHandle */

	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_mod_vc_atm);

	/* Now setup the ATM Mod VC Command structure */
	pMACmd = (msp_ped_mod_vc_atm *)peXCmdAddr;
	pMACmd->CmdId = MSP_PED_MOD_VC_CMD;
	pMACmd->HsHandle = (U32)serBuf;
	pMACmd->PedVcHandle = VC[peVcHandle]->PedVcHandle;
	
	/* For now don't change these. */
	pMACmd->PeakCellEmissionTime = MSP_PE_NO_CHANGE;
	pMACmd->SustainedCellEmissionTime = MSP_PE_NO_CHANGE;
	pMACmd->BurstThreshold = MSP_PE_NO_CHANGE;

	/* The rest of the structure is already there */

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_extcmd));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeModFrVcSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify an existing Frame Relay VC's  */
/* attributes.													  */
/*																  */
/* PARAMETERS:													  */
/*				pVcMod- pointer to structure containing Fr VC	  */
/*						properties								  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeModFrVcSer(void						*pCmd,
					void						*pParam1,
					void						*pParam2,	
					void						*pParam3,
					serializationTaskData		*pSerData)
{
	msp_buf					*serBuf;
	msp_pe_mod_vc_fr		*pVcMod;
	void					(*completeFunc)(msp_pe_resp *pFeResp);
	U32						callerRefId;
	msp_ped_extcmd			xCmd;
	msp_ped_extcmd			*pXCmd = &xCmd;
	msp_ped_mod_vc_fr		*pMFCmd;
	U32						peVcHandle;
	U32						*pVcHandle;
	U32						peXCmdAddr;
	msp_pe_resp				errorResp;

	/* INCOMPLETE-	cast needed */
	completeFunc = pParam1;
	callerRefId = (U32)pParam2;
	serBuf = (msp_buf *)pParam3;
	pVcMod = (msp_pe_mod_vc_fr *)MspGetBufferStartOfData(serBuf);

	peVcHandle = pVcMod->PeVcHandle;

	VC[peVcHandle]->MODcompleteFunc = completeFunc;
	VC[peVcHandle]->ModRefId = callerRefId;

	/* The non-blocking function fills in fields assuming the	*/
	/* modification is successful.	If it fails, the vc attribs */
	/* aren't correct and the modification should be done again */
	VC[peVcHandle]->FrVcFlds.ParMod.Bc = pVcMod->ComFlds.Bc;
	VC[peVcHandle]->FrVcFlds.ParMod.Be = pVcMod->ComFlds.Be;
	VC[peVcHandle]->FrVcFlds.ParMod.FragmentSize = 
				pVcMod->ComFlds.FragmentSize;
	VC[peVcHandle]->FrVcFlds.ParMod.VcFlags = 
				pVcMod->ComFlds.VcFlags;
	VC[peVcHandle]->FrVcFlds.ParMod.VoiceProtocolType = 
				pVcMod->ComFlds.VoiceProtocolType;


	/* Now setup the Extended command structure */
	pVcHandle = (U32*)serBuf->dataBuffer;
	*pVcHandle = peVcHandle;
	peXCmdAddr = (U32)serBuf->dataBuffer + 4;	  /* The XCmd follows the PeVcHandle */

	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_mod_vc_fr);

	/* Now setup the FR Mod VC Command structure */
	pMFCmd = (msp_ped_mod_vc_fr *)peXCmdAddr;
	pMFCmd->CmdId = MSP_PED_MOD_VC_CMD;
	pMFCmd->HsHandle = (U32)serBuf;
	pMFCmd->PedVcHandle = VC[peVcHandle]->PedVcHandle;

	/* The rest of the structure is already there */

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_extcmd));

	return (MSP_SUCCESS);
}


/******************************************************************/
/*																  */
/* MspPeGetAtmVcStatsSer										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular vc's statistics.	  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of Atm VC to get statistics	  */
/*							from.								  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeGetAtmVcStatsSer(void						*pCmd,
						  void						*pParam1,
						  void						*pParam2,	
						  void						*pParam3,
						  serializationTaskData		*pSerData)
{
	msp_buf					*serBuf;
	msp_pe_vc_stats_pars	*pGetPars;
	U32						peVcHandle;
	msp_ped_get_vc_stats	xCmd;
	msp_ped_get_vc_stats	*pGSCmd = &xCmd;
	U32						callerRefId;
	void					(*completeFunc)( msp_pe_resp *pFeResp,
										msp_pe_vc_stats_atm *pStat);
	msp_pe_resp				errorResp;
	msp_pe_vc_stats_atm		errorStats;

	serBuf = (msp_buf *)pParam1;
	pGetPars = (msp_pe_vc_stats_pars *)serBuf->dataBuffer;

	peVcHandle = pGetPars->PeVcHandle;
	completeFunc = pGetPars->AtmCompleteFunc;
	callerRefId = pGetPars->CallerRefId;

	pGSCmd->CmdId = MSP_PED_GET_VC_STATS_CMD;
	pGSCmd->HsHandle = (U32)serBuf;
	pGSCmd->PedVcHandle = VC[peVcHandle]->PedVcHandle;
	pGSCmd->StatBufPtr = (U32)&pGetPars->VcStats.AtmStats;
	
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pGSCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_get_vc_stats));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetFrVcStatsSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular vc's statistics.	  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of FR VC to get statistics	  */
/*							from.								  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeGetFrVcStatsSer(void						*pCmd,
						 void						*pParam1,
						 void						*pParam2,	
						 void						*pParam3,
						 serializationTaskData		*pSerData)
{
	msp_buf					*serBuf;
	msp_pe_vc_stats_pars	*pGetPars;
	U32						peVcHandle;
	msp_ped_get_vc_stats	xCmd;
	msp_ped_get_vc_stats	*pGSCmd = &xCmd;
	U32						callerRefId;
	void					(*completeFunc)( msp_pe_resp *pFeResp,
											msp_pe_vc_stats_fr *pStat);
	msp_pe_resp				errorResp;
	msp_pe_vc_stats_fr		errorStats;

	serBuf = (msp_buf *)pParam1;
	pGetPars = (msp_pe_vc_stats_pars *)serBuf->dataBuffer;

	peVcHandle = pGetPars->PeVcHandle;
	completeFunc = pGetPars->FrCompleteFunc;
	callerRefId = pGetPars->CallerRefId;

	pGSCmd->CmdId = MSP_PED_GET_VC_STATS_CMD;
	pGSCmd->HsHandle = (U32)serBuf;
	pGSCmd->PedVcHandle = VC[peVcHandle]->PedVcHandle;
	pGSCmd->StatBufPtr = (U32)&pGetPars->VcStats.FrStats;
	
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pGSCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_get_vc_stats));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetHdlcVcStatsSer										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular vc's statistics.	  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of Hdlc VC to get statistics	  */
/*							from.								  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeGetHdlcVcStatsSer(void						*pCmd,
						   void						*pParam1,
						   void						*pParam2,	
						   void						*pParam3,
						   serializationTaskData	*pSerData)
{
	msp_buf					*serBuf;
	msp_pe_vc_stats_pars	*pGetPars;
	U32						peVcHandle;
	msp_ped_get_vc_stats	xCmd;
	msp_ped_get_vc_stats	*pGSCmd = &xCmd;
	U32						callerRefId;
	void					(*completeFunc)( msp_pe_resp *pFeResp,
											msp_pe_vc_stats_hdlc *pStat);
	msp_pe_resp				errorResp;
	msp_pe_vc_stats_hdlc	errorStats;

	serBuf = (msp_buf *)pParam1;
	pGetPars = (msp_pe_vc_stats_pars *)serBuf->dataBuffer;

	peVcHandle = pGetPars->PeVcHandle;
	completeFunc = pGetPars->HdlcCompleteFunc;
	callerRefId = pGetPars->CallerRefId;

	pGSCmd->CmdId = MSP_PED_GET_VC_STATS_CMD;
	pGSCmd->HsHandle = (U32)serBuf;
	pGSCmd->PedVcHandle = VC[peVcHandle]->PedVcHandle;
	pGSCmd->StatBufPtr = (U32)&pGetPars->VcStats.HdlcStats;
	
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pGSCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_get_vc_stats));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddCidSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to add a CID channel for an AAL2 VC	  */
/* that has already been provisioned							  */
/*																  */
/* PARAMETERS:													  */
/*				pCiSet- pointer to structure containing CID		  */
/*						properties								  */
/*																  */
/*				completeFunc-  Function to be called upon CID	  */
/*						 addition completion					  */
/*																  */
/******************************************************************/

U32 MspPeAddCidSer(void						*pCmd,
				   void						*pParam1,
				   void						*pParam2,	
				   void						*pParam3,
				   serializationTaskData	*pSerData)
{
	int					intLevel;
	msp_buf				*serBuf;
	msp_pe_cid			*pCidSet;
	U32					callerRefId;
	void				(*completeFunc)(msp_pe_resp *pFeResp);
	msp_ped_extcmd		xCmd;
	msp_ped_extcmd		*pXCmd = &xCmd;
	msp_ped_add_cid		*pACCmd;
	U32					clrCid;
	U16					vpmPortHandle;
	U32					*pCidHandle;
	U32					peXCmdAddr;
	msp_pe_resp			errorResp;
	U32					peCidHandle;

	/* INCOMPLETE-	cast needed */
	completeFunc = pParam1;
	callerRefId = (U32)pParam2;
	serBuf = (msp_buf *)pParam3;
	pCidSet = (msp_pe_cid *)MspGetBufferStartOfData(serBuf);

#ifdef PE_ADD_CID_DEBUG
	printf("ACID (SER):	 Entering AddCidSer\n");
#endif

	/* Lock out interrupt */
	intLevel = intLock();


	/* Store all the values in the	*/
	/* global variable structure	*/

	/* Find next available CID index */
	clrCid = FEFirstCidIndex;
	while(CID[clrCid]->used) 
	{
		if (clrCid != FELastCidIndex)
		{
			clrCid++;
		}
		else
		{
			intUnlock(intLevel);
	
			/* Finished with the msp buffer used for serialization */
			MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);
			errorResp.CallerRefId = callerRefId;
			errorResp.Status = MSP_PE_ERROR_NO_CID_AVAIL;
			(*completeFunc)(&errorResp);
			return (MSP_PE_ERRORS);
		}
	}


	CID[clrCid]->used = 1;
	intUnlock(intLevel);
	
	CID[clrCid]->PeVcHandle = pCidSet->PeVcHandle;
	CID[clrCid]->PedVcHandle = VC[pCidSet->PeVcHandle]->PedVcHandle;
	CID[clrCid]->completeFunc = completeFunc;
	CID[clrCid]->VpmPort.source = pCidSet->VpmPort.source;
	CID[clrCid]->VpmPort.port = pCidSet->VpmPort.port;
	CID[clrCid]->CidFlds.CidNum = pCidSet->ComFlds.CidNum;
	CID[clrCid]->CidFlds.CidMode = pCidSet->ComFlds.CidMode;
	CID[clrCid]->CidFlds.ParMod.CidFlags =
				pCidSet->ComFlds.ParMod.CidFlags;
	CID[clrCid]->CidFlds.ParMod.VoiceProfileType =
				pCidSet->ComFlds.ParMod.VoiceProfileType;

	CID[clrCid]->AddRefId = callerRefId;

	/* Convert the users version of vpm_port to 16 bits */
	CONVERT_USER_PORTHANDLE(pCidSet->VpmPort.source,
							pCidSet->VpmPort.port,
							vpmPortHandle);

#ifdef PE_ADD_CID_DEBUG
	printf("ACID (SER):	 vpmporthandle converted: 0x%x\n",vpmPortHandle);
#endif	 

	/* Now setup the Extended command structure */
	pCidHandle = (U32*)serBuf->dataBuffer;
	peCidHandle = clrCid | MSP_PE_CID_HANDLE_BIT;
	*pCidHandle = peCidHandle;
	peXCmdAddr = (U32)serBuf->dataBuffer + 4;	  /* The XCmd follows the PeCidHandle */

	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_add_cid);

	pACCmd = (msp_ped_add_cid *)peXCmdAddr;
	pACCmd->CmdId = MSP_PED_ADD_CID_CMD;
	pACCmd->HsHandle = (U32)serBuf;
	pACCmd->PedVcHandle = CID[clrCid]->PedVcHandle;
	pACCmd->VpmdPortHandle = vpmPortHandle;

	/* The rest of the structure is already there */

#ifdef PE_ADD_CID_DEBUG
	printf("ACID (SER):	 About to copy down command\n");
#endif

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_extcmd));

#ifdef PE_ADD_CID_DEBUG
	printf("ACID (SER):	 Exiting AddCidSer:\n");
#endif

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeDelCidSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to delete a CID from the WAN interface  */
/*																  */
/* PARAMETERS:													  */
/*				PeCidHandle- Handle of the CID to be removed	  */
/*				completeFunc-  completion function called after	  */
/*							   CID is deleted					  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeDelCidSer(void						*pCmd,
				   void						*pParam1,
				   void						*pParam2,	
				   void						*pParam3,
				   serializationTaskData	*pSerData)
{  
	int					intLevel;
	U32					peCidHandle;
	void				(*completeFunc)(msp_pe_resp *pFeResp);
	U32					callerRefId;
	msp_ped_del_cid		xCmd;
	msp_ped_del_cid		*pDCCmd = &xCmd;
	msp_pe_resp			errorResp;

	peCidHandle = (U32)pParam1;
	/* INCOMPLETE-	cast needed */
	completeFunc = pParam2;
	callerRefId = (U32)pParam3;

	/* Set the completion function for the del CID command */
	CID[peCidHandle]->completeFunc = completeFunc;
	CID[peCidHandle]->DelRefId = callerRefId;
	
	pDCCmd->CmdId = MSP_PED_DEL_CID_CMD;
	pDCCmd->HsHandle = peCidHandle;
	pDCCmd->PedCidHandle = CID[peCidHandle]->PedCidHandle;
	
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pDCCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_del_cid));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeModCidSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify a CID on an AAL2 connection.  */
/*																  */
/* PARAMETERS:													  */
/*				pCid-  Structure holding CID handle and new		  */
/*					   parameters								  */
/*																  */
/*				completeFunc-  Completion function called later	  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeModCidSer(void						*pCmd,
				   void						*pParam1,
				   void						*pParam2,	
				   void						*pParam3,
				   serializationTaskData	*pSerData)
{
	int					intLevel;
	msp_buf				*serBuf;
	msp_pe_mod_cid		*pCid;
	U32					callerRefId;
	void				(*completeFunc)(msp_pe_resp *pFeResp);
	msp_ped_extcmd		xCmd;
	msp_ped_extcmd		*pXCmd = &xCmd;
	msp_ped_mod_cid		*pMCCmd;
	U32					peCidHandle;
	U16					vpmPortHandle;
	U32					*pCidHandle;
	U32					peXCmdAddr;
	msp_pe_resp			errorResp;

	/* INCOMPLETE-	cast needed */
	completeFunc = pParam1;
	callerRefId = (U32)pParam2;
	serBuf = (msp_buf *)pParam3;
	pCid = (msp_pe_mod_cid *)
		(serBuf->dataBuffer +
		(sizeof(msp_ped_mod_cid) + 4) - 
		sizeof(msp_pe_mod_cid));
   

	/* Store all the values in the	*/
	/* global variable structure	*/
	peCidHandle = pCid->PeCidHandle;

	if (pCid->VpmPort.source != MSP_PE_NO_CHANGE)
	{
		CID[peCidHandle]->VpmPort.source = pCid->VpmPort.source;
					
	}
	
	if (pCid->VpmPort.port != MSP_PE_NO_CHANGE)
	{
		CID[peCidHandle]->VpmPort.port = pCid->VpmPort.port;
					
	}
	
	if (pCid->ComFlds.CidFlags != MSP_PE_NO_CHANGE)
	{
		CID[peCidHandle]->CidFlds.ParMod.CidFlags = 
			pCid->ComFlds.CidFlags;					
	}
	
	if (pCid->ComFlds.VoiceProfileType != MSP_PE_NO_CHANGE)
	{
		CID[peCidHandle]->CidFlds.ParMod.VoiceProfileType = 
			pCid->ComFlds.VoiceProfileType;
					
	}
	
	CID[peCidHandle]->MODcompleteFunc = completeFunc;
	CID[peCidHandle]->ModRefId = callerRefId;


	/* Now setup the Extended command structure */
	pCidHandle = (U32*)serBuf->dataBuffer;
	*pCidHandle = peCidHandle;
	peXCmdAddr = (U32)serBuf->dataBuffer + 4;	  /* The XCmd follows the PeCidHandle */
	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = peXCmdAddr; /* Link to XCmd */
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_mod_cid);

	/* Now setup the Mod CID Command structure */
	pMCCmd = (msp_ped_mod_cid *)peXCmdAddr;
	pMCCmd->CmdId = MSP_PED_MOD_CID_CMD;
	pMCCmd->HsHandle = (U32)serBuf;
	pMCCmd->PedCidHandle = CID[peCidHandle]->PedCidHandle;
	
	/* Convert the users version of vpm_port to 16 bits */
	if ((pCid->VpmPort.port != MSP_PE_NO_CHANGE) ||
		(pCid->VpmPort.source != MSP_PE_NO_CHANGE))
	{
		CONVERT_USER_PORTHANDLE(pCid->VpmPort.source,
							   pCid->VpmPort.port,
							   vpmPortHandle);
		pMCCmd->VpmdPortHandle = vpmPortHandle;
	}
	else
	{
		pMCCmd->VpmdPortHandle = MSP_PE_NO_CHANGE;
	}
	
	/* The rest of the structure is already there */

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pXCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_extcmd));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetCidStatsSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular cid's statistics	  */
/*																  */
/* PARAMETERS:													  */
/*				PeCidHandle- Handle of CID to get statistics from */
/*				completeFunc-  Pointer to completion function	  */
/*																  */
/* RETURNS:														  */
/*				nothing											  */
/*																  */
/******************************************************************/

U32 MspPeGetCidStatsSer(void						*pCmd,
						void						*pParam1,
						void						*pParam2,	
						void						*pParam3,
						serializationTaskData		*pSerData)
{
	int						intLevel;
	msp_buf					*serBuf;
	msp_pe_cid_stats_pars	*pGetPars;
	U32						peCidHandle;
	U32						callerRefId;
	msp_ped_get_cid_stats	xCmd;
	msp_ped_get_cid_stats	*pGSCmd = &xCmd;
	void					(*completeFunc)(msp_pe_resp *pFeResp,
											msp_pe_cid_stats *pStat);
	msp_pe_resp				errorResp;
	msp_pe_cid_stats		errorStats;

	serBuf = (msp_buf *)pParam1;
	pGetPars = (msp_pe_cid_stats_pars *)serBuf->dataBuffer;

	peCidHandle = pGetPars->PeCidHandle;
	completeFunc = pGetPars->CompleteFunc;
	callerRefId = pGetPars->CallerRefId;

	pGSCmd->CmdId = MSP_PED_GET_CID_STATS_CMD;
	pGSCmd->HsHandle = (U32)serBuf;
	pGSCmd->PedCidHandle = CID[peCidHandle]->PedCidHandle;
	pGSCmd->StatBufPtr = (U32)&pGetPars->CidStats;
	
	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pGSCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_get_cid_stats));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* mspPeTransmitUnSer											  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to send a packet out over the WAN over  */
/* the specified VC.											  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle-	 Identifies VC Tx ring to put packet  */
/*																  */
/*				pTrBuf-	 Pointer to MSP Buff to send packet		  */
/*																  */
/*				PktType-  Packet type							  */
/*																  */
/*				TxPriority-	 Packet priority (high, med, low)	  */
/*																  */
/******************************************************************/

U32 mspPeTransmitUnSer( U32		PeVcHandle,
						U32		UserTxId,
						msp_buf *pMSPBuf,
						U32		TxPriority)
{
	U32						tempTxHead;
	U32						bufLen;
	msp_ped_txbd_update		xCmd;
	msp_ped_txbd_update		*pTxCmd = &xCmd;
	msp_ped_txbd			*pTxBd;
	int						intLevel;
	U32						status = 0;

	/* Tx Buffer Length Checks */
	bufLen = MspGetBufferDataLength(pMSPBuf);
	if (VC[PeVcHandle]->TxAal2Restriction)
	{
		if (bufLen != 48) 
		{
			status = MSP_PE_ERROR_TX_BUFF_LENGTH;
			goto peTxErrorExit1;
		}

	}
	else if (VC[PeVcHandle]->TxAal0Restriction)
	{
		if (VC[PeVcHandle]->AtmVcFlds.ParMod.VcFlags & MSP_PE_VC_FLAGS_AAL0_STRIP_ATM_HDR)
		{
			if (bufLen != 48)
				status = MSP_PE_ERROR_TX_BUFF_LENGTH;
		}
		else
		{
			if (bufLen != 54)
				status = MSP_PE_ERROR_TX_BUFF_LENGTH;
		}

		if (status != 0) 
			goto peTxErrorExit1;
	}
	else if (bufLen == 0) 
	{
		status = MSP_PE_ERROR_TX_BUFF_LENGTH;
		goto peTxErrorExit1;
	}

	/* Attempt to clear some TxBds first */
	MspPeCleanTx(PeVcHandle);

	intLock(intLevel);
	
	/* Check if we have a Tx Buffer descriptor available */
	if (VC[PeVcHandle]->TxHead == VC[PeVcHandle]->TxLast) 
		tempTxHead = VC[PeVcHandle]->TxFirst;
	else
		tempTxHead = VC[PeVcHandle]->TxHead + sizeof(msp_ped_txbd); 

	if (tempTxHead == VC[PeVcHandle]->TxTail) 
	{
		status = MSP_PE_ERROR_TX_BUFF_DESCRIPTORS;
		goto peTxErrorExit;
	}

	/* Setup Tx Buffer Descriptor */
	pTxBd = (msp_ped_txbd *)VC[PeVcHandle]->TxHead;

	/* Increment TxHead */
	VC[PeVcHandle]->TxHead = tempTxHead;
	intUnlock (intLevel);

	/* Update MSP Buffer attributes */
	pTxBd->BufAddr = (U32)MspGetBufferStartOfData(pMSPBuf);
	pTxBd->BufLen = bufLen;

	/* For now, assume one buffer */
	pTxBd->Flags |= MSP_PED_TXBD_READY_FLAG |
					MSP_PED_TXBD_LAST_FLAG;

	pTxCmd->CmdId = MSP_PED_TXBD_UPDATE_CMD;
	pTxCmd->HsHandle = PeVcHandle;
	pTxCmd->PedVcHandle = VC[PeVcHandle]->PedVcHandle;
	/* pTxCmd->TxBdPtr = tempTxHead; */ /* One ahead of current head */
	pTxCmd->TxBdPtr = VC[PeVcHandle]->TxHead;

	PeTotalTxBdRing++;
#ifdef PE_PERF_DEBUG   
	if (PeTotalTxBdRing > PeMaxOutTxBdRing) {
		PeMaxOutTxBdRing = PeTotalTxBdRing;
		printf("TX (SER):  Tx Bd ring max out:	0x%x\n",PeMaxOutTxBdRing);
	}
#endif	 
	/* Add msp_buf to Tx in-use fifo */
	status = MspFIFOBufInUsePut(VC[PeVcHandle]->TxMspFifo, pMSPBuf);

#ifdef PE_TX_DEBUG
	printf("TX:	 About to copy command down\n");
	printf("TX:	 PedVcHandle:  %x\n",pTxCmd->PedVcHandle);
	printf("TX:	 TxBd update addr:	%x\n",pTxCmd->TxBdPtr);
	printf("TX:	 TxBd going in:	 %x\n",(U32)pTxBd);
	printf("TX:	 TxBd-BufAddr:	%x\n",pTxBd->BufAddr);
	printf("TX:	 TxBd-Length:  %x\n",pTxBd->BufLen);
	printf("TX:	 TxBd-Flags:  %x\n",pTxBd->Flags);
#endif

	/* DEBUG */
	PeTotalTxCD++;

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pTxCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_txbd_update));

#ifdef PE_TX_DEBUG
	printf("TX:	 Exiting TransmitSer:\n");
#endif
	return(MSP_SUCCESS);


peTxErrorExit:
	intUnlock(intLevel);
peTxErrorExit1:
	PeTotalTxErr++;
	FreeMspBuf(pMSPBuf); /* */
	PeTotalTxFree++;
	if (VC[PeVcHandle]->ErrorFunc)
		(*VC[PeVcHandle]->ErrorFunc)(VC[PeVcHandle]->UserErrorId,
									status);
	return (MSP_PE_ERRORS);
}

/******************************************************************/
/*																  */
/* MspPeTransmitSer												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to send a packet out over the WAN over  */
/* the specified VC.											  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle-	 Identifies VC Tx ring to put packet  */
/*																  */
/*				pTrBuf-	 Pointer to MSP Buff to send packet		  */
/*																  */
/*				PktType-  Packet type							  */
/*																  */
/*				TxPriority-	 Packet priority (high, med, low)	  */
/*																  */
/******************************************************************/

U32 MspPeTransmitSer(void				*pCmd,
					 void				*pParam1,
					 void				*pParam2,	
					 void				*pParam3,
					 serializationTaskData		*pSerData)
{
	int						intLevel;
	msp_buf					*serBuf;
	msp_pe_tx_info			*txInfo;
	U32						peVcHandle;
	U32						UserTxId;
	msp_buf					*pMSPBuf;
	U32						TxPriority;
	U32						status = 0;
	U32						tempTxHead;
	U32						bufLen;
	msp_ped_txbd_update		*pTxCmd;
	msp_ped_txbd			xCmd;
	msp_ped_txbd			*pTxBd = &xCmd;

	serBuf = (msp_buf *)pParam1;
	txInfo = (msp_pe_tx_info *)serBuf->dataBuffer;

	peVcHandle = txInfo->PeVcHandle;
	UserTxId = txInfo->UserTxId;
	pMSPBuf = txInfo->pMSPBuf;
	TxPriority = txInfo->TxPriority;

#ifdef PE_TX_DEBUG
	printf("TX (SER):  TransmitSer entered\n");
#endif

	/* DEBUG */
	PeTotalTxSer++;

	/* Do error checking */
	
	/* Tx Buffer Length Checks */
	bufLen = MspGetBufferDataLength(pMSPBuf);
	if (VC[PeVcHandle]->TxAal2Restriction)
	{
		if (bufLen != 48) 
		{
			status = MSP_PE_ERROR_TX_BUFF_LENGTH;
			PeTotalTxErr++;
			FreeMspBuf(pMSPBuf); /* */
			MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);
			PeTotalTxFree++;
			if (VC[PeVcHandle]->ErrorFunc)
				(*VC[PeVcHandle]->ErrorFunc)(VC[PeVcHandle]->UserErrorId,
											status);
			return (MSP_PE_ERRORS);
		}
	}
	else if (VC[PeVcHandle]->TxAal0Restriction)
	{
		if (VC[PeVcHandle]->AtmVcFlds.ParMod.VcFlags & MSP_PE_VC_FLAGS_AAL0_STRIP_ATM_HDR)
		{
			if (bufLen != 48)
				status = MSP_PE_ERROR_TX_BUFF_LENGTH;
		}
		else
		{
			if (bufLen != 54)
				status = MSP_PE_ERROR_TX_BUFF_LENGTH;
		}

		if (status != 0) 
		{
			PeTotalTxErr++;
			FreeMspBuf(pMSPBuf); /* */
			MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);
			PeTotalTxFree++;
			if (VC[PeVcHandle]->ErrorFunc)
				(*VC[PeVcHandle]->ErrorFunc)(VC[PeVcHandle]->UserErrorId,
											status);
			return (MSP_PE_ERRORS);
		}
	}
	else if (bufLen == 0) 
	{
		status = MSP_PE_ERROR_TX_BUFF_LENGTH;
		PeTotalTxErr++;
		FreeMspBuf(pMSPBuf); /* */
		MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);
		PeTotalTxFree++;
		if (VC[PeVcHandle]->ErrorFunc)
			(*VC[PeVcHandle]->ErrorFunc)(VC[PeVcHandle]->UserErrorId,
										status);
		return (MSP_PE_ERRORS);
	}

	/* Lock out interrupt */
	intLevel = intLock();

	/* Check if we have a Tx Buffer descriptor available */
	if (VC[PeVcHandle]->TxHead == VC[PeVcHandle]->TxLast) 
		tempTxHead = VC[PeVcHandle]->TxFirst;
	else
		tempTxHead = VC[PeVcHandle]->TxHead + sizeof(msp_ped_txbd); 
	
	if (tempTxHead == VC[PeVcHandle]->TxTail) 
	{
		/* Attempt to clear some TxBds first */
		MspPeCleanTx(PeVcHandle);
		if (tempTxHead == VC[PeVcHandle]->TxTail) 
		{
			/* Unlock the interrupt */
			intUnlock(intLevel);

			status = MSP_PE_ERROR_TX_BUFF_DESCRIPTORS;
			PeTotalTxErr++;
			FreeMspBuf(pMSPBuf); /* */
			MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);
			PeTotalTxFree++;
			if (VC[PeVcHandle]->ErrorFunc)
				(*VC[PeVcHandle]->ErrorFunc)(VC[PeVcHandle]->UserErrorId,
											status);
			return (MSP_PE_ERRORS);
		}
	}


	/* Setup Tx Buffer Descriptor */
	pTxBd = (msp_ped_txbd *)VC[PeVcHandle]->TxHead;

	VC[PeVcHandle]->TxHead = tempTxHead;
	intUnlock (intLevel);

	/* Update MSP Buffer attributes */
	pTxBd->BufAddr = (U32)MspGetBufferStartOfData(pMSPBuf);
	pTxBd->BufLen = bufLen;

	/* For now, assume one buffer */
	pTxBd->Flags |= MSP_PED_TXBD_READY_FLAG |
					MSP_PED_TXBD_LAST_FLAG;

	if (VC[PeVcHandle]->IndMode == MSP_PE_VC_INTERRUPT_MODE) 
		pTxBd->Flags |= MSP_PED_TXBD_INTERRUPT_FLAG;

	/* Add TxId to the TxIdFifo */
	VC[PeVcHandle]->UserTxIdFifo[VC[PeVcHandle]->UserTxIdHead] = UserTxId;

	if (VC[PeVcHandle]->UserTxIdHead == (MSP_PE_NUM_TXBDS_DEFAULT - 1))
		VC[PeVcHandle]->UserTxIdHead = 0;
	else
		VC[PeVcHandle]->UserTxIdHead++;


	pTxCmd->CmdId = MSP_PED_TXBD_UPDATE_CMD;
	pTxCmd->HsHandle = peVcHandle;
	pTxCmd->PedVcHandle = VC[PeVcHandle]->PedVcHandle;
	pTxCmd->TxBdPtr = tempTxHead; /* One ahead of current head */

	PeTotalTxBdRing++;
#ifdef PE_PERF_DEBUG   
	if (PeTotalTxBdRing > PeMaxOutTxBdRing) 
	{
		PeMaxOutTxBdRing = PeTotalTxBdRing;
		printf("TX (SER):  Tx Bd ring max out:	0x%x\n",PeMaxOutTxBdRing);
	}
#endif	 

	/* Add msp_buf to Tx in-use fifo */
	status = MspFIFOBufInUsePut(VC[PeVcHandle]->TxMspFifo, pMSPBuf);

#ifdef PE_TX_DEBUG
	printf("TX (SER):  About to copy command down\n");
	printf("TX (SER):  PedVcHandle:	 %x\n",pTxCmd->PedVcHandle);
	printf("TX (SER):  TxBd update addr:  %x\n",pTxCmd->TxBdPtr);
	printf("TX (SER):  TxBd going in:  %x\n",(U32)pTxBd);
	printf("TX (SER):  TxBd-BufAddr:  %x\n",pTxBd->BufAddr);
	printf("TX (SER):  TxBd-Length:	 %x\n",pTxBd->BufLen);
	printf("TX (SER):  TxBd-Flags:	%x\n",pTxBd->Flags);
#endif

	/* Finished with the msp buffer used for serialization */
	status = MspFIFOBufInUsePut(PESerialFifoSmall, serBuf);

	/* DEBUG */
	PeTotalTxCD++;

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pTxCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_txbd_update));

#ifdef PE_TX_DEBUG
	printf("TX (SER):  Exiting TransmitSer:\n");
#endif

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeNokiaEocTxSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to send an EOC frame out over the WAN	  */
/*																  */
/* PARAMETERS:													  */
/*				pEOCFrame-	pointer to frame to be send			  */
/*																  */
/*				portNum-  port number to send frame out of		  */
/*																  */
/*				Size-  Size of frame to be send					  */
/*																  */
/******************************************************************/

U32 MspPeNokiaEocTxSer( U32 InterfaceNum, U8 *pEOCFrame, U32 Size)
{
	msp_buf					*serBuf;
	msp_ped_nokia_txeoc		*pNTxCmd;
	msp_ped_extcmd			xCmd;
	msp_ped_extcmd			*pXCmd = &xCmd;

	pNTxCmd = getExtendedCommand();
	if (pNTxCmd == NULL)
		return MSP_NO_RESOURCES;
		
	pXCmd->CmdId =	MSP_PED_EXT_CMD;
	pXCmd->ExtCmdBufPtr = pNTxCmd; 
	pXCmd->ExtCmdBufLen = sizeof(msp_ped_nokia_txeoc);

	pNTxCmd->CmdId = MSP_PED_NOKIA_TXEOC_CMD;
	pNTxCmd->HsHandle = pNTxCmd;
	pNTxCmd->PhyDevice.InterfaceNum = InterfaceNum;
	pNTxCmd->PhyDevice.PhyAddr = InterfaceNum;
	pNTxCmd->EocBufPtr = pEOCFrame;
	pNTxCmd->EocBufBSize = Size;

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)	pXCmd,
						MSP_PED_COMMAND_Q_BASE,
						BC_CP_DFIX_SINC_NINT_MODE,
						sizeof(msp_ped_extcmd));

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeReceivePollSer											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is the PE's receive polling routine.  The user calls this */
/* routine intermittently to receive packets when in polling mode */
/*																  */
/* PARAMETERS:	PeVcHandle-	 Handle of VC						  */
/*																  */
/******************************************************************/
U32 MspPeReceivePollSer ( void						*pCmd,
						  void						*pParam1,
						  void						*pParam2,	
						  void						*pParam3,
						  serializationTaskData		*pSerData)
{
	U32						peVcHandle;
	msp_ped_gen_rsp			evt;

	peVcHandle = (U32)pParam1;

	if (VC[PeVcHandle]->IndMode != MSP_PE_VC_POLLING_MODE) {
		/* ********** INCOMPLETE ********** */
		/* MAYBE SHOULD CALL REGISTERED ERROR FUNC */
		return (MSP_PE_ERRORS);
	}

	cacheInvalidate(DATA_CACHE, (msp_ped_rxbd *) VC[PeVcHandle]->RxHead, sizeof(msp_ped_rxbd));
	PREF_LOAD(VC[PeVcHandle]->RxHead);

	evt.HsHandle = peVcHandle;
	MspPeHandleRx(&evt, peVcHandle);

	return(MSP_SUCCESS);

}

/******************************************************************/
/*																  */
/* MspPeDPR														  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is the PE's deferred processing routine.				  */
/*																  */
/* PARAMETERS:	<none>											  */
/*																  */
/******************************************************************/

static U32 MspPeDPR(void					*pCmd,
					void					*pParam1,
					void					*pParam2,	
					void					*pParam3,
					serializationTaskData	*pSerData)
{
	U32				currEvent;
	msp_ped_gen_rsp *pEvt;


#ifdef PE_DEBUG
	printf("DPR (SER):	Entering def processing routine\n");
#endif

	currEvent = FEEventHead;
	pEvt = FEEventQueue[currEvent]; /* */

#ifdef PE_DEBUG
	printf("DPR (SER):	Event Location 0x%x\n",(U32)pEvt); 
	printf("DPR (SER):	Event Id is 0x%x\n",pEvt->EvtId); 
#endif

	/* At least one event must be valid */
	while (pEvt->EvtId & MSP_PED_VALID_EVT) 
	{

		/* Call MspPeHandleEvent to handle single event */
		MspPeHandleEvent(pEvt);
		cacheInvalidate(DATA_CACHE, FEEventQueue[currEvent+1], sizeof(msp_ped_gen_rsp));
		PREF_LOAD(FEEventQueue[currEvent+1]);
		PREF_LOAD((U32 )(FEEventQueue[currEvent+1] + MSP5000_CACHE_DATA_LINE_SIZE));

		if (currEvent == FEEventLast)
		{
			currEvent = FEEventFirst;
			cacheInvalidate(DATA_CACHE, FEEventQueue[currEvent], sizeof(msp_ped_gen_rsp));
		}
		else
			currEvent++;
		
		pEvt = FEEventQueue[currEvent];

#ifdef PE_DEBUG
	printf("DPR (SER):	.. next Event Id is 0x%x\n",pEvt->EvtId);
#endif

	}

	PeNoPendingJob = 1;
	FEEventHead = currEvent;

#ifdef PE_DEBUG
	printf("DPR (SER):	Event head is 0x%x\n", FEEventHead);
	printf("DPR (SER):	Event head Location 0x%x\n",(U32)pEvt); 
	printf("DPR (SER):	Exiting def processing routine\n");
#endif
	
	return (MSP_SUCCESS);

}

/******************************************************************/
/*																  */
/* PeIntHandler													  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is the PE's interrupt service routine.					  */
/*																  */
/* PARAMETERS:	<none>											  */
/*																  */
/******************************************************************/

void PeIntHandler()
{
	mspMsg	msg;			/* Has to be named msg for job_add */
	U32		returnValue;

	*MEM_CNFG1_REG; /* To make sure the data gets to the SDRAM */

#ifdef PE_FW_MAILBOX_PRINT	 
	{
		U32 peMboxRegister= READ_FE_MBOX();

		/* Check if mbox register has value other than one */
	
		/* Add the Deferred Processing Routine to the Ser Queue */
		if (peMboxRegister != 1) {
			MSP_JOB_ADD(&MspPePrintMBox, peMboxRegister, NULL, NULL, returnValue);
		}
	}
#else	
	READ_FE_MBOX();
	if (PeNoPendingJob) 
	{
		cacheInvalidate(DATA_CACHE, FEEventQueue[FEEventHead], sizeof(msp_ped_gen_rsp));
		PeNoPendingJob = 0;
		MSP_JOB_ADD(&MspPeDPR, NULL, NULL, NULL, returnValue);
	}
#endif

	/* Now clear the interrupt bit */
	*INT_STA_REG = SLM_FE_MBOX_INT;
}


U32 MspPePingTestSer()
{
	msp_ped_cmd		xCmd;
	msp_ped_cmd		*pPCmd = &xCmd;
	U32				lockParam;
	U32				Cnt;

	/* Disable interrupt so Isr doesn't get called */
	lockParam = intLock();

	/* Issue Ping */

	pPCmd->CmdId = MSP_PED_PING_CMD;
	pPCmd->CmdParm1 = 0x00000000;
	pPCmd->CmdParm2 = 0x00000000;
	pPCmd->CmdParm3 = 0x00000000;

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pPCmd,
				MSP_PED_COMMAND_Q_BASE,
				BC_CP_DFIX_SINC_NINT_MODE,
				sizeof(msp_ped_cmd));

	
	Cnt = 0;
	while (!(READ_FE_MBOX() & MSP_PED_INT_MAILBOX_EVT)) 
	{
		Cnt++;
		if (Cnt == 2000)
			break;
		NanoDelay (100);
	}

	/* Now clear the interrupt bit */
	*INT_STA_REG = SLM_FE_MBOX_INT;
	
	intUnlock(lockParam);

	/* Ping commands have no response */

	if (Cnt == 2000) 
		return MSP_PE_ERROR_START_FAIL;

	return MSP_SUCCESS;
}

U32 MspPeShowStatsSer(void				*pCmd,
			   void				*pParam1,
			   void				*pParam2,	
			   void				*pParam3,
			   serializationTaskData	*pSerData)
{
	msp_ped_txbd			*pTxBD;
	U32						NextLocation;

	printf("Total Tx called = 0x%x\n", PeTotalTx);
	printf("Total Tx serial calls = 0x%x\n", PeTotalTxSer);
	printf("Total Tx copy downs = 0x%x\n", PeTotalTxCD);
	printf("Total Tx handled = 0x%x\n", PeTotalTxHan);
	printf("Total Tx errors = 0x%x\n", PeTotalTxErr);
	printf("Total Rx = 0x%x\n", PeTotalRx);
	printf("Total Rx errors = 0x%x\n", PeTotalRxErr);
	printf("Total Tx Allocations = 0x%x\n", PeTotalTxAlloc);
	printf("Total Rx Allocations = 0x%x\n", PeTotalRxAlloc);
	printf("Total Tx Freed = 0x%x\n", PeTotalTxFree);
	printf("Total Rx Freed = 0x%x\n", PeTotalRxFree);
	printf("Total Tx BdRing size = 0x%x\n", PeTotalTxBdRing);
	if (PeTotalTxBdRing) {
		JohnError = 1;
		printf("----------Tx Head is 0x%x\n",VC[0]->TxHead);
		printf("----------Tx Tail is 0x%x\n",VC[0]->TxTail);
		pTxBD = (msp_ped_txbd *)VC[0]->TxTail;
		printf("----------Tx Tail Flags:  0x%x\n",pTxBD->Flags);
		if (VC[0]->TxTail == VC[0]->TxLast)
			NextLocation = VC[0]->TxFirst;
		else
			NextLocation = VC[0]->TxTail + sizeof(msp_ped_txbd);
		pTxBD = (msp_ped_txbd *)NextLocation;
		printf("----------Tx Tail+1 Flags:	0x%x\n",pTxBD->Flags);
	}

	printf("Total Rx BdRing size = 0x%x\n", PeTotalRxBdRing);
	
	return (MSP_SUCCESS);
}

U32 MspPePrintMBox(void						*pCmd,
				   void						*pParam1,
				   void						*pParam2,	
				   void						*pParam3,
				   serializationTaskData	*pSerData)
{
	U32		mBoxValue;

	mBoxValue = (U32)pParam1;

	printf("---------------PE Mailbox value is %x\n",mBoxValue);

	return(MSP_SUCCESS);
}

void MspPeIndicateLinkStatus(U32 interfaceNum, U32	LinkStatus)
{
	U32			i;

	for (i=0;i<FELastVcIndex;i++) 
	{
		if (VC[i]->used && VC[i]->ErrorFunc)
		{
			switch(VC[i]->VcType)
			{
			case PE_VCTYPE_ATM:
				if (interfaceNum == VC[i]->AtmVcFlds.PhyDevice.InterfaceNum)
				{
#if 0
					printf ("%s: ErrorFunc %08X, LinkStatus = %u\n",
						"PE_VCTYPE_ATM", VC[i]->ErrorFunc, LinkStatus);
#endif
					(*VC[i]->ErrorFunc)(VC[i]->UserErrorId, LinkStatus);
				}
				break;

			case PE_VCTYPE_FR:
				if (interfaceNum == VC[i]->FrVcFlds.PhyDevice.InterfaceNum)
				{
#if 0
					printf ("%s: ErrorFunc %08X, LinkStatus = %u\n",
						"PE_VCTYPE_FR", VC[i]->ErrorFunc, LinkStatus);
#endif
					(*VC[i]->ErrorFunc)(VC[i]->UserErrorId, LinkStatus);
				}
				break;

			case PE_VCTYPE_HDLC:
				if (interfaceNum == VC[i]->HdlcVcFlds.PhyDevice.InterfaceNum)
				{
#if 0
					printf ("%s: ErrorFunc %08X, LinkStatus = %u\n",
						"PE_VCTYPE_HDCL", VC[i]->ErrorFunc, LinkStatus);
#endif
					(*VC[i]->ErrorFunc)(VC[i]->UserErrorId, LinkStatus);
				}
				break;
			
			default:
			}
		}
	}
}

U32 MspPeDbgReadMemSer(void				*pCmd,
					   void				*pParam1,
					   void				*pParam2,	
					   void				*pParam3,
					   serializationTaskData	*pSerData)
{
	U32						peDramWAddr;
	U32						bufAddr;
	U32						bufWSize;
	msp_ped_read_mem_dbg	xCmd;
	msp_ped_read_mem_dbg	*pRMCmd = &xCmd;

	peDramWAddr = (U32)pParam1;
	bufAddr = (U32)pParam2;
	bufWSize = (U32)pParam3;

	/* save bufaddr fow later cache flushing */
	PeDbgReadMemBufAddr = bufAddr;
	PeDbgReadMemBufWSize = bufWSize;

	pRMCmd->CmdId = MSP_PED_READ_MEM_DBGCMD;
	pRMCmd->PeDramWAddr = peDramWAddr;
	pRMCmd->BufAddr = bufAddr;
	pRMCmd->BufWSize = bufWSize;

	/* Copy from driver's cmd queue into FE cmd queue */
	TriadBcopy( (U32)pRMCmd,
			MSP_PED_COMMAND_Q_BASE,
			BC_CP_DFIX_SINC_NINT_MODE,
			sizeof(msp_ped_read_mem_dbg));

	return (MSP_SUCCESS);

}
