/*
 $Header: /proj/software/pub/CVSROOT/uClinux/brecis/pe_api/mspPePrivateStruct.h,v 1.2 2002/01/25 17:17:11 prakity Exp $
 */




/******************************************************************/
/* Copyright (c) 2001 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

/******************************************************************/
/* mspPePrivateStruct.h                                           */
/******************************************************************/

/******************************************************************/
/*                                                                */
/* modification history                                           */
/* --------------------                                           */
/* Begun			Tuesday January 23, 2001                      */
/* First version (VxSim bld)    Thursday April 5, 2001            */
/*                                                                */
/******************************************************************/

/******************************************************************/
/*                                                                */
/* DESCRIPTION:                                                   */
/* This file contains structures private to the packet engine     */
/*                                                                */
/* AUTHOR:  John Rhodes                                           */
/*                                                                */
/* INCLUDE FILES:                                                 */
/*                                                                */
/******************************************************************/

#ifndef __mspPePrivateStructH__
#define __mspPePrivateStructH__

/* -------------------------------------------- */
/* Enumerated type to identify type of VC       */
/* (used in msp_pe_vc_stats_pars)               */
/* -------------------------------------------- */
typedef enum { PE_VCTYPE_ATM,
               PE_VCTYPE_FR,
               PE_VCTYPE_HDLC } msp_pe_vc_type;

/* -------------------------------------------- */
/* Structure for Getting VC Stats               */
/* (serialization passing)                      */
/* -------------------------------------------- */
typedef struct {
    U32             IsBlockingCall;
    U32             Status;
    U32             PeVcHandle;
    msp_pe_vc_type  VcType;
	void		    (*AtmCompleteFunc)(msp_pe_resp *pFeResp,
							msp_pe_vc_stats_atm *pStat);
	void		    (*FrCompleteFunc)(msp_pe_resp *pFeResp,
							msp_pe_vc_stats_fr *pStat);
	void		    (*HdlcCompleteFunc)(msp_pe_resp *pFeResp,
							msp_pe_vc_stats_hdlc *pStat);
	U32             CallerRefId;
    union {
        msp_pe_vc_stats_atm_com     AtmStats;
        msp_pe_vc_stats_fr_com      FrStats;
        msp_pe_vc_stats_hdlc_com    HdlcStats;
    } VcStats;
} msp_pe_vc_stats_pars;

/* -------------------------------------------- */
/* Structure for Getting Cid Stats              */
/* (serialization passing)                      */
/* -------------------------------------------- */
typedef struct {
    U32             IsBlockingCall;
    U32             Status;
    U32             PeCidHandle;
    U32             CallerRefId;
	void			(*CompleteFunc)(msp_pe_resp *pFeResp,
							        msp_pe_cid_stats *pStat);
    msp_pe_cid_stats_com    CidStats;
} msp_pe_cid_stats_pars;

/* -------------------------------------------- */
/* Structure for update line speed              */
/* (serialization passing)                      */
/* -------------------------------------------- */
typedef struct {
	msp_pe_phy_device	PhyDevice;
	msp_pe_line_speed	LineSpeed;
} msp_pe_update_phy_linespeed;

/* -------------------------------------------- */
/* Structure for transmits                      */
/* (serialization passing)                      */
/* -------------------------------------------- */
typedef struct {
    U32         PeVcHandle;
    U32         UserTxId;
    msp_buf     *pMSPBuf;
    U32         TxPriority;
} msp_pe_tx_info;

/* Structure for PE attributes */
typedef struct 
{
	msp_pe_config		    CfgFlds;

    msp_pe_pe_stats_com     Stats;
    U32                     GetRefId;

	msp_pe_utopia_cfg	    UtopiaFlds;

	msp_pe_nokia_cfg	    NokiaFlds;
    U32                     NokiaRxEocBufAddr[MSP_PE_NOKIA_MAX_PHYS];

	msp_pe_hdlc_cfg		    HdlcFlds;
	U32			            HdlcL2Intf[MSP_PE_MAX_PHYS];

	msp_pe_serial_atm_cfg	SatmFlds;

	U32			            PhyEna[MSP_PE_MAX_PHYS];
	msp_pe_line_speed       LineSpeed[MSP_PE_MAX_PHYS];

    msp_pe_phy_stats_com    PStats;
    U32                     PhyGetRefId;

	U32			            NumberVCs;
	U32			            NumberCIDs;
	
    msp_ped_extcmd			extendedCmd;		
    void            (*GETcompleteFunc)(msp_pe_resp *pFeResp,
                                       msp_pe_stats *pStat);
    void            (*PhyGETcompleteFunc)(msp_pe_resp *pFeResp,
                                          msp_pe_phy_stats *pStat);
} msp_pe_global_stats;

/* Structure for each VCs stats */
typedef struct {
	U32			used;
	U32			Enabled;
	U32			PedVcHandle;

	msp_pe_vc_type	VcType;

	/* For SNMP use */
	U32			NextPeVcHandle;

	/* Common user configured attributes */
	U32		IndMode;
	U32		UserTxIdFifo[MSP_PE_NUM_TXBDS_DEFAULT];
	U32     UserTxIdHead;
	U32     UserTxIdTail;
	U32		UserRxId;
	U32		UserErrorId;
	void		(*TxCompleteFunc)(U32 UserTxId, U32 PeVcHandle);
	void		(*RxCompleteFunc)(U32 UserRxId, U32 PeVcHandle, msp_buf *pBuff);
	void		(*ErrorFunc)(U32 UserErrorId, U32 ErrInfo);

	U32             AddRefId;
	U32             DelRefId;
	U32             EnaRefId;
	U32             DisRefId;
	U32             ModRefId;

	/* Vc Attributes-  only one of these is used */
	msp_pe_add_vc_atm_com	AtmVcFlds;
	msp_pe_add_vc_fr_com	FrVcFlds;
	msp_pe_add_vc_hdlc_com	HdlcVcFlds;


	/* Completion functions for VC Api calls */
	void		(*completeFunc)(msp_pe_resp *pFeResp);
	void		(*EDcompleteFunc)(msp_pe_resp *pFeResp);
	void		(*MODcompleteFunc)(msp_pe_resp *pFeResp);

	/* Tx Attributes */
	U32				NumTxBDs;
	msp_ped_txbd	*TxBDs;
	U32				TxFirst;
	U32				TxLast;
	U32				TxHead;
	U32				TxTail;
	msp_buf_fifo	*TxMspFifo;
	U32				TxAal0Restriction;
	U32				TxAal2Restriction;

	/* Rx Attributes */
	U32				NumRxBDs;
	msp_ped_rxbd	*RxBDs;
	U32				RxFirst;
	U32				RxLast;
    U32             RxHead;
	U32				RxTail;
    U32             RxFwPtr;
	msp_buf_fifo	*RxMspFifo;
    U32             RxBufferSize;
    U32             RxBdsReady;

    msp_buf			*AddSerBufAddr;
    msp_ped_extcmd	extendedCmd;		
} msp_pe_global_vc_stats;
 
/* Structure for each CIDs stats */
typedef struct {
	U32				        used;
	U32				        PedCidHandle;
	U32				        PeVcHandle;
	U32				        PedVcHandle;
    U32                     FrameLength;

    msp_vpm_port_device     VpmPort;

	/* For SNMP use */
	U32				        NextPeCidHandle;

    U32         AddRefId;
    U32         DelRefId;
    U32         ModRefId;

	msp_pe_add_cid_com		CidFlds;

	/* Completion functions for CID Api calls */
	void				(*completeFunc)(msp_pe_resp *pFeResp);
	void				(*MODcompleteFunc)(msp_pe_resp *pFeResp);
} msp_pe_global_cid_stats;

#endif



