/*
 $Header: /proj/software/pub/CVSROOT/uClinux/brecis/pe_api/mspPeMain.c,v 1.2 2002/01/25 17:17:11 prakity Exp $
 */
/******************************************************************/
/* Copyright (c) 2001 Brecis Communications						  */
/*	This software is the property of Brecis Communications	  */
/*		and may not be copied or distributed in any form without  */
/*		a prior licensing arrangement.							  */
/******************************************************************/

/******************************************************************/
/* mspPeMain.c													  */
/******************************************************************/

/******************************************************************/
/*																  */
/* modification history											  */
/* --------------------											  */
/* Begun			Tuesday January 23, 2001		 			  */
/* First version (VxSim bld)	Thursday April 5, 2001			  */
/*																  */
/******************************************************************/

/******************************************************************/
/*																  */
/* DESCRIPTION:													  */
/* This is the main file for the framer engine API.	 Only the	  */
/* files prototyped in mspPeMain.h are defined here.			  */
/*																  */
/*																  */
/* AUTHOR:	John Rhodes											  */
/*																  */
/* INCLUDE FILES: mspPeMain.h									  */
/*				  mspPeSerial.h									  */
/*				  common.h										  */
/*				  mspBufStruct.h								  */
/*				  mspPeDefs.h									  */
/*				  macrosDef.h									  */
/*																  */
/******************************************************************/

/* includes */
/* All vxworks and msp includes are in this file */
#include <cacheLib.h>
#include <sysLib.h>
#include "hal_api/includeMsp.h"
#include "hal_api/mspBufProto.h"
#include "sys/MspSysApi.h"

#include "hal_api/mspPeCom.h"
#include "hal_api/pe_api/MspPed.h"
#include "hal_api/mspPeDef.h"
#include "hal_api/mspPeStruct.h"
#include "hal_api/pe_api/mspPePrivateDef.h"
#include "hal_api/pe_api/mspPePrivateStruct.h"
#include "hal_api/pe_api/mspPePrivateProto.h"
#include "hal_api/mspPeProto.h"

/* Globals */

/* The following are globals to hold blocking funcion values */
U32 FeStartComplete;
U32 FeStartStatus;

U32 FeConfigComplete;
U32 FeConfigStatus;

U32 PeGetPeStatsComplete;
U32 PeGetPeStatsStatus;

U32 FeWanConfigComplete;

U32 FeUtopiaComplete;
U32 FeUtopiaStatus;

U32 FeNokiaComplete;
U32 FeNokiaStatus;

U32 FeSatmComplete;
U32 FeSatmStatus;

U32 FeHdlcComplete;
U32 FeHdlcStatus;

U32 PeEnaPhyStatus;
U32 PeEnaPhyComplete;

U32 PeDisPhyStatus;
U32 PeDisPhyComplete;

U32 PeCfgL2Status;
U32 PeCfgL2Complete;

U32 PeUpdLSStatus;
U32 PeUpdLSComplete;

U32 PeGetPhyStatsComplete;
U32 PeGetPhyStatsStatus;

U32 FeAddAtmVcStatus;
U32 FeAddAtmVcHandle;
U32 FeAddAtmVcComplete;

U32 FeAddFrVcStatus;
U32 FeAddFrVcHandle;
U32 FeAddFrVcComplete;

U32 FeAddHdlcVcStatus;
U32 FeAddHdlcVcHandle;
U32 FeAddHdlcVcComplete;

U32 FeDelVcStatus;
U32 FeDelVcComplete;

U32 FeEnableVcStatus;
U32 FeEnableVcComplete;

U32 FeDisableVcStatus;
U32 FeDisableVcComplete;

U32 FeModAtmVcStatus;
U32 FeModAtmVcComplete;

U32 FeModFrVcStatus;
U32 FeModFrVcComplete;

U32 FeModVcCBStatus;
U32 FeModVcCBComplete;

U32 FeAddCidStatus;
U32 FeAddCidHandle;
U32 FeAddCidComplete;

U32 FeDelCidStatus;
U32 FeDelCidComplete;

U32 FeModCidStatus;
U32 FeModCidComplete;

/* Semaphore Id definitions */
SEM_ID		mspPeStartSemId;
SEM_ID		mspPeConfigSemId;
SEM_ID		mspPeGetPeSemId;
SEM_ID		mspPeUtopiaSemId;
SEM_ID		mspPeNokiaSemId;
SEM_ID		mspPeSatmSemId;
SEM_ID		mspPeHdlcSemId;
SEM_ID		mspPeEnaPhySemId;
SEM_ID		mspPeDisPhySemId;
SEM_ID		mspPeCfgL2SemId;
SEM_ID		mspPeUpdLSSemId;
SEM_ID		mspPeGetPhySemId;
SEM_ID		mspPeAddAtmVcSemId;
SEM_ID		mspPeAddFrVcSemId;
SEM_ID		mspPeAddHdlcVcSemId;
SEM_ID		mspPeDelVcSemId;
SEM_ID		mspPeEnaVcSemId;
SEM_ID		mspPeDisVcSemId;
SEM_ID		mspPeModAtmVcSemId;
SEM_ID		mspPeModFrVcSemId;
SEM_ID		mspPeModVcCBSemId;
SEM_ID		mspPeGetAtmVcSemId;
SEM_ID		mspPeGetFrVcSemId;
SEM_ID		mspPeGetHdlcVcSemId;
SEM_ID		mspPeAddCidSemId;
SEM_ID		mspPeDelCidSemId;
SEM_ID		mspPeModCidSemId;
SEM_ID		mspPeGetCidSemId;
SEM_ID		mspPeDbgReadMemSemId;

msp_buf_fifo					*PESerialFifoSmall;
msp_buf_fifo					*PESerialFifoBig;
msp_buf_fifo					*PESerialFifoNokia;

U32			PeDbgReadMemBufAddr;
U32			PeDbgReadMemBufWSize;

extern msp_pe_global_stats		*FE;
extern msp_pe_global_vc_stats	*VC[MSP_PE_MAX_VCS];
extern msp_pe_global_cid_stats	*CID[MSP_PE_MAX_CIDS];

extern U32		FEEventFirst;
extern U32		FEEventLast;
extern U32		FEEventHead;

extern msp_pe_global_vc_stats		GlobalVC[MSP_PE_MAX_VCS];
extern msp_pe_global_vc_stats		*VC[MSP_PE_MAX_VCS];

extern U32					   FEFirstVcIndex;
extern U32					   FELastVcIndex;

extern msp_pe_global_cid_stats		 GlobalCID[MSP_PE_MAX_CIDS];
extern msp_pe_global_cid_stats		 *CID[MSP_PE_MAX_CIDS];

extern U32					   FEFirstCidIndex;
extern U32					   FELastCidIndex;

extern U32					   PeFirstVcHandle;
extern U32					   PeFirstCidHandle;

/* The following are necessary for Transmit to	*/
/* not be run through the serialization task	*/
extern U32					   PeTotalTxSer;
extern U32					   PeTotalTxErr;
extern U32					   PeTotalTxFree;
extern U32					   PeTotalTxCD;
extern U32					   PeTotalTxBdRing;
extern U32					   FEActCmdFirst;

/******************************************************************/
/*																  */
/* MspPeInit													  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine initializes all PE HAL API structures.	It is	  */
/* called by the serialization routine at startup.				  */
/*																  */
/* PARAMETERS: none												  */
/*																  */
/******************************************************************/

void MspPeInit()
{
	int	  i;

#ifdef PE_DEBUG
	printf("PEInit:	 Beginning of initialization\n");
#endif

	/* Initialize all blocking global variables */
	FeStartComplete = 0;
	FeStartStatus = 0;

	FeConfigComplete = 0;
	FeConfigStatus = 0;

	FeWanConfigComplete = 0;

	FeUtopiaComplete = 0;
	FeUtopiaStatus = 0;

	FeNokiaComplete = 0;
	FeNokiaStatus = 0;

	FeSatmComplete = 0;
	FeSatmStatus = 0;

	FeHdlcComplete = 0;
	FeHdlcStatus = 0;

	PeEnaPhyComplete = 0;
	PeDisPhyComplete = 0;
	PeCfgL2Complete = 0;
	PeUpdLSComplete = 0;

	FeAddAtmVcStatus = 0;
	FeAddAtmVcHandle = 0;
	FeAddAtmVcComplete = 0;

	FeAddFrVcStatus = 0;
	FeAddFrVcHandle = 0;
	FeAddFrVcComplete = 0;

	FeAddHdlcVcStatus = 0;
	FeAddHdlcVcHandle = 0;
	FeAddHdlcVcComplete = 0;

	FeDelVcStatus = 0;
	FeDelVcComplete = 0;

	FeEnableVcStatus = 0;
	FeEnableVcComplete = 0;

	FeDisableVcStatus = 0;
	FeDisableVcComplete = 0;

	FeModAtmVcStatus = 0;
	FeModAtmVcComplete = 0;

	FeModFrVcStatus = 0;
	FeModFrVcComplete = 0;

	FeModVcCBStatus = 0;
	FeModVcCBComplete = 0;

	FeAddCidStatus = 0;
	FeAddCidHandle = 0;
	FeAddCidComplete = 0;

	FeDelCidStatus = 0;
	FeDelCidComplete = 0;

	FeModCidStatus = 0;
	FeModCidComplete = 0;
	
	/* Here we should setup each of the command, response and data queues */
	FEEventHead = FEEventFirst = 0;

	/* Setup VC structure pointers */
	for (i=0;i<MSP_PE_MAX_VCS;i++)
			VC[i] = &GlobalVC[i];

	/* Setup CID structure pointers */
	for (i=0;i<MSP_PE_MAX_CIDS;i++)
		CID[i] = &GlobalCID[i];

	FEFirstVcIndex = 0;
	FELastVcIndex = MSP_PE_MAX_VCS - 1;

	FEFirstCidIndex = 0;
	FELastCidIndex = MSP_PE_MAX_CIDS - 1;

#ifdef PE_DEBUG
	printf("PEInit:	 End of initialization\n");
#endif

}



/******************************************************************/
/*																  */
/* MspPeStartBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine starts the Packet engine by issuing a ping		  */
/* command to the Packet Engine Firmware.						  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS: none												  */
/*																  */
/******************************************************************/

U32 MspPeStartBlk()
{
	return MspPeStartSer();
}

/******************************************************************/
/*																  */
/* MspPeGetPeStatsComplete										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the GetPeStats */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleGetPeStats						  */
/*																  */
/*				pStats-	 unused (the user would use this)		  */
/*																  */
/******************************************************************/

static void MspPeGetPeStatsComplete(msp_pe_resp *pResp,
							 msp_pe_stats	*pStats)
{
	PeGetPeStatsStatus = pResp->Status;
	PeGetPeStatsComplete = 1;

	SEMGIVE(mspPeGetPeSemId);
}

/******************************************************************/
/*																  */
/* MspPeGetPhyStatsComplete										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the			  */
/* GetPhyStats completion for blocking functions.				  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleGetPhyStats						  */
/*																  */
/*				pStats-	 unused (the user would use this)		  */
/*																  */
/******************************************************************/

static void MspPeGetPhyStatsComplete(msp_pe_resp		*pResp,
							  msp_pe_phy_stats	*pStats)
{
	PeGetPhyStatsStatus = pResp->Status;
	PeGetPhyStatsComplete = 1;

	SEMGIVE(mspPeGetPhySemId);
}

/******************************************************************/
/*																  */
/* MspPeAddAtmVcComplete										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the AddAtmVC	  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleAddAtmVC							  */
/*																  */
/******************************************************************/

static void MspPeAddAtmVcComplete(msp_pe_resp	*pResp)
{
	FeAddAtmVcStatus = pResp->Status;
	FeAddAtmVcHandle = pResp->PePar1;
	FeAddAtmVcComplete = 1;
	SEMGIVE(mspPeAddAtmVcSemId);
}

/******************************************************************/
/*																  */
/* MspPeAddFrVcComplete											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the AddFrVC	  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleAddFrVC							  */
/*																  */
/******************************************************************/

static void MspPeAddFrVcComplete(msp_pe_resp	*pResp)
{
	FeAddFrVcStatus = pResp->Status;
	FeAddFrVcHandle = pResp->PePar1;
	FeAddFrVcComplete = 1;
	SEMGIVE(mspPeAddFrVcSemId);
}

/******************************************************************/
/*																  */
/* MspPeAddHdlcVcComplete										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the AddHdlcVC  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleAddHdlcVC							  */
/*																  */
/******************************************************************/

static void MspPeAddHdlcVcComplete(msp_pe_resp	*pResp)
{
	FeAddHdlcVcStatus = pResp->Status;
	FeAddHdlcVcHandle = pResp->PePar1;
	FeAddHdlcVcComplete = 1;
	SEMGIVE(mspPeAddHdlcVcSemId);
}

/******************************************************************/
/*																  */
/* MspPeDelVcComplete											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the DelVC	  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleDelVC								  */
/*																  */
/******************************************************************/

static void MspPeDelVcComplete(msp_pe_resp	*pResp)
{
	FeDelVcStatus = pResp->Status;

	FeDelVcComplete = 1;
	SEMGIVE(mspPeDelVcSemId);
}

/******************************************************************/
/*																  */
/* MspPeEnableVcComplete										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the EnableVc	  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleEnableVc							  */
/*																  */
/******************************************************************/

static void MspPeEnableVcComplete(msp_pe_resp	*pResp)
{
	FeEnableVcStatus = pResp->Status;

	FeEnableVcComplete = 1;
#ifdef PE_ENAVC_DEBUG
	printf("EVC:  About to give enavcsemid\n");
#endif

	SEMGIVE(mspPeEnaVcSemId);
}

/******************************************************************/
/*																  */
/* MspPeDisableVcComplete										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the DisableVc  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleDisableVc							  */
/*																  */
/******************************************************************/

static void MspPeDisableVcComplete(msp_pe_resp	*pResp)
{
	FeDisableVcStatus = pResp->Status;

	FeDisableVcComplete = 1;
	SEMGIVE(mspPeDisVcSemId);
}

/******************************************************************/
/*																  */
/* MspPeModAtmVcComplete										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the ModAtmVc	  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleModAtmVC							  */
/*																  */
/******************************************************************/

static void MspPeModAtmVcComplete(msp_pe_resp	*pResp)
{
	FeModAtmVcStatus = pResp->Status;

	FeModAtmVcComplete = 1;
	SEMGIVE(mspPeModAtmVcSemId);
}

/******************************************************************/
/*																  */
/* MspPeModFrVcComplete											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the ModFrVc	  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleModFrVC							  */
/*																  */
/******************************************************************/

static void MspPeModFrVcComplete(msp_pe_resp	*pResp)
{
	FeModFrVcStatus = pResp->Status;

	FeModFrVcComplete = 1;
	SEMGIVE(mspPeModFrVcSemId);
}


/******************************************************************/
/*																  */
/* MspPeGetAtmVcStatsComplete									  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the			  */
/* GetAtmVcStats completion for blocking functions.				  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleGetVcStats						  */
/*																  */
/*				pStats-	 unused (the user would use this)		  */
/*																  */
/******************************************************************/

static void MspPeGetAtmVcStatsComplete(msp_pe_resp		*pResp,
								msp_pe_vc_stats_atm *pStats)
{
	SEMGIVE(mspPeGetAtmVcSemId);
}

/******************************************************************/
/*																  */
/* MspPeGetFrVcStatsComplete									  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the			  */
/* GetFrVcStats completion for blocking functions.				  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleGetVcStats						  */
/*																  */
/*				pStats-	 unused (the user would use this)		  */
/*																  */
/******************************************************************/

static void MspPeGetFrVcStatsComplete(msp_pe_resp		*pResp,
							   msp_pe_vc_stats_fr	*pStats)
{
	SEMGIVE(mspPeGetFrVcSemId);
}

/******************************************************************/
/*																  */
/* MspPeGetHdlcVcStatsComplete									  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the			  */
/* GetHdlcVcStats completion for blocking functions.			  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleGetVcStats						  */
/*																  */
/*				pStats-	 unused (the user would use this)		  */
/*																  */
/******************************************************************/

static void MspPeGetHdlcVcStatsComplete(msp_pe_resp		*pResp,
								 msp_pe_vc_stats_hdlc	*pStats)
{
	SEMGIVE(mspPeGetHdlcVcSemId);
}

/******************************************************************/
/*																  */
/* MspPeAddCidComplete											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the AddCid	  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleAddCid							  */
/*																  */
/******************************************************************/

static void MspPeAddCidComplete(msp_pe_resp *pResp)
{
	FeAddCidStatus = pResp->Status;
	FeAddCidHandle = pResp->PePar1;

	FeAddCidComplete = 1;
	SEMGIVE(mspPeAddCidSemId);
}

/******************************************************************/
/*																  */
/* MspPeDelCidComplete											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the DelCid	  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleDelCid							  */
/*																  */
/******************************************************************/

static void MspPeDelCidComplete(msp_pe_resp *pResp)
{
	FeDelCidStatus = pResp->Status;

	FeDelCidComplete = 1;
	SEMGIVE(mspPeDelCidSemId);
}

/******************************************************************/
/*																  */
/* MspPeModCidComplete											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the ModCid	  */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleModCid							  */
/*																  */
/******************************************************************/

static void MspPeModCidComplete(msp_pe_resp *pResp)
{
	FeModCidStatus = pResp->Status;

	FeModCidComplete = 1;
	SEMGIVE(mspPeModCidSemId);
}

/******************************************************************/
/*																  */
/* MspPeGetCidStatsComplete										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is an internally used routine that handles the GetVcStats */
/* completion for blocking functions.							  */
/*																  */
/* PARAMETERS:	pResp-	pointer to the response struct from		  */
/*						HandleGetCidStats						  */
/*																  */
/******************************************************************/

void MspPeGetCidStatsComplete(msp_pe_resp		*pResp,
							  msp_pe_cid_stats	*pStats)
{
	SEMGIVE(mspPeGetCidSemId);
}

/******************************************************************/
/*																  */
/* MspPeConfigBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the FE. Numerous resources */
/* are configured with this function, such as:	number of voice	  */
/* channels, number of VCs, number of WAN interfaces and type,	  */
/* WAN mode (ATM or frame-relay), and specifics of voice over the */
/* interface.													  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				config- pointer to structure containing FE		  */
/*						attributes								  */
/*																  */
/******************************************************************/

U32 MspPeConfigBlk( msp_pe_config	*config)
{
	msp_buf			*serBuf;
	mspMsg			msg;	/* Has to be named msg for job_add */
	msp_pe_config	*msgBody;
	U32				returnValue;

	/* StartBlk must be called first */
	if (!(FeStartComplete))
		return (MSP_PE_ERROR_CONFIG_NO_START_CALL);

	/* This function should not be called twice */
	if (FeConfigComplete) 
		return (MSP_PE_ERROR_CONFIG_ALREADY_CALLED);

	/* Error checking on Each Parameter */
	if (config->ComFlds.MaxCmds > MSP_PE_MAX_COMMANDS)
		return (MSP_PE_ERROR_CONFIG_MAX_CMDS);
		
	if (config->ComFlds.MaxHDLC > MSP_PE_HDLC_MAX_PHYS)
		return (MSP_PE_ERROR_CONFIG_MAX_HDLC);
		
	if (config->ComFlds.MaxUTOPIA > MSP_PE_UTOPIA_MAX_PHYS)
		return (MSP_PE_ERROR_CONFIG_MAX_UTOPIA);
		
	if (config->ComFlds.MaxSerialATM > MSP_PE_SATM_MAX_PHYS)
		return (MSP_PE_ERROR_CONFIG_MAX_SATM);
		
	if (config->ComFlds.MaxNokia > MSP_PE_NOKIA_MAX_PHYS)
		return (MSP_PE_ERROR_CONFIG_MAX_NOKIA);
		
	if (config->ComFlds.MaxDataVcs > MSP_PE_MAX_DATA_VCS)
		return (MSP_PE_ERROR_CONFIG_MAX_DATA_VCS);
		
	if (config->ComFlds.MaxVoiceVcs > MSP_PE_MAX_VOICE_VCS)
		return (MSP_PE_ERROR_CONFIG_MAX_VOICE_VCS);
		
	if (config->ComFlds.MaxCidChans > MSP_PE_MAX_CIDS)
		return (MSP_PE_ERROR_CONFIG_MAX_CIDS);
		
	/* 
	 * Store all the values in the
	 * global variable structure			
	 */
#if 0
	FE->CfgFlds.ComFlds.MaxCmds = config->ComFlds.MaxCmds;
	FE->CfgFlds.ComFlds.MaxUTOPIA = config->ComFlds.MaxUTOPIA;
	FE->CfgFlds.ComFlds.MaxHDLC = config->ComFlds.MaxHDLC;
	FE->CfgFlds.ComFlds.MaxSerialATM = config->ComFlds.MaxSerialATM;
	FE->CfgFlds.ComFlds.MaxNokia = config->ComFlds.MaxNokia;
	FE->CfgFlds.ComFlds.MaxDataVcs = config->ComFlds.MaxDataVcs;
	FE->CfgFlds.ComFlds.MaxVoiceVcs = config->ComFlds.MaxVoiceVcs;
	FE->CfgFlds.ComFlds.MaxCidChans = config->ComFlds.MaxCidChans;
#else
	FE->CfgFlds.ComFlds = config->ComFlds;
#endif

	return MspPeConfigSer(config);
}

/******************************************************************/
/*																  */
/* MspPeGetPeStatsBlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get the PE's statistics.			  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				pStat-	Pointer to structure to place statistics  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if Pe stats retrieved				  */
/*																  */
/******************************************************************/

U32 MspPeGetPeStatsBlk( msp_pe_stats	*pStat)
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;
	U32			comStatus;

	if (!(pStat))
		return (MSP_PE_ERROR_STATS_STRUCT);

	/* Get GetPeStatsBlk Semaphore */
	SEMTAKE(mspPeGetPeSemId, WAIT_FOREVER);

	MspPeGetPeStatsSer (NULL, MspPeGetPeStatsComplete, pStat);
	/* Wait for GetPeStatsBlk Semaphore */
	SEMTAKE(mspPeGetPeSemId, WAIT_FOREVER);

	comStatus = PeGetPeStatsStatus;
	PeGetPeStatsComplete = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeGetPeSemId);

	return (comStatus);
}

/******************************************************************/
/*																  */
/* MspPeGetPeStats												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get the PE's statistics.			  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if Pe stats retrieved				  */
/*																  */
/******************************************************************/

U32 MspPeGetPeStats( U32	callerRefId,
					 void	(*completeFunc)( msp_pe_resp *pPeResp,
											 msp_pe_stats *pStat))
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	/* Schedule MspPeGetPeStatsSer */
	MspPeGetPeStatsSer (callerRefId, completeFunc, &FE->Stats);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeConfigUTOPIABlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the FE for a UTOPIA		  */
/* interface.													  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				config- pointer to structure containing FE UTOPIA */
/*						attributes								  */
/*																  */
/******************************************************************/

U32 MspPeConfigUTOPIABlk(msp_pe_utopia_cfg *config)
{
	msp_buf				*serBuf;
	mspMsg				msg;	/* Has to be named msg for job_add */
	msp_pe_utopia_cfg	*msgBody;
	U32					i;
	U32					returnValue;

	/* PeConfig must be called first */
	if (!(FeConfigComplete))
		return (MSP_PE_ERROR_PHY_NO_PECONFIG_CALL);

	/* This function should not be called twice */
	if (FeUtopiaComplete) 
		return (MSP_PE_ERROR_UTOPIA_ALREADY_CALLED);

	/* Error checking on Each Parameter */
	if (config->ComFlds.UTOPIAMode > MSP_PE_UTOPIA_MODE_2)
		return(MSP_PE_ERROR_UTOPIA_MODE);

	if (config->ComFlds.Parity > MSP_PE_UTOPIA_PARITY_IGNORED)
		return(MSP_PE_ERROR_UTOPIA_PARITY);

	if (config->ComFlds.MaxPhys > FE->CfgFlds.ComFlds.MaxUTOPIA) 
		return(MSP_PE_ERROR_UTOPIA_MAX_PHYS);

	for (i=0; i < config->ComFlds.MaxPhys; i++) 
	{
		if (config->ComFlds.PhyPort[i].PhyAddr > MSP_PE_UTOPIA_MAX_PHY_PORT_NUM)
			return (MSP_PE_ERROR_PHY_MAX_PORT_NUM);
			
		if (config->ComFlds.PhyPort[i].IdleCellMode > MSP_PE_PHY_IDLE_CELL_NONE)
			return(MSP_PE_ERROR_PHY_IDLE_CELL_MODE);
#if 0
		if (!(config->ComFlds.PhyPort[i].LineSpeed.RxLineSpeed))
			return(MSP_PE_ERROR_PHY_RX_LINE_SPEED);
			
		if (!(config->ComFlds.PhyPort[i].LineSpeed.TxLineSpeed))
			return(MSP_PE_ERROR_PHY_TX_LINE_SPEED);
#endif
			
		if (config->ComFlds.PhyPort[i].AutoF5OamLoopback > 
										MSP_PE_PHY_AUTO_F5OAM_LOOPBACK_MAX )
			return(MSP_PE_ERROR_PHY_AUTO_F5OAM_LOOPBACK);
			
		if (config->ComFlds.PhyPort[i].AutoF4OamLoopback > 
										MSP_PE_PHY_AUTO_F4OAM_LOOPBACK_MAX )
			return(MSP_PE_ERROR_PHY_AUTO_F4OAM_LOOPBACK);
	}

	/* First, store all the values in the	*/
	/* global variable structure			*/

	FE->UtopiaFlds.ComFlds.InterfaceNum = config->ComFlds.InterfaceNum;
	FE->UtopiaFlds.ComFlds.UTOPIAMode = config->ComFlds.UTOPIAMode;
	FE->UtopiaFlds.ComFlds.Parity = config->ComFlds.Parity;
	FE->UtopiaFlds.ComFlds.MaxPhys = config->ComFlds.MaxPhys;

	/* Set the Mode for GetPhyStats */
	if (FE->UtopiaFlds.ComFlds.UTOPIAMode == MSP_PE_UTOPIA_MODE_1)
		FE->PStats.PhyType = MSP_PE_PHYTYPE_UTOPIA1;
	else
		FE->PStats.PhyType = MSP_PE_PHYTYPE_UTOPIA2;

	for (i=0;i<MSP_PE_UTOPIA_MAX_PHYS;i++) 
	{
		FE->UtopiaFlds.ComFlds.PhyPort[i].PhyAddr =
					config->ComFlds.PhyPort[i].PhyAddr;
		FE->UtopiaFlds.ComFlds.PhyPort[i].IdleCellMode =
					config->ComFlds.PhyPort[i].IdleCellMode;
		FE->UtopiaFlds.ComFlds.PhyPort[i].LineSpeed.RxLineSpeed =
					config->ComFlds.PhyPort[i].LineSpeed.RxLineSpeed;
		FE->UtopiaFlds.ComFlds.PhyPort[i].LineSpeed.TxLineSpeed =
					config->ComFlds.PhyPort[i].LineSpeed.TxLineSpeed;
		FE->UtopiaFlds.ComFlds.PhyPort[i].AutoF5OamLoopback
				= config->ComFlds.PhyPort[i].AutoF5OamLoopback;
		FE->UtopiaFlds.ComFlds.PhyPort[i].AutoF4OamLoopback
				= config->ComFlds.PhyPort[i].AutoF4OamLoopback;
	}

	/* Schedule MspPeConfigUtopiaSer */
	MspPeConfigUtopiaSer(config);


	if (FeUtopiaStatus) 
	{
		FeUtopiaComplete = 0;
		return(FeUtopiaStatus);
	}

	FeWanConfigComplete = 1;

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeConfigNokiaBlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the FE for a Nokia ATM	  */
/* serial interface.											  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				config- pointer to structure containing FE Nokia  */
/*						attributes								  */
/*																  */
/******************************************************************/

U32 MspPeConfigNOKIABlk( msp_pe_nokia_cfg	*config)
{
	msp_buf				*tempMspBuf;
	U32					i;

	/* PeConfig must be called first */
	if (!(FeConfigComplete))
		return (MSP_PE_ERROR_PHY_NO_PECONFIG_CALL);

	/* This function should not be called twice */
	if (FeNokiaComplete) 
		return (MSP_PE_ERROR_NOKIA_ALREADY_CALLED);

	if (!(FE->CfgFlds.ComFlds.MaxNokia))
		return (MSP_PE_ERROR_NOKIA_MAX_PHYS_ZERO);

	for (i=0;i < FE->CfgFlds.ComFlds.MaxNokia;i++) 
	{
#if 0
		if (!(config->ComFlds.Interface[i].LineSpeed.RxLineSpeed))
			return(MSP_PE_ERROR_PHY_RX_LINE_SPEED);
		if (!(config->ComFlds.Interface[i].LineSpeed.TxLineSpeed))
			return(MSP_PE_ERROR_PHY_TX_LINE_SPEED);
#endif

		if (config->ComFlds.Interface[i].CosetFlag > MSP_PE_PHY_COSET_MAX )
			return(MSP_PE_ERROR_PHY_COSET_FLAG);
			
		if (config->ComFlds.Interface[i].IdleCellMode > 
										MSP_PE_PHY_IDLE_CELL_NONE )
			return(MSP_PE_ERROR_PHY_IDLE_CELL_MODE);
			
		if (config->ComFlds.Interface[i].PayloadScrambling > 
										MSP_PE_PHY_PAYLOAD_SCRAMBLE_MAX )
			return(MSP_PE_ERROR_PHY_PAYLOAD_SCRAMBLE);
			
		if (config->ComFlds.Interface[i].PhyClockMode > 
										MSP_PE_PHY_CLOCK_MAX )
			return(MSP_PE_ERROR_PHY_CLOCK_MODE);
			
		if (config->ComFlds.Interface[i].AutoF5OamLoopback > 
										MSP_PE_PHY_AUTO_F5OAM_LOOPBACK_MAX )
			return(MSP_PE_ERROR_PHY_AUTO_F5OAM_LOOPBACK);
			
		if (config->ComFlds.Interface[i].AutoF4OamLoopback > 
										MSP_PE_PHY_AUTO_F4OAM_LOOPBACK_MAX )
			return(MSP_PE_ERROR_PHY_AUTO_F4OAM_LOOPBACK);
	}

	FE->NokiaFlds.TxEOCId = config->TxEOCId;
	FE->NokiaFlds.RxEOCId = config->RxEOCId;
	FE->NokiaFlds.ErrEOCId = config->ErrEOCId;
	FE->NokiaFlds.TxEOCComplete = config->TxEOCComplete;
	FE->NokiaFlds.RxEOCComplete = config->RxEOCComplete;
	FE->NokiaFlds.ErrEOC = config->ErrEOC;

	/* Set the Mode for GetPhyStats */
	FE->PStats.PhyType = MSP_PE_PHYTYPE_NOKIA;

	for (i=0;i<MSP_PE_NOKIA_MAX_PHYS;i++) 
	{
#if 0
		FE->NokiaFlds.ComFlds.Interface[i].InterfaceNum
				= config->ComFlds.Interface[i].InterfaceNum;
		FE->NokiaFlds.ComFlds.Interface[i].LineSpeed.RxLineSpeed
				= config->ComFlds.Interface[i].LineSpeed.RxLineSpeed;
		FE->NokiaFlds.ComFlds.Interface[i].LineSpeed.TxLineSpeed
				= config->ComFlds.Interface[i].LineSpeed.TxLineSpeed;
		FE->NokiaFlds.ComFlds.Interface[i].MaxEocFrameBSize
				= config->ComFlds.Interface[i].MaxEocFrameBSize;
		FE->NokiaFlds.ComFlds.Interface[i].CosetFlag
				= config->ComFlds.Interface[i].CosetFlag;
		FE->NokiaFlds.ComFlds.Interface[i].CosetValue
				= config->ComFlds.Interface[i].CosetValue;
		FE->NokiaFlds.ComFlds.Interface[i].IdleCellMode
				= config->ComFlds.Interface[i].IdleCellMode;
		FE->NokiaFlds.ComFlds.Interface[i].PayloadScrambling
				= config->ComFlds.Interface[i].PayloadScrambling;
		FE->NokiaFlds.ComFlds.Interface[i].PhyClockMode
				= config->ComFlds.Interface[i].PhyClockMode;
		FE->NokiaFlds.ComFlds.Interface[i].AutoF5OamLoopback
				= config->ComFlds.Interface[i].AutoF5OamLoopback;
		FE->NokiaFlds.ComFlds.Interface[i].AutoF4OamLoopback
				= config->ComFlds.Interface[i].AutoF4OamLoopback;
#else
		FE->NokiaFlds.ComFlds.Interface[i] = config->ComFlds.Interface[i];
#endif
		if (FE->NokiaFlds.ComFlds.Interface[i].MaxEocFrameBSize > 0 )
		{
			tempMspBuf = MspBufferGet(FE->NokiaFlds.ComFlds.Interface[i].MaxEocFrameBSize,
									   MSP_BUF_NOAPPEND_64_BYTES,
									   MSP_PE_OWNER_ID,
									   DONT_GET_RTOS_BUFFER);

			FE->NokiaRxEocBufAddr[i] = (U32)tempMspBuf->dataBuffer;
		}
		else
		{
			FE->NokiaRxEocBufAddr[i] = 0;
		}
	}


	MspPeConfigNokiaSer (config);

	if (FeNokiaStatus) 
	{
		FeNokiaComplete = 0;
		return(FeNokiaStatus);
	}

	FeWanConfigComplete = 1;

	return (FeNokiaStatus);
}

/******************************************************************/
/*																  */
/* MspPeConfigHDLCBlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the FE for an HDLC		  */
/* interface													  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				config- pointer to structure containing FE HDLC	  */
/*						attributes								  */
/*																  */
/******************************************************************/

U32 MspPeConfigHDLCBlk( msp_pe_hdlc_cfg		*config)
{
	msp_buf				*serBuf;
	mspMsg				msg;	/* Has to be named msg for job_add */
	msp_pe_hdlc_cfg		*msgBody;
	U32					returnValue;
	U32					i;

	/* PeConfig must be called first */
	if (!(FeConfigComplete))
		return (MSP_PE_ERROR_PHY_NO_PECONFIG_CALL);

	/* This function should not be called twice */
	if (FeHdlcComplete) 
		return (MSP_PE_ERROR_HDLC_ALREADY_CALLED);

	if (!(FE->CfgFlds.ComFlds.MaxHDLC))
		return (MSP_PE_ERROR_HDLC_MAX_PHYS_ZERO);

	for (i=0;i < FE->CfgFlds.ComFlds.MaxHDLC;i++) {
		if (!(config->ComFlds.Interface[i].LineSpeed.RxLineSpeed))
			return(MSP_PE_ERROR_PHY_RX_LINE_SPEED);
		if (!(config->ComFlds.Interface[i].LineSpeed.TxLineSpeed))
			return(MSP_PE_ERROR_PHY_TX_LINE_SPEED);
		if (config->ComFlds.Interface[i].ItfPattern >
							MSP_PE_HDLC_ITFPATTERN_IDLE)
			return(MSP_PE_ERROR_HDLC_ITFPATTERN);
		if (config->ComFlds.Interface[i].CrcType > 
							MSP_PE_HDLC_CRCTYPE_ISO32)
			return(MSP_PE_ERROR_HDLC_CRCTYPE);
	}

	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				CmdId				*/
	/*	0x4			<Not Used>				HsHandle			*/
	/*	0x8														*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	serBuf->prependStart = 7;
	msgBody = (msp_pe_hdlc_cfg *)MspGetBufferStartOfData(serBuf);

	for (i=0;i < FE->CfgFlds.ComFlds.MaxHDLC;i++) {
		msgBody->ComFlds.Interface[i].InterfaceNum = 
							config->ComFlds.Interface[i].InterfaceNum;
		msgBody->ComFlds.Interface[i].LineSpeed.RxLineSpeed =
							config->ComFlds.Interface[i].LineSpeed.RxLineSpeed;
		msgBody->ComFlds.Interface[i].LineSpeed.TxLineSpeed =
							config->ComFlds.Interface[i].LineSpeed.TxLineSpeed;
		msgBody->ComFlds.Interface[i].ItfPattern = 
							config->ComFlds.Interface[i].ItfPattern;
		msgBody->ComFlds.Interface[i].CrcType = 
							config->ComFlds.Interface[i].CrcType;
		msgBody->ComFlds.Interface[i].NumDevices = 
							config->ComFlds.Interface[i].NumDevices;
	}

	/* Get HdlcBlk Semaphore */
	SEMTAKE(mspPeHdlcSemId, WAIT_FOREVER);

	/* Schedule MspPeConfigHdlcSer */
	MSP_JOB_ADD(&MspPeConfigHdlcSer, serBuf, NULL, NULL, returnValue);

	/* Wait for HdlcBlk Semaphore */
	SEMTAKE(mspPeHdlcSemId, WAIT_FOREVER);

	/* Give HdlcBlk Semaphore-	in case of error status */
	SEMGIVE(mspPeHdlcSemId);

	if (FeHdlcStatus) {
		FeHdlcComplete = 0;
		return(FeHdlcStatus);
	}

	FeWanConfigComplete = 1;

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeConfigSerialAtmBlk										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the FE for a Serial Atm	  */
/* interface.													  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				config- pointer to structure containing PE Serial */
/*						Atm attributes.							  */
/*																  */
/******************************************************************/

U32 MspPeConfigSerialAtmBlk( msp_pe_serial_atm_cfg	*config)
{
	msp_buf					*serBuf;
	mspMsg					msg;	/* Has to be named msg for job_add */
	msp_pe_serial_atm_cfg	*msgBody;
	U32						returnValue;
	U32						i;

	/* PeConfig must be called first */
	if (!(FeConfigComplete))
		return (MSP_PE_ERROR_PHY_NO_PECONFIG_CALL);

	/* This function should not be called twice */
	if (FeSatmComplete) 
		return (MSP_PE_ERROR_SATM_ALREADY_CALLED);

	if (!(FE->CfgFlds.ComFlds.MaxSerialATM))
		return (MSP_PE_ERROR_SATM_MAX_PHYS_ZERO);

	for (i=0;i < FE->CfgFlds.ComFlds.MaxSerialATM;i++) {
		if (!(config->ComFlds.Interface[i].LineSpeed.RxLineSpeed))
			return(MSP_PE_ERROR_PHY_RX_LINE_SPEED);
		if (!(config->ComFlds.Interface[i].LineSpeed.TxLineSpeed))
			return(MSP_PE_ERROR_PHY_TX_LINE_SPEED);
		if (config->ComFlds.Interface[i].CosetFlag > MSP_PE_PHY_COSET_MAX )
			return(MSP_PE_ERROR_PHY_COSET_FLAG);
		if (config->ComFlds.Interface[i].IdleCellMode > 
										MSP_PE_PHY_IDLE_CELL_NONE )
			return(MSP_PE_ERROR_PHY_IDLE_CELL_MODE);
		if (config->ComFlds.Interface[i].PayloadScrambling > 
										MSP_PE_PHY_PAYLOAD_SCRAMBLE_MAX )
			return(MSP_PE_ERROR_PHY_PAYLOAD_SCRAMBLE);
		if (config->ComFlds.Interface[i].PhyClockMode > 
										MSP_PE_PHY_CLOCK_MAX )
			return(MSP_PE_ERROR_PHY_CLOCK_MODE);
		if (config->ComFlds.Interface[i].TdmFrameSyncBitMode > 
										MSP_PE_PHY_TDM_FRAME_SYNC_MAX )
			return(MSP_PE_ERROR_PHY_TDM_FRAME_SYNC_BIT_MODE);
		if (config->ComFlds.Interface[i].TdmExternalTxFrameSync > 
										MSP_PE_PHY_TDM_EXT_TX_FRAME_SYNC_MAX )
			return(MSP_PE_ERROR_PHY_TDM_EXT_TX_FRAME_SYNC);
		if (config->ComFlds.Interface[i].TdmSlotsPerFrame > 
										MSP_PE_PHY_TDM_SLOTS_PER_FRAME_MAX )
			return(MSP_PE_ERROR_PHY_TDM_SLOTS);
		if (config->ComFlds.Interface[i].AutoF5OamLoopback > 
										MSP_PE_PHY_AUTO_F5OAM_LOOPBACK_MAX )
			return(MSP_PE_ERROR_PHY_AUTO_F5OAM_LOOPBACK);
		if (config->ComFlds.Interface[i].AutoF4OamLoopback > 
										MSP_PE_PHY_AUTO_F4OAM_LOOPBACK_MAX )
			return(MSP_PE_ERROR_PHY_AUTO_F4OAM_LOOPBACK);
	}

	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				CmdId				*/
	/*	0x4			<Not Used>				HsHandle			*/
	/*	0x8														*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	serBuf->prependStart = 7;
	msgBody = (msp_pe_serial_atm_cfg *)MspGetBufferStartOfData(serBuf);

	for (i=0;i < FE->CfgFlds.ComFlds.MaxSerialATM;i++) {
		msgBody->ComFlds.Interface[i].InterfaceNum = config->ComFlds.Interface[i].InterfaceNum;
		msgBody->ComFlds.Interface[i].LineSpeed.RxLineSpeed =
							config->ComFlds.Interface[i].LineSpeed.RxLineSpeed;
		msgBody->ComFlds.Interface[i].LineSpeed.TxLineSpeed =
							config->ComFlds.Interface[i].LineSpeed.TxLineSpeed;
		msgBody->ComFlds.Interface[i].CosetFlag = 
							config->ComFlds.Interface[i].CosetFlag;
		msgBody->ComFlds.Interface[i].CosetValue = 
							config->ComFlds.Interface[i].CosetValue;
		msgBody->ComFlds.Interface[i].IdleCellMode = 
							config->ComFlds.Interface[i].IdleCellMode;
		msgBody->ComFlds.Interface[i].PayloadScrambling = 
							config->ComFlds.Interface[i].PayloadScrambling;
		msgBody->ComFlds.Interface[i].PhyClockMode = 
							config->ComFlds.Interface[i].PhyClockMode;
		msgBody->ComFlds.Interface[i].TdmFrameSyncBitMode = 
							config->ComFlds.Interface[i].TdmFrameSyncBitMode;
		msgBody->ComFlds.Interface[i].TdmExternalTxFrameSync = 
							config->ComFlds.Interface[i].TdmExternalTxFrameSync;
		msgBody->ComFlds.Interface[i].TdmSlotsPerFrame = 
							config->ComFlds.Interface[i].TdmSlotsPerFrame;
		msgBody->ComFlds.Interface[i].AutoF5OamLoopback = 
							config->ComFlds.Interface[i].AutoF5OamLoopback;
		msgBody->ComFlds.Interface[i].AutoF4OamLoopback = 
							config->ComFlds.Interface[i].AutoF4OamLoopback;
	}

	/* Get SatmBlk Semaphore */
	SEMTAKE(mspPeSatmSemId, WAIT_FOREVER);

#ifdef PE_SATM_DEBUG
	printf("SCON:  About to schedule ConfigSerialAtm\n");
#endif

	/* Schedule MspPeConfigSerialAtmSer */
	MSP_JOB_ADD(&MspPeConfigSerialAtmSer, serBuf, NULL, NULL, returnValue);

	/* Wait for SatmBlk Semaphore */
	SEMTAKE(mspPeSatmSemId, WAIT_FOREVER);

#ifdef PE_SATM_DEBUG
	printf("SCON:  Got the SatmConfig semaphore\n");
#endif

	/* Give SatmBlk Semaphore-	in case of error status */
	SEMGIVE(mspPeSatmSemId);

	if (FeSatmStatus) {
		FeSatmComplete = 0;
		return(FeSatmStatus);
	}

	FeWanConfigComplete = 1;

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeEnablePhyBlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to enable the phy device specified	  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PhyDevice-	Physical device to be enabled		  */
/*																  */
/******************************************************************/

U32 MspPeEnablePhyBlk( msp_pe_phy_device	PhyDevice)
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;
	U32			comStatus;

	/* Get EnaPhy Semaphore */
	SEMTAKE(mspPeEnaPhySemId, WAIT_FOREVER);

	/* Schedule MspPeConfigSerialAtmSer */
	MSP_JOB_ADD(&MspPeEnablePhySer,
			PhyDevice.InterfaceNum,
			PhyDevice.PhyAddr,
			NULL,
			returnValue);

	/* Wait for EnaPhy Semaphore */
	SEMTAKE(mspPeEnaPhySemId, WAIT_FOREVER);

	comStatus = PeEnaPhyStatus;
	PeEnaPhyStatus = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeEnaPhySemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeDisablePhyBlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to disable the phy device specified	  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PhyDevice-	Physical device to be disabled		  */
/*																  */
/******************************************************************/

U32 MspPeDisablePhyBlk( msp_pe_phy_device	PhyDevice)
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;
	U32			comStatus;

	/* Get DisPhy Semaphore */
	SEMTAKE(mspPeDisPhySemId, WAIT_FOREVER);

	/* Schedule MspPeDisablePhySer */
	MSP_JOB_ADD(&MspPeDisablePhySer,
			PhyDevice.InterfaceNum,
			PhyDevice.PhyAddr,
			NULL,
			returnValue);

	/* Wait for DisPhy Semaphore */
	SEMTAKE(mspPeDisPhySemId, WAIT_FOREVER);

	comStatus = PeDisPhyStatus;
	PeDisPhyStatus = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeDisPhySemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}


/******************************************************************/
/*																  */
/* MspPeConfigHDLCL2Blk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to configure the layer 2 interface for  */
/* HDLC.														  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PhyDevice-	Physical device to be configured	  */
/*				L2Intf-	 Layer 2 Interface configuration		  */
/*																  */
/******************************************************************/

U32 MspPeConfigHDLCL2Blk( msp_pe_phy_device		PhyDevice,
						  U32					L2Intf)
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;
	U32			comStatus;

	/* Get ConfigHDLCL2 Semaphore */
	SEMTAKE(mspPeCfgL2SemId, WAIT_FOREVER);

	/* Schedule MspPeConfigHDLCL2Ser */
	MSP_JOB_ADD(&MspPeConfigHdlcL2Ser,
			PhyDevice.InterfaceNum,
			PhyDevice.PhyAddr,
			L2Intf,
			returnValue);

	/* Wait for ConfigHDLCL2 Semaphore */
	SEMTAKE(mspPeCfgL2SemId, WAIT_FOREVER);

	comStatus = PeCfgL2Status;
	PeCfgL2Status = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeCfgL2SemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeUpdateLineSpeedBlk										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to update the phy line speed.			  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PhyDevice-	Physical device to be configured	  */
/*				LineSpeed-	The new line speeds for the phy		  */
/*																  */
/******************************************************************/

U32 MspPeUpdateLineSpeedBlk( msp_pe_phy_device	PhyDevice,
				 msp_pe_line_speed	LineSpeed)
{
	msp_buf						*serBuf;
	mspMsg						msg;	/* Has to be named msg for job_add */
	msp_pe_update_phy_linespeed *msgBody;
	U32							returnValue;
	U32							comStatus;

	if (!(LineSpeed.RxLineSpeed))
		return(MSP_PE_ERROR_PHY_RX_LINE_SPEED);

	if (!(LineSpeed.TxLineSpeed))
		return(MSP_PE_ERROR_PHY_TX_LINE_SPEED);

	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				CmdId				*/
	/*	0x4			<Not Used>				HsHandle			*/
	/*	0x8														*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	serBuf->prependStart = 7;
	msgBody = (msp_pe_update_phy_linespeed *)MspGetBufferStartOfData(serBuf);

	msgBody->PhyDevice.InterfaceNum = PhyDevice.InterfaceNum;
	msgBody->PhyDevice.PhyAddr = PhyDevice.PhyAddr;
	msgBody->LineSpeed.RxLineSpeed = LineSpeed.RxLineSpeed;
	msgBody->LineSpeed.TxLineSpeed = LineSpeed.TxLineSpeed;

	/* Get UpdLS Semaphore */
	SEMTAKE(mspPeUpdLSSemId, WAIT_FOREVER);

	/* Schedule MspPeUpdateLineSpeedSer */
	MSP_JOB_ADD(&MspPeUpdateLineSpeedSer, serBuf, NULL, NULL, returnValue);

	/* Wait for UpdLS Semaphore */
	SEMTAKE(mspPeUpdLSSemId, WAIT_FOREVER);

	comStatus = PeUpdLSStatus;
	PeUpdLSStatus = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeUpdLSSemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetPhyStatsBlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a specific Phy's statistics.	  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PhyDevice-	Physical device to get stats from	  */
/*																  */
/*				pStat-	Pointer to structure to place statistics  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if phy stats retrieved				  */
/*																  */
/******************************************************************/

U32 MspPeGetPhyStatsBlk( msp_pe_phy_device	PhyDevice,
						 msp_pe_phy_stats	*pStat)
{
	msp_buf					*serBuf;
	mspMsg					msg;	/* Has to be named msg for job_add */
	msp_pe_phy_device		*msgBody;
	U32						returnValue;
	U32						comStatus;
		STATUS		errorCode;

	if (!(pStat))
		return (MSP_PE_ERROR_STATS_STRUCT);

	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	msgBody = (msp_pe_phy_device *)serBuf->dataBuffer;
	msgBody->InterfaceNum = PhyDevice.InterfaceNum;
	msgBody->PhyAddr = PhyDevice.PhyAddr;

	/* Get GetPhyStatsBlk Semaphore */
	errorCode = SEMTAKE(mspPeGetPhySemId, sysClkRateGet());
	if (errorCode == ERROR)
		return MSP_PE_ERROR_SEMAPHORE_NOT_AVAILABLE;

	/* Schedule MspPeGetPhyStatsSer */
	MSP_JOB_ADD(&MspPeGetPhyStatsSer,
				&MspPeGetPhyStatsComplete,
				NULL,
				serBuf,
				returnValue);

	/* Wait for GetPhyStatsBlk Semaphore */
	errorCode = SEMTAKE(mspPeGetPhySemId, sysClkRateGet());
	if (errorCode == ERROR)
		return MSP_PE_ERROR_SEMAPHORE_NOT_AVAILABLE;

	PeGetPhyStatsComplete = 0;
	comStatus = PeGetPhyStatsStatus;
	PeGetPhyStatsStatus = 0;

	pStat->ComFlds.PhyType = FE->PStats.PhyType;

	switch (FE->PStats.PhyType) {
		case MSP_PE_PHYTYPE_SERIAL_ATM:
			pStat->ComFlds.PhyStats.SerialAtmIfStats.ConfigFlags =
					FE->PStats.PhyStats.SerialAtmIfStats.ConfigFlags;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.CosetValue =
					FE->PStats.PhyStats.SerialAtmIfStats.CosetValue;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.TdmSlotsPerFrame =
					FE->PStats.PhyStats.SerialAtmIfStats.TdmSlotsPerFrame;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.LineSpeed.RxLineSpeed =
					FE->PStats.PhyStats.SerialAtmIfStats.LineSpeed.RxLineSpeed;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.LineSpeed.TxLineSpeed =
					FE->PStats.PhyStats.SerialAtmIfStats.LineSpeed.TxLineSpeed;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.RxCells =
					FE->PStats.PhyStats.SerialAtmIfStats.RxCells;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.RxCellsDropped =
					FE->PStats.PhyStats.SerialAtmIfStats.RxCellsDropped;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.TxCells =
					FE->PStats.PhyStats.SerialAtmIfStats.TxCells;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.TxCellsDropped =
					FE->PStats.PhyStats.SerialAtmIfStats.TxCellsDropped;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.SyncAcquiredCnt =
					FE->PStats.PhyStats.SerialAtmIfStats.SyncAcquiredCnt;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.SyncLostCnt =
					FE->PStats.PhyStats.SerialAtmIfStats.SyncLostCnt;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.RxOamF4Cells =
					FE->PStats.PhyStats.SerialAtmIfStats.RxOamF4Cells;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.RxOamF5Cells =
					FE->PStats.PhyStats.SerialAtmIfStats.RxOamF5Cells;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.RxOamF4LoopbackCells =
					FE->PStats.PhyStats.SerialAtmIfStats.RxOamF4LoopbackCells;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.RxOamF5LoopbackCells =
					FE->PStats.PhyStats.SerialAtmIfStats.RxOamF5LoopbackCells;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.TxIdleCellCnt =
					FE->PStats.PhyStats.SerialAtmIfStats.TxIdleCellCnt;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.RxIdleCellCnt =
					FE->PStats.PhyStats.SerialAtmIfStats.RxIdleCellCnt;
			pStat->ComFlds.PhyStats.SerialAtmIfStats.RxHecErrCells =
					FE->PStats.PhyStats.SerialAtmIfStats.RxHecErrCells;
			break;
		case MSP_PE_PHYTYPE_NOKIA:
			pStat->ComFlds.PhyStats.NokiaIfStats.ConfigFlags =
					FE->PStats.PhyStats.NokiaIfStats.ConfigFlags;
			pStat->ComFlds.PhyStats.NokiaIfStats.CosetValue =
					FE->PStats.PhyStats.NokiaIfStats.CosetValue;
			pStat->ComFlds.PhyStats.NokiaIfStats.MaxEocFrameBSize =
					FE->PStats.PhyStats.NokiaIfStats.MaxEocFrameBSize;
			pStat->ComFlds.PhyStats.NokiaIfStats.LineSpeed.RxLineSpeed =
					FE->PStats.PhyStats.NokiaIfStats.LineSpeed.RxLineSpeed;
			pStat->ComFlds.PhyStats.NokiaIfStats.LineSpeed.TxLineSpeed =
					FE->PStats.PhyStats.NokiaIfStats.LineSpeed.TxLineSpeed;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxCells =
					FE->PStats.PhyStats.NokiaIfStats.RxCells;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxCellsDropped =
					FE->PStats.PhyStats.NokiaIfStats.RxCellsDropped;
			pStat->ComFlds.PhyStats.NokiaIfStats.TxCells =
					FE->PStats.PhyStats.NokiaIfStats.TxCells;
			pStat->ComFlds.PhyStats.NokiaIfStats.TxCellsDropped =
					FE->PStats.PhyStats.NokiaIfStats.TxCellsDropped;
			pStat->ComFlds.PhyStats.NokiaIfStats.SyncAcquiredCnt =
					FE->PStats.PhyStats.NokiaIfStats.SyncAcquiredCnt;
			pStat->ComFlds.PhyStats.NokiaIfStats.SyncLostCnt =
					FE->PStats.PhyStats.NokiaIfStats.SyncLostCnt;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxOamF4Cells =
					FE->PStats.PhyStats.NokiaIfStats.RxOamF4Cells;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxOamF5Cells =
					FE->PStats.PhyStats.NokiaIfStats.RxOamF5Cells;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxOamF4LoopbackCells =
					FE->PStats.PhyStats.NokiaIfStats.RxOamF4LoopbackCells;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxOamF5LoopbackCells =
					FE->PStats.PhyStats.NokiaIfStats.RxOamF5LoopbackCells;
			pStat->ComFlds.PhyStats.NokiaIfStats.TxIdleCellCnt =
					FE->PStats.PhyStats.NokiaIfStats.TxIdleCellCnt;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxIdleCellCnt =
					FE->PStats.PhyStats.NokiaIfStats.RxIdleCellCnt;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxHecErrCells =
					FE->PStats.PhyStats.NokiaIfStats.RxHecErrCells;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxCrcErrs =
					FE->PStats.PhyStats.NokiaIfStats.RxCrcErrs;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxRaiCnt =
					FE->PStats.PhyStats.NokiaIfStats.RxRaiCnt;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxFebeCnt =
					FE->PStats.PhyStats.NokiaIfStats.RxFebeCnt;
			pStat->ComFlds.PhyStats.NokiaIfStats.TxEocFrames =
					FE->PStats.PhyStats.NokiaIfStats.TxEocFrames;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxEocFrames =
					FE->PStats.PhyStats.NokiaIfStats.RxEocFrames;
			pStat->ComFlds.PhyStats.NokiaIfStats.TxEocBytes =
					FE->PStats.PhyStats.NokiaIfStats.TxEocBytes;
			pStat->ComFlds.PhyStats.NokiaIfStats.RxEocBytes =
					FE->PStats.PhyStats.NokiaIfStats.RxEocBytes;
			break;
		case MSP_PE_PHYTYPE_UTOPIA1:
		case MSP_PE_PHYTYPE_UTOPIA2:
			pStat->ComFlds.PhyStats.UtopiaIfStats.ConfigFlags =
					FE->PStats.PhyStats.UtopiaIfStats.ConfigFlags;
			pStat->ComFlds.PhyStats.UtopiaIfStats.LineSpeed.RxLineSpeed =
					FE->PStats.PhyStats.UtopiaIfStats.LineSpeed.RxLineSpeed;
			pStat->ComFlds.PhyStats.UtopiaIfStats.LineSpeed.TxLineSpeed =
					FE->PStats.PhyStats.UtopiaIfStats.LineSpeed.TxLineSpeed;
			pStat->ComFlds.PhyStats.UtopiaIfStats.RxCells =
					FE->PStats.PhyStats.UtopiaIfStats.RxCells;
			pStat->ComFlds.PhyStats.UtopiaIfStats.RxCellsDropped =
					FE->PStats.PhyStats.UtopiaIfStats.RxCellsDropped;
			pStat->ComFlds.PhyStats.UtopiaIfStats.TxCells =
					FE->PStats.PhyStats.UtopiaIfStats.TxCells;
			pStat->ComFlds.PhyStats.UtopiaIfStats.TxCellsDropped =
					FE->PStats.PhyStats.UtopiaIfStats.TxCellsDropped;
			pStat->ComFlds.PhyStats.UtopiaIfStats.RxOamF4Cells =
					FE->PStats.PhyStats.UtopiaIfStats.RxOamF4Cells;
			pStat->ComFlds.PhyStats.UtopiaIfStats.RxOamF5Cells =
					FE->PStats.PhyStats.UtopiaIfStats.RxOamF5Cells;
			pStat->ComFlds.PhyStats.UtopiaIfStats.RxOamF4LoopbackCells =
					FE->PStats.PhyStats.UtopiaIfStats.RxOamF4LoopbackCells;
			pStat->ComFlds.PhyStats.UtopiaIfStats.RxOamF5LoopbackCells =
					FE->PStats.PhyStats.UtopiaIfStats.RxOamF5LoopbackCells;
			break;
		  
	}
	/* Give back the semaphore for next call */
	SEMGIVE(mspPeGetPhySemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetPhyStats												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a specific Phy's statistics.	  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				PhyDevice-	Physical device to get stats from	  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if phy stats retrieved				  */
/*																  */
/******************************************************************/

U32 MspPeGetPhyStats( U32				callerRefId,
					  msp_pe_phy_device PhyDevice,
					  void				(*completeFunc)
											( msp_pe_resp *pPeResp,
											  msp_pe_phy_stats *pStat))
{
	msp_buf					*serBuf;
	mspMsg					msg;	/* Has to be named msg for job_add */
	msp_pe_phy_device		*msgBody;
	U32						returnValue;

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	msgBody = (msp_pe_phy_device *)serBuf->dataBuffer;
	msgBody->InterfaceNum = PhyDevice.InterfaceNum;
	msgBody->PhyAddr = PhyDevice.PhyAddr;

	/* Schedule MspPeGetPhyStatsSer */
	MSP_JOB_ADD(&MspPeGetPhyStatsSer,
				completeFunc,
				callerRefId,
				serBuf,
				returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddAtmVCBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to provision an ATM VC.				  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				pVcSet- pointer to structure containing Atm VC	  */
/*						properties								  */
/*																  */
/*				pFeResp- pointer to structure containing status	  */
/*						 and VC handle							  */
/*																  */
/******************************************************************/

U32 MspPeAddAtmVCBlk(msp_pe_atm_vc	*pVcSet,
					 msp_pe_resp	*pFeResp)
{
	msp_buf				*serBuf;
	mspMsg				msg;	/* Has to be named msg for job_add */
	msp_pe_atm_vc		*msgBody;
	U32					returnValue;
	U32					comStatus;
	U32					VcFlags;


	/* One of the WanConfigs must be called first */
	if (!(FeWanConfigComplete))
		return (MSP_PE_ERROR_ADDVC_NO_WANCONFIG_CALL);

	if (pVcSet->IndMode > MSP_PE_VC_POLLING_MODE)
		return (MSP_PE_ERROR_ADDVC_IND_MODE);

	if (pVcSet->ComFlds.Vpi & 0xffffff00)
		return (MSP_PE_ERROR_ADDVC_ATM_VPI);

	if (pVcSet->ComFlds.Vci & 0xffff0000)
		return (MSP_PE_ERROR_ADDVC_ATM_VCI);

	if (pVcSet->ComFlds.VcType > MSP_PE_ATM_VCTYPE_MAX)
		return (MSP_PE_ERROR_ADDVC_ATM_VC_TYPE);

	/* For AAL5 VCs ensure MRU is multiple of 48 bytes. */
	if ((pVcSet->ComFlds.VcType == MSP_PE_ATM_VCTYPE_AAL5) &&
		((pVcSet->ComFlds.ParMod.MRU % 48) != 0))
		return (MSP_PE_ERROR_ADDVC_MRU_NOT_MULTIPLE48);

	/* Verify VC Flags */
	VcFlags = pVcSet->ComFlds.ParMod.VcFlags;
	if (VcFlags &=			
		~(MSP_PE_VC_FLAGS_LOOPBACK | 
			MSP_PE_VC_FLAGS_DISCARDRX | 
			MSP_PE_VC_FLAGS_AAL2_IGNORE_PARITY | 
			MSP_PE_VC_FLAGS_AAL0_STRIP_ATM_HDR))
		return (MSP_PE_ERROR_VC_ATM_VCFLAGS);

	if ((VcFlags & MSP_PE_VC_FLAGS_AAL0_STRIP_ATM_HDR) &&
		(pVcSet->ComFlds.VcType != MSP_PE_ATM_VCTYPE_AAL0))
		return (MSP_PE_ERROR_VC_ATM_VCFLAGS);

	if (pVcSet->ComFlds.ParMod.SrvType > MSP_PE_ATM_SRVTYPE_MAX)
		return (MSP_PE_ERROR_VC_ATM_SRV_TYPE);

	if (pVcSet->ComFlds.ParMod.VoiceProtocolType > 
									MSP_PE_VOICE_PROTOCOL_MAX)
		return (MSP_PE_ERROR_VC_VOICE_PROTOCOL);

	if (!(pFeResp))
		return (MSP_PE_ERROR_RESPONSE_STRUCT);

	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0									CmdId				*/
	/*	0x4									HsHandle			*/
	/*	0x8									TxBdBaseAddr		*/
	/*	0xC			IndMode					TxBdSize			*/
	/*	0x10		UserRxId				RxBdBaseAddr		*/
	/*	0x14		UserErrorId				RxBdSize			*/
	/*	0x18		TxCompleteFunc			PeakCellEmissionTime*/
	/*	0x1c		RxCompleteFunc			SustainedCellEmissionTime*/
	/*	0x20		ErrorFunc				BurstThreshold		*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	msgBody = (msp_pe_atm_vc *)
		(serBuf->dataBuffer +
		sizeof(msp_ped_add_vc_atm) - 
		sizeof(msp_pe_atm_vc));

	msgBody->IndMode = pVcSet->IndMode;
	msgBody->UserRxId = pVcSet->UserRxId;
	msgBody->UserErrorId = pVcSet->UserErrorId;
	msgBody->TxCompleteFunc = pVcSet->TxCompleteFunc;
	msgBody->RxCompleteFunc = pVcSet->RxCompleteFunc;
	msgBody->ErrorFunc = pVcSet->ErrorFunc;

	msgBody->ComFlds.PhyDevice.InterfaceNum =
				pVcSet->ComFlds.PhyDevice.InterfaceNum;
	msgBody->ComFlds.PhyDevice.PhyAddr = 
				pVcSet->ComFlds.PhyDevice.PhyAddr;

	msgBody->ComFlds.Vpi = pVcSet->ComFlds.Vpi;
	msgBody->ComFlds.Vci = pVcSet->ComFlds.Vci;
	msgBody->ComFlds.VcType = pVcSet->ComFlds.VcType;

	msgBody->ComFlds.ParMod.SrvType = 
				pVcSet->ComFlds.ParMod.SrvType;
	msgBody->ComFlds.ParMod.PeakCellRate = 
				pVcSet->ComFlds.ParMod.PeakCellRate;
	msgBody->ComFlds.ParMod.SustainedCellRate = 
				pVcSet->ComFlds.ParMod.SustainedCellRate;
	msgBody->ComFlds.ParMod.MaxBurstSize = 
				pVcSet->ComFlds.ParMod.MaxBurstSize;
	msgBody->ComFlds.ParMod.MinCellRate = 
				pVcSet->ComFlds.ParMod.MinCellRate;
	msgBody->ComFlds.ParMod.VcFlags = 
				pVcSet->ComFlds.ParMod.VcFlags;
	msgBody->ComFlds.ParMod.VoiceProtocolType = 
				pVcSet->ComFlds.ParMod.VoiceProtocolType;
	msgBody->ComFlds.ParMod.MTU = 
				pVcSet->ComFlds.ParMod.MTU;
	msgBody->ComFlds.ParMod.MRU = 
				pVcSet->ComFlds.ParMod.MRU;

	/* Get AddAtmVcBlk Semaphore */
	SEMTAKE(mspPeAddAtmVcSemId, WAIT_FOREVER);

#ifdef PE_ADD_ATM_DEBUG
	printf("AATM:  About to schedule AddAtmVc\n");
#endif

	/* Schedule MspPeAddAtmVcSer */
	MSP_JOB_ADD(&MspPeAddAtmVcSer,
				&MspPeAddAtmVcComplete,
				NULL,
				serBuf,
				returnValue);

	/* Wait for AddAtmVcBlk Semaphore */
	SEMTAKE(mspPeAddAtmVcSemId, WAIT_FOREVER);

	FeAddAtmVcComplete = 0;
	comStatus = FeAddAtmVcStatus;
	FeAddAtmVcStatus = 0;

	/* Set the status in the response struct */
	pFeResp->CallerRefId = 0;
	pFeResp->Status = comStatus;
	pFeResp->PePar1 = FeAddAtmVcHandle;
	pFeResp->PePar2 = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeAddAtmVcSemId);

#ifdef PE_ADD_ATM_DEBUG
	printf("AATM:  Exiting AddAtmVcBlk\n");
#endif

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddAtmVC												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to provision an ATM VC.				  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				pVcSet- pointer to structure containing Atm VC	  */
/*						properties								  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeAddAtmVC(U32				callerRefId,
				  msp_pe_atm_vc		*pVcSet,
				  void				(*completeFunc)(msp_pe_resp *pFeResp))
{
	msp_buf				*serBuf;
	mspMsg				msg;	/* Has to be named msg for job_add */
	msp_pe_atm_vc		*msgBody;
	U32					returnValue;
	U32					VcFlags;

	/* One of the WanConfigs must be called first */
	if (!(FeWanConfigComplete))
		return (MSP_PE_ERROR_ADDVC_NO_WANCONFIG_CALL);

	if (pVcSet->IndMode > MSP_PE_VC_POLLING_MODE)
		return (MSP_PE_ERROR_ADDVC_IND_MODE);

	if (pVcSet->ComFlds.Vpi & 0xffffff00)
		return (MSP_PE_ERROR_ADDVC_ATM_VPI);

	if (pVcSet->ComFlds.Vci & 0xffff0000)
		return (MSP_PE_ERROR_ADDVC_ATM_VCI);

	if (pVcSet->ComFlds.VcType > MSP_PE_ATM_VCTYPE_MAX)
		return (MSP_PE_ERROR_ADDVC_ATM_VC_TYPE);

	/* For AAL5 VCs ensure MRU is multiple of 48 bytes. */
	if ((pVcSet->ComFlds.VcType == MSP_PE_ATM_VCTYPE_AAL5) &&
		((pVcSet->ComFlds.ParMod.MRU % 48) != 0))
		return (MSP_PE_ERROR_ADDVC_MRU_NOT_MULTIPLE48);

	/* Verify VC Flags */
	VcFlags = pVcSet->ComFlds.ParMod.VcFlags;
	if (VcFlags &=			
		~(MSP_PE_VC_FLAGS_LOOPBACK | 
			MSP_PE_VC_FLAGS_DISCARDRX | 
			MSP_PE_VC_FLAGS_AAL0_STRIP_ATM_HDR))
		return (MSP_PE_ERROR_VC_ATM_VCFLAGS);

	if ((VcFlags & MSP_PE_VC_FLAGS_AAL0_STRIP_ATM_HDR) &&
		(pVcSet->ComFlds.VcType != MSP_PE_ATM_VCTYPE_AAL0))
		return (MSP_PE_ERROR_VC_ATM_VCFLAGS);

	if (pVcSet->ComFlds.ParMod.SrvType > MSP_PE_ATM_SRVTYPE_MAX)
		return (MSP_PE_ERROR_VC_ATM_SRV_TYPE);

	if (pVcSet->ComFlds.ParMod.VoiceProtocolType > 
									MSP_PE_VOICE_PROTOCOL_MAX)
		return (MSP_PE_ERROR_VC_VOICE_PROTOCOL);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0									CmdId				*/
	/*	0x4									HsHandle			*/
	/*	0x8									TxBdBaseAddr		*/
	/*	0xC			IndMode					TxBdSize			*/
	/*	0x10		UserRxId				RxBdBaseAddr		*/
	/*	0x14		UserErrorId				RxBdSize			*/
	/*	0x18		TxCompleteFunc			PeakCellEmissionTime*/
	/*	0x1c		RxCompleteFunc			SustainedCellEmissionTime*/
	/*	0x20		ErrorFunc				BurstThreshold		*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	msgBody = (msp_pe_atm_vc *)
		(serBuf->dataBuffer +
		sizeof(msp_ped_add_vc_atm) - 
		sizeof(msp_pe_atm_vc));

	msgBody->IndMode = pVcSet->IndMode;
	msgBody->UserRxId = pVcSet->UserRxId;
	msgBody->UserErrorId = pVcSet->UserErrorId;
	msgBody->TxCompleteFunc = pVcSet->TxCompleteFunc;
	msgBody->RxCompleteFunc = pVcSet->RxCompleteFunc;
	msgBody->ErrorFunc = pVcSet->ErrorFunc;

	msgBody->ComFlds.PhyDevice.InterfaceNum =
				pVcSet->ComFlds.PhyDevice.InterfaceNum;
	msgBody->ComFlds.PhyDevice.PhyAddr = 
				pVcSet->ComFlds.PhyDevice.PhyAddr;

	msgBody->ComFlds.Vpi = pVcSet->ComFlds.Vpi;
	msgBody->ComFlds.Vci = pVcSet->ComFlds.Vci;
	msgBody->ComFlds.VcType = pVcSet->ComFlds.VcType;

	msgBody->ComFlds.ParMod.SrvType = 
				pVcSet->ComFlds.ParMod.SrvType;
	msgBody->ComFlds.ParMod.PeakCellRate = 
				pVcSet->ComFlds.ParMod.PeakCellRate;
	msgBody->ComFlds.ParMod.SustainedCellRate = 
				pVcSet->ComFlds.ParMod.SustainedCellRate;
	msgBody->ComFlds.ParMod.MaxBurstSize = 
				pVcSet->ComFlds.ParMod.MaxBurstSize;
	msgBody->ComFlds.ParMod.MinCellRate = 
				pVcSet->ComFlds.ParMod.MinCellRate;
	msgBody->ComFlds.ParMod.VcFlags = 
				pVcSet->ComFlds.ParMod.VcFlags;
	msgBody->ComFlds.ParMod.VoiceProtocolType = 
				pVcSet->ComFlds.ParMod.VoiceProtocolType;
	msgBody->ComFlds.ParMod.MTU = 
				pVcSet->ComFlds.ParMod.MTU;
	msgBody->ComFlds.ParMod.MRU = 
				pVcSet->ComFlds.ParMod.MRU;

	/* Schedule MspPeAddAtmVcSer */
	MSP_JOB_ADD(&MspPeAddAtmVcSer,
			completeFunc,
			callerRefId,
			serBuf,
			returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddFrVCBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to provision a Frame Relay VC.		  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				pVcSet- pointer to structure containing FR VC	  */
/*						properties								  */
/*																  */
/*				pFeResp- pointer to structure containing status	  */
/*						 and VC handle							  */
/*																  */
/******************************************************************/

U32 MspPeAddFrVCBlk(msp_pe_fr_vc	*pVcSet,
					msp_pe_resp		*pFeResp)
{
	msp_buf			*serBuf;
	mspMsg			msg;	/* Has to be named msg for job_add */
	msp_pe_fr_vc	*msgBody;
	U32				returnValue;
	U32				comStatus;

	/* One of the WanConfigs must be called first */
	if (!(FeWanConfigComplete))
		return (MSP_PE_ERROR_ADDVC_NO_WANCONFIG_CALL);

	if (pVcSet->IndMode > MSP_PE_VC_POLLING_MODE)
		return (MSP_PE_ERROR_ADDVC_IND_MODE);

	if (pVcSet->ComFlds.VcType > MSP_PE_FR_VCTYPE_VOICE)
		return (MSP_PE_ERROR_ADDVC_FR_VC_TYPE);

	if (pVcSet->ComFlds.ParMod.VoiceProtocolType > 
									MSP_PE_VOICE_PROTOCOL_MAX)
		return (MSP_PE_ERROR_VC_VOICE_PROTOCOL);

	if (!(pFeResp))
		return (MSP_PE_ERROR_RESPONSE_STRUCT);

	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			IndMode					CmdId				*/
	/*	0x4			UserRxId				HsHandle			*/
	/*	0x8			UserErrorId				TxBdBaseAddr		*/
	/*	0xC			TxCompleteFunc			TxBdSize			*/
	/*	0x10		RxCompleteFunc			RxBdBaseAddr		*/
	/*	0x14		ErrorFunc				RxBdSize			*/
	/*	0x18													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	msgBody = (msp_pe_fr_vc *)serBuf->dataBuffer;

	msgBody->IndMode = pVcSet->IndMode;
	msgBody->UserRxId = pVcSet->UserRxId;
	msgBody->UserErrorId = pVcSet->UserErrorId;
	msgBody->TxCompleteFunc = pVcSet->TxCompleteFunc;
	msgBody->RxCompleteFunc = pVcSet->RxCompleteFunc;
	msgBody->ErrorFunc = pVcSet->ErrorFunc;

	msgBody->ComFlds.PhyDevice.InterfaceNum =
				pVcSet->ComFlds.PhyDevice.InterfaceNum;
	msgBody->ComFlds.PhyDevice.PhyAddr = 
				pVcSet->ComFlds.PhyDevice.PhyAddr;

	msgBody->ComFlds.VcType = pVcSet->ComFlds.VcType;
	msgBody->ComFlds.Dlci = pVcSet->ComFlds.Dlci;

	msgBody->ComFlds.ParMod.Bc = 
				pVcSet->ComFlds.ParMod.Bc;
	msgBody->ComFlds.ParMod.Be = 
				pVcSet->ComFlds.ParMod.Be;
	msgBody->ComFlds.ParMod.FragmentSize = 
				pVcSet->ComFlds.ParMod.FragmentSize;
	msgBody->ComFlds.ParMod.VcFlags = 
				pVcSet->ComFlds.ParMod.VcFlags;
	msgBody->ComFlds.ParMod.VoiceProtocolType = 
				pVcSet->ComFlds.ParMod.VoiceProtocolType;
	msgBody->ComFlds.ParMod.MTU = 
				pVcSet->ComFlds.ParMod.MTU;
	msgBody->ComFlds.ParMod.MRU = 
				pVcSet->ComFlds.ParMod.MRU;

	/* Get AddFrVcBlk Semaphore */
	SEMTAKE(mspPeAddFrVcSemId, WAIT_FOREVER);

	/* Schedule MspPeAddFrVcSer */
	MSP_JOB_ADD(&MspPeAddFrVcSer, &MspPeAddFrVcComplete, NULL, serBuf, returnValue);

	/* Wait for AddFrVcBlk Semaphore */
	SEMTAKE(mspPeAddFrVcSemId, WAIT_FOREVER);

	FeAddFrVcComplete = 0;
	comStatus = FeAddFrVcStatus;
	FeAddFrVcStatus = 0;

	/* Set the status in the response struct */
	pFeResp->Status = comStatus;
	pFeResp->PePar1 = FeAddFrVcHandle;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeAddFrVcSemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddFrVC													  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to provision a Frame Relay VC.		  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				pVcSet- pointer to structure containing FR VC	  */
/*						properties								  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeAddFrVC(U32			callerRefId,
				 msp_pe_fr_vc	*pVcSet,
				 void			(*completeFunc)(msp_pe_resp *pFeResp))
{
	msp_buf			*serBuf;
	mspMsg			msg;	/* Has to be named msg for job_add */
	msp_pe_fr_vc	*msgBody;
	U32				returnValue;

	/* One of the WanConfigs must be called first */
	if (!(FeWanConfigComplete))
		return (MSP_PE_ERROR_ADDVC_NO_WANCONFIG_CALL);

	if (pVcSet->IndMode > MSP_PE_VC_POLLING_MODE)
		return (MSP_PE_ERROR_ADDVC_IND_MODE);

	if (pVcSet->ComFlds.VcType > MSP_PE_FR_VCTYPE_VOICE)
		return (MSP_PE_ERROR_ADDVC_FR_VC_TYPE);

	if (pVcSet->ComFlds.ParMod.VoiceProtocolType > 
									MSP_PE_VOICE_PROTOCOL_MAX)
		return (MSP_PE_ERROR_VC_VOICE_PROTOCOL);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			IndMode					CmdId				*/
	/*	0x4			UserRxId				HsHandle			*/
	/*	0x8			UserErrorId				TxBdBaseAddr		*/
	/*	0xC			TxCompleteFunc			TxBdSize			*/
	/*	0x10		RxCompleteFunc			RxBdBaseAddr		*/
	/*	0x14		ErrorFunc				RxBdSize			*/
	/*	0x18													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	msgBody = (msp_pe_fr_vc *)serBuf->dataBuffer;

	msgBody->IndMode = pVcSet->IndMode;
	msgBody->UserRxId = pVcSet->UserRxId;
	msgBody->UserErrorId = pVcSet->UserErrorId;
	msgBody->TxCompleteFunc = pVcSet->TxCompleteFunc;
	msgBody->RxCompleteFunc = pVcSet->RxCompleteFunc;
	msgBody->ErrorFunc = pVcSet->ErrorFunc;

	msgBody->ComFlds.PhyDevice.InterfaceNum =
				pVcSet->ComFlds.PhyDevice.InterfaceNum;
	msgBody->ComFlds.PhyDevice.PhyAddr = 
				pVcSet->ComFlds.PhyDevice.PhyAddr;

	msgBody->ComFlds.VcType = pVcSet->ComFlds.VcType;
	msgBody->ComFlds.Dlci = pVcSet->ComFlds.Dlci;

	msgBody->ComFlds.ParMod.Bc = 
				pVcSet->ComFlds.ParMod.Bc;
	msgBody->ComFlds.ParMod.Be = 
				pVcSet->ComFlds.ParMod.Be;
	msgBody->ComFlds.ParMod.FragmentSize = 
				pVcSet->ComFlds.ParMod.FragmentSize;
	msgBody->ComFlds.ParMod.VcFlags = 
				pVcSet->ComFlds.ParMod.VcFlags;
	msgBody->ComFlds.ParMod.VoiceProtocolType = 
				pVcSet->ComFlds.ParMod.VoiceProtocolType;
	msgBody->ComFlds.ParMod.MTU = 
				pVcSet->ComFlds.ParMod.MTU;
	msgBody->ComFlds.ParMod.MRU = 
				pVcSet->ComFlds.ParMod.MRU;

	/* Schedule MspPeAddFrVcSer */
	MSP_JOB_ADD(&MspPeAddFrVcSer,
			completeFunc,
			callerRefId,
			serBuf,
			returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddHdlcVCBlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to provision an HDLC VC.				  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				pVcSet- pointer to structure containing HDLC VC	  */
/*						properties								  */
/*																  */
/*				pFeResp- pointer to structure containing status	  */
/*						 and VC handle							  */
/*																  */
/******************************************************************/

U32 MspPeAddHdlcVCBlk(msp_pe_hdlc_vc	*pVcSet,
					  msp_pe_resp		*pFeResp)
{
	msp_buf			*serBuf;
	mspMsg			msg;	/* Has to be named msg for job_add */
	msp_pe_hdlc_vc	*msgBody;
	U32				returnValue;
	U32				comStatus;

	/* One of the WanConfigs must be called first */
	if (!(FeWanConfigComplete))
		return (MSP_PE_ERROR_ADDVC_NO_WANCONFIG_CALL);

	if (pVcSet->IndMode > MSP_PE_VC_POLLING_MODE)
		return (MSP_PE_ERROR_ADDVC_IND_MODE);

	if (!(pFeResp))
		return (MSP_PE_ERROR_RESPONSE_STRUCT);

	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			IndMode					CmdId				*/
	/*	0x4			UserRxId				HsHandle			*/
	/*	0x8			UserErrorId				TxBdBaseAddr		*/
	/*	0xC			TxCompleteFunc			TxBdSize			*/
	/*	0x10		RxCompleteFunc			RxBdBaseAddr		*/
	/*	0x14		ErrorFunc				RxBdSize			*/
	/*	0x18													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	msgBody = (msp_pe_hdlc_vc *)serBuf->dataBuffer;

	msgBody->IndMode = pVcSet->IndMode;
	msgBody->UserRxId = pVcSet->UserRxId;
	msgBody->UserErrorId = pVcSet->UserErrorId;
	msgBody->TxCompleteFunc = pVcSet->TxCompleteFunc;
	msgBody->RxCompleteFunc = pVcSet->RxCompleteFunc;
	msgBody->ErrorFunc = pVcSet->ErrorFunc;

	msgBody->ComFlds.PhyDevice.InterfaceNum =
				pVcSet->ComFlds.PhyDevice.InterfaceNum;
	msgBody->ComFlds.PhyDevice.PhyAddr = 
				pVcSet->ComFlds.PhyDevice.PhyAddr;
	msgBody->ComFlds.MTU = 
				pVcSet->ComFlds.MTU;
	msgBody->ComFlds.MRU = 
				pVcSet->ComFlds.MRU;

	/* Get AddHdlcVcBlk Semaphore */
	SEMTAKE(mspPeAddHdlcVcSemId, WAIT_FOREVER);

	/* Schedule MspPeAddHdlcVcSer */
	MSP_JOB_ADD(&MspPeAddHdlcVcSer,
				&MspPeAddHdlcVcComplete,
				NULL,
				serBuf,
				returnValue);

	/* Wait for AddHdlcVcBlk Semaphore */
	SEMTAKE(mspPeAddHdlcVcSemId, WAIT_FOREVER);

	FeAddHdlcVcComplete = 0;
	comStatus = FeAddHdlcVcStatus;
	FeAddHdlcVcStatus = 0;

	/* Set the status in the response struct */
	pFeResp->Status = comStatus;
	pFeResp->PePar1 = FeAddHdlcVcHandle;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeAddHdlcVcSemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddHdlcVC												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to provision an HDLC VC.				  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				pVcSet- pointer to structure containing Hdlc VC	  */
/*						properties								  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeAddHdlcVC(U32				callerRefId,
				   msp_pe_hdlc_vc	*pVcSet,
				   void				(*completeFunc)(msp_pe_resp *pFeResp))
{
	msp_buf			*serBuf;
	mspMsg			msg;	/* Has to be named msg for job_add */
	msp_pe_hdlc_vc	*msgBody;
	U32				returnValue;

	/* One of the WanConfigs must be called first */
	if (!(FeWanConfigComplete))
		return (MSP_PE_ERROR_ADDVC_NO_WANCONFIG_CALL);

	if (pVcSet->IndMode > MSP_PE_VC_POLLING_MODE)
		return (MSP_PE_ERROR_ADDVC_IND_MODE);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			IndMode					CmdId				*/
	/*	0x4			UserRxId				HsHandle			*/
	/*	0x8			UserErrorId				TxBdBaseAddr		*/
	/*	0xC			TxCompleteFunc			TxBdSize			*/
	/*	0x10		RxCompleteFunc			RxBdBaseAddr		*/
	/*	0x14		ErrorFunc				RxBdSize			*/
	/*	0x18													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	msgBody = (msp_pe_hdlc_vc *)serBuf->dataBuffer;

	msgBody->IndMode = pVcSet->IndMode;
	msgBody->UserRxId = pVcSet->UserRxId;
	msgBody->UserErrorId = pVcSet->UserErrorId;
	msgBody->TxCompleteFunc = pVcSet->TxCompleteFunc;
	msgBody->RxCompleteFunc = pVcSet->RxCompleteFunc;
	msgBody->ErrorFunc = pVcSet->ErrorFunc;

	msgBody->ComFlds.PhyDevice.InterfaceNum =
				pVcSet->ComFlds.PhyDevice.InterfaceNum;
	msgBody->ComFlds.PhyDevice.PhyAddr = 
				pVcSet->ComFlds.PhyDevice.PhyAddr;
	msgBody->ComFlds.MTU = 
				pVcSet->ComFlds.MTU;
	msgBody->ComFlds.MRU = 
				pVcSet->ComFlds.MRU;

	/* Schedule MspPeAddHdlcVcSer */
	MSP_JOB_ADD(&MspPeAddHdlcVcSer,
				completeFunc,
				callerRefId,
				serBuf,
				returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeDelVCBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to delete a VC from the WAN interface.  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of VC to be removed			  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found and deleted				  */
/*																  */
/******************************************************************/

U32 MspPeDelVCBlk(U32 PeVcHandle)
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;
	U32			comStatus;

	if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);


	/* Get DelVcBlk Semaphore */
	SEMTAKE(mspPeDelVcSemId, WAIT_FOREVER);

	/* Schedule MspPeDelVcSer */
	MSP_JOB_ADD(&MspPeDelVcSer,
				PeVcHandle,
				&MspPeDelVcComplete,
				NULL,
				returnValue);

	/* Wait for DelVcBlk Semaphore */
	SEMTAKE(mspPeDelVcSemId, WAIT_FOREVER);

	FeDelVcComplete = 0;
	comStatus = FeDelVcStatus;
	FeDelVcStatus = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeDelVcSemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeDelVC													  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to delete a VC from the WAN interface.  */
/*																  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				PeVcHandle- Handle of VC to be removed			  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found and delete command sent	  */
/*																  */
/******************************************************************/

U32 MspPeDelVC(U32		callerRefId,
			   U32		PeVcHandle,
			   void		(*completeFunc)(msp_pe_resp *pFeResp))
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;

	if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	/* Schedule MspPeDelVcSer */
	MSP_JOB_ADD(&MspPeDelVcSer,
				PeVcHandle,
				completeFunc,
				callerRefId,
				returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeEnableVCBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to enable a VC on the WAN interface.	  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of VC to be enabled			  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found and enabled				  */
/*																  */
/******************************************************************/

U32 MspPeEnableVCBlk(U32 PeVcHandle)
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;
	U32			comStatus;

	if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);


	/* Get EnaVcBlk Semaphore */
	SEMTAKE(mspPeEnaVcSemId, WAIT_FOREVER);

#ifdef PE_ENAVC_DEBUG
	printf("EVC:  About to schedule EnableVc\n");
#endif

	/* Schedule MspPeEnableVcSer */
	MSP_JOB_ADD(&MspPeEnableVcSer,
				PeVcHandle,
				&MspPeEnableVcComplete,
				NULL,
				returnValue);

	/* Wait for EnaVcBlk Semaphore */
	SEMTAKE(mspPeEnaVcSemId, WAIT_FOREVER);

	FeEnableVcComplete = 0;
	comStatus = FeEnableVcStatus;
	FeEnableVcStatus = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeEnaVcSemId);

#ifdef PE_ENAVC_DEBUG
	printf("EVC:  Exiting EnableVc\n");
#endif

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeEnableVC												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to enable a VC on the WAN interface.	  */
/*																  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				PeVcHandle- Handle of VC to be enabled			  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found and enable command sent	  */
/*																  */
/******************************************************************/

U32 MspPeEnableVC(U32		callerRefId,
				  U32		PeVcHandle,
				  void		(*completeFunc)(msp_pe_resp *pFeResp))
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;

	if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);


	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	/* Schedule MspPeEnableVcSer */
	MSP_JOB_ADD(&MspPeEnableVcSer,
				PeVcHandle,
				completeFunc,
				callerRefId,
				returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeDisableVCBlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to disable a VC on the WAN interface.	  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of VC to be disabled			  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found and disabled			  */
/*																  */
/******************************************************************/

U32 MspPeDisableVCBlk(U32 PeVcHandle)
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;
	U32			comStatus;

	if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	/* Get DisVc Semaphore */
	SEMTAKE(mspPeDisVcSemId, WAIT_FOREVER);

	/* Schedule MspPeDisableVcSer */
	MSP_JOB_ADD(&MspPeDisableVcSer, PeVcHandle, &MspPeDisableVcComplete, NULL, returnValue);

	/* Wait for DisVc Semaphore */
	SEMTAKE(mspPeDisVcSemId, WAIT_FOREVER);

	FeDisableVcComplete = 0;
	comStatus = FeDisableVcStatus;
	FeDisableVcStatus = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeDisVcSemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeDisableVC												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to disable a VC on the WAN interface.	  */
/*																  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				PeVcHandle- Handle of VC to be disabled			  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found and disable cmd sent	  */
/*																  */
/******************************************************************/

U32 MspPeDisableVC(U32		callerRefId,
				   U32		PeVcHandle,
				   void		(*completeFunc)(msp_pe_resp *pFeResp))
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;

	if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	/* Schedule MspPeDisableVcSer */
	MSP_JOB_ADD(&MspPeDisableVcSer,
				PeVcHandle,
				completeFunc,
				callerRefId,
				returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeModAtmVCBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify an existing Atm VC's		  */
/* attributes.													  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				pVcMod- pointer to structure containing new Atm	  */
/*						VC properties							  */
/*																  */
/*				pFeResp- pointer to structure containing status	  */
/*																  */
/******************************************************************/

U32 MspPeModAtmVCBlk(msp_pe_mod_vc_atm *pVcMod)
{
	msp_buf				*serBuf;
	U32					disStatus;
	U32					enaStatus;
	mspMsg				msg;	/* Has to be named msg for job_add */
	msp_pe_mod_vc_atm	*msgBody;
	U32					returnValue;
	U32					comStatus;
	U32					VcFlags;

	if (pVcMod->PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if ((pVcMod->ComFlds.SrvType != MSP_PE_NO_CHANGE) &&
		(pVcMod->ComFlds.SrvType > MSP_PE_ATM_SRVTYPE_MAX))
		return (MSP_PE_ERROR_VC_ATM_SRV_TYPE);

	if ((pVcMod->ComFlds.VoiceProtocolType != MSP_PE_NO_CHANGE) &&
		(pVcMod->ComFlds.VoiceProtocolType > MSP_PE_VOICE_PROTOCOL_MAX))
		return (MSP_PE_ERROR_VC_VOICE_PROTOCOL);

	/* Verify VC Flags */
	VcFlags = pVcMod->ComFlds.VcFlags;
	if (VcFlags != MSP_PE_NO_CHANGE)
	{
		if (VcFlags &=			
			~(MSP_PE_VC_FLAGS_LOOPBACK | 
				MSP_PE_VC_FLAGS_DISCARDRX | 
				MSP_PE_VC_FLAGS_AAL0_STRIP_ATM_HDR))
			return (MSP_PE_ERROR_VC_ATM_VCFLAGS);
	}

	/* Modifying the VC requires disabling it first */
	disStatus = MspPeDisableVCBlk(pVcMod->PeVcHandle);

	if (disStatus != MSP_SUCCESS) 
	{
		return (disStatus);
	}

	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}
	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				PeVcHandle			*/
	/*	0x4			<Not Used>				CmdId				*/
	/*	0x8			<Not Used>				HsHandle			*/
	/*	0xc			<Not Used>				PedVcHandle			*/
	/*	0x10		<Not Used>				VpmdPortHandle		*/
	/*	0x14		<Not Used>				PeakCellEmissionTime*/
	/*	0x18		<Not Used>				SustainedCellEmissionTime*/
	/*	0x1c		PeVcHandle				BurstThreshold		*/
	/*	0x20													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/*															*/
	/* Note: PeVcHandle in Extended Command column is not		*/
	/*		 part of the extended command.	It's kept in the	*/
	/*		 serBuf so we can map it back and completion time.	*/
	/************************************************************/
	msgBody = (msp_pe_mod_vc_atm *)
		(serBuf->dataBuffer +
		(sizeof(msp_ped_mod_vc_atm) + 4) - 
		sizeof(msp_pe_mod_vc_atm));

	msgBody->PeVcHandle = pVcMod->PeVcHandle;	
	msgBody->ComFlds.SrvType = 
				pVcMod->ComFlds.SrvType;
	msgBody->ComFlds.PeakCellRate = 
				pVcMod->ComFlds.PeakCellRate;
	msgBody->ComFlds.SustainedCellRate = 
				pVcMod->ComFlds.SustainedCellRate;
	msgBody->ComFlds.MaxBurstSize = 
				pVcMod->ComFlds.MaxBurstSize;
	msgBody->ComFlds.MinCellRate = 
				pVcMod->ComFlds.MinCellRate;
	msgBody->ComFlds.VcFlags = 
				pVcMod->ComFlds.VcFlags;
	msgBody->ComFlds.VoiceProtocolType = 
				pVcMod->ComFlds.VoiceProtocolType;

	/* Get ModVcBlk Semaphore */
	SEMTAKE(mspPeModAtmVcSemId, WAIT_FOREVER);

	/* Schedule MspPeModAtmVcSer */
	MSP_JOB_ADD(&MspPeModAtmVcSer,
				&MspPeModAtmVcComplete,
				NULL,
				serBuf,
				returnValue);

	/* Wait for ModVcBlk Semaphore */
	SEMTAKE(mspPeModAtmVcSemId, WAIT_FOREVER);

	FeModAtmVcComplete = 0;
	comStatus = FeModAtmVcStatus;
	FeModAtmVcStatus = 0;

	/* Modifying the VC requires enabling it now */
	enaStatus = MspPeEnableVCBlk(pVcMod->PeVcHandle);

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeModAtmVcSemId);

	if (enaStatus != MSP_SUCCESS) {
		return(enaStatus);
	}

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeModAtmVC												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify an existing Atm VC's		  */
/* attributes.													  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				pVcMod- pointer to structure containing new Atm	  */
/*						VC properties							  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeModAtmVC(U32					callerRefId,
				  msp_pe_mod_vc_atm		*pVcMod,
				  void					(*completeFunc)(msp_pe_resp *pFeResp))
{
	msp_buf				*serBuf;
	mspMsg				msg;	/* Has to be named msg for job_add */
	msp_pe_mod_vc_atm	*msgBody;
	U32					returnValue;

	if (pVcMod->PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if ((pVcMod->ComFlds.SrvType != MSP_PE_NO_CHANGE) &&
		(pVcMod->ComFlds.SrvType > MSP_PE_ATM_SRVTYPE_MAX))
		return (MSP_PE_ERROR_VC_ATM_SRV_TYPE);

	if ((pVcMod->ComFlds.VoiceProtocolType != MSP_PE_NO_CHANGE) &&
		(pVcMod->ComFlds.VoiceProtocolType > MSP_PE_VOICE_PROTOCOL_MAX))
		return (MSP_PE_ERROR_VC_VOICE_PROTOCOL);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				PeVcHandle			*/
	/*	0x4			<Not Used>				CmdId				*/
	/*	0x8			<Not Used>				HsHandle			*/
	/*	0xc			<Not Used>				PedVcHandle			*/
	/*	0x10		<Not Used>				VpmdPortHandle		*/
	/*	0x14		<Not Used>				PeakCellEmissionTime*/
	/*	0x18		<Not Used>				SustainedCellEmissionTime*/
	/*	0x1c		PeVcHandle				BurstThreshold		*/
	/*	0x20													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/*															*/
	/* Note: PeVcHandle in Extended Command column is not		*/
	/*		 part of the extended command.	It's kept in the	*/
	/*		 serBuf so we can map it back and completion time.	*/
	/************************************************************/
	msgBody = (msp_pe_mod_vc_atm *)
		(serBuf->dataBuffer +
		(sizeof(msp_ped_mod_vc_atm) + 4) - 
		sizeof(msp_pe_mod_vc_atm));

	msgBody->PeVcHandle = pVcMod->PeVcHandle;	
	msgBody->ComFlds.SrvType = 
				pVcMod->ComFlds.SrvType;
	msgBody->ComFlds.PeakCellRate = 
				pVcMod->ComFlds.PeakCellRate;
	msgBody->ComFlds.SustainedCellRate = 
				pVcMod->ComFlds.SustainedCellRate;
	msgBody->ComFlds.MaxBurstSize = 
				pVcMod->ComFlds.MaxBurstSize;
	msgBody->ComFlds.MinCellRate = 
				pVcMod->ComFlds.MinCellRate;
	msgBody->ComFlds.VcFlags = 
				pVcMod->ComFlds.VcFlags;
	msgBody->ComFlds.VoiceProtocolType = 
				pVcMod->ComFlds.VoiceProtocolType;

	/* Schedule MspPeModAtmVcSer */
	MSP_JOB_ADD(&MspPeModAtmVcSer,
				completeFunc,
				callerRefId,
				serBuf,
				returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeModFrVCBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify an existing Frame Relay VC's  */
/* attributes.													  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				pVcMod- pointer to structure containing new FR VC */
/*						properties								  */
/*																  */
/*				pFeResp- pointer to structure containing status	  */
/*																  */
/******************************************************************/

U32 MspPeModFrVCBlk(msp_pe_mod_vc_fr *pVcMod)
{
	msp_buf				*serBuf;
	U32					disStatus;
	U32					enaStatus;
	mspMsg				msg;	/* Has to be named msg for job_add */
	msp_pe_mod_vc_fr	*msgBody;
	U32					returnValue;
	U32					comStatus;

	if (pVcMod->PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (pVcMod->ComFlds.VoiceProtocolType > MSP_PE_VOICE_PROTOCOL_MAX)
		return (MSP_PE_ERROR_VC_VOICE_PROTOCOL);

	/* Modifying the VC requires disabling it first */
	disStatus = MspPeDisableVCBlk(pVcMod->PeVcHandle);

	if (disStatus != MSP_SUCCESS) {
		return (disStatus);
	}

	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				PeVcHandle			*/
	/*	0x4			<Not Used>				CmdId				*/
	/*	0x8			<Not Used>				HsHandle			*/
	/*	0xC			PeVcHandle				PedVcHandle			*/
	/*	0x10													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	serBuf->prependStart = 11;
	msgBody = (msp_pe_mod_vc_fr *)MspGetBufferStartOfData(serBuf);

	msgBody->PeVcHandle = pVcMod->PeVcHandle;	
	msgBody->ComFlds.Bc = pVcMod->ComFlds.Bc;
	msgBody->ComFlds.Be = pVcMod->ComFlds.Be;
	msgBody->ComFlds.FragmentSize = 
				pVcMod->ComFlds.FragmentSize;
	msgBody->ComFlds.VcFlags = 
				pVcMod->ComFlds.VcFlags;
	msgBody->ComFlds.VoiceProtocolType = 
				pVcMod->ComFlds.VoiceProtocolType;

	/* Get ModFrVcBlk Semaphore */
	SEMTAKE(mspPeModFrVcSemId, WAIT_FOREVER);

	/* Schedule MspPeModFrVcSer */
	MSP_JOB_ADD(&MspPeModFrVcSer, &MspPeModFrVcComplete, NULL, serBuf, returnValue);

	/* Wait for ModFrVcBlk Semaphore */
	SEMTAKE(mspPeModFrVcSemId, WAIT_FOREVER);

	FeModFrVcComplete = 0;
	comStatus = FeModFrVcStatus;
	FeModFrVcStatus = 0;

	/* Modifying the VC requires enabling it now */
	enaStatus = MspPeEnableVCBlk(pVcMod->PeVcHandle);

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeModFrVcSemId);

	if (enaStatus != MSP_SUCCESS) {
		return(enaStatus);
	}

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeModFrVC													  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify an existing Frame Relay VC's  */
/* attributes.													  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				pVcMod- pointer to structure containing FR VC	  */
/*						properties								  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeModFrVC(U32				callerRefId,
				 msp_pe_mod_vc_fr	*pVcMod,
				 void				(*completeFunc)(msp_pe_resp *pFeResp))
{
	msp_buf				*serBuf;
	mspMsg				msg;	/* Has to be named msg for job_add */
	msp_pe_mod_vc_fr	*msgBody;
	U32					returnValue;

	if (pVcMod->PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (pVcMod->ComFlds.VoiceProtocolType > MSP_PE_VOICE_PROTOCOL_MAX)
		return (MSP_PE_ERROR_VC_VOICE_PROTOCOL);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				PeVcHandle			*/
	/*	0x4			<Not Used>				CmdId				*/
	/*	0x8			<Not Used>				HsHandle			*/
	/*	0xC			PeVcHandle				PedVcHandle			*/
	/*	0x10													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	serBuf->prependStart = 11;
	msgBody = (msp_pe_mod_vc_fr *)MspGetBufferStartOfData(serBuf);

	msgBody->PeVcHandle = pVcMod->PeVcHandle;	
	msgBody->ComFlds.Bc = pVcMod->ComFlds.Bc;
	msgBody->ComFlds.Be = pVcMod->ComFlds.Be;
	msgBody->ComFlds.FragmentSize = 
				pVcMod->ComFlds.FragmentSize;
	msgBody->ComFlds.VcFlags = 
				pVcMod->ComFlds.VcFlags;
	msgBody->ComFlds.VoiceProtocolType = 
				pVcMod->ComFlds.VoiceProtocolType;

	/* Schedule MspPeFrModVcSer */
	MSP_JOB_ADD(&MspPeModFrVcSer,
				completeFunc,
				callerRefId,
				serBuf,
				returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeModVCCallbackBlk										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify an existing VC's Callback	  */
/* functions.													  */
/*																  */
/* PARAMETERS:													  */
/*				pVcMod- pointer to structure containing VC		  */
/*						callback functions.						  */
/*																  */
/******************************************************************/

U32 MspPeModVCCallbackBlk( msp_pe_vc_callback	*pCBAtts)
{
	if (pCBAtts->PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);


	/* Store all the values in the		*/
	/* global VC attribute structure	*/
	peVcHandle = pCBAtts->PeVcHandle;

	intLevel = intLock();
	VC[peVcHandle]->UserRxId = pCBAtts->UserRxId;	
	VC[peVcHandle]->UserErrorId = pCBAtts->UserErrorId;	
	VC[peVcHandle]->TxCompleteFunc = pCBAtts->TxCompleteFunc;	
	VC[peVcHandle]->RxCompleteFunc = pCBAtts->RxCompleteFunc;	
	VC[peVcHandle]->ErrorFunc = pCBAtts->ErrorFunc;	
	intUnLock(intLevel);
	
	return (MSP_SUCCESS);
}


/******************************************************************/
/*																  */
/* MspPeModVCCallback											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify an existing VC's Callback	  */
/* functions.													  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				pVcMod- pointer to structure containing VC		  */
/*						callback functions.						  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/******************************************************************/

U32 MspPeModVCCallback( U32					callerRefId,
						msp_pe_vc_callback	*pCBAtts,
						void				(*completeFunc)(msp_pe_resp *pPeResp))
{
	msp_pe_resp			respStruct;
	U32					status;

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	status = MspPeModVCCallbackBlk (pCBAtts);
	if (status != MSP_SUCCESS)
		return status;
	
	respStruct.CallerRefId = callerRefId;
	respStruct.Status = MSP_SUCCESS;
	respStruct.PePar1 = pCBAtts->PeVcHandle; 

	(*completeFunc)(&respStruct);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetAtmVCStatsBlk										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get an Atm VC's statistics.		  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of VC to get statistics from	  */
/*																  */
/*				pStat-	Pointer to structure to place statistics  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found stats retrieved			  */
/*																  */
/******************************************************************/

U32 MspPeGetAtmVCStatsBlk(U32					PeVcHandle,
						  msp_pe_vc_stats_atm	*pStat)
{
	msp_buf					*serBuf;
	mspMsg					msg;
	msp_pe_vc_stats_pars	*msgBody;
	U32						returnValue;
	U32						getVcStatsStatus;

	if (!(PeVcHandle))
		PeVcHandle = PeFirstVcHandle;
	else if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (!(pStat))
		return (MSP_PE_ERROR_STATS_STRUCT);

	/* Get a big serialization buf to hold status and stats */
	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	msgBody = (msp_pe_vc_stats_pars *)serBuf->dataBuffer;

	msgBody->IsBlockingCall = 1;
	msgBody->PeVcHandle = PeVcHandle;
	msgBody->VcType = PE_VCTYPE_ATM;
	msgBody->AtmCompleteFunc = &MspPeGetAtmVcStatsComplete;

	/* Get GetAtmVcBlk Semaphore */
	SEMTAKE(mspPeGetAtmVcSemId, WAIT_FOREVER);

	/* Schedule MspPeGetAtmVcStatsSer */
	MSP_JOB_ADD(&MspPeGetAtmVcStatsSer,
			serBuf,
			NULL,
			NULL,
			returnValue);

	/* Wait for GetAtmVcBlk Semaphore */
	SEMTAKE(mspPeGetAtmVcSemId, WAIT_FOREVER);

	getVcStatsStatus = msgBody->Status;

	pStat->CurrPeVcHandle = PeVcHandle;
	pStat->NextPeVcHandle = VC[PeVcHandle]->NextPeVcHandle;

	pStat->VcCfg.PhyDevice.InterfaceNum =
							VC[PeVcHandle]->AtmVcFlds.PhyDevice.InterfaceNum;
	pStat->VcCfg.PhyDevice.PhyAddr =
							VC[PeVcHandle]->AtmVcFlds.PhyDevice.PhyAddr;
	pStat->VcCfg.Vpi = VC[PeVcHandle]->AtmVcFlds.Vpi;
	pStat->VcCfg.Vci = VC[PeVcHandle]->AtmVcFlds.Vci;
	pStat->VcCfg.VcType = VC[PeVcHandle]->AtmVcFlds.VcType;
	
#if 0
	pStat->VcCfg.ParMod.SrvType = VC[PeVcHandle]->AtmVcFlds.ParMod.SrvType;
	pStat->VcCfg.ParMod.PeakCellRate = VC[PeVcHandle]->AtmVcFlds.ParMod.PeakCellRate;
	pStat->VcCfg.ParMod.SustainedCellRate = VC[PeVcHandle]->AtmVcFlds.ParMod.SustainedCellRate;
	pStat->VcCfg.ParMod.MaxBurstSize = VC[PeVcHandle]->AtmVcFlds.ParMod.MaxBurstSize;
	pStat->VcCfg.ParMod.MinCellRate = VC[PeVcHandle]->AtmVcFlds.ParMod.MinCellRate; 
	pStat->VcCfg.ParMod.VcFlags = VC[PeVcHandle]->AtmVcFlds.ParMod.VcFlags;
	pStat->VcCfg.ParMod.VoiceProtocolType = VC[PeVcHandle]->AtmVcFlds.ParMod.VoiceProtocolType;
	pStat->VcCfg.ParMod.MTU = VC[PeVcHandle]->AtmVcFlds.ParMod.MTU;
	pStat->VcCfg.ParMod.MRU = VC[PeVcHandle]->AtmVcFlds.ParMod.MRU;
#else
	pStat->VcCfg.ParMod = VC[PeVcHandle]->AtmVcFlds.ParMod;
#endif

	cacheInvalidate(DATA_CACHE,
					&msgBody->VcStats.AtmStats,
					sizeof(msp_pe_vc_stats_atm_com));
		
	pStat->ComFlds.TxCells = msgBody->VcStats.AtmStats.TxCells;
	pStat->ComFlds.RxCells = msgBody->VcStats.AtmStats.RxCells;
	pStat->ComFlds.TxOamCells = msgBody->VcStats.AtmStats.TxOamCells;
	pStat->ComFlds.RxOamCells = msgBody->VcStats.AtmStats.RxOamCells;
	pStat->ComFlds.RxCrcErrs = msgBody->VcStats.AtmStats.RxCrcErrs;
	pStat->ComFlds.RxNoRxBdErrs = 
					msgBody->VcStats.AtmStats.RxNoRxBdErrs;
	pStat->ComFlds.RxCellsDropped = 
					msgBody->VcStats.AtmStats.RxCellsDropped;
	pStat->ComFlds.TxAal5Pdus = 
					msgBody->VcStats.AtmStats.TxAal5Pdus;
	pStat->ComFlds.RxAal5Pdus = 
					msgBody->VcStats.AtmStats.RxAal5Pdus;
	pStat->ComFlds.RxAal5PdusDropped = 
					msgBody->VcStats.AtmStats.RxAal5PdusDropped;
	pStat->ComFlds.RxAal5PduTooLong = 
					msgBody->VcStats.AtmStats.RxAal5PduTooLong;
	pStat->ComFlds.RxAal5InvCpiErrs = 
					msgBody->VcStats.AtmStats.RxAal5InvCpiErrs;
	pStat->ComFlds.RxAal5AbortedPdus = 
					msgBody->VcStats.AtmStats.RxAal5AbortedPdus;
	pStat->ComFlds.RxAal5InvLenErrs = 
					msgBody->VcStats.AtmStats.RxAal5InvLenErrs;
	pStat->ComFlds.RxAal2SeqNumErrs = 
					msgBody->VcStats.AtmStats.RxAal2SeqNumErrs;
	pStat->ComFlds.RxAal2UnknownCids = 
					msgBody->VcStats.AtmStats.RxAal2UnknownCids;

	/* Return Serialization Buffer to Fifo */
	MspFIFOBufInUsePut(PESerialFifoBig, serBuf);

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeGetAtmVcSemId);

	if (getVcStatsStatus)
		return(getVcStatsStatus);

	return (MSP_SUCCESS);
}


/******************************************************************/
/*																  */
/* MspPeGetAtmVCStats											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular Atm VC's statistics */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				PeVcHandle- Handle of VC to get statistics from	  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found and stats retrieved		  */
/*																  */
/******************************************************************/

U32 MspPeGetAtmVCStats( U32 callerRefId,
						U32 PeVcHandle,
						void	(*completeFunc)( msp_pe_resp *pPeResp,
												 msp_pe_vc_stats_atm *pStat))
{
	msp_buf					*serBuf;
	mspMsg					msg;
	msp_pe_vc_stats_pars	*msgBody;
	U32						returnValue;

	if (!(PeVcHandle))
		PeVcHandle = PeFirstVcHandle;

	if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	/* Get a big serialization buf to hold status and stats */
	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	msgBody = (msp_pe_vc_stats_pars *)serBuf->dataBuffer;

	msgBody->IsBlockingCall = 0;
	msgBody->PeVcHandle = PeVcHandle;
	msgBody->VcType = PE_VCTYPE_ATM;
	msgBody->AtmCompleteFunc = completeFunc;
	msgBody->CallerRefId = callerRefId;

	/* Get GetAtmVcBlk Semaphore */
	SEMTAKE(mspPeGetAtmVcSemId, WAIT_FOREVER);

	/* Schedule MspPeGetAtmVcStatsSer */
	MSP_JOB_ADD(&MspPeGetAtmVcStatsSer,
			serBuf,
			NULL,
			NULL,
			returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetFrVCStatsBlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular FR VC's statistics. */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of VC to get statistics from	  */
/*																  */
/*				pStat-	Pointer to structure to place statistics  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found stats retrieved			  */
/*																  */
/******************************************************************/

U32 MspPeGetFrVCStatsBlk(U32				PeVcHandle,
						 msp_pe_vc_stats_fr *pStat)
{
	msp_buf					*serBuf;
	mspMsg					msg;
	msp_pe_vc_stats_pars	*msgBody;
	U32						returnValue;
	U32						getVcStatsStatus;

	if (!(PeVcHandle))
		PeVcHandle = PeFirstVcHandle;
	else if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (!(pStat))
		return (MSP_PE_ERROR_STATS_STRUCT);


	/* Get a big serialization buf to hold status and stats */
	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	msgBody = (msp_pe_vc_stats_pars *)serBuf->dataBuffer;

	msgBody->IsBlockingCall = 1;
	msgBody->PeVcHandle = PeVcHandle;
	msgBody->VcType = PE_VCTYPE_FR;
	msgBody->FrCompleteFunc = &MspPeGetFrVcStatsComplete;

	/* Get GetFrVcBlk Semaphore */
	SEMTAKE(mspPeGetFrVcSemId, WAIT_FOREVER);

	/* Schedule MspPeGetFrVcStatsSer */
	MSP_JOB_ADD(&MspPeGetFrVcStatsSer,
				serBuf,
				NULL,
				NULL,
				returnValue);

	/* Wait for GetFrVcBlk Semaphore */
	SEMTAKE(mspPeGetFrVcSemId, WAIT_FOREVER);

	getVcStatsStatus = msgBody->Status;

	pStat->CurrPeVcHandle = PeVcHandle;
	pStat->NextPeVcHandle = VC[PeVcHandle]->NextPeVcHandle;

	pStat->VcCfg.PhyDevice.InterfaceNum =
							VC[PeVcHandle]->FrVcFlds.PhyDevice.InterfaceNum;
	pStat->VcCfg.PhyDevice.PhyAddr =
							VC[PeVcHandle]->FrVcFlds.PhyDevice.PhyAddr;
	pStat->VcCfg.VcType = VC[PeVcHandle]->FrVcFlds.VcType; 
	pStat->VcCfg.Dlci = VC[PeVcHandle]->FrVcFlds.Dlci;
	pStat->VcCfg.ParMod.Bc = VC[PeVcHandle]->FrVcFlds.ParMod.Bc;
	pStat->VcCfg.ParMod.Be = VC[PeVcHandle]->FrVcFlds.ParMod.Be;
	pStat->VcCfg.ParMod.FragmentSize =
							VC[PeVcHandle]->FrVcFlds.ParMod.FragmentSize;
	pStat->VcCfg.ParMod.VcFlags = VC[PeVcHandle]->FrVcFlds.ParMod.VcFlags;
	pStat->VcCfg.ParMod.VoiceProtocolType =
							VC[PeVcHandle]->FrVcFlds.ParMod.VoiceProtocolType;
	pStat->VcCfg.ParMod.MTU = VC[PeVcHandle]->FrVcFlds.ParMod.MTU;
	pStat->VcCfg.ParMod.MRU = VC[PeVcHandle]->FrVcFlds.ParMod.MRU;
	
	cacheInvalidate(DATA_CACHE,
					&msgBody->VcStats.FrStats,
					sizeof(msp_pe_vc_stats_fr_com));

	pStat->ComFlds.TxFrames = msgBody->VcStats.FrStats.TxFrames;
	pStat->ComFlds.RxFrames = msgBody->VcStats.FrStats.RxFrames;
	pStat->ComFlds.TxBytes = msgBody->VcStats.FrStats.TxBytes;
	pStat->ComFlds.RxBytes = msgBody->VcStats.FrStats.RxBytes;
	pStat->ComFlds.RxCrcErrs = msgBody->VcStats.FrStats.RxCrcErrs;
	pStat->ComFlds.NoRxBdErrs = msgBody->VcStats.FrStats.NoRxBdErrs;

	/* Return Serialization Buffer to Fifo */
	MspFIFOBufInUsePut(PESerialFifoBig, serBuf);

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeGetFrVcSemId);

	if (getVcStatsStatus)
		return(getVcStatsStatus);

	return (MSP_SUCCESS);
}


/******************************************************************/
/*																  */
/* MspPeGetFrVcStats											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular FR VC's statistics  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				PeVcHandle- Handle of VC to get statistics from	  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found and stats retrieved		  */
/*																  */
/******************************************************************/

U32 MspPeGetFrVCStats( U32	callerRefId,
					   U32	PeVcHandle,
					   void (*completeFunc)( msp_pe_resp		*pPeResp,
											 msp_pe_vc_stats_fr *pStat))
{
	msp_buf					*serBuf;
	mspMsg					msg;
	msp_pe_vc_stats_pars	*msgBody;
	U32						returnValue;

	if (!(PeVcHandle))
		PeVcHandle = PeFirstVcHandle;

	if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	/* Get a big serialization buf to hold status and stats */
	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	msgBody = (msp_pe_vc_stats_pars *)serBuf->dataBuffer;

	msgBody->IsBlockingCall = 0;
	msgBody->PeVcHandle = PeVcHandle;
	msgBody->VcType = PE_VCTYPE_FR;
	msgBody->FrCompleteFunc = completeFunc;
	msgBody->CallerRefId = callerRefId;

	/* Schedule MspPeGetFrVcStatsSer */
	MSP_JOB_ADD(&MspPeGetFrVcStatsSer,
				serBuf,
				NULL,
				NULL,
				returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetHDLCVCStatsBlk										  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular HDLC VC's			  */
/* statistics.													  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle- Handle of VC to get statistics from	  */
/*																  */
/*				pStat-	Pointer to structure to place statistics  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found stats retrieved			  */
/*																  */
/******************************************************************/

U32 MspPeGetHDLCVCStatsBlk(U32			PeVcHandle,
							msp_pe_vc_stats_hdlc	*pStat)
{
	msp_buf					*serBuf;
	mspMsg					msg;
	msp_pe_vc_stats_pars	*msgBody;
	U32						returnValue;
	U32						getVcStatsStatus;

	if (!(PeVcHandle))
		PeVcHandle = PeFirstVcHandle;
	else if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (!(pStat))
		return (MSP_PE_ERROR_STATS_STRUCT);

	/* Get a big serialization buf to hold status and stats */
	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	msgBody = (msp_pe_vc_stats_pars *)serBuf->dataBuffer;

	msgBody->IsBlockingCall = 1;
	msgBody->PeVcHandle = PeVcHandle;
	msgBody->VcType = PE_VCTYPE_HDLC;
	msgBody->HdlcCompleteFunc = &MspPeGetHdlcVcStatsComplete;

	/* Get GetHdlcVcBlk Semaphore */
	SEMTAKE(mspPeGetHdlcVcSemId, WAIT_FOREVER);

	/* Schedule MspPeGetHdlcVcStatsSer */
	MSP_JOB_ADD(&MspPeGetHdlcVcStatsSer,
			serBuf,
			NULL, 
			NULL,
			returnValue);

	/* Wait for GetHdlcVcBlk Semaphore */
	SEMTAKE(mspPeGetHdlcVcSemId, WAIT_FOREVER);

	getVcStatsStatus = msgBody->Status;

	pStat->CurrPeVcHandle = PeVcHandle;
	pStat->NextPeVcHandle = VC[PeVcHandle]->NextPeVcHandle;

	pStat->VcCfg.PhyDevice.InterfaceNum =
							VC[PeVcHandle]->HdlcVcFlds.PhyDevice.InterfaceNum;
	pStat->VcCfg.PhyDevice.PhyAddr =
							VC[PeVcHandle]->HdlcVcFlds.PhyDevice.PhyAddr;
	pStat->VcCfg.MTU = VC[PeVcHandle]->HdlcVcFlds.MTU;
	pStat->VcCfg.MRU = VC[PeVcHandle]->HdlcVcFlds.MRU;

	cacheInvalidate(DATA_CACHE,
					&msgBody->VcStats.HdlcStats,
					sizeof(msp_pe_vc_stats_hdlc_com));

	pStat->ComFlds.TxFrames = msgBody->VcStats.HdlcStats.TxFrames;
	pStat->ComFlds.RxFrames = msgBody->VcStats.HdlcStats.RxFrames;
	pStat->ComFlds.TxBytes = msgBody->VcStats.HdlcStats.TxBytes;
	pStat->ComFlds.RxBytes = msgBody->VcStats.HdlcStats.RxBytes;
	pStat->ComFlds.RxCrcErrs = msgBody->VcStats.HdlcStats.RxCrcErrs;
	pStat->ComFlds.NoRxBdErrs = msgBody->VcStats.HdlcStats.NoRxBdErrs;

	/* Return Serialization Buffer to Fifo */
	MspFIFOBufInUsePut(PESerialFifoBig, serBuf);

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeGetHdlcVcSemId);

	if (getVcStatsStatus)
		return(getVcStatsStatus);

	return (MSP_SUCCESS);
}


/******************************************************************/
/*																  */
/* MspPeGetHDLCVCStats											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular HDLC VC's			  */
/* statistics.													  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				PeVcHandle- Handle of VC to get statistics from	  */
/*																  */
/*				completeFunc-  pointer to completion function	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if VC found and stats retrieved		  */
/*																  */
/******************************************************************/

U32 MspPeGetHDLCVCStats( U32	callerRefId,
						 U32	PeVcHandle,
						 void	(*completeFunc)( msp_pe_resp		*pPeResp,
												msp_pe_vc_stats_hdlc	*pStat))
{
	msp_buf					*serBuf;
	mspMsg					msg;
	msp_pe_vc_stats_pars	*msgBody;
	U32						returnValue;

	if (!(PeVcHandle))
		PeVcHandle = PeFirstVcHandle;
	else if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	/* Get a big serialization buf to hold status and stats */
	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	msgBody = (msp_pe_vc_stats_pars *)serBuf->dataBuffer;

	msgBody->IsBlockingCall = 0;
	msgBody->PeVcHandle = PeVcHandle;
	msgBody->VcType = PE_VCTYPE_HDLC;
	msgBody->HdlcCompleteFunc = completeFunc;
	msgBody->CallerRefId = callerRefId;

	/* Schedule MspPeGetHdlcVcStatsSer */
	MSP_JOB_ADD(&MspPeGetHdlcVcStatsSer,
				serBuf,
				NULL,
				NULL,
				returnValue);

	return(MSP_SUCCESS);
}


/******************************************************************/
/*																  */
/* MspPeAddCIDBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to add a CID channel for an AAL2 VC	  */
/* that has already been provisioned							  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				pCidSet- pointer to structure containing CID	  */
/*						 properties								  */
/*																  */
/*				pFeResp- pointer to structure containing status	  */
/*						 and CID handle							  */
/*																  */
/******************************************************************/

U32 MspPeAddCIDBlk(msp_pe_cid	*pCidSet,
				   msp_pe_resp	*pFeResp)
{
	msp_buf			*serBuf;
	mspMsg			msg;	/* Has to be named msg for job_add */
	msp_pe_cid		*msgBody;
	U32				returnValue;
	U32				comStatus;

	if (pCidSet->PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);
	else if (pCidSet->ComFlds.CidMode > MSP_PE_CID_MODE_APP)
		return (MSP_PE_ERROR_CID_MODE);

	if (pCidSet->ComFlds.ParMod.VoiceProfileType >
								MSP_PE_CID_VOCPROFILE_COPPERCOM)
		return (MSP_PE_ERROR_CID_VOICE_PROFILE);

	if (!(pFeResp))
		return (MSP_PE_ERROR_RESPONSE_STRUCT);

	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				PeCidHandle			*/
	/*	0x4			<Not Used>				CmdId				*/
	/*	0x8			PeVcHandle				HsHandle			*/
	/*	0xC			VpmPort.source			PedVcHandle			*/
	/*	0x10		VpmPort.port			VpmPortHandle		*/
	/*	0x14													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	serBuf->prependStart = 7;
	msgBody = (msp_pe_cid *)MspGetBufferStartOfData(serBuf);

	msgBody->PeVcHandle = pCidSet->PeVcHandle;	
	msgBody->VpmPort.source = pCidSet->VpmPort.source;
	msgBody->VpmPort.port = pCidSet->VpmPort.port;
	msgBody->ComFlds.CidNum = pCidSet->ComFlds.CidNum;
	msgBody->ComFlds.CidMode = pCidSet->ComFlds.CidMode;
	msgBody->ComFlds.ParMod.CidFlags =
				pCidSet->ComFlds.ParMod.CidFlags;
	msgBody->ComFlds.ParMod.VoiceProfileType =
				pCidSet->ComFlds.ParMod.VoiceProfileType;

	/* Get AddCidBlk Semaphore */
	SEMTAKE(mspPeAddCidSemId, WAIT_FOREVER);

#ifdef PE_ADD_CID_DEBUG
	printf("ACID:  About to schedule AddCid\n");
#endif

	/* Schedule MspPeAddCidSer */
	MSP_JOB_ADD(&MspPeAddCidSer,
				&MspPeAddCidComplete,
				NULL,
				serBuf,
				returnValue);

	/* Wait for AddCidBlk Semaphore */
	SEMTAKE(mspPeAddCidSemId, WAIT_FOREVER);

	FeAddCidComplete = 0;
	comStatus = FeAddCidStatus;
	FeAddCidStatus = 0;

	/* Set the status in the response struct */
	pFeResp->Status = comStatus;
	pFeResp->PePar1 = FeAddCidHandle;
	pFeResp->PePar2 = pCidSet->PeVcHandle;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeAddCidSemId);

#ifdef PE_ADD_CID_DEBUG
	printf("ACID:  Exiting AddCidBlk\n");
#endif

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeAddCID													  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to add a CID channel for an AAL2 VC	  */
/* that has already been provisioned							  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				pCiSet- pointer to structure containing CID		  */
/*						properties								  */
/*																  */
/*				completeFunc-  Function to be called upon CID	  */
/*						 addition completion					  */
/*																  */
/******************************************************************/

U32 MspPeAddCID(U32			callerRefId,
				msp_pe_cid	*pCidSet,
				void		(*completeFunc)(msp_pe_resp *pFeResp))
{
	msp_buf			*serBuf;
	mspMsg			msg;	/* Has to be named msg for job_add */
	msp_pe_cid		*msgBody;
	U32				returnValue;
	U32				CidFlags;

	if (pCidSet->PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	if (pCidSet->ComFlds.CidMode > MSP_PE_CID_MODE_APP)
		return (MSP_PE_ERROR_CID_MODE);

	if (pCidSet->ComFlds.ParMod.VoiceProfileType >
								MSP_PE_CID_VOCPROFILE_COPPERCOM)
		return (MSP_PE_ERROR_CID_VOICE_PROFILE);

	/* Verify CID Flags */
	CidFlags = pCidSet->ComFlds.ParMod.CidFlags;
	if (CidFlags &=				
		~(MSP_PE_CID_FLAGS_IGNORE_HEC_ERRS | 
			MSP_PE_CID_FLAGS_IGNORE_SEQ_ERRS | 
			MSP_PE_CID_FLAGS_LOOPBACK | 
			MSP_PE_CID_FLAGS_SLAVE_MODE | 
			MSP_PE_CID_FLAGS_IDLE_CHAN_SUPPRESSION))
	{
		return (MSP_PE_ERROR_CID_BAD_CIDFLAGS);
	}

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				PeCidHandle			*/
	/*	0x4			<Not Used>				CmdId				*/
	/*	0x8			PeVcHandle				HsHandle			*/
	/*	0xC			VpmPort.source			PedVcHandle			*/
	/*	0x10		VpmPort.port			VpmPortHandle		*/
	/*	0x14													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/************************************************************/
	serBuf->prependStart = 7;
	msgBody = (msp_pe_cid *)MspGetBufferStartOfData(serBuf);

	msgBody->PeVcHandle = pCidSet->PeVcHandle;	
	msgBody->VpmPort.source = pCidSet->VpmPort.source;
	msgBody->VpmPort.port = pCidSet->VpmPort.port;
	msgBody->ComFlds.CidNum = pCidSet->ComFlds.CidNum;
	msgBody->ComFlds.CidMode = pCidSet->ComFlds.CidMode;
	msgBody->ComFlds.ParMod.CidFlags =
				pCidSet->ComFlds.ParMod.CidFlags;
	msgBody->ComFlds.ParMod.VoiceProfileType =
				pCidSet->ComFlds.ParMod.VoiceProfileType;

	/* Schedule MspPeAddCidSer */
	MSP_JOB_ADD(&MspPeAddCidSer,
				completeFunc,
				callerRefId,
				serBuf,
				returnValue);

	return(MSP_SUCCESS);
}


/******************************************************************/
/*																  */
/* MspPeDelCIDBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to delete a CID from the WAN interface  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				PeCidHandle- Handle of the CID to be removed	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if CID found and deleted			  */
/*																  */
/******************************************************************/

U32 MspPeDelCIDBlk(U32 PeCidHandle)
{
	mspMsg			msg;	/* Has to be named msg for job_add */
	U32				returnValue;
	U32				comStatus;

	if (PeCidHandle >= MSP_PE_MAX_CIDS)
		return (MSP_PE_ERROR_CID_BAD_PECIDHANDLE);

	/* Get DelCidBlk Semaphore */
	SEMTAKE(mspPeDelCidSemId, WAIT_FOREVER);

	/* Schedule MspPeDelCidSer */
	MSP_JOB_ADD(&MspPeDelCidSer, PeCidHandle, &MspPeDelCidComplete, NULL, returnValue);

	/* Wait for DelCidBlk Semaphore */
	SEMTAKE(mspPeDelCidSemId, WAIT_FOREVER);

	FeDelCidComplete = 0;
	comStatus = FeDelCidStatus;
	FeDelCidStatus = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeDelCidSemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeDelCID													  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to delete a CID from the WAN interface  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				PeCidHandle- Handle of the CID to be removed	  */
/*																  */
/*				completeFunc-  completion function called after	  */
/*							   CID is deleted					  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if CID found and delete command sent  */
/*																  */
/******************************************************************/

U32 MspPeDelCID( U32		callerRefId,
				 U32		PeCidHandle,
				 void		(*completeFunc)(msp_pe_resp *pFeResp))
{
	mspMsg		msg;	/* Has to be named msg for job_add */
	U32			returnValue;

	if (PeCidHandle >= MSP_PE_MAX_CIDS)
		return (MSP_PE_ERROR_CID_BAD_PECIDHANDLE);

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	/* Schedule MspPeDelCidSer */
	MSP_JOB_ADD(&MspPeDelCidSer,
				PeCidHandle,
				completeFunc,
				callerRefId,
				returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeModCIDBlk												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify a CID on an AAL2 connection.  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				pCid-  Structure holding CID handle and new		  */
/*					   parameters								  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if CID found and modified			  */
/*																  */
/******************************************************************/

U32 MspPeModCIDBlk(msp_pe_mod_cid	*pCid)
{
	msp_buf				*serBuf;
	mspMsg				msg;	/* Has to be named msg for job_add */
	msp_pe_mod_cid		*msgBody;
	U32					returnValue;
	U32					comStatus;
	U32					CidFlags;

	if (PeCidHandle >= MSP_PE_MAX_CIDS)
		return (MSP_PE_ERROR_CID_BAD_PECIDHANDLE);


   if ((pCid->ComFlds.VoiceProfileType != MSP_PE_NO_CHANGE) &&
	   (pCid->ComFlds.VoiceProfileType >
								MSP_PE_CID_VOCPROFILE_COPPERCOM))
		return (MSP_PE_ERROR_CID_VOICE_PROFILE);

	/* Verify CID Flags */
	CidFlags = pCid->ComFlds.CidFlags;
	if (CidFlags != MSP_PE_NO_CHANGE)
	{
		if (CidFlags &=				
			~(MSP_PE_CID_FLAGS_IGNORE_HEC_ERRS | 
				MSP_PE_CID_FLAGS_IGNORE_SEQ_ERRS | 
				MSP_PE_CID_FLAGS_LOOPBACK | 
				MSP_PE_CID_FLAGS_SLAVE_MODE | 
				MSP_PE_CID_FLAGS_IDLE_CHAN_SUPPRESSION))
			return (MSP_PE_ERROR_CID_BAD_CIDFLAGS);
	}


	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				PeCidHandle			*/
	/*	0x4			<Not Used>				CmdId				*/
	/*	0x8			PeCidHandle				HsHandle			*/
	/*	0xc			VpmPort.source			PedCidHandle		*/
	/*	0x10		VpmPort.port			VpmdPortHandle		*/
	/*	0x14													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/* Note: PeCidHandle in Extended Command column is not		*/
	/*		 part of the extended command.	It's kept in the	*/
	/*		 serBuf so we can map it back and completion time.	*/
	/************************************************************/
	msgBody = (msp_pe_mod_cid *)
		(serBuf->dataBuffer +
		(sizeof(msp_ped_mod_cid) + 4) - 
		sizeof(msp_pe_mod_cid));

	msgBody->PeCidHandle = pCid->PeCidHandle;	
	msgBody->VpmPort.source = pCid->VpmPort.source;
	msgBody->VpmPort.port = pCid->VpmPort.port;
	msgBody->ComFlds.CidFlags = pCid->ComFlds.CidFlags;
	msgBody->ComFlds.VoiceProfileType = pCid->ComFlds.VoiceProfileType;

	/* Get ModCidBlk Semaphore */
	SEMTAKE(mspPeModCidSemId, WAIT_FOREVER);

	/* Schedule MspPeModCidSer */
	MSP_JOB_ADD(&MspPeModCidSer,
				&MspPeModCidComplete,
				NULL,
				serBuf,
				returnValue);

	/* Wait for ModCidBlk Semaphore */
	SEMTAKE(mspPeModCidSemId, WAIT_FOREVER);

	FeModCidComplete = 0;
	comStatus = FeModCidStatus;
	FeModCidStatus = 0;

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeModCidSemId);

	if (comStatus)
		return(comStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeModCID													  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to modify a CID on an AAL2 connection.  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				pCid-  Structure holding CID handle and new		  */
/*					   parameters								  */
/*																  */
/*				completeFunc-  Completion function called later	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if CID found and modify command sent  */
/*																  */
/******************************************************************/

U32 MspPeModCID(U32				callerRefId,
				msp_pe_mod_cid	*pCid,
				void			(*completeFunc)(msp_pe_resp *pFeResp))
{
	msp_buf				*serBuf;
	mspMsg				msg;	/* Has to be named msg for job_add */
	msp_pe_mod_cid		*msgBody;
	U32					returnValue;
	U32					CidFlags;

	if (PeCidHandle >= MSP_PE_MAX_CIDS)
		return (MSP_PE_ERROR_CID_BAD_PECIDHANDLE);

	if (pCid->ComFlds.VoiceProfileType >
								MSP_PE_CID_VOCPROFILE_COPPERCOM)
		return (MSP_PE_ERROR_CID_VOICE_PROFILE);

	/* Verify CID Flags */
	CidFlags = pCid->ComFlds.CidFlags;
	if (CidFlags != MSP_PE_NO_CHANGE)
	{
		if (CidFlags &=				
			~(MSP_PE_CID_FLAGS_IGNORE_HEC_ERRS | 
				MSP_PE_CID_FLAGS_IGNORE_SEQ_ERRS | 
				MSP_PE_CID_FLAGS_LOOPBACK | 
				MSP_PE_CID_FLAGS_SLAVE_MODE | 
				MSP_PE_CID_FLAGS_IDLE_CHAN_SUPPRESSION))
			return (MSP_PE_ERROR_CID_BAD_CIDFLAGS);
	}

	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	/************************************************************/
	/* Set the prependStart to 1 byte before data should start. */
	/* The following describes the use of the serialization		*/
	/* buffer (serBuf) to span this function's scheduling until */
	/* the serialized function is called and also through the	*/
	/* extended command call until the response event from the	*/
	/* firmware...												*/
	/*															*/
	/*			Serialized Call:		Extended Command:		*/
	/*	Offset													*/
	/*	0x0			<Not Used>				PeCidHandle			*/
	/*	0x4			<Not Used>				CmdId				*/
	/*	0x8			PeCidHandle				HsHandle			*/
	/*	0xc			VpmPort.source			PedCidHandle		*/
	/*	0x10		VpmPort.port			VpmdPortHandle		*/
	/*	0x14													*/
	/*	 |			ComFlds					ComFlds				*/
	/*	end														*/
	/* Note: PeCidHandle in Extended Command column is not		*/
	/*		 part of the extended command.	It's kept in the	*/
	/*		 serBuf so we can map it back and completion time.	*/
	/************************************************************/
	msgBody = (msp_pe_mod_cid *)
		(serBuf->dataBuffer +
		(sizeof(msp_ped_mod_cid) + 4) - 
		sizeof(msp_pe_mod_cid));

	msgBody->PeCidHandle = pCid->PeCidHandle;	
	msgBody->VpmPort.source = pCid->VpmPort.source;
	msgBody->VpmPort.port = pCid->VpmPort.port;
	msgBody->ComFlds.CidFlags = pCid->ComFlds.CidFlags;
	msgBody->ComFlds.VoiceProfileType = pCid->ComFlds.VoiceProfileType;

	/* Schedule MspPeModCidSer */
	MSP_JOB_ADD(&MspPeModCidSer,
				completeFunc,
				callerRefId,
				serBuf,
				returnValue);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetCIDStatsBlk											  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular cid's statistics	  */
/*																  */
/* This is a blocking function									  */
/*																  */
/* PARAMETERS:													  */
/*				FeCidhandle- Handle of CID to get statistics from */
/*				pStat-	Pointer to structure to place stats		  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if CID found and stats retrieved	  */
/*																  */
/******************************************************************/

U32 MspPeGetCIDStatsBlk(U32					PeCidHandle,
						msp_pe_cid_stats	*pStat)
{
	msp_buf					*serBuf;
	mspMsg					msg;
	msp_pe_cid_stats_pars	*msgBody;
	U32						returnValue;
	U32						getCidStatsStatus;
	U32						peCidIndex;

	if (!(PeCidHandle))
		PeCidHandle = PeFirstCidHandle;
	else if (PeCidHandle >= MSP_PE_MAX_CIDS)
		return (MSP_PE_ERROR_CID_BAD_PECIDHANDLE);

	if (!(pStat))
		return (MSP_PE_ERROR_STATS_STRUCT);

	/* Get a big serialization buf to hold status and stats */
	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	msgBody = (msp_pe_cid_stats_pars *)serBuf->dataBuffer;

	msgBody->IsBlockingCall = 1;
	msgBody->PeCidHandle = PeCidHandle;
	msgBody->CompleteFunc = &MspPeGetCidStatsComplete;

	/* Get GetCidBlk Semaphore */
	SEMTAKE(mspPeGetCidSemId, WAIT_FOREVER);

	/* Schedule MspPeGetCidStatsSer */
	MSP_JOB_ADD(&MspPeGetCidStatsSer,
				serBuf,
				NULL,
				NULL,
				returnValue);

	/* Wait for GetCidBlk Semaphore */
	SEMTAKE(mspPeGetCidSemId, WAIT_FOREVER);

	getCidStatsStatus = msgBody->Status;

	peCidIndex = PeCidHandle & ~(MSP_PE_CID_HANDLE_BIT);

	pStat->CurrPeCidHandle = PeCidHandle;
	pStat->NextPeCidHandle = CID[peCidIndex]->NextPeCidHandle;
	
	
	pStat->Vpi = VC[PeVcHandle]->AtmVcFlds.Vpi;
	pStat->Vci = VC[PeVcHandle]->AtmVcFlds.Vci;
	pStat->CidCfg.CidNum = CID[peCidIndex]->CidFlds.CidNum;
	pStat->CidCfg.CidMode = CID[peCidIndex]->CidFlds.CidMode;
	pStat->CidCfg.ParMod.CidFlags =
				CID[peCidIndex]->CidFlds.ParMod.CidFlags;
	pStat->CidCfg.ParMod.VoiceProfileType =
				CID[peCidIndex]->CidFlds.ParMod.VoiceProfileType;

	cacheInvalidate(DATA_CACHE,
					&msgBody->CidStats,
					sizeof(msp_pe_cid_stats_com));
		
	pStat->ComFlds.PeVcHandle =
				msgBody->CidStats.PeVcHandle;
	pStat->ComFlds.TxPktsFromHost =
				msgBody->CidStats.TxPktsFromHost;
	pStat->ComFlds.RxPktsToHost =
				msgBody->CidStats.RxPktsToHost;
	pStat->ComFlds.TxPktsFromHfp =
				msgBody->CidStats.TxPktsFromHfp;
	pStat->ComFlds.TxBytesFromHfp =
				msgBody->CidStats.TxBytesFromHfp;
	pStat->ComFlds.RxPktsToHfp =
				msgBody->CidStats.RxPktsToHfp;
	pStat->ComFlds.RxBytesToHfp =
				msgBody->CidStats.RxBytesToHfp;
	pStat->ComFlds.RxSeqNumErrs =
				msgBody->CidStats.RxSeqNumErrs;
	pStat->ComFlds.RxParityErrs =
				msgBody->CidStats.RxParityErrs;
	pStat->ComFlds.RxInvAal2HdrErrs =
				msgBody->CidStats.RxInvAal2HdrErrs;

	/* Return Serialization Buffer to Fifo */
	MspFIFOBufInUsePut(PESerialFifoBig, serBuf);

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeGetCidSemId);

	if (getCidStatsStatus)
		return(getCidStatsStatus);

	return (MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeGetCIDStats												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to get a particular cid's statistics	  */
/*																  */
/* PARAMETERS:													  */
/*				callerRefId-  reference id given back in		  */
/*							  completion function				  */
/*																  */
/*				PeCidHandle- Handle of CID to get statistics from */
/*																  */
/*				completeFunc-  Pointer to completion function	  */
/*																  */
/* RETURNS:														  */
/*				MSP_SUCCESS if CID found and GetStats command	  */
/*				called											  */
/*																  */
/******************************************************************/

U32 MspPeGetCIDStats( U32		callerRefId,
					  U32		PeCidHandle,
					  void		(*completeFunc)(msp_pe_resp		*pPeResp,
												msp_pe_cid_stats	*pStat))
{
	msp_buf					*serBuf;
	mspMsg					msg;
	msp_pe_cid_stats_pars	*msgBody;
	U32						returnValue;

	if (!PeCidHandle)
		PeCidHandle = PeFirstCidHandle;
	else if (PeCidHandle >= MSP_PE_MAX_CIDS)
		return (MSP_PE_ERROR_CID_BAD_PECIDHANDLE);


	if (!(completeFunc))
		return (MSP_PE_ERROR_COMPLETE_FUNC);

	/* Get a big serialization buf to hold status and stats */
	serBuf = MspFIFOBufInUseGet(PESerialFifoBig);
	if (serBuf == NULL) {
		return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
	}

	msgBody = (msp_pe_cid_stats_pars *)serBuf->dataBuffer;

	msgBody->IsBlockingCall = 0;
	msgBody->PeCidHandle = PeCidHandle;
	msgBody->CompleteFunc = completeFunc;
	msgBody->CallerRefId = callerRefId;

	/* Schedule MspPeGetCidStatsSer */
	MSP_JOB_ADD(&MspPeGetCidStatsSer,
				serBuf,
				NULL,
				NULL,
				returnValue);

	return(MSP_SUCCESS);
}

/****************************************************************************/
/*																			*/
/*	function:	MspSetPeClockingOptionsBlk									*/
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*	Tony Raetz:11-15-2001	: Initial version of function					*/
/*																			*/
/****************************************************************************/
/*	Description:															*/
/*	The function Vpm_Reinitialize_Memory will be passed a pointer of the	*/
/*	type stVpmHALData.	The function will then set all of the data fields	*/
/*	for this structure type to default starting values.						*/
/*																			*/
/*	Input:																	*/
/*		*localVpmHALData:  Pointer to a data structure of the type			*/
/*			stVpmHALData.													*/
/*																			*/
/*	Output:																	*/
/*		*localVpmHALData:  Initialized data structure.						*/
/*																			*/
/****************************************************************************/
U32 MspSetPeClockingOptionsBlk(U32 clkRate, U32 mode, U32 txfsMode, U32 selectedPePhy)
{

	return 1;  /*???temp until AR fills this out. */
}

/******************************************************************/
/*																  */
/* MspPeTransmit												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to send a packet out over the WAN over  */
/* the specified VC.  If the VC's TxCompleteFunc pointer is set,  */
/* the serialized interface is used.  In the case that the		  */
/* TxCompleteFunc pointer is NULL, the unserialized interface is  */
/* used.														  */
/*																  */
/* PARAMETERS:													  */
/*				PeVcHandle-	 Identifies VC Tx ring to put packet  */
/*																  */
/*				pTrBuf-	 Pointer to MSP Buff to send packet		  */
/*																  */
/*				PktType-  Packet type							  */
/*																  */
/*				TxPriority-	 Packet priority (high, med, low)	  */
/*																  */
/******************************************************************/

U32 MspPeTransmit(U32		PeVcHandle,
				  U32		UserTxId,
				  msp_buf	*pMSPBuf,
				  U32		TxPriority)
{
	msp_buf					*serBuf;
	mspMsg					msg; /* Has to be named msg for job_add */
	msp_pe_tx_info			*msgBody;
	U32						returnValue;

	if (PeVcHandle >= MSP_PE_MAX_VCS)
		return (MSP_PE_ERROR_VC_BAD_PEVCHANDLE);

	
	if (VC[PeVcHandle]->TxCompleteFunc == 0)
	{
		return mspPeTransmitUnSer (PeVcHandle, UserTxId, pMSPBuf, TxPriority);
	}
	else {
		/* Serialized Interface */
		serBuf = MspFIFOBufInUseGet(PESerialFifoSmall);
		if (serBuf == NULL) {
			return (MSP_PE_ERROR_NO_SER_BUF_AVAIL);
		}

		msgBody = (msp_pe_tx_info *)serBuf->dataBuffer;

		msgBody->PeVcHandle = PeVcHandle;
		msgBody->UserTxId = UserTxId;
		msgBody->pMSPBuf = pMSPBuf;
		msgBody->TxPriority = TxPriority;

		/* Schedule MspPeTransmitSer */
		MSP_JOB_ADD(&MspPeTransmitSer,
					serBuf,
					NULL,
					NULL,
					returnValue);

#ifdef PE_TX_DEBUG
		printf("TX:	 Transmit called and scheduled\n");
#endif	 
		return(MSP_SUCCESS);
	}
}

/******************************************************************/
/*																  */
/* MspPeNOKIAEOCTx												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This routine is called to send an EOC frame out over the WAN	  */
/*																  */
/* PARAMETERS:													  */
/*				pEOCFrame-	pointer to frame to be send			  */
/*																  */
/*				portNum-  port number to send frame out of		  */
/*																  */
/*				Size-  Size of frame to be send					  */
/*																  */
/******************************************************************/

U32 MspPeNOKIAEOCTx( U32		InterfaceNum,
					 U8			*pEOCFrame,
					 U32		Size)
{
	mspMsg			msg;	/* Has to be named msg for job_add */
	U32				returnValue;

	/* Schedule MspPeNokiaEocSer Routine */
	MspPeNokiaEocTxSer (InterfaceNum, pEOCFrame, Size);

	return(MSP_SUCCESS);
}

/******************************************************************/
/*																  */
/* MspPeReceivePoll												  */
/*																  */
/*																  */
/* DESCRIPTION:													  */
/* This is the PE's receive polling routine.  The user calls this */
/* routine intermittently to receive packets when in polling mode */
/*																  */
/* PARAMETERS:	PeVcHandle-	 Handle of VC						  */
/*																  */
/******************************************************************/
U32 MspPeReceivePoll(U32 PeVcHandle)
{
	mspMsg			msg;	/* Has to be named msg for job_add */
	U32				returnValue;

	/* Add the Receive Poll Routine to the Ser Queue */
	MSP_JOB_ADD(&MspPeReceivePollSer,
				PeVcHandle,
				NULL,
				NULL,
				returnValue);

	return (MSP_SUCCESS);
}


U32 MspPeDbgReadMem(U32		peDramWAddr,
					U32		bufAddr,
					U32		bufWSize)
{
	mspMsg			msg;	/* Has to be named msg for job_add */
	U32				returnValue;

	/* Get DbgReadMem Semaphore */
	SEMTAKE(mspPeDbgReadMemSemId, WAIT_FOREVER);

	/* Schedule MspPeDbgReadMemSer Routine */
	MSP_JOB_ADD(&MspPeDbgReadMemSer,
				peDramWAddr,
				bufAddr,
				bufWSize,
				returnValue);

	/* Wait for DbgReadMem Semaphore */
	SEMTAKE(mspPeDbgReadMemSemId, WAIT_FOREVER);

	/* Give back the semaphore for next call */
	SEMGIVE(mspPeDbgReadMemSemId);

	return (MSP_SUCCESS);

}



/*	The following functions print the PE/VX/CID stats */

void MspPeStatsShow()
{
	msp_pe_vc_stats_atm	  VcStat;
	U32		Status;
	U32		VcIdx = 0;
	U32		PeVcHandle = VcIdx;

	while (PeVcHandle)
	{		
		Status = MspPeGetAtmVCStatsBlk(PeVcHandle, &VcStat);
		if (Status != MSP_SUCCESS)
		{
			printf("Error %d returned from MspPeGetAtmVCStatsBlk\n", Status);
			return;
		}

		/* It would be good to know, VcType, Vpi, Vci..anything else? */

		printf("---	 VC Statistics Display ---\n\n");
		printf("  VPI									 %d\n",
			VcStat.VcCfg.Vpi);
		printf("  VCI									 %d\n",
			VcStat.VcCfg.Vci);

		printf("  WAN Interface Num						 %d\n",
			 VcStat.VcCfg.PhyDevice.InterfaceNum);
		printf("  PHY address(Utopia Only)				 %d\n",
			VcStat.VcCfg.PhyDevice.PhyAddr);

		switch (VcStat.VcCfg.VcType)
		{
		case MSP_PE_ATM_VCTYPE_AAL0:
			{
				printf("  VcType								 AAL0\n");
				break;
			}
		case MSP_PE_ATM_VCTYPE_AAL0GBL:
			{
				printf("  VcType								 Global AAL0\n");
				break;
			}
		case MSP_PE_ATM_VCTYPE_AAL2:
			{
				printf("  VcType								 AAL2\n");
				break;
			}
		case MSP_PE_ATM_VCTYPE_AAL5:
			{
				printf("  VcType								 AAL5\n");
				break;
			}
		case MSP_PE_ATM_VCTYPE_OAM:
			{
				printf("  VcType								 OAM\n");
				break;
			}
		default:
			{
				printf("  VcType								 %d (INVALID)\n",
					VcStat.VcCfg.VcType);
			break;
			}
		} /* switch */

		if (VcStat.VcCfg.VcType == MSP_PE_ATM_VCTYPE_AAL2)
		{
			/* Voice Protocol field only used if VC type is AAL2 */
		switch (VcStat.VcCfg.ParMod.VoiceProtocolType)
		{
			case MSP_PE_VOICE_PROTOCOL_BLES_CAS:
			{
				printf("  Voice Protocol Type					 BLES-CAS\n");
				break;
			}
		case MSP_PE_VOICE_PROTOCOL_BLES_CCS:
			{
				printf("  Voice Protocol Type					 BLES-CCS\n");
				break;
			}
		case MSP_PE_VOICE_PROTOCOL_JETSTREAM:
			{
				printf("  Voice Protocol Type					 Jetstream\n");
				break;
			}
		case MSP_PE_VOICE_PROTOCOL_COPPERCOM:
			{
				printf("  Voice Protocol Type					 CopperCom\n");
				break;
			}
		default:
			{
				printf("  Voice Protocol Type					 %d (INVALID)\n",
					VcStat.VcCfg.ParMod.VoiceProtocolType);
			break;
			}
		} /* switch */
		}

		printf("  VC Flags								 %d\n",
			VcStat.VcCfg.ParMod.VcFlags);

		if (VcStat.VcCfg.ParMod.VcFlags & MSP_PE_VC_FLAGS_LOOPBACK)
		{
			printf("										 Loopback Rx Cells\n");
		}
		if (VcStat.VcCfg.ParMod.VcFlags & MSP_PE_VC_FLAGS_DISCARDRX)
		{
			printf("										 Discard Rx Cells\n");
		}
		if (VcStat.VcCfg.ParMod.VcFlags & MSP_PE_VC_FLAGS_AAL2_IGNORE_PARITY)
		{
			printf("										 Ignore AAL2 header HEC Errors\n");
		}


		printf("\n");

		switch (VcStat.VcCfg.ParMod.SrvType)
		{
		case MSP_PE_ATM_SRVTYPE_IMMEDIATE:
			{
				printf("  Service Type							 Voice\n");
				break;
			}
		case MSP_PE_ATM_SRVTYPE_VBRRT:
			{
				printf("  Service Type							 Real Time Variable Bit Rate\n");
				break;
			}
		case MSP_PE_ATM_SRVTYPE_VBRNRT:
			{
				printf("  Service Type							 Non-Real Time Variable Bit Rate\n");
				break;
			}
		case MSP_PE_ATM_SRVTYPE_UBR1:
			{
				printf("  Service Type							 Unspecified Bit Rate (Priority 1)\n");
				break;
			}
		case MSP_PE_ATM_SRVTYPE_UBR2:
			{
				printf("  Service Type							 Unspecified Bit Rate (Priority 2)\n");
				break;
			}
		case MSP_PE_ATM_SRVTYPE_UBR3:
			{
				printf("  Service Type							 Unspecified Bit Rate (Priority 3)\n");
				break;
			}
		case MSP_PE_ATM_SRVTYPE_GFR:
			{
				printf("  Service Type							 Guaranteed Frame Rate\n");
				break;
			}
		default:
			{
				printf("  Service Type							 %d (INVALID)\n",
					VcStat.VcCfg.ParMod.SrvType);
			break;
			}
		} /* switch */
		printf("  Peak Cell Rate						 %d\n",
			VcStat.VcCfg.ParMod.PeakCellRate);
		printf("  Sustained Cell Rate					 %d\n",
			VcStat.VcCfg.ParMod.SustainedCellRate);
		printf("  Maximum Burst Size					 %d\n",
			VcStat.VcCfg.ParMod.MaxBurstSize);
		printf("  Minimum Cell Rate						 %d\n",
			VcStat.VcCfg.ParMod.MinCellRate);


		printf("\n");
		if (VcStat.VcCfg.VcType == MSP_PE_ATM_VCTYPE_AAL5)
		{
			printf("  Maximum Tx Unit						 %d\n",
				VcStat.VcCfg.ParMod.MTU);
			printf("  Maximum Rx Unit						 %d\n",
				VcStat.VcCfg.ParMod.MRU);
			printf("\n");
		}

		printf("  TxCells								 %d\n",
			VcStat.ComFlds.TxCells);
		printf("  RxCells								 %d\n",
			VcStat.ComFlds.RxCells);

		printf("\n");

		if ((VcStat.VcCfg.VcType == MSP_PE_ATM_VCTYPE_OAM) ||
		   (VcStat.VcCfg.VcType == MSP_PE_ATM_VCTYPE_AAL0GBL))
		{
			printf("  TxOamCells							 %d\n",
				VcStat.ComFlds.TxOamCells);
			printf("  RxOamCells							 %d\n",
				VcStat.ComFlds.RxOamCells);
			printf("\n");
		}

		if (VcStat.VcCfg.VcType == MSP_PE_ATM_VCTYPE_AAL5)
		{
			printf("  TxAal5Pdus							 %d\n",
				VcStat.ComFlds.TxAal5Pdus);
			printf("  RxAal5Pdus							 %d\n",
				VcStat.ComFlds.RxAal5Pdus);
			printf("\n");
		}


		printf("  RxCellsDropped						 %d\n",
			VcStat.ComFlds.RxCellsDropped);
		printf("  RxCrcCells							 %d\n",
			VcStat.ComFlds.RxCrcErrs);
		printf("  RxNoRxBdErrs							 %d\n",
			VcStat.ComFlds.RxNoRxBdErrs);

		printf("\n");

		if (VcStat.VcCfg.VcType == MSP_PE_ATM_VCTYPE_AAL5)
		{
		
			printf("  RxAal5PdusDropped						 %d\n",
				VcStat.ComFlds.RxAal5PdusDropped);
			printf("  RxAal5InvCpiErrs						 %d\n",
				VcStat.ComFlds.RxAal5InvCpiErrs);
			printf("  RxAal5AbortedPdus						 %d\n",
				VcStat.ComFlds.RxAal5AbortedPdus);
			printf("  RxAal5InvLenErrs						 %d\n",
				VcStat.ComFlds.RxAal5InvLenErrs);
			printf("\n");
		}


		if (VcStat.VcCfg.VcType == MSP_PE_ATM_VCTYPE_AAL2)
		{
			printf("  RxAal2SeqNumErrs						 %d\n",
				VcStat.ComFlds.RxAal2SeqNumErrs);
			printf("  RxAal2UnknownCids						 %d\n",
				VcStat.ComFlds.RxAal2UnknownCids);
			printf("\n");
		}

		printf("\n");

		PeVcHandle = VcStat.NextPeVcHandle;
		VcIdx++;
	}
} /* MspPeTestGetVcStats() */

void MspPeCidStatsShow()
{
	msp_pe_cid_stats   CidStat;
	U32		Status;
	U32		CidIdx = 0;
	U32		PeCidHandle = (CidIdx | MSP_PE_CID_HANDLE_BIT);

	while (PeCidHandle)
	{		
		Status = MspPeGetCIDStatsBlk(PeCidHandle, &CidStat);
		if (Status != MSP_SUCCESS)
		{
			printf("Error %d returned from MspPeGetCIDStatsBlk()\n", Status);
			return;
		}

		printf("---	 CID Statistics Display ---\n\n");
		printf("  CidNum								 %d\n",
				CidStat.CidCfg.CidNum);

		printf("  Associated VC VPI						 %d\n",
				CidStat.Vpi);

		printf("  Associated VC VCI						 %d\n",
				CidStat.Vci);

		switch (CidStat.CidCfg.ParMod.VoiceProfileType)
		{
		case MSP_PE_CID_VOCPROFILE_VMOA_7:
			{
				printf("  Voice Profile Type					 BLES-7\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_VMOA_8:
			{
				printf("  Voice Profile Type					 BLES-8\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_VMOA_9:
			{
				printf("  Voice Profile Type					 BLES-9\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_VMOA_10:
			{
				printf("  Voice Profile Type					 BLES-10\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_VMOA_11:
			{
				printf("  Voice Profile Type					 BLES-11\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_VMOA_12:
			{
				printf("  Voice Profile Type					 BLES-12\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_ITU3662_1:
			{
				printf("  Voice Profile Type					 ITU366.2-1\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_ITU3662_2:
			{
				printf("  Voice Profile Type					 ITU366.2-2\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_ITU3662_3:
			{
				printf("  Voice Profile Type					 ITU366.2-3\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_ITU3662_4:
			{
				printf("  Voice Profile Type					 ITU366.2-4\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_JETSTREAM:
			{
				printf("  Voice Profile Type					 JetStream\n");
				break;
			}
		case MSP_PE_CID_VOCPROFILE_COPPERCOM:
			{
				printf("  Voice Profile Type					 CopperCom\n");
				break;
			}
		default:
			{
				printf("  Voice Profile Type					 %d (INVALID)\n",
					CidStat.CidCfg.ParMod.VoiceProfileType);
				break;
			}
		} /* switch */

		switch (CidStat.CidCfg.CidMode)
		{
		case MSP_PE_CID_MODE_HFP:
			{
			printf("  CidMode								 HFP\n");
			break;
			}
		case MSP_PE_CID_MODE_APP:
			{
			printf("  CidMode								 APP\n");
			break;
			}
		default:
			printf("  CidMode								 %d (INVALID)\n",
					CidStat.CidCfg.CidMode);
			break;
		} /*switch*/

		printf("  CidFlags								 %d\n",
				CidStat.CidCfg.ParMod.CidFlags);

		if (CidStat.CidCfg.ParMod.CidFlags & MSP_PE_CID_FLAGS_IGNORE_HEC_ERRS)
		{
			printf("										 Ignore AAL2 Header HEC Errors\n");
		}
		if (CidStat.CidCfg.ParMod.CidFlags & MSP_PE_CID_FLAGS_IGNORE_SEQ_ERRS)
		{
			printf("										 Ignore AAL2 Sequence Number Errors\n");
		}
		if (CidStat.CidCfg.ParMod.CidFlags & MSP_PE_CID_FLAGS_LOOPBACK)
		{
			printf("										 Loopback Rx Cells\n");
		}
		if (CidStat.CidCfg.ParMod.CidFlags & MSP_PE_CID_FLAGS_SLAVE_MODE)
		{
			printf("										 Slave Mode\n");
		}
		if (CidStat.CidCfg.ParMod.CidFlags & MSP_PE_CID_FLAGS_IDLE_CHAN_SUPPRESSION)
		{
			printf("										 Enable Idle Channel Suppression\n");
		}

		printf("  PeVcHandle							 0x%x\n",
				CidStat.ComFlds.PeVcHandle);

		printf("\n");
		printf("  TxPktsFromHost						 %d\n",
				CidStat.ComFlds.TxPktsFromHost);
		printf("  RxPktsToHost							 %d\n",
				CidStat.ComFlds.RxPktsToHost);
		printf("  TxPktsFromHfp							 %d\n",
				CidStat.ComFlds.TxPktsFromHfp);
		printf("  TxBytesFromHfp						 %d\n",
				CidStat.ComFlds.TxBytesFromHfp);
		printf("  RxPktsToHfp							 %d\n",
				CidStat.ComFlds.RxPktsToHfp);
		printf("  RxBytesToHfp							 %d\n",
				CidStat.ComFlds.RxBytesToHfp);
		printf("\n");
		printf("  RxSeqNumErrs							 %d\n",
				CidStat.ComFlds.RxSeqNumErrs);
		printf("  RxParityErrs							 %d\n",
				CidStat.ComFlds.RxParityErrs);
		printf("  RxInvAal2HdrErrs						 %d\n",
				CidStat.ComFlds.RxInvAal2HdrErrs);

		printf("\n\n");

		PeCidHandle = CidStat.NextPeCidHandle;
		CidIdx++;
	}
}


void MspPePhyStatsShow()
{
	msp_pe_phy_stats   PhyStats;
	msp_pe_phy_device	PhyDev;
	U32					Status;

	msp_pe_serial_atm_if_stats_com* pSAtmStats;
	msp_pe_nokia_if_stats_com*		pNokiaStats;
	msp_pe_utopia_if_stats_com* pUtopiaStats;

	U32		PhyIdx = 0;

	while (PhyIdx < 2)
	{		
		PhyDev.InterfaceNum = PhyIdx;
		PhyDev.PhyAddr = 0;

		Status = MspPeGetPhyStatsBlk(PhyDev, &PhyStats);
		if (Status != MSP_SUCCESS)
		{
			if (Status == MSP_PE_ERROR_SEMAPHORE_NOT_AVAILABLE)
				printf("Semaphore timed out.\n");
			else
				printf("Error %d returned from MspPeGetPhyStatsBlk()\n", Status);
			return;
		}

		printf("---	 PHY Statistics Display ---\n\n");

		switch (PhyStats.ComFlds.PhyType)
		{
		case MSP_PE_PHYTYPE_NOT_CONFIGURED:
			printf("  Phy #%d not configured\n",
				PhyDev.InterfaceNum);
			break;

		case MSP_PE_PHYTYPE_SERIAL_ATM:
			printf("  Phytype								 Serial ATM\n");
			pSAtmStats = (msp_pe_serial_atm_if_stats_com*)(&PhyStats.ComFlds.PhyStats.SerialAtmIfStats);

			printf("  Configuration Flags					 0x%08x\n",
					pSAtmStats->ConfigFlags);

			if (pSAtmStats->ConfigFlags & MSP_PE_CFGFLAG_SYNC_ACQUIRED)
			{
				printf("	Phy State							 Sync Acquired\n");
			}
			else
			{
				printf("	Phy State							 Sync Lost\n");
			}

			if (pSAtmStats->ConfigFlags & MSP_PE_SATM_CFGFLAG_PAYLOAD_SCRAMBLE_ENABLE)
			{
				printf("	Payload Scrambling					 Enabled\n");
			}
			else
			{
				printf("	Payload Scrambling					 Disabled\n");
			}

			if (pSAtmStats->ConfigFlags & MSP_PE_SATM_CFGFLAG_MASTER_CLOCK)
			{
				printf("	Clock source						 Master\n");
			}
			else
			{
				printf("	Clock source						 Slave\n");
			}

			if (pSAtmStats->ConfigFlags & MSP_PE_SATM_CFGFLAG_TDM_FRAME_SYNC_ENABLE)
			{
				printf("	TDM Frame Sync						 Enabled\n");
			}
			else
			{
				printf("	TDM Frame Sync						 Disabled\n");
			}

			if (pSAtmStats->ConfigFlags & MSP_PE_SATM_CFGFLAG_TDM_EXTERNAL_TX_FRAME_SYNC)
			{
				printf("	TDM External Frame Sync				 Enabled\n");
			}
			else
			{
				printf("	TDM External Frame Sync				 Disabled\n");
			}
			if (pSAtmStats->ConfigFlags & MSP_PE_CFGFLAG_PHY_IDLE_CELL_ATMF)
			{
				printf("	Idle cell generation				 ATM Forum\n");
			}
			else
				if (pSAtmStats->ConfigFlags & MSP_PE_CFGFLAG_PHY_IDLE_CELL_ITU)
				{
					printf("	Idle cell generation				 ITU\n");

				}
				else
				{
					printf("	Idle cell generation				 Disabled\n");
				}

			if (pSAtmStats->ConfigFlags & MSP_PE_CFGFLAG_COSET_ENABLE)
			{
				printf("	COSET generation					 Enabled\n");
				printf("	COSET value							 %d\n",
					pSAtmStats->CosetValue);
			}
			else
			{
				printf("	COSET generation					 Disabled\n");
			}

			printf("\n");

			if (pSAtmStats->ConfigFlags & MSP_PE_CFGFLAG_GLOBAL_VC_ENABLED)
			{
				printf("	Global VC							 Added\n");
			}
			else
			{
				printf("	Global VC							 Not Added\n");
			}

			if (pSAtmStats->ConfigFlags & MSP_PE_CFGFLAG_OAM_VC_ENABLED)
			{
				printf("	OAM VC								 Added\n");
			}
			else
			{
				printf("	OAM VC								 Not Added\n");
			}
			if (pSAtmStats->ConfigFlags & MSP_PE_CFGFLAG_AUTO_F5OAM_LOOPBACK_DISABLED)
			{
				printf("	Auto Reply to F5 OAM Loopback Cells	 Disabled\n");
			}
			else
			{
				printf("	Auto Reply to F5 OAM Loopback Cells	 Enabled\n");
			}
			if (pSAtmStats->ConfigFlags & MSP_PE_CFGFLAG_AUTO_F4OAM_LOOPBACK_DISABLED)
			{
				printf("	Auto Reply to F4 OAM Loopback Cells	 Disabled\n");
			}
			else
			{
				printf("	Auto Reply to F4 OAM Loopback Cells	 Enabled\n");
			}
			printf("\n");
			printf("  TDM Slots Per Frame					 %d\n",
					pSAtmStats->TdmSlotsPerFrame);
			printf("\n");
			printf("  TX Line Speed							 %d\n",
					pSAtmStats->LineSpeed.TxLineSpeed);
			printf("  RX Line Speed							 %d\n",
					pSAtmStats->LineSpeed.RxLineSpeed);
			printf("\n");

			printf("  TX Cells								 %d\n",
					pSAtmStats->TxCells);
			printf("  RX Cells								 %d\n",
					pSAtmStats->RxCells);
			printf("  TX Cells Dropped						 %d\n",
					pSAtmStats->TxCellsDropped);
			printf("  RX Cells Dropped						 %d\n",
					pSAtmStats->RxCellsDropped);
			printf("\n");

			printf("  TX Idle Cell Count					 %d\n",
					pSAtmStats->TxIdleCellCnt);
			printf("  RX Idle Cell Count					 %d\n",
					pSAtmStats->RxIdleCellCnt);
			printf("  RX HEC errors							 %d\n",
					pSAtmStats->RxHecErrCells);
			printf("\n");

			printf("  Sync Acquired Count					 %d\n",
					pSAtmStats->SyncAcquiredCnt);
			printf("  Sync Lost Count						 %d\n",
					pSAtmStats->SyncLostCnt);
			printf("\n");

			printf("  RX Oam F4 Cells						 %d\n",
					pSAtmStats->RxOamF4Cells);
			printf("  RX Oam F5 Cells						 %d\n",
					pSAtmStats->RxOamF5Cells);
			printf("  RX Oam F4 Loopback Cells				 %d\n",
					pSAtmStats->RxOamF4LoopbackCells);
			printf("  RX Oam F5 Loopback Cells				 %d\n",
					pSAtmStats->RxOamF5LoopbackCells);
			printf("\n");


			break;

		case MSP_PE_PHYTYPE_NOKIA:
			printf("  Phytype								 Nokia\n");
			pNokiaStats = (msp_pe_nokia_if_stats_com*)(&PhyStats.ComFlds.PhyStats.NokiaIfStats);

			printf("  Configuration Flags					 0x%08x\n",
					pNokiaStats->ConfigFlags);

			if (pNokiaStats->ConfigFlags & MSP_PE_CFGFLAG_SYNC_ACQUIRED)
			{
				printf("	Phy State							 Sync Acquired\n");
			}
			else
			{
				printf("	Phy State							 Sync Lost\n");
			}

			if (pNokiaStats->ConfigFlags & MSP_PE_SATM_CFGFLAG_PAYLOAD_SCRAMBLE_ENABLE)
			{
				printf("	Payload Scrambling					 Enabled\n");
			}
			else
			{
				printf("	Payload Scrambling					 Disabled\n");
			}

			if (pNokiaStats->ConfigFlags & MSP_PE_SATM_CFGFLAG_MASTER_CLOCK)
			{
				printf("	Clock source						 Master\n");
			}
			else
			{
				printf("	Clock source						 Slave\n");
			}

			if (pNokiaStats->ConfigFlags & MSP_PE_CFGFLAG_PHY_IDLE_CELL_ATMF)
			{
				printf("	Idle cell generation				 ATM Forum\n");
			}
			else
				if (pNokiaStats->ConfigFlags & MSP_PE_CFGFLAG_PHY_IDLE_CELL_ITU)
				{
					printf("	Idle cell generation				 ITU\n");

				}
				else
				{
					printf("	Idle cell generation				 Disabled\n");
				}

			if (pNokiaStats->ConfigFlags & MSP_PE_CFGFLAG_COSET_ENABLE)
			{
				printf("	COSET generation					 Enabled\n");
				printf("	COSET value							 %d\n",
					pNokiaStats->CosetValue);
			}
			else
			{
				printf("	COSET generation					 Disabled\n");
			}

			printf("\n");

			if (pNokiaStats->ConfigFlags & MSP_PE_CFGFLAG_GLOBAL_VC_ENABLED)
			{
				printf("	Global VC							 Added\n");
			}
			else
			{
				printf("	Global VC							 Not Added\n");
			}

			if (pNokiaStats->ConfigFlags & MSP_PE_CFGFLAG_OAM_VC_ENABLED)
			{
				printf("	OAM VC								 Added\n");
			}
			else
			{
				printf("	OAM VC								 Not Added\n");
			}
			if (pNokiaStats->ConfigFlags & MSP_PE_CFGFLAG_AUTO_F5OAM_LOOPBACK_DISABLED)
			{
				printf("	Auto Reply to F5 OAM Loopback Cells	 Disabled\n");
			}
			else
			{
				printf("	Auto Reply to F5 OAM Loopback Cells	 Enabled\n");
			}
			if (pNokiaStats->ConfigFlags & MSP_PE_CFGFLAG_AUTO_F4OAM_LOOPBACK_DISABLED)
			{
				printf("	Auto Reply to F4 OAM Loopback Cells	 Disabled\n");
			}
			else
			{
				printf("	Auto Reply to F4 OAM Loopback Cells	 Enabled\n");
			}
			printf("\n");

			printf("  TX Line Speed							 %d\n",
					pNokiaStats->LineSpeed.TxLineSpeed);
			printf("  RX Line Speed							 %d\n",
					pNokiaStats->LineSpeed.RxLineSpeed);
			printf("\n");

			printf("  TX Cells								 %d\n",
					pNokiaStats->TxCells);
			printf("  RX Cells								 %d\n",
					pNokiaStats->RxCells);
			printf("  TX Cells Dropped						 %d\n",
					pNokiaStats->TxCellsDropped);
			printf("  RX Cells Dropped						 %d\n",
					pNokiaStats->RxCellsDropped);
			printf("\n");

			printf("  TX Idle Cell Count					 %d\n",
					pNokiaStats->TxIdleCellCnt);
			printf("  RX Idle Cell Count					 %d\n",
					pNokiaStats->RxIdleCellCnt);
			printf("  RX HEC errors							 %d\n",
					pNokiaStats->RxHecErrCells);
			printf("\n");

			printf("  Sync Acquired Count					 %d\n",
					pNokiaStats->SyncAcquiredCnt);
			printf("  Sync Lost Count						 %d\n",
					pNokiaStats->SyncLostCnt);
			printf("\n");

			printf("  RX Oam F4 Cells						 %d\n",
					pNokiaStats->RxOamF4Cells);
			printf("  RX Oam F5 Cells						 %d\n",
					pNokiaStats->RxOamF5Cells);
			printf("  RX Oam F4 Loopback Cells				 %d\n",
					pNokiaStats->RxOamF4LoopbackCells);
			printf("  RX Oam F5 Loopback Cells				 %d\n",
					pNokiaStats->RxOamF5LoopbackCells);
			printf("\n");

			printf("  RX Crc Errors							 %d\n",
					pNokiaStats->RxCrcErrs);
			printf("  RX RAI(remote alarm indicator) Count	 %d\n",
					pNokiaStats->RxRaiCnt);
			printf("  RX FEBE Count							 %d\n",
					pNokiaStats->RxFebeCnt);
			printf("\n");

			printf("  Maximum EOC Frame byte size			 %d\n",
					pNokiaStats->MaxEocFrameBSize);
			printf("  TX EOC Frames							 %d\n",
					pNokiaStats->TxEocFrames);
			printf("  RX EOC Frames							 %d\n",
					pNokiaStats->RxEocFrames);
			printf("  TX EOC Bytes							 %d\n",
					pNokiaStats->TxEocBytes);
			printf("  RX EOC Bytes							 %d\n",
					pNokiaStats->RxEocBytes);
			printf("\n");

			break;

		case MSP_PE_PHYTYPE_UTOPIA1:
			printf("  Phytype								 Utopia1(SPHY)\n");
			pUtopiaStats = (msp_pe_utopia_if_stats_com*)(&PhyStats.ComFlds.PhyStats.UtopiaIfStats);

			printf("  Configuration Flags					 0x%08x\n",
					pUtopiaStats->ConfigFlags);

			if (pUtopiaStats->ConfigFlags & MSP_PE_UTOPIA_CFGFLAG_PARITY_ODD)
			{
				printf("	Parity								 Odd\n");
			}
			else
				if (pUtopiaStats->ConfigFlags & MSP_PE_UTOPIA_CFGFLAG_PARITY_EVEN)
				{
					printf("	Parity								 Even\n");
				}
				else
				{
					printf("	Parity								 NONE\n");
				}

			if (pUtopiaStats->ConfigFlags & MSP_PE_CFGFLAG_PHY_IDLE_CELL_ATMF)
			{
				printf("	Idle cell generation				 ATM Forum\n");
			}
			else
				if (pUtopiaStats->ConfigFlags & MSP_PE_CFGFLAG_PHY_IDLE_CELL_ITU)
				{
					printf("	Idle cell generation				 ITU\n");

				}
				else
				{
					printf("	Idle cell generation				 Disabled\n");
				}
			if (pUtopiaStats->ConfigFlags & MSP_PE_CFGFLAG_AUTO_F5OAM_LOOPBACK_DISABLED)
			{
				printf("	Auto Reply to F5 OAM Loopback Cells	 Disabled\n");
			}
			else
			{
				printf("	Auto Reply to F5 OAM Loopback Cells	 Enabled\n");
			}
			if (pUtopiaStats->ConfigFlags & MSP_PE_CFGFLAG_AUTO_F4OAM_LOOPBACK_DISABLED)
			{
				printf("	Auto Reply to F4 OAM Loopback Cells	 Disabled\n");
			}
			else
			{
				printf("	Auto Reply to F4 OAM Loopback Cells	 Enabled\n");
			}
			printf("\n");

			printf("  TX Line Speed							 %d\n",
					pUtopiaStats->LineSpeed.TxLineSpeed);
			printf("  RX Line Speed							 %d\n",
					pUtopiaStats->LineSpeed.RxLineSpeed);
			printf("\n");

			printf("  TX Cells								 %d\n",
					pUtopiaStats->TxCells);
			printf("  RX Cells								 %d\n",
					pUtopiaStats->RxCells);
			printf("  TX Cells Dropped						 %d\n",
					pUtopiaStats->TxCellsDropped);
			printf("  RX Cells Dropped						 %d\n",
					pUtopiaStats->RxCellsDropped);
			printf("\n");

			printf("  RX Oam F4 Cells						 %d\n",
					pUtopiaStats->RxOamF4Cells);
			printf("  RX Oam F5 Cells						 %d\n",
					pUtopiaStats->RxOamF5Cells);
			printf("  RX Oam F4 Loopback Cells				 %d\n",
					pUtopiaStats->RxOamF4LoopbackCells);
			printf("  RX Oam F5 Loopback Cells				 %d\n",
					pUtopiaStats->RxOamF5LoopbackCells);
			printf("\n");

				break;

		case MSP_PE_PHYTYPE_UTOPIA2:
			printf("  Phytype								 Utopia2(MPHY)\n");
			pUtopiaStats = (msp_pe_utopia_if_stats_com*)(&PhyStats.ComFlds.PhyStats.UtopiaIfStats);
			break;

		default:
			printf("  Invalid Phytype						 %d\n",
				PhyStats.ComFlds.PhyType);
		} /* switch */
		printf("\n\n");
		PhyIdx++;
	} /* while */
}


void MspPeCfgStatsShow()
{
	msp_pe_stats		PeStats;
	U32		Status;
	U32		Month;
	U32		Day;
	U32		Hour;
	U32		Min;
	U32		MajRev;
	U32		MinRev;
	U32		ZspSpeed;

		Status = MspPeGetPeStatsBlk(&PeStats);
		if (Status != MSP_SUCCESS)
		{
			printf("Error %d returned from MspPeGetPeStatsBlk()\n", Status);
			return;
		}

		Month = PeStats.ComFlds.BuildDate >> 24;
		Day = (PeStats.ComFlds.BuildDate >> 16 ) & 0xFF;
		Hour = (PeStats.ComFlds.BuildDate >> 8 ) & 0xFF;
		Min = PeStats.ComFlds.BuildDate & 0xFF;

		MajRev = (PeStats.ComFlds.Version >> 16) & 0xffff;
		MinRev = PeStats.ComFlds.Version & 0xffff;

		printf("---	 PE Statistics Display ---\n\n");
		printf("  Build Date							 %02x/%02x/01(%02x:%02x)\n",
				Month, Day, Hour, Min);

		printf("  Major Revision						 %x\n",
				MajRev);
		printf("  Minor Revision						 %x\n",
				MinRev);
		printf("\n");

		/* convert ZspCycleSpeed(AKA ZCS) to mhz.  Note that ZCS is rounded to the nearest
		 * 100.	 So nanoseconds = ZCS / 100.  
		 * Formula is
		 * MHZ = ((1,000,000,000 * 100 / ZCS) / 1,000,000) or
		 * MHZ = 100,000/NS
		 */
		ZspSpeed = 100000/PeStats.ComFlds.ZspCycleSpeed;
		printf("  ZSP clock rate						 %d MHz\n",
				ZspSpeed);
		printf("\n");


		printf("  Maximum commands configured			 %d\n",
				PeStats.ComFlds.MaxCmds);
		printf("\n");
		printf("  Maximum UTOPIA phys configured		 %d\n",
				PeStats.ComFlds.MaxUTOPIA);
		printf("  Maximum HDLC phys configured			 %d\n",
				PeStats.ComFlds.MaxHDLC);
		printf("  Maximum Serial ATM phys configured	 %d\n",
				PeStats.ComFlds.MaxSerialATM);
		printf("  Maximum Nokia phys configured			 %d\n",
				PeStats.ComFlds.MaxNokia);
		printf("\n");
		printf("  Maximum Data VCs configured			 %d\n",
				PeStats.ComFlds.MaxDataVcs);
		printf("  Maximum Voice VCs configured			 %d\n",
				PeStats.ComFlds.MaxVoiceVcs);
		printf("  Maximum CID channels configured		 %d\n",
				PeStats.ComFlds.MaxCidChans);
		printf("\n");
		printf("  Event Buffer: Starting Address		 0x%08x\n",
				PeStats.ComFlds.EvtBufAddrStart);
		printf("  Event Buffer: Ending Address			 0x%08x\n",
				PeStats.ComFlds.EvtBufAddrEnd);
		printf("  Event Buffer: Address of last event	 0x%08x\n",
				PeStats.ComFlds.EvtBufWrPtr);
		printf("\n");
		printf("  Number of events						 %d\n",
				PeStats.ComFlds.EvtCnt);
		printf("  Number of lost events					 %d\n",
				PeStats.ComFlds.LostEvts);


		printf("\n\n");

}

