#include <stdlib.h>
#include <stddef.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <sys/time.h>
#include <asm/mipsregs.h>
/* ------------------------------------------------------------------------ */
#define Get_CP0_COUNT(arg) ({					\
	__asm__ volatile ("move $4, %0;"			\
			  "li $2, -1;"				\
			  "syscall"				\
			  : : "r" (arg) : "$4", "$2", "$7" );})

/* ------------------------------------------------------------------------ */
/* time testing */
#define MAXTIMES	5
int timeworkingon = 0;
struct timeval rqt[MAXTIMES +1];
struct timezone tz;
struct timeval timeadd;
struct timeval timemin;
struct timeval timemax;
struct timeval timediff;
double timeavg;

static unsigned int buffer[MAXTIMES];


#define	timestart() timeworkingon = 0
#define	timetake()  do {			\
    if (timeworkingon > MAXTIMES) {		\
      fprintf(stderr,"too many times collected\n");	\
    } else {					\
      gettimeofday(&rqt[timeworkingon], &tz);	\
      timeworkingon++;				\
    }						\
  } while(0)
#define timeprint() do {			\
    if (timeworkingon == 0) {			\
      fprintf(stderr,"No time information gathered\n");	\
    } else if (timeworkingon == 1) {		\
      fprintf(stderr,"Only one time stamp, can't average.\n"); \
    } else {					\
      timeadd.tv_sec = 0; timeadd.tv_usec = 0;	\
      timemin.tv_sec = 0; timemin.tv_usec = 0;	\
      timemax.tv_sec = 0; timemax.tv_usec = 0;	\
      for (i = 0; i < timeworkingon-1; i++) {	\
	timersub(&rqt[i+1], &rqt[i], &timediff); \
	timeradd(&timediff, &timeadd, &timeadd); \
      }						\
      timeavg = (timeadd.tv_sec + (timeadd.tv_usec/1000000.0))/ (timeworkingon-1); \
      fprintf(stderr,"time average of %d timestamps = %f\n", timeworkingon, timeavg); \
    }						\
    timeworkingon = 0;				\
  } while (0);

/* ------------------------------------------------------------------------ */
int             main()
{
  int i;
  unsigned int addr;

  timestart();
  for (i = 0; i < MAXTIMES; i++) {
    timetake();
  }
  timeprint();

  fprintf(stderr,"-------\n");

  for (i = 0; i < MAXTIMES; i++) {
    sleep(1);
    timetake();
  }
  timeprint();

  for (i = 0; i < MAXTIMES; i++) {
    addr = (unsigned int)(&buffer[i]);
    Get_CP0_COUNT(addr);
  }
  for (i = 0; i < MAXTIMES; i++) {
    fprintf(stderr,"buffer[%2d] = %-10.10u (0x%-8.8x)\n", i, buffer[i], buffer[i]);
  }

  fprintf(stderr, "done\n"); sleep(1);

  return(0);
}

/* ------------------------------------------------------------------------ */
