#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <time.h>
#include <string.h>

/* ------------------------------------------------------------------------ */
static struct timespec rqt,
                rmt;
#define do_sleep	{rqt.tv_sec = 1; \
			 rqt.tv_nsec = 0; \
			 (void)nanosleep(&rqt, &rmt);}

/* ------------------------------------------------------------------------ */
static char buf[BUFSIZ];

int             main(int argc, char *argv[], char *envp[])
{
  int             i;
  char *p;
  struct stat st;

  fprintf(stderr, "in init, main()\n");
  fprintf(stderr, "argc=%x, argv=%x, envp=%x\n", argc, (int)argv, (int)envp);
setvbuf(stderr, NULL, _IONBF, 0);
  fprintf(stderr, "in init, main(), after setvbuf\n");
  for (i = 0; i < argc; i++) {
    fprintf(stderr, "init arg#%d = (%s)\n", i, argv[i]);
  }
  i = 0;
  while (envp[i] != NULL) {
    fprintf(stderr,"init envp#%d = (%s)\n", i, envp[i]);
    i++;
  }
  do_sleep;
  /* ------------- */
  while(1) {
    fprintf(stderr, "\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "Enter file to stat:");
    fprintf(stderr, "> ");
    fflush(stderr);
  /* ------------- */
    fgets(buf, sizeof(buf), stdin);

    if ((p = strchr(buf, '\n')) != NULL) {	/* delete newline */
      *p = '\0';
    }
    if (stat(buf, &st) < 0) {
      perror("stat");
    } else {
    fprintf(stderr, "dev=%ld, ino=%ld, mode=%d, nlink=%d, uid=%d, gid=%d\n",
			st.st_dev, st.st_ino, st.st_mode, st.st_nlink, st.st_uid, st.st_gid);
    fprintf(stderr, "rdev=%ld, pad2=%ld,%ld size=%ld, pad3=%ld, atime=%ld, __reserved0=%ld\n",
			st.st_rdev, st.st_pad2[0], st.st_pad2[1], st.st_size, st.st_pad3, st.st_atime, st.__reserved0);
    fprintf(stderr, "mtime=%ld, __reserved1=%ld, ctime=%ld, __reserved2=%ld, blksize=%ld, blocks=%ld, pad5[0]=%ld\n",
			st.st_mtime, st.__reserved1, st.st_ctime, st.__reserved2, st.st_blksize, st.st_blocks, st.st_pad5[0]);
    }
  }
}

/* ------------------------------------------------------------------------ */
