#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <sys/signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <termios.h>

/* ------------------------------------------------------------------------ */
static pid_t mypid;

static char *argv_ls[4] = { "ls", "-l", "/dev", NULL };
static char *envp_init[3] = { "HOME=/", "TERM=linux", NULL };

/* ------------------------------------------------------------------------ */
static void test1(void)
{
    pid_t w;

    fprintf(stderr, "test 1\n"); sleep(1);
    if (vfork() == 0) {
	fprintf(stderr, "child, running\n"); /* sleep(1); */
	fprintf(stderr, "child, execve(/bin/ls)\n"); /* sleep(1); */
	execve("/bin/ls", argv_ls, envp_init);
	fprintf(stderr, "execve failed\n"); /* sleep(1); */
	_exit(EXIT_FAILURE);
    }
    fprintf(stderr, "parent, running\n"); sleep(1);
    for(;;) {
	fprintf(stderr, "parent waiting a while, sleep 10)\n");
	sleep(10);
	w = waitpid(-1, NULL, WNOHANG | WUNTRACED);
	fprintf(stderr, "waitpid returned %d\n", w); sleep(1);
	if (w > 0) {
	    fprintf(stderr, "parent waitpid returned > 0\n"); /* sleep(1); */
	    break;
	}
    }
    fprintf(stderr, "parent, test 1 done\n"); /* sleep(1); */
}

/* ------------------------------------------------------------------------ */
static void test2(void)
{
    pid_t w;

    fprintf(stderr, "test 2\n"); sleep(2);
    if (vfork() == 0) {
	fprintf(stderr, "child, running\n");
	fprintf(stderr, "child, execve(/bin/ls)\n");
	execve("/bin/ls", argv_ls, envp_init);
	fprintf(stderr, "execve failed\n");
	_exit(EXIT_FAILURE);
    }
/*     fprintf(stderr, "parent, running\n"); */
    for(;;) {
/* 	fprintf(stderr, "parent not waiting before waitpid)\n"); */
	w = waitpid(-1, NULL, WNOHANG | WUNTRACED);
	fprintf(stderr, "parent waitpid returned %d\n", w);
	if (w > 0) {
	    fprintf(stderr, "parent waitpid returned > 0\n");
	    break;
	}
/* 	fprintf(stderr, "parent after waitpid\n"); */
    }
    fprintf(stderr, "parent, test 2 done\n");
}

/* ------------------------------------------------------------------------ */
int main(void) 
{
    mypid = getpid();
    
    test1();
    test2();

    fprintf(stderr, "Bye-bye!  All done!\n");
/*     tcdrain(STDOUT_FILENO); */
/*     tcdrain(STDERR_FILENO); */
    exit(0);
}

/* ------------------------------------------------------------------------ */
