#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

#define COUNT	64

#define SIZE	2048

static char buf[1024];
static FILE *f;

static void printfree(int t)
{

  fseek(f, 0, SEEK_SET);
  fgets(buf, sizeof(buf), f);
  if (t == 1) {		/* print out header */
    fprintf(stderr, buf);
  }
  fgets(buf, sizeof(buf), f);
  buf[strlen(buf)-1] = '\0';
  fprintf(stderr, buf);

/*   fclose(f); */
}

int main()
{
  void *a[COUNT];
  int d;

  f = fopen("/proc/meminfo", "r");
  if (f == NULL) {
    perror("fopen");
    fprintf(stderr, "can't open /proc/meminfo\n");
    exit(1);
  }

  printfree(1);
  for (d = 0; d < COUNT; d++) {
    a[d] = malloc(SIZE);
    fprintf(stderr, "  malloc(%d) a[%d]=%p\n", SIZE, d, a[d]);
    usleep(100000);
    printfree(0);
  }

  for (d = COUNT-1; d >= 0; d--) {
    fprintf(stderr, "  free a[%d]=%p\n", d, a[d]);
    free(a[d]);
    usleep(100000);
    printfree(0);
  }
  fprintf(stderr, "\n");

  exit(0);
}
