#include <stdlib.h>
#include <stdio.h>

/* #define N_PTRS 250 */
#define N_PTRS 1000
#define N_ALLOCS 10000
#define MAX_SIZE 0x8000
#define random_size()	((random()%MAX_SIZE)+1)
#define random_ptr()	(random()%N_PTRS)

void            test1(void)
{
  void          **ptrs;
  int             i, j;

  srandom(0x19730929);
  ptrs = (void **) malloc(N_PTRS * sizeof(void *));
  if (!ptrs) {
    fprintf(stderr, "malloc failed!\n");
    exit(1);
  }
  for (i = 0; i < N_PTRS; i++) {
    ptrs[i] = malloc(random_size());
    if (!ptrs[i])
      fprintf(stderr, "malloc failed! #%d\n", i);
  }
  for (i = 0; i < N_ALLOCS; i++) {
    j = random_ptr();
    free(ptrs[j]);
    ptrs[j] = malloc(random_size());
    if (!ptrs[j])
      fprintf(stderr, "malloc failed! %d / %d\n", i, j);
  }
  for (i = 0; i < N_PTRS; i++)
    free(ptrs[i]);
}

void            test2(void)
{
  void           *ptr = NULL;

  ptr = realloc(ptr, 100);
  if (!ptr) {
    fprintf(stderr, "couldn't realloc() a NULL pointer\n");
    exit(1);
  } else {
    free(ptr);
  }
  ptr = malloc(100);
  ptr = realloc(ptr, 0);
  if (ptr) {
    fprintf(stderr, "realloc(,0) failed\n");
    free(ptr);
    exit(1);
  }
}

int             main(int argc, char *argv[])
{
  test1();
  test2();
  return 0;
}
