#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <ctype.h>
extern size_t strspn( const char *s, const char *accept);

/* #include <utypes.h> */

typedef unsigned long U32;

#define	PREG_BASE	0xB8400000	/* Base address to Peripheral Reg  */
#define PER_BASE 	PREG_BASE

/**********************************************************/
/* GPIO registers										  */
/**********************************************************/
#define GPIO_DATA_REG			((volatile U32 *)(PER_BASE + 0xE0))	/* GPIO Data reg				*/
#define GPIO_CFG1_REG			((volatile U32 *)(PER_BASE + 0xE4)) 	/* GPIO CFG1 reg				*/
#define GPIO_CFG2_REG			((volatile U32 *)(PER_BASE + 0xE8))	/* GPIO CFG2 reg				*/

#define MAXLEDSAVAILABLE	6

/*******************************************************************************
*
* initLED - initialize GPIO pins for the LED
*
* Input :  gpioPin to be used as LED (pin is set to output)
* 
********************************************************************************/

void initLED (int gpioPin)
{
    /* set the appropriate GPIO pins to be outputs */
    /* *GPIO_CFG1_REG controls GPIO 0-7 */
    /* *GPIO_CFG2_REG controls GPIO 8-15 */
    if (gpioPin < 8)
    {
        *GPIO_CFG1_REG &= ~(0xF << (gpioPin * 4));
        *GPIO_CFG1_REG |= 0x8 << (gpioPin * 4);
    }
    else
    {
        *GPIO_CFG2_REG &= ~(0xF << (gpioPin * 4));
        *GPIO_CFG2_REG |= 0x8 << (gpioPin * 4);
    }
}

/*******************************************************************************
*
* turnOnLED - turn LED on associated with GPIO pin
*
* Input :  gpioPin used as LED (pin is set to output
* 
********************************************************************************/
void turnOnLED (int gpioPin)
{	
    *GPIO_DATA_REG |= 1 << gpioPin;    /* turns LED on */
}

/*******************************************************************************
*
* turnOffLED - turn LED off associated with GPIO pin
*
* Input :  gpioPin used as LED (pin is set to output
* 
********************************************************************************/
void turnOffLED (int gpioPin)
{
    *GPIO_DATA_REG &= ~(1 << gpioPin);    /* turns LED off */
}

volatile int waiting;

void delay(int delaycount)
{
/*   int i; */
  
  sleep(delaycount);
/*   for (i = 0; i < delaycount; i++) */
/* 	{ */
/* 	  waiting = i; */
/* 	} */
}

/* ledflash <delay> <led> <led> <led> ... */

int main(int argc, char **argv)
{
	int i;
	int skip;
	int lastled = 0;
	int led;
	int delaycount = 0;
	unsigned long selectedleds = 0;

	printf("ledflash <delay count> <led> <led> <led> ...\n");
	printf("recommended delay count (seconds) is between 1 and 10 \n");
	printf("led can be 0 to %d inclusive\n", MAXLEDSAVAILABLE-1);

	for (i = 1; i < argc; i++)
	{
		skip = strspn(argv[i], " ");
		if (!isdigit(argv[i][skip]))
		{
			printf("Argument <%s> doesn't appear to be a number\n", argv[i]);
			continue;
		}
		led = atoi(&argv[i][skip]);

		if (i == 1)
		{
			delaycount = led;
			continue;
		}
		
		if (led >= MAXLEDSAVAILABLE)
		{
			printf("<%s> must be less than %d\n", argv[i], MAXLEDSAVAILABLE);
			continue;
		}
		selectedleds |= 1 << led;
	}
	
	if (selectedleds == 0)
	{
		printf("No leds selected\n");
		return 1;
	}
	
	printf("delay count selected %d\n", delaycount);

	for (led = 0; led < MAXLEDSAVAILABLE; led++)
	{
		if (selectedleds & (1<<led))
		{
			initLED(led);
			turnOffLED(led);
			lastled = led;
			printf("led %d selected\n", led);
		}
	}

	/* turn on/off leds */

	while (1)
	{
		turnOffLED(lastled);
		led = lastled + 1;
		while (led != lastled)
		{
			if (led < MAXLEDSAVAILABLE)
			{
				if (selectedleds & (1<<led))
					lastled = led;
				else
					led++;
			}
			else
				led = 0;
		}
		turnOnLED(lastled);

		/* scan devs checks for ctrl-c and other device activity */
/* 		scandevs(); */
		delay(delaycount);
	}
	return(0);
}

