#include <stdlib.h>
#include <stddef.h>
#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <time.h>
#include <string.h>
#include <sys/wait.h>

extern int getpid();
extern int wait4();
extern int execv();

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */
static struct timespec rqt,
                rmt;
static struct timespec lrqt,
                lrmt;
#define do_sleep	{rqt.tv_sec = 1; \
			 rqt.tv_nsec = 0; \
			 (void)nanosleep(&rqt, &rmt);}

#define do_long_sleep	{lrqt.tv_sec = 5; \
			 lrqt.tv_nsec = 0; \
			 (void)nanosleep(&lrqt, &lrmt);}

/* ------------------------------------------------------------------------ */
static volatile int abc;
static FILE *M4fd = NULL;
/* ------------------------------------------------------------------------ */
static void     catcher(int a)
{
  signal(SIGALRM, SIG_DFL);
  printf("catcher, a=%d (%x)\n", a, a);
  do_sleep;
  abc = 1;
}

/* ------------------------------------------------------------------------ */
static void alarmtest()
{
  printf("\n");
  printf("alarm test sets an alarm for six (6) seconds, and then prints\n");
  printf("an \"a\" in a loop, with a nanosleep for 1 second after it.\n");
  printf("It prints a message about things being good.\n");
  printf("The second part is same thing, but prints \"b\".\n");
  printf("\n");
  /* ----------- */
  signal(SIGALRM, catcher);
  alarm(6);
  abc = 0;
  while (abc == 0) {
    fprintf(M4fd, "a");
    do_sleep;
  }
  signal(SIGALRM, SIG_DFL);
  fprintf(M4fd, "after alarm(6), everything should be good.\n");
  do_long_sleep;
  /* ----------- */
  signal(SIGALRM, catcher);
  alarm(6);
  abc = 0;
  while (abc == 0) {
    fprintf(M4fd, "b");
    do_sleep;
  }
  signal(SIGALRM, SIG_DFL);
  fprintf(M4fd, "after alarm(1), everything should be good.\n");
  do_sleep;
  /* ----------- */
  fprintf(M4fd, "exiting alarm test, doing good.\n");
  do_sleep;
}

/* ------------------------------------------------------------------------ */
#define VFORKCOUNT	15
/* ------------------------------------------------------------------------ */
static volatile int vcount;

static void vforktest()
{
  int pid;
  int starting_pid = getpid();

  vcount = 0;
  while (vcount != VFORKCOUNT) {
    if ((pid = vfork()) == 0) {		/* child */
      vcount++;
      printf("child [vcount=%d] (pid=%d) running\n", vcount, getpid());
    } else {				/* parent */
      printf("parent(pid=%d) for child=(%d) [vcount=%d]\n", getpid(), pid, vcount);
      if (starting_pid != getpid()) {
	_exit(0);			/* exit parent */
      }
      printf("original parent running, exit loop\n");
      break;				/* original parent rnning. */
    }
  }
  if (starting_pid != getpid()) {
    _exit(0);				/* exit child */
  }
  printf("end of vfork test\n");
}

/* ------------------------------------------------------------------------ */
#include <fcntl.h>

static void do_fd(char *str)
{
  FILE *file;
  int fd;

  fprintf(M4fd, "%s [vcount=%d] (pid=%d) running\n", str, vcount, getpid());
  fprintf(M4fd, "fileno: stdin=%d, stdout=%d, stderr=%d\n", fileno(stdin),fileno(stdout),fileno(stderr));
  fd = open("/etc/rc", O_RDONLY, 0);
  fprintf(M4fd, "open gave fd=%d\n", fd);
  fprintf(M4fd, "fileno: stdin=%d, stdout=%d, stderr=%d\n", fileno(stdin),fileno(stdout),fileno(stderr));
  close(fd);
  file = fopen("/etc/rc", "r");
  fprintf(M4fd, "fopen gave fd=%d\n", fileno(file));
  fprintf(M4fd, "fileno: stdin=%d, stdout=%d, stderr=%d\n", fileno(stdin),fileno(stdout),fileno(stderr));
  fclose(file);
}

/* ------------------------------------------------------------------------ */
static void fdtest()
{
  int pid;
  int starting_pid = getpid();

  fprintf(M4fd, "original process [vcount=%d] (pid=%d)\n", vcount, getpid());
  fprintf(M4fd, "fileno: stdin=%d, stdout=%d, stderr=%d\n", fileno(stdin),fileno(stdout),fileno(stderr));
  vcount = 0;
  if ((pid = vfork()) == 0) {		/* child */
    vcount++;
    do_fd("child");
  } else {				/* parent */
    fprintf(M4fd, "parent(pid=%d) for child=(%d) [vcount=%d]\n", getpid(), pid, vcount);
    do_fd("parent");
  }
  if (starting_pid != getpid()) {
    _exit(0);				/* exit child */
  }
  fprintf(M4fd, "end of fdtest test\n");
}

/* ------------------------------------------------------------------------ */
static char buf[BUFSIZ];
static char *newargv[BUFSIZ];

int             main(int argc, char *argv[], char *envp[])
{
  int             i;

  M4fd = fopen("/var/M4fd", "w");
  fprintf(M4fd, "in init, main()\n");
  fprintf(M4fd, "argc=%x, argv=%x, envp=%x\n", argc, (int)argv, (int)envp);
setvbuf(M4fd, NULL, _IONBF, 0);
  fprintf(M4fd, "in init, main(), after setvbuf\n");
  for (i = 0; i < argc; i++) {
    fprintf(M4fd, "init arg#%d = (%s)\n", i, argv[i]);
  }
  i = 0;
  while (envp[i] != NULL) {
    fprintf(M4fd,"init envp#%d = (%s)\n", i, envp[i]);
    i++;
  }
  do_sleep;
  /* ------------- */
  while(1) {
    fprintf(M4fd, "\n");
    fprintf(M4fd, "\n");
    fprintf(M4fd, "\n");
    fprintf(M4fd, "Choose a letter, press return to run:\n");
    fprintf(M4fd, "\t a	alarm test -- warning -- fails/hangs\n");
    fprintf(M4fd, "\t b	vfork %d times and exit back to here\n", VFORKCOUNT);
    fprintf(M4fd, "\t c	fdtest and exit back to here\n");
    fprintf(M4fd, "\t q	exit(0) this test program (called init)\n");
    fprintf(M4fd, "\t x	exit(1) this test program (called init)\n");
    fprintf(M4fd, "\t cmd	/bin/sh -c cmd		# anything else\n");
    fprintf(M4fd, "\n");
    fprintf(M4fd, "example: /sbin/init this is the arguments\n");
    fprintf(M4fd, "> ");
    fflush(M4fd);
  /* ------------- */
    fgets(buf, sizeof(buf), stdin);
    if (strcmp(buf, "a\n") == 0) {
      alarmtest();
    } else if (strcmp(buf, "b\n") == 0) {
      vforktest();
    } else if (strcmp(buf, "c\n") == 0) {
      fdtest();
    } else if (strcmp(buf, "q\n") == 0) {
      exit(0);
    } else if (strcmp(buf, "x\n") == 0) {
      exit(1);
    } else {
/*       system(buf); */
      char *p;
      int j = 0;

      if ((p = strchr(buf, '\n')) != NULL) {	/* delete newline */
	*p = '\0';
      }
      p = buf;
      newargv[j] = p;
      j++;
      while (p < buf+BUFSIZ && *p != '\0') {
	if (*p == ' ' || *p == '	') {
	  *p = '\0';
	  newargv[j] = p+1;
	  j++;
	}
	p++;
      }
      newargv[j] = NULL;
      if ((i = vfork()) == 0) {			/* child */
	execv(buf, newargv);
	fprintf(M4fd, "execv failed, child (%d) exits.\n", i);
	exit(i);
      } else if (i < 0) {
	fprintf(M4fd, "vfork error\n");
      } else {					/* parent */
	int wait_val;
	fprintf(M4fd, "Waiting for child %d\n", i);
	if (wait4(i, &wait_val, 0, 0) == -1) {
	      fprintf(M4fd, "wait4 error\n");
	} else {
	  fprintf(M4fd, "wait4 returned status of 0x%x (%d)\n", wait_val, wait_val);
	}
      }
    }
  }
}

/* ------------------------------------------------------------------------ */
