#include <stdlib.h>
#include <stddef.h>
#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <time.h>
#include <string.h>
#include <sys/wait.h>

extern int getpid();
extern int wait4();
extern int execv();

/* ------------------------------------------------------------------------ */
static struct timespec rqt,
                rmt;
static struct timespec lrqt,
                lrmt;
#define do_sleep	{rqt.tv_sec = 1; \
			 rqt.tv_nsec = 0; \
			 (void)nanosleep(&rqt, &rmt);}

#define do_long_sleep	{lrqt.tv_sec = 5; \
			 lrqt.tv_nsec = 0; \
			 (void)nanosleep(&lrqt, &lrmt);}

/* ------------------------------------------------------------------------ */
static volatile int abc;
/* ------------------------------------------------------------------------ */
static void     catcher(int a)
{
  signal(SIGALRM, SIG_DFL);
  fprintf(stderr, "catcher, a=%d (%x)\n", a, a);
  do_sleep;
  abc = 1;
}

/* ------------------------------------------------------------------------ */
static void alarmtest()
{
  fprintf(stderr, "\n");
  fprintf(stderr, "alarm test sets an alarm for six (6) seconds, and then prints\n");
  fprintf(stderr, "an \"a\" in a loop, with a nanosleep for 1 second after it.\n");
  fprintf(stderr, "It prints a message about things being good.\n");
  fprintf(stderr, "The second part is same thing, but prints \"b\".\n");
  fprintf(stderr, "\n"); sleep(1);
  /* ----------- */
  signal(SIGALRM, catcher);
  alarm(6);
  abc = 0;
  while (abc == 0) {
    fprintf(stderr, "a");
    do_sleep;
  }
  signal(SIGALRM, SIG_DFL);
  fprintf(stderr, "after alarm(6), everything should be good.\n");
  do_long_sleep;
  /* ----------- */
  signal(SIGALRM, catcher);
  alarm(6);
  abc = 0;
  while (abc == 0) {
    fprintf(stderr, "b");
    do_sleep;
  }
  signal(SIGALRM, SIG_DFL);
  fprintf(stderr, "after alarm(1), everything should be good.\n");
  do_sleep;
  /* ----------- */
  fprintf(stderr, "exiting alarm test, doing good.\n");
  do_sleep;
}

/* ------------------------------------------------------------------------ */
#define VFORKCOUNT	15
/* ------------------------------------------------------------------------ */
static volatile int vcount;

static void vforktest()
{
  int pid;
  int starting_pid = getpid();

  vcount = 0;
  while (vcount != VFORKCOUNT) {
    if ((pid = vfork()) == 0) {		/* child */
      vcount++;
      fprintf(stderr, "child [vcount=%d] (pid=%d) running\n", vcount, getpid()); sleep(1);
    } else {				/* parent */
      fprintf(stderr, "parent(pid=%d) for child=(%d) [vcount=%d]\n", getpid(), pid, vcount); sleep(1);
      if (starting_pid != getpid()) {
	_exit(0);			/* exit parent */
      }
      fprintf(stderr, "original parent running, exit loop\n"); sleep(1);
      break;				/* original parent rnning. */
    }
  }
  if (starting_pid != getpid()) {
    fprintf(stderr, "exiting child with pid=%d\n", getpid()); sleep(1);
    _exit(0);				/* exit child */
  }
  fprintf(stderr, "end of vfork test\n"); sleep(1);
}

/* ------------------------------------------------------------------------ */
#define FORKCOUNT	4
/* ------------------------------------------------------------------------ */
static volatile int fcount;

static void forktest()
{
  int pid;
  int starting_pid = getpid();
  int status;
  int parent_pid;
  int pcount;
fprintf(stderr, "starting_pid(%d)\n", starting_pid);

  fcount = 0;
  pcount = 0;
  while (fcount < FORKCOUNT && pcount < FORKCOUNT) {
    parent_pid=getpid();
    if ((pid = fork()) == 0) {		/* child */
      fcount++;
      fprintf(stderr, "c%d/%d[%d,%d]\n", parent_pid, getpid(), fcount, pcount);
      sleep(1);
    } else {				/* parent */
      pcount++;
      fprintf(stderr, "p%d(%d)/%d[%d,%d]\n", getpid(), parent_pid, pid, fcount, pcount);
      sleep(1);
      if (starting_pid != getpid()) {
fprintf(stderr, "starting_pid(%d) [%d,%d] != getpid(%d)\n", starting_pid, fcount, pcount, getpid());
	sleep(1);
	continue;
/*	exit(starting_pid); */		/* exit parent */
      }
      fprintf(stderr, "original parent running (%d), exit loop [%d,%d]\n", starting_pid, fcount, pcount);
      sleep(1);
      break;				/* original parent rnning. */
    }
  }
  if (starting_pid != getpid()) {
    fprintf(stderr, "exiting child with pid=%d (%d) [%d,%d]\n", getpid(), starting_pid, fcount, pcount);
    sleep(1);
    while (1) {
      pid=wait(&status);
      if (pid < 0) {
	perror("wait");
	sleep(1);
	fprintf(stderr, "really exiting child with pid=%d (%d) [%d,%d]\n", getpid(), starting_pid, fcount, pcount);
	sleep(1);
	exit(getpid());
      }
      fprintf(stderr, "child (%d) got pid=%d from wait, with status=%x\n", getpid(), pid, status);
      sleep(1);
    }
  }
  while (1) {
    pid=wait(&status);
    if (pid < 0) {
      perror("wait");
      sleep(1);
      break;
    }
    fprintf(stderr, "parent (%d) got pid=%d from wait, with status=%x\n", getpid(), pid, status);
    sleep(1);
  }
  fprintf(stderr, "end of fork test [%d,%d]\n", fcount, pcount);
  sleep(1);
}

/* ------------------------------------------------------------------------ */
static void complicatedforktest()
{
  int starting_pid = getpid();
  int status;
  int pid;
  int parent_pid;
  struct complicated {
    int pid;
    int length;
    int *data;
  };
  struct complicated m1;
  struct complicated m2;
  struct complicated m11;
  struct complicated m12;
  struct complicated m22;

  m1.pid = -1;
  m1.length = 0;
  m1.data = NULL;
  m2.pid = -2;
  m2.length = 0;
  m2.data = NULL;
  m11.pid = -11;
  m11.length = 0;
  m11.data = NULL;
  m12.pid = -12;
  m12.length = 0;
  m12.data = NULL;
  m22.pid = -22;
  m22.length = 0;
  m22.data = NULL;
fprintf(stderr, "complicated starting_pid(%d)\n", starting_pid);
  m1.pid = getpid();
  m1.length = 100*sizeof(int);
  m1.data = (int *)malloc(m1.length);
  memset(m1.data, getpid(), m1.length);
  parent_pid=fork();
  if (parent_pid < 0) {
    fprintf(stderr, "complicatedforktest, first parent fork failed?\n");
    return;
  }
  if (parent_pid == 0) {	/* child 11 */
    m11.pid = getpid();
    m11.length = 200*sizeof(int);
    m11.data = (int *)malloc(m11.length);
    memset(m11.data, getpid(), m1.length);
    fprintf(stderr, "child11 (pid=%d) sleeping 10 seconds\n", getpid());
    sleep(10);
    fprintf(stderr, "child11 (pid=%d) exiting\n", getpid());
    exit(11);
  } else {			/* parent 1 */
    m2.pid = getpid();
    m2.length = 300*sizeof(int);
    m2.data = (int *)malloc(m2.length);
    memset(m2.data, getpid(), m2.length);
    parent_pid=fork();
    if (parent_pid < 0) {
      fprintf(stderr, "complicatedforktest, second parent fork failed?\n");
      return;
    }
    if (parent_pid == 0) {	/* child 12 */
      m12.pid = getpid();
      m12.length = 400*sizeof(int);
      m12.data = (int *)malloc(m12.length);
      memset(m12.data, getpid(), m1.length);
      fprintf(stderr, "child12 (pid=%d) sleeping 1 second\n", getpid());
      sleep(1);
/* child 2 forks and becomes a parent. */
      parent_pid=fork();
      if (parent_pid < 0) {
	fprintf(stderr, "complicatedforktest, second parent fork failed?\n");
	return;
      }
      if (parent_pid == 0) {	/* child 22 */
	m22.pid = getpid();
	m22.length = 500*sizeof(int);
	m22.data = (int *)malloc(m22.length);
	memset(m22.data, getpid(), m1.length);
	fprintf(stderr, "child22 (pid=%d) sleeping 10 second\n", getpid());
	sleep(10);
	fprintf(stderr, "child22 (pid=%d) exiting\n", getpid());
	exit(22);
      } else {			/* parent 1 */
	fprintf(stderr, "parent 12 has forked a child, sleep 10\n");
	sleep(10);
	while (1) {
	  pid=wait(&status);
	  if (pid < 0) {
	    perror("wait");
	    sleep(1);
	    break;
	  }
	  fprintf(stderr, "parent (%d) got pid=%d from wait, with status=%x\n", getpid(), pid, status);
	  sleep(1);
	}
	fprintf(stderr, "child12 (pid=%d) sleeping 10 second\n", getpid());
	sleep(10);
	fprintf(stderr, "child12 (pid=%d) exiting\n", getpid());
	exit(12);
      }
    }
  }
  sleep(1);
  while (1) {
    pid=wait(&status);
    if (pid < 0) {
      perror("wait");
      sleep(1);
      break;
    }
    fprintf(stderr, "parent (%d) got pid=%d from wait, with status=%x\n", getpid(), pid, status);
    sleep(1);
  }
}

/* ------------------------------------------------------------------------ */
#include <fcntl.h>

static void do_fd(char *str)
{
  FILE *file;
  int fd;

  fprintf(stderr, "%s [vcount=%d] (pid=%d) running\n", str, vcount, getpid()); sleep(1);
  fprintf(stderr, "fileno: stdin=%d, stdout=%d, stderr=%d\n", fileno(stdin),fileno(stdout),fileno(stderr)); sleep(1);
  fd = open("/etc/rc", O_RDONLY, 0);
  fprintf(stderr, "open gave fd=%d\n", fd); sleep(1);
  fprintf(stderr, "fileno: stdin=%d, stdout=%d, stderr=%d\n", fileno(stdin),fileno(stdout),fileno(stderr)); sleep(1);
  close(fd);
  fprintf(stderr,"close(fd) done\n"); sleep(1);
  file = fopen("/etc/rc", "r");
  fprintf(stderr, "fopen gave fd=%d\n", fileno(file)); sleep(1);
  fprintf(stderr, "fileno: stdin=%d, stdout=%d, stderr=%d\n", fileno(stdin),fileno(stdout),fileno(stderr)); sleep(1);
  fclose(file);
  fprintf(stderr,"close(fd) done\n"); sleep(1);
}

/* ------------------------------------------------------------------------ */
static void vfdtest()
{
  int pid;
  int starting_pid = getpid();

  fprintf(stderr, "original process [vcount=%d] (pid=%d)\n", vcount, starting_pid); sleep(1);
  fprintf(stderr, "fileno: stdin=%d, stdout=%d, stderr=%d\n", fileno(stdin),fileno(stdout),fileno(stderr)); sleep(1);
  vcount = 0;
  if ((pid = vfork()) == 0) {		/* child */
    vcount++;
    do_fd("child");
  } else {				/* parent */
    fprintf(stderr, "parent(pid=%d) for child=(%d) [vcount=%d]\n", getpid(), pid, vcount); sleep(1);
    do_fd("parent");
  }
  if (starting_pid != getpid()) {
    fprintf(stderr, "exit child\n"); sleep(1);
    _exit(0);				/* exit child */
  }
  fprintf(stderr, "end of vfdtest test\n"); sleep(1);
}

/* ------------------------------------------------------------------------ */
static void ffdtest()
{
  int pid;
  int starting_pid = getpid();

  fprintf(stderr, "original process [vcount=%d] (pid=%d)\n", vcount, starting_pid); sleep(1);
  fprintf(stderr, "fileno: stdin=%d, stdout=%d, stderr=%d\n", fileno(stdin),fileno(stdout),fileno(stderr)); sleep(1);
  vcount = 0;
  if ((pid = fork()) == 0) {		/* child */
    vcount++;
    do_fd("child");
  } else {				/* parent */
    fprintf(stderr, "parent(pid=%d) for child=(%d) [vcount=%d]\n", getpid(), pid, vcount); sleep(1);
    do_fd("parent");
  }
  if (starting_pid != getpid()) {
    fprintf(stderr, "exit child\n"); sleep(1);
    _exit(0);				/* exit child */
  }
  fprintf(stderr, "end of ffdtest test\n"); sleep(1);
}

/* ------------------------------------------------------------------------ */
static char buf[BUFSIZ];
static char *newargv[BUFSIZ];

int             main(int argc, char *argv[], char *envp[])
{
  int             cnt;

  fprintf(stderr, "in init, main(), stderr\n");
  fprintf(stderr, "argc=%x, argv=%x, envp=%x\n", argc, (int)argv, (int)envp);
setvbuf(stderr, NULL, _IONBF, 0);
setvbuf(stdout, NULL, _IONBF, 0);
  fprintf(stderr, "in init, main(), stdout\n");
  for (cnt = 0; cnt < argc; cnt++) {
    fprintf(stderr, "init arg#%d = (%s)\n", cnt, argv[cnt]);
  }
  cnt = 0;
  while (envp[cnt] != NULL) {
    fprintf(stderr,"init envp#%d = (%s)\n", cnt, envp[cnt]);
    cnt++;
  }
  do_sleep;
/* forktest(); exit(1); */
  /* ------------- */
  while(1) {
    fprintf(stderr, "\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "Choose a letter, press return to run:\n");
    fprintf(stderr, "\t a	alarm test -- warning -- fails/hangs\n");
    fprintf(stderr, "\t b	vfork %d times and exit back to here\n", VFORKCOUNT);
    fprintf(stderr, "\t c	fork %d times and exit back to here\n", FORKCOUNT);
    fprintf(stderr, "\t d	vfdtest and exit back to here\n");
    fprintf(stderr, "\t e	ffdtest and exit back to here\n");
    fprintf(stderr, "\t f	more complicated fork test.\n");
    fprintf(stderr, "\t q	exit(0) this test program (called init)\n");
    fprintf(stderr, "\t x	exit(1) this test program (called init)\n");
    fprintf(stderr, "\t cmd	/bin/sh -c cmd		# anything else\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "example: /sbin/init this is the arguments\n");
    fprintf(stderr, "> "); sleep(1);
  /* ------------- */
    fgets(buf, sizeof(buf), stdin);
    if (strcmp(buf, "a\n") == 0) {
      alarmtest();
    } else if (strcmp(buf, "b\n") == 0) {
      vforktest();
    } else if (strcmp(buf, "c\n") == 0) {
      forktest();
    } else if (strcmp(buf, "d\n") == 0) {
      vfdtest();
    } else if (strcmp(buf, "e\n") == 0) {
      ffdtest();
    } else if (strcmp(buf, "f\n") == 0) {
      complicatedforktest();
    } else if (strcmp(buf, "q\n") == 0) {
      exit(0);
    } else if (strcmp(buf, "x\n") == 0) {
      exit(1);
    } else {
/*       system(buf); */
      char *p;
      int i = 0;

      if ((p = strchr(buf, '\n')) != NULL) {	/* delete newline */
	*p = '\0';
      }
      p = buf;
      newargv[i] = p;
      i++;
      while (p < buf+BUFSIZ && *p != '\0') {
	if (*p == ' ' || *p == '	') {
	  *p = '\0';
	  newargv[i] = p+1;
	  i++;
	}
	p++;
      }
      newargv[i] = NULL;
      if ((i = vfork()) == 0) {			/* child */
	execv(buf, newargv);
	i = fprintf(stderr, "execv failed, child will exit with value %d also.\n", i); sleep(1);
	_exit(i);
      } else if (i < 0) {
	perror("vfork");
      } else {					/* parent */
	int wait_val;
	fprintf(stderr, "Waiting for child %d\n", i); sleep(1);
	if (wait4(i, &wait_val, 0, 0) == -1) {
	      perror("wait4");
	} else {
	  fprintf(stderr, "wait4 returned status of 0x%x (%d)\n", wait_val, wait_val); sleep(1);
	}
      }
    }
  }
}

/* ------------------------------------------------------------------------ */
