/* #include <features.h> */
#include <unistd.h>
#define __NO_INLINE__
#include <string.h>

class TestGlobal 
{
    public: 
	TestGlobal::TestGlobal()
	{
	    char *msg = "hello from a global constructor\n";
	    write(1, msg, strlen(msg));
	    initialized_flag = 42;
	}
	TestGlobal::~TestGlobal()
	{
	    char *msg = "goodbye from a global destructor\n";
	    write(1, msg, strlen(msg));
	}
	void hello(char *str)
	{
	    char *msg = "hello from ";

	    write(1, msg, strlen(msg));
	    write(1, str, strlen(str));
	    write(1, "\n", 1);
	};
    public:
	int initialized_flag;
};

class Test 
{
    public: 
	Test::Test()
	{
	    char *msg = "hello from a normal constructor\n";
	    write(1, msg, strlen(msg));
	    initialized_flag = 42;
	}
	Test::~Test()
	{
	    char *msg = "goodbye from a normal destructor\n";
	    write(1, msg, strlen(msg));
	}
	void hello(char *str)
	{
	    char *msg = "hello from ";
	    if (initialized_flag != 42) {
		msg = "normal contructor failed to execute!\n";
		write(1, msg, strlen(msg));
		_exit(1);
	    }
	    write(1, msg, strlen(msg));
	    write(1, str, strlen(str));
	    write(1, "\n", 1);
	};
    private:
	int initialized_flag;
};

// A nice test global
TestGlobal b;

// Another test global
int flag = 0;

class Test2 
{
    public: 
	template <class T, class U> Test2(T, U) {flag = 1;}
	template <class T, class U> Test2(T, U*) {flag = 2;}
	template <class T, class U> Test2(T*, U) {flag = 3;}
	template <class T, class U> Test2(T*, U*) {flag = 4;}
};



int main(void) 
{
    TestGlobal *c;
    c = &b;

    if (c->initialized_flag != 42) {
	char * msg = "Global Contructor failed to execute!\n";
	write(1, msg, strlen(msg));
	return 1;
    }


    Test a;
    a.hello("test 1"); 
    b.hello("test 2"); 
    c->hello("test 3");


    int* p = 0;
    flag = 0;
    new Test2(p, 0);
    if (flag != 3) {
	char * msg = "bug 1\n";
	write(1, msg, strlen(msg));
	return(1);
    }

    flag = 0;
    new Test2(0, p);
    if (flag != 2) {
	char * msg = "bug 2\n";
	write(1, msg, strlen(msg));
	return(2);
    }

    flag = 0;
    new Test2(p, p);
    if (flag != 4) {
	char * msg = "bug 3\n";
	write(1, msg, strlen(msg));
	return(3);
    }

    flag = 0;
    new Test2(0, 0);
    if (flag != 1) {
	char * msg = "bug 4\n";
	write(1, msg, strlen(msg));
	return(4);
    }

    char * msg = "Cool, things seem to be working!\n"; 
    write(1, msg, strlen(msg));
    return 0;
}

