/*************************************************************
 * File: lib/memset.s
 * Purpose: Part of C runtime library
 */

#include <asm/regdef.h>

	.globl	memset
	.ent	memset
memset:
	.set noreorder
	/* memset(s,c,n) - fill s with n bytes of c */

	li		t1, 0xff
	move	v0, a0
	and		t1, a1
	li		t2, 16
	move	t4, t1
	li		t3, 1
	sll		t4, 8

	beqz	a2, done
	or		t1, t4

	move	t4, t1
	sll		t4, 16

	bgtu	t2, a2, 4f
	or		t1, t4
1:
	li		t4, 3
	and		t4, a0
	beqz	t4, 2f
	nop
	sb		t1, 0(a0)
	subu	a2, t3
	b		1b
	addu	a0, t3	

2:
	bgtu	t2, a2, 3f
	nop
	sw		t1, 0(a0)
	sw		t1, 4(a0)
	sw		t1, 8(a0)
	sw		t1, 12(a0)	
	subu	a2, t2	
	b		2b	
	addu	a0, t2

3:	
	beqz	a2, done
	nop
4:
	subu	a2, t3	
	sb		t1, 0(a0)
	bnez	a2, 4b	 
	addu	a0, t3	
	 
done:	
	j		ra
	nop
	
	.set reorder
	.end	memset
