/*************************************************************
 * File: lib/cpdata.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	971231	Added ifdef for GHS
 */

#include "mips.h"

#define icache_indinv(r)	.word	(0xbc000000|((r)<<21))

/*
 * Copy data from ROM to RAM, used in ROM-based applications.
 */

	.globl cpdata
	.ent cpdata
cpdata: # copy .data to RAM
	# s0 = address to flush mips caches
	# src=ftext dst=eromtext stop=edata

	la		t0, cpdatahandler
	la		t1, ecpdatahandler
	la		t2, 0x80000000
		
1:	lw		t3, (t0)
	lw		t4, 4(t0)
	lw		v0, 8(t0)
	lw		v1, 12(t0)			
	icache_indinv(r_t2)
	sw		t3, (t2)
	sw		t4, 4(t2)
	sw		v0, 8(t2)
	sw		v1, 12(t2)			
	addu	t0, 16
	addu	t2, 16
	blt		t0, t1, 1b

	la	t0,ldata
	la	t2,edata
 	la	t1,ftext

	la	v0, 0x80000000
	j	v0
			
cpdatahandler:	
1:	lw		t3, (t0)
	lw		t4, 4(t0)
	lw		v0, 8(t0)
	lw		v1, 12(t0)			
	sw		t3, (t1)
	sw		t4, 4(t1)
	sw		v0, 8(t1)
	sw		v1, 12(t1)			
	addu	t0, 16
	addu	t1, 16
	blt		t1, t2, 1b

	j	ra
	nop
ecpdatahandler:		
	.end cpdata
