/*************************************************************
 * File: pmon/mips.s
 * Purpose: startup code for PMON
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	970313	changed jal to jalr for EPI tools
 *	970530	Changed DCACHEI to DCACHE. Could lose data on 4010.
 *	971212	Always copy handler to debug exception vector
 *	980203	Restored 64008 ifdef to reset_exception
 *	980703	Replaced hostInit(0) with cpuInit()
 */

/*
 *	The contents of this file are not copyrighted in any
 *	way, and may therefore be used without restriction.
 */

#include <pmon.h>

/*
 * If you are new to MIPS assembly language programming, you will find
 * the following texts useful:
 *
 * "MIPS Risc Architecture", by Jerry Kane, published by Prentice Hall,
 *  ISBN 0-13-584749-4.
 *
 * "MIPS Programmer's Handbook", by Erin Farquhar and Philip Bunce,
 * published by Morgan Kaufmann, ISBN 1-55860-297-6.
 *
 */

	.text

reset_exception:
    la      k0,_romstart
	or      k0,K1BASE
	j       k0
	.align  8
#ifdef R4KEXCEPTIONS
	.align  9	/* bfc00200 Other general */
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0

	.align  7	/* bfc00280 XTLB refill */
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0

	.align  8	/* bfc00300 Cache error */
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0

	.align  7	/* bfc00380 Others (general) */
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0

	.align  10	/* bfc00400 */
	addu	zero,zero,zero
		
	.align  7	/* bfc00480 - Debug with probtrap - 0 in ECR */
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0

	.align  8	/* bfc00500 start of entry pt table */
#else

utlb_miss_exception:
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0
	.align 7

general_exception:
	la	k0,_exception
	li	k1,K1BASE
	or	k0,k1
	j	k0
	.align  10	/* bfc00400 */
	addu	zero,zero,zero

	.align  8	/* bfc00500 start of entry pt table */
#endif

/*************************************************************
*  util_routines:
*	table of entry address used by clients to access PMON's
*	internal routines. It's the main reason that PMON must
*	be built with "-G 0" (no gp addressing).
*	This table starts at PROM base + 0x500
*/
	.globl util_routines
util_routines:
	.word	read		# 0
	.word	write		# 1
	.word	open		# 2
	.word	close		# 3
	.word	ioctl		# 4
	.word	printf		# 5
	.word	vsprintf	# 6
	.word	ttctl		# 7

	.word	cliexit		# 8
	.word	getMonEnv	# 9
	.word	onintr		# 10
	.word	flush_cache	# 11
	.word	_exception	# 12
#ifdef FPEM
	.word	_fpstatesz	# 13
#ifdef NEWFP
	.word	0		# 14
#else
	.word	_fpinit		# 14
#endif
	.word	_fpstate	# 15
	.word	cop1		# 16
#else
	.word	0			# 13
	.word	0			# 14
	.word	0			# 15
	.word	0			# 16
#endif
	.word	adr2symoff	# 17
	.word	sym2adr		# 18
	.word	getclkfreq	# 19
	.word	_clkinit	# 20
	.word	scandevs	# 21
	.word	do_cmd		# 22
	.word	0:8		# spare

	.comm	uart_freq, 4

/*************************************************************
*  _romstart:
*	This is the entry point of the entire PROM Monitor
*/
	.globl _romstart
	.ent _romstart
_romstart:
	# force kSeg1 in case control is passed here from Kseg0
	la	t0,1f
	or	t0,K1BASE
	j	t0
	nop
  1:

	# set SR and CAUSE to something sensible
	.set noreorder
	.set noat
	mtc0	zero,$18	# C0_WATCHLO
	nop
	mtc0	zero,$19	# C0_WATCHHI
	nop
	li	v0,(SR_BEV|SR_IMASK|SR_EXL)
	nop
	mtc0	v0,C0_SR
	nop
	mtc0	zero,C0_CAUSE
	nop
	.set at
	.set reorder

	# Set up the CPU and enable the RAM. This routine figures out
	# what type of CPU this is and returns the address of the 
	# cache flushing routine in s0.
	# The rom version of the cache flushing routine is in s2.	
	jal	a5000rominit
	move	s1, v0   # save size of memory

	# initializes the instruction and data caches
	li      a0,DCACHEI
	or		s0,K1BASE
	or		s2,K1BASE
	jal     s2

	li		a0,ICACHEI
	jal		s2

	jal	cptext
	jal	clrbssrom

	li	a0, DCACHE
	jal	s2

	sw	k1, uart_freq	# Save UART frequency

	# force kSeg1
	la	t0, _start
	or	t0,K1BASE
	j	t0
	.end _romstart
