/*************************************************************
 * File: lib/sizemem.s
 *
 * The algorithm being used is as follows:
 * 1) change starting address from caller (a0)
 *    and verify we can change that location
 * 2) test address computed by adding the next power of 2 to a0,
 *    verify we can change that location, and verify we didn't
 *    change starting address location from caller
 * 3) return memory size we found
 *
 * Note: Following algorithm will not work if memory size is not a power of 2.
 */

#include <mips.h>

	.set noreorder

	.globl sizemem
	.ent sizemem
	sizemem: # a0 = start address, return size of memory starting at address
 	lui	v0,0xa000
 	or	a0,a0,v0		# insure address is not cached
 	lw	t0,0(a0)		# save contents at address
 	lui	t1,0xfeed
 	ori	t1,t1,0xface

 	sw	v0,0(a0)		# modify contents at address
 	lw	v1,0(a0)
 	bne	v1,v0,9f		# if failed to modify contents
 	move	a1,zero

 	sw	zero,0(a0)		# store zero
 	lw	v0,0(a0)
 	bnez	v0,9f		# if failed to modify contents
 	li	a3,0
	li	a1, 2	

	move	v1, a0	
 	lw	a2,0(v1)

3:						# beginning of loop testing addresses
 	sw	a2,0(v1)
 	slti	v0,a3,27
	sll		a1, 1	
 	beqz	v0,7f		# if end of loop -- tested maximum times
	addu	v1,a1, a0
 	lw	a2,0(v1)
 	sw	t1,0(v1)
 	lw	v0,0(a0)
 	beq	v0,t1,7f		# if memory wrapped
 	nop
 	lw	v0,0(v1)
 	beq	v0,t1,3b		# if read what we wrote -- loop testing addresses
 	addiu	a3,a3,1
7:
 	sw	a2,0(v1)		# restore modified addresses
 	sw	t0,0(a0)
9:
 	jr	ra
 	move	v0,a1
	.end sizemem
