/*************************************************************
 * File: pmon/mfrinfo.c
 * Purpose: Provide support for setting up Brecis' Manufacturing
 * 	    Information records from PMON command prompt
 * Author: Mike Cherba
 * Revision History:
 */

#include <termio.h>
#include <stdio.h>
#include <pmon.h>
#include <flashconfig.h>
#include <brecis.h>

extern unsigned char FLASH_CONFIG_ADDRESS;

int get_arg(char *arg);
int printkey(char *key);
int show_key(flashConfigValue *keyval, flashConfigLength keylen, int type);

Optdesc setup_opts[] = {
        {"[-u]","Display and Set the Manufacturing Info"},
        {"-u", "Set manufacturing info"},
        {0}};



/*************************************************************
*  setup:
*  This command Displays and current Manufacturing info 
*  and allows the user to modify it or add new records 
*/
setup(ac,av)
int ac;
Uchar *av[];
{
	int update, key_present, autoinc;
	flashConfigPtr *mfrinfo, *newflashConfig;
  	flashConfigValue *keyval;
	flashConfigLength keylen;
	int record, i, arglen, j, ports, found, inc;
	char *k;
	char buff[18];
	Ulong from, to, n;
	char mfrinbuff[200];
	char *bptr, *bbptr;
	unsigned int number[6];
	char last[6], current[6] ={0,0,0,0,0,0};
	unsigned long crc;
	int cac;
	char *cav[5];
	/*** DEV ID Variables **/
	int *devid_reg;


        /*****************************/
	/* Set up initial conditions */
        /*****************************/

	newflashConfig = (flashConfigPtr *) mfrinbuff;
	bptr = bbptr = (char *) &newflashConfig[1];
	autoinc=1;
	update = (av[1][0] == '-')  && (av[1][1] == 'u');
	mfrinfo = validateManufConfig(
		  (flashConfigPtr *) &FLASH_CONFIG_ADDRESS);
	if (mfrinfo==0) mfrinfo = (flashConfigPtr *)&FLASH_CONFIG_ADDRESS;

	ports = 3; /* this makes the highest keynumber that of MAC3 */
	from = 0x80040000;
	to =  0xbfc00000;
	n =  0x10000;

        /****************************************/
	/* prompt for number of MACS to enter   */
	/* otherwise stay with our default of 3 *
        /****************************************/

	if(update)
        {
		printf("Number of MACs [3]:");
		get_arg(buff);		
		sscanf(buff, "%x", &ports);
        }
		ports=ports+2;
	
        /***********************************/
	/* Show and Set MAC & IP Addresses */
        /***********************************/

	for (i=2; i <ports; i++)
	{

			
		/**********************/
		/* fill default value */
		/**********************/
		inc=1;
		key_present = !getFlashConfigValue(mfrinfo, i, &keyval, 
						   &keylen);
		if( autoinc && (i!=2) && update)
		{  
		    for (j=5; j>=0; j--)
		    {
			current[j] = last[j];
			if(inc) {current[j]++;}
			if (current[j] > last[j]) inc=0;	
		    }
		    key_present = 1;
		}
		else 
		{
		    for (j=5; j>=0; j--)
		    { current[j] = keyval[j]; }
	
		}


		/******************************************/
		/* Prompt and show MAC address if present */
		/******************************************/

		if (!update) { printf ("\n"); }
		if (update) { printf("Enter "); }
	    	printf("MAC%x address [", i-2);
	    	if(key_present){ printkey( current); }
	    	printf("]:  ");
		

		/*******************************/
		/* Fetch new address if needed */
		/*******************************/

		if(update)
		{
		    *bptr++ = i; /* save keyID */
		    *bptr++ = 6; /* save key Length */

		    get_arg(buff); 
		    	for (j=0; j <6; j++)
			    { number[j]=0;  }

		    found = sscanf(buff, "%x:%x:%x:%x:%x:%x", 
					&number[0], &number[1], &number[2], 
					&number[3], &number[4], &number[5]);


                    if (found == 0)   
                    { 
                        for (j=0; j <6; j++)
                        { 
			     *bptr++ = current[j]; 
			     last[j] = current[j];
			}
                    }
                    else if (found == 6)
                    {
                        for (j=0; j <6; j++) 
                        { 
			     *bptr++ = number[j];  
  			     last[j]= (char)number[j];
			}
                    }
		    else
		    {
			printf("Bad MAC Address\n");
			return (1);
		    }
	
	

		} /* end if(update) */


	} /* end for each port */
	

	printf("\n");




        /****************************************/
	/* Burn the new information into flash  */
        /****************************************/
	if(update)
	{
	        /***********************************/
		/* Prepare the new flashConfigPtr  */
	        /***********************************/
		newflashConfig->length = (signed short) ( bptr - bbptr); 
		newflashConfig->offset = (signed short)(sizeof(flashConfigPtr));

		/* Calculate CRC */
	        crc = crc32_payload_begin((unsigned char *) newflashConfig, 
				sizeof(signed short) + sizeof(signed short));
	        crc = crc32_payload_end(crc, (unsigned char *) bbptr, 
				bptr - bbptr);
	        newflashConfig->crc = crc;
		

	        /***************************************************/
		/* call the copy function to copy this into flash  */
	        /***************************************************/
		bcopy (0xbfc00000, 0x80040000, n);

		/* when copying in the new flashconfig info, make sure to 
		   pad by 8 to account for the portion of the structure that 
		   isn't records */
		bcopy (newflashConfig, 0x80040020, newflashConfig->length+8);
		printf ("Writing new Manufacturer Information to flash.\n");
		printf ("The first pass inserts the Manufacturing setup info");
		printf ("\nand the second replaces the PMON code around it.\n");

 		if (ports==2) writeSectorsFlash(current, &FLASH_CONFIG_ADDRESS,
						6, 0);
		else
		writeSectorsFlash(newflashConfig, &FLASH_CONFIG_ADDRESS,  
				  newflashConfig->length, 0);


		writeSectorsFlash(from, to, n, 1);

	} /* end flashConfigPtr Preparation */


	printf("\n");
	return (0);

} /* end of setup */







/******************************************
 * Get an argument entered in the console *
 ******************************************/
int get_arg(char *arg)
{
  int i;
  i=0;
  while( 0xa != (arg[i]=getchar()))
  {
    if ( (arg[i]==8) || (arg[i]==0x10) ) 
      {	arg[i]='\0'; i--; }
    i++;
    
  }
  arg[i] = '\0';

  return (i);
}

/*****************
 * Display a Key *
 *****************/
int printkey(char *key)
{
    int index;
    for (index=0; index < 6; index++)
    {
     	printf ("%02x", key[index]); 
	if (index!=5) { printf(":"); }
    }   
return(0);
}




