/*************************************************************
 * File: pmon/ping.c
 * Purpose: provide ping request capability for debugging purposes.
 */
#include <termio.h>
#include <pmon.h>

Optdesc ping_opts[] = {
	{"[-c count] [-i interval] [-s packetsize] [-v] [ethernet MAC] ip-destination",
	 "send ping request to hostport"},
	{"-c","count of patckets to send"},
	{"-i","delay interval between ping requests"},
	{"-s","packetsize for each packet"},
	{"-v","set verbose flag for debugging"},
	{0}};

extern int pingCount;
extern unsigned short pingLen;
extern Ulong pingAddress;
extern Ulong pingInterval;
extern Uchar pingDHost[6];

/*************************************************************
*  ping(ac,av)
*/
ping(ac,av)
int ac;
Uchar *av[];
{
struct termio tbuf;
char *hostport, *p;
int fd, i,j,ipi[4], n;
char *dhost;
char *address;

hostport = getMonEnv("hostport");

fd = open(hostport,0,0);
if (fd == -1) {
	printf("can't open %s\n",hostport);
	return;
	}

vflag = 0;

/* initialize ping request variables */
pingCount = 10;
pingLen = 56;
pingAddress = 0;
pingInterval = 1000000;
dhost = NULL;
address = NULL;

for (i=0;i<6;i++)
	pingDHost[i] = 0xff;

for (i=1;i<ac;i++) {
	if (av[i][0] == '-') {
		for (j=1;av[i][j];j++) {
			if (av[i][j] == 'v') vflag = 1;
			else if (av[i][j] == 'c') {
				if (av[i][j+1] != '\0' || ++i > ac) {
					printf("-c option requires count immediately following\n");
					return;
					}
				if (!atob(&n, av[i])) {
					printf("%s Bad count\n", av[i]);
					return;
					}
				pingCount = n;
				break;
				}
			else if (av[i][j] == 'i') {
				if (av[i][j+1] != '\0' || ++i > ac) {
					printf("-i option requires interval immediately following\n");
					return;
					}
				if (!atob(&n, av[i])) {
					printf("%s Bad count\n", av[i]);
					return;
					}
				pingInterval = n;
				break;
				}
			else if (av[i][j] == 's') {
				if (av[i][j+1] != '\0' || ++i > ac) {
					printf("-s option requires packetsize immediately following\n");
					return;
					}
				if (!atob(&n, av[i])) {
					printf("%s Bad packetsize\n", av[i]);
					return;
					}
				pingLen = n;
				break;
				}
			else printf("%c: unrecognized option\n",av[i][j]);
			}
		}
	else {
		if (address != NULL) {
			if (dhost != NULL) {
				printf("Too many arguments (%s, %s, %s)\n",
					   dhost, address, av[i]);
				return;
				}
			dhost = address;
			address = av[i];
			}
		else {
			address = av[i];
			}
		}
	}

/* convert the mac address string into an array of 6 bytes */
if (dhost != NULL) {
	for (i=0,p=strtok(dhost,":");p;p=strtok(0,":"),i++) {
		sscanf(p,"%x",&n);
		pingDHost[i] = n; 
		}
	}

if (address == NULL) {
	printf("No destination IP address specified\n");
	return;
	}

 

/* get our destination IP address */
sscanf(address,"%d.%d.%d.%d", &ipi[0],&ipi[1],&ipi[2],&ipi[3]);
pingAddress = ((ipi[0]<<24) | (ipi[1]<<16) | (ipi[2]<<8) | ipi[3]);
printf("Pinging %d.%d.%d.%d through interface %s with interval %d\n",
	   ipi[0], ipi[1], ipi[2], ipi[3], hostport, pingInterval);
printf("%d times with packet size %d to destination MAC %x:%x:%x:%x:%x:%x\n",
	   pingCount, pingLen,
	   pingDHost[0], pingDHost[1], pingDHost[2],
	   pingDHost[3], pingDHost[4], pingDHost[5]);

ether_ping(fd);
}





