/*************************************************************
 * File: pmon/ld.c
 * Purpose: load srec or elf format program.
 */

#include <termio.h>
#include <pmon.h>
#include <eload.h>

Optdesc ld_opts[] = {
  {"[-sbeS] addr", "load elf or srec"},
	{"-s","don't clear symbols"},
	{"-b","don't clear breakpoints"},
	{"-e","don't clear exception handlers"},
	{"-S","don't load symbols"},
  {0}};

/*************************************************************
 *  ld(ac,av)
 */
ld(ac,av)
int ac;
Uchar *av[];
{
Ulong addr;
Uchar *ptr,recbuf[MAXREC];
int count,flags,i,j,len,line,srecflag;

flags = 0;
count = 0;
for (i = 1; i < ac; i++) {
  if (av[i][0] == '-') {
	for (j=1;av[i][j];j++) {
	  if (av[i][j] == 's') flags |= DL_sFLAG;
	  else if (av[i][j] == 'b') flags |= DL_bFLAG;
	  else if (av[i][j] == 'e') flags |= DL_eFLAG;
	  else if (av[i][j] == 'S') flags |= DL_SFLAG;
	  else printf("%c: unrecognized option\n",av[i][j]);
	}
  }
  else {
	if (count == 0) if (sscanf(av[i], "%x", &addr) == 1) count++;
  }
}

if (count < 1) {
  printf("load address not specified\n");
  return;
}

/* address of program in srec or elf format */
ptr = (Uchar *) addr;

if (ptr[EI_MAG0] == ELFMAG0) srecflag = 0;
else if (*ptr == 'S') srecflag = 1;
else {
  printf("memory does not appear to be srec or elf format\n");	
  return;
}

line = 0;
addr = 0;

if (!(flags&DL_sFLAG)) clrsyms();
if (!(flags&DL_bFLAG)) clrbpt(-1);
if (!(flags&DL_eFLAG)) clrhndlrs();

while (1) {
  if (srecflag) {

	/* do srec record format */

	for (i = 0; i < MAXREC-1; i++)
	  if (isprint(*ptr)) 
		recbuf[i] = *ptr++;
	  else 
		break;

	ptr++;
	recbuf[i] = '\0';

	if (strempty(recbuf)) continue;

	line++;

	i = sload(recbuf, 0, &len, &flags);

	if (i < 0) {
	  printf("error %d on line %d\n", i, line);
	} else if (i == 0) break;					/* end of srecords */

  } else {

	/* do elf record format */

	i = eload(&ptr, &line,flags);

	if (i < 0) {
	  printf("error %d on record %d\n", i, line);
	  break;
	} else if (i == 0) break;					/* end of erecords */
  }
}

}

