/*************************************************************
 * File: pmon/ioctl.c
 * Purpose: Part of the Prom Monitor (PMON)
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <termio.h>
#include <pmon.h>


#define OPEN_MAX 8
static struct termio ttsave[OPEN_MAX];

/*************************************************************
*  ioctl_setup(fd)
*/
ioctl_setup(fd)
int fd;
{
if (ioctl(fd,TCGETA,&ttsave[fd]) == -1) {
	fprintf(stderr,"ioctl_setup: bad ioctl TCGETA on fd=%d\n",fd);
	}
}

/*************************************************************
*  ioctl_getsaved(fd,buf)
*/
ioctl_getsaved(fd,buf)
int fd;
struct termio *buf;
{
*buf = ttsave[fd];
}

/*************************************************************
*  ioctl_putsaved(fd,buf)
*/
ioctl_putsaved(fd,buf)
int fd;
struct termio *buf;
{
ttsave[fd] = *buf;
}

/*************************************************************
*  ioctl_restore(fd)
*/
ioctl_restore(fd)
int fd;
{
if (ioctl(fd,TCSETAF,&ttsave[fd]) == -1) {
	fprintf(stderr,"ioctl_restore: bad ioctl TCSETAF on fd=%d\n",fd);
	}
}

/*************************************************************
*  ioctl_cbreak(fd)
*	clear ICANON and ECHO
*/
ioctl_cbreak(fd)
int fd;
{
struct termio tbuf;

if (ttsave[fd].c_cflag==0) ioctl_setup(fd);

tbuf = ttsave[fd];
tbuf.c_lflag &= ~(ICANON|ECHO|ECHOE);
tbuf.c_cc[4] = 1; /* MIN */

if (ioctl(fd,TCSETAF,&tbuf) == -1) {
	fprintf(stderr,"ioctl_cbreak: bad ioctl TCSETAF on fd=%d\n",fd);
	}
}

/*************************************************************
*  ioctl_xvwlo(fd)
*/ 
ioctl_xvwlo(fd) 
int fd;
{ 
struct termio tbuf; 
 
if (ttsave[fd].c_cflag==0) ioctl_setup(fd);

tbuf = ttsave[fd];
tbuf.c_iflag &= ~IXOFF;
tbuf.c_lflag &= ~ECHO;
tbuf.c_iflag &= ~(ISTRIP|ICRNL);
tbuf.c_cc[2] = 0xff; /* turn off bs processing */
if (ioctl(fd,TCSETAF,&tbuf) == -1) {
	fprintf(stderr,"ioctl_xvwlo: bad ioctl TCSETAF on fd=%d\n",fd);
	}
ioctl(fd,TCSETAF,&tbuf);
}

/*************************************************************
*  ioctl_fionread(fd)
*/
ioctl_fionread(fd)
int fd;
{
int n;

ioctl(fd,FIONREAD,&n);
return(n);
}
