/*************************************************************
 * File: lib/clrbssrom.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	980107	Added ifdef for GHS
 */

#include "mips.h"
#include <brecis.h>

#define icache_indinv(r)	.word	(0xbc000000|((r)<<21))

/*
 * Clear the .bss section as required by C language.
 */

	.globl clrbssrom
	.ent clrbssrom
clrbssrom:	# clear the bss area
		
	la		t0, clrbssromhandler
	la		t1, eclrbssromhandler
	la		t2, 0x80000000
		
1:	lw		t3, (t0)
	lw		t4, 4(t0)
	lw		v0, 8(t0)
	lw		v1, 12(t0)			
	icache_indinv(r_t2)
	sw		t3, (t2)
	sw		t4, 4(t2)
	sw		v0, 8(t2)
	sw		v1, 12(t2)			
	addu	t0, 16
	addu	t2, 16
	blt		t0, t1, 1b

	.set push
	.set mips3
	sync
	.set pop
	ld		v0, MEM_CNFG_REG	/* force memory controller to finish writes */

	la	v0,_fbss
	la	v1,BSS_END

	la	t1, 0x80000000
	j	t1
clrbssromhandler:
1:		
	sw	zero,0x0(v0)
	sw	zero,0x4(v0)
	sw	zero,0x8(v0)
	sw	zero,0xc(v0)
	addu	v0,16
	blt	v0,v1,1b
	j	ra
eclrbssromhandler:	
	.end clrbssrom
