/*************************************************************
 * File: mon/modify.c
 * Purpose: Part of core Monitor. This module implements the 'm' command.
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	970822	Permit ESC to be used to exit interactive mode
 *	980816	Changed gets to GETS for imon95.
 *      990303  Fixed prob w sz being set by arg length
 */

#include <mon.h>

#ifdef PMCC
#define GETS(x) gets(x)
#endif

Optdesc m_opts[] = {
	{"[-bhw][adr [val|-s str]..]","modify memory"},
	{"-b","use byte write operations"},
	{"-h","use half-word write operations"},
	{"-w","use word write operations"},
	{"","size also determined by length of val"},
	{"-s str","write string to memory"},
	{"",""},
	{"hexval","set memory, forward one"},
	{"CR","forward one, no change"},
	{"=","re-read"},
	{"^|-","back one"},
	{".|ESC","quit"},
	{0}};

/*************************************************************
*  modify(ac,av)
*	The 'm' command. This command permits the user to modify
*	memory using byte, half-word, or word write operations.
*	It has two modes: interactive, and non-interactive.
*	Interactive mode is entered whenever no value was specified
*	on the command line.
*/
modify(ac,av)
int ac;
char *av[];
{
Ulong i;
char *p,line[20];
unsigned long v,a,adr;
int sz,flag;

if (!regChain) {
	printf("Target Description Driver not loaded\n");
	return(1);
	}

sz = 1;
i = matchenv("datasz");
switch (i) {
	case 0 : sz=1; break;
	case 1 : sz=2; break;
	case 2 : sz=4; break;
	default : 
		printf("%s: bad datasz value\n",getMonEnv("datasz"));
		return(1);
	}

flag = 0;
adr = 0;
for (i=1;i<ac;i++) {
        if (av[i][0] == '-') {
                if (av[i][1] == 'b') sz = 1;
                else if (av[i][1] == 'h') sz = 2;
                else if (av[i][1] == 'w') sz = 4;
                else if (av[i][1] == 's') {
                        i++;
                        if (i >= ac) {
                                printf("bad arg count\n");
                                return(1);
                                }
                        for (p=av[i];*p;p++) write_target(XT_MEM,adr++,*p,1);
                        flag = 1;
                        }
                else {
                        printf("%c: unknown option\n",av[i][1]);
                        return(1);
                        }
                }
        else {
                if(!get_rsa(&v,av[i])) return(1);
                if (!adr) adr = v;
                else {
                        flag = 1;
                        /* 990303 set sz from length of const value */
                        if (strlen(av[i]) > 4 && sz < 4) sz = 4;
                        else if (strlen(av[i]) > 2 && sz == 1) sz = 2;
                        switch (sz) {
                                case 1 : write_target(XT_MEM,adr,v,1); break;
                                case 2 : 
					if (adr&1) 
						printf("bad address align\n");
					else write_target(XT_MEM,adr,v,2); 
					break;
                                case 4 : 
					if (adr&3) 
						printf("bad address align\n");
					else write_target(XT_MEM,adr,v,4); 
					break;
                                }
			adr += sz; 
                        }
                }
        }
if (flag) return(0);

for (;;) {
	switch (sz) {
	    case 1 :
		printf("%08x %02x ",adr,read_target8(adr)&0xff);
		break;
	    case 2 :
		printf("%08x %04x ",adr,read_target16(adr)&0xffff);
		break;
	    case 4 :
		printf("%08x %08x ",adr,read_target32(adr));
		break;
		}
	GETS(line);
	for (p = line; *p == ' '; p++) ;
	if (*p == 0) adr += sz;
	else if (*p == '.' || *p == 033) break;
	else if (*p == '^' || *p == '-') adr -= sz;
	else if (*p == '=') ;
	else if (get_rsa(&v,p)) {
		switch (sz) {
			case 1 : write_target(XT_MEM,adr,v,1); break;
			case 2 : write_target(XT_MEM,adr,v,2); break;
			case 4 : write_target(XT_MEM,adr,v,4); break;
			}
		adr += sz;
		}
	}
return(0);
}
