/*************************************************************
 * File: lib/trap10a.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mips.h>
#include "trap10.h"

	.extern trap10state,4

	.globl	trap10
	.ent trap10
trap10:
	.set noat
	.set noreorder
#ifdef BSO_TASKING
	la	k0,trap10state
	lw	k0,(k0)
#else
	lw	k0,trap10state
#endif
	nop
#ifdef CYGNUS  /* my copy of the cygnus tools doesn't support .struct */
	addu	k0,trap10_Gpr
#else
	la	k0,trap10_Gpr(k0)
#endif
	sw	AT,S_AT*4(k0)		/* $1  (AT) */
	.set at
	sw	t0,S_T0*4(k0)		/* $8  (t0) */
	mfc0	t0,C0_EPC
	nop
	sw	t0,S_EPC*4(k0)		/* EPC */
	mfc0	t0,C0_CAUSE
	nop
	sw	t0,S_CAUSE*4(k0)	/* Cause */
	lw	t0,4(sp)
	addu	sp,8
	sw	t0,S_RTN*4(k0)		/* Return address */
	mfc0	t0,C0_SR
	nop
	sw	t0,S_STATUS*4(k0)	/* Status */
	srl	k0,t0,2			# move IEP to IEC
	and	k0,1			# ignore other bits
	or	t0,k0
	mtc0	t0,C0_SR
	.set reorder
	# ints restored

	lw	t0,trap10state
	la	t0,trap10_Gpr(t0)
	sw	v0,S_V0*4(t0)		/* $2  (v0) */
	sw	v1,S_V1*4(t0)		/* $3  (v1) */
	sw	a0,S_A0*4(t0)		/* $4  (a0) */
	sw	a1,S_A1*4(t0)		/* $5  (a1) */
	sw	a2,S_A2*4(t0)		/* $6  (a2) */
	sw	a3,S_A3*4(t0)		/* $7  (a3) */
	sw	t1,S_T1*4(t0)		/* $9  (t1) */
	sw	t2,S_T2*4(t0)		/* $10 (t2) */
	sw	t3,S_T3*4(t0)		/* $11 (t3) */
	sw	t4,S_T4*4(t0)		/* $12 (t4) */
	sw	t5,S_T5*4(t0)		/* $13 (t5) */
	sw	t6,S_T6*4(t0)		/* $14 (t6) */
	sw	t7,S_T7*4(t0)		/* $15 (t7) */
	sw	s0,S_S0*4(t0)		/* $16 (s0) */
	sw	s1,S_S1*4(t0)		/* $17 (s1) */
	sw	s2,S_S2*4(t0)		/* $18 (s2) */
	sw	s3,S_S3*4(t0)		/* $19 (s3) */
	sw	s4,S_S4*4(t0)		/* $20 (s4) */
	sw	s5,S_S5*4(t0)		/* $21 (s5) */
	sw	s6,S_S6*4(t0)		/* $22 (s6) */
	sw	s7,S_S7*4(t0)		/* $23 (s7) */
	sw	t8,S_T8*4(t0)		/* $24 (t8) */
	sw	t9,S_T9*4(t0)		/* $25 (t9) */
	sw	gp,S_GP*4(t0)		/* $28 (gp) */
	sw	sp,S_SP*4(t0)		/* $29 (sp) */
	sw	fp,S_FP*4(t0)		/* $30 (s8) */
	sw	ra,S_RA*4(t0)		/* $31 (ra) */
	# all regs now saved

	lw	a0,S_CAUSE*4(t0)	/* Cause */
	lw	a1,S_EPC*4(t0)		/* EPC */

	subu	sp,24			# alloc min framesz
	#li	t0,0xbe00003b
	#li	t1,0x40
	#sb	t1,(t0)		# grn off
	jal	_trap10		# return addr in v0
	#li	t0,0xbe00003b
	#li	t1,0x20
	#sb	t1,(t0)		# red off
	addu	sp,24			# dealloc frame

	lw	t0,trap10state
	la	t0,trap10_Gpr(t0)
	sw	v0,S_EPC*4(t0)		# save return addr

	lw	v0,S_V0*4(t0)		/* $2  (v0) */
	lw	v1,S_V1*4(t0)		/* $3  (v1) */
	lw	a0,S_A0*4(t0)		/* $4  (a0) */
	lw	a1,S_A1*4(t0)		/* $5  (a1) */
	lw	a2,S_A2*4(t0)		/* $6  (a2) */
	lw	a3,S_A3*4(t0)		/* $7  (a3) */
	lw	t1,S_T1*4(t0)		/* $9  (t1) */
	lw	t2,S_T2*4(t0)		/* $10 (t2) */
	lw	t3,S_T3*4(t0)		/* $11 (t3) */
	lw	t4,S_T4*4(t0)		/* $12 (t4) */
	lw	t5,S_T5*4(t0)		/* $13 (t5) */
	lw	t6,S_T6*4(t0)		/* $14 (t6) */
	lw	t7,S_T7*4(t0)		/* $15 (t7) */
	lw	s0,S_S0*4(t0)		/* $16 (s0) */
	lw	s1,S_S1*4(t0)		/* $17 (s1) */
	lw	s2,S_S2*4(t0)		/* $18 (s2) */
	lw	s3,S_S3*4(t0)		/* $19 (s3) */
	lw	s4,S_S4*4(t0)		/* $20 (s4) */
	lw	s5,S_S5*4(t0)		/* $21 (s5) */
	lw	s6,S_S6*4(t0)		/* $22 (s6) */
	lw	s7,S_S7*4(t0)		/* $23 (s7) */
	lw	t8,S_T8*4(t0)		/* $24 (t8) */
	lw	t9,S_T9*4(t0)		/* $25 (t9) */
	lw	fp,S_FP*4(t0)		/* $30 (s8) */
	lw	ra,S_RA*4(t0)		/* $31 (ra) */

	.set noreorder
	lw	t0,S_STATUS*4(t0)	/* Status */
	nop
	mtc0	t0,C0_SR
	nop
	nop
	# ints disabled

	lw	k0,trap10state
	nop
	la	k0,trap10_Gpr(k0)
	lw	t0,S_T0*4(k0)		/* $8  (t0) */
	.set noat
	lw	AT,S_AT*4(k0)		/* $1  (at) */
	lw	k0,S_EPC*4(k0)		/* EPC      */
	nop
	j	k0
	rfe
	.set at
	.set reorder
	.end trap10



/**********************************************************/
/*  a0 = number  unsigned int                             */
/*  a1 = divisor unsigned int                             */
/*  v0 = result of a0/a1                         	  */
/*  v1 = remainder of a0/a1                               */
/*                                                        */
/*  caller must deal with signs before calling and after  */
/*  returning.						  */
/**********************************************************/


	.globl div32u
	.ent div32u
div32u:
	bnez	a1,1f
	j	ra			#divide by 0 check

1:	bgeu	a0,a1,1f		#number greater than divisor
	sw	a0,(a2) 		#else remainder = number
	sw	zero,(a3)		# quotient = 0
	j	ra

1:	move	t1,a1
	li	t0,1	
	li	v0,0			#initialize quotient

	bltz	a1,4f			#if msb of divisor is set

	bgtz	a0,2f			#if msb of number not set
1:	sll	t1,1
	sll	t0,1			#msb of number was set
	bgtz	t1,1b			#so shift till msb of divisor*2^x is set
	bgtu	t1,a0,3f		#if we shifted too far back up
	b	4f

2:	sll	t1,1			
	sll	t0,1
	bleu	t1,a0,2b		#loop until divisor*2^x > number
					#then back up
3:	srl	t1,1
	srl	t0,1			
	bgtu	t1,a0,3b		#till divisor*2^x <= current number

4:	subu	a0,t1			#subtract divisor*2^x from number
	addu	v0,t0			#add 2^x to answer
	bgeu	a0,a1,3b		#loop if remainder > divisor		

	sw	a0,(a2)			# remainder
	sw	v0,(a3)

	j	ra
	.end div32u
