/*************************************************************
 * File: lib/time.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mips.h>

typedef int Func();
Func *_clkfunc,*_clkinit();

/*************************************************************
*  clkfunc args
*	1,v = set secs to v
*	2 = get secs
*	3 = get usecs
*/

/*************************************************************
*  long time(tloc)
*	Returns the current time in seconds
*/
long time(tloc)
long *tloc;
{
unsigned long t;

if (!_clkfunc) if (!(_clkfunc=_clkinit())) return(0);
t = (* _clkfunc)(2);
if (tloc) *tloc = t;
return(t);
}

/*************************************************************
*  int stime(tp)
*	Set the current time, tp is in seconds.
*/
int stime(tp)
long *tp;
{
if (!_clkfunc) if (!(_clkfunc=_clkinit())) return(0);
(* _clkfunc)(1,*tp);
return(0);
}

/*************************************************************
*  unsigned long clock()
*	Returns the current time in microseconds
*/
unsigned long clock()
{
if (!_clkfunc) if (!(_clkfunc=_clkinit())) return(0);
return((* _clkfunc)(3));
}

