# File: lib/target.mk
# Purpose: slave ""Makefile"" - builds one target directory at a time
# Author: Phil Bunce (pjb@carmel.com)
# Revision History:
#	970303	Fixed prob with vers.c etc..
#	970317	Added comments about the various crt's
#	970317	Moved *vers.o from OBJ

include $(LSIPKG)/defines.mk
include ../files.mk

ICEOBJS = k4101a.o ia4101.o ia4101-rom.o ic4101.o \
	k4011a.o ia4011.o ia4011-rom.o ic4011.o \
	k4102a.o ia4102.o ia4102-rom.o ic4102.o \
	k4011a-4k.o ia4011-4k.o ia4011-4k-rom.o ic4011-4k.o
# keep OBJS simple to make the dos conversion easier
OBJS = $(CFILES:.c=.o) $(ASFILES:.s=.o) irq4_a.o
OBJ = lib$(NMOD)c.a crt1$(NMOD).o crt0$(NMOD).o crtn$(NMOD).o \
	crt3.o crt2.o $(ICEOBJS) $(EXTRA_LIB_OBJS)

all : $(OBJ)
	@echo lib/$(ENDIAN) is now up to date

lib$(NMOD)c.a: $(OBJS) libvers.o ../rules.mk
	@$(RMF) lib$(NMOD)c.a
	$(AR) lib$(NMOD)c.a $(OBJS) libvers.o

clean:
	@$(RMFOBJS) $(OBJ) lib$(NMOD)c.a libvers.o

reduce:
	@$(RMFOBJS) libvers.o

vsprintf.o dbl2asci.o atod.o crt1$(NMOD).o crt0$(NMOD).o atof.o \
nvram.o sizemem.o termio.o sonic.o getmach.o cpuinit.o \
: $(LSIPKG)/include/defines.h

include ../rules.mk

# The MIPS tools require crt1 and crtn, the other toolsets expect crt0, or
# they don't care.
# NMOD is required to support the MIPS Sun-hosted tools. They name everything
# crt1r3000.o etc.
crt1$(NMOD).o : ../crt1.s
	$(CC) -c $(ASFLAGS) -o crt1$(NMOD).o ../crt1.s
crtn$(NMOD).o : ../crtn.s
	$(CC) -c $(ASFLAGS) -o crtn$(NMOD).o ../crtn.s
crt0$(NMOD).o : ../crt1.s
	$(CC) -c $(ASFLAGS) -o crt0$(NMOD).o ../crt1.s

# crt3 is for SerialICE drivers
crt3.o : ../crt3.s
	$(CC) -c $(ASFLAGS) -o crt3.o ../crt3.s

# This is to support r4k exceptions in a stand-alone environment.
irq4_a.o : ../irq_a.s
	$(CC) -c $(ASFLAGS) -DR4KEXCEPTIONS -o irq4_a.o ../irq_a.s

# This is required for the MIPS Sun-hosted toolset when you select the
# -mips2 switch.
lib$(NMOD)c_mips2.a : lib$(NMOD)c.a
	cp lib$(NMOD)c.a lib$(NMOD)c_mips2.a 

# required for $(CC) -c's 
crt2.o : ../crt2.s
	$(CC) -c $(ASFLAGS) -o crt2.o ../crt2.s

# required for $(CC) -c's -board option
k4101a.o : ../k4101.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -DRUN_APP -c -o $@ ../k4101.s
ia4101.o : ../ia4101.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -c -o $@ ../ia4101.s
ia4101-rom.o : ../ia4101.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -DROM_BASED -c -o $@ ../ia4101.s
ic4101.o : ../ic4101.c
	$(CC) -c $(CFLAGS) $(TFLAG) -c -o $@ ../ic4101.c

k4011a.o : ../k4011.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -DRUN_APP -c -o $@ ../k4011.s
ia4011.o : ../ia4011.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -c -o $@ ../ia4011.s
ia4011-rom.o : ../ia4011.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -DROM_BASED -c -o $@ ../ia4011.s
ic4011.o : ../ic4011.c
	$(CC) -c $(CFLAGS) $(TFLAG) -c -o $@ ../ic4011.c
k4011a-4k.o : ../k4011.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -DRUN_APP -DR4KEXCEPTIONS -c -o $@ ../k4011.s
ia4011-4k.o : ../ia4011.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -DR4KEXCEPTIONS -c -o $@ ../ia4011.s
ia4011-4k-rom.o : ../ia4011.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -DROM_BASED -DR4KEXCEPTIONS -c -o $@ ../ia4011.s
ic4011-4k.o : ../ic4011.c
	$(CC) -c $(CFLAGS) $(TFLAG) -DR4KEXCEPTIONS -c -o $@ ../ic4011.c

k4102a.o : ../k4102.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -DRUN_APP -c -o $@ ../k4102.s
ia4102.o : ../ia4102.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -c -o $@ ../ia4102.s
ia4102-rom.o : ../ia4102.s
	$(CC) -c $(ASFLAGS) $(TFLAG) -DROM_BASED -c -o $@ ../ia4102.s
ic4102.o : ../ic4102.c
	$(CC) -c $(CFLAGS) $(TFLAG) -c -o $@ ../ic4102.c

# DO NOT DELETE THIS LINE -- make depend depends on it.
atob.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
cc2str.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
cc2str.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
dbl2asci.o: $(LSIPKG)/include/defines.h
getword.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
index.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
lseek.o: $(LSIPKG)/include/errno.h $(LSIPKG)/include/termio.h
lseek.o: $(LSIPKG)/include/unistd.h
printf.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
printf.o: $(LSIPKG)/include/varargs.h
queue.o: $(LSIPKG)/include/queue.h
rindex.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
sizemem.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
sizemem.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
sizemem.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
sizemem.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
sizemem.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
sizemem.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
sizemem.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
sizemem.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
sizemem.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
sizemem.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
sizemem.o: $(LSIPKG)/include/utypes.h
stdio.o: $(LSIPKG)/include/fcntl.h $(LSIPKG)/include/malloc.h
stdio.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
stdio.o: $(LSIPKG)/include/varargs.h
str2cc.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
str_fmt.o: $(LSIPKG)/include/strfmt.h $(LSIPKG)/include/string.h
str_fmt.o: $(LSIPKG)/include/string2.h
strbalp.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strbequ.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strcat.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strccat.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strchr.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strdchr.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strempty.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strequ.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strichr.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
striequ.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
stristr.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strlen.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strncat.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strncmp.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strncpy.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strnwrd.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strpat.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string2.h
strpat.o: $(LSIPKG)/include/utypes.h
strpbrk.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strposn.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strrchr.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strrpset.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strrset.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strset.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strstr.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strtok.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
strtoupp.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
termio.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
termio.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
termio.o: $(LSIPKG)/include/errno.h $(LSIPKG)/include/l9a0084.h
termio.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
termio.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
termio.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
termio.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
termio.o: $(LSIPKG)/include/lr4102.h $(LSIPKG)/include/lr64008.h
termio.o: $(LSIPKG)/include/lr64360.h $(LSIPKG)/include/lr64363.h
termio.o: $(LSIPKG)/include/lr64364.h $(LSIPKG)/include/lr64388.h
termio.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/queue.h
termio.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/termio.h
termio.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
terms.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/termio.h
terms.o: $(LSIPKG)/include/utypes.h
time.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
time.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
time.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
time.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
time.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
time.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
time.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
time.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
time.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
time.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
toupper.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
vsprintf.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/stdio.h
vsprintf.o: $(LSIPKG)/include/strfmt.h $(LSIPKG)/include/string.h
vsprintf.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
vsprintf.o: $(LSIPKG)/include/varargs.h
atod.o: $(LSIPKG)/include/defines.h
read.o: $(LSIPKG)/include/termio.h
calloc.o: $(LSIPKG)/include/malloc.h
atof.o: $(LSIPKG)/include/defines.h
atol.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
open.o: $(LSIPKG)/include/errno.h $(LSIPKG)/include/termio.h
close.o: $(LSIPKG)/include/termio.h
write.o: $(LSIPKG)/include/errno.h $(LSIPKG)/include/termio.h
atoi.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
ptty.o: $(LSIPKG)/include/terms.h
kbhit.o: $(LSIPKG)/include/termio.h
fileno.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
scanf.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
scanf.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
scanf.o: $(LSIPKG)/include/varargs.h
files.o: $(LSIPKG)/include/termio.h
feof.o: $(LSIPKG)/include/termio.h
signal.o: $(LSIPKG)/include/errno.h $(LSIPKG)/include/signal.h
signal.o: $(LSIPKG)/include/termio.h
filbuf.o: $(LSIPKG)/include/malloc.h $(LSIPKG)/include/stdio.h
filbuf.o: $(LSIPKG)/include/utypes.h
ungetc.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
nvram.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
nvram.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
nvram.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
nvram.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
nvram.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
nvram.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
nvram.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
nvram.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
nvram.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
nvram.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
nvram.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
nvram.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
nvram.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
nvram.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
nvram.o: $(LSIPKG)/include/utypes.h
getchar.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
putchar.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
puts.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
putc.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
fgets.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
fputs.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
fflush.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
sprintf.o: $(LSIPKG)/include/varargs.h
fprintf.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
fprintf.o: $(LSIPKG)/include/varargs.h
vfprintf.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
vfprintf.o: $(LSIPKG)/include/varargs.h
fwrite.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
fread.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
fseek.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
fclose.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
gets.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
fgetc.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/utypes.h
ps2drivr.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
ps2drivr.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
ps2drivr.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
ps2drivr.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
ps2drivr.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
ps2drivr.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
ps2drivr.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
ps2drivr.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
ps2drivr.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
ps2drivr.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
ps2drivr.o: $(LSIPKG)/include/screen.h $(LSIPKG)/include/string.h
ps2drivr.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/terms.h
ps2drivr.o: $(LSIPKG)/include/utypes.h
ioctl.o: $(LSIPKG)/include/termio.h
gputc.o: $(LSIPKG)/include/screen.h
iram.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
iram.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
iram.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
iram.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
iram.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
iram.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
iram.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
iram.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
iram.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
iram.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
iram.o: $(LSIPKG)/include/utypes.h
p8530.o: $(LSIPKG)/include/terms.h
fscanf.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
fscanf.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
fscanf.o: $(LSIPKG)/include/varargs.h
strtolow.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
tolower.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
creat.o: $(LSIPKG)/include/fcntl.h
codecpy.o: $(LSIPKG)/include/utypes.h
strnspc.o: $(LSIPKG)/include/string2.h
cpsupp.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
cpsupp.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
cpsupp.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
cpsupp.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
cpsupp.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
cpsupp.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
cpsupp.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
cpsupp.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
cpsupp.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
cpsupp.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
cpsupp.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
cpsupp.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
cpsupp.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
hostinit.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
hostinit.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
hostinit.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
hostinit.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
hostinit.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
hostinit.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
hostinit.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
hostinit.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
hostinit.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
hostinit.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
hostinit.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
hostinit.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
hostinit.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
c64363.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c64363.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c64363.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c64363.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c64363.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c64363.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c64363.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c64363.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c64363.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c64363.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c64363.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c64363.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c64363.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c64363.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c64363.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c64363.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
trap10.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
trap10.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
trap10.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
trap10.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
trap10.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
trap10.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
trap10.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
trap10.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
trap10.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
trap10.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
trap10.o: $(LSIPKG)/include/trap10.h $(LSIPKG)/include/utypes.h
sonic.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
sonic.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
sonic.o: $(LSIPKG)/include/ether.h $(LSIPKG)/include/l9a0084.h
sonic.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
sonic.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
sonic.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
sonic.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
sonic.o: $(LSIPKG)/include/lr4102.h $(LSIPKG)/include/lr64008.h
sonic.o: $(LSIPKG)/include/lr64360.h $(LSIPKG)/include/lr64363.h
sonic.o: $(LSIPKG)/include/lr64364.h $(LSIPKG)/include/lr64388.h
sonic.o: $(LSIPKG)/include/malloc.h $(LSIPKG)/include/mips.h
sonic.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
sonic.o: $(LSIPKG)/include/sonic.h $(LSIPKG)/include/stdio.h
sonic.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
sonic.o: $(LSIPKG)/include/termio.h $(LSIPKG)/include/utypes.h
c33000.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c33000.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c33000.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c33000.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c33000.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c33000.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c33000.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c33000.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c33000.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c33000.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c33000.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
c33000.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c33000.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c33000.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c33000.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c33020.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c33020.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c33020.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c33020.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c33020.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c33020.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c33020.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c33020.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c33020.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c33020.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c33020.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
c33020.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c33020.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c33020.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c33020.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c33050.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c33050.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c33050.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c33050.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c33050.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c33050.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c33050.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c33050.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c33050.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c33050.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c33050.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
c33050.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c33050.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c33050.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c33050.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c33300.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c33300.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c33300.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c33300.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c33300.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c33300.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c33300.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c33300.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c33300.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c33300.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c33300.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c33300.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c33300.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c33300.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c33300.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c33300.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c4001.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c4001.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c4001.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c4001.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c4001.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c4001.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c4001.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c4001.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c4001.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c4001.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c4001.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c4001.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c4001.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c4001.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c4001.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c4001.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c4010.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c4010.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c4010.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c4010.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c4010.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c4010.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c4010.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c4010.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c4010.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c4010.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c4010.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c4010.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c4010.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c4010.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c4010.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c4010.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c64360.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c64360.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c64360.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c64360.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c64360.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c64360.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c64360.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c64360.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c64360.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c64360.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c64360.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
c64360.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c64360.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c64360.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c64360.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
p8251.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
p8251.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
p8251.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
p8251.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
p8251.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
p8251.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
p8251.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
p8251.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
p8251.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
p8251.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
p8251.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c64008.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c64008.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c64008.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c64008.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c64008.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c64008.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c64008.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c64008.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c64008.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c64008.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c64008.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c64008.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c64008.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c64008.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c64008.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c64008.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c4003.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c4003.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c4003.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c4003.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c4003.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c4003.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c4003.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c4003.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c4003.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c4003.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c4003.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c4003.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c4003.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c4003.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c4003.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c4003.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
irq.o: $(LSIPKG)/include/utypes.h
c400x.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c400x.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c400x.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c400x.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c400x.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c400x.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c400x.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c400x.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c400x.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c400x.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c400x.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c400x.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c400x.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c400x.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c400x.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c400x.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c401x.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c401x.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c401x.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c401x.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c401x.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c401x.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c401x.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c401x.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c401x.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c401x.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c401x.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c401x.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c401x.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
c401x.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
c401x.o: $(LSIPKG)/include/utypes.h
c4011.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c4011.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c4011.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c4011.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c4011.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c4011.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c4011.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c4011.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c4011.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c4011.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c4011.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c4011.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c4011.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c4011.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c4011.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c4011.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c4101.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c4101.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c4101.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c4101.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c4101.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c4101.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c4101.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c4101.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c4101.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c4101.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c4101.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c4101.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c4101.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c4101.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c4101.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c4101.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
iceport.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
iceport.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
iceport.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
iceport.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
iceport.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
iceport.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
iceport.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
iceport.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
iceport.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
iceport.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
iceport.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
rstrstr.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
p16c552.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
p16c552.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
p16c552.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
p16c552.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
p16c552.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
p16c552.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
p16c552.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
p16c552.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
p16c552.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
p16c552.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
p16c552.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c4300.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c4300.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c4300.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c4300.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c4300.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c4300.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c4300.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c4300.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c4300.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c4300.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c4300.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c4300.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c4300.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c4300.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c4300.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c4300.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c90084.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c90084.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c90084.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c90084.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c90084.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c90084.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c90084.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c90084.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c90084.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c90084.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c90084.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c90084.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c90084.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c90084.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c90084.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c90084.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
p90084.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
p90084.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
p90084.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
p90084.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
p90084.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
p90084.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
p90084.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
p90084.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
p90084.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
p90084.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
p90084.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
c4102.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c4102.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c4102.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c4102.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c4102.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c4102.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c4102.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c4102.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c4102.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c4102.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c4102.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c4102.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c4102.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c4102.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c4102.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c4102.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
p16550.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
p16550.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
p16550.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
p16550.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
p16550.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
p16550.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
p16550.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
p16550.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
p16550.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
p16550.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
p16550.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
ether.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
ether.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
ether.o: $(LSIPKG)/include/ether.h $(LSIPKG)/include/l9a0084.h
ether.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
ether.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
ether.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
ether.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
ether.o: $(LSIPKG)/include/lr4102.h $(LSIPKG)/include/lr64008.h
ether.o: $(LSIPKG)/include/lr64360.h $(LSIPKG)/include/lr64363.h
ether.o: $(LSIPKG)/include/lr64364.h $(LSIPKG)/include/lr64388.h
ether.o: $(LSIPKG)/include/malloc.h $(LSIPKG)/include/mips.h
ether.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/queue.h
ether.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
ether.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
ether.o: $(LSIPKG)/include/termio.h $(LSIPKG)/include/utypes.h
vstrlen.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/stdio.h
vstrlen.o: $(LSIPKG)/include/strfmt.h $(LSIPKG)/include/string.h
vstrlen.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
vstrlen.o: $(LSIPKG)/include/varargs.h
am79970.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
am79970.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
am79970.o: $(LSIPKG)/include/ether.h $(LSIPKG)/include/l9a0084.h
am79970.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
am79970.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
am79970.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
am79970.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
am79970.o: $(LSIPKG)/include/lr4102.h $(LSIPKG)/include/lr64008.h
am79970.o: $(LSIPKG)/include/lr64360.h $(LSIPKG)/include/lr64363.h
am79970.o: $(LSIPKG)/include/lr64364.h $(LSIPKG)/include/lr64388.h
am79970.o: $(LSIPKG)/include/malloc.h $(LSIPKG)/include/mips.h
am79970.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
am79970.o: $(LSIPKG)/include/utypes.h
perror.o: $(LSIPKG)/include/errno.h $(LSIPKG)/include/stdio.h
perror.o: $(LSIPKG)/include/utypes.h
c64364.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c64364.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c64364.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c64364.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c64364.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c64364.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c64364.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c64364.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c64364.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c64364.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c64364.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c64364.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c64364.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c64364.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c64364.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c64364.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
p16550u.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/terms.h
c64388.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
c64388.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
c64388.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
c64388.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
c64388.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
c64388.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
c64388.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
c64388.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
c64388.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
c64388.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
c64388.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
c64388.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
c64388.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
c64388.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
c64388.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
c64388.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
p2681.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
p2681.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
p2681.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
p2681.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
p2681.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
p2681.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
p2681.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
p2681.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
p2681.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
p2681.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
p2681.o: $(LSIPKG)/include/terms.h $(LSIPKG)/include/utypes.h
ctime.o: $(LSIPKG)/include/time.h
tmr1.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
tmr1.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
tmr1.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
tmr1.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
tmr1.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
tmr1.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
tmr1.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
tmr1.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
tmr1.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
tmr1.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
tmr1.o: $(LSIPKG)/include/utypes.h
pmirq.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
pmirq.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
pmirq.o: $(LSIPKG)/include/irqvec.h $(LSIPKG)/include/l9a0084.h
pmirq.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
pmirq.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
pmirq.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
pmirq.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
pmirq.o: $(LSIPKG)/include/lr4102.h $(LSIPKG)/include/lr64008.h
pmirq.o: $(LSIPKG)/include/lr64360.h $(LSIPKG)/include/lr64363.h
pmirq.o: $(LSIPKG)/include/lr64364.h $(LSIPKG)/include/lr64388.h
pmirq.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/utypes.h
sairq.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
sairq.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
sairq.o: $(LSIPKG)/include/irqvec.h $(LSIPKG)/include/l9a0084.h
sairq.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
sairq.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
sairq.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
sairq.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
sairq.o: $(LSIPKG)/include/lr4102.h $(LSIPKG)/include/lr64008.h
sairq.o: $(LSIPKG)/include/lr64360.h $(LSIPKG)/include/lr64363.h
sairq.o: $(LSIPKG)/include/lr64364.h $(LSIPKG)/include/lr64388.h
sairq.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/utypes.h
irqvec.o: $(LSIPKG)/include/irqvec.h $(LSIPKG)/include/utypes.h
