/*************************************************************
 * File: lib/strpat.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <stdio.h>
#include <string2.h>

#ifndef MAXLN
#define MAXLN 400
#endif

#define BANCHOR		(0x80|'^')
#define EANCHOR		(0x80|'$')
#define strNcpy(x,y,z)	strncpy(x,y,z),(x)[z]=0

/************************************************************
*  int strpat(p,pat) 
*	return 1 if pat matches p, else 0; wildcards * and ? 
*/
int strpat(s1,s2)
unsigned char *s1,*s2;
{
unsigned char *p,*pat;
unsigned char *t,tmp[MAXLN];
unsigned char src1[MAXLN],src2[MAXLN];

if (!s1 || !s2) return(0);

p = src1; pat = src2;
*p++ = BANCHOR; while (*s1) *p++ = *s1++; *p++ = EANCHOR; *p = 0;
*pat++ = BANCHOR; while (*s2) *pat++ = *s2++; *pat++ = EANCHOR; *pat = 0;

p = src1; pat = src2;
for (;*p && *pat;) {
	if (*pat == '*') {
		pat++;
		for (t=pat;*t && *t != '*' && *t != '?';t++) ;
		strNcpy(tmp,pat,t-pat);
		pat = t;
		t = (unsigned char *)strposn(p,tmp);
		if (t == 0) return(0);
		p = t + strlen(tmp);
		}
	else if (*pat == '?'|| *pat == *p) { pat++; p++; }
	else return(0);
	}
if (!*p && !*pat) return(1);
if (!*p && *pat == '*' && !*(pat+1)) return(1);
return(0);
}

